/*

//debut de fichier
camera {
    location <00, 3.5, -1.5>
   direction <0, 0, 1.20711>
         sky <0, 1, 0>
          up <0, 1, 0>
       right <1.33333, 0, 0>
     look_at <0, 3, 0>
}

#default {
  pigment {rgb <1,1,1>}
 }
//creation d'une source de lumiere ponctuelle
light_source {
    0*x //POSITION de base
    color rgb 1 //COULEUR
    //fade_distance FADE_DISTANCE // attnuation de la lumire avec la distance
    // fade_power FADE_POWER 		// idem
    translate <-200, 4000, -200>// deplace  la lumiere
    }
#declare cm=1;
#declare m=cm*100; 
#declare hazard=seed(0); 
#declare Planche=
texture {
    pigment {
        bozo//gradient y
        color_map {
            [ 0.000 rgb <0.55, 0.32, 0.20> ] 
            [ 0.100 rgb <0.55, 0.32, 0.20> ] 
            [ 0.101 rgb <0.55, 0.35, 0.20> ] 
            [ 0.200 rgb <0.88, 0.60, 0.40> ] 
            [ 0.201 rgb <0.88, 0.60, 0.40> ] 
            [ 0.300 rgb <0.60, 0.30, 0.20> ] 
            [ 0.301 rgb <0.60, 0.30, 0.20> ] 
            [ 0.400 rgb <0.60, 0.30, 0.20> ] 
            [ 0.401 rgb <0.60, 0.30, 0.20> ] 
            [ 0.900 rgb <0.88, 0.60, 0.40> ] 
            [ 0.901 rgb <0.88, 0.60, 0.40> ] 
            [ 1.000 rgb <0.55, 0.32, 0.20> ] 
        }turbulence <.25,.2,.2>
    }
    scale 10
    scale <35,.125,1>
    scale .25
    translate rand(hazard)*500
}
*/



    
#declare attache_chevaux =
union {
cylinder {
  -10*y,  .9*m*y,  5
}
cylinder {
  -10*y,  .9*m*y,  5
  translate 2*m*x
}
difference {
cylinder {
  -50*x,  2.5*m*x,  7
  translate .9*m*y
}
box{
  <-6, -6, -6>  
  < 6,  0,  6>
  translate .9*m*y 
}
box{
  <-6, -6, -6>  
  < 6,  0,  6>
  translate .9*m*y 
  translate 2*m*x
}
}
texture {
    pigment {
        color rgb <0.525,0.333,0.055>
    }
    normal {
        bumps 0.3
    }
}
}


#macro poteau_attache (pos, rot)
union {
cylinder {
  -10*y,  1.1*m*y,  4.5
  texture {
    pigment {
        color rgb <0.525,0.333,0.055>
    }
    normal {
        bumps 0.3
    }
}
}
union {
torus
{
  7,
  1
  rotate 90*x
  translate -7*y
  rotate -rot*x
  translate 7*y
  translate <0,1*m,-6>
}
sphere
{
  <0, 0, 0>   1
  translate <0,1*m+4,-6>       
}
cylinder {
  0*z,  -6*z,  .4
  translate <0,1*m+4,0> 
}
texture {
    pigment {
        color rgb <1.000,0.655,0.259>
    }
    normal {
        bumps 0.3
    }
    finish {
        roughness 0.1
        specular 0.8
        brilliance 8
        diffuse 0.7
        ambient <0.300, 0.300, 0.300 >
    }
}
}
rotate rot*x
translate pos
}
#end

#declare mangeoire=
union {
box{
  <0, 0, 0>  
  < 5,  80,  5>
  texture {Planche rotate 90*z}
}
box{
  <0, 0, 0>  
  < 5,  80,  5>  
translate 75*z
texture {Planche rotate 90*z}
}
box{
  <0, 0, 0>  
  < 5,  80,  5>
    translate <145,0,0>
  texture {Planche rotate 90*z}
}
box{
  <0, 0, 0>  
  < 5,  80,  5>        
  translate <145,0,75>
  texture {Planche rotate 90*z}
}
box{
  <1, .5, 0>  
  < 1.485*m,  29.5,  4>        
  translate <0,10,-4>
    rotate 20*y
  rotate -6*z

  texture {Planche scale .8 translate 20}
}
box{
  <3.5, .5, 0>  
  < 1.47*m,  29.5,  4>        
  translate <0,40,-4>
    texture {Planche scale .8 translate 10}
}
box{
  <3, .5, 0>  
  < 1.47*m,  29.5,  4>        
  translate <0,10,80>
  texture {Planche scale .8 translate 12}
}
box{
  <2, .5, 0>  
  < 1.48*m,  29.5,  4>        
  translate <0,40,80>                    
  texture {Planche scale .8 translate 17}
}/*
box{
  <0, .5, 1>  
  < 4,  29.5,  79.5>        
  translate <-4,10,0>
  texture {Planche rotate 90*y scale .8 translate 17}
} */
box{
  <0, .5, 3>  
  < 4,  29.5,  78>        
  translate <-4,40,0>
  texture {Planche   rotate 90*y scale .8 translate 23}
}
box{
  <0, .5, 1>  
  < 4,  29.5,  79.5>
   translate <1.5*m,10,0>
   texture {Planche rotate 90*y scale .8 translate 32}
}
box{
  <0, .5, 0.3>  
  < 4,  29.5,  79>        
  translate <1.5*m,40,0>                              
  texture {Planche rotate 90*y scale .8 translate 72}
}
box{
  <0, 0, 0>  
  < 1.5*m,  4,  80>        
  translate <0,10,0>                              
  texture {Planche rotate 90*x scale .8 translate 72}
}
}



     
#declare Tonneau=
union {
difference {
sphere
{
  <0, 0, 0>   1
  scale <1,2,1>
//  texture {Planche translate rand(hazard)*10  rotate 90*z scale .25}
pigment{
		image_map {
			gif "ton.gif"
			map_type 2
		}
	}
}
union {
box{
  <-1, -1, -1>  
  < 1,  1,  1>
  translate 2.5*y  
}
box{
  <-1, -1, -1>  
  < 1,  1,  1>
  translate -2.5*y  
}
sphere
{
  <0, 0, 0>   .95
  scale <1,2,1>
}
#declare rot=0;
#while (rot<180)
torus
{
  1,
  0.03
  rotate 90*x
  scale <1,2,1>
  rotate rot*y
}
#declare rot=rot+30;
#end
//texture {Planche translate rand(hazard)*10  rotate 90*z scale .25 }
pigment{
		image_map {
			gif "ton.gif"
			map_type 2
		}
	}

}
}
union {
torus { .85, 0.05  translate 1*y}
torus { .825, 0.05  translate 1.06*y}
torus { .8, 0.05  translate 1.12*y}
torus { .85, 0.05  translate -1*y}
torus { .825, 0.05  translate -1.06*y}
torus { .8, 0.05  translate -1.12*y}
texture {
    pigment {
        color rgb <1.000,0.831,0.494>
    }
    finish {
        roughness 0.1
        specular 0.8
        brilliance 8
        reflection 0.15
        diffuse 0.7
        ambient <0.300, 0.300, 0.300 >
    }
}
}
translate 1.5*y
}




#declare buisson=
union {
#declare nb=0;
#while (nb<1000)
cylinder {
  -10*y,  10*y,  1
  translate rand(hazard)*50*x
  rotate rand(hazard)*360*z
  rotate rand(hazard)*360*y
  translate 50*y
texture {
    pigment {
        color rgb <1.000,0.769,0.220>
    }
    finish {
        ambient <0.100, 0.100, 0.100 >
        diffuse 0.600
        crand 0.000
    }
}
}
#declare nb=nb+1;
#end
}



#declare tonneau2 =
union {
object {Tonneau}

difference {
cylinder {
  2.9*y,  2.95*y,  .65
  //pigment {rgb <1,0,0>}
}
union {
cylinder {
  -1*x,  1*x,  .01
  //pigment {rgb <0,0,1>}
  translate 2.95*y
}
cylinder {
  -1*x,  1*x,  .01
  //pigment {rgb <0,0,1>}
  translate 2.95*y
  translate -.25*z
}
cylinder {
  -1*x,  1*x,  .01
  //pigment {rgb <0,0,1>}
  translate 2.95*y
  translate .25*z
}
}
texture {Planche translate rand(hazard)*10  rotate 90*x scale .25 }
}
}



