#version unofficial MegaPov 0.4;
 
global_settings
{
  ini_option "+QR"   

  radiosity {
    pretrace_start .1//0.08
    pretrace_end   0.02
     brightness 2 
     count 20
     recursion_limit 4
     }
  ambient_light .8
   assumed_gamma 2.2
} 


#declare cm=1;
#declare m=cm*100; 
#declare hazard=seed(0); 
//debut de fichier
camera {
    //location <0,2*m,-7*m> 
    location <-350, 180, -700>//ok
   direction <0, 0, 1.20711>
         sky <0, 1, 0>
          up <0, 1, 0>
       right <1.33333, 0, 0>
     //look_at <0, 1*m, -6*m>
     look_at <2000, 150, 500>//ok
}

#default {
  pigment {rgb <1,1,1>}
 }


// area light (creation d'ombre douce)
// ATTENTION : l'utilisation de cette source lumineuse augmente le temps de rendu
light_source {
    0*x //<POSITION> (on bouge apres)
    color rgb 10 //<COULEUR>
    area_light 
    <800,0,0> <0,0,800>//<AXIS1>, <AXIS2>, SIZE1, SIZE2
    40, 40 // nombre total de lumiere sur la grille (4x*4y = 16 lumieres)
    adaptive 0//ADAPTIVE 0,1,2,3...
    jitter //JITTER
    //FADE_DISTANCE // attnuation de la lumire avec la distance
    //FADE_POWER
    translate 1000000*y
    rotate <-1,0,-87>//-5,0,87
}



/*
//creation d'une source de lumiere ponctuelle
light_source {
    0*x //POSITION de base
    color rgb 10 //COULEUR
    //fade_distance FADE_DISTANCE // attnuation de la lumire avec la distance
    // fade_power FADE_POWER 		// idem
    //translate <-20000, 100*100, -20000>// deplace  la lumiere
    translate 1000000*y
    rotate <-1,0,-87>//-5,0,87
    }
    

//lum a detruire ???   

light_source {
    0*x //POSITION de base
    color rgb .2 shadowless //COULEUR
    //fade_distance FADE_DISTANCE // attnuation de la lumire avec la distance
    // fade_power FADE_POWER 		// idem
    translate <3500*m, 1800*m, -7000*m>// deplace  la lumiere
    }
*/    
light_source {
    0*x //POSITION de base
    color rgb <0.88, 0.60, 0.40>/4 shadowless //COULEUR
    //fade_distance FADE_DISTANCE // attnuation de la lumire avec la distance
    // fade_power FADE_POWER 		// idem
    translate <-350*m, 180*m, -700*m>// deplace  la lumiere
    }



sky_sphere {
	pigment {
        gradient y
        color_map {
            [ 0.000 rgb <1.000,0.663,0.184> ]//0.667,0.929,1.000 
            [ 0.100 rgb <0.000,0.204,0.580> ]//[ 0.100 rgb <0.263,0.431,0.502> ]//[ 0.100 rgb <0.000,0.204,0.580> ] 
            [ 0.250 rgb <0.039,0.000,0.329> ]
            [ 1.000 rgb <0.039,0.000,0.329> ] 
        }
    }
    pigment {
		gradient y
		color_map {
			//[0.000 0.002 color rgb <1.0, 0.2, 0.0> color rgb <1.0, 0.2, 0.0>]
			//[0.002 0.200 color rgb <0.8, 0.1, 0.0> color rgb <0.2, 0.2, 0.3>]
		[0 color rgb <1.0, 0.2, 0.0>]
		[0.001 color rgb <1,0.100,0>]
		[ 0.001 rgbf <1.000,1,1,1> ]//0.667,0.929,1.000 
                [ 1 rgbf <1.000,1,1,1> ] 
            //[ 0.300 rgb <0.039,0.000,0.329> ]
            //[ 1.000 rgb <0.039,0.000,0.329> ] 
        
		}
		scale 2
		translate -1 rotate <1,0,87>
	}
	
       
}

#declare Planche=
texture {
    pigment {
        bozo//gradient y
        color_map {
            [ 0.000 rgb <0.55, 0.32, 0.20> ] 
            [ 0.100 rgb <0.55, 0.32, 0.20> ] 
            [ 0.101 rgb <0.55, 0.35, 0.20> ] 
            [ 0.200 rgb <0.88, 0.60, 0.40> ] 
            [ 0.201 rgb <0.88, 0.60, 0.40> ] 
            [ 0.300 rgb <0.60, 0.30, 0.20> ] 
            [ 0.301 rgb <0.60, 0.30, 0.20> ] 
            [ 0.400 rgb <0.60, 0.30, 0.20> ] 
            [ 0.401 rgb <0.60, 0.30, 0.20> ] 
            [ 0.900 rgb <0.88, 0.60, 0.40> ] 
            [ 0.901 rgb <0.88, 0.60, 0.40> ] 
            [ 1.000 rgb <0.55, 0.32, 0.20> ] 
        }turbulence <.25,.2,.2>
    }
    scale 10
    scale <35,.125,1>
    scale .25
    translate rand(hazard)*500
}
#declare Planche1=
texture {
    pigment {
        bozo//gradient y
        color_map {
            [ 0.000 rgb <0.45, 0.22, 0.10> ] 
            [ 0.100 rgb <0.45, 0.22, 0.10> ] 
            [ 0.101 rgb <0.45, 0.25, 0.10> ] 
            [ 0.200 rgb <0.78, 0.50, 0.30> ] 
            [ 0.201 rgb <0.78, 0.50, 0.30> ] 
            [ 0.300 rgb <0.50, 0.20, 0.10> ] 
            [ 0.301 rgb <0.50, 0.20, 0.10> ] 
            [ 0.400 rgb <0.50, 0.20, 0.10> ] 
            [ 0.401 rgb <0.50, 0.20, 0.10> ] 
            [ 0.900 rgb <0.78, 0.50, 0.30> ] 
            [ 0.901 rgb <0.78, 0.50, 0.30> ] 
            [ 1.000 rgb <0.45, 0.22, 0.10> ] 
        }turbulence <.25,.2,.2>
    }
    scale 15
    scale <35,.125,1>
    scale .25
    translate rand(hazard)*700
}
#declare translucide_Glass =
material { 
texture {
    pigment {
        rgbf <1.000,1.000,1.000,0.95>
    }
    finish {
        specular 1
        roughness 0.001
        ambient 0
        diffuse 0
        reflection 0.1
    }
}
interior {
    ior 1.5
    caustics 1
    fade_power 1
    fade_distance 1
    }    
}     

//macro poutre_haute (largueur, hauteur)
#macro poutre_haute (largueur, hauteur)
box{
  <0, -10, -25>  
  < largueur,  0,  2>
  translate hauteur*y
  texture {Planche translate rand(hazard)} 
}
#declare ecart=largueur/6;
#declare tr=ecart;
#while (tr<largueur)
box{
  <-5, -25, -20>  
  < 5,  -5,  2>
  translate hauteur*y
  translate tr*x
  texture {Planche translate rand(hazard)} 
}
#declare tr=tr+ecart;
#end
#end
//fin poutre haute
//macro plancher
#macro plancher (largueur)
#declare tr=0;
#while (tr<5*m)
box{
  < 0, 0, 0>  
  < largueur,  2,  49>
  translate <0,0,tr>
  texture {Planche translate rand(hazard) rotate <90,0,0>}  
}
#declare tr=tr+50;
#end
#end

//macro planche
#macro planche ( longueur, point_de_depart, hauteur_maximum, map)
#declare planche_object =
box{
  <0, 0, 0>  
  < longueur,  20,  4>
  translate -10*y
  rotate 10*x  
  translate 10*y
  translate point_de_depart
}
#declare tr=0;
#while (tr<hauteur_maximum-1)
//object {planche_object  translate tr*y texture {map translate rand(hazard)*500}}
box{
  <0, 0, 0>  
  < longueur,  20,  4>
  translate <-longueur/2,-10,-2>//translate -10*y
  rotate <9+(rand(hazard)*4),0,rand(hazard)/4>//rotate 10*x  
  translate <longueur/2,10,2>//translate 10*y
  translate point_de_depart
  translate tr*y texture {map translate rand(hazard)*500}
}





#declare tr = tr+20;
#end
#end
//fin de macro planche
//macro poteau
#macro poteau (poteau1,poteau2,poteau3,poteau4,hauteur,map)
box{
  <-5, 0, -5>  
  < 5,  hauteur,  5>  
translate poteau1
texture {map translate rand(hazard)*500 rotate 90*z}
}
box{
  <-5, 0, -5>  
  < 5,  hauteur,  5>  
translate poteau2
texture {map translate rand(hazard)*500 rotate 90*z}
}
box{
  <-5, 0, -5>  
  < 5,  hauteur,  5>  
translate poteau3
texture {map translate rand(hazard)*500 rotate 90*z}
}
box{
  <-5, 0, -5>  
  < 5,  hauteur,  5>  
translate poteau4
texture {map translate rand(hazard)*500 rotate 90*z}
}
#end
//fin macro poteau
//macro tour facade
#macro tour_facade (point_gauche,point_droit,hauteur,largueur)
box{
  <-7.5, 0, -7.5>  
  <7.5 , hauteur,  7.5>
  translate point_gauche*x
}
box{
  <-7.5, 0, -7.5>  
  <7.5 , hauteur,  7.5>
  translate point_droit*x
}

box{
  <point_gauche-7.5, -7.5, -27.5>  
  <point_droit+7.5 , 7.5,  7.5>
  translate hauteur*y
}

#local tr=point_gauche+40;
#while (tr<point_droit)
box{
  <-5, 0, -25>  
  <5 , 15,  7.5>
  translate <tr,(hauteur-22.7),0>
}
#declare tr=tr+80;
#end
#end
//fin de macro tour facade

//macro mur gauche
#macro mur_gauche (position_x,hauteur,profondeur)
#declare planche_object =
box{
  <0, 0, 0>  
  < profondeur,  20,  4>
  translate -10*y
  rotate 10*x
  translate 10*y
  rotate 90*y
  translate profondeur*z
  translate position_x*x   
}
#declare tr=0;
#while (tr<hauteur-1)
object {planche_object  translate tr*y}
#declare tr = tr+20;
#end
box{
  <-7.5, 0, -7.5>  
  < 7.5,  hauteur,  7.5>
  translate <position_x,0,profondeur>  
}
box{
  <-7.5, -7.5, 0>  
  < 7.5,  7.5,  profondeur>
  translate <position_x,hauteur,0>  
}

#end 
//fin murgauche
//macro mur droit
#macro mur_droit (position_x,hauteur,profondeur)
#declare planche_object =
box{
  <0, 0, 0>  
  < profondeur,  20,  4>
  translate -10*y
  rotate 10*x
  translate 10*y
  rotate -90*y
  //translate profondeur*z
  translate position_x*x   
}
#declare tr=0;
#while (tr<hauteur-1)
object {planche_object  translate tr*y}
#declare tr = tr+20;
#end
box{
  <-7.5, 0, -7.5>  
  < 7.5,  hauteur,  7.5>
  translate <position_x,0,profondeur>  
}
box{
  <-7.5, -7.5, 0>  
  < 7.5,  7.5,  profondeur>
  translate <position_x,hauteur,0>  
}
#end 
//fin mur droit
//macro mur du fond
#macro mur_du_fond (position_x, hauteur, largueur, profondeur)
#declare planche_object =
box{
  <0, 0, 0>  
  < largueur,  20,  4>
  translate -10*y
  rotate -10*x
  translate 10*y
  translate <position_x,0,profondeur>   
}
#declare tr=0;
#while (tr<hauteur-1)
object {planche_object  translate tr*y}
#declare tr = tr+20;
#end
#end
//fin mur du fond
//fenetre dim 1*1m
#declare fenetre=
union {
box{
  <-4, -4, -3.5>  
  < 1*m+4,  1,  2.5>
  texture {Planche translate rand(hazard)*20 }  
}
box{
  <-4, 1*m-1, -3.5>  
  < 1*m+4,  1*m+4,  2.5>  
  texture {Planche translate rand(hazard)*20}
}
box{
  <-4, 1, -2.5>  
  < 1,  1*m-1,  2.5>
  texture {Planche translate rand(hazard)*20 rotate 90*z}  
}
box{
  <1*m-1, 1, -2.5>  
  < 1*m+4,  1*m-1,  2.5>  
  texture {Planche translate rand(hazard)*20 rotate 90*z}
}
box{
  <1, 49, -1>  
  < 1*m-1,  51,  1>  
  texture {Planche translate rand(hazard)*20 rotate 90*z}
}
box{
  <1, 1, -.5>  
  < 1*m-1,  49,  .5>  
  material {translucide_Glass}
}   
box{
  <1, 51, -.5>  
  < 1*m-1,  1*m-1,  .5>  
  material {translucide_Glass}
}
}//fin de fenetre
//porte
#macro creaporte (rot)
#declare porte=
union {
box{
  <-4, 0, -5>  
  < 1,  2*m-1,  5>  
texture {Planche translate rand(hazard)*10 rotate 90*z}
}
box{
  <69, 0, -5>  
  < 74,  2*m-1,  5>  
texture {Planche translate rand(hazard)*10 rotate 90*z}
}
box{
  <-5, 2*m-1, -10>  
  < 75,  2*m+5,  5>  
texture {Planche translate rand(hazard)*10}
}
difference {
box{
  <1.5, 2, -1>  
  < 73.5,  2*m-1.5,  1>  
texture {Planche translate rand(hazard)*500 }
}
box{
  <3.5, 30, -1.2>  
  < 71.5,  2*m-11,  0>  
texture {Planche translate rand(hazard)*20 rotate 90*z}
}
rotate rot*y
}
} #end//fin de porte


#declare facadepleine=
union { 
planche (5*m,<0,0,0>,3*m,Planche)
} 
#declare facadepleine1=
union { 
planche (5*m,<0,0,0>,3.2*m,Planche)
}
#declare facadepleine2=
union { 
planche (5*m,<0,0,0>,4.8*m,Planche)
}



#declare facade1=
union { 
//planche ( longueur, point_de_depart, hauteur_maximum)
planche (2*m,<0,0,0>,1*m,Planche)
planche (50,<2.7*m,0,0>,2*m,Planche)
planche (50,<0,1*m,0>,1*m,Planche) 
planche (50,<1.5*m,1*m,0>,1*m,Planche)
planche (3.2*m,<0,2*m,0>,1*m,Planche)
object {facadepleine rotate -90*y translate 3.2*m*x}
object {facadepleine rotate 90*y translate 5*m*z}
mur_du_fond (0, 3*m, 3.2*m, 5*m)
poteau (<0,0,0>,<3.2*m,0,0>,<0,0,5*m>,<3.2*m,0,5*m>,3*m,Planche)
//toit
box{  <0, -1, 0>    < 3.2*m,  0,  5*m>  translate 3*m*y texture {Planche}}
plancher (3.2*m)
poutre_haute (3.2*m, 3*m)
object {fenetre translate <50,1*m,0>}
creaporte (-15)
object {porte  translate 2*m*x}
}//fin facade1

#declare facade2=
union {
planche (2*m,<0,0,0>,1*m,Planche)
planche (2*m,<2.7*m,0,0>,1*m,Planche)
planche (50,<0,1*m,0>,1*m,Planche)
planche (50,<1.5*m,1*m,0>,1*m,Planche)
planche (50,<2.7*m,1*m,0>,1*m,Planche)
planche (50,<4.2*m,1*m,0>,1*m,Planche)
planche (4.7*m,<0,2*m,0>,1.2*m,Planche)
object {facadepleine1 rotate -90*y translate 4.7*m*x}
object {facadepleine1 rotate 90*y translate 5*m*z}
mur_du_fond (0, 3.2*m, 4.7*m, 5*m)
poteau (<0,0,0>,<4.7*m,0,0>,<0,0,5*m>,<4.7*m,0,5*m>,3.2*m,Planche)
//toit
box{
  <0, -1, 0>  
  < 4.7*m,  0,  5*m>  
translate 3.2*m*y
texture {Planche}
}
plancher (4.7*m)
poutre_haute (4.7*m, 3.2*m)
object {fenetre translate <50,1*m,0>}
object {fenetre translate <3.2*m,1*m,0>}
creaporte (-7)
object {porte  translate 2*m*x}
#include "objetc.pov"
object { pan_gs translate <1.5*m,2.05*m,0>}
object {pan_gsp rotate 90*y translate <1.75*m,2*m,0>}
}//fin facade2

#declare facade3=
union {
planche (2*m,<0,0,0>,2*m,Planche)
planche (3*m,<3.5*m,0,0>,.6*m,Planche)
planche (50,<3.5*m,.6*m,0>,1.4*m,Planche)
planche (50,<6*m,.6*m,0>,1.4*m,Planche)
planche (6.5*m,<0,2*m,0>,1*m,Planche)
object {facadepleine rotate -90*y translate 6.5*m*x}
object {facadepleine rotate 90*y translate 5*m*z}
mur_du_fond (0, 6*m, 6.5*m, 5*m)
poteau (<0,0,0>,<6.5*m,0,0>,<0,0,5*m>,<6.5*m,0,5*m>,3*m,Planche)
//toit
box{
  <0, -1, 0>  
  < 6.5*m,  0,  5*m>  
translate 3*m*y
texture {Planche}
}
plancher (6.5*m)
object { porte_saloon_gauche  translate <2*m,5,0>}
object { porte_saloon_droite  rotate 180*y translate <2*m,5,0> translate 1.5*m*x}   
object { grd_fenetre translate <4*m,60,0>}
}

#declare facade4=
union {
planche (50,<0,0,0>,2*m,Planche)
planche (3.5*m,<1.2*m,0,0>,1*m,Planche)
planche (50,<1.2*m,1*m,0>,1*m,Planche)
planche (50,<2.7*m,1*m,0>,1*m,Planche)
planche (50,<4.2*m,1*m,0>,1*m,Planche)
planche (4.7*m,<0,2*m,0>,1*m,Planche)
object {facadepleine rotate -90*y translate 4.7*m*x}
object {facadepleine rotate 90*y translate 5*m*z}
mur_du_fond (0, 3*m, 4.7*m, 5*m)
poteau (<0,0,0>,<4.7*m,0,0>,<0,0,5*m>,<4.7*m,0,5*m>,3*m,Planche)
//toit
box{
  <0, -1, 0>  
  < 4.7*m,  0,  5*m>  
translate 3*m*y
texture {Planche}
}
plancher (4.7*m)
poutre_haute (4.7*m, 3*m)
object {fenetre translate <1.7*m,1*m,0>}
object {fenetre translate <3.2*m,1*m,0>}
creaporte (-27)
object {porte translate 50*x}
}//fin de 4

#declare facade5=
union {
planche (5*m,<0,0,0>,2.6*m,Planche)
planche (2*m,<8*m,0,0>,2.6*m,Planche)
planche (10*m,<0,2.6*m,0>,2.2*m,Planche)
object {facadepleine2 rotate -90*y translate 10*m*x}
object {facadepleine2 rotate 90*y translate 5*m*z}
mur_du_fond (0, 5*m, 10*m, 5*m)
poteau (<0,0,0>,<10*m,0,0>,<0,0,5*m>,<10*m,0,5*m>,4.8*m,Planche)
poutre_haute (10*m, 4.8*m)
}

#declare facade6=
union {
planche (1*m,<0,0,0>,2*m,Planche)
planche (3.5*m,<1.7*m,0,0>,.6*m,Planche)
planche (50,<1.7*m,.6*m,0>,1.4*m,Planche)
planche (1*m,<4.2*m,.6*m,0>,1.4*m,Planche)
planche (5.2*m,<0,2*m,0>,1*m,Planche)
object {facadepleine rotate -90*y translate 5.2*m*x}
object {facadepleine rotate 90*y translate 5*m*z}
mur_du_fond (0, 3*m, 5.2*m, 5*m)
poteau (<0,0,0>,<5.2*m,0,0>,<0,0,5*m>,<5.2*m,0,5*m>,3*m,Planche)
//toit
box{
  <0, -1, 0>  
  < 5.2*m,  0,  5*m>  
translate 3*m*y
texture {Planche}
}
plancher (5.2*m)
poutre_haute (5.2*m, 3*m)
creaporte (-5)
object {porte translate 1*m*x}
}

#declare facade7=
union { 
planche (1*m,<0,0,0>,2*m,Planche)
planche (1*m,<1.7*m,0,0>,2*m,Planche)
planche (2.7*m,<0,2*m,0>,1*m,Planche)
object {facadepleine rotate -90*y translate 2.7*m*x}
object {facadepleine rotate 90*y translate 5*m*z}
mur_du_fond (0, 3*m, 2.7*m, 5*m)
poteau (<0,0,0>,<2.7*m,0,0>,<0,0,5*m>,<2.7*m,0,5*m>,3*m,Planche)
//toit
box{
  <0, -1, 0>  
  < 2.7*m,  0,  5*m>  
translate 3*m*y
texture {Planche}
}
plancher (2.7*m)
poutre_haute (2.7*m, 3*m)
creaporte (-20)
object {porte translate 1*m*x}
}

#declare facade3b=
union {
planche (6.5*m,<0,0,0>,1*m,Planche)
planche (50,<0,1*m,0>,1*m,Planche)
planche (50,<1.5*m,1*m,0>,1*m,Planche)
planche (50,<3*m,1*m,0>,1*m,Planche)
planche (50,<4.5*m,1*m,0>,1*m,Planche)
planche (50,<6*m,1*m,0>,1*m,Planche)
planche (6.5*m,<0,2*m,0>,1*m,Planche)
object {facadepleine rotate -90*y translate 6.5*m*x}
object {facadepleine rotate 90*y translate 5*m*z}
poteau (<0,0,0>,<6.5*m,0,0>,<0,0,5*m>,<6.5*m,0,5*m>,3*m,Planche)
//toit
box{
  <0, -1, 0>  
  < 6.5*m,  0,  5*m>  
translate 3*m*y
texture {Planche}
}
poutre_haute (6.5*m, 3*m)
object {fenetre translate <50,1*m,0>}
object {fenetre translate <2*m,1*m,0>}
object {fenetre translate <3.5*m,1*m,0>}
object {fenetre translate <5*m,1*m,0>}
object {hampe translate <6.25*m,1.75*m,0>}
}//fin facade3b

 













object {facade1 translate 22*y}
object {facade2 translate 3.3*m*x translate 22*y}
object {facade3 translate 8.1*m*x translate 22*y}
object {facade3b translate <8.1*m,3*m,0> translate 22*y}
object {facade4 translate 14.7*m*x translate 22*y}
object {facade5 translate 19.5*m*x} 
object {facade6 translate 29.6*m*x translate 22*y}
object {facade7 translate 34.9*m*x translate 22*y}




//le trotoir

#declare tr=-60;
#while (tr<19.4*m)
box{
  < 0, 0, -2*m>  
  < 19.4,  2,  0>
  rotate rand(hazard)
  translate <tr,20,0>
  texture {Planche translate rand(hazard) rotate <90,90,0>}  
}
#declare tr=tr+20;
#end
box{
  <-60, -2, -5>  
  < 19.4*m,  10,  0>
  translate <0,8,-1.9*m>
  texture {Planche translate rand(hazard)*20 }  
}



#declare tr=29.4*m;
#while (tr<37.4*m)
box{
  < 0, 0, -2*m>  
  < 19,  2,  0>
  rotate rand(hazard)
  translate <tr,20,0>
  texture {Planche translate rand(hazard) rotate <90,90,0>}  
}
#declare tr=tr+20;
#end 
box{
  <0, -2, -5>  
  < 8*m,  10,  0>
  translate <0,8,-1.9*m>
  translate 29.4*m*x
  texture {Planche translate rand(hazard)*20 }  
}


//fin de trotoir

//l'avanc du sallon
//poteau

union {
box{
  <-5, 0, -5>  
  < 5, 3*m,  5>  
translate <0,0,-2*m>
texture {Planche rotate 90*z}
}
box{
  <-5, 0, -5>  
  < 5, 3*m,  5>  
translate <6.5*m,0,-2*m>
texture {Planche rotate 90*z}
}
//traverse
box{
  <10, 0, 0>  
  < 6.3*m,  20,  10>
  translate <0,2.8*m,-2*m>  
texture {Planche}
}
box{
  <0, 0, 0>  
  < 10,  20,  -1.9*m>
  translate 2.8*m*y
texture {Planche rotate 90*y}    
}
box{
  <0, 0, 0>  
  < 10,  20,  -1.9*m>
  translate <6.4*m,2.8*m,0>
texture {Planche rotate 90*y}    
}
#declare tr=10;
#while (tr<6.3*m)
box{
  <0, 0, 1>  
  < 62,  1,  -1.9*m>
  translate <tr,2.9*m,0>  
texture {Planche rotate 90*x rotate 90*y}
}
#declare tr=tr+63;
#end 
object {pan_saloon translate <1.3*m,3.05*m,-2.03*m>}
translate 8.1*m*x
} 

//la montagne
/*
#declare Myhf =
height_field {
	pattern 500, 500 {
		hf_gray_16
		leopard//bozo
		color_map {
			[ 0.000 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 1
			[ 0.100 rgbft <1.0, 0.5, 1.0, 0.0, 0.0> ]	//violet 2
			[ 0.214 rgbft <0.5, 0.5, 1.0, 0.0, 0.0> ]	//indigo
			[ 0.328 rgbft <0.2, 0.2, 1.0, 0.0, 0.0> ]	//blue
			[ 0.442 rgbft <0.2, 1.0, 1.0, 0.0, 0.0> ]	//cyan
			[ 0.556 rgbft <0.2, 1.0, 0.2, 0.0, 0.0> ]	//green
			[ 0.670 rgbft <1.0, 1.0, 0.2, 0.0, 0.0> ]	//yellow
			[ 0.784 rgbft <1.0, 0.5, 0.2, 0.0, 0.0> ]	//orange
			[ 0.900 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red1
			[ 1.000 rgbft <1.0, 0.2, 0.2, 0.0, 0.0> ]	//red2
		} 
		turbulence .5 
		//scale 1.75
		//translate <-1.1,0,-1.1>
		triangle_wave
		scale <0.3, 0.1, 0.3>
	}
	scale <2, 0.2, 2>
	smooth 
}

#declare cont=
difference {
cylinder {
  -10*y,  10*y,  10
pigment { rgb <0.9, 0.9, 0.9> 	}
}
cylinder {
  -20*y,  20*y,  .7
}
translate <-.1,0,0>
}


difference {
object {
	Myhf   
	pigment { rgb <1, 0, 0> 	}
	translate <-1.0, 0, -1.0>
}
object {cont}
scale <2000,4000,2000>
scale 20
translate <500*m,-80*m,100*m>
} */
//fin de montagne 

#declare Roche = texture {
   pigment {
     granite 
       color_map {
       [ 0.000  color rgb<0.588, 0.412, 0.310> ]
       [ 0.500  color rgb<0.584, 0.459, 0.388> ]
       [ 0.750  color rgb<0.361, 0.251, 0.200> ]
       [ 0.875  color rgb<0.361, 0.184, 0.145> ]
       [ 1.000  color rgb<0.922, 0.780, 0.620> ]
       }
       /*
       color_map {
            [ 0.000 rgb <0.459,1.000,0.212> ] 
            [ 0.500 rgb <0.718,1.000,0.588> ] 
            [ 1.000 rgb <0.769,1.000,0.663> ] 
     } */
     turbulence 0.950
   }/*
   normal {
		wrinkles 1.
		scale .0005
		turbulence 0.950
	}*/
   finish {
     diffuse 0.700
     ambient 0.300
    // specular 0.400
     //roughness 0.0100
   } scale .25

}
/*
#declare Fun0=function {x*0 + y*1 + z*0}//plan
#declare Pig1=function{pigment{leopard color_map{[0 rgb 1][1 rgb 0]} scale <1,1,1> turbulence .4 translate <1.5,0,1.5>}}

#declare montagne=

height_field { tga "map.tga"  water_level 0 smooth
        texture { Roche }
        //pigment {image_map { gif "map2.gif"} rotate 90*x}
       // bounded_by { box { <-0.51,-0.51,-0.51> <0.51,0.51,0.51> }}
        scale <288, 259, 143> //scale taille 
        translate <-288/2,0,-259/2 > scale <50,180,50> 
        
        //rotate <0,45,0>
    } 


isosurface {           
 function {Fun0 + Pig1*7}
           threshold .5    
           accuracy .1
           contained_by {sphere -3.0*y,3}//{<-2,-3,-2>,<2,0,2>}}
           sign 1
           max_gradient 1.1
           method 1
           texture { Roche }            
           //scale <1,2,1>
           translate 1.5*y
           scale <1,10,1>*3500
           //scale <50,180,50>
           }    
    
object {montagne translate <500*m,-80*m,100*m>}
object {montagne rotate 90*y translate <500*m,-80*m,120*m>}
object {montagne rotate 180*y translate <510*m,-80*m,140*m>}
object {montagne rotate 196*y translate <540*m,-80*m,170*m>}
object {montagne rotate 240*y translate <300*m,-80*m,200*m>}
object {montagne rotate 300*y translate <250*m,-80*m,250*m>}
object {montagne rotate 180*y translate <200*m,-80*m,260*m>}
*/

#include "cactus.pov"

object {cactus scale 10 rotate rand(hazard)*360*y translate <40*m,0,-3*m>}
object {cactus scale 10 rotate rand(hazard)*360*y translate <62*m,0,-5*m>}
object {cactus scale 10 rotate rand(hazard)*360*y translate <120*m,0,-10*m>}
object {cactus scale 10 rotate rand(hazard)*360*y translate <200*m,0,2*m>}
object {cactus scale 10 rotate rand(hazard)*360*y translate <180*m,0,5*m>}
object {cactus scale 10 rotate rand(hazard)*360*y translate <100*m,0,8*m>}



//le cot invisible
box{
  <0, 0, 0>  
  < 3.5*m,  3*m,  50>
  texture {Planche translate rand(hazard)*200}
  translate -15*m*z
}
box{
  <0, 0, 0>  
  < 4*m,  3.2*m,  50>
  texture {Planche translate rand(hazard)*200}
  translate -15*m*z
  translate 3.5*m*x
}

box{
  <0, 0, 0>  
  < 3*m,  3*m,  50>
  texture {Planche translate rand(hazard)*200}
  translate -15*m*z
  translate (3.5+4)*m*x
} 
box{
  <0, 0, 0>  
  < 10*m,  6*m,  50>
  texture {Planche translate rand(hazard)*200}
  translate -15*m*z
  translate (3.5+4+3)*m*x
} 
box{
  <0, 0, 0>  
  < 3*m,  3*m,  50>
  texture {Planche translate rand(hazard)*200}
  translate -15*m*z
  translate (10+3.5+4+3)*m*x
} 
box{
  <0, 0, 0>  
  < 10*m,  6*m,  50>
  texture {Planche translate rand(hazard)*200}
  translate -15*m*z
  translate (10+3+3.5+4+3)*m*x
} 
// les Tonneaux 
#include "objetd.pov"
object {Tonneau scale 30 translate <7*m,20,-.5*m>}
object {Tonneau scale 30 translate <22*m,0,-.5*m>}
object {Tonneau scale 30 translate <23*m,0,-1.5*m>}
object {Tonneau scale 30 rotate 90*x rotate 30*y translate <21.5*m,25,-2*m>}
object {Tonneau scale 30 rotate 90*x rotate -33*y translate <1*m,25,-3*m>}
object {tonneau2 scale 30 translate <0*m,0,-6*m>}
#include "serpent.pov"
object {serpent  scale 3  translate <0,.9*m,-6.0*m>}

object {buisson translate <7*m,0,-7*m>}
object {buisson rotate rand(hazard)*360*y  scale .75 translate <30*m,0,-5*m>}

object { attache_chevaux translate <12.5*m,0,-2.2*m>}
object { attache_chevaux rotate 30*y translate <28.5*m,0,-1.5*m>}

poteau_attache (<0,0,-2.1*m>, -2)
poteau_attache (<5*m,0,-2.1*m>, -4)
poteau_attache (<33*m,0,-2.1*m>, -14)



object {mangeoire translate <13.5*m,0,-3*m>}

#include "vautour.pov"
//object {vautour rotate 180*y scale 30  translate <2*m,3.2*m,-25>}
object {vautour rotate -90*y scale 30  translate <14.35*m,5*m,-.9*m>}

plane{
  y,  -.5
   texture {
    pigment {
        bozo
        color_map {
            [ 0.000 rgb <0.6875,0.5546875,0.40625> ] 
            [ 0.500 rgb <0.6640625,0.53515625,0.3984375> ] 
            [ 1.000 rgb <0.71484375,0.5859375,0.41796875> ]  
        }
    } scale 20
}
normal {bumps .2 scale <30,10,30>}  
}
 
#declare nb=0;
#while (nb<20)
box{
  <-75, -2, -10>  
  < 75,  2,  10>
  texture {Planche rotate 90*x translate rand(hazard)*10}
  rotate rand(hazard)*-30*x 
  rotate rand(hazard)*360*y  
  rotate rand(hazard)*10*z  
  translate <(rand(hazard)*40*m)+5*m,0,(rand(hazard)*-10*m)+4*m>
}
#declare nb=nb+1;
#end



#declare Fun0=function {x*0 + y*1 + z*0}//plan
#declare Pig1=function{pigment{bozo color_map{//{
            [0 rgb 1][1 rgb 0.5]} 
             scale 20
             }}
isosurface {           
 function {Fun0 + Pig1}
           threshold .5    
           accuracy .1
           contained_by {box {<-3*m,-3,-5000*m><20000*m,2,10*m>}}
           sign 1
           max_gradient 1.1
           method 1
           texture {
    pigment {  color rgb <0.6875,0.5546875,0.40625>} 
        
}translate 1*y
}  
