// Persistence of Vision Ray Tracer Scene Description File
// File: BuildingIM.pov
// Vers: 3.1
// Desc: Heightfield generator for buildings

#version 3.1;

#include "colors.inc"
#include "textures.inc"

global_settings
{
  assumed_gamma 1.0
}

#declare abw = seed(7) ;
 
camera
{
  location  <0.1, 2000, 100>
  direction 1.5*z
  look_at   <0.1, 0.1,0.1> 
  orthographic
}

plane { y, 0 pigment {color rgb <0.55,0.55,0.35>}finish {ambient 0.4}} 
 

#declare loop = 0; 

#while (loop <4500)       // loop to generate buildings imagemap

   #declare boxx = (2000 * rand(abw) - 1000);
   #declare boxz = (2000 * rand(abw) - 1000);

   #declare baseRGB = 0.4 + 0.4 * rand(abw);  

   box
   {
     <boxx, 0.01, boxz>     
     <boxx + 45 * rand(abw) +15, 0.01 ,  boxz + 45 * rand(abw) + 15 >  
     pigment {color rgb <baseRGB, baseRGB, baseRGB - 0.2 >}
     finish {ambient 0.8}
   }

   #declare loop = loop + 1;

#end    