//------------------------------------------------------------------------------
// Persistence of Vision Ray Tracer Scene Include File
// File: CityTex.inc
// Vers: 3.1g
// Desc: Textures for IRTC The City
// Date: 27/04/2000
// Auth: Tony Vrnjas
// Mail: tonyv@iafrica.com
//

//------------------------------------------------------------------------------
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"

//------------------------------------------------------------------------------
// Some random numbers for the textures
#declare ShackRand1 = seed(1234);
#declare ShackRand2 = seed(1538);
#declare ShackRand3 = seed(3446);
//------------------------------------------------------------------------------
#declare ShackTexture1 = 
texture {
  pigment { P_Silver5 }
}
texture {
  pigment {
    bozo
    turbulence 3
    colour_map {
      [0.00 colour Gray80]
      [0.30 colour Clear]
      [0.35 colour Gray60]
      [0.50 colour Clear]
      [0.60 colour Gray50]
      [0.90 colour Clear]
      [0.95 colour Gray70]
      [1.00 colour Clear]
    }
  }
  rotate <ShackRand1*90,ShackRand2*90,ShackRand3*90>
  translate <2-ShackRand1*4,2-ShackRand2*4,2-ShackRand3*4>
  scale <10,20,10>
}

//------------------------------------------------------------------------------
#declare ShackTexture2 = 
texture {
  pigment { P_Silver5 }
}
texture {
  pigment {
    bozo
    turbulence 1
    colour_map {
      [0.00 colour Gray80]
      [0.30 colour Clear]
      [0.35 colour Gray70]
      [0.50 colour Clear]
      [0.60 colour Gray60]
      [0.90 colour Clear]
      [0.95 colour Gray70]
      [1.00 colour Clear]
    }
  }
  rotate <ShackRand1*90,ShackRand2*90,ShackRand3*90>
  translate <2-ShackRand1*4,2-ShackRand2*4,2-ShackRand3*4>
  scale <10,20,10>
}
texture {
  pigment {
    wrinkles
    turbulence 0.3
    scale 0.3
    colour_map {
      [0.0 rgbf< 0.50, 0.25, 0.10, 0.85>]
      [1.0 rgbf< 0.65, 0.40, 0.00, 0.65>]
    }
  }
}

//------------------------------------------------------------------------------
#declare ShackTexture3 = 
texture {
  pigment { colour Khaki }
}
texture {
  pigment {
    bozo
    turbulence 3
    colour_map {
      [0.00 colour Gray70]
      [0.30 colour Clear]
      [0.35 colour Gray40]
      [0.50 colour Clear]
      [0.60 colour Gray50]
      [0.90 colour Clear]
      [0.95 colour Gray80]
      [1.00 colour Clear]
    }
  }
  rotate <ShackRand1*90,ShackRand2*90,ShackRand3*90>
  translate <2-ShackRand1*4,2-ShackRand2*4,2-ShackRand3*4>
  scale <4,10,2>
}

/*
//------------------------------------------------------------------------------
// Copy from textures.inc for comparison.
//
#declare T_Stone44 =
texture {
    pigment {
        granite
        colour_map {
            [0.0 rgb 0.3 ]
            [1.0 rgb 0.7 ]
        }
        scale 0.075
    }
    normal  { granite 0.75 scale 0.075 }
}
texture {
    pigment {
        wrinkles
        turbulence 0.3
        scale 0.3
        colour_map {
            [0.0 rgbf< 0.50, 0.25, 0.10, 0.85>]
            [1.0 rgbf< 0.65, 0.40, 0.00, 0.65>]
        }
    }
}
*/

//------------------------------------------------------------------------------
// Texture based on the standard T_Stone44
#declare KerbStone =
texture {
  pigment {
    granite
    colour_map {
      [0.3 rgb 0.5 ]
      [1.0 rgb 1.0 ]
    }
    scale 0.075
  }
  normal {
    granite 0.75 
    scale 0.075
  }
}
/*
texture {
  pigment {
    wrinkles
    turbulence 0.3
    scale 0.3
    colour_map {
      [0.0 rgbf< 0.50, 0.25, 0.10, 0.85>]
      [1.0 rgbf< 0.65, 0.40, 0.00, 0.65>]
    }
  }
}
*/

//------------------------------------------------------------------------------
// Texture based on the standard T_Stone44
#declare PavingStone =
texture {
  pigment {
    granite
    colour_map {
      [0.3 rgb 0.5 ]
      [1.0 rgb 1.0 ]
    }
    scale 0.075
  }
  normal {
    granite 0.75
    scale 0.075
  }
  scale 3.0
}
/*
texture {
  pigment {
    wrinkles
    turbulence 0.3
    scale 0.3
    colour_map {
      [0.0 rgbf< 0.50, 0.25, 0.10, 0.85>]
      [1.0 rgbf< 0.65, 0.40, 0.00, 0.65>]
    }
  }
}
*/

//------------------------------------------------------------------------------
// Texture based on the standard T_Stone44
#declare RoadSurface1 = 
texture {
  pigment {
    granite
    colour_map {
      [0.0 rgb 0.0 ]
      [1.0 rgb 0.6 ]
    }
    scale 0.075
  }
  normal {
    granite 0.75
    scale 0.075
  }
}
texture {
  pigment {
    wrinkles
    turbulence 0.3
    scale 0.3
    colour_map {
      [0.0 rgbf< 0.50, 0.25, 0.10, 0.85>]
      [1.0 rgbf< 0.65, 0.40, 0.00, 0.65>]
    }
  }
}

//------------------------------------------------------------------------------
// Texture based on the standard T_Stone44
#declare RoadSurface2 =
texture {
  pigment {
    granite
    colour_map {
      [0.0 rgb 0.0 ]
      [1.0 rgb 0.6 ]
    }
    scale 0.075
  }
  normal {
    granite 0.75
    scale 0.075
  }
}
texture {
  pigment {
    wrinkles
    turbulence 0.3
    scale 0.3
    colour_map {
      [0.0 rgbf< 0.10, 0.27, 0.33, 0.85>]
      [1.0 rgbf< 0.23, 0.25, 0.33, 0.65>]
    }
  }
}


//------------------------------------------------------------------------------
#declare RoadPaintWhite =
texture {
  pigment {
    granite
    turbulence 1.0
    colour_map {
      [0.0 colour Black filter 1]
      [0.3 colour White]
      [0.7 colour White]
      [1.0 colour Black filter 1]
    }
  }
  finish {
    specular 0.5
    roughness 0.5
  }
}

//------------------------------------------------------------------------------
#declare ShackWindow =
texture {
  pigment {
    granite
    turbulence 1.0
    colour_map {
      [0.0 colour White filter 1]
      [0.3 colour Khaki filter 0.9]
      [0.7 colour Khaki filter 0.9]
      [1.0 colour White filter 1]
    }
  }
}

//------------------------------------------------------------------------------
// Cool-drink can texture
#declare CanTextureRed = 
texture {
  Brushed_Aluminum
}
texture {
  pigment {
    gradient z
    colour_map {
      [0.0 colour White filter 1]
      [0.2 colour Red filter 0.7]
      [0.8 colour Red filter 0.7]
      [1.0 colour White filter 1]
    }
  }
}

//------------------------------------------------------------------------------
// Cool-drink can texture
#declare CanTextureBlue = 
texture {
  Brushed_Aluminum
}
texture {
  pigment {
    gradient z
    colour_map {
      [0.0 colour White filter 1]
      [0.2 colour Blue filter 0.7]
      [0.8 colour Blue filter 0.7]
      [1.0 colour White filter 1]
    }
  }
}

//------------------------------------------------------------------------------
// Cool-drink can texture
#declare CanTextureGreen = 
texture {
  Brushed_Aluminum
}
texture {
  pigment {
    gradient z
    colour_map {
      [0.0 colour White filter 1]
      [0.2 colour Green filter 0.7]
      [0.8 colour Green filter 0.7]
      [1.0 colour White filter 1]
    }
  }
}

//------------------------------------------------------------------------------
#declare LampPostTexture = 
texture {
  pigment {colour Gray50}
  finish {
    metallic
    specular 0.3
    reflection 0.08
  }
}

