camera{location<10,25,-60>look_at -10*z}//render camera

#declare Ant_Real_Tex=on;        //off makes the ant green so you can see it easier.

#include "Ant_City_Textures.inc" //all my textures and sizes fot the bricks, etc.

#declare RoadP       =on;        //Parse road on/off.
#declare BricksP     =on;        //Parse Brick Wall on/off.
#declare PavementP   =on;        //Parse Pavement on/off.
#declare GutterP     =on;        //Parse Gutter on/off. Speeds up the render time a fair bit.
#declare AntP        =on;        //Parse the ants.
#declare Light_Post_P=on;        //Parse the Light post. Off is just a normal light where it was during the testing.
#declare Fog_P       =on;        //Parse the fog on/off.
#declare Headlight_P =on;        //Parse the headlights on/off.
#declare Graffiti_P  =on;        //Parse the graffiti on/off.

#if (AntP=on)
#declare LegsOnly    =off;       //Parse the legs only (applies to all ants) on/off (off makes parsing MUCH quicker).
#end

#declare Addon=3; //higher makes the pavement wider

#if (BricksP=on)
//The brick Wall:
#debug "\n Parsing Bricks \n"
#include "Bricks.inc"
#declare Building_Height=40;
#declare Building_Length=100;
#declare Building_Depth=40;

#declare Building_Trans=40+Addon*2;
#declare Ground_Level=-2;

#declare Mortar_Depth=0.05125;
#declare Brick_Scale=2;

//bricks
box{<Building_Length,Building_Height,-Building_Depth><-Building_Length,Ground_Level,Building_Depth> texture{T_newBrick scale 0.5 scale Brick_Scale}translate Building_Trans*z}
//Mortar
box{<Building_Length,Building_Height,-Building_Depth+Building_Trans+Mortar_Depth><-Building_Length,Ground_Level,Building_Depth+Building_Trans+Mortar_Depth> pigment{color rgb 1}}
#end

#if (RoadP=on)
//Road:
#debug "\n Parsing Road \n"
#include "Road.inc"
#declare Line_Spacing=40;
#declare Line_End=100;
#declare Line_Length=1;
#declare Line_Width=5;
#declare Ground_Level=-2;
#declare Height_Above_Road=0.001;
#declare AllTrans=<10,0,-40>;

Road(Line_Spacing,Line_End,Line_Length,Line_Width,Ground_Level,Height_Above_Road,AllTrans,Tex_Road,Tex_Line)
#end

#if (PavementP=on)
//Pavement:
#debug "\n Parsing Pavement \n"
#include "Pavement.inc"

#declare Block_Width=8+Addon;
#declare Block_Length=10+Addon;
#declare Ground_Level=0;
#declare Height_Above=1;
#declare Max_Length=100;
#declare Whole_Trans=<0,-Height_Above,-Block_Width+Addon*2>;
#declare Little_Bit=3.75;

#declare Top_Roundness=0.25;
#declare Vertical_Roundness=0.01;

Pavement(Block_Length,Block_Width,Ground_Level,Height_Above,Pavement_Tex,Max_Length,Whole_Trans,Little_Bit,Top_Roundness,Vertical_Roundness)
#end

#if(GutterP=on)
//Gutter
#debug "\n Parsing Gutter \n"
#declare Steepness_Offset=0.25;
bicubic_patch { 
type 0 u_steps 4 v_steps 4 flatness 0.001
<-0.5,0,-0.5>,<0.5,0,-0.5>,<-0.5+Steepness_Offset,1,-0.5>,<0.5+Steepness_Offset,1,-0.5>,
<-0.5,0,   0>,<0.5,0,   0>,<-0.5+Steepness_Offset,1,   0>,<0.5+Steepness_Offset,1,    >,
<-0.5,0,   0>,<0.5,0,   0>,<-0.5+Steepness_Offset,1,   0>,<0.5+Steepness_Offset,1,    >,
<-0.5,0, 0.5>,<0.5,0, 0.5>,<-0.5+Steepness_Offset,1, 0.5>,<0.5+Steepness_Offset,1, 0.5> 
rotate -90*y scale <Block_Length*10,Height_Above*2,3> translate <0,-2,-17.5-Steepness_Offset>
texture{Pavement_Tex}}
#end

//ant
#declare Ant_Size=0.5;
#declare Ant_Trans=<18,4,-5>;
#declare Ant_Rot=<0,90,0>;

#if (AntP=on)
   #if(LegsOnly=off)
      #debug "\n Parsing the ant's Legs AND Body \n"
      #include "Ant_Body.inc"
      #include "Ant_Legs.inc"
      union{
      object{Legs rotate <-90,180,0>}
      object{Body material{Body_Tex}}
      scale Ant_Size
      rotate Ant_Rot
      translate Ant_Trans
      }
   #else
      #debug "\n Parsing the ant's Legs only \n"
      #include "Ant_Legs.inc"
      object{Legs rotate <-90,180,0>
      scale Ant_Size
      rotate Ant_Rot
      translate Ant_Trans
      }
   #end
#end

//lighting:
#declare Plus=0;
#if(Light_Post_P=on)
   #debug "\n Parsing Light Post \n"
   #declare Post_Size=<1,2,1>;
   #declare GrndLevel=-1;
   #declare Trans=<-20,0,-14-Plus>;
   #declare Rot=0;
   
   #declare Point_At=<0,0,-20-Plus>;
   #declare Radius=40;
   #declare Falloff=70;
   #declare Tightness=2.5;

   #include "Light_Post.inc"

   Light_Post_All(Post_Size,GrndLevel,Trans,Rot)
#else
   light_source{<70,500,-600>color rgb 0.1}
#end

light_source{<70,500,-600>color rgb 0.1 media_interaction on}

//Car Headlights:
#if(Headlight_P=on)
#debug "\n Parsing Headlights \n"
#include "Headlights.inc"
#declare Fuzzyness=5;
#declare Fade=0;
#declare INRad=15;
#declare OUTRad=22;
#declare Spacing=3;
#declare Position=<-40,7,-22>;
#declare Point_At=<0,0,-25>;

Headlights(HeadLight_Color,Fuzzyness,Fade,INRad,OUTRad,Position,Point_At)

#declare Position=<-40,7,-28-10>;
#declare Point_At=<0,0,-25>;

Headlights(HeadLight_Color,Fuzzyness,Fade,INRad,OUTRad,Position,Point_At)
#end

//Fog:
#if(Fog_P=on)
#debug "\n Parsing Fog \n"
media{
scattering{2 Fog_Thickness extinction 0.5}}
#end

#if (Graffiti_P=on)
#debug "\n Parsing Graffiti \n"
#declare GScale=<17,17,10>;
#declare GRot=<0,0,15>;
#declare GTrans=<0,15,11.8>;
#declare GTex=texture{pigment{color red 0.7}finish{ambient 1}}
#include "Graffiti.inc"
Graffiti(GScale,GTrans,GTex,GRot)
#end
