// Persistence of Vision Raytracer Version 3.1
//
// file: bgate.pov      author: -- jd --      version: 080400
//
// A Berlin Snapshot
// ...and sorry for the approximately Latin comments ;-)

#include "colors.inc"
#include "xcolors.inc"

#declare SlightlyDarkerKhaki = rgb <0.705, 0.68, 0.41>;
#declare DarkerKhaki = rgb <0.62, 0.6, 0.35>;
#declare SandStone = rgb <0.55, 0.50, 0.33>;
#declare DarkSandStone = rgb <0.36, 0.35, 0.2>;
#declare DarkUmbra = rgb <0.2, 0.18, 0.05>;
#declare PalerGreen = rgb <0.75, 1.0, 0.75>;
#declare PalestGreen = rgb <0.88, 1.0, 0.9>;

#include "textures.inc"
#include "metals.inc"
#include "stones.inc"
#include "skies.inc"

camera {
 // location  <32.75, 5, -24>         // final view
 // location  <0, 28, 0>              // a birds view
    location  <22.75, 0.03, -10.75>   // a bugs view   
    direction <0, 0, 1>
    up        <0, 1, 0>
    right   <4/3, 0, 0>
    look_at   <0, 13.5, 23>           // a bugs view
 // look_at   <4, 10.75, 25>          // final view
 // look_at   <0, 24, 25>             // a birds view
 // ultra_wide_angle
 // angle 210
}

light_source { 0*x color White  translate <70, 140, -1400> }
// light_source { 0*x color Tan translate <100, 50, 26> }

sky_sphere { S_Cloud3 }

fog { distance 1000.0 fog_type 2 fog_offset 0 fog_alt 20 color Gray80 }

box
{   // orbis terranum cubum est
    <-1000,0,-1000>, <1000,-2000,1000>
    pigment
    {
          granite
          color_map {
          [0.0 rgb <.2, .2, .2> ]
          [0.2 rgb <.5, .5, .5> ]
          [0.2 rgb <.4, .4, .4> ]
          [1.0 rgb <.4, .4, .4> ]
        }
        scale 0.5
    }
    normal { bumps 0.2 }
    finish { ambient .2 diffuse .3 }
}
union
{   // domi secundarii
    box { <40,0,10>, <70,20,-1> }
    box { <-40,0,10>, <-70,20,-1> }
    box { <70,0,-25>, <100,20,-50> }
    box { <-70,0,-25>, <-100,15,-50> }
    box { <-35,0,-80>, <-80,30,-120> } // adlon
    box  { <35,0,-400>, <70,15,-450> }
    box  { <-35,0,-420>, <-70,20,-470> }
    box  { <35,0,-500>, <70,20,-550> }
    box  { <-35,0,-500>, <-70,20,-550> }
    pigment { color Khaki }
}
union
{   // domi secundarii
    box { <30,0,-125>, <70,20,-200> }
    box { <-30,0,-125>, <-70,25,-200> }
    box { <30,0,-210>, <70,20,-290> }
    box { <-30,0,-210>, <-70,20,-290> }
    box { <35,0,-300>, <70,25,-400> }
    box { <-35,0,-300>, <-70,25,-400> }
    box { <30,0,-570>, <70,25,-680> }
    box { <-30,0,-570>, <-70,25,-680> }
    pigment { color Gray80 }
}

#include "tree.pov"

object
{   // arbor
    Tree scale <1.2,0.9,1.2>
    translate <32.875,0,63>
    pigment { VeryDarkBrown }
    normal  { bumps 0.5 scale 0.2 }
}
object
{   // arbor
    Tree scale <1.2,0.9,1.2>
    rotate y*135
    translate <33.225,0,60>
    pigment { DarkUmbra }
    normal  { bumps 0.5 scale 0.2 }
}
object
{   // arbor
    Tree scale <1.25,0.8,1.25>
    rotate y*15
    translate <-79.5,0,61>
    pigment { VeryDarkBrown }
}
object
{   // arbor
    Tree scale <1.2,0.9,1.2>
    rotate y*115
    translate <-78.66,0,59>
    pigment { VeryDarkBrown }
    // pigment { Red } finish  { ambient 1 }
}
object
{   // arbor
    Tree scale <1.2,0.9,1.2>
    rotate y*135
    translate <-71.1,0,61>
    pigment { DarkUmbra }
}
object
{   // arbor
    Tree scale <1.2,0.8,1.2>
    rotate y*-45
    translate <-71.5,0,60>
    pigment { VeryDarkBrown }
}

union
{   // tabula informationis
    union
    {
        union
        {
            box { <-0.5,0,0>, <0.5,-1.25,0.01> } 
            box { <-0.5,-0.5,0.05>, <-0.4,-1.5,0.0> } 
            box { <0.5,-0.5,0.05>, <0.4,-1.5,0.0> } 
   
            pigment { Snow }
        }
        object
        {
            box { <-0.5,0,0.00>, <0.5,-1.25,-0.005> pigment { color White } } 
            pigment
            {   image_map { png "bgate.png" }
                scale <1.4,1.4,1.4> translate <-0.725,-1.25,0>
            }
            normal { wrinkles 0.3 scale 0.1 }
        }

        rotate x*15
    }
    union
    {
        box { <-0.5,0,0>, <0.5,-1.25,-0.01> } 
        box { <-0.5,-0.5,-0.05>, <-0.4,-1.5,0.0> } 
        box { <0.5,-0.5,-0.05>, <0.4,-1.5,0.0> } 

        rotate x*-15
        pigment { Snow }
    }
    box { <-0.5,-0.75,-0.2>, <-0.51,-0.7,0.2> pigment { Silver } texture { T_Chrome_2A } } 
    box { < 0.5,-0.75,-0.2>, < 0.51,-0.7,0.2> pigment { Silver } texture { T_Chrome_2A } } 
   
    rotate y*-15
    translate <18.875,1.45,-8.5>
}

union
{   // fountain
    torus    { 5, 0.4 translate y*0.75 }
    cylinder { <0,0,0>, <0,0.5,0>, 5.25 }
    texture  { T_Stone30 }
    finish
    {   reflection 0.1 diffuse 0.1 roughness 0.001
        phong 1 phong_size 100
    }
}
object
{   // fountain sprinkler
    cylinder { <0,0,0>, <0,0.7,0>, 0.15 }
    pigment  { color Gray20 }
}
object
{   // remaining water
    cylinder { <0,0,0>, <0,0.66,0>, 5.2 }
    pigment  { color rgbf <0.5,0.5,0.6,0.8> }
    normal   { ripples 0.05 turbulence 0.3 }
    finish   { reflection 0.4 diffuse 0.3 }
}

#declare pillar =
union
{   box { <0.95, 0, 0.95>, <-0.95, 0.25, -0.95> } // basis // plinthe
    torus { 0.825, 0.125 translate y*0.375 }      // basis // torus 
    torus { 0.805, 0.05 translate y*0.55 }        // basis
    cylinder { <0,0.5,0>, <0,0.65,0> 0.8115 }     // basis
    difference
    {   // shaft + kannelures
        cone { <0, 0.6, 0>, 0.8, <0, 9.55, 0>, 0.65 }
        #declare i=0;
        #while (i<360)
        cone { <0.8, 0.8, 0>, 0.1, <0.65, 9.4, 0>, 0.075 rotate y*i }
        sphere { <0.8, 0.8, 0>, 0.1 rotate y*i }
        sphere { <0.65, 9.4, 0>, 0.075 rotate y*i }
        #declare i=i+15;
        #end
    }
    cylinder { <0, 9.525, 0>, <0, 9.55, 0>, 0.6875 }    // ~anuli
    cylinder { <0, 9.55, 0>, <0, 9.575, 0>, 0.7 }       // ~anuli
    cylinder { <0, 9.575, 0>, <0, 9.6, 0>, 0.7125 }     // ~anuli
    torus { 0.625, 0.125 translate y*9.725 }            // echinus
    box { <0.75, 9.85, 0.75>, <-0.75, 10.00, -0.75> }   // abakus
}

#declare triglyph =
difference
{
    box { <-0.2,0,-0.195>, <0.2,1.05,0.2> }
    box { <-0.3,-1,-0.3>, <0.3,1,0.15> }
    box { <-0.1,0.1,-0.3>, <-0.05,0.95,0.19> }
    box { <0.1,0.125,-0.3>, <0.05,0.975,0.19> }

    pigment { SlightlyDarkerKhaki }
}

#declare diglyph =
difference
{
    box { <-0.2,22.5,-0.2>, <0.2,23,0.2> }
    box { <-0.025,22.0,-0.25>, <0.025,24,0.25> }
    cylinder { <-0.25,22.5,-0.2>, <0.25,22.5,-0.2>, 0.35 }

    pigment { DarkKhaki }
}

#declare poller =
union
{   
    sphere
    {   <0,0,26>, 0.4
        pigment { Gray75 }
        normal { granite 0.4 scale 0.5 }
    }
    difference
    {   
        sphere
        {   <0,0,26>, 0.401
            pigment { LemonChiffon }
            normal { granite 0.2 scale 0.5 }
        }
        box  { <-1,0.15,25>, <1,1,27> pigment { Clear } }
    }
}

#declare no_trespassing =
union
{   // signum trafficum
    cylinder
    {
        <0,0,0>, <0,2.0,0>, 0.05
        pigment {
        gradient y
        color_map {
        [0.00 color Gray25 ]
        [0.20 color Gray60 ]
        [1.00 color Gray80 ]
        } scale <1,2,1> }
        translate z*0.05
    }
    cylinder { <0,2.0,0.1>, <0,2.0,0.105>, 0.4 pigment { Gray90 } }
    box { <0.2,1.5,0.1>, <-0.2,1.2,0.105> pigment { Gray90 } }
    difference
    {   
        cylinder { <0,2.0,0.105>, <0,2.0,0.106>, 0.38 }
        cylinder { <0,2.0,0.104>, <0,2.0,0.107>, 0.28 }
        pigment { Red }
    }
    normal { bumps 0.4 scale 0.125 }
    finish { ambient 0.25 }
}

#declare right_turn_only_no_right =
union
{   // signum trafficum
    cylinder
    {
        <0,0,0>, <0,2.75,0>, 0.05
        pigment {
        gradient y
        color_map {
        [0.00 color Gray25 ]
        [0.20 color Gray60 ]
        [1.00 color Gray80 ]
        } scale <1,2.25,1> }
        translate z*0.05
    }
    cylinder { <0,2,0.1>, <0,2,0.105>, 0.4 pigment { Gray90 } }
    cylinder { <0,2,0.105>, <0,2,0.106>, 0.38 pigment { Blue } }
    difference 
    { 
        cylinder { <0,2,0.105>, <0,2,0.107>, 0.2 }
        cylinder { <0,2,0.104>, <0,2,0.108>, 0.05 }
        box { <0.25,2,0.104>, <-0.25,1.75,0.108> }
        box { <-0.25,2.25,0.104>, <0,1.75,0.108> }
        pigment { White }
    }
    box { <0.2,1.75,0.104>, <0.05,2,0.107> pigment { White } }
    box { <0,2.2,0.104>, <-0.1,2.05,0.107> pigment { White } }
    triangle { <-0.1,2.3,0.107>, <-0.1,1.95,0.107>, <-0.25,2.125,0.107> pigment { White } }

    polygon
    {   4, <0, 2.4>, <0.5, 3.3>, <-0.5, 3.3>, <0, 2.4> translate z*0.101 pigment { White }
    }
    polygon
    { 8, <0, 2.35>, <0.48, 3.28>, <-0.48, 3.28>, <0, 2.35>,
         <0, 2.60>, <0.30, 3.18>, <-0.30, 3.18>, <0, 2.60> translate z*0.102 pigment { Red }
    }

    normal { bumps 0.4 scale 0.125 }
    finish { ambient 0.25 }
}

#declare right_only =
union
{   // signum trafficum
    cylinder
    {
        <0,0,0>, <0,0.75,0>, 0.05
        pigment {
        gradient y
        color_map {
        [0.00 color Gray25 ]
        [0.20 color Gray60 ]
        [1.00 color Gray80 ]
        } }
        translate z*0.05
    }
    cylinder { <0,0.5,0.1>, <0,0.5,0.105>, 0.4 pigment { Gray90 } }
    cylinder { <0,0.5,0.105>, <0,0.5,0.106>, 0.38 pigment { Blue } }
    box { <0.25,0.575,0.104>, <-0.1,0.425,0.107> pigment { White } }
    triangle  { <-0.1,0.675,0.107>, <-0.1,0.325,0.107>, <-0.25,0.5,0.107> pigment { White } }

    normal { bumps 0.4 scale 0.125 }
    finish { ambient 0.25 }
}

#declare vexilli =
union
{
    union
    {
        cylinder { <0,0,37>, <0,1.5,37> 0.33 }
        sphere { 0*x, 0.33 scale <1,0.5,1> translate <0,1.5,37> }
        pigment { Gray50 }    normal { granite 0.4 }
    }
    object
    {
        cone { <0,0,37>, 0.3, <0,23,37> 0.15 }    pigment { Gray90 }
    }
    object
    {
        sphere { 0*x, 0.3 scale <1,0.5,1> translate <0,23,37> }
        pigment { Silver }
        texture { T_Chrome_2D }
    }
}

#declare lantern =
union
{
    union
    {
        cylinder { <0,0,0>, <0,0.5,0>, 0.4 }
        sphere { <0,0,0>, 1 scale <0.5,0.1,0.5> translate y*0.6 }
        sphere { <0,0,0>, 1 scale <0.5,0.1,0.5> translate y*0.7 }
        cone   { <0,0.7,0>, 0.5, <0,0.9,0>, 0.4 }
        cone   { <0,0.9,0>, 0.4, <0,3.3,0>, 0.275 }
        sphere { <0,0,0>, 1 scale <0.33,0.05,0.33> translate y*3 }
        sphere { <0,0,0>, 1 scale <0.4,0.1,0.4> translate y*3.3 }
        torus  { 0.28, 0.05 translate y*3.45 }
        cone   { <0,3.5,0>, 0.3, <0,3.75,0>, 0.275 }
        sphere { <0,0,0>, 1 scale <0.33,0.1,0.33> translate y*3.75 }
        sphere { <0,0,0>, 1 scale <0.33,0.33,0.33> translate y*4 }
        cone   { <0,4.25,0>, 0.275, <0,4.9,0>, 0.25 }
        sphere { <0,0,0>, 1 scale <0.3,0.1,0.3> translate y*5 }
        cone   { <0,5,0>, 0.225, <0,6.5,0>, 0.2 }
        sphere { <0,0,0>, 1 scale <0.265,0.05,0.265> translate y*6.5 }
        sphere { <0,0,0>, 1 scale <0.3,0.2,0.3> translate y*6.7 }
        sphere { <0,0,0>, 1 scale <0.33,0.05,0.33> translate y*6.7 }
        sphere { <0,0,0>, 1 scale <0.265,0.05,0.265> translate y*6.9 }
        cone   { <0,6.9,0>, 0.2, <0,9,0>, 0.175 }
        sphere { <0,0,0>, 1 scale <0.25,0.05,0.25> translate y*9 }
        sphere { <0,0,0>, 1 scale <0.265,0.2,0.265> translate y*9.2 }
        sphere { <0,0,0>, 1 scale <0.275,0.05,0.275> translate y*9.2 }
        sphere { <0,0,0>, 1 scale <0.25,0.05,0.25> translate y*9.4 }
        cone   { <0,9.4,0>, 0.175, <0,11.5,0>, 0.15 }
        sphere { <0,0,0>, 1 scale <0.21,0.05,0.21> translate y*11.5 }
        sphere { <0,0,0>, 1 scale <0.225,0.2,0.225> translate y*11.7 }
        sphere { <0,0,0>, 1 scale <0.235,0.05,0.235> translate y*11.7 }
        sphere { <0,0,0>, 1 scale <0.21,0.05,0.21> translate y*11.9 }
        cone   { <0,11.9,0>, 0.15, <0,14.0,0>, 0.125 }
        sphere { <0,0,0>, 1 scale <0.185,0.05,0.185> translate y*14 }
        cone   { <0,14.0,0>, 0.125, <0,14.2,0>, 0.15 }
        torus  { 0.175, 0.05 translate y*14.2 }
        cone   { <0,14.2,0>, 0.15, <0,14.4,0>, 0.125 }
        sphere { <0,0,0>, 1 scale <0.185,0.05,0.185> translate y*14.4 }
        cone   { <0,14.4,0>, 0.125, <0,16,0>, 0.1 }
        sphere { <0,0,0>, 1 scale <0.25,0.25,0.25> translate y*15 }
        difference
        {
            torus { 1.5, 0.1 rotate x*90 translate y*16 translate x*1.5 }
            box   { <-2,16,-2>, <2,10,2> }
            box   { <1.5,18,-1>, <5,10,1> }
        }
        sphere { <0,0,0>, 1 scale <0.05,0.2,0.2> translate <1.5,17.5,0> }
        difference
        {
            torus { 1, 0.1 rotate x*90 translate y*16.5 translate x*1.5 }
            box   { <-3,16.5,-3>, <3,10,3> }
            box   { <1.5,18,-1>, <-5,10,1> }
        }
        difference
        {
            torus { 0.5, 0.1 rotate x*90 translate y*16.5 translate x*2 }
            box   { <-3,16.5,-3>, <3,18,3> }
            box   { <2,18,-1>, <-5,10,1> }
        }
        sphere { <0,0,0>, 1 scale 0.125 translate <2,16.125,0> }
        cylinder { <2,16.125,0>, <2,15.5,0>, 0.1 }
        cylinder { <2,15.5,0>, <2,15.4,0>, 0.01 }
        sphere { <0,0,0>, 1 scale 0.02 translate <2,15.4,0> }
        sphere { <0,0,0>, 1 scale 0.2 translate <2,15.61,0> }
        cylinder { <2,15.61,0>, <2,15.25,0>, 0.175 }
        sphere { <0,0,0>, 1 scale <0.2,0.05,0.225> translate <2,15.4,0> }
        sphere { <0,0,0>, 1 scale <0.175,0.0175,0.175> translate <2,15.125,0> }
        cylinder { <2,15.125,0>, <2,14.25,0>, 0.175 }
        sphere { <0,0,0>, 1 scale <0.2,0.05,0.225> translate <2,14.5,0> }
        sphere { <0,0,0>, 1 scale <0.2,0.05,0.225> translate <2,14.7,0> }
        sphere { <0,0,0>, 1 scale <0.4,0.1,0.4> translate <2,14.1,0> }
        cone { <2,14.25,0>, 0.175, <2,13.9,0>, 0.75 open }
        torus { 0.74, 0.01 translate <2,13.9,0> }
        cylinder { <2,12.65,0>, <2,12.75,0>, 0.050 }
        sphere { <2,12.725,0>, 0.030 }
        cone { <2,12.725,0>, 0.0250, <2,12.65,0>, 0.000001 }
        
        pigment { Brass }
        texture { T_Brass_1A }
        normal { bumps 0.25 scale 0.125 }
        finish { diffuse 0.3 }
    }
    difference
    {
        union
        {
            sphere { <0,0,0>, 1 scale <0.6,0.6,0.6> translate <2,13.5,0> }
            cone { <2,13.33,0>, 0.5, <2,12.7,0>, 0.00001 }
        }
        sphere { <0,0,0>, 1 scale <0.595,0.595,0.595> translate <2,13.5,0> }
        cylinder { <2,15,0>, <2,14,0>, 0.2 }
        cone { <2,13.30,0>, 0.5, <2,12.72,0>, 0.00001 }

        pigment { color rgbt <1,1,1,0.75> turbulence 0.2 }
        finish { reflection 0.1 phong 0.9 phong_size 80 diffuse 0.2 }
    }
    difference
    {
        sphere { <0,0,0>, 1 scale <0.595,0.595,0.595> translate <2,13.5,0> }
        sphere { <0,0,0>, 1 scale <0.594,0.594,0.594> translate <2,13.5,0> }
        box { <1,13.1,-1>, <3,12.5,1> }
        pigment { Silver }
        texture { T_Chrome_3C }
    }
    sphere
    {   <0,0,0>, 1
        scale <0.1,0.2,0.1> translate <2,13.7,0>
        pigment { OldLace }
    }
}

#declare i_sign =
union
{
    union
    {
        sphere { 0*x, 0.3 translate x*0.8 }
        sphere { 0*x, 0.3 translate x*-0.8 }
        cylinder { x*0.8, x*-0.8, 0.3 }
        scale <1,0.5,1>
        pigment { Gray40 }
        normal { bumps 0.4 scale 0.02 }
        finish { Dull }
    }
    union
    {
        cylinder { <0.75,0,0>, <0.75,2.5,0> 0.03 }
        cylinder { <-0.75,0,0>, <-0.75,2.5,0> 0.03 }
        box  { <0.75,0.5,-0.02>, <-0.75,2.5,0.02> }
        pigment {
        gradient y
        color_map {
        [0.00 color Gray25 ]
        [0.10 color Gray85 ]
        [1.00 color Gray95 ]
        } turbulence 0.25 scale <1,3,1> }
        normal { bumps 0.2 scale 0.25 }
        finish { Shiny ambient 0.25 }
    }
    difference
    {
        box { <-0.6, 0.6, -0.0255>, <0.6, 2.4, 0.0255> }
        box { <-0.7, 2.2, -0.0300>, <0, 2.5, 0.0300> }
        cylinder { <0, 2.0, -0.0300>, <0, 2.0, 0.0300>, 0.15 }
        box { <-0.3, 1.8, -0.0300>, <0.15, 1.7, 0.0300> }
        box { <-0.15, 1.7, -0.0300>, <0.15, 1.3, 0.0300> }
        box { <-0.3, 1.3, -0.0300>, <0.3, 1.2, 0.0300> }
        box { <-0.5, 1, -0.0300>, <0.6, 0.8, 0.0300> }
        difference
        {
            box { <-0.125,0.125,-0.0300>, <0.125,-0.125,0.0300> rotate z*45 }
            box { < 0,0.25,-0.0400>, <0.25,-0.25,0.0400> }
            translate <-0.4,0.9,0>
        }
        pigment { Tomato } // I love this color! Makes the sign looking pale.
        normal { bumps 0.2 scale 0.25 }
        finish { Shiny ambient 0.25 }
    }
    text { ttf "cyrvetic.ttf" "SOUVENIRS" 0.06, x*0.1 pigment { Tomato } scale <0.125,0.15,1> translate <-0.35,0.85,-0.03> }
}

object
{   // a flying flyer
    box { <0.25,0.05,0.1>,<-0.25,0.0501,-0.1> }
    rotate y*35
    translate <27,0,-9>
    pigment { Beige }
    normal { wrinkles 1 scale 0.1 }
    finish { ambient 0.25 }
}
union
{   // another flying flyer
    box { <0.25,0.05,0.0>,<-0.25,0.0501,0.2> }
    box { <0.25,-0.0001,0.0>,<-0.25,0.0001,0.2> rotate x*-155 translate y*0.05 }
    rotate y*67
    translate <32,0,-8>
    pigment { Beige }
    normal { wrinkles 1 scale 0.1 }
    finish { ambient 0.25 }
}
object
{   // yet another flying flyer
    box { <0.25,0.05,0.1>,<-0.25,0.0501,-0.1> }
    pigment
    {
        gradient x
        color_map {
        [0.00 color Blue ]
        [0.50 color Red  ]
        [0.70 color Red  ]
        [1.00 color Blue ]
        }
        turbulence 0.2
        scale <0.5,1,1>
    }
    normal  { bumps 1 scale 0.08 }
    rotate y*-48
    translate <27.5,0,-8>
    finish { ambient 0.25 }
}

#declare tincan =
union
{   // tin can
    difference
    {   cylinder { <0.125,0,0>,<-0.125,0,0>,0.075 }
        cylinder { <0.135,0,0>,<-0.135,0,0>,0.065 }
        torus { 0.075, 0.009 rotate z*90 translate <0.12,0,0> }
        torus { 0.075, 0.009 rotate z*90 translate <-0.12,0,0> }
        pigment
        {
            gradient z
            color_map {
            [0.00 color ForestGreen  ]
            [0.2499 color ForestGreen ]
            [0.25 color Gold ]
            [0.75 color  Gold ]
            [0.7501 color ForestGreen ]
            [1.00 color ForestGreen ]
            }
            // turbulence 0.01
            scale 0.25
        }
        normal { bumps 0.2 scale 0.02 }
        finish { Metallic_Finish }
    }
    difference
    {   cylinder { <0.1225,0,0>,<0.1200,0,0>, 0.065 }
        cylinder { <0.125,-0.035,0>,<0.115,-0.035,0>, 0.02 }
        pigment { Silver }
        normal { bumps 0.05 scale 0.01 }
        finish { Metallic_Finish }
    }
    difference
    {   cylinder { <0.12,0,0>,<-0.12,0,0>,0.065 }
        cylinder { <0.135,0,0>,<-0.135,0,0>,0.06 }
        pigment { Gray10 }
        normal { bumps 0.3 scale 0.02 }
        finish { Metallic_Finish }
    }
    union
    {   cylinder { <-0.1225,0,0>,<-0.1200,0,0>, 0.065 }
        cylinder { <0.1255,-0.015,0>,<0.125,-0.015,0>, 0.01 }
        torus { 0.02, 0.002 scale <1,0.25,1> rotate z*90 translate <0.12525,-0.005,0> }
        pigment { Silver }
        normal { bumps 0.05 scale 0.01 }
        finish { Metallic_Finish }
    }
    intersection
    {
        //  text { ttf "cyrvetic.ttf" "YEBISU" 1, 0
        difference
        {
            union
            {
                 text { ttf "cyrvetic.ttf" "YEBISU" 1, 0 translate <-0.025,0.0175,0> }
                 text { ttf "cyrvetic.ttf" "YEBISU" 1, 0 translate <0.025,0.0175,0> }
                 text { ttf "cyrvetic.ttf" "YEBISU" 1, 0 translate <-0.025,-0.03,0> }
                 text { ttf "cyrvetic.ttf" "YEBISU" 1, 0 translate <0.025,-0.03,0> }
            }
            text { ttf "cyrvetic.ttf" "YEBISU" 2, x*0.063
                   scale <0.9,0.95,1> translate <0.03,0.017,-0.5>
            }
            scale <0.048,0.048,1>
            translate <-0.08,-0.05,-0.08>
        }
        cylinder { <0.3,0,0>,<-0.3,0,0>,0.0751 }
        rotate x*40
        pigment { Black }
        normal { bumps 0.3 scale 0.02 }
        finish { Metallic_Finish }
    }
    intersection
    {
        text { ttf "timrom.ttf" "EXPORT" 0.1, 0 scale <0.025,0.025,1> translate <-0.05,-0.05,-0.08> }
        cylinder { <0.3,0,0>,<-0.3,0,0>,0.0751 }
        rotate x*15
        pigment { Black }
        normal { bumps 0.3 scale 0.02 }
        finish { Metallic_Finish }
    }
    intersection
    {
        text { ttf "timrom.ttf" "YEBISU Export" 0.1, 0 scale <0.015,0.015,1> translate <-0.05,-0.0075,-0.08> rotate z*-90 translate x*0.08}
        cylinder { <0.3,0,0>,<-0.3,0,0>,0.0751 }

        rotate x*90
        pigment { White }
        normal { bumps 0.3 scale 0.02 }
        finish { Metallic_Finish }
    }
    intersection
    {
        text { ttf "timrom.ttf" "Premium Quality" 0.1, 0 scale <0.0125,0.0125,1> translate <-0.05,-0.0075,-0.08> rotate z*-90 translate x*0.065 }
        cylinder { <0.3,0,0>,<-0.3,0,0>,0.0751 }

        rotate x*90
        pigment { Black }
        normal { bumps 0.3 scale 0.02 }
        finish { Metallic_Finish }
    }
    intersection
    {
        text { ttf "timrom.ttf" "All Malt Beer" 0.1, 0 scale <0.0125,0.0125,1> translate <-0.05,-0.0075,-0.08> rotate z*-90 translate x*0.0525 }
        cylinder { <0.3,0,0>,<-0.3,0,0>,0.0751 }

        rotate x*90
        pigment { Black }
        normal { bumps 0.3 scale 0.02 }
        finish { Metallic_Finish }
    }
    intersection
    {
        text { ttf "timrom.ttf" "Best Served Cold" 0.1, 0 scale <0.0125,0.0125,1> translate <-0.05,-0.0075,-0.08> rotate z*-90 translate x*0.04 }
        cylinder { <0.3,0,0>,<-0.3,0,0>,0.0751 }

        rotate x*90
        pigment { Black }
        normal { bumps 0.3 scale 0.02 }
        finish { Metallic_Finish }
    }
    intersection
    {
        text { ttf "timrom.ttf" "7.5% vol.     0.33l" 0.1, 0 scale <0.015,0.015,1> translate <-0.05,-0.0075,-0.08> rotate z*-90 translate x*-0.09 }
        cylinder { <0.3,0,0>,<-0.3,0,0>,0.0751 }

        rotate x*90
        pigment { White }
        normal { bumps 0.3 scale 0.02 }
        finish { Metallic_Finish }
    }
    intersection
    {
        text { ttf "timrom.ttf" "Product of Japan" 0.1, 0 scale <0.01,0.01,1> translate <-0.05,-0.0075,-0.08> rotate z*-90 translate x*-0.0725 }
        cylinder { <0.3,0,0>,<-0.3,0,0>,0.0751 }

        rotate x*90
        pigment { White }
        normal { bumps 0.3 scale 0.02 }
        finish { Metallic_Finish }
    }
    intersection
    {   sphere { 0*x, 0.015 translate <-0.07,-0.025,-0.08> }
        cylinder { <0.3,0,0>,<-0.3,0,0>,0.0751 }
        pigment { Navy }
        normal { bumps 0.3 scale 0.02 }
        finish { Metallic_Finish }
    }
    intersection
    {   sphere { 0*x, 0.015 translate <0.07,-0.025,-0.08> }
        cylinder { <0.3,0,0>,<-0.3,0,0>,0.0751 }
        pigment { VeryDarkBrown }
        normal { bumps 0.3 scale 0.02 }
        finish { Metallic_Finish }
    }
    intersection
    {   box { <0,0.1,0.04>,<-0.07,0,-0.04> }
        cylinder { <0.3,0,0>,<-0.3,0,0>,0.0751 }
        pigment { White }
        normal { bumps 0.3 scale 0.02 }
        finish { Metallic_Finish }
    }
    intersection
    {   // barcode
        box { <-0.0025,0.1,0.035>,<-0.06,0,-0.035> }
        cylinder { <0.3,0,0>,<-0.3,0,0>,0.07511 }
        pigment
        {   gradient x
            color_map {
            [0.0 color Clear ]
            [0.1999 color Clear ]
            [0.2 color Black ]
            [0.4 color Black ]
            [0.4001 color Clear ]
            [0.7 color Clear ]
            [0.7001 color Black ]
            [1.0 color Black ]
            }
            scale 0.006
        }
        normal { bumps 0.3 scale 0.02 }
        finish { Metallic_Finish }
    }
    // ...and here a small concentration test: please estimate the time
    // difference to model the two alternatives "union of intersections"
    // and "intersection of unions" for an anti-alialized 640x480 image
    // of the above object:
    //
    // a) no time difference
    // b) "intersection of unions" will save ca.  4 minutes
    // c) "intersection of unions" will save ca. 40 minutes
    // d) "union of intersections" will save ca.  4 minutes
    // e) "union of intersections" will save ca. 40 minutes
    //
    // ...the correct answer is e)
}

object { tincan translate <22.222,0.075,-10.275> }
object { tincan rotate z*90 rotate y*-50 translate <22.75,0.165,-9.75> }

union
{   // some orange plastic
    difference
    {
        box { <0.015,0.01,0.02>,<-0.03,0,-0.02> }
        box { <0.04,0.05,0.03>,<-0.0275,0.0025,-0.0175> }
        box { <0.04,0.10,0.03>,<-0.02, 0.00,-0.03> rotate x*45 rotate z*33 }
        rotate y*45
        translate <22.32,0,-10.45>
    }
    intersection
    {
        difference
        {
            sphere { 0*x, 0.1 }
            sphere { 0*x, 0.0975 }
            translate y*0.1
        }
        prism
        {   linear_sweep linear_spline 0,0.1
            5 <-0.02,0.03>, <0.03,0.02>, <0.01,-0.02>, <-0.03,-0.04>, <-0.02,0.03>
        }
        rotate y*90
        translate <22.57,0,-10.425>
    }
    intersection
    {
        difference
        {
            sphere { 0*x, 0.1 }
            sphere { 0*x, 0.0975 }
            translate y*0.1
        }
        prism
        {   linear_sweep linear_spline 0,0.1
            5 <0.02,-0.04>, <-0.01,0>, <-0.02,0.03>, <0.03,0.04>, <0.02,-0.04>
        }
        translate <22.0,0,-10.3125>
    }
    prism
    {   linear_sweep linear_spline 0,0.0025
        4 <0.02,-0.04>, <-0.01,0>, <0.03,0.02>, <0.02,-0.04>
        translate <22.55,0,-10.5>
    }
    prism
    {   linear_sweep linear_spline 0,0.0025
        4 <0.02,-0.04>, <-0.01,0>, <0.03,0.02>, <0.02,-0.04>
        rotate y*25
        translate <22.615,0,-10.55>
    }
    prism
    {   linear_sweep linear_spline 0,0.0025
        4 <0.02,-0.015>, <-0.01,0>, <0.01,0.02>, <0.02,-0.015>
        translate <22.635,0,-10.275>
    }
    pigment { color rgbf <1,0.5,0,0.6> }
    interior { ior 1.4 }
    normal { dents 2 scale 0.02 }
    finish { reflection 0.1 phong 0.5 phong_size 20 }
}
union
{   // some white glass
    prism
    {   linear_sweep linear_spline 0,0.0035
        4 <0.01,-0.01>, <-0.005,0>, <0.005,0.01>, <0.01,-0.01>
        translate <22.675,0,-10.25>
    }
    prism
    {   linear_sweep linear_spline 0,0.0045
        4 <0.01,-0.01>, <-0.005,0>, <0.005,0.01>, <0.01,-0.01>
        translate <22.35,0,-10.5>
    }
    prism
    {   linear_sweep linear_spline 0,0.0035
        5 <0.01,-0.01>, <-0.015,-0.01>, <-0.015,0.01>, <0.01,0.01>, <0.01,-0.01>
        translate <22.385,0,-10.6>
    }
    prism
    {   linear_sweep linear_spline 0,0.0035
        5 <0.01,-0.01>, <-0.015,-0.01>, <-0.015,0.01>, <0.01,0.01>, <0.01,-0.01>
        rotate y*120
        translate <22.425,0,-10.6>
    }
    prism
    {   linear_sweep linear_spline 0,0.0045
        5 <0.01,-0.01>, <-0.015,-0.01>, <-0.015,0.015>, <0.01,0.015>, <0.01,-0.01>
        rotate y*33
        translate <22.625,0,-10.635>
    }
    prism
    {   linear_sweep linear_spline 0,0.0045
        4 <0.01,-0.01>, <-0.005,0>, <0.005,0.01>, <0.01,-0.01>
        rotate y*-66
        translate <22.415,0,-10.475>
    }
    prism
    {   linear_sweep linear_spline 0,0.0045
        4 <0.01,-0.01>, <-0.005,0>, <0.005,0.01>, <0.01,-0.01>
        rotate y*-66
        translate <22.495,0,-10.55>
    }
    prism
    {   linear_sweep linear_spline 0,0.0035
        4 <0.01,-0.01>, <-0.005,0>, <0.005,0.01>, <0.01,-0.01>
        rotate y*25
        translate <22.6,0,-10.4>
    }
    prism
    {   linear_sweep linear_spline 0,0.0045
        5 <0.025,-0.01>, <-0.015,0>, <0.03,0.02>, <0.01,0>, <0.025,-0.01>
        translate <22.225,0,-10.33>
    }
    prism
    {   linear_sweep linear_spline 0,0.0035
        5 <-0.01,-0.01>, <-0.015,-0.02>, <0.03,-0.02>, <0.02,0.02>, <-0.01,-0.01>
        translate <22.1,0,-10.425>
    }
    pigment { color rgbf <1,1,1,0.9> }
    interior { ior 1.6 }
    normal { dents 2 scale 0.02 }
    finish { reflection 0.1 phong 0.7 phong_size 40 }
}

difference
{   // plastic fork
    union
    {   cylinder { <0,0,0>,<0,0.003,0>, 0.015 }
        box { <-0.015,0,0.1>,<0.015,0.003,0> }
        cylinder { <0,0,0.1>,<0,0.003,0.1>, 0.015 }
        cylinder { <0,0,0.125>,<0,0.003,0.125>, 0.015 }
        prism
        {   linear_sweep linear_spline 0,0.003
            4 <-0.015,0.13>, <-0.015,0.175>, <0,0.13>, <-0.015,0.13>
        }
        prism
        {   linear_sweep linear_spline 0,0.003
            4 <-0.01,0.13>, <0,0.175>, <0.01,0.13>, <-0.01,0.13>
        }
        prism
        {   linear_sweep linear_spline 0,0.003
            4 <0.015,0.13>, <0.015,0.175>, <0,0.13>, <0.015,0.13>
        }
    }
    cylinder { <0,-0.1,0>,<0,0.001,0>, 0.0125 }
    box { <-0.0125,-0.1,0.1>,<0.0125,0.001,0> }
    cylinder { <0,-0.1,0.1>,<0,0.001,0.1>, 0.0125 }
    box { <-0.01,-0.1,0.1>,<0.01,0.001,0.125> }
    cylinder { <0,-0.1,0.125>,<0,0.001,0.125>, 0.0125 }
    prism
    {   linear_sweep linear_spline -0.1,0.001
        4 <-0.0125,0.115>, <-0.0125,0.16>, <0,0.115>, <-0.0125,0.115>
    }
    prism
    {   linear_sweep linear_spline -0.1,0.001
        4 <-0.01,0.115>, <0,0.16>, <0.01,0.115>, <-0.01,0.115>
    }
    prism
    {   linear_sweep linear_spline -0.1,0.001
        4 <0.0125,0.115>, <0.0125,0.16>, <0,0.115>, <0.0125,0.115>
    }
    cylinder { <0,0.1,0>,<0,0.002,0>, 0.0125 }
    box { <-0.0125,0.1,0.1>,<0.0125,0.002,0> }
    cylinder { <0,0.1,0.1>,<0,0.002,0.1>, 0.0125 }
    box { <-0.01,0.1,0.1>,<0.01,0.002,0.125> }
    cylinder { <0,0.1,0.125>,<0,0.002,0.125>, 0.0125 }
    prism
    {   linear_sweep linear_spline 0.1,0.002
        4 <-0.0125,0.115>, <-0.0125,0.16>, <0,0.115>, <-0.0125,0.115>
    }
    prism
    {   linear_sweep linear_spline 0.1,0.002
        4 <-0.01,0.115>, <0,0.16>, <0.01,0.115>, <-0.01,0.115>
    }
    prism
    {   linear_sweep linear_spline 0.1,0.002
        4 <0.0125,0.115>, <0.0125,0.16>, <0,0.115>, <0.0125,0.115>
    }
    pigment
    {   wood
        color_map {
          [0.0 color Salmon ]
          [0.2 color Plum ]
          [0.5 color Plum ]
          [0.9 color Orchid ]
          [1.0 color Salmon ]
        }
        turbulence 0.2
        rotate x*90
        scale <0.15, 0.2, 0.3>
    }
    finish { Shiny }
    rotate y*-30
    translate <22.69,0,-10.475>
}

#declare sanddune =
difference
{ box { <1,1,-1>, <-1,0,0> }
  sphere { <1,1,-1>, 1.5 }
  sphere { <-1,1,-1>, 1.5 }
  pigment
  {
      granite
      color_map
      {
          [0.0 color Khaki     ]
          [0.2 color Tan       ]
          [0.2 color SandStone ]
          [0.3 color Gray80    ]
          [1.0 rgbt <.6,.6,.6, 1> ]
      }
  }
  finish { crand 0.4 }
}
object { sanddune scale <0.5,0.04,0.05> translate <21.55,0,-10.19> }
object { sanddune scale <0.4,0.03,0.075> translate <22.6,0,-10.2> }



//
// porta
//

object
{   pillar scale <1.25,1.6,1.25>
    translate x*18 translate z*20.5
    pigment
    {
        gradient y
        color_map {
        [0.00 color DarkSandStone ]
        [0.20 color SandStone ]
        [0.50 color DarkKhaki ]
        [0.95 color SandStone ]
        [1.00 color SandStone ]
        }
        scale <1,16,1>
    }
    normal { bumps 0.95 scale 0.5 }
}
object
{   pillar scale <1.25,1.6,1.25>
    translate x*11.25 translate z*20.5
    pigment
    {
        gradient y
        color_map {
        [0.00 color SandStone ]
        [0.20 color DarkerKhaki ]
        [0.50 color DarkKhaki ]
        [0.95 color SandStone ]
        [1.00 color Khaki ]
        }
        scale <1,16,1>
    }
    normal { bumps 0.9 scale 0.475 }
}
difference
{   object { pillar scale <1.251,1.6,1.251> }
    box { <2,7,2>,<-2,-1,-2> }
    box { <2,9.5,2>,<-2,20,-2> }
    translate x*11.25 translate z*20.5
    pigment { DarkerKhaki }
    normal { bumps 0.95 scale 0.44 }
}
object
{   pillar scale <1.25,1.6,1.25>
    translate x*4.5 translate z*20.5
    pigment
    {
        gradient y
        color_map {
        [0.00 color SandStone ]
        [0.23 color DarkKhaki ]
        [0.231 color DarkUmbra ]
        [0.232 color DarkUmbra ]
        [0.235 color DarkKhaki ]
        [0.25 color DarkKhaki ]
        [0.255 color DarkUmbra ]
        [0.257 color DarkUmbra ]
        [0.26 color DarkKhaki ]
        [0.80 color DarkKhaki ]
        [0.90 color DarkerKhaki ]
        [1.00 color SandStone ]
        }
        scale <1,17,1>
    }
    normal { bumps 0.9 scale 0.41 }
}
difference
{   object { pillar scale <1.251,1.6,1.251> }
    box { <2,3,2>,<-2,-1,-2> }
    box { <2,9.5,2>,<-2,20,-2> }
    box { <2,9.5,-0.5>,<-2,3,-2> }
    translate x*4.5 translate z*20.5
    pigment { DarkKhaki }
    normal { bumps 0.95 scale 0.41 }
}
object
{   pillar scale <1.25,1.6,1.25>
    translate x*-4.5 translate z*20.5 pigment { DarkerKhaki }
    normal { bumps 0.8 scale 0.4 }
}
difference
{   object { pillar scale <1.251,1.6,1.251> }
    box  { <2,4,2>, <-2,20,-2> }
    translate x*-4.5 translate z*20.5
    pigment { SandStone }
    normal { bumps 0.6 scale 0.4 }
}
object
{   pillar scale <1.25,1.6,1.25>
    translate x*-11.25 translate z*20.5
    pigment { DarkerKhaki }
    normal { bumps 0.6 scale 0.37 }
}
difference
{   object { pillar scale <1.251,1.6,1.251> }
    box { <2,7,2>,<-2,-1,-2> }
    box { <2,10,2>,<-2,9,-2> }
    box { <2,12,2>,<-2,20,-2> }
    translate x*-11.25 translate z*20.5
    pigment { DarkKhaki }
    normal { bumps 0.95 scale 0.37 }
}
object
{   pillar scale <1.25,1.6,1.25>
    translate x*-18 translate z*20.5 pigment { DarkKhaki }
    normal { bumps 0.5 scale 0.42 }
}
difference
{   object { pillar scale <1.251,1.6,1.251> }
    box { <2,12,2>,<-2,-1,-2> }
    translate x*-18 translate z*20.5
    pigment { DarkerKhaki }
    normal { bumps 0.95 scale 0.37 }
}
object
{   pillar scale <1.25,1.6,1.25>
    translate x*18 translate z*31.5
    pigment { SandStone } normal { bumps 0.5 }
}
object
{   pillar scale <1.25,1.6,1.25>
    translate x*11.25 translate z*31.5
    pigment { SandStone } normal { bumps 0.6 }
}
object
{   pillar scale <1.25,1.6,1.25>
    translate x*4.5 translate z*31.5
    pigment { SandStone } normal { bumps 0.9 }
}
object
{   pillar scale <1.25,1.6,1.25>
    translate x*-4.5 translate z*31.5
    pigment { SandStone } normal { bumps 0.7 }
}
object
{   pillar scale <1.25,1.6,1.25>
    translate x*-11.25 translate z*31.5
    pigment { SandStone } normal { bumps 0.9 }
}
object
{   pillar scale <1.25,1.6,1.25>
    translate x*-18 translate z*31.5 pigment
    { SandStone } normal { bumps 0.8 }
}

union
{
    box { <18.5,0,21.75>, <17.2,16,30.25> }
    difference
    {
        box { <18.5,0,21.9>, <17,16,30.1> }
        box { <18,0,25.75>, <15,6.5,22.75> }
        box { <18,0,26.25>, <15,6.5,29.25> }
        box { <18,7.5,22.75>, <15,10,29.25> }
        cylinder { <18,13,26>, <15,13,26>, 1.6 }
    }
    box { <10.45,0,21.75>, <12.05,16,30.25> }
    difference
    {
        box { <12.25,0,21.9>, <10.25,16,30.1> }
        box { <9,0,25.75>, <13,6.5,22.75> }
        box { <9,0,26.25>, <13,6.5,29.25> }
        box { <9,7.5,22.75>, <13,10,29.25> }
        cylinder { <9,13,26>, <13,13,26>, 1.6 }
    }
    box { <3.7,0,21.75>, <5.3,16,30.25> }
    difference
    {
        box { <3.5,0,21.9>, <5.5,16,30.1> }
        box { <4,0,25.75>, <7,6.5,22.75> }
        box { <4,0,26.25>, <7,6.5,29.25> }
        box { <4,0,24>, <2,6.5,28> }
        box { <4,7.5,22.75>, <7,10,29.25> }
        box { <4,7.5,24>, <2,10,28> }
        cylinder { <2,13,26>, <7,13,26>, 1.6 }
    }
    box { <-18.5,0,21.75>, <-17.2,16,30.25> }
    difference
    {
        box { <-18.5,0,21.9>, <-17,16,30.1> }
        box { <-18,0,25.75>, <-15,6.5,22.75> }
        box { <-18,0,26.25>, <-15,6.5,29.25> }
        box { <-18,7.5,22.75>, <-15,10,29.25> }
        cylinder { <-18,13,26>, <-15,13,26>, 1.6 }
    }
    box { <-10.45,0,21.75>, <-12.05,16,30.25> }
    difference
    {
        box { <-12.25,0,21.9>, <-10.25,16,30.1> }
        box { <-9,0,25.75>, <-13,6.5,22.75> }
        box { <-9,0,26.25>, <-13,6.5,29.25> }
        box { <-9,7.5,22.75>, <-13,10,29.25> }
        cylinder { <-9,13,26>, <-13,13,26>, 1.6 }
    }
    box { <-3.7,0,21.75>, <-5.3,16,30.25> }
    difference
    {
        box { <-3.5,0,21.9>, <-5.5,16,30.1> }
        box { <-4,0,25.75>, <-7,6.5,22.75> }
        box { <-4,0,26.25>, <-7,6.5,29.25> }
        box { <-4,0,24>, <-2,6.5,28> }
        box { <-4,7.5,22.75>, <-7,10,29.25> }
        box { <-4,7.5,24>, <-2,10,28> }
        cylinder { <-2,13,26>, <-7,13,26>, 1.6 }
    }

    difference
    {   // magnus architravus
        box { <18.5,16,19.5>, <-18.5,20.5,32.5> }          
        box { <16.5,0,21>, <12.75,17,31> }          
        box { <9.75,0,21>, <6,17,31> }          
        box { <3,0,21>, <-3,17,31> }          
        box { <-9.75,0,21>, <-6,17,31> }          
        box { <-16.5,0,21>, <-12.75,17,31> }          
    }
    box { <18.65,17,19.35>, <-18.65,17.15,32.65> }      // magna taenia
    box { <19,18.5,19>, <-19,18.55,33> }                // geison
    box { <19.3,18.55,18.7>, <-19.3,19,33.3>  }         // magnus geison
    box { <19.4,19,18.6>, <-19.4,19.1,33.4> }
    difference
    {
        cylinder { <19.4,19.5,18.6>, <19.4,19.5,33.4>, 0.4 }
        box  { <20,19.5,18>, <-20,25,34> }
    }
    difference
    {
        cylinder { <-19.4,19.5,18.6>, <-19.4,19.5,33.4>, 0.4 }
        box  { <20,19.5,18>, <-20,25,34> }
    }
    difference
    {
        cylinder { <-19.4,19.5,18.6>, <19.4,19.5,18.6>, 0.4 }
        box  { <20,19.5,18>, <-20,25,34> }
    }
    difference
    {
        cylinder { <-19.4,19.5,33.4>, <19.4,19.5,33.4>, 0.4 }
        box  { <20,19.5,18>, <-20,25,34> }
    }
    difference
    {
        intersection
        {
            cylinder { <19.4,19.5,18.1>, <19.4,19.5,33.4>, 0.4 }
            cylinder { <-19.4,19.5,18.6>, <19.9,19.5,18.6>, 0.4 }
        }
        box  { <20,19.5,18>, <-20,25,34> }
    }
    difference
    {
        intersection
        {
            cylinder { <-19.4,19.5,18.1>, <-19.4,19.5,33.4>, 0.4 }
            cylinder { <-19.9,19.5,18.6>, <19.4,19.5,18.6>, 0.4 }
        }
        box  { <20,19.5,18>, <-20,25,34> }
    }
    difference
    {
        intersection
        {
            cylinder { <19.4,19.5,18.9>, <19.4,19.5,33.9>, 0.4 }
            cylinder { <-19.4,19.5,33.4>, <19.9,19.5,33.4>, 0.4 }
        }
        box  { <20,19.5,18>, <-20,25,34> }
    }
    difference
    {
        intersection
        {
            cylinder { <-19.4,19.5,18.9>, <-19.4,19.5,33.9>, 0.4 }
            cylinder { <-19.9,19.5,33.4>, <19.1,19.5,33.4>, 0.4 }
        }
        box  { <20,19.5,18>, <-20,25,34> }
    }

    #declare i=17.8;
    #while (i>-18)
    object { triglyph scale <1.8,1.65,1.8> translate <i,16.8,19.17> }
    object { triglyph scale <1.8,1.65,1.8> rotate y*180 translate <i,16.8,32.93> }
    #declare i=i-2.225;
    #end
    #declare i=20.5;
    #while (i<33)
    object { triglyph scale<1.8,1.65,1.8> rotate y*-90 translate<18.88,16.8,i> }
    object { triglyph scale<1.8,1.65,1.8> rotate y*90 translate<-18.88,16.8,i> }
    #declare i=i+2.2;
    #end

    #declare i=-18.3;
    #while (i<-5)
    object { diglyph translate <i,0,20.3> }
    object { diglyph translate <-i,0,20.3> }
    object { diglyph rotate y*180 translate <i,0,31.7> }
    object { diglyph rotate y*180 translate <-i,0,31.7> }
    #declare i=i+1.665;
    #end
    #declare i=-4.75;
    #while (i<5)
    object { diglyph translate <i,0,19.2> }
    object { diglyph rotate y*180 translate <i,0,32.4> }
    #declare i=i+1.58333;
    #end
    object { diglyph rotate y*-90 translate <5.2,0,19.6> }
    object { diglyph rotate y*90 translate <-5.2,0,19.6> }
    object { diglyph rotate y*-90 translate <5.2,0,32.1> }
    object { diglyph rotate y*90 translate <-5.2,0,32.1> }
    #declare i=20.8;
    #while (i<31.5)
    object { diglyph rotate y*-90 translate <18.7,0,i> }
    object { diglyph rotate y*90 translate <-18.7,0,i> }
    #declare i=i+2.08;
    #end

    box { <19.9,19.5,18.1>, <-19.9,19.575,33.9> }
    difference
    {
        box { <5,19.5,19.4>, <-5,23.75,32.6> }  // quadriga basis
        box { <4.3,20.7,19>, <-4.3,22.5,19.6> } // fries
        box { <4.3,20.7,33>, <-4.3,22.5,32.4> } // fries
    }
    box { <19,23,20>, <-19,23.1,32> }
    box { <5.5,23,18.9>, <-5.5,23.1,33.1> }

    box { < 6.25,22.4,19.875>, < -6.25,22.7,32.125> }      // scalae
    box { < 7.50,22.1,19.870>, < -7.50,22.4,32.130> }      // scalae
    box { < 8.75,21.8,19.865>, < -8.75,22.1,32.135> }      // scalae
    box { <10.00,21.5,19.860>, <-10.00,21.8,32.140> }      // scalae
    box { <11.25,21.2,19.855>, <-11.25,21.5,32.145> }      // scalae
    box { <12.50,20.9,19.850>, <-12.50,21.2,32.150> }      // scalae
    box { <13.75,20.6,19.845>, <-13.75,20.9,32.155> }      // scalae

    pigment { DarkKhaki }
}

union
{   // fries relief
    box { <4.2,20.7,19.5>, <-4.2,22.5,19.6> }
    box { <4.2,20.7,32.5>, <-4.2,22.5,32.4> }

    pigment { DarkKhaki }
    normal { granite 1.2 scale 2.5 }
}
union
{   // architrav reliefs
    box { <18,17.3,19.5>, <-18,18.35,19.501> }
    box { <18,17.3,32.5>, <-18,18.35,32.499> }

    pigment { DarkKhaki }
    normal { granite 1.2 scale 2 }
}
object
{   // architrav lacunar
    box { <18,17.0,21.0>, <-18,16.999,31.0> }

    pigment { SlightlyDarkerKhaki }
    finish  { ambient 0.15 }
}
union
{   // architrav lacunar ornamentum
    difference
    {   
        box { <16.25,16.998,21.25>, <13.00,17,30.75> }          
        box { <16.00,16.997,21.50>, <13.25,17,30.50> }          
    }
    difference
    {   
        box { <9.50,16.998,21.25>, <6.25,17,30.75> }          
        box { <9.25,16.997,21.50>, <6.50,17,30.50> }          
    }
    difference
    {   
        box { <2.75,16.998,21.25>, <-2.75,17,30.75> }          
        box { <2.50,16.997,21.50>, <-2.50,17,30.50> }          
    }
    difference
    {   
        box { <-9.50,16.998,21.25>, <-6.25,17,30.75> }          
        box { <-9.25,16.997,21.50>, <-6.50,17,30.50> }          
    }
    difference
    {   
        box { <-16.25,16.998,21.25>, <-13.00,17,30.75> }          
        box { <-16.00,16.997,21.50>, <-13.25,17,30.50> }          
    }

    pigment { SlightlyDarkerKhaki }
    normal { granite 1.2 scale 0.5 }
}
object
{   // corona porta
    box { <18.5,20.6,20.5>, <-18.5,23,31.5> }
    pigment
    {   brick SandStone, DarkKhaki
        brick_size <1, 0.48, 1> mortar 0.02
    }
}

union
{   // internal reliefs
    difference
    {   
        cylinder { <17,13,26>, <18,13,26>, 1.595 }
        cylinder { <16,13,26>, <17.1,13,26>, 1.45 }
    }
    difference
    {   
        box { <18,7.495,22.755>, <17,9.995,29.245> }
        box { <16,7.35,22.9>, <17.1,9.85,29.1> }
    }
    difference
    {   
        cylinder { <12.25,13,26>, <10.25,13,26>, 1.595 }
        cylinder { <12.15,13,26>, <13,13,26>, 1.45 }
        cylinder { <10.35,13,26>, <9,13,26>, 1.45 }
    }
    difference
    {   
        box { <12.25,7.495,22.755>, <10.25,9.995,29.245> }
        box { <12.15,7.35,22.9>, <13,9.85,29.1> }
        box { <10.35,7.35,22.9>, <9,9.85,29.1> }
    }
    difference
    {   
        cylinder { <3.5,13,26>, <5.5,13,26>, 1.595 }
        cylinder { <3.6,13,26>, <2,13,26>, 1.595 }
        cylinder { <6,13,26>, <5.4,13,26>, 1.45 }
    }
    difference
    {   
        box { <5.5,7.495,22.755>, <4.5,9.995,29.245> }
        box { <6,7.35,22.9>, <5.4,9.85,29.1> }
    }
    difference
    {   
        box { <3.5,7.495,24.005>, <4.5,9.995,27.995> }
        box { <2,7.35,24.15>, <4.6,9.85,27.85> }
    }
    difference
    {   
        cylinder { <-17,13,26>, <-18,13,26>, 1.595 }
        cylinder { <-16,13,26>, <-17.1,13,26>, 1.45 }
    }
    difference
    {   
        box { <-18,7.495,22.755>, <-17,9.995,29.245> }
        box { <-16,7.35,22.9>, <-17.1,9.85,29.1> }
    }
    difference
    {   
        cylinder { <-12.25,13,26>, <-10.25,13,26>, 1.595 }
        cylinder { <-12.15,13,26>, <-13,13,26>, 1.45 }
        cylinder { <-10.35,13,26>, <-9,13,26>, 1.45 }
    }
    difference
    {   
        box { <-12.25,7.495,22.755>, <-10.25,9.995,29.245> }
        box { <-12.15,7.35,22.9>, <-13,9.85,29.1> }
        box { <-10.35,7.35,22.9>, <-9,9.85,29.1> }
    }
    difference
    {   
        cylinder { <-3.5,13,26>, <-5.5,13,26>, 1.595 }
        cylinder { <-3.6,13,26>, <-2.5,13,26>, 1.595 }
        cylinder { <-6,13,26>, <-5.4,13,26>, 1.45 }
    }
    difference
    {   
        box { <-5.5,7.495,22.755>, <-4.5,9.995,29.245> }
        box { <-6,7.35,22.9>, <-5.4,9.85,29.1> }
    }
    difference
    {   
        box { <-3.5,7.495,24.005>, <-4.5,9.995,27.995> }
        box { <-2,7.35,24.15>, <-3.6,9.85,27.85> }
    }

    pigment { DarkUmbra }
    normal { granite 0.8 scale 0.5 }
}

union
{   // porta basis
    box { <18.5,0,21.749>,   <17.199,0.5,30.251> }
    box { <18.5,0,21.899>,   <16.999,0.5,30.101> }
    box { <10.449,0,21.749>, <12.051,0.5,30.251> }
    box { <12.251,0,21.899>, <10.249,0.5,30.101> }
    box { <3.699,0,21.749>,  <5.301,0.5,30.251> }
    box { <3.499,0,21.899>,  <5.501,0.5,30.101> }
    box { <-18.5,0,21.749>,  <-17.199,0.5,30.251> }
    box { <-18.5,0,21.899>,  <-16.999,0.5,30.101> }
    box { <-10.449,0,21.749>,<-12.051,0.5,30.251> }
    box { <-12.251,0,21.899>,<-10.249,0.5,30.101> }
    box { <-3.699,0,21.749>, <-5.301,0.5,30.251> }
    box { <-3.499,0,21.899>, <-5.501,0.5,30.101> }

    pigment { DarkUmbra }
    normal { bumps 0.8 scale 0.5 }
}

object
{   
    box { <18.5,20.5,19.499>, <-18.5,20.575,32.501> } // sima architravae
    pigment { DarkSandStone }                         // trickus schmutzikus
}

union
{   
    box { <19.9,19.5,18.1>, <-19.9,19.6,33.9> }  // magnae simae
    box { <18.5,20.5,19.5>, <-18.5,20.6,32.5> } // sima architravae
    box { <19,23.15,20>, <-19,23.1,32> }        // sima finita
    box { <5.5,23.15,18.9>, <-5.5,23.1,33.1> }
    box { <5,23.75,19.4>, <-5,23.8,32.6> } // quadriga basis

    box { < 6.30,22.71,19.825>, < -6.30,22.7,32.175> }      // scalae
    box { < 7.55,22.41,19.820>, < -7.55,22.4,32.180> }      // scalae
    box { < 8.80,22.11,19.815>, < -8.80,22.1,32.185> }      // scalae
    box { <10.05,21.81,19.810>, <-10.05,21.8,32.190> }      // scalae
    box { <11.30,21.51,19.805>, <-11.30,21.5,32.195> }      // scalae
    box { <12.55,21.21,19.800>, <-12.55,21.2,32.200> }      // scalae
    box { <13.80,20.91,19.795>, <-13.80,20.9,32.205> }      // scalae

    pigment { PalerGreen }
    normal  { bumps 0.1 scale 2.5 }
}

object { poller translate x*14.625 }
object { poller translate x*7.875 }
object { poller translate x*-2 translate z*2 }
object { poller translate x*2 translate z*-2 }
object { poller translate x*-7.875 }
object { poller translate x*-14.625 }
object { no_trespassing translate <4.5,0,35> }
object { no_trespassing translate <-4.5,0,35> }
object { no_trespassing rotate y*180 translate <4.5,0,18.5> }
object { no_trespassing rotate y*180 translate <-4.5,0,18.5> }
object { right_only translate <0,0,6.8> }
object { right_only rotate y*-90 translate <-6.8,0,0> }
object { right_only rotate y*90 translate <6.8,0,0> }
object { right_only rotate y*180 translate <0,0,-6.8> }
object { right_turn_only_no_right rotate y*-90 translate <-19,0,-18.5> }
object { right_turn_only_no_right rotate y*90 translate <19,0,-9.75> }
object { lantern translate <-17.5,0,-9> }
object { lantern rotate y*180 translate <17.5,0,-9> }
object { i_sign rotate y*3 translate <19.5,0,5> }
object { i_sign rotate y*-89 translate <-22.75,0,13> }
object { vexilli translate x*29 }
object { vexilli translate x*-29 }



//
// dextra
//

object
{   pillar scale <0.8,1,0.8>
    translate x*24
 // pigment { DarkKhaki }
    pigment
    {
        gradient y
        color_map {
        [0.00 color SandStone ]
        [0.10 color SandStone ]
        [0.50 color DarkerKhaki ]
        [1.00 color DarkerKhaki ]
        }
        turbulence 0.1
        scale <1,10,1>
    }
    normal { bumps 0.6 scale 0.33 }
}
difference
{   object { pillar scale <0.801,1,0.801> }
    box { <-1,8,-1>, <1,6,1> }
    box { <-1,4,-1>, <1,2,1> }
    box { <-1,0.5,-1>, <1,0,1> }
    translate x*24
    pigment
    {
        gradient y
        color_map {
        [0.00 color DarkerKhaki ]
        [1.00 color DarkKhaki ]
        }
        turbulence 0.1
        scale <1,11,1>
    }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*27
 // pigment { DarkKhaki }
    pigment
    {
        gradient y
        color_map {
        [0.00 color SandStone ]
        [0.08 color SandStone ]
        [0.10 color DarkerKhaki ]
        [0.30 color DarkKhaki ]
        [1.00 color DarkKhaki ]
        }
        turbulence 0.1
        scale <1,11,1>
    }
    normal { bumps 0.6 scale 0.33 }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*31
    pigment
    {
        gradient y
        color_map {
        [0.00 color SandStone ]
        [0.08 color SandStone ]
        [0.10 color DarkerKhaki ]
        [1.00 color DarkKhaki ]
        }
        turbulence 0.1
        scale <1,11,1>
    }
    normal { bumps 0.6 scale 0.33 }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*34
    pigment
    {
        gradient y
        color_map {
        [0.00 color SandStone ]
        [0.10 color SandStone ]
        [0.11 color DarkerKhaki ]
        [1.00 color DarkKhaki ]
        }
        scale <1,10,1>
    }
    normal { bumps 0.6 scale 0.33 }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*24 translate z*4 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*34 translate z*4 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*24 translate z*8 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*34 translate z*8 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*24 translate z*12 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*34 translate z*12 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*24 translate z*16 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*34 translate z*16 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*20 translate z*20 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*24 translate z*20 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*29 translate z*20 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*34 translate z*20 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*38 translate z*20 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*24 translate z*24 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*29 translate z*24 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*34 translate z*24 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*38 translate z*24 pigment { DarkKhaki }
}
// object { pillar scale <0.8,1,0.8> translate <24,0,28> pigment { DarkKhaki }}
// object { pillar scale <0.8,1,0.8> translate <29,0,28> pigment { DarkKhaki }}
object
{   pillar scale <0.8,1,0.8>
    translate x*34 translate z*28 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*38 translate z*28 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*20 translate z*32 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*24 translate z*32 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*29 translate z*32 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*34 translate z*32 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8>
    translate x*38 translate z*32 pigment { DarkKhaki }
}

difference
{   // aedificium
    box { <26.25,0,2.5>, <32.75,10,17> }
    box { <26.75,0.5,3>, <32.25,11,16.5> }
    // fenestra fronta sub architrav
    box { <28.0625,8.75,1>, <29.9375,6.875,4> }
    // ostium imitamentum
    box { <27.75,0.5,1>, <30.25,5,4> }
    // fenestra media sub architrav
    box { <25,8.75,9.0625>, <28,6.875,10.9375> }
    // ostium
    box { <25,0.5,8.75>, <28,5,11.25> }
    // fenestra dextra sub architrav
    box { <25,8.75,5.0625>, <28,6.875,6.9375> }
    // fenestra dextra
    box { <25,1.875,5.0625>, <28,4.375,6.9375> }
    // fenestra sinistra sub architrav
    box { <25,8.75,13.0625>, <28,6.875,14.9375> }
    // fenestra sinistra
    box { <25,1.875,13.0625>, <28,4.375,14.9375> }

    pigment
    {   brick Gray10, DarkKhaki
        brick_size <1.4, 0.65, 1.4> mortar 0.025 translate <0.05,0.3,0>
    }
}

union
{   difference
    {   // intermediate
        box { <18.5,0,21.5>, <20.5,11.5,30.5> }
        cylinder { <20.5,0,26>, <20.5,5,26>, 1.5 }
        sphere { <20.5,5,26>, 1.5 }
    }
    box { <18.5,10.5,21.6>, <20.5,10.55,30.6> }        // intermediate taenia
    box { <18.5,11.5,21.9>, <20.5,11.75,30.9> }        // intermediate geison
    box { <18.5,11.75,22.0>, <19.25,12.20,30.0> }      // intermediate scalae
    box { <18.5,12.20,22.4>, <19.25,12.55,29.6> }
    box { <18.5,12.55,22.8>, <19.25,12.90,29.2> }
    box { <18.5,12.90,23.2>, <19.25,13.25,28.8> }
    box { <18.5,13.25,23.6>, <19.25,13.60,28.4> }
    box { <18.5,13.60,24.0>, <19.25,13.95,28.0> }
    box { <18.5,13.95,24.4>, <19.25,14.30,27.6> }
    box { <18.5,14.30,24.8>, <19.25,14.65,27.2> }
    box { <18.5,14.65,25.2>, <19.25,15.00,26.8> }
    box { <18.5,15.00,25.6>, <19.25,15.35,26.4> }
    
    box { <23.5,10,-0.5>, <34.5,11.5,20> }             // architrav
    box { <23.4,10.5,-0.6>, <34.6,10.55,20> }          // taenia
    box { <23.1,11.5,-0.9>, <34.9,11.75,20> }          // geison
    box { <23.0,11.655,-1>, <35.0,11.65,20> }          // geison taenia

    box { <19.5,10,19.5>, <38.5,11.5,32.5> }           // architrav
    box { <19.4,10.5,19.4>, <38.6,10.54,32.6> }        // taenia
    box { <19.1,11.5,19.1>, <38.9,11.75,32.9> }        // geison
    box { <19,11.655,19>, <39,11.65,33> }              // geison taenia

    pigment { DarkKhaki }
}

union
{   // sima secundus intermediate + aedificium + porticus
    box { <18.5,12.20,22.0>, <19.26,12.201,22.39> }
    box { <18.5,12.20,29.6>, <19.26,12.201,30.01> }
    box { <18.5,12.55,22.4>, <19.26,12.551,22.79> }
    box { <18.5,12.55,29.2>, <19.26,12.551,29.61> }
    box { <18.5,12.90,22.8>, <19.26,12.901,23.19> }
    box { <18.5,12.90,28.8>, <19.26,12.901,29.21> }
    box { <18.5,13.25,23.2>, <19.26,13.251,23.59> }
    box { <18.5,13.25,28.4>, <19.26,13.251,28.81> }
    box { <18.5,13.60,23.6>, <19.26,13.601,23.99> }
    box { <18.5,13.60,28.0>, <19.26,13.601,28.41> }
    box { <18.5,13.95,24.0>, <19.26,13.951,24.39> }
    box { <18.5,13.95,27.6>, <19.26,13.951,28.01> }
    box { <18.5,14.30,24.4>, <19.26,14.301,24.79> }
    box { <18.5,14.30,27.2>, <19.26,14.301,27.61> }
    box { <18.5,14.65,24.8>, <19.26,14.651,25.19> }
    box { <18.5,14.65,26.8>, <19.26,14.651,27.21> }
    box { <18.5,15.00,25.2>, <19.26,15.001,25.59> }
    box { <18.5,15.00,26.4>, <19.26,15.001,26.81> }
    box { <18.5,15.35,25.59>,<19.26,15.351,26.41> }

    box { <24,11.76,-0.915>, <34,11.75,20> }
    box { <19.01,11.76,20>, <38.91,11.75,32> }

    pigment { PaleGreen }
}

difference
{   // sima + tympanon aedificium
    union
    {
        box { <23.5,9,-0.5>, <34.5,11.5,26> pigment { DarkKhaki } }
        box { <23.1,11.5,-0.9>, <34.9,11.75,26> pigment { DarkKhaki } }
        box { <23,11.65,-1>, <35,11.655,26> pigment { DarkKhaki } }
        difference
        {
            cylinder { <23,11.925,-0.9>, <35,11.925,-0.9>, 0.2 }
            box { <22,11.925,-2>, <36,14,0> }
            pigment { DarkKhaki }
        }
        difference
        {
            cylinder { <23.1,11.925,-0.9>, <23.1,11.925,26>, 0.2 }
            box { <22,11.925,-2>, <36,14,27> }
            pigment { DarkKhaki }
        }
        intersection
        {
            difference
            {
                cylinder { <21,11.925,-0.9>, <35,11.925,-0.9>, 0.2 }
                box { <20,11.925,-2>, <36,14,0> }
            }
            difference
            {
                cylinder { <23.1,11.925,-3>, <23.1,11.925,26>, 0.2 }
                box { <22,11.925,-2>, <36,14,27> }
            }
            pigment { DarkKhaki }
        }

        box { <22.75,11.925,-1.15>, <35.15,11.93,26> pigment { PaleGreen } }
        #declare i=-1;
        #while (i<26)
        box { <23.1,11.925,i>, <34.9,11.95,i+0.002> pigment { PaleGreen4 } }
        #declare i=i+1;
        #end
        // box { <23.002,11.925,-0.5>, <23.004,11.95,26> pigment { PaleGreen4 } }

        box { <22.75,11.925,0>, <35.15,11.95,0.> pigment { PaleGreen } }

        translate <-23,-10,0> rotate z*15 translate <23.5,10,0>
    }
    box { <-10,11.5,-10>, <50,0,50> pigment { Clear } }
    box { <29,11,-5>, <50,22,50> pigment { Clear } }
}

difference
{   // sima + tympanon aedificium
    union
    {
        box { <23.5,9,-0.5>, <34.5,11.5,26> pigment { DarkKhaki } }
        box { <23.1,11.5,-0.9>, <34.9,11.75,26> pigment { DarkKhaki } }
        box { <23,11.65,-1>, <35,11.655,26> pigment { DarkKhaki } }
        difference
        {
            cylinder { <23,11.925,-0.9>, <35,11.925,-0.9>, 0.2 }
            box { <22,11.925,-2>, <36,14,0> }
            pigment { DarkKhaki }
        }
        difference
        {
            cylinder { <34.9,11.925,-0.9>, <34.9,11.925,26>, 0.2 }
            box { <22,11.925,-2>, <36,14,27> }
            pigment { DarkKhaki }
        }
        intersection
        {
            difference
            {
                cylinder { <23,11.925,-0.9>, <37,11.925,-0.9>, 0.2 }
                box { <20,11.925,-2>, <36,14,0> }
            }
            difference
            {
                cylinder { <34.9,11.925,-3>, <34.9,11.925,26>, 0.2 }
                box { <22,11.925,-2>, <36,14,27> }
            }
            pigment { DarkKhaki }
        }

        box { <22.75,11.925,-1.15>, <35.15,11.93,26> pigment { PaleGreen } }
        #declare i=-1;
        #while (i<26)
        box { <23,11.925,i>, <34.9,11.95,i+0.002> pigment { PaleGreen4 } }
        #declare i=i+1;
        #end
        // box { <35.002,11.925,-0.5>, <35.004,11.95,26> pigment { PaleGreen4 } }

        translate <-35,-10,0> rotate z*-15 translate <34.5,10,0>
    }
    box { <-10,11.5,-10>, <50,0,50> pigment { Clear } }
    box { <29,11,-5>, <0,22,30> pigment { Clear } }
}


height_field {
    gif "relief2.gif"
    smooth
    pigment { SlightlyDarkerKhaki }
    // normal { bumps 0.7 scale 2 }
    // finish { diffuse .4 }
    scale <1.2,0.1,1.2>
    translate <-0.5,0,-0.5>
    rotate x*-90
    translate <-29,12.355,-0.475>
}

difference
{   // sima + tympanon porticus
    union
    {
        box { <19.5,10,19.5>, <38.5,11.5,32.5> pigment { DarkKhaki } }
        box { <19.1,11.5,19.1>, <38.9,11.75,32.9> pigment { DarkKhaki } }
        difference
        {
            cylinder { <19.1,11.925,19.1>, <38.9,11.925,19.1>, 0.2 }
            box { <18,11.925,10>, <40,14,20> }
            pigment { DarkKhaki }
        }
        difference
        {
            cylinder { <19.1,11.925,19.1>, <19.1,11.925,32.9>, 0.2 }
            box { <10,11.925,-2>, <36,14,40> }
            pigment { DarkKhaki }
        }
        difference
        {
            cylinder { <38.9,11.925,19.1>, <38.9,11.925,32.9>, 0.2 }
            box { <10,11.925,-2>, <40,14,34> }
            pigment { DarkKhaki }
        }
        intersection
        {
            difference
            {
                cylinder { <18,11.925,19.1>, <38.9,11.925,19.1>, 0.2 }
                box { <19,11.925,10>, <40,14,20> }
            }
            difference
            {
                cylinder { <19.1,11.925,18>, <19.1,11.925,32.9>, 0.2 }
                box { <10,11.925,-2>, <36,14,34> }
            }
            pigment { DarkKhaki }
        }
        intersection
        {
            difference
            {
                cylinder { <19.1,11.925,19.1>, <40,11.925,19.1>, 0.2 }
                box { <19,11.925,10>, <41,14,20> }
            }
            difference
            {
                cylinder { <38.9,11.925,18>, <38.9,11.925,32.9>, 0.2 }
                box { <10,11.925,-2>, <41,14,34> }
            }
            pigment { DarkKhaki }
        }

        box { <18.85,11.925,18.85>, <39.15,11.93,33.15> pigment { PaleGreen } }
        #declare i=19;
        #while (i<40)
        box { <i,11.925,19.1>, <i+0.002,11.96,32.9> pigment { PaleGreen4 } }
        #declare i=i+1;
        #end
        // box { <19,11.925,19>, <39,11.96,19.002> pigment { PaleGreen4 } }

        translate <0,-10,-19> rotate x*-13.25 translate <0,10,19.5>
    }
    box { <-10,11.5,-10>, <50,0,50> pigment { Clear } }
    box { <10,11,26>, <40,22,40> pigment { Clear } }
}

difference
{   // sima + tympanon porticus
    union
    {
        box { <19.5,10,19.5>, <38.5,11.5,32.5> pigment { DarkKhaki } }
        box { <19.1,11.5,19.1>, <38.9,11.75,32.9> pigment { DarkKhaki } }
        difference
        {
            cylinder { <19.1,11.925,32.9>, <38.9,11.925,32.9>, 0.2 }
            box { <18,11.925,10>, <40,14,40> }
            pigment { DarkKhaki }
        }
        difference
        {
            cylinder { <19.1,11.925,19.1>, <19.1,11.925,32.9>, 0.2 }
            box { <10,11.925,-2>, <36,14,40> }
            pigment { DarkKhaki }
        }
        difference
        {
            cylinder { <38.9,11.925,19.1>, <38.9,11.925,32.9>, 0.2 }
            box { <10,11.925,-2>, <40,14,34> }
            pigment { DarkKhaki }
        }
        intersection
        {
            difference
            {
                cylinder { <18,11.925,32.9>, <38.9,11.925,32.9>, 0.2 }
                box { <19,11.925,10>, <40,14,40> }
            }
            difference
            {
                cylinder { <19.1,11.925,18>, <19.1,11.925,34>, 0.2 }
                box { <10,11.925,-2>, <36,14,34> }
            }
            pigment { DarkKhaki }
        }
        intersection
        {
            difference
            {
                cylinder { <19.1,11.925,32.9>, <40,11.925,32.9>, 0.2 }
                box { <19,11.925,10>, <41,14,40> }
            }
            difference
            {
                cylinder { <38.9,11.925,18>, <38.9,11.925,34>, 0.2 }
                box { <10,11.925,-2>, <41,14,34> }
            }
            pigment { DarkKhaki }
        }

        box { <18.85,11.925,18.85>, <39.15,11.93,33.15> pigment { PaleGreen } }
        #declare i=19;
        #while (i<40)
        box { <i,11.925,19.1>, <i+0.002,11.96,32.9> pigment { PaleGreen4 } }
        #declare i=i+1;
        #end
        // box { <19,11.925,33>, <39,11.96,33.002> pigment { PaleGreen4 } }

        translate <0,-10,-33> rotate x*13.25 translate <0,10,32.5>
    }
    box { <-10,11.5,-10>, <50,0,50> pigment { Clear } }
    box { <10,11,26>, <40,22,0> pigment { Clear } }
}

#declare i=24;
#while (i<35)
object { triglyph translate <i,10.45,-0.7> }
#declare i=i+1;
#end
#declare i=0;
#while (i<20)
object { triglyph rotate y*-90 translate <34.7,10.45,i> }
object { triglyph rotate y*90 translate <23.3,10.45,i> }
#declare i=i+1;
#end
#declare i=20;
#while (i<24)
object { triglyph translate <i,10.45,19.3> }
#declare i=i+1;
#end
#declare i=35;
#while (i<39)
object { triglyph translate <i,10.45,19.3> }
#declare i=i+1;
#end
#declare i=20;
#while (i<33)
object { triglyph rotate y*-90 translate <38.7,10.45,i> }
object { triglyph rotate y*90 translate <19.3,10.45,i> }
#declare i=i+1;
#end
#declare i=20;
#while (i<39)
object { triglyph rotate y*180 translate <i,10.45,32.7> }
#declare i=i+1;
#end

union
{   // ostium imitamentum
    difference
    {
        box { <27.75,0,2.6>, <30.25,5,2.9> }
        box { <28.0625,1.25,1>, <29.9375,4.4,3> }
    }
    box { <27.75,0,2.475>, <30.25,0.5001,3> }
    box { <27.75,0,2.45>, <27.95,5,3> }
    box { <30.25,0,2.45>, <30.05,5,3> }
    box { <30.25,5,2.45>, <27.95,4.5,3> }
    box { <30.25,5,2.415>, <30.05,4.25,3> }
    box { <27.75,5,2.415>, <27.95,4.25,3> }
    box { <27.625,5,2.3>, <30.375,5.2,3> }
    box { <27.55,5.2,2.25>, <30.45,5.25,3> }
    // ostium
    box { <25.75,0,8.95>, <26.5,0.5001,11.05> }
    box { <25.95,0,8.75>, <26.5,5,8.95> }
    box { <25.95,0,11.05>, <26.5,5,11.25> }
    box { <25.95,4.5,8.75>, <26.5,5,11.25> }
    box { <25.925,4.2,8.75>, <26.5,5,8.95> }
    box { <25.925,4.2,11.05>, <26.5,5,11.25> }
    box { <25.8,5,8.625>, <26.5,5.2,11.325> }
    box { <25.8,5.2,8.625>, <26.5,5.25,11.325> }
    box { <25.75,5.2,8.5>, <26.5,5.25,11.45> }

    pigment { SandStone }
}
object
{   // sima ostiorum imitamentorum
    box { <27.53,5.25,2.225>, <30.47,5.26,3> }
    pigment { PaleGreen }
}

union
{   // fenestra fronta sub architrav
    difference
    {
        box { <28.0625,8.75,2.6>, <29.9375,6.875,2.9> }
        box { <29.09375,8.65625,2.5>, <29.84375,6.96875,3> }
        box { <28.15625,8.65625,2.5>, <28.90625,6.96875,3> }
    }
    box { <28.50,8.75,2.7>, <28.55,6.875,2.8> }
    box { <29.45,8.75,2.7>, <29.50,6.875,2.8> }
    box { <28.0625,7.475,2.7>, <29.9375,7.525,2.8> }
    box { <28.0625,8.10,2.7>, <29.9375,8.15,2.8> }
    // fenestra ostiora imitamenta
    difference
    {
        box { <28.0625,1.25,2.6>, <29.9375,4.4,2.9> }
        box { <29.09375,4.3,3>, <29.84375,3.228,2> }
        box { <28.15625,4.3,3>, <28.90625,3.228,2> }
        box { <29.09375,3.052,3>, <29.84375,1.35,2> }
        box { <28.15625,3.052,3>, <28.90625,1.35,2> }
    }
    box { <28.50,1.25,2.7>, <28.55,4.4,2.8> }
    box { <29.45,1.25,2.7>, <29.50,4.4,2.8> }
    box { <28.0625,1.85,2.7>, <29.9375,1.9,2.8> }
    box { <28.0625,2.5,2.7>, <29.9375,2.55,2.8> }
    box { <28.0625,3.8,2.7>, <29.9375,3.75,2.8> }
    // fenestra sinistra sub architrav
    difference
    {
        box { <26.1,8.75,5.0625>, <26.4,6.875,6.9375> }
        box { <26,8.65625,5.15625>, <27,6.96875,5.90625> }
        box { <26,8.65625,6.09375>, <27,6.96875,6.84375> }
    }
    box { <26.2,8.75,5.50>, <26.3,6.875,5.55> }
    box { <26.2,8.75,6.50>, <26.3,6.875,6.45> }
    box { <26.2,7.475,5.0625>, <26.3,7.525,6.9375> }
    box { <26.2,8.10,5.0625>, <26.3,8.15,6.9375> }
    // fenestra media sub architrav
    difference
    {
        box { <26.35,8.75,9.0625>, <26.65,6.875,10.9375> }
        box { <26,8.65625,9.15625>, <27,6.96875,9.90625> }
        box { <26,8.65625,10.09375>, <27,6.96875,10.84375> }
    }
    box { <26.45,8.75,9.50>, <26.55,6.875,9.55> }
    box { <26.45,8.75,10.50>, <26.55,6.875,10.45> }
    box { <26.45,7.475,9.0625>, <26.55,7.525,10.9375> }
    box { <26.45,8.10,9.0625>, <26.55,8.15,10.9375> }
    // fenestra sinistra sub architrav
    difference
    {
        box { <26.35,8.75,13.0625>, <26.65,6.875,14.9375> }
        box { <26,8.65625,13.15625>, <27,6.96875,13.90625> }
        box { <26,8.65625,14.09375>, <27,6.96875,14.84375> }
    }
    box { <26.45,8.75,13.50>, <26.55,6.875,13.55> }
    box { <26.45,8.75,14.50>, <26.55,6.875,14.45> }
    box { <26.45,7.475,13.0625>, <26.55,7.525,14.9375> }
    box { <26.45,8.10,13.0625>, <26.55,8.15,14.9375> }
    // fenestra dextra
    difference
    {
        box { <26.35,4.4,5.0625>, <26.65,1.875,6.9375> }
        box { <26,4.3,5.15625>, <27,3.225,5.90625> }
        box { <26,3.05,5.15625>, <27,1.975,5.90625> }
        box { <26,4.3,6.09375>, <27,3.225,6.84375> }
        box { <26,3.05,6.09375>, <27,1.975,6.84375> }
    }
    box { <26.45,4.4,5.50>, <26.55,1.875,5.55> }
    box { <26.45,4.4,6.50>, <26.55,1.875,6.45> }
    box { <26.45,2.525,5.0625>, <26.55,2.475,6.9375> }
    box { <26.45,3.80,5.0625>, <26.55,3.75,6.9375> }
    // fenestra sinistra
    difference
    {
        box { <26.35,4.4,13.0625>, <26.65,1.875,14.9375> }
        box { <26,4.3,13.15625>, <27,3.225,13.90625> }
        box { <26,3.05,13.15625>, <27,1.975,13.90625> }
        box { <26,4.3,14.09375>, <27,3.225,14.84375> }
        box { <26,3.05,14.09375>, <27,1.975,14.84375> }
    }
    box { <26.45,4.4,13.50>, <26.55,1.875,13.55> }
    box { <26.45,4.4,14.50>, <26.55,1.875,14.45> }
    box { <26.45,2.525,13.0625>, <26.55,2.475,14.9375> }
    box { <26.45,3.80,13.0625>, <26.55,3.75,14.9375> }

    // ostium
    difference
    {
        box { <26.35,4.5,8.9>, <26.65,0.5,11.1> }
        box { <26,4.3,9.15625>, <27,3.225,9.90625> }
        box { <26,3.05,9.15625>, <27,1.975,9.90625> }
        box { <26,4.3,10.09375>, <27,3.225,10.84375> }
        box { <26,3.05,10.09375>, <27,1.975,10.84375> }
    }
    box { <26.45,4.4,9.50>, <26.55,1.875,9.55> }
    box { <26.45,4.4,10.50>, <26.55,1.875,10.45> }
    box { <26.45,2.525,9.0625>, <26.55,2.475,10.9375> }
    box { <26.45,3.80,9.0625>, <26.55,3.75,10.9375> }
    difference
    {
        box { <26.25,1.8,9.15625>,<26.75,0.675,10.84375> }
        box { <25,1.75,9.20625>,<27,0.725,10.79375> }
    }
    box { <26.25,0.55,8.9>,<26.75,0.5,11.1> }

    pigment { DarkBrown }
}
union
{   // ansa
    cylinder { <26.25,2.5,11>, <26.75,2.5,11>, 0.08 }
    cylinder { <26,2.5,11>, <27,2.5,11>, 0.04 }
    sphere { <26,2.5,11>, 0.06 }
    cylinder { <26,2.5,11>, <26,2.5,10.75>, 0.06 }
    sphere { <26,2.5,10.75>, 0.06 }
    sphere { <27,2.5,11>, 0.06 }
    cylinder { <27,2.5,11>, <27,2.5,10.75>, 0.06 }
    sphere { <27,2.5,10.75>, 0.06 }

    pigment { Gold }
    texture { T_Gold_3C}
}
union
{   // fenestra fronta sub architrav
    box { <28.0625,8.75,2.725>, <29.9375,6.875,2.775> }
    // fenestra ostiora imitamenta
    box { <28.0625,1.25,2.725>, <29.9375,4.4,2.775> }
    // fenestra media sub architrav
    box { <26.475,8.75,9.0625>, <26.525,6.875,10.9375> }
    // fenestra dextra sub architrav
    box { <26.475,8.75,5.0625>, <26.525,6.875,6.9375> }
    // fenestra sinistra sub architrav
    box { <26.475,8.75,13.0625>, <26.525,6.875,14.9375> }
    // fenestra dextra
    box { <26.475,1.825,5.0625>, <26.525,4.4,6.9375> }
    // fenestra sinistra
    box { <26.475,1.825,13.0625>, <26.525,4.4,14.9375> }
    // fenestra ostiora
    box { <26.475,1.825,9.0625>, <26.525,4.4,10.9375> }

    pigment { Clear }
    finish { reflection 0.4 brilliance 0.8 }
}

union
{   // lapides viae
    box { <19.3,0,19.3>, <39,0.05,33> }
    box { <23.3,0,20>, <34.7,0.05,-0.7> }

    pigment {
        brick Gray25, Khaki
        brick_size <1, 1, 1> mortar 0.02
        rotate y*45
    }
    normal { bumps 0.2 scale 0.25 }
    finish { Shiny }
}
union
{   // lapides viae minor
    box { <16.4,0,-10>, <40,0.04,43> }
    cylinder { <11.25,0,18>, <11.25,0.04,18>, 1.7 }
    box      { <9.55,0,18>, <13.05,0.04,34> }
    cylinder { <11.25,0,34>, <11.25,0.04,34>, 1.7 }
    cylinder { <4.5,0,18>, <4.5,0.04,18>, 1.7 }
    box      { <6.2,0,18>, <2.8,0.04,34> }
    cylinder { <4.5,0,34>, <4.5,0.04,34>, 1.7 }
    box { <16.4,0,-18.2>, <40,0.04,-100> }

    pigment { 
        brick Gray20, Gray50
        brick_size <0.25, 0.25, 0.25> mortar 0.03
        turbulence 0.05
        translate <0.05,0,0.1275>
    }
    normal {
        brick normal {granite 0.2 scale 0.01}, normal {granite 0.2 scale 0.2}
        brick_size <0.25, 0.25, 0.25> mortar 0.03
        turbulence 0.05
        translate <0.05,0,0.1275>
    }

}
union
{   // lapides viae marginae
    box { <19.2,0,19.2>, <39.1,0.0495,33.1> }
    box { <23.2,0,20>, <34.8,0.0495,-0.8> }

    pigment
    {   brick Gray05, Gray40
        brick_size <4,2,4> mortar 0.02
        translate y*0.5
        rotate z*90
    }
    normal { bumps 0.4 scale 0.125 }
}
union
{   // lapides viae minor marginae
    box { <16.2,0,-10.2>, <40.2,0.0399,43.2> }
    cylinder { <11.25,0,18>, <11.25,0.0399,18>, 1.8 }
    box      { <9.45,0,18>, <13.05,0.0399,34> }
    cylinder { <11.25,0,34>, <11.25,0.0399,34>, 1.8 }
    cylinder { <4.5,0,18>, <4.5,0.0399,18>, 1.8 }
    box      { <6.3,0,18>, <2.7,0.0399,34> }
    cylinder { <4.5,0,34>, <4.5,0.0399,34>, 1.8 }
    box { <16.2,0,-18>, <40.2,0.0399,-100> }

    pigment
    {   brick
        pigment { color Gray10 },
        pigment
        {
            granite
            color_map {
            [0.0 rgb <.2, .2, .2> ]
            [0.2 rgb <.5, .5, .5> ]
            [0.2 rgb <.4, .4, .4> ]
            [1.0 rgb <.4, .4, .4> ]
            }
            scale 0.25
        }

        brick_size <4,2,4> mortar 0.02
        translate <0,0.45,0.1>
        rotate z*90
    }
    normal { bumps 1 scale 0.125 }
}




//
// sinistra 
//

object
{   pillar scale <0.8,1,0.8> 
    translate x*-24 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-27 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-31 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-34 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-24 translate z*4 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-34 translate z*4 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-24 translate z*8 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-34 translate z*8 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-24 translate z*12 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-34 translate z*12 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-24 translate z*16 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-34 translate z*16 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-20 translate z*20 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-24 translate z*20 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-29 translate z*20 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-34 translate z*20 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-38 translate z*20 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-24 translate z*24 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-29 translate z*24 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-34 translate z*24 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-38 translate z*24 pigment { DarkKhaki }
}
// object { pillar scale <0.8,1,0.8> translate <-24,0,28> pigment { DarkKhaki }}
// object { pillar scale <0.8,1,0.8> translate <-29,0,28> pigment { DarkKhaki }}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-34 translate z*28 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-38 translate z*28 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-20 translate z*32 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-24 translate z*32 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-29 translate z*32 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-34 translate z*32 pigment { DarkKhaki }
}
object
{   pillar scale <0.8,1,0.8> 
    translate x*-38 translate z*32 pigment { DarkKhaki }
}

difference
{   // aedificium
    box { <-26.25,0,2.5>, <-32.75,10,17> }
    box { <-26.75,0.5,3>, <-32.25,11,16.5> }
    // fenestra fronta sub architrav
    box { <-28.0625,8.75,1>, <-29.9375,6.875,4> }
    // ostium imitamentum
    box { <-27.75,0.5,1>, <-30.25,5,4> }
    // fenestra media sub architrav
    box { <-25,8.75,9.0625>, <-28,6.875,10.9375> }
    // ostium
    box { <-25,0.5,8.75>, <-28,5,11.25> }
    // fenestra dextra sub architrav
    box { <-25,8.75,5.0625>, <-28,6.875,6.9375> }
    // fenestra dextra
    box { <-25,1.875,5.0625>, <-28,4.375,6.9375> }
    // fenestra sinistra sub architrav
    box { <-25,8.75,13.0625>, <-28,6.875,14.9375> }
    // fenestra sinistra
    box { <-25,1.875,13.0625>, <-28,4.375,14.9375> }

    pigment
    {   brick Gray10, DarkKhaki
        brick_size <1.4, 0.65, 1.4> mortar 0.025  translate <0.05,0.3,0>
    }
}

union
{   difference
    {   // intermediate
        box { <-18.5,0,21.5>, <-20.5,11.5,30.5> }
        cylinder { <-20.5,0,26>, <-20.5,5,26>, 1.5 }
        sphere { <-20.5,5,26>, 1.5 }
    }
    box { <-18.5,10.5,21.6>, <-20.5,10.55,30.5> }      // intermediate taenia
    box { <-18.5,11.5,21.9>, <-20.5,11.75,30.9> }      // intermediate geison
    box { <-18.5,11.75,22.0>, <-19.25,12.20,30.0> }    // intermediate scalae
    box { <-18.5,12.20,22.4>, <-19.25,12.55,29.6> }
    box { <-18.5,12.55,22.8>, <-19.25,12.90,29.2> }
    box { <-18.5,12.90,23.2>, <-19.25,13.25,28.8> }
    box { <-18.5,13.25,23.6>, <-19.25,13.60,28.4> }
    box { <-18.5,13.60,24.0>, <-19.25,13.95,28.0> }
    box { <-18.5,13.95,24.4>, <-19.25,14.30,27.6> }
    box { <-18.5,14.30,24.8>, <-19.25,14.65,27.2> }
    box { <-18.5,14.65,25.2>, <-19.25,15.00,26.8> }
    box { <-18.5,15.00,25.6>, <-19.25,15.35,26.4> }
    
    box { <-23.5,10,-0.5>, <-34.5,11.5,20> }           // architrav
    box { <-23.4,10.5,-0.6>, <-34.6,10.55,20> }        // taenia
    box { <-23.1,11.5,-0.9>, <-34.9,11.75,20> }        // geison
    box { <-23.0,11.655,-1>, <-35.0,11.65,20> }        // geison taenia

    box { <-19.5,10,19.5>, <-38.5,11.5,32.5> }         // architrav
    box { <-19.4,10.5,19.4>, <-38.6,10.54,32.6> }      // taenia
    box { <-19.1,11.5,19.1>, <-38.9,11.75,32.9> }      // geison
    box { <-19,11.655,19>, <-39,11.65,33> }            // geison taenia

    pigment { DarkKhaki }
}

union
{   // sima secundus intermediate + aedificium + porticus
    box { <-18.5,12.20,22.0>, <-19.26,12.201,22.39> }
    box { <-18.5,12.20,29.6>, <-19.26,12.201,30.01> }
    box { <-18.5,12.55,22.4>, <-19.26,12.551,22.79> }
    box { <-18.5,12.55,29.2>, <-19.26,12.551,29.61> }
    box { <-18.5,12.90,22.8>, <-19.26,12.901,23.19> }
    box { <-18.5,12.90,28.8>, <-19.26,12.901,29.21> }
    box { <-18.5,13.25,23.2>, <-19.26,13.251,23.59> }
    box { <-18.5,13.25,28.4>, <-19.26,13.251,28.81> }
    box { <-18.5,13.60,23.6>, <-19.26,13.601,23.99> }
    box { <-18.5,13.60,28.0>, <-19.26,13.601,28.41> }
    box { <-18.5,13.95,24.0>, <-19.26,13.951,24.39> }
    box { <-18.5,13.95,27.6>, <-19.26,13.951,28.01> }
    box { <-18.5,14.30,24.4>, <-19.26,14.301,24.79> }
    box { <-18.5,14.30,27.2>, <-19.26,14.301,27.61> }
    box { <-18.5,14.65,24.8>, <-19.26,14.651,25.19> }
    box { <-18.5,14.65,26.8>, <-19.26,14.651,27.21> }
    box { <-18.5,15.00,25.2>, <-19.26,15.001,25.59> }
    box { <-18.5,15.00,26.4>, <-19.26,15.001,26.81> }
    box { <-18.5,15.35,25.59>,<-19.26,15.351,26.41> }

    box { <-24,11.76,-0.915>, <-34,11.75,20> }
    box { <-19.01,11.76,20>, <-38.91,11.75,32> }

    pigment { PaleGreen }
}

difference
{   // sima + tympanon aedificium
    union
    {
        box { <-23.5,9,-0.5>, <-34.5,11.5,26> pigment { DarkKhaki } }
        box { <-23.1,11.5,-0.9>, <-34.9,11.75,26> pigment { DarkKhaki } }
        box { <-23,11.65,-1>, <-35,11.655,26> pigment { DarkKhaki } }
        difference
        {
            cylinder { <-23,11.925,-0.9>, <-35,11.925,-0.9>, 0.2 }
            box { <-22,11.925,-2>, <-36,14,0> }
            pigment { DarkKhaki }
        }
        difference
        {
            cylinder { <-23.1,11.925,-0.9>, <-23.1,11.925,26>, 0.2 }
            box { <-22,11.925,-2>, <-36,14,27> }
            pigment { DarkKhaki }
        }
        intersection
        {
            difference
            {
                cylinder { <-21,11.925,-0.9>, <-35,11.925,-0.9>, 0.2 }
                box { <-20,11.925,-2>, <-36,14,0> }
            }
            difference
            {
                cylinder { <-23.1,11.925,-3>, <-23.1,11.925,26>, 0.2 }
                box { <-22,11.925,-2>, <-36,14,27> }
            }
            pigment { DarkKhaki }
        }

        box { <-22.75,11.925,-1.15>, <-35.15,11.93,26> pigment { PaleGreen } }
        #declare i=-1;
        #while (i<26)
        box { <-23.1,11.925,i>, <-34.9,11.95,i+0.002> pigment { PaleGreen4 } }
        #declare i=i+1;
        #end
        // box { <-23.002,11.925,-0.5>,<-23.004,11.95,26> pigment { PaleGreen4 } }

        translate <23,-10,0> rotate z*-15 translate <-23.5,10,0>
    }
    box { <10,11.5,-10>, <-50,0,50> pigment { Clear } }
    box { <-29,11,-5>, <-50,22,50> pigment { Clear } }
}

difference
{   // sima + tympanon aedificium
    union
    {
        box { <-23.5,9,-0.5>, <-34.5,11.5,26> pigment { DarkKhaki } }
        box { <-23.1,11.5,-0.9>, <-34.9,11.75,26> pigment { DarkKhaki } }
        box { <-23,11.65,-1>, <-35,11.655,26> pigment { DarkKhaki } }
        difference
        {
            cylinder { <-23,11.925,-0.9>, <-35,11.925,-0.9>, 0.2 }
            box { <-22,11.925,-2>, <-36,14,0> }
            pigment { DarkKhaki }
        }
        difference
        {
            cylinder { <-34.9,11.925,-0.9>, <-34.9,11.925,26>, 0.2 }
            box { <-22,11.925,-2>, <-36,14,27> }
            pigment { DarkKhaki }
        }
        intersection
        {
            difference
            {
                cylinder { <-23,11.925,-0.9>, <-37,11.925,-0.9>, 0.2 }
                box { <-20,11.925,-2>, <-36,14,0> }
            }
            difference
            {
                cylinder { <-34.9,11.925,-3>, <-34.9,11.925,26>, 0.2 }
                box { <-22,11.925,-2>, <-36,14,27> }
            }
            pigment { DarkKhaki }
        }

        box { <-22.75,11.925,-1.15>, <-35.15,11.93,26> pigment { PaleGreen } }
        #declare i=-1;
        #while (i<26)
        box { <-23,11.925,i>, <-34.9,11.95,i+0.002> pigment { PaleGreen4 } }
        #declare i=i+1;
        #end
        // box { <-35.002,11.925,-0.5>,<-35.004,11.95,26> pigment { PaleGreen4 } }

        translate <35,-10,0> rotate z*15 translate <-34.5,10,0>
    }
    box { <10,11.5,-10>, <-50,0,50> pigment { Clear } }
    box { <-29,11,-5>, <0,22,30> pigment { Clear } }
}

height_field {
    gif "relief1.gif"
    smooth
    pigment { SlightlyDarkerKhaki }
    // normal { bumps 0.7 scale 2 }
    // finish { diffuse .4 }
    scale <1.2,0.1,1.2>
    translate <-0.5,0,-0.5>
    rotate x*-90
    translate <29,12.355,-0.475>
}

difference
{   // sima + tympanon porticus
    union
    {
        box { <-19.5,10,19.5>, <-38.5,11.5,32.5> pigment { DarkKhaki } }
        box { <-19.1,11.5,19.1>, <-38.9,11.75,32.9> pigment { DarkKhaki } }
        difference
        {
            cylinder { <-19.1,11.925,19.1>, <-38.9,11.925,19.1>, 0.2 }
            box { <-18,11.925,10>, <-40,14,20> }
            pigment { DarkKhaki }
        }
        difference
        {
            cylinder { <-19.1,11.925,19.1>, <-19.1,11.925,32.9>, 0.2 }
            box { <-10,11.925,-2>, <-36,14,40> }
            pigment { DarkKhaki }
        }
        difference
        {
            cylinder { <-38.9,11.925,19.1>, <-38.9,11.925,32.9>, 0.2 }
            box { <-10,11.925,-2>, <-40,14,34> }
            pigment { DarkKhaki }
        }
        intersection
        {
            difference
            {
                cylinder { <-18,11.925,19.1>, <-38.9,11.925,19.1>, 0.2 }
                box { <-19,11.925,10>, <-40,14,20> }
            }
            difference
            {
                cylinder { <-19.1,11.925,18>, <-19.1,11.925,32.9>, 0.2 }
                box { <-10,11.925,-2>, <-36,14,34> }
            }
            pigment { DarkKhaki }
        }
        intersection
        {
            difference
            {
                cylinder { <-19.1,11.925,19.1>, <-40,11.925,19.1>, 0.2 }
                box { <-19,11.925,10>, <-41,14,20> }
            }
            difference
            {
                cylinder { <-38.9,11.925,18>, <-38.9,11.925,32.9>, 0.2 }
                box { <-10,11.925,-2>, <-41,14,34> }
            }
            pigment { DarkKhaki }
        }

        box { <-18.85,11.925,18.85>, <-39.15,11.93,33.15> pigment { PaleGreen } }
        #declare i=-19;
        #while (i>-40)
        box { <i,11.925,19.1>, <i+0.002,11.96,32.9> pigment { PaleGreen4 } }
        #declare i=i-1;
        #end
        // box { <-19,11.925,19>, <-39,11.96,19.002> pigment { PaleGreen4 } }

        translate <0,-10,-19> rotate x*-13.25 translate <0,10,19.5>
    }
    box { <10,11.5,-10>, <-50,0,50> pigment { Clear } }
    box { <-10,11,26>, <-40,22,40> pigment { Clear } }
}

difference
{   // sima + tympanon porticus
    union
    {
        box { <-19.5,10,19.5>, <-38.5,11.5,32.5> pigment { DarkKhaki } }
        box { <-19.1,11.5,19.1>, <-38.9,11.75,32.9> pigment { DarkKhaki } }
        difference
        {
            cylinder { <-19.1,11.925,32.9>, <-38.9,11.925,32.9>, 0.2 }
            box { <-18,11.925,10>, <-40,14,40> }
            pigment { DarkKhaki }
        }
        difference
        {
            cylinder { <-19.1,11.925,19.1>, <-19.1,11.925,32.9>, 0.2 }
            box { <-10,11.925,-2>, <-36,14,40> }
            pigment { DarkKhaki }
        }
        difference
        {
            cylinder { <-38.9,11.925,19.1>, <-38.9,11.925,32.9>, 0.2 }
            box { <-10,11.925,-2>, <-40,14,34> }
            pigment { DarkKhaki }
        }
        intersection
        {
            difference
            {
                cylinder { <-18,11.925,32.9>, <-38.9,11.925,32.9>, 0.2 }
                box { <-19,11.925,10>, <-40,14,40> }
            }
            difference
            {
                cylinder { <-19.1,11.925,18>, <-19.1,11.925,34>, 0.2 }
                box { <-10,11.925,-2>, <-36,14,34> }
            }
            pigment { DarkKhaki }
        }
        intersection
        {
            difference
            {
                cylinder { <-19.1,11.925,32.9>, <-40,11.925,32.9>, 0.2 }
                box { <-19,11.925,10>, <-41,14,40> }
            }
            difference
            {
                cylinder { <-38.9,11.925,18>, <-38.9,11.925,34>, 0.2 }
                box { <-10,11.925,-2>, <-41,14,34> }
            }
            pigment { DarkKhaki }
        }

        box { <-18.85,11.925,18.85>, <-39.15,11.93,33.15> pigment { PaleGreen } }
        #declare i=-19;
        #while (i>-40)
        box { <i,11.925,19.1>, <i+0.002,11.96,32.9> pigment { PaleGreen4 } }
        #declare i=i-1;
        #end
        // box { <-19,11.925,33>, <-39,11.96,33.002> pigment { PaleGreen4 } }

        translate <0,-10,-33> rotate x*13.25 translate <0,10,32.5>
    }
    box { <10,11.5,-10>, <-50,0,50> pigment { Clear } }
    box { <-10,11,26>, <-40,22,0> pigment { Clear } }
}

#declare i=-24;
#while (i>-35)
object { triglyph translate <i,10.45,-0.7> }
#declare i=i-1;
#end
#declare i=0;
#while (i<20)
object { triglyph rotate y*90 translate <-34.7,10.45,i> }
object { triglyph rotate y*-90 translate <-23.3,10.45,i> }
#declare i=i+1;
#end
#declare i=-20;
#while (i>-24)
object { triglyph translate <i,10.45,19.3> }
#declare i=i-1;
#end
#declare i=-35;
#while (i>-39)
object { triglyph translate <i,10.45,19.3> }
#declare i=i-1;
#end
#declare i=20;
#while (i<33)
object { triglyph rotate y*90 translate <-38.7,10.45,i> }
object { triglyph rotate y*-90 translate <-19.3,10.45,i> }
#declare i=i+1;
#end
#declare i=-20;
#while (i>-39)
object { triglyph rotate y*180 translate <i,10.45,32.7> }
#declare i=i-1;
#end

union
{   // ostium imitamentum
    difference
    {
        box { <-27.75,0,2.6>, <-30.25,5,2.9> }
        box { <-28.0625,1.25,1>, <-29.9375,4.4,3> }
    }
    box { <-27.75,0,2.475>, <-30.25,0.5001,3> }
    box { <-27.75,0,2.45>, <-27.95,5,3> }
    box { <-30.25,0,2.45>, <-30.05,5,3> }
    box { <-30.25,5,2.45>, <-27.95,4.5,3> }
    box { <-30.25,5,2.415>, <-30.05,4.25,3> }
    box { <-27.75,5,2.415>, <-27.95,4.25,3> }
    box { <-27.625,5,2.3>, <-30.375,5.2,3> }
    box { <-27.55,5.2,2.25>, <-30.45,5.25,3> }
    // ostium
    box { <-25.75,0,8.95>, <-26.5,0.5001,11.05> }
    box { <-25.95,0,8.75>, <-26.5,5,8.95> }
    box { <-25.95,0,11.05>, <-26.5,5,11.25> }
    box { <-25.95,4.5,8.75>, <-26.5,5,11.25> }
    box { <-25.925,4.2,8.75>, <-26.5,5,8.95> }
    box { <-25.925,4.2,11.05>, <-26.5,5,11.25> }
    box { <-25.8,5,8.625>, <-26.5,5.2,11.325> }
    box { <-25.8,5.2,8.625>, <-26.5,5.25,11.325> }
    box { <-25.75,5.2,8.5>, <-26.5,5.25,11.45> }

    pigment { SandStone }
}
object
{   // sima ostiorum imitamentorum
    box { <-27.53,5.25,2.225>, <-30.47,5.26,3> }
    pigment { PaleGreen }
}

union
{   // fenestra fronta sub architrav
    difference
    {
        box { <-28.0625,8.75,2.6>, <-29.9375,6.875,2.9> }
        box { <-29.09375,8.65625,2.5>, <-29.84375,6.96875,3> }
        box { <-28.15625,8.65625,2.5>, <-28.90625,6.96875,3> }
    }
    box { <-28.50,8.75,2.7>, <-28.55,6.875,2.8> }
    box { <-29.45,8.75,2.7>, <-29.50,6.875,2.8> }
    box { <-28.0625,7.475,2.7>, <-29.9375,7.525,2.8> }
    box { <-28.0625,8.10,2.7>, <-29.9375,8.15,2.8> }
    // fenestra ostiora imitamenta
    difference
    {
        box { <-28.0625,1.25,2.6>, <-29.9375,4.4,2.9> }
        box { <-29.09375,4.3,3>, <-29.84375,3.228,2> }
        box { <-28.15625,4.3,3>, <-28.90625,3.228,2> }
        box { <-29.09375,3.052,3>, <-29.84375,1.35,2> }
        box { <-28.15625,3.052,3>, <-28.90625,1.35,2> }
    }
    box { <-28.50,1.25,2.7>, <-28.55,4.4,2.8> }
    box { <-29.45,1.25,2.7>, <-29.50,4.4,2.8> }
    box { <-28.0625,1.85,2.7>, <-29.9375,1.9,2.8> }
    box { <-28.0625,2.5,2.7>, <-29.9375,2.55,2.8> }
    box { <-28.0625,3.8,2.7>, <-29.9375,3.75,2.8> }
    // fenestra dextra sub architrav
    difference
    {
        box { <-26.35,8.75,5.0625>, <-26.65,6.875,6.9375> }
        box { <-26,8.65625,5.15625>, <-27,6.96875,5.90625> }
        box { <-26,8.65625,6.09375>, <-27,6.96875,6.84375> }
    }
    box { <-26.45,8.75,5.50>, <-26.55,6.875,5.55> }
    box { <-26.45,8.75,6.50>, <-26.55,6.875,6.45> }
    box { <-26.45,7.475,5.0625>, <-26.55,7.525,6.9375> }
    box { <-26.45,8.10,5.0625>, <-26.55,8.15,6.9375> }
    // fenestra media sub architrav
    difference
    {
        box { <-26.35,8.75,9.0625>, <-26.65,6.875,10.9375> }
        box { <-26,8.65625,9.15625>, <-27,6.96875,9.90625> }
        box { <-26,8.65625,10.09375>, <-27,6.96875,10.84375> }
    }
    box { <-26.45,8.75,9.50>, <-26.55,6.875,9.55> }
    box { <-26.45,8.75,10.50>, <-26.55,6.875,10.45> }
    box { <-26.45,7.475,9.0625>, <-26.55,7.525,10.9375> }
    box { <-26.45,8.10,9.0625>, <-26.55,8.15,10.9375> }
    // fenestra sinistra sub architrav
    difference
    {
        box { <-26.35,8.75,13.0625>, <-26.65,6.875,14.9375> }
        box { <-26,8.65625,13.15625>, <-27,6.96875,13.90625> }
        box { <-26,8.65625,14.09375>, <-27,6.96875,14.84375> }
    }
    box { <-26.45,8.75,13.50>, <-26.55,6.875,13.55> }
    box { <-26.45,8.75,14.50>, <-26.55,6.875,14.45> }
    box { <-26.45,7.475,13.0625>, <-26.55,7.525,14.9375> }
    box { <-26.45,8.10,13.0625>, <-26.55,8.15,14.9375> }
    // fenestra dextra
    difference
    {
        box { <-26.35,4.4,5.0625>, <-26.65,1.875,6.9375> }
        box { <-26,4.3,5.15625>, <-27,3.225,5.90625> }
        box { <-26,3.05,5.15625>, <-27,1.975,5.90625> }
        box { <-26,4.3,6.09375>, <-27,3.225,6.84375> }
        box { <-26,3.05,6.09375>, <-27,1.975,6.84375> }
    }
    box { <-26.45,4.4,5.50>, <-26.55,1.875,5.55> }
    box { <-26.45,4.4,6.50>, <-26.55,1.875,6.45> }
    box { <-26.45,2.525,5.0625>, <-26.55,2.475,6.9375> }
    box { <-26.45,3.80,5.0625>, <-26.55,3.75,6.9375> }
    // fenestra sinistra
    difference
    {
        box { <-26.35,4.4,13.0625>, <-26.65,1.875,14.9375> }
        box { <-26,4.3,13.15625>, <-27,3.225,13.90625> }
        box { <-26,3.05,13.15625>, <-27,1.975,13.90625> }
        box { <-26,4.3,14.09375>, <-27,3.225,14.84375> }
        box { <-26,3.05,14.09375>, <-27,1.975,14.84375> }
    }
    box { <-26.45,4.4,13.50>, <-26.55,1.875,13.55> }
    box { <-26.45,4.4,14.50>, <-26.55,1.875,14.45> }
    box { <-26.45,2.525,13.0625>, <-26.55,2.475,14.9375> }
    box { <-26.45,3.80,13.0625>, <-26.55,3.75,14.9375> }

    // ostium
    difference
    {
        box { <-26.35,4.5,8.9>, <-26.65,0.5,11.1> }
        box { <-26,4.3,9.15625>, <-27,3.225,9.90625> }
        box { <-26,3.05,9.15625>, <-27,1.975,9.90625> }
        box { <-26,4.3,10.09375>, <-27,3.225,10.84375> }
        box { <-26,3.05,10.09375>, <-27,1.975,10.84375> }
    }
    box { <-26.45,4.4,9.50>, <-26.55,1.875,9.55> }
    box { <-26.45,4.4,10.50>, <-26.55,1.875,10.45> }
    box { <-26.45,2.525,9.0625>, <-26.55,2.475,10.9375> }
    box { <-26.45,3.80,9.0625>, <-26.55,3.75,10.9375> }
    difference
    {
        box { <-26.25,1.8,9.15625>,<-26.75,0.675,10.84375> }
        box { <-25,1.75,9.20625>,<-27,0.725,10.79375> }
    }
    box { <-26.25,0.55,8.9>,<-26.75,0.5,11.1> }

    pigment { DarkBrown }
}
union
{   // ansa
    cylinder { <-26.25,2.5,11>, <-26.75,2.5,11>, 0.08 }
    cylinder { <-26,2.5,11>, <-27,2.5,11>, 0.04 }
    sphere { <-26,2.5,11>, 0.06 }
    cylinder { <-26,2.5,11>, <-26,2.5,10.75>, 0.06 }
    sphere { <-26,2.5,10.75>, 0.06 }
    sphere { <-27,2.5,11>, 0.06 }
    cylinder { <-27,2.5,11>, <-27,2.5,10.75>, 0.06 }
    sphere { <-27,2.5,10.75>, 0.06 }

    pigment { Gold }
    texture { T_Gold_3C}
}
union
{   // fenestra fronta sub architrav
    box { <-28.0625,8.75,2.725>, <-29.9375,6.875,2.775> }
    // fenestra ostiora imitamenta
    box { <-28.0625,1.25,2.725>, <-29.9375,4.4,2.775> }
    // fenestra media sub architrav
    box { <-26.475,8.75,9.0625>, <-26.525,6.875,10.9375> }
    // fenestra dextra sub architrav
    box { <-26.475,8.75,5.0625>, <-26.525,6.875,6.9375> }
    // fenestra sinistra sub architrav
    box { <-26.475,8.75,13.0625>, <-26.525,6.875,14.9375> }
    // fenestra dextra
    box { <-26.475,1.825,5.0625>, <-26.525,4.4,6.9375> }
    // fenestra sinistra
    box { <-26.475,1.825,13.0625>, <-26.525,4.4,14.9375> }
    // fenestra ostiora
    box { <-26.475,1.825,9.0625>, <-26.525,4.4,10.9375> }

    pigment { Clear }
    finish { reflection 0.4 brilliance 0.8 }
}

union
{   // lapides viae
    box { <-19.3,0,19.3>, <-39,0.05,33> }
    box { <-23.3,0,20>, <-34.7,0.05,-0.7> }

    pigment {
        brick Gray25, Khaki
        brick_size <1, 1, 1> mortar 0.02
        rotate y*45
    }
    normal { bumps 0.2 scale 0.25 }
    finish { Shiny }
}
union
{   // lapides viae minor
    box { <-16.4,0,-10>, <-40,0.04,43> }
    cylinder { <-11.25,0,20>, <-11.25,0.04,20>, 1.7 }
    box      { <-9.55,0,20>, <-12.95,0.04,32> }
    cylinder { <-11.25,0,32>, <-11.25,0.04,32>, 1.7 }
    cylinder { <-4.5,0,20>, <-4.5,0.04,20>, 1.7 }
    box      { <-6.2,0,20>, <-2.8,0.04,32> }
    cylinder { <-4.5,0,32>, <-4.5,0.04,32>, 1.7 }
    box { <-16.4,0,-18.2>, <-40,0.04,-100> }

    cylinder { <0,0,0>, <0,0.04,0>, 7 }

    pigment {
        brick Gray20, Gray50
        brick_size <0.25, 0.25, 0.25> mortar 0.03
        turbulence 0.05
    }
    normal { granite 0.25 scale 0.05 }
}
union
{   // lapides viae marginae
    box { <-19.2,0,19.2>, <-39.1,0.0495,33.1> }
    box { <-23.2,0,20>, <-34.8,0.0495,-0.8> }

    pigment
    {   brick Gray05, Gray40
        brick_size <4,2,4> mortar 0.02
        translate y*0.5
        rotate z*90
    }
    normal { bumps 0.4 scale 0.125 }
}
union
{   // lapides viae minor marginae
    box { <-16.2,0,-10.2>, <-40.2,0.0399,43.2> }
    cylinder { <-11.25,0,18>, <-11.25,0.0399,18>, 1.8 }
    box      { <-9.45,0,18>, <-13.05,0.0399,34> }
    cylinder { <-11.25,0,34>, <-11.25,0.0399,34>, 1.8 }
    cylinder { <-4.5,0,18>, <-4.5,0.0399,18>, 1.8 }
    box      { <-6.3,0,18>, <-2.7,0.0399,34> }
    cylinder { <-4.5,0,34>, <-4.5,0.0399,34>, 1.8 }
    box { <-16.2,0,-18>, <-40.2,0.0399,-100> }

    cylinder { <0,0,0>, <0,0.04,0>, 7.1 }

    pigment
    {   brick Gray10, Gray40
        brick_size <4,2,4> mortar 0.02
        translate <0,0.55,0.1>
        rotate z*90
    }
    normal { bumps 1 scale 0.125 }
}
union
{   // viae signiae
    box { <23,0,-10>, <23.5,0.001,-14> }
    box { <-23,0,-14>, <-23.5,0.001,-18> }

    #declare i=0;
    #while (i<360)
    box { <0.4,0,15.5>, <-0.4,0.001,15.7> rotate y*i }
    #declare i=i+6;
    #end
    #declare i=0;
    #while (i<360)
    box { <0.4,0,11.0>, <-0.4,0.001,11.2> rotate y*i }
    #declare i=i+12;
    #end

    pigment { White }
    normal { bumps 0.2 scale 0.25 }
    finish { ambient 0.3 }
}
union
{   // viae signiae invalidae
    box { <19,0,-10>, <19.5,0.001,-14> }
    box { <-19,0,-14>, <-19.5,0.001,-18> }
    box { <28,0,-10>, <28.5,0.001,-14> }
    box { <-28,0,-14>, <-28.5,0.001,-18> }

    box { <-0.125,0,15>, <0.125,0.001,-15> rotate y*-45 translate <16,0,-20> }
    box { <-0.125,0,15>, <0.125,0.001,-15> rotate y*-45 translate <20,0,-20> }
    box { <-0.125,0,15>, <0.125,0.001,-15> rotate y*-45 translate <28,0,-20> }
    box { <-0.125,0,15>, <0.125,0.001,-15> rotate y*-45 translate <32,0,-20> }

    pigment { Gray60 }
    normal { bumps 0.2 scale 0.25 }
}



//
// Quadriga
// 

#declare victory_pole =
union
{
    #declare i=0;
    #while (i<360)
    cylinder
    {   <-0.0075,0,0>, <0.0075,0,0>, 0.25
        scale <1,0.33,1> rotate y*10 translate 0.5*y rotate x*i
    }
    #declare i=i+10;
    #end
    cylinder { <0,-0.5,0>, <0,-7,0>, 0.04 }
    translate y*7
}
#declare iron_cross =
union
{
    difference
    { 
        box { <-0.0125,0.5,0.5>, <0.0125,-0.5,-0.5> }
        cylinder { <-0.2,0,0.8>, <0.2,0,0.8>, 0.75 }
        cylinder { <-0.2,0,-0.8>, <0.2,0,-0.8>, 0.75 }
    }
    difference
    { 
        box { <-0.0125,0.5,0.5>, <0.0125,-0.5,-0.5> }
        cylinder { <-0.2,0,0.8>, <0.2,0,0.8>, 0.75 }
        cylinder { <-0.2,0,-0.8>, <0.2,0,-0.8>, 0.75 }

        rotate x*90
    }
    translate y*7
}
#declare geier =
union
{
    sphere { x*0,1 scale <0.05,0.5,0.1> }
    sphere { x*0,1 scale <0.06,0.06,0.06> translate <0,0.45,0.05> }
    cone { <0,0,0>, 0.05, <0,-0.06,0.1>, 0.0001 translate <0,0.45,0.05> }
    cone { <0,0,0>, 0.03, <0,0.08,0>, 0.05 open translate <0,0.45,0.05> }
    cylinder { <0,0.25,0.35>, <0,0.25,-0.35>, 0.05 scale <0.1,1,1> }
    sphere { <0,0.25,0.35>, 0.05 scale <0.1,1,1> }
    sphere { <0,0.25,-0.35>, 0.05 scale <0.1,1,1> }
    cylinder { <0,0.25,0.35>, <0,0.75,0.4>, 0.05 scale <0.1,1,1> }
    sphere { <0,0.75,0.4>, 0.04 scale <0.1,1,1> }
    cylinder { <0,0.25,-0.35>, <0,0.75,-0.4>, 0.05 scale <0.1,1,1> }
    sphere { <0,0.75,-0.4>, 0.05 scale <0.1,1,1> }
    sphere { x*0,1 scale<0.01,0.2,0.05> translate <0,0.07,0.10> }
    sphere { x*0,1 scale<0.01,0.2,0.05> translate <0,0.07,0.15> }
    sphere { x*0,1 scale<0.01,0.2,0.05> translate <0,0.07,0.20> }
    sphere { x*0,1 scale<0.01,0.2,0.05> translate <0,0.07,0.25> }
    sphere { x*0,1 scale<0.01,0.2,0.05> translate <0,0.07,0.30> }
    sphere { x*0,1 scale<0.01,0.2,0.05> rotate x*-15  translate <0,0.07,0.325> }
    sphere { x*0,1 scale<0.01,0.2,0.05> rotate x*-30  translate <0,0.12,0.350> }
    sphere { x*0,1 scale<0.01,0.2,0.05> rotate x*-45  translate <0,0.17,0.375> }
    sphere { x*0,1 scale<0.01,0.2,0.05> rotate x*-60  translate <0,0.22,0.400> }
    sphere { x*0,1 scale<0.01,0.2,0.05> rotate x*-75  translate <0,0.27,0.425> }
    sphere { x*0,1 scale<0.01,0.2,0.05> rotate x*-90  translate <0,0.32,0.450> }
    sphere { x*0,1 scale<0.01,0.2,0.05> rotate x*-105 translate <0,0.37,0.475> }
    sphere { x*0,1 scale<0.01,0.2,0.05> rotate x*-120 translate <0,0.42,0.500> }
    sphere { x*0,1 scale<0.01,0.22,0.05> rotate x*-120 translate <0,0.52,0.52> }
    sphere { x*0,1 scale<0.01,0.24,0.05> rotate x*-120 translate <0,0.62,0.54> }
    sphere { x*0,1 scale<0.01,0.26,0.05> rotate x*-120 translate <0,0.72,0.56> }
    sphere { x*0,1 scale<0.01,0.28,0.05> rotate x*-120 translate <0,0.82,0.58> }
    sphere { x*0,1 scale<0.01,0.30,0.05> rotate x*-120 translate <0,0.92,0.60> }

    sphere { x*0,1 scale<0.01,0.2,0.05> translate <0,0.07,-0.10> }
    sphere { x*0,1 scale<0.01,0.2,0.05> translate <0,0.07,-0.15> }
    sphere { x*0,1 scale<0.01,0.2,0.05> translate <0,0.07,-0.20> }
    sphere { x*0,1 scale<0.01,0.2,0.05> translate <0,0.07,-0.25> }
    sphere { x*0,1 scale<0.01,0.2,0.05> translate <0,0.07,-0.30> }
    sphere { x*0,1 scale<0.01,0.2,0.05> rotate x*15  translate <0,0.07,-0.325> }
    sphere { x*0,1 scale<0.01,0.2,0.05> rotate x*30  translate <0,0.12,-0.350> }
    sphere { x*0,1 scale<0.01,0.2,0.05> rotate x*45  translate <0,0.17,-0.375> }
    sphere { x*0,1 scale<0.01,0.2,0.05> rotate x*60  translate <0,0.22,-0.400> }
    sphere { x*0,1 scale<0.01,0.2,0.05> rotate x*75  translate <0,0.27,-0.425> }
    sphere { x*0,1 scale<0.01,0.2,0.05> rotate x*90  translate <0,0.32,-0.450> }
    sphere { x*0,1 scale<0.01,0.2,0.05> rotate x*105 translate <0,0.37,-0.475> }
    sphere { x*0,1 scale<0.01,0.2,0.05> rotate x*120 translate <0,0.42,-0.500> }
    sphere { x*0,1 scale<0.01,0.22,0.05> rotate x*120 translate <0,0.52,-0.52> }
    sphere { x*0,1 scale<0.01,0.24,0.05> rotate x*120 translate <0,0.62,-0.54> }
    sphere { x*0,1 scale<0.01,0.26,0.05> rotate x*120 translate <0,0.72,-0.56> }
    sphere { x*0,1 scale<0.01,0.28,0.05> rotate x*120 translate <0,0.82,-0.58> }
    sphere { x*0,1 scale<0.01,0.30,0.05> rotate x*120 translate <0,0.92,-0.60> }

 translate y*7.9
}

#declare horse_torso =
union
{
    sphere { 0*x, 1 scale <0.2, 0.5, 0.45> translate <0.15,2,0> }
    sphere { 0*x, 1 scale <0.3, 0.45, 0.6> translate <0,2.00,0.35> }
    sphere { 0*x, 1 scale <0.2, 0.45, 0.45> translate <-0.15,2,0> }
    sphere { 0*x, 1 scale <0.25, 0.51, 0.475> translate <0.125,2,1.6> }
    sphere { 0*x, 1 scale <0.25, 0.51, 0.475> translate <-0.125,2,1.6> }

    sphere { 0*x, 1 scale <0.3, 0.45, 0.45> translate <0,1.95,0> }
    cone { <0,1.95,0>, 0.45, <0,2.1,1.5>, 0.4 scale <0.5, 1, 1> }
    sphere { 0*x, 1 scale <0.35, 0.475, 0.475> translate <0,2.025,1.5> }
}
#declare horse_straight_foreleg =
union
{
    sphere { 0*x, 1 scale <0.2, 0.45, 0.225> translate <0,1.75,0> }
    cone { <0,1.7,0>, 0.17, <0,0.9,0> 0.09 }
    sphere { 0*x, 1 scale <0.12, 0.17, 0.12> translate <0,0.9,0> }
    cone { <0,0.9,0>, 0.11, <0,0.25,0> 0.075 }
    sphere { 0*x, 1 scale <0.105, 0.135, 0.105> translate <0,0.25,0> }
    difference 
    {   // hoof
        cone { <0,0.25,0>, 0.075, <0,-0.1,-0.1> 0.2 }
        cylinder { <0,0.5,0.55>, <0,0,0.55> 0.55 }
        box { <0.6,0,0.6>, <-0.6,-1,-0.6> }
    }
    scale <0.75,1,0.95>
}
#declare horse_bowed_foreleg =
union
{
    sphere
    {
        0*x, 1 scale <0.2, 0.45, 0.225> rotate x*60 translate <0,1.7,0.1>
    }
    cone { <0,1.65,0.1>, 0.17, <0,1.35,-0.85> 0.09 }
    sphere { 0*x, 1 scale <0.12, 0.12, 0.12> translate <0,1.35,-0.85> }
    cone { <0,1.35,-0.85>, 0.11, <0,0.7,-0.75> 0.075 }
    sphere { 0*x, 1 scale <0.105, 0.135, 0.105> translate <0,0.7,-0.75> }
    difference 
    {   // hoof
        cone { <0,0.25,0>, 0.075, <0,-0.1,-0.1> 0.2 }
        cylinder { <0,0.5,0.55>, <0,0,0.55> 0.55 }
        box { <0.6,0,0.6>, <-0.6,-1,-0.6> }

        rotate x*-45 translate <0,0.5,-0.55>
    }
    scale <0.75,1,0.95>
}
#declare horse_straight_backleg =
union
{
    sphere { 0*x, 1 scale <0.275, 0.45, 0.3> translate <0,1.85,0> }
    cone { <0,1.85,0>, 0.28, <0,1.35,0.15>, 0.15 }
    sphere { 0*x, 1 scale <0.15, 0.15, 0.15> translate <0,1.35,0.15> }
    cone { <0,1.35,0.15>, 0.15, <0,1.125,0.35>, 0.1 }
    sphere { 0*x, 1 scale <0.125, 0.15, 0.125> translate <0,1.125,0.35> }
    cone { <0,1.125,0.35>, 0.115, <0,0.25,-0.05>, 0.085 }
    sphere { 0*x, 1 scale <0.11, 0.125, 0.11> translate <0,0.25,-0.05> }
    difference
    {   // hoof
        cone { <0,0.25,-0.05>, 0.075, <0,-0.1,0> 0.22 }
        cylinder { <0,0.5,0.6>, <0,0,0.6> 0.55 }
        box { <0.6,0,0.6>, <-0.6,-1,-0.6> }
    }
    scale <0.75,1,0.95>
}
#declare horse_tail =
union
{
    cone { <0,2.2,1.75>, 0.075, <0,2.3,2> 0.1 }
    sphere { <0,2.3,2>, 0.1 }
    cone { <0,2.3,2> 0.1, <0,2.3,2.2>, 0.115 }

    scale <0.6,1,1>
}
#declare horse_head =
union
{
    union
    {
        cone { <0,2,0.15>, 0.6, <0,2.5,-0.1>, 0.4 }
        sphere { <0,2.5,-0.1>, 0.385 }
        cone { <0,2.5,-0.1>, 0.375, <0,2.8,-0.4>, 0.25 }
        sphere { <0,2.8,-0.4>, 0.245 }
        cone { <0,2.8,-0.4>, 0.25, <0,2.8,-0.5>, 0.225 }
        sphere { <0,2.8,-0.5>, 0.220 }
        cone { <0,2.8,-0.5>, 0.225, <0,2.85,-0.6>, 0.2125 }
        sphere { <0,2.85,-0.6>, 0.2125 }
        cone { <0,2.85,-0.6>, 0.2125, <0,2.85,-0.7>, 0.2 }

        scale <0.4,1,1>
    }
    union
    {
        cone { <0,2,0.15>, 0.6, <0,2.5,-0.1>, 0.4 }
        sphere { <0,2.5,-0.1>, 0.385 }
        cone { <0,2.5,-0.1>, 0.375, <0,2.8,-0.4>, 0.25 }
        sphere { <0,2.8,-0.4>, 0.245 }
        cone { <0,2.8,-0.4>, 0.25, <0,2.8,-0.5>, 0.225 }
        sphere { <0,2.8,-0.5>, 0.220 }
        cone { <0,2.8,-0.5>, 0.225, <0,2.85,-0.6>, 0.2125 }
        sphere { <0,2.85,-0.6>, 0.2125 }
        cone { <0,2.85,-0.6>, 0.2125, <0,2.85,-0.7>, 0.2 }
        sphere { <0,2.85,-0.7>, 0.195 }

        scale <0.04,1,1> translate <0,0.1,0.075>
    }
    sphere { 0*x, 0.15 scale <0.85,1,1> translate <0,2.9,-0.7125> }
    sphere { 0*x, 0.15 scale <0.9,1.115,1.125> translate <0,2.8,-0.65> }
    cone { <0,2.925,-0.7>, 0.15, <0,2.45,-0.8>, 0.09 scale <0.775,1,1> }
    difference
    {   // nose
        sphere { 0*x, 1 scale <0.075,0.07,0.09> translate <0,2.45,-0.8> }
        sphere { 0*x, 1 scale <0.02,0.2,0.02> translate <0.05,2.45,-0.85> }
        sphere { 0*x, 1 scale <0.02,0.2,0.02> translate <-0.05,2.45,-0.85> }
    }
    difference
    {   // eyes
        sphere { 0*x,1 scale <0.05,0.05,0.15> }
        box { <-0.1,-0.1,0> <0.1,0.1,-1> }
        rotate x*-75 translate <0.0775,2.8,-0.775>
    }
    difference
    {   // eyes
        sphere { 0*x,1 scale <0.05,0.05,0.15> }
        box { <-0.1,-0.1,0> <0.1,0.1,-1> }
        rotate x*-75 translate <-0.0775,2.8,-0.775>
    }
    difference
    {   // ears
        cone { <-0.075,2.9,-0.7>, 0.055, <-0.11,3.125,-0.9>, 0.0001 }
        cone { <-0.075,2.875,-0.7>, 0.06, <-0.11,3.125,-0.9>, 0.0001 }
    }
    difference
    {   // ears
        cone { <0.075,2.9,-0.7>, 0.055, <0.11,3.125,-0.9>, 0.0001 }
        cone { <0.075,2.875,-0.7>, 0.06, <0.11,3.125,-0.9>, 0.0001 }
    }
}
#declare horse_clothes =
union
{
    cylinder
    {   <0,-0.015,0>, <0,0.015,0>, 0.11
        scale <0.775,1,1> rotate x*10 translate <0,2.5,-0.8>
    }
    difference
    {
        cylinder { <0,2,0>, <0,2.05,0> 0.3795 scale <1,1,1.38> }
        box { <-2,1,0>, <2,3,2> }
    }
    difference
    {
        cylinder { <0,2,0>, <0,2.05,0> 0.3725 scale <1,1,1.78> }
        box { <-2,1,0>, <2,3,2> }
        translate y*-2 rotate x*135 translate y*2
    }
}

#declare right_horse =
union
{
    object { horse_head  }
    object { horse_torso }
    object { horse_straight_foreleg translate x*0.25 }
    object { horse_bowed_foreleg translate x*-0.25 }
    object { horse_straight_backleg translate <0.25,0,1.7> }
    object { horse_straight_backleg rotate x*15 translate <-0.25,0,1.2> }
    object { horse_tail  }
    object { horse_clothes  }
}

#declare left_horse =
union
{
    object { horse_head  }
    object { horse_torso }
    object { horse_straight_foreleg translate x*-0.25 }
    object { horse_bowed_foreleg translate x*0.25 }
    object { horse_straight_backleg translate <0.25,0,1.7> }
    object { horse_straight_backleg rotate x*15 translate <-0.25,0,1.2> }
    object { horse_tail  }
    object { horse_clothes  }
}

#declare wheel =
union
{
    difference
    {
        cylinder { <-0.075,0,0>, <0.075,0,0>, 1 }
        cylinder { <-0.5,0,0>, <0.5,0,0>, 0.8 }
    }
    cylinder { <-0.1,0,0>, <0.1,0,0>, 0.15 }
    sphere {-0.1*x, 0.1 }
    sphere { 0.1*x, 0.1 }
    union { cone { <0,0.9,0>, 0.03, <0,0.4,0>, 0.1 } cylinder { <0,0.4,0>, <0,0.3,0>, 0.05 } cone { <0,0.3,0>, 0.1, <0,0,0>, 0.03 } rotate x*45 }
    union { cone { <0,0.9,0>, 0.03, <0,0.4,0>, 0.1 } cylinder { <0,0.4,0>, <0,0.3,0>, 0.05 } cone { <0,0.3,0>, 0.1, <0,0,0>, 0.03 } rotate x*135 }
    union { cone { <0,0.9,0>, 0.03, <0,0.4,0>, 0.1 } cylinder { <0,0.4,0>, <0,0.3,0>, 0.05 } cone { <0,0.3,0>, 0.1, <0,0,0>, 0.03 } rotate x*-45 }
    union { cone { <0,0.9,0>, 0.03, <0,0.4,0>, 0.1 } cylinder { <0,0.4,0>, <0,0.3,0>, 0.05 } cone { <0,0.3,0>, 0.1, <0,0,0>, 0.03 } rotate x*-135 }

    translate y*1
}

#declare carriage =
union
{   // carriage
    object { wheel translate <-2,0,5> }
    object { wheel translate < 2,0,5> }
    cylinder { <1.9,1,5>, <1.7,1,5>, 0.125 }
    cylinder { <-1.9,1,5>, <-1.7,1,5>, 0.125 }
    cylinder { <1.7,1,5>, <-1.7,1,5>, 0.075 }
    cylinder { <1.5,1,5>, <1.25,1,5>, 0.125 }
    cylinder { <-1.5,1,5>, <-1.25,1,5>, 0.125 }
    difference
    {
        cylinder { <0,1.0,0>, <0,3,0>, 1.5 }
        cylinder { <0,1.1,0>, <0,5,0>, 1.45 }
        box { <-2,0,2>, <2,5,1> }
        box { <-2,3,2>, <2,5,-2> rotate x*33 }
        translate z*5.5
    }
    cylinder { <0,1.15,5.5>, <0,1,5.5>, 1.53 }
    difference
    {
        cylinder { <0,1.0,0>, <0,3,0>, 1.53 }
        cylinder { <0,1.1,0>, <0,5,0>, 1.45 }
        box { <-2,0,2>, <2,5,0> }
        box { <-2,2.9,2>, <2,-5,-2> rotate x*15 }
        translate z*5.5
    }
    difference
    {
        torus { 1.475, 0.08 translate y*3 }
        box { <-2,2.5,2>, <2,5,-2> rotate x*33 }
        translate z*5.5
    }
    box { <0.08,1.15,-1>, <-0.08,1,5> } // deichsel
    cylinder { <0,1,1>, <0,0,1>, 0.025 } // holder

    scale <1.25,1,1>
}

#declare angelwing =
union
{   // angel wing
    difference
    {
        sphere { 0*x, 1 scale <0.05,1.125,0.75> }
        sphere { 0*x, 1 scale <0.025,0.5,0.75> translate <0.025,-0.5,0> }
    }
    sphere { 0*x, 1 scale <0.025,1.80,0.125> translate <0,-1.5,0.7> }
    sphere { 0*x, 1 scale <0.025,1.65,0.125> translate <0,-1.4,0.55> }
    sphere { 0*x, 1 scale <0.025,1.50,0.125> translate <0,-1.3,0.4> }
    sphere { 0*x, 1 scale <0.025,1.35,0.125> translate <0,-1.2,0.25> }
    sphere { 0*x, 1 scale <0.025,1.20,0.125> translate <0,-1.1,0.1> }
    sphere { 0*x, 1 scale <0.025,1.05,0.125> translate <0,-1.0,-.05> }
    sphere { 0*x, 1 scale <0.025,0.90,0.125> translate <0,-0.9,-.2> }
    sphere { 0*x, 1 scale <0.025,0.75,0.125> translate <0,-0.8,-.35> }
    sphere { 0*x, 1 scale <0.025,0.60,0.125> translate <0,-0.7,-.5> }
}

#declare angel =
union
{   // angel

    object { angelwing rotate x*-30 rotate y*30 translate <0.5,4.0,6.1> }
    object { angelwing rotate x*-30 rotate y*-30 translate <-0.5,4.0,6.1> }

    difference
    {
        union
        {   // skull skill skoll
            sphere { 0*x, 1 scale <0.3,0.3,0.3> translate <0,5.5,5> }
            cone { <0,5.495,5>, 0.33, <0,5.1,4.9>, 0.125  }
            sphere { 0*x, 1 scale <0.138,0.05,0.136> translate <0,5.14,4.925> }
            sphere { 0*x, 1 scale <0.08,0.025,0.122> translate <0,5.215,4.87> }
            sphere { 0*x, 1 scale <0.08,0.025,0.122> translate <0,5.200,4.87> }
            cylinder { <0,5.7,4.85>, <0,5.275,4.74>, 0.05 scale <0.5,1,1> }
            torus { 0.33, 0.066 rotate x*20 translate <0,5.5,5> }
            torus { 0.3, 0.045 rotate x*25 translate <0,5.4,5.05> }
            torus { 0.3, 0.045 rotate x*25 translate <0,5.6,5.05> }
        }
        sphere { 0*x, 1 scale <0.15,0.06,0.15> translate <0.15,5.4,4.64> }
        sphere { 0*x, 1 scale <0.15,0.06,0.15> translate <-0.15,5.4,4.64> }

        scale <0.8,1,1>
    }
    
    cone { <0,5.4,5.05>, 0.16, <0,4.8,5.15>, 0.18 }
    cone { <0,4.8,5.15>, 0.18, <0.5,4.8,5.15>, 0.16 }
    cone { <-0.5,4.8,5.15>, 0.16, <0,4.8,5.15>, 0.18 }
    sphere { <-0.5,4.8,5.15>, 0.16 }
    sphere { <0.5,4.8,5.15>, 0.16 }
    cone { <-0.5,4.8,5.15>, 0.16, <-1.25,5,4.9>, 0.11 }
    sphere { <-1.25,5,4.9>, 0.11 }
    cone { <-1.25,5,4.9>, 0.11, <-0.80,5.4,4.5>, 0.08 }
    sphere { <-0.80,5.4,4.5>, 0.08 }
    torus { 0.095, 0.0265 translate <-0.775,5.54,4.35> }
    torus { 0.100, 0.0275 translate <-0.80,5.50,4.375> }
    torus { 0.095, 0.0265 translate <-0.775,5.46,4.4> }
    torus { 0.090, 0.025 translate <-0.75,5.42,4.425> }

    cone { <0.5,4.8,5.15>, 0.16, <0.6,4.3,4.8>, 0.11 }
    sphere { <0.6,4.3,4.8>, 0.11 }
    cone { <0.6,4.3,4.8>, 0.11, <0.1,4.0,4.2>, 0.08 }
    sphere { <0.1,4.0,4.2>, 0.08 }
    torus { 0.095, 0.0265 rotate z*90 translate <0.0,4,4> }
    torus { 0.100, 0.0275 rotate z*90 translate <0.04,4,4> }
    torus { 0.095, 0.0265 rotate z*90 translate <0.08,4,4> }
    torus { 0.090, 0.025  rotate z*90 translate <0.12,4,4> }

    cone { <0,4.8,0>, 0.5, <0,4,0>, 0.4 scale <1,1,0.4> translate <0,0,5.15> }
    sphere { x*0, 0.15 scale <1,1.25,1> translate <0.2,4.5,5.05> }
    sphere { x*0, 0.15 scale <1,1.25,1> translate <-0.2,4.5,5.05> }
    sphere { x*0, 0.15 scale <1,2,1> translate <0.15,4.5,5.25> }
    sphere { x*0, 0.15 scale <1,2,1> translate <-0.15,4.5,5.25> }
    cylinder { <0.2,0,5.05>, <-0.2,0,5.05>, 0.15 scale <1,1.25,1> translate y*4.5 }
    cone { <0,4,0>, 0.4, <0,1,0> 1 scale <1,1,0.4> translate <0,0,5.15> }
    cone { <0.1,4,0>, 0.3, <0.1,1,0> 1 scale <1,1,0.5> translate <0,0,5.15> }
    cone { <-0.1,4,0>, 0.3, <-0.1,1,0> 0.9 scale <1,1,0.5> translate <0,0,5.15>}
    cone { <-0.1,4,0>, 0.2, <-0.1,1,0> 0.9 scale <1,1,0.5> translate <0,0,5.25>}
}

union
{   // quadriga
    union
    {   // wreath + cross + eagle
        object { geier }
        object { iron_cross }
        object { victory_pole }
        rotate y*-90 rotate x*-20 translate <-0.75,1,6>
    }
    object { carriage }
    object { angel }
    object { right_horse scale 1.2 rotate y*25 translate <-3,0,-.5> }
    cylinder  { <0,4,4>, <-3,2.5,0>, 0.01 }
    object { left_horse scale 1.2 rotate y*10 translate <-1,0,-.5> }
    cylinder  { <0,4,4>, <-1,2.5,0>, 0.01 }
    object { right_horse scale 1.2 rotate y*-10 translate <1,0,-.5> }
    cylinder  { <0.12,4,4>, <1,2.5,0>, 0.01 }
    object { left_horse scale 1.2 rotate y*-25 translate <3,0,-.5> }
    cylinder  { <0.12,4,4>, <3,2.5,0>, 0.01 }

    translate <0,23.8,21>

    pigment
    {
        gradient y
        color_map {
        [0.00 color PaleGreen3  ]
        [0.50 color PalerGreen  ]
        [0.60 color PalestGreen ]
        [0.80 color PaleGreen2 ]
        [1.00 color PaleGreen4 ]
        }
        turbulence 0.25
        scale <5,17,5>
    }
    normal { bumps 0.3 scale 0.25 }
}


