#version unofficial MegaPov 0.4;

#ifndef (St)
	#declare St = seed(12);
#end

#declare T_Carton = texture {
	pigment { color rgb<.7, .6, .5> }
	normal {
		gradient x
		scallop_wave
		scale <2, 1, 1>
	}
	finish { ambient .4 diffuse .6 }
}

#declare T_Carton_2 = texture {
	pigment { color rgb<.7, .6, .5> }
	normal {
		average
		normal_map {
			[2 gradient x scallop_wave scale <2, 1, 1> ]
			[1 crackle scallop_wave scale 50 ]
		}
	}
	finish { ambient .4 diffuse .6 }
}

#macro T_Carton1(portion, turbz)
	pigment {
		boxed
		pigment_map {
			[portion*.6 wrinkles scale .2 color_map{ [0.0 color rgbf 1] [.7 color rgbf<.3,.2,0,.5>]} ]
			[portion color rgbf 1 ]
		}
		warp { reset_children }
		scale 2
		#local tmp = 20*rand(St);
		translate tmp
		warp { turbulence <.6, .6, 0> lambda 5 }
		translate -tmp
		scale .5
		translate <1,1,.5>
		warp { turbulence <0, 0, turbz> octaves 4 lambda 6 omega .9 }
		scale <.5, .5, 1>
	}
	finish { ambient .4 diffuse .6 }
#end

#declare T_Message = texture {
	pigment {
		image_map {
			png "image_map/help.png"
			map_type 0
			once
			interpolate 2
			filter all 1.0
		}
	}
	finish { ambient .4 diffuse .6 }
}

#declare T_Haut = texture {
	pigment {
		image_map {
			png "image_map/haut.png"
			map_type 0
			once
			interpolate 2
			filter all 1.0
		}
	}
	finish { ambient .4 diffuse .6 }
}

#declare T_Fragile = texture {
	pigment {
		image_map {
			png "image_map/fragile.png"
			map_type 0
			once
			interpolate 2
			filter all 1.0
		}
	}
	finish { ambient .4 diffuse .6 }
}

#declare hf_carton = height_field {
	pattern 500,10 {
		hf_gray_16
		function { .7*noise3d(3*x+20, 3*y+30,3*z+40) + .2*noise3d(12*x+10, 12*y+20,12*z+30) + .05*noise3d(40*x, 40*y,40*z) }
		color_map { [0 rgb 0] [1 rgb 1] }
	}
	rotate z*90
	translate .01*x
}



#declare O_Pancarte = difference {
	union {
		box { <-70/3,0,0>, <0, 50, 1>
			texture { T_Carton_2 }
			texture { T_Message scale <70,50,1> translate -70*x/3 }
			texture { T_Carton1(.35,2) scale <70, 50, 1> translate -70*x/3 }
			rotate -10*y 
		}
		box { <0,0,0>, <70/3, 50, 1>
			texture { T_Carton_2 translate 325*x }
			texture { T_Message scale <70,50,1> translate -70*x/3 }
			texture { T_Carton1(.35,2) scale <70, 50, 1> translate -70*x/3 }
		}
		box { <0,0,0>, <70/3, 50, 1>
			texture { T_Carton_2 translate 35*x }
			texture { T_Message scale <70,50,1> translate -140*x/3  }
			texture { T_Carton1(.35,2) scale <70, 50, 1> translate -140*x/3  }
			rotate 15*y translate 70*x/3
		}
	}
	object { hf_carton rotate z*90 scale <75, 4, sin(radians(10))*75/3> translate 50*y +x*(75 -70/3) -z*sin(radians(10))*75/3 texture { T_Carton_2 } }
	object { hf_carton scale <3, 55, 2> translate -2*y -.5*z + x*70/3 rotate 15*y translate 70*x/3 texture { T_Carton_2 } }
	scale .75
}


#declare O_Cartons = union {
	box { <0,0,0>, <120, 80, 1>
		texture { T_Carton_2 rotate z*90 translate 350*x }
		texture { T_Haut scale <10,100/6,1> rotate -90*z translate 15*y + (115-100/6)*x }
		texture { T_Fragile scale <10,100/6,1> rotate -90*z translate 75*y + (115-100/6)*x }
		texture { T_Carton1(.2,1) scale <120, 80, 1> }
		rotate x*15
	}
	box { <0,0,0>, <120, 1, 50>
		texture { T_Carton_2 rotate z*90 rotate x*90 }
		texture { T_Carton1(.2,1) scale <120, 50, 1> rotate x*90 }
	}
	box { <0,0,0>, <120, 80, 1>
		texture { T_Carton_2 rotate z*90 }
		texture { T_Carton1(.2,1) scale <120, 80, 1> }
		rotate x*15
		translate 49*z
	}
	box { <0,0,0>, <120, 1, 50>
		texture { T_Carton_2 rotate z*90 rotate x*90 }
		texture { T_Carton1(.2,1) scale <120, 50, 1> rotate x*90 }
		translate (80*cos(radians(15))-1)*y
		translate 80*sin(radians(15))*z
	}
	difference {
		box { <0,0,0>, <25, 78,1> }
		object { hf_carton scale <10,78,2> rotate z*15 translate 35*x + 15*y -.5*z }
		texture { T_Carton_2 rotate z*90 translate 12*x }
		texture { T_Carton1(.2,.5) scale <25, 78, 1> }
		rotate y*110
		rotate 15*x
		translate 120*x
		translate y
	}
	box { <0,0,0>, <25, 1, 48>
		texture { T_Carton_2 rotate z*90 rotate x*90 }
		texture { T_Carton1(.3,1) scale <25, 48, 1> rotate x*90 }
		translate 120*x + z
	}
	box { <0,0,0>, <25, 78,1>
		texture { T_Carton_2 rotate z*90 translate 51*x }
		texture { T_Carton1(.3,1) scale <25, 78, 1> }
		rotate -5*y
		rotate 15*x
		translate 120*x
		translate z*49
	}
	box { <0,0,0>, <25, 1, 48>
		texture { T_Carton_2 rotate z*90 rotate x*90 }
		texture { T_Carton1(.3,1) scale <25, 48, 1> rotate x*90 }
		rotate -35*z
		translate 120*x + (80*cos(radians(15))-1)*y
		translate -x + z + 80*sin(radians(15))*z
	}
}


#declare O_Godet = difference {
	union {
		cylinder { 0*y, 10*y, 6 }
		torus { 4, .5
			rotate x*90
			scale <.75, 1, .9>
			rotate -30*z
			translate 4.5*y + 6*x
		}
	}
	cylinder { .1*y, 10.1*y, 5.9 }
	
	texture { T_Metal_Pourri scale .2 }
	texture { T_Crasse scale 5 }
	texture { T_Crasse scale 2 }
	texture { T_Crasse scale .6 }
}
