#version unofficial MegaPov 0.4;

background { color rgb 0}

global_settings { hf_gray_16 on }

camera {
	orthographic
	location <0,0,-20>
	right 61*x
	up 61*y
	look_at <0,0,0>
}


#declare Machin = pigment {
	boxed
	cubic_wave
	translate x+y
	color_map { [0 rgb .4][.9 rgb .8] }
	warp {repeat 2*x}
	warp {repeat 2*y}
}

#declare Cyl1 = function {
	pigment {
		cylindrical
		rotate -90*x
		color_map { [0 rgb 0] [.3 rgb 1] }
	}
}

#declare Cyl2 = function {
	pigment {
		cylindrical
		scale .15
		rotate -90*x
		color_map { [0 rgb 1] [.1 rgb 0] }
	}
}


#declare Truc = pigment {
	function { Cyl1(x,y,z)*Cyl2(x,y,z) }
	pigment_map {
		[0 color rgb .4]
		[1 Machin scale 1/10 ]
	}
}

disc { 0, -z, 29.99, 3
	pigment {
		onion
		scale 30
		pigment_map {
			[27/30 Truc ]
			[27.8/30 color rgb .4 ]
			[28.8/30 color rgb .8 ]
			[29.8/30 color rgb .4 ]
		}
	}
	finish { ambient 1 diffuse 0 }
}
