#version unofficial MegaPov 0.4;


#declare T_Pierre = texture {
	pigment {
		granite
		scale .05
		color_map {
			[0.0 color rgb <1,.95,.8>*.7]
			[0.5 color rgb <1,.95,.8>*.8]
			[1.0 color rgb <1,.95,.8>*.9]
		}
	}
	normal { granite .4 scale .5 }
	finish {
		ambient .4
		diffuse .6
		specular .1
		roughness .005
	}
	scale .5
}

#declare T_Mortier = texture {
	pigment { color rgb <.9, .9, .7>*.8 }
	normal { wrinkles 2 scale .5 }
	finish {
		ambient .5
		diffuse .5
	}
}




/* Mur */
#declare F_Crack = function {
	pigment {
		crackle form <-1,.8,.2>
		scale <30/400, 30/5, 30/100>
		color_map {
			[0 rgb 0]
			[.9 rgb 1]
		}
		translate 200*y
	}
}

#macro O_Mur1()
union {
	height_field {
		pattern 400, 150 { hf_gray_16 function { F_Crack(x,y,z)^.3 } color_map { [0 rgbft 0] [1 rgbft <1, 1, 1, 0, 0>] } }
		water_level .3
		scale <400, 5, 150>
		rotate -90*x
		texture { T_Pierre }
		texture { T_Crasse scale 10 }
		texture { T_Crasse scale 5 }
	}
	box { <0, 0, -2.1>, <400, 150, 0>
		texture { T_Mortier }
		texture { T_Crasse scale 200 }
		texture { T_Crasse scale 10 }
	}
}
#end

#declare hfbrick = height_field {
	pattern 300,300 {
		hf_gray_16
		bozo
		warp { turbulence 1 lambda 3 }
		scale .1
		color_map { [0.5 rgb 0] [1 rgb 1] }
	}
	translate <-.5, 0, -.5>
	rotate x*90
	translate -.01*z
}

#declare F_Granite = function {
	pigment {
		granite scale .5
		color_map { [0 rgb 0] [1 rgb 1] }
	}
}

#declare hfaffiche = height_field {
	pattern 300,10 {
		hf_gray_16
		function { .7*F_Granite(x,y,z) + .3*F_Granite(4*x,y,z) }
		color_map { [0 rgb 0] [1 rgb 1] }
	}
	translate <-.5, 0, -.5>
	translate -.05*y
}


#macro P_Brick(sc)
pigment {
	bozo
	warp { turbulence .5 lambda 6 octaves 3 omega .4 }
	scale <sc, sc/2, sc/2>
	color_map {
		[.5 color rgb <.6-.1*rand(St), .3+(-.025+.05*rand(St)), .2+(-.025+.05*rand(St))>*(.65+.8*rand(St)) ]
		[.8 color rgb <.4, .32, .30>*(.85+.4*rand(St)) ]
	}
	translate 3251*rand(St)
}
#end


#macro One_Brick(taille, Rnd)

#local sc= sqrt(2)*1.1*max(taille.x, taille.y);

difference {
	box {0, taille}
	object {
		hfbrick
		rotate z*(3652*Rnd + 3254)
		scale <2*sc, 2*sc, .3>
	}
}
#end

#macro O_Mur2(taille_brique, taille_mur, mortier, pisse, xpisse, ypisse, hpisse, lpisse)

#local iy = taille_brique.y + mortier.y;
#local ix = taille_brique.x + mortier.x;


#if (pisse = true)
#local T_Pisse = texture {
	pigment {
		cylindrical
		rotate x*90
		warp { turbulence .2 octaves 3 lambda 3 omega .3 }
		scale 10
		warp { turbulence 2 octaves 3 lambda 7 omega .4 }
		scale .1
		scale <lpisse, hpisse, 1>
		translate <xpisse, ypisse, 0>
		warp { reset_children }
		pigment_map {
			[.05 rgb 0 transmit 1 ]
			[.05 bozo scale <.5, 2, .5> color_map { [0 rgbt <.4, .5, .05, .5> ] [1 rgbt <.4, .4, .05, .6> ] } ]
		}
	}
}

#end

union{

	box { <0,0,.5>, taille_mur
		texture { pigment { color rgb <.5, .5, .47>*.8 } normal {wrinkles scale .1} finish { ambient .4 diffuse .6 } }
		texture { T_Crasse scale 6 }
		texture { T_Crasse scale 3 }
		#if (pisse = true)
		texture { T_Pisse }
		#end
	}

#local yd = 0;

#while (yd < taille_mur.y)

	#local xd = .5*taille_brique.x * mod(yd/iy,2);
	#while (xd < taille_mur.x)
		object {
			One_Brick(taille_brique, rand(St)*365)
			translate -taille_brique*.5
			rotate -.5+rand(St)*y
			translate taille_brique*.5
			translate <-.2+.4*rand(St), -.2+.4*rand(St), -.1+.2*rand(St)>
			translate xd*x + yd*y
			texture { P_Brick(.5*taille_brique.x) finish { ambient .4 diffuse .6 } }
			texture { T_Crasse scale 20 }
			texture { T_Crasse scale 5 }
			#if (pisse = true)
			texture { T_Pisse }
			#end
		}
	#local xd = xd + ix;
	#end

#local yd = yd + iy;
#end

}

#end


#macro element_gouttiere(rayon, hauteur, thaut)

difference {
	union {
		cylinder {0, hauteur*y, rayon}
		cone { hauteur*y, rayon, (hauteur+3)*y, rayon*1.15 }
		cylinder {(hauteur+3)*y, (hauteur+thaut)*y, rayon*1.15 }
	}
	union {
		cylinder {-1*y, hauteur*y, rayon*.95}
		cylinder {(hauteur+3)*y, (hauteur+thaut+1)*y, rayon*1.05 }
	}
}

#end



#macro O_Gouttiere(loc, haut, rayon, nba, ha)

#local tex = texture {
	bozo
	turbulence .7 octaves 3
	scale 2
	texture_map {
		[0.3 T_Metal_Pourri ]
		[1.0 T_Rouille      ]
	}
}

union {
	#local i = nba;
	#while (i > 0)
	#local i = i - 1;
		object {
			element_gouttiere(rayon, haut*.9, (haut*.1 + 1))
			translate (i*haut)*y
			texture {
				gradient y
				texture_map {
					[0.01 T_Rouille translate 6542*rand(St)*(x+z)      ]
					[0.08 tex scale 3 translate 6542*rand(St)*(x+z) ]
				}
				scale 1.01
				translate y
				warp { turbulence .07*y lambda 2 octaves 3 }
				scale <1/10, 1, 1/10>
				scale <1, haut + 1, 1>
				warp { reset_children }
			}
		}
		cylinder { 0, ha*y, rayon*1.15 translate (i+1/2)*haut*y texture { T_Alu } }
	#end

	translate loc
}

#end



#macro Affiche(tx, ty, file, rot)

#local T_Affiche = texture {
	pigment {
		image_map {
			png	file
			once
			interpolate 2
		}
	}
	normal { wrinkles .3 scale .1 translate rand(St)*652 }
	finish { ambient .4 diffuse .6
		specular .3 roughness .01
	}
}
texture { pigment { bozo cubic_wave turbulence .5 octaves 3 color_map { [0 rgbft <.4,.4,.4,0,.7>] [1 rgbft <.8,.8,.8,0,.3>]} scale <.3,.4,.4> rotate -rot*z } }
texture { T_Crasse2 scale .2 translate rand(St)*652 }
texture { T_Crasse2 scale .06 translate rand(St)*652 }

#local F_Granite = function {
	pigment {
		granite scale .5
		color_map { [0 rgb 0] [1 rgb 1] }
	}
}
#local F_Crackle = function {
	pigment {
		crackle form <-.1,1,-.1> scale .3
		color_map { [0 rgb 0] [1 rgb 1] }
	}
}

#local tmp = rand(St)*65432;

#local hfaffiche = height_field {
	pattern 300,10 {
		hf_gray_16
		function { .7*F_Crackle(x+tmp,y+tmp,z) + .3*F_Granite(2*(x+tmp),y,z) }
		color_map { [0 rgb 0] [1 rgb 1] }
	}
	translate <-.5, 0, -.5>
	translate -.05*y
}

difference {
	box { <0, 0, 0>, <tx,ty,.01> }
	object { hfaffiche scale <tx+20, 30, 1> translate (tx*.5+10)*x - (7+6*rand(St))*y }
	object { hfaffiche scale <ty+50, 20, 1> rotate -90*z translate -(5+7*rand(St))*x + ty*.5*y }
	object { hfaffiche scale <ty+50, 20, 1> rotate 90*z translate (tx+5+7*rand(St))*x + ty*.5*y }
	texture { T_Affiche scale <tx,ty,1> }
}


#end


