#version unofficial MegaPov 0.4;

#include"reorient.mcr"
#include"utils.inc"

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "metals.inc"

#ifndef (St)
	#declare St = seed (3254*12);
#end


#declare T_Ciment = texture {
	pigment {
		crackle
		scale 2
		pigment_map {
			[.6 granite scale 5 color_map {[0 color rgb <.52,.50,.51>] [.5 color rgb <.51,.52,.50>] [1 color rgb <.51,.50,.52>]} ]
			[.6 color rgb <.7, .65, .5>]
		}
	}
	normal { granite .6 scale 3 }
	finish {
		ambient .4 diffuse .6
	}
}

#declare T_Ciment2 = texture {
	pigment { color rgb <.7, .7, .65> }
	normal { wrinkles scale 2 }
	finish { ambient .4 diffuse .6 }
}


#declare T_Trottoir1 = texture {
	pigment { color rgb <.55, .52, .45>
	}
	normal { granite .5 scale .5 }
	finish {
		ambient .4 diffuse .6
	}
}


#declare T_Bitume = texture {
	pigment { granite scale 4 color_map { [.6 color rgb <.2, .2, .25>*.7] [.9 color rgb<.7,.7,.8>]} }
	normal { granite scale <10,20,10>*.5 }
	finish { ambient .4 diffuse .6
		specular .3 roughness .01
		phong .3 phong_size 30
	}
}
/*
#declare P_Peinture = pigment {
	bozo
	turbulence 2 lambda 7
	color_map {
		[.6 color rgbt<1,1,1,.1>]
		[.90 color rgbt<1,1,1,.5>]
		[.92 color rgbt<1,1,1,1>]
	}
}
*/

#declare P_Peinture = pigment {
	crackle form <-.1,1,-.1>
	turbulence 1.5 lambda 4 octaves 3
	color_map {
		[0.30 color rgbt<1,1,1,1>]
		[0.40 color rgbt<1,1,1,.1>]
	}
}

#declare T_Passage =  texture {
	pigment {
		boxed
		translate -1.1*z
		scale <1,1,100>
		warp { turbulence .01*x lambda 5 octaves 2 }
		scale <100,1,.01>
		warp { turbulence .05*z lambda 5 octaves 2 }
		scale <.01,1,1>
		pigment_map {
			[0.001 color rgbt 1 ]
			[0.001 P_Peinture scale 20 ]
		}
		warp { repeat -z*3 }
		scale <100, 20, 20>
		warp { reset_children }
	}
	normal { wrinkles scale 3 }
}


#macro element_trottoir(long2, haut, larg)

#local sc = sqrt(2)*1.1*max(haut, larg);

difference {
	union {
		box { <-long2, 0, 0>, <long2, haut*.8, larg> }
		box { <-long2, haut*.7, larg*.2>, <long2, haut, larg> }
		cylinder { -long2*x, long2*x, 1
			scale <1, haut*.2, larg*.2>
			translate <0, haut*.8, larg*.2>
		}
	}
	object { hfbrick scale <2*sc, 2*sc, .5>
		rotate 36542*rand(St)*z
		rotate y*90
		translate -long2*x
	}
	object { hfbrick scale <2*sc, 2*sc, .5>
		rotate 36542*rand(St)*z
		rotate -y*90
		translate long2*x
	}
}
#end


#macro une_dalle(corner1, corner2, rnd, crack)

#local Str = seed(rnd);
#local long = sqrt(2)*max(corner2.x - corner1.x, corner2.z - corner1.z);
#local larg = corner2.y - corner1.y;
#local tr = rand(Str)*32165;

#if (crack = 0)
	box { corner1, corner2 }
#else

#local F_Crack = function {
	pigment {
		crackle form <-.1,1,-.1>
		scale .1
		color_map { [0 rgb 0] [1 rgb 1] }
		translate 200
		rotate 45*y
		rotate 45*x
	}
}

	#debug "\nUne de cassee"
	#local hf = union {
		height_field {
			pattern 200, 20 {
				hf_gray_16
				function { .7*noise3d(x*2, y*2, tr) + .2*F_Crack(x, y, tr) +.09*noise3d(x*10, y*10, tr) }
				color_map { [0 rgb .1] [1 rgb .9] }
			}
		}
		box { -.1*y, <1,.01,1> }
		translate -.5
		scale sqrt(2)*1.02
		rotate 90*x
		translate y*1.01
	}
	#local rot = rand(Str)*1250;
	union {
		intersection {
			box { -.5, .5 }
			object { hf translate -.015*z rotate rot*y }
			translate -.01*y
		}
		difference {
			box { -.5, .5 }
			object { hf translate .015*z  rotate rot*y}
			translate .03*y
		}
		translate .5
		scale (corner2-corner1)
		translate corner1
	}

#end

#end

#macro dalles_trottoir(vmin, vmax, nbx, nbz, crack)

#local long = (vmax.x - vmin.x)/nbx;
#local long2 = long*.493;
#local larg = (vmax.z - vmin.z)/nbz;
#local larg2 = larg*.493;
#local haut = vmax.y - vmin.y;

union {
	box { vmin, <vmax.x, vmax.y*.95, vmax.z>
		texture { T_Ciment2 }
	}
#local j = nbz;
#local zd = vmin.z + larg*.5;
#while (j > 0)
	#local i = nbx;
	#local xd = vmin.x + long*.5;
	#while (i > 0)
		object { une_dalle(<-long2, 0, -larg2>, <long2, vmax.y-vmin.y, larg2>, rand(St)*96324, crack[j-1][i-1])
			#if (rand(St) > .4)
				rotate <-.4+.8*rand(St), 0, -.4+.8*rand(St)>
			#end
			translate <xd, vmin.y, zd>
		}
		#local i = i-1;
		#local xd = xd + long;
	#end
	#local j = j-1;
	#local zd = zd + larg;
#end
	texture { T_Trottoir1 }
	texture { T_Crasse scale 100 }
	texture { T_Crasse2 scale 50 }
	texture { T_Crasse2 scale 10 }
	texture { T_Crasse scale 3 }
}

#end

#macro bordure_trottoir(vmin, vmax, nb)

#local long = (vmax.x - vmin.x)/nb;
#local long2 = long*.49;
#local haut = vmax.y - vmin.y;
#local larg = vmax.z - vmin.z;

#local xd = vmin.x + long*.5;

/* ciment */
union {
	object { element_trottoir((vmax.x-vmin.x)*.5, haut*.99, larg*.99)
		translate larg*.01*z
		translate y*vmin.y + z*vmin.z
		texture { T_Ciment2 }
		texture { T_Crasse scale 5 }
		texture { T_Crasse2 scale 1 }
	}
/* elements de bordure */
#local i = nb;
#while (i > 0)
	object { element_trottoir(long2, haut, larg)
		/*rotate <0, -.5+rand(St), -.5+rand(St)>*/
		translate xd*x
		translate y*vmin.y + z*vmin.z
	}
	#local i = i-1;
	#local xd = xd + long;
#end

	texture { T_Ciment }
/*	texture { T_Crasse scale 200 } */
	texture { T_Crasse2 scale <3, 15, 10> }
	texture { T_Crasse2 scale <1, 2, 2> }
}

#end


#macro caniveau(vmin, vmax, nb)

#local long = vmax.x - vmin.x;
#local larg = vmax.z - vmin.z;
#local long2 = long/nb;

#local F_hf1 = function {
	pigment {
		gradient x
		scallop_wave
		scale <long2/long, 1, 1>
		color_map {
			[0 rgb 0]
			[1 rgb 1]
		}
		translate x*long
	}
}

#local F_hf2 = function {
	pigment {
		gradient z
		scallop_wave
		scale <1,1,1/larg>
		color_map {
			[0 rgb 0]
			[1 rgb 1]
		}
		translate z*larg
	}
}

union {
	height_field {
		pattern long*2, larg {
			hf_gray_16
			function { .8*(F_hf2(x,y,z)^.5)*(F_hf1(x,y,z)^.5) + .2*noise3d(x*long/long2,y,z*larg/3)*(F_hf2(x,y,z)^.1)*(F_hf1(x,y,z)^.1) }
			color_map {[0 rgb 0][1 rgb 1] }
		}
		translate -y*.4
	}
	box { -.4*y, <1, 0, 1.5>
		texture { T_Ciment }
		texture { T_Crasse scale <200/long, 200/(vmax.y-vmin.y), 200/larg> }
		texture { T_Crasse scale <3/long, 10/(vmax.y-vmin.y), 5/larg> }
		texture { T_Crasse2 scale <1/long, 2/(vmax.y-vmin.y), 1/larg> }
	}
	scale <long, (vmax.y-vmin.y), larg>
	translate vmin
	texture { T_Stone13 scale .2 }
	texture { T_Crasse scale 40 }
	texture { T_Crasse scale 5 }
	texture { T_Crasse scale 2 }
}

#end

#macro grille(vmin, vmax, nbb, lb)

#local long = vmax.x - vmin.x;
#local larg = vmax.z - vmin.z;
#local haut = vmax.y - vmin.y;

#local esp = (long - lb)/(nbb + 1);

union {
	rounded_bar(<0,0,0>, <long, lb, larg>, larg*.25)
	rounded_bar(<0,0,0>, <lb, haut, larg>, larg*.25)
	rounded_bar(<long-lb,0,0>, <long, haut, larg>, larg*.25)
	rounded_bar(<0, haut-lb,0>, <long, haut, larg>, larg*.25)
	
	#local i = 0;
	#while (i < nbb)
		#local i = i+1;
		rounded_bar( <esp*i, 0, 0>, <esp*i+lb, haut, larg>, lb*.3)
	#end
	
	texture { T_Rouille scale 10 }
	translate vmin
}

#end


#macro Bouche_egout(loc, Rayon, ep)

union {
	cylinder { 0, ep*.7*y, Rayon }
	height_field{
		tga "image_map/bouche.tga"
		translate -.5*(x+z)
		scale <Rayon*2, ep*.31, Rayon*2>
		translate ep*.7*y
		rotate y*132
	}
	translate loc
	texture { T_Bronze_Rouille scale .5 }
}

#end

#macro trottoir(vmin, vmax, nbdx, nbdz, crack, lb, nbb, lc, nbc, xbouch, lbouch, xgrille, l1grille, l2grille, locb, rayonb, epb)

union {
difference {
	union {
		object { dalles_trottoir(vmin+lb*z, vmax, nbdx, nbdz, crack) }
		bordure_trottoir(vmin, <vmax.x, vmax.y, lb>, nbb)
		object {
			caniveau(vmin, <vmax.x, vmin.y+2, vmin.z+1.5*lb>, nbb*6)
			translate -1.5*lb*z
		}
		union {
			box { <0, -20, -1000>, <vmax.x-vmin.x, -.2, -1.5*lb> }
			box { <0, -100, 0>, <vmax.x-vmin.x, 0, vmax.z> }
			translate vmin
			texture { T_Bitume }
			texture { T_Passage translate 28*z - 150*x}
			texture { T_Crasse2 scale 5 }
			texture { T_Crasse2 scale 2 }
		}
	}
	union {
		box { <xbouch, -2, vmin.z-1>, <xbouch + lbouch, (vmax.y-vmin.y)*.7, vmin.z+30> }
		box { <xbouch, -15, vmin.z+5>, <xbouch + lbouch, 1, vmin.z+40> }
		box { <xgrille, -10, vmax.z-l2grille-1>, <xgrille + l1grille, (vmax.y-vmin.y)+10, vmax.z-1> }
		cylinder { 0 , epb*y*2, rayonb*.98 translate locb - y*vmin.y }
		translate y*vmin.y
		texture { T_Ciment }
		texture { T_Crasse2 scale 30 }
	}
}

object {
	grille( <0,0,0>, <lbouch, (vmax.y-vmin.y)*.69 + 1, 4>, 3, lbouch*.08)
	translate <xbouch, vmin.y-1.05, vmin.z-.05>
}
object {
	grille( <0,0,0>, <l1grille*.99, l2grille*.99, 3>, 4, l1grille*.08)
	rotate x*90
	translate <xgrille+.005, vmax.y+.5, vmax.z-l2grille-0.995>
}
object {
	Bouche_egout(locb, rayonb, epb)
}

}
#end

