
#macro rounded_bar(corner1, corner2, R)

union {
	box{ <corner1.x, corner1.y+R, corner1.z+R>, <corner2.x, corner2.y-R, corner2.z-R> }
	box{ <corner1.x+R, corner1.y, corner1.z+R>, <corner2.x-R, corner2.y, corner2.z-R> }
	box{ <corner1.x+R, corner1.y+R, corner1.z>, <corner2.x-R, corner2.y-R, corner2.z> }
	sphere { 0, R translate <corner1.x+R, corner1.y+R, corner1.z+R> }
	sphere { 0, R translate <corner1.x+R, corner1.y+R, corner2.z-R> }
	sphere { 0, R translate <corner1.x+R, corner2.y-R, corner1.z+R> }
	sphere { 0, R translate <corner1.x+R, corner2.y-R, corner2.z-R> }
	sphere { 0, R translate <corner2.x-R, corner1.y+R, corner1.z+R> }
	sphere { 0, R translate <corner2.x-R, corner1.y+R, corner2.z-R> }
	sphere { 0, R translate <corner2.x-R, corner2.y-R, corner1.z+R> }
	sphere { 0, R translate <corner2.x-R, corner2.y-R, corner2.z-R> }
	cylinder { <corner1.x+R, corner1.y+R, corner1.z+R>, <corner1.x+R, corner1.y+R, corner2.z-R>, R }
	cylinder { <corner1.x+R, corner1.y+R, corner1.z+R>, <corner1.x+R, corner2.y-R, corner1.z+R>, R }
	cylinder { <corner1.x+R, corner1.y+R, corner1.z+R>, <corner2.x-R, corner1.y+R, corner1.z+R>, R }
	
	cylinder { <corner1.x+R, corner1.y+R, corner2.z-R>, <corner1.x+R, corner2.y-R, corner2.z-R>, R }
	cylinder { <corner1.x+R, corner1.y+R, corner2.z-R>, <corner2.x-R, corner1.y+R, corner2.z-R>, R }
	
	cylinder { <corner2.x-R, corner1.y+R, corner1.z+R>, <corner2.x-R, corner1.y+R, corner2.z-R>, R }
	cylinder { <corner2.x-R, corner1.y+R, corner1.z+R>, <corner2.x-R, corner2.y-R, corner1.z+R>, R }
	
	cylinder { <corner2.x-R, corner1.y+R, corner2.z-R>, <corner2.x-R, corner2.y-R, corner2.z-R>, R }
	
	cylinder { <corner1.x+R, corner2.y-R, corner1.z+R>, <corner1.x+R, corner2.y-R, corner2.z-R>, R }
	cylinder { <corner1.x+R, corner2.y-R, corner1.z+R>, <corner2.x-R, corner2.y-R, corner1.z+R>, R }

	cylinder { <corner1.x+R, corner2.y-R, corner2.z-R>, <corner2.x-R, corner2.y-R, corner2.z-R>, R }

	cylinder { <corner2.x-R, corner2.y-R, corner1.z+R>, <corner2.x-R, corner2.y-R, corner2.z-R>, R }
}

#end

