//Standard include files
#include "colors.inc"
#include "textures.inc"
#include "stoneold.inc"
#include "stones.inc"
#include "woods.inc"
#include "metals.inc"
#include "golds.inc"
#include "glass.inc"

light_source { < 20, 30, -48> color red 1 green 1 blue 1 }
light_source{<-200,100,0> rgb<1,1,1> shadowless}
light_source{<200,100,0> rgb<1,1,1> shadowless}
//--------------------------------------------------------------------------------------------------------------------
camera
{
  location  <0,0.6,-3.5> 
  look_at <-5,1000,3000>
}
//--------------------------------------------------------------------------------------------------------------------
sky_sphere
{
  pigment
  {
   gradient y
   color_map
   {
    [0.1 rgb<0.6,0.6,0.6>]
    [0.2 rgb<0.8,0.6,0.7>]
    [0.4 rgb<0.5,0.5,0.8>]
   }
  }
  pigment
  {
   bozo
    turbulence<2,1,1>
    octaves 6
    omega .3
    lambda 2.1
    color_map
   {
    [0.02 rgbf<0.6,0.6,0.6,0.6>]
    [0.2 rgbf<0.8,0.8,0.9,0.8>]
    [0.4 rgbf<1,1,1,1>]
   }
   scale<0.4,0.1,0.4>
  }
  pigment
  {
   bozo
    turbulence<2,1,1>
    octaves 6
    omega .3
    lambda 2.1
    color_map
   {
    [0.02 rgbf<0.6,0.6,0.6,0.6>]
    [0.2 rgbf<0.8,0.8,0.9,0.8>]
    [0.7 rgbf<1,1,1,1>]
   }
   rotate<0,135,0>
   scale<0.4,0.1,0.4>
  }
}
//----------------------------------------------------------------------------------------------------------------
plane
{
 <0,1,0>,16000
 texture
 {
  pigment
  {
   gradient z
   turbulence<1,1,1>
   octaves 6
   omega .3
   lambda 2.1
   color_map
   {
    [0.2 rgbf<1,1,1,1>]
    [0.5 rgbf<0.9,0.9,0.9,0.8>]
    [0.8 rgbf<1,1,1,1>]
   }
   scale 6400
  }
 }
 texture
 { 
  pigment
  {
   bozo
   turbulence<1,1,1>
   octaves 6
   omega .3
   lambda 2.1
   color_map
   {
    [0.02 rgbf<0.9,0.9,0.9,0.8>]
    [0.5 rgbf<1,1,1,1>]
   }
   scale 6400
  }
 }
}   
//----------------------------------------------------------------------------------------------------------------------
#declare Hochhaus_Glass_Texture=
texture
{
 pigment{color rgbf <0.8, 0.8, 0.8, 0.9>}
 finish
 {
  ambient 0.1
  diffuse 0.3
  reflection 0.4
  specular 0.8
  roughness 0.003
  phong 1
  phong_size 400
 }
}
#declare Hochhaus_Fenster =
box
{
 <-3.2,0,-0.01><3.2,6.4,0.01>
 interior{I_Glass}
 texture{Hochhaus_Glass_Texture}
}
//---------------------------------------------------------------------------------------------------------------------------------------------
#macro Fenster_Rahmen(X1,Y1,X2,Y2,Rahmen_Breite)
 union
 {
  cylinder{<X1,Y1,0><X2,Y1,0>,Rahmen_Breite}
  cylinder{<X1,Y2,0><X2,Y2,0>,Rahmen_Breite}
  cylinder{<X1,Y1,0><X1,Y2,0>,Rahmen_Breite}
  cylinder{<X2,Y1,0><X2,Y2,0>,Rahmen_Breite}
  sphere{<X1,Y1,0>, Rahmen_Breite}
  sphere{<X2,Y1,0>, Rahmen_Breite}
  sphere{<X1,Y2,0>, Rahmen_Breite}
  sphere{<X2,Y2,0>, Rahmen_Breite}
 }
#end
//--------------------------------------------------------------------------------------------------------------------------------------------------
#declare Hochhaus_Marmor_Texture = 
texture
{
 pigment{color rgb<0,0,0>}
 finish
 {
  ambient 0.15
  brilliance 5
  diffuse 0.6
  metallic
  specular 0.80
  roughness 1/100
  reflection 0.2
 }
}
#declare Hochhaus_Wand =
union
{
 object{Fenster_Rahmen(-4+0.4,0+0.4,4-0.4,8-0.4,0.4) translate<0,0,-0.5>}
 difference
 {
  box{<-4,0,-0.05><4,8,0.05>}
  box{<-3.2,0.8,-0.06><3.2,7.2,0.06>}
 }
 object{Hochhaus_Fenster translate<0,0.8,0>}
}
//----------------------------------------------------------------------------------------------------------------------
#declare Hochhaus_Scheibe =
union
{
 #local Rotation = 0;
 #local Translation = -8/tan(radians(10));
 #while(Rotation < 360) 
  object{Hochhaus_Wand translate<0,0,-Translation> rotate<0,Rotation,0>}
  #local Rotation = Rotation+10;
 #end
 cylinder{<0,1.98,0><0,2,0>,8/tan(radians(10)) pigment{color White}}

}
//--------------------------------------------------------------------------------------------------------------------
#declare Hochhaus =
union
{
 #local Translation_Y=0;
 #while(Translation_Y<200)
  object{Hochhaus_Scheibe translate<0,Translation_Y,0>}
  #local Translation_Y=Translation_Y+8;
 #end
 texture{Hochhaus_Marmor_Texture}
}
//--------------------------------------------------------------------------------------------------------------------
#declare Hochhaus_Rechteck_Scheibe =
union
{
 #local X_Counter = -48;
 #while(X_Counter < 48)
  object{Hochhaus_Wand translate<X_Counter+4,0,-24>}
  #local X_Counter = X_Counter + 8;
 #end
 #local X_Counter = -48;
 #while(X_Counter < 48)
  object{Hochhaus_Wand translate<X_Counter+4,0,24>}
  #local X_Counter = X_Counter + 8;
 #end
 #local Z_Counter = -24;
 #while(Z_Counter<24)
  object{Hochhaus_Wand rotate<0,90,0> translate<-48,0,Z_Counter+4>}
  #local Z_Counter = Z_Counter+8;
 #end 
 #local Z_Counter = -24;
 #while(Z_Counter<24)
  object{Hochhaus_Wand rotate<0,90,0> translate<48,0,Z_Counter+4>}
  #local Z_Counter = Z_Counter+8;
 #end 
}
#declare Hochhaus_2 =
union
{
 #local Y_Counter = 0;
 #while(Y_Counter<72)
 object{Hochhaus_Rechteck_Scheibe translate<0,Y_Counter,0>}
 #local Y_Counter = Y_Counter+8;
 #end
 box{<-48,72,-24><48,73,24>}
 texture{Hochhaus_Marmor_Texture}
}
//--------------------------------------------------------------------------------------------------------------------
object{Hochhaus translate<0,-10,160> rotate<0,30,0>}
object{Hochhaus translate<0,-10,160> rotate<0,90,0>}
object{Hochhaus translate<0,-10,160> rotate<0,150,0>}
object{Hochhaus translate<0,-10,160> rotate<0,210,0>}
object{Hochhaus translate<0,-10,160> rotate<0,270,0>}
object{Hochhaus translate<0,-10,160> rotate<0,330,0>}

object{Hochhaus translate<40,-10,260>}
object{Hochhaus_2 translate<-40,-10,400>}
//-------------------------------------------------------------------------------------------------------------------
#declare Texture_Sand_1 =
texture
{
 pigment
 {
  bozo
   color_map
   {
    [0.01 rgb<0.8,0.6,0.2>]
    [1 rgb<0.7,0.3,0.2>]
   }
   scale 0.01
 }
 normal
 {
  bumps 0.05
 }
}
#declare Texture_Sand_2 =
texture
{
 pigment
 {
  bozo
   color_map
   {
    [0.01 rgbf<1,0.5,0.1,0>]
    [0.5 rgbf<1,0.5,0.1,1>]
    [1 rgbf<1,1,1,1>]
   }
   scale 0.005
 }
 normal
 {
  bumps 0.04
 }
}
//--------------------------------------------------------------------------------------------------------------------
intersection
{
 box{<0,0,0>,<6,0.3,6>}
 height_field
 {
  png "Sandkiste.png" smooth
  scale <6,0.3,6>
 }
 translate<-3,0,-3>
 texture{Texture_Sand_1}
 texture{Texture_Sand_2}
}
//-------------------------------------------------------------------------------------------------------------------
#declare Randstein =
union
{
 box{<0,0,0><0.2,0.3,0.2>}
 sphere{<0.1,0.3,0.1>,0.1}
}
//-------------------------------------------------------------------------------------------------------------------
#declare Eckstein =
union
{
 box{<0,0,0><0.2,0.45,0.2>}
 sphere{<0.1,0.45,0.1>,0.1}
}
//------------------------------------------------------------------------------------------------------------------
#declare Randstein_Texture = 
texture
{
 pigment
 {
  bozo
  color_map
  {
   [0.3 rgb<1,0.3,0.1>]
   [1 rgb<0.8,0.2,0.2>]
  }
  scale 0.04
 }
 normal
 {
  bumps scale 0.05
 }
}
//-------------------------------------------------------------------------------------------------------------------
#declare Randstein_Seite =
union
{
 #local Translation = -3;
 #while(Translation<3)
  object{Randstein texture{Randstein_Texture translate<0,2*Translation,0>} translate<Translation,0,0>}
  #local Translation = Translation + 0.2;
 #end
}
//-----------------------------------------------------------------------------------------------------------------
object{Randstein_Seite translate<0,0,3>}
object{Randstein_Seite translate<0,0,-3-0.2>}
object{Randstein_Seite rotate<0,90,0> translate<3,0,0>}
object{Randstein_Seite rotate<0,90,0> translate<-3-0.2,0,0>}

object{Eckstein texture{Randstein_Texture} translate<3,0,3>}
object{Eckstein texture{Randstein_Texture} translate<-3-0.2,0,3>}
object{Eckstein texture{Randstein_Texture} translate<3,0,-3-0.2>}
object{Eckstein texture{Randstein_Texture} translate<-3-0.2,0,-3-0.2>}
//-------------------------------------------------------------------------------------------------------------------
#declare Bauklotz_Finish = //finish{F_Glass3}
finish
{
 brilliance 0.8
 diffuse 0.8
 reflection 0.05
 specular 0.05
}
#declare Bauklotz_Texture_1=
texture
{
 pigment
 {
  gradient y
  color_map
  {
   [0.01 rgbf<0.9,0.2,0.1,0>]
   [0.9 rgbf<0.9,0.9,0.9,0.8>]
  }
  scale 0.1
 }
 finish{Bauklotz_Finish}
}
texture
{
 pigment
 {
  radial
  color_map
  {
   [0.05 rgbf<1,1,1,1>]
   [0.5 rgbf<0.9,0.2,0.1,0>]
   [0.95 rgbf<1,1,1,1>]
  }
  frequency 10
 }
 finish{Bauklotz_Finish}
}
#declare Bauklotz_Texture_2=
texture
{
 pigment
 {
  gradient y
  color_map
  {
   [0.01 rgbf<0,0.1,0.9,0>]
   [0.9 rgbf<0.9,0.9,0.9,0.8>]
  }
  scale 0.1
 }
 finish{Bauklotz_Finish}
}
texture
{
 pigment
 {
  radial
  color_map
  {
   [0.05 rgbf<1,1,1,1>]
   [0.5 rgbf<0,0.1,0.9,0>]
   [0.95 rgbf<1,1,1,1>]
  }
  frequency 10
 }
 finish{Bauklotz_Finish}
}
#declare Bauklotz_Texture_3=
texture
{
 pigment
 {
  gradient y
  color_map
  {
   [0.01 rgbf<0.1,0.6,0.25,0>]
   [0.9 rgbf<0.9,0.9,0.9,0.8>]
  }
  scale 0.1
 }
 finish{Bauklotz_Finish}
}
texture
{
 pigment
 {
  radial
  color_map
  {
   [0.05 rgbf<1,1,1,1>]
   [0.5 rgbf<0.1,0.6,0.25,0>]
   [0.95 rgbf<1,1,1,1>]
  }
  frequency 10
 }
 finish{Bauklotz_Finish}
}
#declare Bauklotz_Texture_4=
texture
{
 pigment
 {
  gradient y
  color_map
  {
   [0.01 rgbf<0.8,0.7,0.1,0>]
   [0.9 rgbf<0.9,0.9,0.9,0.8>]
  }
  scale 0.1
 }
 finish{Bauklotz_Finish}
}
texture
{
 pigment
 {
  radial
  color_map
  {
   [0.05 rgbf<1,1,1,1>]
   [0.5 rgbf<0.8,0.7,0.1,0>]
   [0.95 rgbf<1,1,1,1>]
  }
  frequency 10
 }
 finish{Bauklotz_Finish}
}

#declare Bauklotz =
union
{
 difference
 {
  cylinder{<0,0,0><0,0.7,0>,0.2}
  cylinder{<0,0.1,0><0,0.75,0>,0.18}
 }
 torus{0.19,0.01 translate<0,0.7,0>}
 interior{I_Glass}
}  
//-------------------------------------------------------------------------------------------------------------------
object{Bauklotz texture{Bauklotz_Texture_4} rotate<10,0,0> translate<-0.6,0,1>}
object{Bauklotz texture{Bauklotz_Texture_1} translate<-0.601,0.7,1>}
object{Bauklotz texture{Bauklotz_Texture_3} translate<-1.5,0,0.5>}
object{Bauklotz texture{Bauklotz_Texture_2} rotate<-5,0,0> translate<-0.3,0,-0.1>}
//------------------------------------------------------------------------------------------------------------------
#declare Giesskanne_Texture =
texture
{
 pigment{color rgb <0.58, 0.42, 0.20>}
 normal
 {
  crackle
 }
 finish
 {
  ambient 0.35
  brilliance 2
  diffuse 0.3
  metallic
  specular 0.80
  roughness 1/20
  reflection 0.1
 }
}
#declare Giesskanne_Kopf =
difference
{
 sphere{<0,0,0>,0.2}
 sphere{<0,0,0>,0.19}
 plane{<0,1,0>,0}
 #local Translation = 0;
 #while(Translation<0.2)
  #local Rotation = 0 ;
  #while(Rotation<360)
   cylinder{<Translation,0,0><Translation,1,0>,0.02 rotate<0,Rotation,0>}
   #local Rotation = Rotation+30; 
  #end
  #local Translation = Translation + 0.04; 
 #end
}
#declare Giesskanne_Schnabel =
union
{
 cone{<0,0,0>,0.1,<0,0.5,0>,0.07}
 cone{<0,0.5,0>,0.07,<0,0.7,0>,0.2}
 object{Giesskanne_Kopf scale<1,0.4,1> translate<0,0.7,0>} 
}

#declare Giesskanne =
union
{
 difference
 {
  cylinder{<0,0,0><0,1,0>,0.5}
  cylinder{<0,0.05,0><0,1.1,0>,0.495}
  scale<1,0.75,0.5>
 }
 difference
 {
  cylinder{<0,0.9,0><0,1,0>,0.5}
  cylinder{<0,0.85,0><0,1.1,0>,0.3}
  scale<1,0.75,0.5>
 }
 object{Giesskanne_Schnabel rotate<0,0,50> translate<-0.4,0.25,0>}
 torus{0.3,0.05 rotate<90,0,0> translate<1-0.35,0.4,0>}
 texture{Giesskanne_Texture}
}
//-----------------------------------------------------------------------------------------------------------------
#declare Hochhaus_Same_Schirm =
union
{
 difference
 {
  sphere{<0,0,0>,1}
  sphere{<0,0,0>,0.999}
  plane{<0,1,0>,0}
  texture
  {
   pigment
   {
    color rgbf<1,1,1,1>
   }
   finish
   {
    diffuse 0.1
    reflection 0.3
    ambient 0
    irid { 0.1 thickness 0.15 turbulence 7 }
   }
  }
 }
 union
 {
  #local Rotation = 0 ;
  #while(Rotation<360)
  cylinder{<1,0,0><0.2,-1,0>,0.01 rotate<0,Rotation,0>}
   #local Rotation=Rotation+30;
  #end
  texture
  {
   pigment{color rgbf<0.8,0.7,0.7,0.6>}
   finish
   {
    diffuse 0.8
    brilliance 0.4
    ambient 0.3
    irid {0.3 thickness 0.25 turbulence 0.3}
   }
  }
 }
}
//------------------------------------------------------------------------------------------------------------------------------
#declare Hochhaus_Same_1 =
union
{
 object{Hochhaus_Same_Schirm} 
 object{Bauklotz texture{Bauklotz_Texture_1} translate<0,-1.7,0>}
 scale 0.2   
}
#declare Hochhaus_Same_2 =
union
{
 object{Hochhaus_Same_Schirm} 
 object{Bauklotz texture{Bauklotz_Texture_2} translate<0,-1.7,0>}
 scale 0.2   
}
#declare Hochhaus_Same_3 =
union
{
 object{Hochhaus_Same_Schirm} 
 object{Bauklotz texture{Bauklotz_Texture_3} translate<0,-1.7,0>}
 scale 0.2   
}
#declare Hochhaus_Same_4 =
union
{
 object{Hochhaus_Same_Schirm} 
 object{Bauklotz texture{Bauklotz_Texture_4} translate<0,-1.7,0>}
 scale 0.2   
}
//------------------------------------------------------------------------------------------------------------------------------
object{Giesskanne rotate<0,-20,0> rotate<-6,0,0> translate<1.2,0,1>}

object{Hochhaus_Same_3 translate<0,1.6,-2>}
object{Hochhaus_Same_2 translate<-1.5,1.5,-1>}
object{Hochhaus_Same_1 translate<2,2.9,0>}
#local Rx=seed(3);
#local Ry=seed(5);
#local Rz=seed(11);

#local Sz =3;
#local Sy =1.5;
#while(Sz<40)
 #local Sx=-30;
 #while(Sx<30)                           
  object{Hochhaus_Same_4 translate<Sx+rand(Rx)*2,Sy+rand(Ry)*3,Sz+rand(Rz)*2>}
  #local Sx=Sx+4;
 #end
 #local Sz=Sz+4;
 #local Sy = Sy+6;
#end 

