
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

#declare NormHaze =
fog
   {
   color rgb <.9, .9, 1>
   distance 500
   }

#declare SunSetHaze =
fog
   {
   color rgb <.9, .85, .6>
   distance 500
   }

#declare SunSetHaze2 =
fog
   {
   color rgb <.9, .6, .6>
   //color rgbf <0.7 0.7 1.0 .4>
   distance 500
   }

#declare Cloudz =
texture
   {
   pigment
      {
      bozo
      turbulence 0.5
      color_map
         {
         [0.0 color rgbf 1]
         [0.4 color rgbf <0.8 0.8 1 .5>]
         [1.0 color rgbf <1, 1, 1, .25>]
         }
      scale 500
      }
   finish
      {
      ambient .8
      diffuse .1
      }
   }
texture
   {
   pigment
      {
      granite
      color_map
         {
         [0.0 color rgbf 1]
         [0.4 color rgbf <0.8 0.8 1 .75>]
         [1.0 color rgbf <1, 1, 1, .2>]
         }
      scale 850
      rotate 25
      }
   finish
      {
      ambient .9
      diffuse .1
      }
   }
texture
   {
   pigment
      {
      wrinkles //granite
      color_map
         {
         [0.0 color rgbf 1]
         [0.4 color rgbf <0.8 0.8 1 .5>]
         [1.0 color rgbf <1,1,1, .25>]
         }
      scale 1000
      }
   finish
      {
      ambient 1
      diffuse .1
      }
   }

// midsummer
#declare Cloudz2 =
texture
   {
   pigment
      {
      bozo
      turbulence 0.5
      color_map
         {
         [0.0 color rgbf 1]
         [0.4 color rgbf <0.85 0.8 .8 .5>]
         [1.0 color rgb <1 0.8 0.8>]
         }
      scale 500
      }
   finish
      {
      ambient .8
      diffuse .1
      }
   }
texture
   {
   pigment
      {
      granite
      color_map
         {
         [0.0 color rgbf 1]
         [0.4 color rgbf <0.8 0.8 1 .5>]
         [1.0 color rgb <0.8 0.8 1>]
         }
      scale 850
      rotate 25
      }
   finish
      {
      ambient .9
      diffuse .1
      }
   }
texture
   {
   pigment
      {
      granite //wrinkles
      //turbulence 0.5
      color_map
         {
         [0.0 color rgbf 1]
         [0.4 color rgbf <0.9 0.9 .8 .5>]
         [1.0 color rgb <1 1 .75>]
         }
      scale 1000
      }
   finish
      {
      ambient 1
      diffuse .1
      }
   }

// evening flame
#declare Cloudz3 =
texture
   {
   pigment
      {
      wrinkles
      turbulence 0.7
      color_map
         {
         [0.0 color rgbt 1]
         [0.2 color rgbt 1]
         [0.4 color rgbt <0.85 0.85 .6 .5>]
         [1.0 color rgbt <1 1 0.7 .35>]
         }
      scale 250
      }
   finish
      {
      ambient .8
      diffuse .1
      }
   }
texture
   {
   pigment
      {
      wrinkles //bozo
      turbulence 0.4
      color_map
         {
         [0.0 color rgbt 1]
         [0.5 color rgbt 1]
         [0.7 color rgbt <0.8 0.6 .4 .5>]
         [1.0 color rgbt <0.9 0.7 .5  0>]
         }
      scale <500, 150, 150>
      rotate y*90
      }
   finish
      {
      ambient .9
      diffuse .1
      }
   }
texture
   {
   pigment
      {
      granite
      turbulence 0.3
      color_map
         {
         [0.0 color rgbt 1]
         [0.6 color rgbt 1]
         [0.75 color rgbt <0.8 0.5 .3 .5>]
         [1.0 color rgb <.8 .4 .4>]
         }
      scale 1000
      }
   finish
      {
      ambient .8
      diffuse .1
      }
   }

// jetstream
#declare Cloudz4 =
texture
   {
   pigment
      {
      bozo
      turbulence 0.5
      color_map
         {
         [0.0 color rgbf 1]
         [0.4 color rgbf <0.2 0.2 .65 .5>]
         [1.0 color rgb <0.2 0.2 0.7>]
         }
      scale 500
      }
   finish
      {
      ambient .8
      diffuse .1
      }
   }
texture
   {
   pigment
      {
      granite
      color_map
         {
         [0.0 color rgbf 1]
         [0.4 color rgbf <0.6 0.6 0.65 .5>]
         [1.0 color rgb <0.7 0.7 0.75>]
         }
      scale 850
      rotate 25
      }
   finish
      {
      ambient .9
      diffuse .1
      }
   }
texture
   {
   pigment
      {
      marble
      turbulence 0.5
      color_map
         {
         [0.0 color rgbf 1]
         [0.4 color rgbf <0.8 0.8 .8 .5>]
         [1.0 color rgb <.9 .9 .9>]
         }
      scale 1000
      }
   finish
      {
      ambient 1
      diffuse .1
      }
   }

// late afternoon
#declare Cloudz5 =
texture
   {
   pigment
      {
      bozo
      turbulence 0.5
      color_map
         {
         [0.0 color rgbf 1]
         [0.4 color rgbf <0.85 0.8 .8 .5>]
         [1.0 color rgb <1 0.8 0.8>]
         }
      scale 500
      }
   finish
      {
      ambient .8
      diffuse .1
      }
   }
texture
   {
   pigment
      {
      granite
      color_map
         {
         [0.0 color rgbf 1]
         [0.4 color rgbf <0.8 0.8 1 .5>]
         [1.0 color rgb <0.9 0.9 1>]
         }
      scale 850
      rotate 25
      }
   finish
      {
      ambient .9
      diffuse .1
      }
   }
texture
   {
   pigment
      {
      bozo
      turbulence 0.2
      color_map
         {
         [0.0 color rgbf 1]
         [0.4 color rgbf <0.9 0.7 .7 .5>]
         [1.0 color rgb <1 .8 .85>]
         }
      scale <500, 250, 250>
      }
   finish
      {
      ambient 1
      diffuse .1
      }
   }

//sunset2
#declare Cloudz6 =
texture
   {
   pigment
      {
      granite
      //turbulence 0.5
      color_map
         {
         [0.0 color rgbf 1]
         [0.55 color rgbf 1]
         [0.7 color rgbf <0.8 0.7 .7 .5>]
         [1.0 color rgb <1 0.7 0.7>]
         }
      scale 1000
      }
   finish
      {
      ambient 1
      diffuse 1
      }
   }
texture
   {
   pigment
      {
      wrinkles//bozo
      turbulence 0.4
      color_map
         {
         [0.0 color rgbf 1]
         [0.4 color rgbf 1]
         [0.5 color rgbf <0.9 0.9 1 .2>]
         [1.0 color rgb <0.5 0.5 .7>]
         }
      scale 2050
      //translate <0 5000 0>
      //rotate 25
      }
   finish
      {
      ambient .8
      diffuse .1
      }
   }
