#version unofficial MegaPov 0.4;
light_source {<400,200,150>*1000 rgb <1,.875,.75>*1.25
*1.25 //used only if this is an arealight 
//cylinder point_at 0
//radius 100000
//falloff 20000000 
//tightness .25    
area_light 31000,31000,4,4  
circular
jitter
orient
}
light_source {<-50,80,-60>*200000 rgb <.8,.75,1>/10 shadowless media_interaction off}
//background {rgb .5}

#declare Color = <1,.625,.25>
#declare LightColor = (Color+.5)/2

fog {fog_type 2 distance 150000 rgb LightColor transmit .25
fog_offset 0
fog_alt 2500
} 
fog {
distance 1500 rgb <.9,.85,1>/2 transmit .175
}
#declare HeavyScarring =
texture {pigment {bozo color_map {[0 rgb 0 transmit .25][1 rgb 0 transmit 1]}scale 2}}
texture {pigment {bozo pigment_map {[0 bozo color_map {[0 rgb 0 transmit .25][1 rgb 0 transmit 1]}scale .125][.5 rgb .175 transmit 1]}scale 2}translate 25}
#declare Scarring =
texture {pigment {bozo color_map {[0 rgb 0 transmit .75][1 rgb 0 transmit 1]}scale 2}}
texture {pigment {bozo pigment_map {[0 bozo color_map {[0 rgb 0 transmit .75][1 rgb 0 transmit 1]}scale .125][.5 rgb .175 transmit 1]}scale 2}translate 25}
#declare Rusting =
texture {pigment {bozo color_map {[0 rgb <1,.5,.4> transmit .75][1 rgb <1,.5,.4> transmit 1]}scale 2}}
texture {pigment {bozo pigment_map {[0 bozo color_map {[0 rgb <1,.5,.4> transmit .75][1 rgb <1,.5,.4> transmit 1]}scale .125][.5 rgb .175 transmit 1]}scale 2}translate 25}
#declare Rusting2 =
texture {pigment {bozo color_map {[0 rgb <1,.5,.4> transmit .875][1 rgb <1,.5,.4> transmit 1]}scale 2}}
texture {pigment {bozo pigment_map {[0 bozo color_map {[0 rgb <1,.5,.4> transmit .875][1 rgb <1,.5,.4> transmit 1]}scale .125][.5 rgb .175 transmit 1]}scale 2}translate 25}
#declare Dirt =
texture {pigment {bozo color_map {[0 rgb <.6,.5,.4> transmit .75][1 rgb <.6,.5,.4> transmit 1]}scale 2}}
texture {pigment {bozo pigment_map {[0 bozo color_map {[0 rgb <.6,.5,.4> transmit .75][1 rgb <.6,.5,.4> transmit 1]}scale .125][.5 rgb <.6,.5,.4> transmit 1]}scale 2}translate 5}
#declare Chipping =
texture {   
pigment {bozo pigment_map {[.4 bozo color_map {[.2 rgb 1 transmit .125][.3 rgb 1 transmit 1]} turbulence 1/2 scale .125/2][.5 rgb .175 transmit 1]}scale 8}
}  
#declare Chipping2 =
texture {   
normal {bozo normal_map {[.4 bozo normal_map {[.2 bumps scale 1/16/12 bump_size 1/12][.3 bumps scale 1/8 bump_size 0]} turbulence 1/2 scale .125/2][.5 bumps scale 1/8 bump_size 0]}scale 8}
pigment {bozo pigment_map {[.4 bozo color_map {[.2 rgb 1 transmit .125][.3 rgb 1 transmit 1]} turbulence 1/2 scale .125/2][.5 rgb .175 transmit 1]}scale 8}
}
#declare Chipping3 =
texture {   
pigment {bozo pigment_map {[.4 bozo color_map {[.2 rgb 1.5][.3 rgb 1 transmit 1]} turbulence 1/2 scale .125/2][.5 rgb .175 transmit 1]}scale 8}
}   
#macro Paper(RandSeed,Scale)
#local RandNum=RandSeed;
#local Point1=<-1+2*rand(RandNum),-.5+1*rand(RandNum),-1+2*rand(RandNum)>;
#local Point2=<-1+2*rand(RandNum),-.5+1*rand(RandNum),-1+2*rand(RandNum)>;
#local Point3=<-1+2*rand(RandNum),-.5+1*rand(RandNum),-1+2*rand(RandNum)>;
#local Point4=<-1+2*rand(RandNum),-.5+1*rand(RandNum),-1+2*rand(RandNum)>;
#local Point5=<-1+2*rand(RandNum),-.5+1*rand(RandNum),-1+2*rand(RandNum)>;
#local Point6=<-1+2*rand(RandNum),-.5+1*rand(RandNum),-1+2*rand(RandNum)>;
#local Point7=<-1+2*rand(RandNum),-.5+1*rand(RandNum),-1+2*rand(RandNum)>;
#local Point8=<-1+2*rand(RandNum),-.5+1*rand(RandNum),-1+2*rand(RandNum)>;
#local Point9=<-1+2*rand(RandNum),-.5+1*rand(RandNum),-1+2*rand(RandNum)>;
#local Point10=<-1+2*rand(RandNum),-.5+1*rand(RandNum),-1+2*rand(RandNum)>;
#local Point11=<-1+2*rand(RandNum),-.5+1*rand(RandNum),-1+2*rand(RandNum)>;
#local Point12=<-1+2*rand(RandNum),-.5+1*rand(RandNum),-1+2*rand(RandNum)>;
#local Point13=<-1+2*rand(RandNum),-.5+1*rand(RandNum),-1+2*rand(RandNum)>;
#local Point14=<-1+2*rand(RandNum),-.5+1*rand(RandNum),-1+2*rand(RandNum)>;
#local Point15=<-1+2*rand(RandNum),-.5+1*rand(RandNum),-1+2*rand(RandNum)>;
#local Point16=<-1+2*rand(RandNum),-.5+1*rand(RandNum),-1+2*rand(RandNum)>;
bicubic_patch {
type 1 flatness 0.0001 u_steps 2 v_steps 2,
Point1,Point2,Point3,Point4,Point5,Point6,Point7,Point8,Point9,Point10,Point11,Point12,Point13,Point14,Point15,Point16
scale Scale
rotate rand(RandNum)*360*y
}
#end 
 

#declare Color = <1,.625,.25>
#declare LightColor = (Color+.5)/2

#declare Bright = 24
#declare DesertSky =
sphere {0,1
//Back Drop
texture {
finish {ambient 2 diffuse 0}
pigment {
gradient y
color_map {
[0 rgb 1.5*Bright*Color]
[.5 rgb <.5,.675,1>/2]
}
}
scale 1/<2,.5,2>
}
texture {
finish {ambient 1 diffuse 0}
pigment {
bozo
color_map {
[.5 rgb <.5,.675,1> transmit 1 ]
[1 rgb 1*Bright*Color transmit .45]
}
translate 1
scale .5 
turbulence <2,1,2> 
scale 10
warp {turbulence <2,1,2>}
scale 1/10

lambda 2
scale <1,.75,1>
}
scale .25
}
texture {
finish {ambient 1 diffuse 0}
pigment {
bozo
color_map {
[.5 rgb <.5,.675,1> transmit 1 ]
[1 rgb 1*Bright*Color transmit .45]
}
translate 1
scale .25 
turbulence 1
scale 10
warp {turbulence <2,1,2>}
scale 1/10
lambda 4
scale <1,.75,1>
}
scale .5
}
texture {
finish {ambient 1 diffuse 0}
//Back Shadow 
pigment {
bozo
color_map {
[.65 rgb <.375,.5,1> transmit 1]
[.85 rgb 2*Bright*Color]
}
turbulence .25 
scale 10
warp {turbulence <2,1,2>/4}
scale 1/10
scale .25 
translate -.025*y
translate .05*x
}
scale .5
}
texture {
finish {ambient 1 diffuse 0}
//Light Part
pigment {
bozo
pigment_map {
[.65 rgb <.5,.675,1>/1.5 transmit 1]
[.775 bozo color_map {[0 rgb .875][1 rgb 2*Bright*Color]} turbulence .5 scale .25]
}
turbulence .25
scale 10
warp {turbulence <2,1,2>/4}
scale 1/10
scale .25
}
scale .5
}
texture {
finish {ambient 1 diffuse 0}
//Dark Part
pigment {
bozo
color_map {
[.65 rgb <.5,.675,1> transmit 1]
[.975 rgb 0 ]
}
turbulence .25 
scale 10
warp {turbulence <2,1,2>/4}
scale 1/10
scale .25 
translate -.06*y
translate .1*x
}
scale .5
}
texture {
finish {ambient .5 diffuse 0}
//Back Shadow 
pigment {
bozo
color_map {
[.65 rgb <.375,.5,1> transmit 1]
[.85 rgb 2*Bright*Color]
}
turbulence .375 
scale 10
warp {turbulence <2,1,2>/3}
scale 1/10
scale .125 
translate -.025*y
translate .05*x
}
scale .5
}
texture {
finish {ambient .5 diffuse 0}
//Light Part
pigment {
bozo
pigment_map {
[.65 rgb <.5,.675,1>/1.5 transmit 1]
[.775 bozo color_map {[0 rgb .875][1 rgb 4*Bright*Color]} turbulence .5 scale .25]
}
turbulence .375
scale .125
}
scale .5
}
texture {
finish {ambient .5 diffuse 0}
//Dark Part
pigment {
bozo
color_map {
[.65 rgb <.5,.675,1> transmit 1]
[.975 rgb <.1,.1,.2> transmit .675/2]
}
turbulence .375 
scale 10
warp {turbulence <2,1,2>/3}
scale 1/10
scale .125 
translate -.05*y
translate .08*x
}
scale .5 
}
texture {
finish {ambient 1 diffuse 0}
pigment {
gradient y
color_map {
[0 rgb <.5,.675,1>*1.5 transmit .25]
[.25 rgb <.5,.675,1>/1.5 transmit 1]
}
}
}
texture {
finish {ambient 1 diffuse 0}
pigment {
rgb <.25,.25,1>/4 transmit .25}
}

scale 2000000
scale <4,.5,4>
hollow on            
}                 
object {DesertSky rotate 45*y scale -x}   

box {<-1000000000,-100,-1000000000>,<1000000000,0,1000000000> hollow 
texture {
pigment {rgb <.05,.1,.075>*2 transmit .25}
normal {granite .25 
phase clock
translate  -5*x*clock  
scale <1,1,4>*20 bump_size 2}  
finish {ambient 0 diffuse 1 phong 2 phong_size 200 metallic reflection .75 conserve_energy}
scale 2/3
}
texture {Chipping scale 1}
texture {Chipping2 scale 2}        
texture {Chipping scale 2 translate 3}
texture {Chipping scale 4}
texture {Chipping2 scale 8}
texture {Chipping2 scale 10}       
texture {Chipping2 scale 12}
interior { ior 1.33    media { absorption rgb (1-<.8,.9,1>)*50 method 2 }}  
scale <1,1,2>*2
rotate 40*y      
translate -40*y
}
plane {y,0 translate -5000*y}  


box {0,1
pigment {
image_map {
png "FarthestCityScape"
once interpolate 2
}
}            
finish {ambient 20 diffuse 0}
scale <640,200,1>
translate <-200,0,0>
translate 300*z
scale 4
hollow on 
no_shadow 
}  


#macro Scraper1(Height,XScale,ZScale,PerLit,Color)   
#declare ReflectRnd = rand(seed(Height*ZScale*XScale))
union { 
box {0,1 scale <XScale-1,Height,ZScale-1> translate <-XScale/2+1/2,1,-ZScale/2+1/2> pigment {rgb 1/2}}
box {0,1 scale <XScale,Height,ZScale> translate <-XScale/2,0,-ZScale/2>
texture {
pigment {
crackle metric 1
pigment_map {
[0 bozo color_map {[0 rgb 1][1 rgb Color/2]} scale 1/15]     
[PerLit/100 rgb 0]
}
scale 3
} 
finish {ambient 1.5 diffuse 0 phong 2 phong_size 20 reflection 2/3*ReflectRnd conserve_energy} 
scale 2*y
} 
}
box {0,1 scale <XScale+.1,Height,ZScale+.1> translate <-XScale/2-.05,0,-ZScale/2-.05>
texture {  
pigment {gradient y triangle_wave color_map {[.45 rgb .5][.55 rgb .5 transmit 1]} scale 3}
finish {ambient -.5 diffuse 0 phong 1/8 phong_size 10}    
scale 4*y
} 
texture {  
pigment {gradient z triangle_wave color_map {[.125 rgb .5][.1275 rgb .5 transmit 1]} scale 3 scale 1.15*z}
finish {ambient -.5 diffuse 0 phong 1/4 phong_size 10} 
scale 2
} 
texture {  
pigment {gradient x triangle_wave color_map {[.125 rgb .5][.1275 rgb .5 transmit 1]} scale 3 scale 1.15*x}
finish {ambient -.5 diffuse 0 phong 1/4 phong_size 10}  
scale 2
}
}
}
#end

union {
object {Scraper1(10,100,100,100,<.5,.5,1>)}
object {Scraper1(20,95,95,100,<.5,.5,1>) translate 10*y}  
object {Scraper1(40,80,80,50,<.5,.5,1>) translate 30*y} 
object {Scraper1(120,50,50,10,<.5,.5,1>) translate 70*y} 
rotate 45*y  

translate 900*z  
translate 100*y
}   
union {
object {Scraper1(600,40,40,50,<.5,1,.7>) translate -40*x}     
object {Scraper1(600,40,40,50,<.5,1,.7>) translate  40*x} 
rotate 45*y
translate <200,0,1000>
}

union {
object {Scraper1(500,50,100,10,<.5,.75,1>)}     
rotate 45*y
translate <100,0,1000>
} 

union {
object {Scraper1(250,101,201,50,<.5,.5,1>)}     
rotate 30*y
translate <300,0,1000>
} 
union {
object {Scraper1(400,150,101,100,<.75,.75,1>)}     
rotate 45*y
translate <400,0,1000>
}  
union {
object {Scraper1(650,101/2,200/2,10,<1,.75,.5>)}     
rotate 45*y
translate <500,0,1000>
}
union {
object {Scraper1(500,101/2,200/2,40,<.5,.75,1>)}     
rotate 60*y
translate <600,0,1000>
} 
union {
object {Scraper1(200,101,101,60,<1,.5,.5>)}     
rotate 45*y
translate <700,0,1000>
}
union {
object {Scraper1(450,101/2,200/2,10,<.75,.75,1>)}     
rotate 60*y
translate <-100,0,1000>
}

box {0,1
pigment {
image_map {
png "Amber"
once interpolate 2
}
}            
finish {ambient 1.5 diffuse 1}
scale <20,30,1>*2 
translate -10*x
rotate -30*y  
translate <190,0,300>
hollow on 
no_shadow 
} 
box {0,1
pigment {
image_map {
png "Amber"
once interpolate 2
}
}            
finish {ambient 2 diffuse 1}
scale <15,30,1>*2.5    
translate -7.5*x
rotate -25*y  
translate <170,0,310>
hollow on 
no_shadow 
} 
box {0,1
pigment {
image_map {
png "Amber"
once interpolate 2
}
}            
finish {ambient 2 diffuse 1}
scale <15,20,1>*2  
translate -7.5*x
rotate -30*y 
translate <180,0,300>
hollow on 
no_shadow 
}
 
box {0,1
pigment {
image_map {
png "Chestnut"
once interpolate 2
}
}            
finish {ambient 2 diffuse 1}
scale <30,30,1/3>*3
translate -15*x
rotate -20*y  
translate <170,0,320>
hollow on 
no_shadow 
}
box {0,1
pigment {
image_map {
png "Chestnut"
once interpolate 2
}
}            
finish {ambient 5 diffuse 2}
scale <30,40,1/3>*3
translate -15*x
rotate -20*y  
translate <210,0,330>
hollow on 
no_shadow 
}


#macro LightBeam(Color,Intensity,Sharpness,Rand) 
cone {0,2,50*x,10 scale <1,1,.01> 
texture {
pigment {
spherical 
pigment_map { 
[0 rgb Color transmit 1]
[.5 radial triangle_wave frequency 20 rotate 90*x translate -x*15 
pigment_map {
[Sharpness bozo color_map {[0 rgb Color transmit 1-Intensity][1 rgb Color transmit (1-Intensity)/2+1/2]}turbulence .25 scale 10 translate Rand]  
[1 rgb Color transmit 1]
}
scale 1/50
]  
}
scale 50
}
finish {ambient 1 diffuse 0 phong 0}        
} 

texture {
pigment {
spherical 
pigment_map { 
[0 rgb Color transmit 1]
[.5 radial triangle_wave frequency 20 rotate 90*x translate -x*15 
pigment_map {
[Sharpness bozo color_map {[0 rgb Color transmit (1-Intensity)/4+3/4][.25 rgb Color transmit 1]} scale 1/3 scale 50*x translate -Rand]  
[1 rgb Color transmit 1]
}
scale 1/50
]  
}
scale 50
}
finish {ambient 1 diffuse 0 phong 0}        
}
scale -x
no_shadow
hollow on
} 
#end 
#macro PointTo2(p)
  #local RotVector = <0, 0, 0>;
  #local Rd = vlength(p);
  #if(Rd != 0)
    #local RotVector = x*degrees(asin(p.y/Rd));
    #if(p.z != 0)
      #local RotVector = RotVector + y*degrees(atan2(p.x, p.z));
    #end
  #end
  rotate RotVector
#end
  
#macro Cable(Point1,Point2,CableRadius,SlackAmount,NumNodes,NumPoints)
#declare Point2 = <Point2.x,-Point2.y,Point2.z>
#declare TheCableSpline =
spline {
cubic_spline 
#declare P=0
#while (P<NumNodes)      
#local Dip = 1-pow(abs(P/NumNodes*2-1),2) 
P/NumNodes,<0,-Dip*SlackAmount,vlength(Point2-Point1)*(P/NumNodes)>   
#declare P=P+1
#end  
1,Point2 
}    
#declare CablewoBounds = 
union {
#declare C=0
#while (C<NumPoints)      
cylinder {TheCableSpline(C/NumPoints),TheCableSpline(C/NumPoints+(1/NumPoints))+.0001,CableRadius}
sphere {TheCableSpline(C/(NumPoints)),CableRadius}  
#declare C=C+1
#end  
sphere {Point2,CableRadius} 
PointTo2(Point2+Point1)
translate Point1    
pigment {rgb .375}
finish {ambient 0 diffuse 1 phong 2/3}
}
union {
CablewoBounds
bounded_by {box{max_extent(CablewoBounds),min_extent(CablewoBounds)}}
clipped_by {bounded_by}
}
#end
box {<-1000,0,0><10000,110,0> translate 600*z}



#declare HullBase1 = 
texture { 
pigment {   
crackle metric 1   
color_map {
[0 rgb 1]     
[1 rgb 1.5]
}
} 
normal {crackle metric 1  bump_size .125}
finish {ambient 0 diffuse .75 phong .175 phong_size 1 metallic}
}
#declare HullFore = 
texture {HullBase1 scale 2*z}
texture {Scarring scale 1/6 scale 3*z} 
texture {Scarring scale 2/3 scale 3*z}
texture {Dirt scale 1/2 scale 3*z}       

#declare VCasing = 
union {
bicubic_patch {
	type 1
	flatness 0
	u_steps 2
	v_steps 2
	<-0.480, 0.518, -0.250> <-0.455, 0.668, -0.250> <-0.388, 0.862, -0.250> <-0.320, 0.998, -0.250> 
	<-0.504, 0.376, -0.250> <-0.479, 0.526, -0.250> <-0.358, 0.923, -0.250> <-0.290, 1.059, -0.250> 
	<-0.524, 0.170, -0.289> <-0.368, 0.475, -0.355> <-0.308, 0.801, -0.299> <-0.224, 1.137, -0.250> 
	<-0.480, 0.038, -0.250> <-0.324, 0.344, -0.316> <-0.243, 0.822, -0.299> <-0.160, 1.158, -0.250> 
}
bicubic_patch {
	type 1
	flatness 0
	u_steps 2
	v_steps 2
	<-0.480, 0.518, -0.250> <-0.504, 0.376, -0.250> <-0.524, 0.170, -0.289> <-0.480, 0.038, -0.250> 
	<-0.561, 0.588, -0.175> <-0.585, 0.446, -0.175> <-0.573, 0.072, -0.268> <-0.530, -0.059, -0.229> 
	<-0.876, 0.726, -0.026> <-0.930, 0.508, -0.026> <-0.923, 0.219, -0.022> <-0.859, 0.003, -0.022> 
	<-0.750, 0.750, 0.000> <-0.804, 0.532, 0.000> <-0.814, 0.216, 0.000> <-0.750, 0.000, 0.000> 
}
bicubic_patch {
	type 1
	flatness 0
	u_steps 2
	v_steps 2
	<-0.480, 0.518, -0.250> <-0.561, 0.588, -0.175> <-0.876, 0.726, -0.026> <-0.750, 0.750, 0.000> 
	<-0.455, 0.668, -0.250> <-0.536, 0.737, -0.175> <-0.816, 0.970, -0.026> <-0.690, 0.994, 0.000> 
	<-0.388, 0.862, -0.250> <-0.406, 1.013, -0.175> <-0.656, 1.200, -0.047> <-0.524, 1.294, 0.000> 
	<-0.320, 0.998, -0.250> <-0.338, 1.149, -0.175> <-0.512, 1.405, -0.047> <-0.380, 1.500, 0.000> 
}
bicubic_patch {
	type 1
	flatness 0
	u_steps 2
	v_steps 2
	<-0.320, 0.998, -0.250> <-0.338, 1.149, -0.175> <-0.512, 1.405, -0.047> <-0.380, 1.500, 0.000> 
	<-0.290, 1.059, -0.250> <-0.308, 1.209, -0.175> <-0.443, 1.504, -0.047> <-0.311, 1.599, 0.000> 
	<-0.224, 1.137, -0.250> <-0.178, 1.322, -0.223> <-0.194, 1.508, -0.075> <-0.163, 1.682, 0.000> 
	<-0.160, 1.158, -0.250> <-0.114, 1.343, -0.223> <-0.088, 1.566, -0.075> <-0.057, 1.741, 0.000> 
}
bicubic_patch {
	type 1
	flatness 0
	u_steps 2
	v_steps 2
	<0.320, 0.998, -0.250> <0.388, 0.862, -0.250> <0.455, 0.668, -0.250> <0.480, 0.518, -0.250> 
	<0.290, 1.059, -0.250> <0.358, 0.923, -0.250> <0.479, 0.526, -0.250> <0.504, 0.376, -0.250> 
	<0.224, 1.137, -0.250> <0.308, 0.801, -0.299> <0.368, 0.475, -0.355> <0.524, 0.170, -0.289> 
	<0.160, 1.158, -0.250> <0.243, 0.822, -0.299> <0.324, 0.344, -0.316> <0.480, 0.038, -0.250> 
}
bicubic_patch {
	type 1
	flatness 0
	u_steps 2
	v_steps 2
	<0.320, 0.998, -0.250> <0.290, 1.059, -0.250> <0.224, 1.137, -0.250> <0.160, 1.158, -0.250> 
	<0.338, 1.149, -0.175> <0.308, 1.209, -0.175> <0.178, 1.322, -0.223> <0.114, 1.343, -0.223> 
	<0.512, 1.405, -0.047> <0.443, 1.504, -0.047> <0.194, 1.508, -0.075> <0.088, 1.566, -0.075> 
	<0.380, 1.500, 0.000> <0.311, 1.599, 0.000> <0.163, 1.682, 0.000> <0.057, 1.741, 0.000> 
}
bicubic_patch {
	type 1
	flatness 0
	u_steps 2
	v_steps 2
	<0.320, 0.998, -0.250> <0.338, 1.149, -0.175> <0.512, 1.405, -0.047> <0.380, 1.500, 0.000> 
	<0.388, 0.862, -0.250> <0.406, 1.013, -0.175> <0.656, 1.200, -0.047> <0.524, 1.294, 0.000> 
	<0.455, 0.668, -0.250> <0.536, 0.737, -0.175> <0.816, 0.970, -0.026> <0.690, 0.994, 0.000> 
	<0.480, 0.518, -0.250> <0.561, 0.588, -0.175> <0.876, 0.726, -0.026> <0.750, 0.750, 0.000> 
}
bicubic_patch {
	type 1
	flatness 0
	u_steps 2
	v_steps 2
	<0.480, 0.518, -0.250> <0.561, 0.588, -0.175> <0.876, 0.726, -0.026> <0.750, 0.750, 0.000> 
	<0.504, 0.376, -0.250> <0.585, 0.446, -0.175> <0.930, 0.508, -0.026> <0.804, 0.532, 0.000> 
	<0.524, 0.170, -0.289> <0.573, 0.072, -0.268> <0.923, 0.219, -0.022> <0.814, 0.216, 0.000> 
	<0.480, 0.038, -0.250> <0.530, -0.059, -0.229> <0.859, 0.003, -0.022> <0.750, 0.000, 0.000> 
}
bicubic_patch {
	type 1
	flatness 0
	u_steps 2
	v_steps 2
	<0.500, -0.086, 0.000> <0.201, -0.106, 0.000> <-0.201, -0.106, 0.000> <-0.500, -0.086, 0.000> 
	<0.579, -0.080, 0.000> <0.280, -0.101, 0.000> <-0.280, -0.101, 0.000> <-0.579, -0.080, 0.000> 
	<0.727, -0.076, 0.000> <0.286, -0.090, 0.090> <-0.286, -0.090, 0.090> <-0.727, -0.076, 0.000> 
	<0.750, 0.000, 0.000> <0.309, -0.014, 0.090> <-0.309, -0.014, 0.090> <-0.750, 0.000, 0.000> 
}
bicubic_patch {
	type 1
	flatness 0
	u_steps 2
	v_steps 2
	<0.500, -0.086, 0.000> <0.579, -0.080, 0.000> <0.727, -0.076, 0.000> <0.750, 0.000, 0.000> 
	<0.446, -0.049, -0.033> <0.525, -0.043, -0.033> <0.836, -0.073, -0.022> <0.859, 0.003, -0.022> 
	<0.339, -0.031, -0.095> <0.402, -0.031, -0.106> <0.510, -0.118, -0.212> <0.530, -0.059, -0.229> 
	<0.320, 0.038, -0.109> <0.383, 0.038, -0.120> <0.461, -0.021, -0.233> <0.480, 0.038, -0.250> 
}
bicubic_patch {
	type 1
	flatness 0
	u_steps 2
	v_steps 2
	<0.500, -0.086, 0.000> <0.446, -0.049, -0.033> <0.339, -0.031, -0.095> <0.320, 0.038, -0.109> 
	<0.201, -0.106, 0.000> <0.147, -0.069, -0.033> <0.150, -0.031, -0.061> <0.131, 0.038, -0.075> 
	<-0.201, -0.106, 0.000> <-0.147, -0.069, -0.033> <-0.150, -0.031, -0.061> <-0.131, 0.038, -0.075> 
	<-0.500, -0.086, 0.000> <-0.446, -0.049, -0.033> <-0.339, -0.031, -0.095> <-0.320, 0.038, -0.109> 
}
bicubic_patch {
	type 1
	flatness 0
	u_steps 2
	v_steps 2
	<-0.500, -0.086, 0.000> <-0.579, -0.080, 0.000> <-0.727, -0.076, 0.000> <-0.750, 0.000, 0.000> 
	<-0.446, -0.049, -0.033> <-0.525, -0.043, -0.033> <-0.836, -0.073, -0.022> <-0.859, 0.003, -0.022> 
	<-0.339, -0.031, -0.095> <-0.402, -0.031, -0.106> <-0.510, -0.118, -0.212> <-0.530, -0.059, -0.229> 
	<-0.320, 0.038, -0.109> <-0.383, 0.038, -0.120> <-0.461, -0.021, -0.233> <-0.480, 0.038, -0.250> 
}
bicubic_patch {
	type 1
	flatness 0
	u_steps 2
	v_steps 2
	<-0.057, 1.741, 0.000> <-0.163, 1.682, 0.000> <-0.311, 1.599, 0.000> <-0.380, 1.500, 0.000> 
	<-0.027, 1.757, 0.000> <-0.133, 1.699, 0.000> <-0.133, 1.727, 0.064> <-0.202, 1.628, 0.064> 
	<0.027, 1.757, 0.000> <0.133, 1.699, 0.000> <0.133, 1.727, 0.064> <0.202, 1.628, 0.064> 
	<0.057, 1.741, 0.000> <0.163, 1.682, 0.000> <0.311, 1.599, 0.000> <0.380, 1.500, 0.000> 
}
bicubic_patch {
	type 1
	flatness 0
	u_steps 2
	v_steps 2
	<-0.057, 1.741, 0.000> <-0.027, 1.757, 0.000> <0.027, 1.757, 0.000> <0.057, 1.741, 0.000> 
	<-0.088, 1.566, -0.075> <-0.058, 1.582, -0.075> <0.058, 1.582, -0.075> <0.088, 1.566, -0.075> 
	<-0.114, 1.343, -0.223> <-0.023, 1.374, -0.223> <0.023, 1.374, -0.223> <0.114, 1.343, -0.223> 
	<-0.160, 1.158, -0.250> <-0.069, 1.188, -0.250> <0.069, 1.188, -0.250> <0.160, 1.158, -0.250> 
}
bicubic_patch {
	type 1
	flatness 0
	u_steps 2
	v_steps 2
	<-0.480, 0.038, -0.250> <-0.480, 0.038, -0.250> <-0.480, 0.038, -0.250> <-0.480, 0.038, -0.250> 
	<-0.461, -0.021, -0.233> <-0.305, 0.285, -0.299> <-0.305, 0.285, -0.299> <-0.324, 0.344, -0.316> 
	<-0.383, 0.038, -0.120> <-0.295, 0.362, -0.185> <-0.291, 0.486, -0.257> <-0.243, 0.822, -0.299> 
	<-0.320, 0.038, -0.109> <-0.231, 0.362, -0.174> <-0.208, 0.822, -0.208> <-0.160, 1.158, -0.250> 
}
bicubic_patch {
	type 1
	flatness 0
	u_steps 2
	v_steps 2
	<0.480, 0.038, -0.250> <0.480, 0.038, -0.250> <0.480, 0.038, -0.250> <0.480, 0.038, -0.250> 
	<0.324, 0.344, -0.316> <0.305, 0.285, -0.299> <0.305, 0.285, -0.299> <0.461, -0.021, -0.233> 
	<0.243, 0.822, -0.299> <0.291, 0.486, -0.257> <0.295, 0.362, -0.185> <0.383, 0.038, -0.120> 
	<0.160, 1.158, -0.250> <0.208, 0.822, -0.208> <0.231, 0.362, -0.174> <0.320, 0.038, -0.109> 
}
bicubic_patch {
	type 1
	flatness 0
	u_steps 2
	v_steps 2
	<-0.320, 0.038, -0.109> <-0.131, 0.038, -0.075> <0.131, 0.038, -0.075> <0.320, 0.038, -0.109> 
	<-0.231, 0.362, -0.174> <-0.042, 0.362, -0.140> <0.042, 0.362, -0.140> <0.231, 0.362, -0.174> 
	<-0.208, 0.822, -0.208> <-0.117, 0.852, -0.208> <0.117, 0.852, -0.208> <0.208, 0.822, -0.208> 
	<-0.160, 1.158, -0.250> <-0.069, 1.188, -0.250> <0.069, 1.188, -0.250> <0.160, 1.158, -0.250> 
}
bicubic_patch {
	type 1
	flatness 0
	u_steps 2
	v_steps 2
	<0.380, 1.500, 0.000> <0.202, 1.628, 0.064> <-0.202, 1.628, 0.064> <-0.380, 1.500, 0.000> 
	<0.524, 1.294, 0.000> <0.346, 1.422, 0.064> <-0.346, 1.422, 0.064> <-0.524, 1.294, 0.000> 
	<0.690, 0.994, 0.000> <0.256, 1.075, 0.088> <-0.256, 1.075, 0.088> <-0.690, 0.994, 0.000> 
	<0.750, 0.750, 0.000> <0.316, 0.832, 0.088> <-0.316, 0.832, 0.088> <-0.750, 0.750, 0.000> 
}
bicubic_patch {
	type 1
	flatness 0
	u_steps 2
	v_steps 2
	<0.750, 0.750, 0.000> <0.804, 0.532, 0.000> <0.814, 0.216, 0.000> <0.750, 0.000, 0.000> 
	<0.316, 0.832, 0.088> <0.370, 0.613, 0.088> <0.374, 0.202, 0.090> <0.309, -0.014, 0.090> 
	<-0.316, 0.832, 0.088> <-0.370, 0.613, 0.088> <-0.374, 0.202, 0.090> <-0.309, -0.014, 0.090> 
	<-0.750, 0.750, 0.000> <-0.804, 0.532, 0.000> <-0.814, 0.216, 0.000> <-0.750, 0.000, 0.000> 
}
}

#macro Ventilator(Rand,Steam)
// Layer 1 
union {
object {VCasing texture {HullFore scale .25 scale 2*y translate Rand} 
}  
#declare C=0
#while (C<10)
object {RRRBox scale <2,.1,1/2> translate <-1,-.1/2,-1/4> rotate -45*x scale 1/2 scale .75*x scale x*((1-(C/10))/2+1/2)  translate <0,0,-1/5> translate (C/8)*y
pigment {rgb .75} 
texture {Scarring scale 1/4 scale 2*y scale 1/4 translate Rand}             
texture {Scarring scale 1/8 scale 4*y scale 1/4 translate Rand}
texture {Scarring scale 1/12 scale 1/4 translate Rand}
texture {Dirt scale 1/4 scale 1/4 translate Rand}
}
#declare C=C+1
#end 
#if (Steam = on)
sphere {0,1  hollow no_shadow
pigment {rgbt 1}
interior { 
media {
method 2
emission <1,.9,.8>*1.5/3
density {spherical}
density {spherical turbulence 1 scale 2 warp {turbulence 1/2} scale 1/2 }       
} 
} 
rotate -Rand*360
translate <0,1/2,-1/2>
}
sphere {0,1  hollow no_shadow
pigment {rgbt 1}
interior { 
media {
method 2
emission <1,.9,.8>*.75/3
density {spherical}
density {spherical turbulence 1 translate Rand scale 2 warp {turbulence 1/2} scale 1/2 translate -Rand}       
} 
}
rotate Rand*360
translate <0,1,-3/2>
}
#end
}
#end