#version unofficial MegaPov 0.4;
#declare BlobBound = true
/*global_settings {
max_trace_level 20  
//radiosity {count 3 media on}

}

//light_source {light_loc rgb 1}  
light_source {<400,200,150> rgb <1,.875,.75> cylinder point_at 0
radius 100000
falloff 20000000 
tightness .25    
area_light 10,10,4,4  
circular
jitter
orient
}
light_source {<-50,30,-60>*200000 rgb <.875,.85,1>/6 shadowless}


 
camera {
location <0,5,-20>
look_at <0,25,200>
}



#declare Scarring =
texture {pigment {bozo color_map {[0 rgb .175 transmit .75][1 rgb .175 transmit 1]}scale 2}}
texture {pigment {bozo pigment_map {[0 bozo color_map {[0 rgb .125 transmit .75][1 rgb .125 transmit 1]}scale .125][.5 rgb .175 transmit 1]}scale 2}translate 25}
#declare Rusting2 =
texture {pigment {bozo color_map {[0 rgb <1,.5,.4> transmit .875][1 rgb <1,.5,.4> transmit 1]}scale 2}}
texture {pigment {bozo pigment_map {[0 bozo color_map {[0 rgb <1,.5,.4> transmit .875][1 rgb <1,.5,.4> transmit 1]}scale .125][.5 rgb .175 transmit 1]}scale 2}translate 25}
#declare Chipping =
texture {pigment {bozo pigment_map {[.4 bozo color_map {[.2 rgb 1 transmit .25][.3 rgb 1 transmit 1]} turbulence 1/2 scale .125/2][.5 rgb .175 transmit 1]}scale 8}}
*/

#declare Test =
function {
    (noise3d(x,y,z)^0.3)
    *noise3d(x*5,y*5,z*5)
    *(noise3d(x*20,y*20,z*20)^0.3)
} 
#declare Test2 =
function {
    (noise3d(x,y,z)^2)
    *noise3d(x*5,y*5,z*5)
    *(noise3d(x*20,y*20,z*20)^0.3)
}
#macro RBoxM(W,H,L)
isosurface{
function{(x^(12*W)+y^(2*H)+z^(12*L))}
threshold 1
contained_by {box{-1,1}}
translate <1,1,1>
scale .5
scale <W,H,L>   
}
#end 

#declare RustedTex1 =
texture {
pigment { function {Test} triangle_wave
pigment_map {
[.7 bozo color_map {[.4 rgb 1][.5 rgb <.6,.65,.8>][.6 rgb .65]} turbulence 1 scale 1/2]
[.8 bozo color_map {[0 rgb <.6,.4,.3>][1 rgb <.6,.5,.4>*1.5]} scale 1/3]
}
scale 1.5
}

normal { function {Test2} bump_size 1/3 scale 1/4} 
finish {ambient .05 diffuse 1 phong 1.5 metallic phong_size 10}
}
texture {Scarring scale 1/16}
texture {Chipping scale 1/16}
texture {Scarring scale 1/16 scale 4*y}
texture {Scarring scale 1/32}
texture {Rusting2 scale 1/5 scale 2*z}
#declare NonRustedTex1 =  
texture {
pigment {rgb .5}
finish {ambient .05 diffuse 1 phong 4 phong_size 10 metallic reflection .25 conserve_energy}
}
texture {Scarring scale 1/16}
texture {Chipping scale 1/16}
texture {Scarring scale 1/16 scale 4*y}
texture {Scarring scale 1/32} 
texture {Rusting2 scale 1/5 scale 2*z}


#declare Carapace_Part1 = 
union {
blob {threshold .1
sphere {0,1.0,1/2}
sphere {0,1.1,1/4}
sphere {0,1.2,1/4}
                     
#macro FeatheredSphere(Center,Radius,Power,Scale,Rotate,Tanslate)
sphere {Center,Radius*1.0,Power/2 scale Scale rotate Rotate translate Tanslate}  
sphere {Center,Radius*1.1,Power/4 scale Scale rotate Rotate translate Tanslate}
sphere {Center,Radius*1.2,Power/4 scale Scale rotate Rotate translate Tanslate} 
#end    
#macro FeatheredSphere2(Center,Radius,Power,Scale,Rotate,Tanslate)
sphere {Center,Radius*1.0,Power/2 scale Scale rotate Rotate translate Tanslate}  
sphere {Center,Radius*1.2,Power/4 scale Scale rotate Rotate translate Tanslate}
sphere {Center,Radius*1.4,Power/4 scale Scale rotate Rotate translate Tanslate} 
#end    

FeatheredSphere(0,.9005,-1/2,0,0,0)  
FeatheredSphere(0,.901,-1/2,0,0,0)

FeatheredSphere2(0,.425,-1/6,<1,4,1>,0,y)    
FeatheredSphere2(0,.4,-1/6,<1,4,1>,0,y) 
FeatheredSphere2(0,1,-1/10,<4,1/2,4>,0,-y/2)
FeatheredSphere2(0,1,-1/2,<4,1/2,4>,0,-y/2-.1) 
FeatheredSphere2(0,1,-1/60,<.125/8,4,4>,0,0)
FeatheredSphere2(0,1,-1/60,<.125/7,4,4>,0,0)          

FeatheredSphere2(0,1,-1/60,<.125/4,.5,4>,0,0)
FeatheredSphere2(0,1,-1/60,<.125/3,.5,4>,0,0)  

FeatheredSphere2(0,.3,-1/60,<.25,.175,.25>,0,<0,.375,-.625>)
FeatheredSphere2(0,.4,-1/60,<.25,.175,.25>,0,<0,.375,-.625>)
FeatheredSphere2(0,.5,-1/60,<.25,.175,.25>,0,<0,.375,-.625>)

FeatheredSphere2(0,.3,-1/60,<.75,.3875,1>,0,<0,0,-.625>)
FeatheredSphere2(0,.4,-1/60,<.75,.3875,1>,0,<0,0,-.625>)
FeatheredSphere2(0,.5,-1/60,<.75,.3875,1>,0,<0,0,-.625>) 

FeatheredSphere2(0,.3,-1/48,<.5,.375,100>, 45*y,<-.2,.3,0>)
FeatheredSphere2(0,.4,-1/48,<.5,.375,100>, 45*y,<-.2,.3,0>)
FeatheredSphere2(0,.5,-1/48,<.5,.375,100>, 45*y,<-.2,.3,0>)
FeatheredSphere2(0,.3,-1/48,<.5,.375,100>,-45*y,<0.2,.3,0>)
FeatheredSphere2(0,.4,-1/48,<.5,.375,100>,-45*y,<0.2,.3,0>)
FeatheredSphere2(0,.5,-1/48,<.5,.375,100>,-45*y,<0.2,.3,0>)  

FeatheredSphere(0,.6,1/48,<.5,.375,100>, 45*y,<-.2,.3,0>)
FeatheredSphere(0,.6,1/48,<.5,.375,100>,-45*y,<0.2,.3,0>)
//bounded_by {box {<-.875,-.1,-.875>,<.875,.55,.875>}}
//clipped_by {bounded_by}
scale <1,1.1,1>
}
texture {RustedTex1 scale 1/2}   
texture {
pigment {
image_map {png "SFPDTex" once interpolate 2}
}  
finish {ambient 0 diffuse 2}          
scale <.875*2,.7,1>
translate <-.875,-.1,0> 
}
#if (BlobBound = true)  
bounded_by {cylinder {-.1*y,y*.6,.875}}
clipped_by {bounded_by}
#end
}



#declare Eye1_Part1 = 
blob {threshold .1
cylinder {-x/3,x/3,1,1 scale <1,1,1>}
cylinder {-x/3,x/3,.75 ,-1 scale <1,1,2>} 
cylinder {-x/3,x/3,.625,-2 scale <1,1,2>}    
sphere {0,1.75,1/5}
}  
#declare Eye1_Part2 = 
blob {threshold .1
cylinder {-x/3,x/3,.75,1 scale <1,1,1>}
sphere {0,2,1/8}
}
#declare Eye1 =
union {
object {Eye1_Part1} 
object {Eye1_Part2 
pigment {rgbt .9}
finish {ambient 0 diffuse 2 phong 3}   
interior {
media {
emission <.25,.5,1>*1.5/.1/3
density {
spherical  
color_map {
[0 rgb 0]
[2/3 rgb .75]
[1 rgb 20]
}
scale 2/3
}
}
}
hollow
}     
light_source {0 rgb <.25,.5,1>/2 fade_distance 2/3/10*3 fade_power 2}
texture {NonRustedTex1 scale 1/.1}       
hollow
}  
#declare Eye2_Part1 =
union {
torus {.5,.25 scale 4*y}
cylinder {-y*2,0,.75} 
}
#declare Eye2_Part2 =
blob {threshold .1
cylinder {0,y*1.75,.625,1 scale y/2}
}
#declare Eye2 =
union {
object {Eye2_Part1}    
object {Eye2_Part2
pigment {rgbt .9}
finish {ambient 0 diffuse 2 phong 3}   
interior {
media {
emission <1,.4,.2>*2/.25/.25/3
density {
spherical
color_map {
[0 rgb 0]
[2/3 rgb <1,.5,.25>]
[1 rgb 20]
}
scale 1/2      
translate .75*y
}
}
}
hollow
}     
light_source {1*y rgb <1,.3,.2>/2 fade_distance 2/3/10*3 fade_power 2}
scale 1/4
rotate -90*x
}

 

#declare Detail1 =
union {
object {RBoxM(1,1,1)
scale <1/2,1/2,1.5> 
translate <-1/4,-1/4,-1/4>
rotate 120*x
}  
object {RBoxM(1,1,1.25)
scale <1/4,1/2,1.5> 
translate <-1/8,-1/4,-1/4>
rotate 120*x
translate -y*.75
}
object {RBoxM(1,1,1.5)
scale <1/2,1/2,1.5> 
translate <-1/4,-1/4,-1/4>
rotate 120*x  
translate -y
} 
scale 1/4
}
#declare Detail2 =
union {
torus {.5,.25 scale 4*y}  
cylinder {-y*2,0,.75}    
#declare C=0
#while (C<360)
blob {threshold .1
cylinder {y*.75,-y,.125,1 translate .625*z rotate C*y}
}
#declare C=C+20
#end

scale 1/4
rotate -90*x
}
#declare Detail2a =
union {
torus {.5,.25 scale 4*y}  
torus {.375,.25 scale 4*y}
cylinder {-y*2,0,.75} 
difference {
cylinder {y,0,.5}
cylinder {y*2,0,.375}  
}
scale 1/4 
rotate -90*x
} 
#declare Detail2b =
union {
torus {.5,.25 scale 4*y}  
torus {.25,.25 scale 4*y}
cylinder {-y*2,0,.75} 
difference {
cylinder {y,0,.5}
cylinder {y*2,0,.25}  
}
scale 1/4 
rotate -90*x
}
#declare Detail2c =
union {
torus {.5,.25 scale 4*y}  
torus {.25,.25 scale 4*y translate .25*z} 
torus {.25,.25 scale 4*y translate .25*z rotate  120*y}
torus {.25,.25 scale 4*y translate .25*z rotate  -120*y}
cylinder {-y*2,0,.75} 
difference {
cylinder {y,0,.5}
cylinder {y*2,0,.25 translate .25*z}   
cylinder {y*2,0,.25 translate .25*z rotate  120*y}
cylinder {y*2,0,.25 translate .25*z rotate -120*y}
}
scale 1/4 
rotate -90*x
} 
#declare Detail2d =
union {
torus {.5,.25 scale 4*y}  
torus {.375,.25 scale 4*y}
cylinder {-y*2,0,.75} 
cylinder {y,0,.5}
scale 1/4 
rotate -90*x
}


#declare Test =
function {
((noise3d(x,y,z)^1.5)  
*noise3d(x*2,y*2,z*2)
*noise3d(x*3,y*3,z*3)      
*noise3d(x*8,y*8,z*8) 
*noise3d(x*200,y*100,z*200)) 
} 
#declare Test2 =
function {
((noise3d(x,y,z)^.5)   
*noise3d(x*2,y*2,z*2)
*noise3d(x*8,y*8,z*8)
*noise3d(x*3+5,y*3+5,z*3+5)  
*noise3d(x*60,y*60,z*60) 
*noise3d(x*200,y*100,z*200)) 
} 
#declare Bump = 
function {
pigment { planar
pigment_map {
[0 rgb 0] 
[.5 function {Test(x,y,z)} triangle_wave pigment_map {
[.2 rgb 0] 
[.25 function {Test} color_map {[.4 rgb .5][.6 rgb .5]}turbulence 1 scale 1/4 ]}
translate y
]
[.625 function {Test(x,y,z)} triangle_wave pigment_map {
[0 rgb 0] 
[.25 function {Test} color_map {[.4 rgb .5][.6 rgb .5]}turbulence 1 scale 1/4 ]}
translate y 
scale 2/3
]
[.75 function {Test2(x,y,z)} triangle_wave pigment_map {
[.125/2 rgb 0] 
[.125 function {Test2} color_map {[.4 rgb .5][.6 rgb .5]}turbulence 1 scale 1/4 ]}
translate y  
scale 1/2

] 
} 
scale 8
warp {turbulence 4}
scale 1/8
warp {reset_children}
scale 1
}
}


#declare SlimeyTex1 =
texture {pigment {planar 
pigment_map {[0 rgb <1,.5,.5>*4.25 transmit .375 filter .125][.5 bozo color_map {[.3 rgb .2][.7 rgb .2 transmit .75]}scale 1/12 lambda 1]}
scale 12 warp{turbulence .5} scale 1/12 scale y translate -y*1.25}
//normal {bumps scale .0001 bump_size 4}
finish {ambient .25 diffuse 1}
}
texture {pigment {bozo pigment_map {[.7 bozo color_map {[.5 rgb 1 transmit .625][.6 rgb 1 transmit 1]} turbulence 1/2 scale .125/2][.75 rgb .175 transmit 1]}scale 8}
scale <1,3,1>
}
texture {
pigment { planar 
pigment_map {  
[0 rgb 0 transmit 1]
[.5 function {Test(x,y,z)} triangle_wave pigment_map {
[.2 rgb 0 transmit 1] 
[.25 bozo color_map {[0 rgb <.3,.32,.2>/2][.5 rgb .15][1 rgb <.2,.25,.2>/3]}turbulence 2 scale 1/16]}
translate y
]
[.625 function {Test(x,y,z)} triangle_wave pigment_map {
[0 rgb <1,1,.8> transmit 1] 
[.25 bozo  color_map {[0 rgb <.3,.32,.2>/2][.5 rgb .15][1 rgb <.2,.25,.2>/3]}turbulence 2 scale 1/16]}
translate y 
scale 2/3
]
[.75 function {Test2(x,y,z)} triangle_wave pigment_map {
[0 rgb <1,1,.8>/3 transmit 1] 
[.125*3/4 bozo  color_map {[0 rgb <.3,.32,.2>/2][.5 rgb .15][1 rgb <.2,.25,.2>/3]}turbulence 2 scale 1/16]}
translate y 
scale 1/2
] 
}
scale 8
warp {turbulence 4}
scale 1/8
warp {reset_children}
scale y*1.25
}
normal {function {Bump(x,y,z)} bump_size 2}
finish {ambient .25 diffuse 2 phong 1 }
translate y*.625
}
#declare SlimeBulb = 
union {
difference {
sphere {0,1 scale .625
hollow  
texture {SlimeyTex1 scale 1.5*y translate -.625*y}
interior { 
media {
emission <1,.5,.5>*2/3
absorption (1-<.9,.5,.5>)*2/3
method 2   
intervals 2
density {
bozo
color_map {
[0 rgb 0]
[1 rgb 1]
}
turbulence 1.5 
lambda 1
scale 1/4
} 
density {
bozo
color_map {
[0 rgb 0]
[1 rgb 1]
}
scale 1/2
}
scale 2/3
}
} 
}
disc {0,-y,1}
}
}
#declare Cage =
difference { 
union {
torus {.575,.125/4 rotate 90*z scale 2*x translate -x/4}   
torus {.575,.125/4 rotate 90*z scale 2*x translate x/4}
//torus {.625,.125/4 rotate 90*z scale 2*x}  
}
disc {0,-y,1}
texture {RustedTex1}
}

#declare CopperBot = 
union {
object {Carapace_Part1}
sphere {0,.5 scale y/2 translate y/3 
texture {RustedTex1 scale 1/2} 
texture {
pigment {
planar 
color_map {
[.5 rgb <.125,.15,1> transmit 0 filter .25]
[.5 rgb <.125,.15,1> transmit 1]
}
rotate 90*z 
translate -x/2
}
finish {ambient 0 diffuse 1 phong 1.5 metallic}          
}
}   
union {
torus {.4875,.025 translate 1/2*y}
torus {.45,.0125 translate 1/2*y}
torus {.4125,.025 translate .4875*y}
pigment {rgb .25}
finish {ambient 0 diffuse 1/2 phong 4 phong_size 10 metallic reflection .5 conserve_energy}
normal {radial frequency 120 triangle_wave bump_size 1/16}                                                   
texture {Scarring scale 1/48}  
texture {Scarring scale 1/48 scale 2*z}
}
union {
object {Eye1 scale .1 rotate 10*x translate <0,.4,-.575>}  
object {Eye2 scale .25 rotate -20*y translate <.20,.1,-.575>}  
object {Eye2 scale .25 rotate <-20,-30,0> translate <.25,.125/2,-.55>} 

object {Eye2 scale .25 rotate <0,10,0> translate <-.15,.1,-.6>}
object {Eye2 scale .25 rotate <0,15,0> translate <-.25,.0875,-.6>}

//Middle Stuff                                                                   
object {Detail2 scale .25 rotate <0,0,0> translate <0,-.025,-.6>}
object {Detail2c scale .15 rotate <0,0,90> translate <0,-.025,-.675>} 
object {Detail2 scale .4 rotate <-30, 15,0> translate <-.075,0,-.6>}
object {Detail2 scale <1,1,.5>*.4 rotate <-30,-15,0> translate < .075,0,-.6>}

//Right Stuff
object {Detail2a scale .25 rotate <-15, 15,0> translate <-.06,.1,-.625>} 
object {Detail2 scale .25 rotate <0,0,0> translate <-.08,.165,-.625>}
object {Detail2b scale .15 rotate <0,0,0> translate <-.08,.165,-.7>} 
object {Detail2c scale .25 rotate <-10,30,0> translate <-.2,0,-.6>}
object {Detail2d scale .25 rotate <-10,35,0> translate <-.3,.025,-.55>}
object {Detail2 scale .1 rotate <0,30,0> translate <-.25,0,-.6>}
object {Detail2 scale .1 rotate <0,30,0> translate <-.25,.05,-.6>} 
object {Detail2 scale .1 rotate <-30,40,0> translate <-.375,0,-.55>}  
object {Detail2 scale .1 rotate <-30,45,0> translate <-.4,0,-.5>}  
object {Detail2 scale .1 rotate <0,40,0> translate <-.375,.025,-.55>}  
object {Detail2 scale .1 rotate <0,45,0> translate <-.4,.025,-.5>}  

//Left Stuff
object {Detail2 scale .1 rotate <0,0,0> translate <.1,.135,-.7>}
object {Detail2 scale .1 rotate <0,0,0> translate <.1,.1,-.7>}   
object {Detail2 scale .1 rotate <0,0,0> translate <.0625,.14,-.7>}
object {Detail2 scale .1 rotate <0,0,0> translate <.0625,.105,-.7>} 
object {Detail2a scale .25 rotate <5,5,0> translate <.08,.1875,-.625>} 
object {Detail2d scale .175 rotate <20,10,0> translate <.15,.15,-.625>}
object {Detail2d scale .2 rotate <-10,-20,0> translate <.175,.025,-.625>} 
object {Detail2c scale .2 rotate <-10,-20,0> translate <.35,.05,-.575>}
object {Detail2 scale .1 rotate <-5,-20,0> translate <.3,.075,-.575>}
object {Detail2 scale .1 rotate <-5,-20,0> translate <.4,.075,-.575>}
object {Detail2d scale .2 rotate <-5,-20,0> translate <.35,.1,-.55>} 

//Under Wire Connector
object {Detail2 scale .25 rotate <-15,-10,0> translate <.075,-.05,-.425>} 

//Side Wide Ports 
object {Detail2c scale .75 scale z/6 rotate <20,-45,0> translate <.55,.325,-.4>}
object {Detail2 scale .75 scale z/3 rotate <20,45,0> translate <-.55,.325,-.4>}

//Inner Armor
union {
difference {
sphere {0,.625}
disc {0,-y,1 translate .45}       
disc {0,y,1} 
}  
cylinder {0,-.025*y,.6}
torus {.6,.025}
texture {NonRustedTex1 scale 1/2}
}   
union {
object {Detail1 scale .575*x translate  (.065+.065/2)*x}     
object {Detail1 scale .575*x translate  (.065-.065/2)*x}
object {Detail1 scale .575*x translate  (-.065+.065/2)*x}     
object {Detail1 scale .575*x translate  (-.065-.065/2)*x}
scale 1/3
translate <0,.275,-.6>
texture {NonRustedTex1 scale 2*z+1/2} 
}
texture {NonRustedTex1 scale 1/2} 
}  

#declare Tube1 = //Red 
spline {
cubic_spline
0,<.1,.135,-.7-.025>        
1/4,<.175,0,-.8>    
2/4,<.125,-.15,-.75>
3/4,<.15,-.1,-.65>    
1,<.075,-.05,-.5>    
}
#declare Tube2 = //Green
spline {
cubic_spline
0,<.1,.1,-.7-.025>        
1/4,<.15,-.05,-.8>
2/4,<.1,-.15,-.7>      
3/4,<.075,-.1,-.6>   
1,<.05,-.05,-.5>    
}
#declare Tube3 =  //Blue
spline {
cubic_spline
0,<.0625,.14,-.7-.025>        
1/4,<.1,.05,-.8>
2/4,<.075,0,-.8> 
3/4,<.04,-.15,-.7> 
1,<.05,-.05,-.5>    
}
#declare Tube4 = //White
spline {
cubic_spline
0,<.0625,.105,-.7-.025>        
1/4,<.15,.05,-.775>
2/4,<.05,-.05,-.75>
3/4,<.075,-.125,-.65>    
1,<.05,-.05,-.5>    
}
union {
blob { 
threshold 0.1 
#local c=0;
#while (c<50)     
sphere { 0,0.0125,1  translate Tube1(c/50)}
#local c=c+1/3;
#end 
}
blob { 
threshold 0.1 
#local c=0;
#while (c<50)     
sphere { 0,0.0125,1  translate Tube2(c/50)}
#local c=c+1/3;
#end 
}
blob { 
threshold 0.1 
#local c=0;
#while (c<50)     
sphere { 0,0.0125,1  translate Tube3(c/50)}
#local c=c+1/3;
#end 
}
blob { 
threshold 0.1 
#local c=0;
#while (c<50)     
sphere { 0,0.0125,1  translate Tube4(c/50)}
#local c=c+1/3;
#end 
}
texture {NonRustedTex1 scale 1/4} 
}               
} 


#macro RotatingLight(Color,Color2,Rot,Lit)
// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Cone
      // Name: NoName
      object
      {
         cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75  }

         scale < 3, 1, 3 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

         scale < 2, 0.25, 2 >
         translate < 0, 1, 0 >
      }
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Union
            // Name: 'or'
            object
            {
               merge
               {
                  // Object type: Cone
                  // Name: NoName
                  object
                  {
                     cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75  }

                     scale < 2, 3, 2 >
                     translate < 0, 1.1875, 0 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 1.25, 3.375, 1.25 >
                     translate < 0, 1, 0 >
                  }
                  // Object type: Torus
                  // Name: NoName
                  object
                  {
                     torus { 1.25, 0.25 }

                     scale < 1, 0.75, 1 >
                     translate < 0, 4.1875, 0 >
                  }
               }
            }
            // Object type: Union
            // Name: 'or'
            object
            {
               merge
               {
                  // Object type: Cone
                  // Name: NoName
                  object
                  {
                     cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75  }

                     scale < 1.9, 3, 1.9 >
                     translate < 0, 1.0938, 0 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 1.1875, 3.375, 1.1875 >
                     translate < 0, 0.90625, 0 >
                  }
                  // Object type: Torus
                  // Name: NoName
                  object
                  {
                     torus { 1.25, 0.25 }

                     scale < 0.95, 0.75, 0.95 >
                     translate < 0, 4.0938, 0 >
                  }
               }
            }
         }
         pigment {rgbft <Color.x*1.25,Color.y*1.25,Color.z*1.25,.5,.25>}  
         #if (Lit = true) 
         finish {ambient 1 diffuse 1 phong 10}
         #else
         finish {diffuse 1 phong 10}         
         #end
      }
      union {
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

         scale < 0.25, 1.5, 0.25 >
         translate < 0, 1, 0 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

         scale < 0.375, 0.625, 0.375 >
         translate < 0, 2.5, 0 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

         scale < 0.25, 0.875, 0.25 >
         translate < 0, 3.125, 0 >
      }
      // Object type: Paraboloid
      // Name: NoName
      object
      {
         object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

         scale < 1, 0.5, 1 >
         rotate < 0, 0, 90 >
         translate < -0.375, 2.5, 0 >
      }
      // Object type: Paraboloid
      // Name: NoName
      object
      {
         object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

         scale < 1, 0.5, 1 >
         rotate < 0, 0, -90 >
         translate < 0.375, 2.5, 0 >
      } 
      pigment {rgb 1}
      finish {ambient 0 diffuse 1 phong 1 reflection 1 conserve_energy}
      } 
#if (Lit = true)      
sphere {0, 1 hollow on  no_shadow
pigment {rgbt 1}
interior {
media{
emission 1/8*2.5 
method 2
density { spherical 
color_map{
[0.0 rgb Color2*0]
[0.5 rgb Color2]
[1.0 rgb Color2]
}
}
}
}
scale 3
translate < 1, 2.5, 0 >
}
sphere {0, 1 hollow on  no_shadow
pigment {rgbt 1}
interior {
media{
emission 1/8*2.5 
method 2
density { spherical 
color_map{
[0.0 rgb Color2*0]
[0.5 rgb Color2]
[1.0 rgb Color2]
}
}
}
}
scale 3
translate < -1, 2.5, 0 >
}
// Object type: OmniLight
// Name: Omni Light
light_source
{
   < 0.625, 2.5, 0 >
   color rgb (Color+Color2)/2*4 
   spotlight
   point_at <4,0,0>
   radius 10000*100000  
   falloff 11000*100000  
}

// Object type: OmniLight
// Name: Omni Light
light_source
{
   < -0.625, 2.5, 0 >
   color rgb (Color+Color2)/2*4  
   spotlight
   point_at <-4,0,0>
   radius 10000*100000  
   falloff 11000*100000  
}
#end
}
hollow on
pigment {rgb .5}
finish {ambient 0 diffuse 1 phong 1}
texture {Scarring}   
texture {Scarring scale 2 scale 2*y}
texture {Scarring scale 3 scale 2*y}
texture {Dirt scale 2 scale 2*y}    
rotate Rot*y
}      
#end  
  
