#version unofficial MegaPov 0.4;

#declare Blanket =  
blob {threshold .1      
///Basic Shape
sphere {0,1,1/2   scale <.75,1,.875>}
sphere {0,1.2,1/4 scale <.75,1,.875>}
sphere {0,1.4,1/4 scale <.75,1,.875>}
//Cuts
sphere {0,.75,-4 scale <.75,1,.875>}
sphere {0,1,-1/2 scale <25,.5,25>translate <0,-.625,0>}    
sphere {0,1.1,-1/4 scale <25,.5,25>translate <0,-.625,0>}
sphere {0,1.2,-1/4 scale <25,.5,25>translate <0,-.625,0>}
sphere {0,.95,-1 scale <1.0125,1,.875> translate 1/2*z}
sphere {0,.95,-1/4 scale <2,.5,.875> translate 1/2*z}
//Arm Folds
sphere {0,1,-1/16 scale <.25,.625,1> rotate <0,-35,10>  translate <.625,.5,-.5>}   
sphere {0,1.5,1/16 scale <.25,.625,1> rotate <0,-35,10> translate <.625,.5,-.5>}   
sphere {0,1,-1/16 scale <.25,.625,1> rotate <0,-35,10>  translate <.625,.5,-.5> scale -x} 
sphere {0,1.5,1/16 scale <.25,.625,1> rotate <0,-35,10> translate <.625,.5,-.5> scale -x} 
//Wrinkles on Arm folds 
sphere {0,2,-1/20 scale <.25,.1,.5> rotate 10*z     translate <.25,1,-1>}
sphere {0,1.5,-1/20 scale <.25,.1,.5> rotate -40*z  translate <.375,.75,-1>}
sphere {0,1,-1/20 scale <.25,.3,.5> rotate 30*z     translate <.5,.5,-1>}
sphere {0,1.25,-1/20 scale <.25,.1,.5> rotate -20*z translate <.625,.375,-1>}
sphere {0,1.5,-1/60 scale <.25,.2,.5> rotate 40*z   translate <.75,0,-1>}      
sphere {0,2,-1/20 scale <.25,.1,.5> rotate 10*z     translate <-.25,1,-1>}
sphere {0,1.5,-1/20 scale <.25,.1,.5> rotate -40*z  translate <-.375,.75,-1>}
sphere {0,1,-1/20 scale <.25,.3,.5> rotate 30*z     translate <-.5,.5,-1>}
sphere {0,1.25,-1/20 scale <.25,.1,.5> rotate -20*z translate <-.625,.375,-1>}
sphere {0,1.5,-1/60 scale <.25,.2,.5> rotate 40*z   translate <-.75,0,-1>}
sphere {0,2,-1/4 scale <.25,.1,1> rotate 10*z     translate <.75,1,-1>}
sphere {0,2,-1/20 scale <.25,.2,1> rotate -40*z   translate <.875,.75,-1>}
sphere {0,2,-1/35 scale <.25,.2,.75> rotate 30*z   translate <1,.5,-1>}
sphere {0,2,-1/35 scale <.25,.1,.75> rotate -20*z   translate <1,.25,-1>}
sphere {0,2,-1/35 scale <.25,.2,.75> rotate 10*z   translate <1,0,-1>}  
sphere {0,2,-1/4 scale <.25,.1,1> rotate 10*z     translate <-.75,1,-1>}
sphere {0,2,-1/20 scale <.25,.2,1> rotate -40*z   translate <-.875,.75,-1>}
sphere {0,2,-1/35 scale <.25,.2,.75> rotate 30*z  translate <-1,.5,-1>}
sphere {0,2,-1/35 scale <.25,.1,.75> rotate -20*z translate <-1,.25,-1>}
sphere {0,2,-1/35 scale <.25,.2,.75> rotate 10*z  translate <-1,0,-1>}
//Wrinkles between legs
sphere {0,1.5,-1/20 scale <.25,.125,.5> rotate 30*z translate <0,.5,-1>}
sphere {0,1.25,-1/10 scale <.25,.125,.5> rotate -20*z translate <0,.25,-1>}
sphere {0,1,-1/10 scale <.25,.1,.5> rotate 0*z translate <0,.125,-1>}
sphere {0,1.5,-1/20 scale <.25,.075,.5> rotate 10*z translate <0,0,-1>}
//Legs
cylinder {<.25,0,-.75>,<.125,.5,-.25>,.15,1/2}
cylinder {<.25,0,-.75>,<.125,.5,-.3>,.2 ,1/4}
cylinder {<.25,0,-.75>,<.125,.5,-.4>,.25,1/4}
cylinder {<-.25,0,-.75>,<-.125,.5,-.25>,.15,1/2}
cylinder {<-.25,0,-.75>,<-.125,.5,-.3>,.2 ,1/4}
cylinder {<-.25,0,-.75>,<-.125,.5,-.4>,.25,1/4}
  
sphere {0,.5,-1/2 scale <.5,.5,.75> translate <0,1.1 ,-.25>} 
sphere {0,.375,-1/4 scale <.5,.5,.75> translate <0,1 ,-.25>} 

sphere {0,1.0,-1/2 scale <.3,.15,2> rotate 45*x translate <0,.75,-.55>} 
sphere {0,1.1,-1/4 scale <.25,.2,2> rotate 45*x translate <0,.75,-.575>} 
sphere {0,1.2,-1/4 scale <.25,.25,2> rotate 45*x translate <0,.75,-.625>} 

sphere {0,1.0,-1/16 scale <.3,.15,2> rotate 45*x translate <0,.75,-.55>} 
sphere {0,1.1,-1/32 scale <.25,.2,2> rotate 45*x translate <0,.75,-.55>} 
sphere {0,1.2,-1/32 scale <.25,.25,2> rotate 45*x translate <0,.75,-.5>} 


sphere {0,.5,-1/30  scale <1,.05,1> rotate 90*z rotate -15*y translate <.25,.75,-.5>} 
sphere {0,.65,-1/60 scale <1,.1,1> rotate 90*z rotate -15*y translate <.25,.75,-.5>} 
sphere {0,.75,-1/60 scale <1,.15,1> rotate 90*z rotate -15*y translate <.25,.75,-.5>} 

sphere {0,.75,-1/30 scale <1,.25,1> rotate 90*z rotate -15*y translate <.25,.75,-.5>} 

sphere {0,.5,-1/30  scale <1,.05,.75> rotate 90*z rotate 15*y translate <-.25,.75,-.5>} 
sphere {0,.65,-1/60 scale <1,.1,.75> rotate 90*z rotate 15*y translate <-.25,.75,-.5>} 
sphere {0,.75,-1/60 scale <1,.15,.75> rotate 90*z rotate 15*y translate <-.25,.75,-.5>} 

sphere {0,.75,-1/30 scale <1,.25,.75> rotate 90*z rotate 15*y translate <-.25,.75,-.5>} 


sphere {0,1,-1/10 scale <.5,.25,.75> translate <0,.75,-.5>} 
sphere {0,3/4,2/3 scale <.5,.5,.5> translate <0,1,0>}

pigment {rgb <1,.875,.7>/2} 
normal {leopard scale 1/1000 bump_size 6} 
finish {ambient -.2 diffuse 1.5}  
texture {Scarring scale 1/16}  
texture {Scarring scale 1/32}       
texture {Scarring scale 1/64}
texture {Dirt scale 2*y+1/4}  
texture {Dirt scale 2*y scale 1/8}  
texture {Dirt scale 2*y scale 1/16}
texture {pigment {gradient y 
color_map {[0 rgb 0][.025 rgb 0 transmit .5][.125 rgb 0 transmit 1][.5 rgb 0 transmit 1][1 rgb 0 transmit .375]}    
scale 1/4
warp {turbulence 1 lambda 0}
scale 4
} 
translate -20
scale 1/3
rotate 15*z 
}

}
#declare BaseBallCap = 
union {
blob {threshold .1
sphere {0,1,1} 
sphere {0,1,-1/10 scale <.5,.25,.5> translate .875*y-.25*z}  
sphere {0,1,-1 scale <10,.5,10> translate -.5*y}
#declare C=0
#while (C<360)
sphere {0,1,-1/25 scale <.25,.75,1> translate <0,.25,-.75> rotate C*y} 
#declare C=C+45
#end 
#declare C=0
#while (C<360)
sphere {0,1,-1/60 scale <.025,.75,1> translate <0,.25,-.5> rotate (C+22.5)*y} 
#declare C=C+45
#end
rotate 30*y
}
union {
blob {threshold .1
cylinder {0,-z,.75,1 scale <1,.5,1>} 
cylinder {z,-z*2,.5,-2 scale <1.125,.5,1> translate -.125*y}   
cylinder {z,-z*2,.625,-1/2 scale <1.25,.5,1> translate -.125/2*y}   
cylinder {z,-z*2,.7,-1/4 scale <1.25,.5,1> }   
scale <1.875,.5,1>*.75 
translate -z/2.75
}
sphere {0,1/10 scale y/2 translate y*.8}

pigment {rgb <1,.75,0>}
normal {leopard scale 1/1000 bump_size 4} 
finish {ambient 0 diffuse 1}  
texture {Scarring scale 1/16 scale 2 } 
texture {Dirt scale 2*y+1/4 scale 2}  
texture {Dirt scale 2*y scale 1/8 scale 2}  
texture {Dirt scale 2*y scale 1/16 scale 2}
}    

pigment {rgb <0,1,.25>/3}
normal {leopard scale 1/1000 bump_size 4} 
finish {ambient 0 diffuse 1 phong .1 phong_size 5}  
texture {Scarring scale 1/16} 
texture {Dirt scale 2*y+1/4}  
texture {Dirt scale 2*y scale 1/8}  
texture {
pigment {image_map {png "OaklandAs" interpolate 2 once}
}      
normal {gradient y sine_wave scale .0175 turbulence .3  rotate 30*z bump_size 1 }
finish {ambient .1 diffuse 1}
translate <-1/2,0,0> 
scale 3/4   
translate -y/20
}
texture {Dirt scale 2*y scale 1/16}
} 

#declare Drunk = 
union {
object {BaseBallCap scale .275 scale .875*x rotate -52.5*x translate <0,1.1*1.25,-.15>} 
light_source { <0,1.05*1.25,-.15> rgb -1/2 shadowless fade_distance 4 fade_power 2}           

object {Blanket scale <.75,1.25,1>}
}


#declare glas_green_tx=
texture
{
  pigment
  {
    color rgbt<0.1,0.6,0.5,0.9>
  }
  finish
  {
    specular 0.2
    phong_size 200
    phong 0.3
    reflection 0.3
  }
}
////////////////////////////////
#declare bottle_outside=
merge
{
  difference
  {
    cylinder{<0,1.3,0>,<0,2,0>,0.4}
    torus{1.2,1.0 scale <1,1,1> translate y*1.9 }
  }
  difference
  {
    cylinder{<0,0,0>,<0,1,0>,0.5}
    sphere{<0,0,0>,0.2 scale <1,0.9,1>}
  }
  torus{0.2,0.05 scale <1,2,1> translate y*2.0 sturm}
  torus{0.35,0.15 scale <1,1,1> sturm}
  sphere{<0,1,0>,0.5 scale <1,1,1>}
  translate y*0.15
}

#declare bottle_inside=
merge
{
  difference
  {
    cylinder{<0,1.3,0>,<0,2,0>,0.4}
    torus{1.2,1.0 scale <1,1,1> translate y*1.9 }
  }
  difference
  {
    cylinder{<0,0,0>,<0,1,0>,0.5}
    sphere{<0,0,0>,0.3 scale <1,0.5,1>}
  }
  cylinder{<0,1,0>,<0,2.5,0>,0.2}
  torus{0.4,0.1 scale <1,0.5,1> sturm}
  sphere{<0,1,0>,0.5 scale <1,1,1>}
  translate y*0.05
}

#declare bottle=
difference
{ 
  object {bottle_outside}
  object {bottle_inside scale<0.75,0.9,0.75>translate y*0.25}
  //interior{caustics 0.2 ior 1.45}
  texture{glas_green_tx}
  texture {Scarring scale 2*y}   
  texture {Scarring scale 2*y}
  scale<1,1.5,1>
}
////////////////////////////////
////////////////////////////////translate <-7,0,-1.5>  



