#version unofficial MegaPov 0.4;
global_settings {
max_trace_level 20  
radiosity {brightness .45 count 3}  
post_process {soft_glow{2/3, 10}}      
}

camera {
location <0,5,-20> 
right -x*1.33
look_at <0,25,200>
}
/*camera {
location <0,7,150> 
right -x*1.33
look_at <50,7,200> 
}*/    

 
#include "background.inc"

#declare Scum1 =
function {
noise3d(x,y,z)^1.5
*noise3d(x*2,y*2,z*2)
} 
#declare RRRBox=
isosurface{
function{(x^(4)+y^(4)+z^(4))}
threshold 1
contained_by {box{-1,1}}
translate <1,1,1>
scale .5
}
#declare RRBox=
isosurface{
function{(x^(6)+y^(6)+z^(6))}
threshold 1
contained_by {box{-1,1}}
translate <1,1,1>
scale .5
} 
#declare RBox=
isosurface{
function{(x^(12)+y^(12)+z^(12))}
threshold 1
contained_by {box{-1,1}}
translate <1,1,1>
scale .5
} 
#declare RBox2=
isosurface{
function{(x^(24)+y^(24)+z^(24))}
threshold 1
contained_by {box{-1,1}}
translate <1,1,1>
scale .5
} 
#declare RBox3=
superellipsoid {
<.0125, .0125>
translate <1,1,1>
scale .5
}
#declare ManholeCover =
union {
difference {
cylinder {-y/8,0,2}
cylinder {-y/64,y,1.875}
cylinder {-y/24,y,1.75}
difference { 
cylinder {-y,y,1.75}     
#declare C=0
#while (C<4)
box {0,1 scale <5,2,1/4> translate <-2.5,-1,-1/8> translate .25*z translate (-C+2)*z}
#declare C=C+1/2
#end
}
}
#declare C=0
#while (C<360)
sphere {1.875*x,.125/2 scale 1/3*y rotate C*y}
#declare C=C+10
#end
pigment {rgb 1/2}      
normal {dents scale 1/32}
finish {ambient 0 diffuse 1 phong 2 metallic} 
texture {Rusting scale 1/4}  
texture {Dirt scale 1/4}  
texture {Dirt scale 1/6}  
texture {Scarring scale 1/2} 
texture {Scarring scale 1/4} 
texture {Scarring scale 1/2} 
texture {Scarring scale 1/2 translate 2}
texture {Scarring}  
}
#declare PadSign = 
union {
difference {
union {
sphere {0,4 scale <1/2,1,1/2> translate 3*x}
sphere {0,4 scale <1/2,1,1/2> translate -3*x} 
cylinder {-3*x,3*x,4 scale <1,1,1/2>}
scale <1.25,1,1>
}  
union {
sphere {0,4 scale <1/2,1,1/2> translate 3*x}
sphere {0,4 scale <1/2,1,1/2> translate -3*x} 
cylinder {-3*x,3*x,4 scale <1,1,1/2>}  
scale .875
translate -z*1.5
}
} 
union {
sphere {0,4 scale <1/6,1,1/2> translate 3*x}
sphere {0,4 scale <1/6,1,1/2> translate -3*x}
scale <1.25,1,1>
} 
union {
sphere {0,4 scale <1/6,1,1/2> translate 3*x}
sphere {0,4 scale <1/6,1,1/2> translate -3*x}
scale <1.5,1,1>
} 
cylinder {-4*x,4*x,3.75 scale <1,1,1/2>  
texture {
pigment {image_map {png "PadSign" interpolate 2}}  
finish {ambient 2 diffuse 0 reflection .125 }
scale <7,6,.1> translate <-3.5,-3,-1.5>}
}
pigment {rgb <.8,.9,1>/2} 
normal {gradient y  triangle_wave normal_map {[.4 gradient y triangle_wave scale 1/5  bump_size .5][.6 gradient x triangle_wave scale 1/5  bump_size 1.5]} scale 2*y}
finish {ambient 0 diffuse 1  phong 1.5 metallic phong_size 5}
texture {Scarring scale 4*y scale 1/2}
texture {Scarring scale 4*y scale 1/2 translate 3}        
texture {Scarring scale 4*y scale 1}
} 
#declare Clock = 
union {
disc {0,z,5 pigment {rgb 1.5}
texture {Scarring scale 2}      
texture {Scarring scale 2} 
texture {Scarring}
}
union {    
union {
text {ttf "times.ttf", "12",.001, 0            
position 1
align_center
scale 2  
scale -z 
translate 3.25*y
}   
text {ttf "times.ttf", "1",.001, 0 
position 1
align_center           
scale 2  
scale -z 
translate vrotate (3.5*y,-30*z)
} 
text {ttf "times.ttf", "2",.001, 0
position 1
align_center            
scale 2  
scale -z 
translate vrotate (3.75*y,-60*z)
}
text {ttf "times.ttf", "3",.001, 0   
position 1
align_center         
scale 2  
scale -z 
translate vrotate (4*y,-90*z)
}
text {ttf "times.ttf", "4",.001, 0
position 1
align_center            
scale 2  
scale -z 
translate vrotate (3.75*y,-120*z)
}
text {ttf "times.ttf", "5",.001, 0
position 1
align_center            
scale 2  
scale -z 
translate vrotate (4*y,-150*z)
}
text {ttf "times.ttf", "6",.001, 0
position 1
align_center            
scale 2  
scale -z 
translate vrotate (4*y,-180*z)
} 
text {ttf "times.ttf", "7",.001, 0
position 1
align_center            
scale 2  
scale -z 
translate vrotate (4*y,-210*z)
}  
text {ttf "times.ttf", "8",.001, 0
position 1
align_center            
scale 2  
scale -z 
translate vrotate (4*y,-240*z)
}    
text {ttf "times.ttf", "9",.001, 0
position 1
align_center            
scale 2  
scale -z 
translate vrotate (3.875*y,-270*z)
} 
text {ttf "times.ttf", "10",.001, 0
position 1
align_center            
scale 2  
scale -z 
translate vrotate (3.5*y,-300*z)
}
text {ttf "times.ttf", "11",.001, 0
position 1
align_center            
scale 2  
scale -z 
translate vrotate (3.25*y,-330*z)
} 
translate -y/3
}
#declare C=0
#while (C<360)
box {0,1 scale <.25,1/2,-.01> translate <-.125,4.5,0> rotate C*z}
#declare C=C+30
#end  
box {0,1 scale <.35,3,-.01> translate <-.175,0,-.1> rotate 180*z}
box {0,1 scale <.25,4,-.01> translate <-.125,0,-.1> rotate 160*z}
#declare C=0
#while (C<360)
box {0,1 scale <.125,1/4,-.01> translate <-.125/2,4.75,0> rotate C*z}
#declare C=C+5
#end 
union {
torus {6,1 rotate 90*x}      
torus {5.25,.25 rotate 90*x translate -z/3}        
torus {5.375,.25 rotate 90*x translate -z/2}    
torus {6.8,.25 rotate 90*x translate -z/2}   
pigment {rgb .75}  
finish {phong 1/2 phong_size 15}  
texture {Scarring scale 2}
texture {Scarring scale 4}         
texture {Scarring scale 4}
texture {Scarring scale 2}
texture {Scarring}
}

pigment {rgb 0}  
finish {phong 2}  
texture {Scarring scale 2}
texture {Scarring scale 4}         
texture {Scarring scale 4}
texture {Scarring scale 2}
texture {Scarring}
} 
difference {
sphere {0,1 scale <6.5,6.5,1>}
sphere {0,.95 scale <6.5,6.5,1>} 
height_field {tga "clockglass" smooth scale 10 translate -5 rotate 90*x scale z*10 scale 1.5}
interior {ior 5}
texture {
pigment {rgb <.9,.96,1> transmit .875} 
finish {ambient 0 diffuse 1 phong 2}
}        
texture {Scarring scale 2}
}
} 
#declare StreetPole =
union {
union {
cylinder {0,y*100,1}
difference {
cylinder {0,y/2,1.5}                    
torus {1.5,.5 translate .5*y}                    
}  
difference {
cylinder {0,-y/2,2.5}                    
torus {2.5,.5}                    
}

box {<-3,-2,-2.5><3,-1/2,2.5>}
box {<-2.5,-2,-3><2.5,-1/2,3>}
cylinder {-y*2,-y/2,1/2 translate <-2.5,0,-2.5>}                  
cylinder {-y*2,-y/2,1/2 translate <2.5,0,-2.5>}                  
cylinder {-y*2,-y/2,1/2 translate <2.5,0,2.5>}                  
cylinder {-y*2,-y/2,1/2 translate <-2.5,0,2.5>}   
#declare Bolt = 
difference {
cylinder {-y,0,1/2}
cylinder {-y/2,y,1/3}
scale y/2  
scale 2/3
}               
object {Bolt translate <-2.5,-.25,-2.5>}  
object {Bolt translate <-2.5,-.25,2.5>}
object {Bolt translate <2.5,-.25,-2.5>}
object {Bolt translate <2.5,-.25,2.5>}
pigment {rgb <.875,1,.8755>}
finish {ambient 0 diffuse 1.5 phong .25 phong_size 10}
texture {Scarring scale 4*y scale 1/2}        
//texture {Chipping scale 3/4}    
texture {Rusting  translate 45 scale 4*y scale 1/2}
}  
union { 
cylinder {-y,-y*100,4.5}
cylinder {-y*1.5,-y*100,5}   
torus {4.5,.5 translate -y*1.5}             

union {
cylinder {-y,-y*100,4.5}
cylinder {-y*1.5,-y*100,5}   
torus {4.5,.5 translate -y*1.5} 
scale 1.5
translate -12*y
}

pigment {rgb <.8,.8,.75>*1.5}   
finish {ambient 0.05 diffuse 1}
normal {wrinkles bump_size 1/2 lambda 1 scale 1/2 scale y*2}   
texture {Scarring scale 4*y scale 1/2}        
//texture {Chipping scale 3/4}    
texture {Rusting  translate 45 scale 4*y scale 1/2}
}
}


             
             
 

//Concrete Pavement
union {
box {<-100000,-100,-100><0,0,100000000> rotate 60*y translate 200*z}
difference {
box {<-10000,-100,-100><2.5,0,100000000>}   
blob {threshold .1  
cylinder {<0,0,0>,<0,0,200>,1,1/2 scale <1,1/3,1>} 
cylinder {<0,-1/3,0>,<0,0,200>,2/3,1 scale <.75,2/3,1>} 
cylinder {<0,-10,0>,<0,20,0>,1/2,1 translate 2*z}   
scale <1,2/3,1>
translate <-3.875,.35,0>
} 
blob {threshold .1  
cylinder {<0,0,0>,<0,0,200>,1,1/2 scale <1,1/3,1>} 
cylinder {<0,-1/3,0>,<0,0,200>,2/3,1 scale <.75,2/3,1>} 
cylinder {<0,-10,0>,<0,20,0>,1/2,1 translate 2*z}   
scale <1,2/3,1>
translate <1.75,.35,-10>
} 
cylinder {-y*100,y*2,2 translate <-1,0,-5>}
torus {2,.125 translate <-1,0,-5>}

height_field {tga "groundcracks" smooth scale <-10,-1/4,40> translate <5,.1,-10>
pigment {planar color_map {[0 rgb 1][1 rgb .25]} translate -.25*y}
}
} 
torus {1,.125 scale <2,1,2>translate <-1,-1/4,-5>}
 
object {ManholeCover rotate 778*y translate <-1/4,1/8,-4.5>}
//Concrete Bumper
union {
object {RBox2 scale <2,2,300> translate <2.5,-1,-100>}
object {RBox2 scale <2,2,20000> translate <2.5,-1,0> rotate 60*y translate 200*z} 

#declare C=0
#while (C<200)
union {
object {RBox scale <2,5,1.5> rotate 30*z translate <0,-.5,-.75>}
object {RBox2 scale <2,4,1> rotate 30*z translate <.25,-.5,-.5>}    
object {RRBox scale <2,4,1> translate <-2,-.5,-.5>}
translate <5.5,-2,C>
}
#declare C=C+20
#end  

#declare C=0
#while (C<400)
union {
object {RBox scale <2,5,1.5> rotate 30*z translate <0,-.5,-.75>}
object {RBox2 scale <2,4,1> rotate 30*z translate <.25,-.5,-.5>}    
object {RRBox scale <2,4,1> translate <-2,-.5,-.5>}
translate <5.5,-2,C>     
rotate 60*y
translate <0,0,190>
}
#declare C=C+20
#end 

union {
cylinder {-100*z,200*z,1/3}    
cylinder {0*z,1000*z,1/3
translate <0,.5,0>
rotate 60*y
translate <0,0,190>
}
#declare C=0
#while (C<200)
union {
box {0,1 scale <2,1,.25> translate <-1,-.5,-.25>}
cylinder {0,-z/4,1 translate -x}
cylinder {0,-z/4,1 translate x}   
sphere {0,.45 translate <1,0,-.25>} 
sphere {0,.45 translate <-1,0,-.25>}
scale .375
scale 1.5*z
translate -.75*z
rotate -45*z
translate <0,0,C>
}
#declare C=C+20
#end
pigment {rgb <.875,1,.8755>}
finish {ambient 0 diffuse 1 phong .25 phong_size 10}
texture {Scarring scale 4*y}        
texture {Chipping scale 3/4}    
texture {Rusting  translate 45 scale 4*y} 
translate <4.5,1.75,0>
}

//Concrete Bumper Texture  
pigment {rgb 1}
normal {dents scale 1/2 turbulence 1}
finish {ambient .1 diffuse .9 phong .05 phong_size 2 crand .1}
texture {Scarring scale <1,4,4>}
texture {Scarring scale <1,4,4> scale 1/2}   
texture {Chipping scale <1,4,4>/2}  
texture {
pigment {
planar  
pigment_map {
[0 rgb 0 transmit 1]    
[.5 bozo color_map {[0 rgb 0 transmit .5][1 rgb 0 transmit 1]} scale 1/15 scale 2*z]
[.875 rgb 0 transmit .5]    
}
}
finish {ambient 1}
}
}
//Concrete Pavement Texture
pigment {rgb 1}
normal {dents scale 1 turbulence 1 bump_size 1/3}
finish {ambient .1 diffuse .9 phong .05 phong_size 2 crand .05}
texture {Scarring scale <1,4,4>}
texture {Scarring scale <1,4,4> scale 2} 
texture {
pigment {
blob {  
cylinder {<4,0,-30>,<4,0,200>,4,1  density_function 0,.5}  
cylinder {<-5,0,-4>,<-5,0,200>,4,1  density_function 0,.5}
cylinder {<-7.5,0,0>,<-25,0,0>,4,1  density_function 0,.5} 
cylinder {<0,-10,0>,<0,10,0>,3,1 translate <-1,0,-4> density_function 0,.5}  
cylinder {<0,-10,0>,<0,10,0>,3,1 translate <-1,0,-6> density_function 0,.5}  
     
threshold .1
max_density 1
}     
pigment_map {
[0 rgb 0 transmit 1]    
[.5 bozo color_map {[0 rgb 0 transmit .5][1 rgb 0 transmit .75]} scale 1/5 scale 2*z]
[.75 bozo color_map {[0 rgb 0 transmit .25][1 rgb 0 transmit .5]} scale 1/5 scale 2*x]    
[1 rgb 0 transmit .25] 
}
}
finish {ambient 1}
}
}


#declare ConcreteGrimeTex1 = 
texture {
pigment {
planar
pigment_map { 
[0 rgb 0 transmit 1]
[1 gradient x triangle_wave 
pigment_map {
[0 function {Scum1(x,y,z)} triangle_wave pigment_map {
[0 rgb <1,1,.8>/3 transmit 1] 
[.125*3/4 bozo  color_map {[0 rgb <.3,.32,.2>/2][.5 rgb .15][1 rgb <.2,.25,.2>/3]}turbulence 2 scale 1/16]}
translate y 
scale 1/4
] 
[1 rgb 0 transmit 1]
}
scale 5
warp {turbulence 1}
scale 1/5
scale 10*x+10*z
] 
} 
}
normal {dents scale 1/3}
finish {ambient 0 diffuse 1 phong 0 crand .1}
}
texture {Scarring scale 1/2 scale 2*z}

//Building1
union {
object {RBox3 scale <80,35,100> translate <-85,-5,0>}
#declare C=0
#while (C<100)
object {RRBox scale <1,35,2> rotate 2*z translate <-5,-5,C>}
#declare C=C+10
#end
#declare C=0
#while (C<20)
object {RRBox scale <1,35,2> rotate 2*z rotate 90*y translate <-22.5+C,-5,0>}
#declare C=C+5
#end  
union {
#declare C=0
#while (C<35)
object {RRBox scale <3,1,2> rotate 5*x translate <-12,C,-2/3>}
#declare C=C+3
#end  
#declare C=0
#while (C<35)
object {RRBox scale <2.5,2,2> translate <-9.75,C+1,-2/3>}
#declare C=C+3
#end

pigment {rgb <1,.95,.9>}
normal {dents scale 1/4}
finish {ambient .1 diffuse .9 phong .05 phong_size 2 crand .1}
texture {Scarring scale 4*y}
texture {Scarring scale 4*y scale 2}  
texture {Rusting2 scale 2*y scale 1/2 translate 20}
texture {Chipping scale 1/4} 
texture {Rusting scale 2*y scale 2 translate -20}
texture {
pigment {
slope -y  
pigment_map {
[.45 rgb 0 transmit 1]    
[.625 bozo color_map {[0 rgb 0 transmit .5][1 rgb 0 transmit 1]} scale 1/15 scale 2*z]
[1 rgb 0 transmit .5]    
}
}
finish {ambient 1}
}
texture {
pigment {
slope y  
pigment_map {
[.45 rgb 0 transmit 1]    
[.625 bozo color_map {[0 rgb 0 transmit .5][1 rgb 0 transmit 1]} scale 1/5 scale 2*z]
[1 rgb 0 transmit .5]    
}
}
finish {ambient 1}
}
texture {
pigment {
planar  
pigment_map {
[0 rgb 0 transmit 1]    
[.5 bozo color_map {[0 rgb 0 transmit .5][1 rgb 0 transmit 1]} scale 1/5 scale 2*z]
[.875 rgb 0 transmit .5]    
}
scale 2*y
}
finish {ambient 1}
}
}       
               
#declare B1SideDetail =
union {
object {RBox scale <8,6,49.5> rotate 45*z translate <-3.5,15,50.25>} 
object {RBox scale <8,8,50> translate <-5.5,20,50>} 
object {RBox scale <2,6,52> translate <-4.5,21,49>}   
object {RBox scale <2,6,52> translate <-2,21,49>}   
object {RBox scale <2,6,52> translate <.5,21,49>}   
object {RBox scale <8,6,50> translate <-5.5,28,50>} 
}
object {B1SideDetail} 
object {B1SideDetail scale .25*z}  

object {RBox2 scale <1,7.5,100> translate <-5.5,-1,-3.75>}  

object {RBox scale <1.5,7,1> translate <-5.75,-1,-3>} 
object {RBox scale <1.5,7,1> translate <-5.75,-1,-1.5>} 


//object {RBox scale <4,6,50> translate <-5,30,50>}
box {<-10000,-100,-100>,<350,100000,-99.5> pigment {rgb 0}}
pigment {rgb <1,.95,.9>}
normal {dents scale 1/4}
finish {ambient .1 diffuse .9 phong .05 phong_size 2 crand .1}
texture {Scarring scale 4*y}
texture {Scarring scale 4*y scale 2}  
texture {Rusting2 scale 2*y scale 1/2 translate 20}
texture {Chipping scale 1/4} 
texture {Rusting scale 2*y scale 2 translate -20}   
texture {Scarring scale 4*y scale 3} 
texture {Scarring scale 4*y} 
texture {
pigment {
planar  
pigment_map {
[0 rgb 0 transmit 1]    
[.5 bozo color_map {[0 rgb 0 transmit .5][1 rgb 0 transmit .75]} scale 1/7.5 scale 2*z]
[.875 rgb 0 transmit .25]    
}
scale 5*y
}
finish {ambient 1}
}
texture {
pigment {
slope y  
pigment_map {
[.5 rgb 0 transmit 1]    
[.75 bozo color_map {[0 rgb 0 transmit .5][1 rgb 0 transmit 1]} scale 1/5 scale 2*z]
[1 rgb 0 transmit .5]    
}
}
finish {ambient 1}
} 
texture {
pigment {
slope -y  
pigment_map {
[.5 rgb 0 transmit 1]    
[.75 bozo color_map {[0 rgb 0 transmit .5][1 rgb 0 transmit 1]} scale 1/5 scale 2*z]
[1 rgb 0 transmit .5]    
}
}
finish {ambient 1}
}
} 


#declare BuildingBlock = //(no pun intended...)                
union {                
//Building2
union {
object {RBox3 scale <80,35,100> translate <-85,-5,0>}
#declare C=0
#while (C<100)
object {RRBox scale <1,35,2> rotate 2*z translate <-5,-5,C>}
#declare C=C+10
#end    

#declare C=0
#while (C<20)
object {RRBox scale <1,35,2> rotate 2*z rotate 90*y translate <-22.5+C,-5,0>}
#declare C=C+5
#end  
              
#declare B2SideDetail =
union {
object {RBox scale <8,6,49.5> rotate 45*z translate <-3.5,15,50.25>} 
object {RBox scale <8,8,50> translate <-5.5,20,50>} 
object {RBox scale <2,6,52> translate <-4.5,21,49>}   
object {RBox scale <2,6,52> translate <-2,21,49>}   
object {RBox scale <2,6,52> translate <.5,21,49>}   
object {RBox scale <8,6,50> translate <-5.5,28,50>} 
}
object {B2SideDetail translate -100*z scale .75*z translate 35*z} 
object {B2SideDetail translate -100*z scale .75*z translate 85*z}   
object {B2SideDetail translate -100*z scale .75*z translate -32*y scale -y translate 35*z} 
object {B2SideDetail translate -100*z scale .75*z translate -32*y scale -y translate 85*z}
//object {RBox scale <4,6,50> translate <-5,30,50>}
pigment {rgb <1,.95,.9>}
normal {dents scale 1/4}
finish {ambient 0 diffuse .9 phong .05 phong_size 2 crand .1}
texture {Scarring scale 4*y}
texture {Scarring scale 4*y scale 2}  
texture {Rusting2 scale 2*y scale 1/2 translate 20}
texture {Chipping} 
texture {Rusting scale 2*y scale 2 translate -20} 
texture {
pigment {
planar  
pigment_map {
[0 rgb 0 transmit 1]    
[.5 bozo color_map {[0 rgb 0 transmit .5][1 rgb 0 transmit 1]} scale 1/15 scale 2*z]
[.875 rgb 0 transmit .5]    
}
scale 2*y
}
finish {ambient 1}
}
texture {
pigment {
slope y  
pigment_map {
[.5 rgb 0 transmit 1]    
[.75 bozo color_map {[0 rgb 0 transmit .5][1 rgb 0 transmit 1]} scale 1/5 scale 2*z]
[1 rgb 0 transmit .5]    
}
}
finish {ambient 1}
} 
texture {
pigment {
slope -y  
pigment_map {
[.5 rgb 0 transmit 1]    
[.75 bozo color_map {[0 rgb 0 transmit .5][1 rgb 0 transmit 1]} scale 1/5 scale 2*z]
[1 rgb 0 transmit .5]    
}
}
finish {ambient 1}
}  
translate <85,0,0>
rotate 60*y
translate <-15,0,300>
} 
//Building3
union {
object {RBox3 scale <80,35,100> translate <-85,-5,0>}
#declare C=0
#while (C<100)
object {RRBox scale <1,35,2> rotate 2*z translate <-5,-5,C>}
#declare C=C+10
#end
#declare C=0
#while (C<20)
object {RRBox scale <1,35,2> rotate 2*z rotate 90*y translate <-22.5+C,-5,0>}
#declare C=C+5
#end                 
object {B2SideDetail translate -100*z scale .75*z translate 35*z} 
object {B2SideDetail translate -100*z scale .75*z translate 85*z}   
object {B2SideDetail translate -100*z scale .75*z translate -32*y scale -y translate 35*z} 
object {B2SideDetail translate -100*z scale .75*z translate -32*y scale -y translate 85*z}
//object {RBox scale <4,6,50> translate <-5,30,50>}
pigment {rgb <1,.95,.9>}
normal {dents scale 1/4}
finish {ambient 0 diffuse .9 phong .05 phong_size 2 crand .1}
texture {Scarring scale 4*y}
texture {Scarring scale 4*y scale 2}  
texture {Rusting2 scale 2*y scale 1/2 translate 20}
texture {Chipping} 
texture {Rusting scale 2*y scale 2 translate -20}   
texture {
pigment {
planar  
pigment_map {
[0 rgb 0 transmit 1]    
[.5 bozo color_map {[0 rgb 0 transmit .5][1 rgb 0 transmit 1]} scale 1/15 scale 2*z]
[.875 rgb 0 transmit .5]    
}
scale 2*y
}
finish {ambient 1}
}
texture {
pigment {
slope y  
pigment_map {
[.5 rgb 0 transmit 1]    
[.75 bozo color_map {[0 rgb 0 transmit .5][1 rgb 0 transmit 1]} scale 1/5 scale 2*z]
[1 rgb 0 transmit .5]    
}
}
finish {ambient 1}
} 
texture {
pigment {
slope -y  
pigment_map {
[.5 rgb 0 transmit 1]    
[.75 bozo color_map {[0 rgb 0 transmit .5][1 rgb 0 transmit 1]} scale 1/5 scale 2*z]
[1 rgb 0 transmit .5]    
}
}
finish {ambient 1}
}
translate <85,0,0>
rotate 60*y
translate <87.5,0,375>
}
} 

union {BuildingBlock}
union {BuildingBlock translate 33*y}

#declare WaterWall = 
union {
box {<-500,0,-100>,<500,.00001,100>
translate <0,0,100>
rotate -45*x
}
#declare C=0
#while (C<100)    
difference {
box {<-2,0,-100>,<2,3,100> translate ((C*10)-500)*x
translate <0,0,100>
rotate -45*x
}
plane {-y,0 translate 143*y 
pigment {rgb 1} 
finish {ambient 0 diffuse 1 crand .1}
texture {Scarring scale 1/2 scale 2*z}
texture {Scarring scale 1/2 scale 2*z} 
texture {Rusting scale 3}
}
}
#declare C=C+1
#end   
pigment {planar color_map {[0 rgb .875][.25 rgb .875][.375 rgb .675][.5 rgb .625][.75 rgb .25][.875 rgb .125][1 rgb 2]}scale 4 warp {turbulence .5} scale 1/4 scale 12 translate -40*y
translate <0,142,62.5-100>}
finish {ambient 0 diffuse 1}
texture {Scarring scale 2*y}
texture {Chipping2 scale 1/2 scale 4*z rotate 45*y} 
texture {Rusting2 scale 6*y}
texture {ConcreteGrimeTex1} 
}
//object {WaterWall translate -450*x}  
object {WaterWall translate  450*x rotate -30*y translate <0,-142,-62.5+100>}


//Begin Highways!!!!
#declare SignPost =
union {
cylinder {0,y*10,1}   
cylinder {-y*4,y*4,1.25}
cone {y*4,1.25,y*6,1}   
intersection {
torus {3,1 rotate 90*x translate <-3,10,0>}
box {<1.2,10,-1.5>,<-3,14,1.5>}
} 
difference {  
union {sphere {<-12,13,0>,1}   
cylinder {<-3,13,0>,<-12,13,0>,1} 
}     
object {RRBox scale <2,1,40> translate <-1,0,-20>
translate <-11,11.5,0>}   
object {RRBox scale <2,1,40> translate <-1,0,-20>
translate <-8,11.5,0>}  
object {RRBox scale <2,1,40> translate <-1,0,-20>
translate <-5,11.5,0>}
}
union {sphere {<-12,13,0>,.8}   
cylinder {<-3,13,0>,<-12,13,0>,.8} 
pigment {planar color_map {[0 rgb .25][1 rgb 2]} translate 13*y}
finish {ambient 1 diffuse 1 phong 1}
} 
object {RBox 
texture {pigment {image_map {tga "SanSign" interpolate 2 once}}
finish {ambient .25 diffuse 1.25 phong 1/2}}
texture {Scarring scale 1/6 scale 4*y}        
texture {Chipping scale 1/24 translate 2}    
texture {Rusting  scale 1/6 translate 45 scale 4*y}
scale <10,6,.1> translate <-12,6,0>}
translate 4*y
}   

#macro HighWay(Rot,Trans)
union {
//Traffic =
#declare C=0
#while (C<11000) 
#declare Rand = rand(seed(C*C*C-4))                                                                   
#declare Rand2 = rand(seed(C*C+2))  
#declare Rand3 = rand(seed(C*C*6+4))
box {0,1 scale <12,12,20> 
pigment {planar  pigment_map {[0 rgb 0 transmit 1][.075 planar color_map {[0 rgb 0 transmit 1][.5-.25*Rand3 rgb 0 transmit .35]} rotate 90*x scale 10 translate 10*z]} scale 12*y}
scale 2*z 
scale y*(1+Rand2/2)
translate <2,0,-10010+C> 
rotate Rot
}
#declare C=C+80+(Rand*80)
#end

#declare C=0
#while (C<11000) 
union {
cylinder {0,-y*1000,5 translate <6,0,120>}
cylinder {0,-y*1000,5 translate <-6,0,120>} 
cylinder {0,-y*1000,6 translate <6,-40,120>} 
cylinder {0,-y*1000,6 translate <-6,-40,120>}      
cone {0,6,y*3,5 translate <6,-40,120>}
cone {0,6,y*3,5 translate <-6,-40,120>} 
cone {0,5.5,-y*3,5 translate <6,-20,120>}
cone {0,5.5,-y*3,5 translate <-6,-20,120>} 
cone {0,7.5,-y*2,6 translate <6,-10,120>}
cone {0,7.5,-y*2,6 translate <-6,-10,120>} 
cylinder {0,-y*20,5.5 translate <6,0,120>}
cylinder {0,-y*20,5.5 translate <-6,0,120>} 
cylinder {0,-y*15,6 translate <6,0,120>}
cylinder {0,-y*15,6 translate <-6,0,120>}
cylinder {0,-y*10,7.5 translate <6,0,120>}
cylinder {0,-y*10,7.5 translate <-6,0,120>}  
union {    
object {RBox2 scale <32,1000,-13> translate <-16,-1055,+6.5+120>}  
object {RBox3 scale <30,1000,-14> translate <-15,-1057.5,+7+120>}
pigment {planar color_map {[0 rgb .875][.25 rgb .875][.375 rgb .675][.5 rgb .625][.75 rgb .25][.875 rgb .125][1 rgb 1.75]}scale 4 warp {turbulence .5} scale 1/4 scale 15 translate (-Trans.y-41)*y}
finish {ambient 0 diffuse 1.25} 
texture {Scarring scale 2*y}
texture {Chipping scale 1 scale 4*z rotate 45*y} 
texture {Rusting2 scale 6*y}     
texture {Scarring scale 2*y translate 8}       
texture {Scarring scale 2*y translate 16}

}
scale <.75,1,.75>
rotate <-Rot.x,0,-Rot.z> 
translate (-10000+C)*z
pigment {rgb .75}
finish {ambient 0 diffuse 1.25} 
texture {Scarring scale 2*y}
texture {Chipping scale 1/2 scale 4*z rotate 45*y} 
texture {Rusting2 scale 6*y}     
texture {Scarring scale 2*y translate 4}       
texture {Scarring scale 2*y translate 8}
texture {Scarring scale 2*y translate 6}
texture {Scarring scale 2*y translate 3} 
translate 10*z //
rotate Rot 
}
#declare C=C+300
#end

union {
cylinder {0,-y*1000,5 translate <6,0,120>}
cylinder {0,-y*1000,5 translate <-6,0,120>} 
cylinder {0,-y*1000,6 translate <6,-40,120>}
cylinder {0,-y*1000,6 translate <-6,-40,120>} 
cone {0,6,y*3,5 translate <6,-40,120>}
cone {0,6,y*3,5 translate <-6,-40,120>}  
cone {0,5.5,-y*3,5 translate <6,-20,120>}
cone {0,5.5,-y*3,5 translate <-6,-20,120>} 
cone {0,7.5,-y*2,6 translate <6,-10,120>}
cone {0,7.5,-y*2,6 translate <-6,-10,120>} 
cylinder {0,-y*20,5.5 translate <6,0,120>}
cylinder {0,-y*20,5.5 translate <-6,0,120>} 
cylinder {0,-y*15,6 translate <6,0,120>}
cylinder {0,-y*15,6 translate <-6,0,120>}
cylinder {0,-y*10,7.5 translate <6,0,120>}
cylinder {0,-y*10,7.5 translate <-6,0,120>} 
union {    
object {RBox2 scale <32,1000,-13> translate <-16,-1055,+6.5+120>}  
object {RBox3 scale <30,1000,-14> translate <-15,-1057.5,+7+120>}
pigment {planar color_map {[0 rgb .875][.25 rgb .875][.375 rgb .675][.5 rgb .625][.75 rgb .25][.875 rgb .125][1 rgb 1.75]}scale 4 warp {turbulence .5} scale 1/4 scale 15 translate (-Trans.y-41)*y}
finish {ambient 0 diffuse 1.25} 
texture {Scarring scale 2*y}
texture {Chipping scale 1 scale 4*z rotate 45*y} 
texture {Rusting2 scale 6*y}     
texture {Scarring scale 2*y translate 8}       
texture {Scarring scale 2*y translate 16}
}
scale <.75,1,.75>
rotate <-Rot.x,0,-Rot.z> 
pigment {rgb .75}
finish {ambient 0 diffuse 1.25} 
texture {Scarring scale 2*y}
texture {Chipping scale 1/2 scale 4*z rotate 45*y} 
texture {Rusting2 scale 6*y}     
texture {Scarring scale 2*y translate 4}       
texture {Scarring scale 2*y translate 8}
texture {Scarring scale 2*y translate 6}
texture {Scarring scale 2*y translate 3}
rotate Rot 
}
object {RBox2 scale <8,7,11000> translate <-4,-4 ,-10000>  translate -5*x rotate Rot}
object {RBox2 scale <8,7,11000> translate <-4,-4 ,-10000>  translate  5*x rotate Rot}  
object {RBox scale <4,7,11000> translate <-2,-8 ,-10000>  translate -5*x rotate Rot}
object {RBox scale <4,7,11000> translate <-2,-8 ,-10000>  translate  5*x rotate Rot}     
#declare C=0
#while (C<11000) 
object {RBox scale <8,7,4> translate <-4,-7.5,-2> translate  (-10000+C)*z rotate Rot}     
#declare C=C+8
#end
#declare C=0
#while (C<11000) 
object {RBox scale <10,7,20> translate <-5,-8.5,-10> translate  (-10000+C)*z rotate Rot}     
#declare C=C+60
#end 

object {RBox scale <10,4,20> translate <10,4,-10+85> rotate Rot}
object {RBox2 scale <20,7,11000>    translate <-10,-2   ,-10000> rotate Rot}
object {RBox2 scale <22,6.75,11000> translate <-11,-1.75,-10000> rotate Rot}
object {RBox2 scale <28,6,11000>    translate <-14,-1   ,-10000> rotate Rot}
object {RBox2 scale <30,5.5,11000>  translate <-15,-.5  ,-10000> rotate Rot}
object {RBox2 scale <32,5,11000>    translate <-16,0    ,-10000> rotate Rot} 
union {
object {RBox2 scale <1,4,11000>    translate <-15,4.5    ,-10000> rotate Rot}
object {RBox2 scale <1,4,11000>    translate <-15,4.5    ,-10000> scale -x rotate Rot}
pigment {rgb 1}
finish {ambient 0 diffuse 1} 
texture {Scarring scale 2*z rotate Rot scale 2}
texture {Chipping2 scale 1/2 scale 4*z rotate 45*y} 
texture {Rusting2 scale 6*y} 
}
pigment {rgb 1}
finish {ambient -.15 diffuse 1.25} 
texture {Scarring scale 2*z rotate Rot scale 2}
texture {Chipping2 scale 1/2 scale 4*z rotate 45*y} 
texture {Rusting2 scale 6*y}  
texture {Scarring scale 2*z rotate Rot scale 3} 
texture {Scarring scale 2*z rotate Rot scale 1}
translate Trans 
}  
#end  

#declare IBeam = 
difference {
box {0,1 scale <3,40,4> translate <-1.5,-12,0>}   
box {0,1 scale <3,50,2.5> translate <-3.5,-17,1>}
box {0,1 scale <3,50,2.5> translate <-3.5,-17,1> scale -x}  
scale <.75,1,1>
translate -5*y+2*z
} 

#declare LightAssembly =  
union {
object {IBeam translate 17*y-2*z scale 1/6 rotate -90*x translate < 1/2,-1,-4>}    
object {IBeam translate 17*y-2*z scale 1/6 rotate -30*x translate < 0  ,-1,-10>}
object {IBeam translate 17*y-2*z scale 1/6 rotate -90*x translate <-1/2,-1,-4>}
object {RRBox scale <1,1,1/2> translate <-.5,0,0> scale 2.5 translate 4*y rotate -30*x translate <0,-1,-10>
pigment {rgb 1}
finish {ambient 0 diffuse 1 phong 1/2}
texture {Scarring scale 1/2}
texture {Scarring scale 1/2}
texture {HeavyScarring scale 6*y}
}
}

#declare BillBoard = 
union { 
box {0,1 
scale <32,24,.25> 
translate <-16,0,0>  
texture {
pigment {image_map{
png "DMFAdd"
once interpolate 2 
}
scale <32,24,.25> 
translate <-16,0,0>
} 
normal {granite scale 25 bump_size .375}
finish {ambient 0 diffuse 1.5}
}
texture {Scarring scale 4*y}
texture {Scarring scale 2 scale 4*y}
texture {Chipping scale 3/2 translate 20}
texture {Chipping scale 1 translate -10}    
texture {Rusting scale 4+4*y translate -10}
texture {Dirt scale 2/3 scale 4*y translate 50}
texture {pigment{gradient y triangle_wave 
color_map {[.925 rgb .5 transmit 1][1 rgb .5]}
scale 10 warp {turbulence .5} scale 1/10 
turbulence .125
} scale 8}      
texture {pigment{gradient x triangle_wave 
color_map {[.925 rgb .5 transmit 1][1 rgb .5]}
scale 10 warp {turbulence .5} scale 1/10  
turbulence .125
} scale 8}



 



}
light_source {<0,4,-8> rgb 1 spotlight point_at <0,10,0> radius 50 falloff 55}
light_source {<0,4,-8> rgb .5 spotlight point_at <0,10,0> radius 50 falloff 55 translate <-12,0,0>} 
light_source {<0,4,-8> rgb .875 spotlight point_at <0,10,0> radius 50 falloff 55 translate < 12,0,0>} 
union {
box {0,1 scale <34,1/2,1> translate <-17,0,-2>}
box {0,1 scale <34,1/2,1> translate <-17,0,-4>}
box {0,1 scale <34,1/2,1> translate <-17,0,-6>}   
pigment {rgb 1}
texture {Scarring scale 1/2}
texture {Scarring scale 1/2}
texture {Scarring scale 1 scale 4*y}
texture {Rusting scale 2+4*y translate -10}     
texture {Rusting scale 2*y translate 10}
texture {Dirt scale 2/3 scale 4*y translate 50}
}
box {0,1 
scale <32,24,.25> 
translate <-16,0,1/8>
scale <1.0125,1.0125,2>
} 
object {IBeam}
object {IBeam translate -12*x} 
object {IBeam translate  12*x}  
object {IBeam scale 1/3 rotate -90*x translate < 2,-3,0>}
object {IBeam scale 1/3 rotate -90*x translate <-2,-3,0>}     
object {IBeam scale 1/3 rotate -90*x translate <10,-3,0>}
object {IBeam scale 1/3 rotate -90*x translate <14,-3,0>} 
object {IBeam scale 1/3 rotate -90*x translate <-10,-3,0>}
object {IBeam scale 1/3 rotate -90*x translate <-14,-3,0>}  
object {LightAssembly translate <-12,0,0>}   
object {LightAssembly translate <  0,0,0>} 
object {LightAssembly translate < 12,0,0>} 
pigment {rgb .75}
finish {ambient 0 diffuse 1 }
texture {Scarring scale 1/2}
texture {Scarring scale 1/2}
texture {Scarring scale 1 scale 4*y}
texture {Rusting scale 2*y translate 10}
texture {Dirt scale 2/3 scale 4*y translate 50} 
texture {HeavyScarring scale 6*y}             
texture {HeavyScarring scale 6*y}
}
#declare LightAssembly2 =  
union {
object {IBeam translate 17*y-2*z scale 1/6 scale 1.75*y rotate -90*x translate < 1/2,-1,0>}    
object {IBeam translate 17*y-2*z scale 1/6 rotate -30*x translate < 0  ,-1,-10>}
object {IBeam translate 17*y-2*z scale 1/6 scale 1.75*y rotate -90*x translate <-1/2,-1,0>}
object {RRBox scale <1,1,1/2> translate <-.5,0,0> scale 2.5 translate 4*y rotate -30*x translate <0,-1,-10>
pigment {rgb 1}
finish {ambient 0 diffuse 1 phong 1/2}
texture {Scarring scale 1/2}
texture {Scarring scale 1/2} 
texture {HeavyScarring scale 6*y}
}
}
#declare BillBoard2 = 
union { 
union {
box {0,1 
scale <25,24,.25> 
translate <-0,0,0>  
}    
box {0,1 
scale <16,8,.25> 
translate <-16,16,0>  
}
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-16.000, 8.000, 0.000> <-13.600, 8.000, 0.000> <-10.400, 8.000, 0.000> <-8.000, 8.000, 0.000> 
		<-16.000, 10.400, -0.050> <-13.600, 10.400, -0.050> <-10.400, 10.400, 0.000> <-8.000, 10.400, 0.000> 
		<-16.998, 13.937, 0.546> <-14.598, 13.937, 0.596> <-10.399, 13.600, 0.075> <-8.000, 13.600, 0.000> 
		<-16.000, 16.000, -0.167> <-13.600, 16.000, -0.117> <-10.399, 16.000, 0.075> <-8.000, 16.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-16.000, 16.000, -0.167> <-13.600, 16.000, -0.117> <-10.399, 16.000, 0.075> <-8.000, 16.000, 0.000> 
		<-15.029, 18.007, -0.861> <-12.629, 18.007, -0.811> <-10.399, 18.400, 0.075> <-8.000, 18.400, 0.000> 
		<-12.042, 18.583, -2.878> <-11.338, 19.876, -1.666> <-9.705, 20.890, 0.472> <-8.000, 21.600, 0.000> 
		<-10.345, 19.690, -4.040> <-9.642, 20.983, -2.828> <-9.705, 23.290, 0.472> <-8.000, 24.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 8.000, 0.000> <0.000, 10.400, -0.200> <0.340, 13.799, 0.248> <0.000, 16.000, -0.668> 
		<-2.400, 8.000, 0.000> <-2.400, 10.400, -0.200> <-2.060, 13.799, 0.449> <-2.400, 16.000, -0.468> 
		<-5.600, 8.000, 0.000> <-5.600, 10.400, 0.000> <-5.593, 13.600, -0.075> <-5.593, 16.000, -0.075> 
		<-8.000, 8.000, 0.000> <-8.000, 10.400, 0.000> <-8.000, 13.600, 0.000> <-8.000, 16.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 16.000, -0.668> <-0.393, 18.544, -1.727> <-1.625, 20.923, -4.582> <-2.321, 23.033, -6.259> 
		<-2.400, 16.000, -0.468> <-2.793, 18.544, -1.527> <-3.328, 21.213, -2.704> <-4.025, 23.323, -4.381> 
		<-5.593, 16.000, -0.075> <-5.593, 18.400, -0.075> <-5.717, 22.551, -0.631> <-5.717, 24.951, -0.631> 
		<-8.000, 16.000, 0.000> <-8.000, 18.400, 0.000> <-8.000, 21.600, 0.000> <-8.000, 24.000, 0.000> 
	}
	scale z/2
	scale -y
	translate 24*y
	scale <1.5,1,1>
}   
scale <-1,1,1>
texture {
pigment {image_map{
png "PovAdd"
once interpolate 2 
}
scale <50,24,.25> 
translate <-25,0,0>
}
normal {granite scale 25 bump_size .375}

finish {ambient 0 diffuse 2.5}
}
texture {Scarring scale 4*y}
texture {Scarring scale 2 scale 4*y}
texture {Chipping scale 3/2 translate 20}
texture {Chipping scale 1 translate -10}    
texture {Rusting scale 4+4*y translate -10}      
texture {Dirt scale 2/3 scale 4*y translate 50} 
texture {pigment{gradient y triangle_wave 
color_map {[.95 rgb .5 transmit 1][1 rgb .5]}
scale 10 warp {turbulence .5} scale 1/10 
turbulence .125
} scale 6}      
texture {pigment{gradient x triangle_wave 
color_map {[.95 rgb .5 transmit 1][1 rgb .5]}
scale 10 warp {turbulence .5} scale 1/10  
turbulence .125
} scale 6} 
}
//light_source {<0,4,-8> rgb 1 spotlight point_at <0,10,0> radius 50 falloff 55 fade_distance 10 fade_power 2}
//light_source {<0,4,-8> rgb .5 spotlight point_at <0,10,0> radius 50 falloff 55 translate <-12,0,0> fade_distance 10 fade_power 2} 
//light_source {<0,4,-8> rgb .5 spotlight point_at <0,10,0> radius 50 falloff 55 translate < 12,0,0> fade_distance 10 fade_power 2} 
union {
box {0,1 scale <34,1/3,1> translate <-17,24,-2>}
box {0,1 scale <34,1/3,1> translate <-17,24,-4>}
box {0,1 scale <34,1/3,1> translate <-17,24,-6>}   
pigment {rgb 1.5} 
finish {ambient 0 diffuse 1}
texture {Scarring scale 1/2}
texture {Scarring scale 1/2}
texture {Scarring scale 1 scale 4*y}
texture {Rusting scale 2+4*y translate -10}     
texture {Rusting scale 2*y translate 10}
texture {Dirt scale 2/3 scale 4*y translate 50}
texture {HeavyScarring scale 4*y}  
texture {HeavyScarring scale 6*y}
texture {HeavyScarring scale 8*y}
}
box {0,1 
scale <50,24,.25> 
translate <-25,0,1/8>
scale <1.0125,1.0125,2>
} 
object {IBeam translate 5*y}
object {IBeam translate -12*x translate 5*y} 
object {IBeam translate  12*x translate 5*y}  
object {IBeam scale 1/3 rotate -90*x translate < 2,24,0>}
object {IBeam scale 1/3 rotate -90*x translate <-2,24,0>}     
object {IBeam scale 1/3 rotate -90*x translate <10,24,0>}
object {IBeam scale 1/3 rotate -90*x translate <14,24,0>} 
object {IBeam scale 1/3 rotate -90*x translate <-10,24,0>}
object {IBeam scale 1/3 rotate -90*x translate <-14,24,0>}  
object {LightAssembly2 translate <-12,0,0>}   
object {LightAssembly2 translate <  0,0,0>} 
object {LightAssembly2 translate < 12,0,0>} 
pigment {rgb .75}
finish {ambient -.15 diffuse 1 }
texture {Scarring scale 1/2}
texture {Scarring scale 1/2}
texture {Scarring scale 1 scale 4*y}
texture {Rusting scale 2*y translate 10}
texture {Dirt scale 2/3 scale 4*y translate 50}
scale -y
translate 10*y
}    
    


object {SignPost scale 2 translate <16,8,85>
pigment {rgb <.875,1,.8755>}
finish {ambient 0 diffuse 1 phong .25 phong_size 10}
texture {Scarring scale 4*y}        
texture {Chipping scale 3/4}    
texture {Rusting  translate 45 scale 4*y}
rotate <0,45,0> 
translate <22.5,50,80>
}
object {SignPost scale 2 translate <16,8,70>
pigment {rgb <.875,1,.8755>}
finish {ambient 0 diffuse 1 phong .25 phong_size 10}
texture {Scarring scale 4*y}        
texture {Chipping scale 3/4}    
texture {Rusting  translate 45 scale 4*y}
rotate <0,-60,0> 
translate <82.5,50,320>
} 

//High, Sky highways 
object {HighWay(<0,45,0>,<22.5,50,80>)}
object {HighWay(<-3.75,120,0>,<82.5,300,1020>)}

object {BillBoard scale .85 translate <0,-45,85> rotate <0,45,0> translate <22.5,50,80>}
object {BillBoard2 scale .75 rotate -90*y translate <14,-15,-15> rotate <0,45,0> translate <22.5,50,80>}



#include "CopRobot.inc"
union {
object {CopperBot} 
object {SlimeBulb} 
object {Cage}   
object {Cable(<0,0,0>,<0,0,3>,.025,-1/3,7,10) scale 1/2 rotate -45*x translate <.5,.5,0>}
object {Cable(<0,0,0>,<0,0,3>,.025,-1/3,7,10) scale 1/2 rotate -45*x translate <-.5,.5,0>} 
object {RotatingLight(<0,.5,1>,<0,.125,1>,20,false) scale .125/2.5 rotate -10*z translate .55*y translate .25*x}       
object {RotatingLight(<1,.25,0>,<1,0,0>,40,false) scale .125/2.5 rotate 10*z translate .55*y translate -.25*x}

pigment {rgb .5}
finish {ambient 0 diffuse 1 phong 2}
scale 3 rotate <-20,0,-10> translate <.5,8.5,7> 

}   
union {
object {CopperBot}  
object {SlimeBulb rotate -90*y} 
object {Cage} 
object {Cable(<0,0,0>,<0,0,3>,.025,-1/3,7,10) scale 1/2 rotate -45*x translate <.5,.5,0>}
object {Cable(<0,0,0>,<0,0,3>,.025,-1/3,7,10) scale 1/2 rotate -45*x translate <-.5,.5,0>}
object {RotatingLight(<0,.5,1>,<0,.125,1>,60,false) scale .125/2.5 rotate -10*z translate .55*y translate .25*x}       
object {RotatingLight(<1,.25,0>,<1,0,0>,90,false) scale .125/2.5 rotate 10*z translate .55*y translate -.25*x}
pigment {rgb .5}
finish {ambient 0 diffuse 1 phong 2}
scale 3 rotate <-20,0,20> rotate -30*y translate <-1,5,-5>
}  

union {
object {CopperBot}  
object {SlimeBulb rotate -180*y} 
object {Cage} 
object {Cable(<0,0,0>,<0,0,3>,.05,-1/3,10,15) scale 1/2 rotate -45*x translate <.5,.5,0>}
object {Cable(<0,0,0>,<0,0,3>,.05,-1/3,10,15) scale 1/2 rotate -45*x translate <-.5,.5,0>}
object {RotatingLight(<0,.5,1>,<0,.125,1>,20,false) scale .125/2.5 rotate -10*z translate .55*y translate .25*x}       
object {RotatingLight(<1,.25,0>,<1,0,0>,90,false) scale .125/2.5 rotate 10*z translate .55*y translate -.25*x}
pigment {rgb .5}
finish {ambient 0 diffuse 1 phong 2}
scale 4 rotate <-20,0,20> rotate 60*y translate <100,7,260>
}
union {
object {CopperBot}  
object {SlimeBulb rotate -180*y} 
object {Cage} 
object {Cable(<0,0,0>,<0,0,3>,.05,-1/3,10,15) scale 1/2 rotate -45*x translate <.5,.5,0>}
object {Cable(<0,0,0>,<0,0,3>,.05,-1/3,10,15) scale 1/2 rotate -45*x translate <-.5,.5,0>}
object {RotatingLight(<0,.5,1>,<0,.125,1>,990,false) scale .125/2.5 rotate -10*z translate .55*y translate .25*x}       
object {RotatingLight(<1,.25,0>,<1,0,0>,340,false) scale .125/2.5 rotate 10*z translate .55*y translate -.25*x}
pigment {rgb .5}
finish {ambient 0 diffuse 1 phong 2}
scale 4 rotate <-20,0,20> rotate 30*y translate  <90,10,255>
}




#include "Drunk.inc"
object {Drunk scale 3.5 rotate 5*y translate <-7,0,-1.5>}    

//Thunderbird w/o bags
union {
object{bottle scale 1/2 translate <-9,0,-2>}
object{bottle scale 1/2 translate <-8,0,-3>}
object{bottle scale 1/2 rotate 90*x rotate 118*y translate <-8,1/4,-2>}
translate <-1.5,0,-1.75>
}      
//Spilled hooch
blob {threshold .1
#declare C=0
#while (C<50)
sphere {0,1.5,1/4 scale <1,.125,1> translate x*(3*rand(seed(C*C*5))) rotate C*700*y}
#declare C=C+1
#end
pigment {rgb <.2,.1,.075> filter 1 transmit .5} 
finish {ambient 0 diffuse 1 phong 2 phong_size 2 reflection .3334 conserve_energy}
scale 1/4
translate <-7.75,0,-6>
}


//Drunk Light = 
light_source {<-70,100,-50> rgb <.575,.6,1>/3
spotlight 
point_at <-7,2,-1.5>
radius 1
falloff 1.5
//area_light 25,25,2,2
//jitter 
//orient 
media_interaction off
} 

#declare MetalStrut =
difference {
object {RRRBox scale <30,4,.4> translate <-15,0,-.2>}   
#declare C=0
#while (C<35)
cone {.5*y,2,3.5*y,0 translate (C-15)*x}        
cone {.5*y,2,3.5*y,0 translate (C-15)*x scale -y translate <2.5,4,0>}
#declare C=C+5
#end
pigment {rgb 1/4}
finish {ambient 0 diffuse 1 phong 2 phong_size 20 metallic}  
texture {Scarring scale 1/4}
texture {Scarring scale 1/4}
texture {Scarring scale 1/8}
texture {Scarring scale 1/8}       
texture {Dirt scale 1/6 scale y*4}
texture {Dirt scale 1/6 scale y*4}
texture {Dirt scale 1/6 scale y*4}

}  
#declare Doohicky =
union {
difference {
sphere {0,1 scale y/2}
disc {0,y,2}                                      
#declare C = 0 
#while (C<360)
box {0,1 scale <1/2,1,1/3> translate <-1,1/4,-1/6> rotate C*y}
#declare C=C+45
#end  
cone {y*.55,.625,y/4,0}
}
difference {
sphere {0,.9 scale y/2} 
#declare C = 0 
#while (C<360)
box {0,1 scale <1/2,1,1/5> translate <-1,.275,-1/10> rotate C*y}
#declare C=C+45
#end 
cone {y/2,.375,0,0}
}
sphere {0,.8 scale y/2} 
pigment {rgb <.8,.8,1>*2/3}
finish {ambient 0 diffuse 1 phong 2 phong_size 20 metallic} 
texture {Scarring scale 1/4}
texture {Scarring scale 1/4}
texture {Scarring scale 1/8}
texture {Scarring scale 1/8}       
texture {Dirt scale 1/6 scale y*4}
texture {Dirt scale 1/6 scale y*4}
texture {Dirt scale 1/6 scale y*4}
}

union {
object {MetalStrut translate -1.5*z}  
object {MetalStrut scale -y translate 4*y translate  1.5*z} 
object {RRBox scale <40,4,2> translate <-20,1/2,-1> 
pigment {rgb <.8,.9,1>*2}
finish {ambient 0 diffuse 1}
texture {Scarring scale 1/2 scale x*3}
texture {Scarring scale 1/2 scale x*3}
texture {Scarring scale 1/4 scale x*3}
texture {Scarring scale 1/4 scale x*3}       
texture {Dirt scale 1/6 scale y*4}
texture {Dirt scale 1/6 scale y*4}
texture {Dirt scale 1/6 scale y*4}  
texture {HeavyScarring scale 4*x}
}
object {Doohicky scale -y scale 1.5 translate y/2 }
object {Doohicky scale -y scale 1.5 translate y/2  translate 8*x}
object {Doohicky scale -y scale 1.5 translate y/2  translate 12*x} 
object {Cable(<0,0,0>,<0,2,5>,.1,2,8,20) rotate 90*y translate 1.5*z}
object {Cable(<0,0,0>,<0,2,5>,.1,2,8,20) rotate 90*y translate <5.25,0,1.5>}
object {Cable(<0,0,0>,<0,2,10>,.1/2,2,8,20) rotate 90*y translate <10.5,0,1.5>}
object {Cable(<0,0,0>,<0,3,15>,.125/3,5,8,20) rotate 90*y translate 1.25*z}
object {Cable(<0,0,0>,<0,3,20>,.125/2,4,8,20) rotate 90*y translate <-2.5,0,1.25>}
object {Cable(<0,0,0>,<0,3,10>,.125/3,4,8,20) rotate 90*y translate <.25,0,1.25>}
object {Cable(<0,0,0>,<0,3,20>,.075,6,8,20) rotate 90*y translate <-7.5,0,1.25>} 
object {Cable(<0,0,0>,<0,3,10>,.125/3,6,8,20) rotate 90*y translate <.25,0,-1.25>}
rotate 45*z
scale 1/3 
translate <-6,8,-10>
}  
object {PadSign scale .25 translate <-8,8,-1>}
light_source {<-8,8,-4> rgb <.25,1,.25> fade_distance 1 fade_power 2 shadowless media_interaction off}


#declare GrillLight =
union {
light_source {0 rgb <1,1,.75>*1.5 fade_distance 2 fade_power 2 media_interaction off }
sphere {0,1 
texture {
pigment {
radial frequency 60 triangle_wave 
color_map {
[.3 rgb 1]
[.7 rgb 1 transmit 1 ]
}
} 
scale 15  
finish {ambient 1}
}
texture {
pigment {
gradient y triangle_wave 
color_map {
[.3 rgb 1]
[.7 rgb 1 transmit 1 ]
}
}
scale y/120  
scale 15 
finish {ambient 1}
}
scale 1/100
}
}
union {GrillLight translate <-10,15,-2>} 




sphere {0,75  hollow no_shadow
pigment {rgbt 1}
interior { 
media {
method 2
//samples 5,5
//samples 19,19
//intervals 1
//aa_level 4
//aa_threshold .1
//jitter 0.00
//absorption 1/6
emission .125*<1,.9,.8>/15
//scattering {3, rgb .005 }
density {spherical scale 75}
} 
}
translate <16,8,85>
rotate <0,45,0> 
translate <22.5,50,60>
}
//Front    
object {LightBeam(<1,.9,.75>*2,.1,.25,1239) scale .15 rotate 5*z translate <3.5,8.55,-15>} 
object {LightBeam(<1,.9,.75>*2,.1,.5,1) rotate 20*z translate <50,35,40>} 
object {LightBeam(<1,.9,.75>*2,.1,.5,20) scale .75 rotate 20*z translate <50,41,40>} 
object {LightBeam(<1,.9,.75>*2,.1,.5,300) rotate 50*z translate <50,28,50>} 
object {LightBeam(<1,.9,.75>*2,.1,.25,4000) rotate 65*z translate <50,24,50>} 
object {LightBeam(<1,.9,.75>*2,.1,.5,5000) rotate 70*z translate <50,18,50>} 
//Back
object {LightBeam(<1,.9,.75>*2,.075,.5,6000) scale 2 rotate 35*z translate <120,75,200>} 
object {LightBeam(<1,.9,.75>*2,.1 ,.25,7000) scale 1 rotate 75*z translate <120,75,200>} 
object {LightBeam(<1,.9,.75>*2,.1  ,.5,8000) scale 2 rotate 35*z translate <60,65,150>} 
object {LightBeam(<1,.9,.75>*2,.1 ,.25,9000) scale 1.5 rotate 25*z translate <40,65,150>} 
object {LightBeam(<1,.9,.75>*2,.1  ,.5,0) scale 1.5 rotate 5*z translate <25,65,150>} 

                                                                                     
//Paper in the street.
#declare C=0
#while (C<30)
object {Paper(seed(C),(.5+.5*rand(seed(C)))  )
translate <1.5+rand(seed(C*C)),0,rand(seed(C*C*C))*8+C*3 - 30 >
texture {
pigment {rgb 1}   
normal {wrinkles}
finish {ambient .05 diffuse 2}  
}
texture {Scarring scale 1/4}
texture {Scarring scale 1/4}
texture {Scarring scale 1/4}
texture {Scarring scale 1/8}

}
object {Paper(seed(C*C),(.5+.5*rand(seed(C)))  )
translate <-4-rand(seed(C*C)),0,rand(seed(C*C*C))*8+C*3 - 5 >
texture {
pigment {rgb 1}  
normal {wrinkles}
finish {ambient .15 diffuse 1} 
} 
texture {Scarring scale 1/4}
texture {Scarring scale 1/2} 
texture {Scarring scale 1/4}
texture {Scarring scale 1/4}
texture {Scarring scale 1/8}

}
#declare C=C+1
#end       

#declare C=0
#while (C<20)
object {Paper(seed(C*C*C),(.5+.5*rand(seed(C)))  )
translate <-4+rand(seed(C*C))*7,0,rand(seed(C*C*C))*8+C*6 - 30 >
texture {
pigment {rgb 1}   
normal {wrinkles}
finish {ambient .05 diffuse 2}   
}
texture {Scarring scale 1/4}         
texture {Scarring scale 1/4}
texture {Scarring scale 1/4}
texture {Scarring scale 1/8}

}
#declare C=C+1
#end
        
      
//Trash Can
blob {threshold .1
cylinder {0,y*100,5,1 scale y/10} 
#declare C=0
#while (C<360)
cylinder {y,y*9.25,1,-1 translate x*5 rotate C*y}
#declare C=C+10
#end   
#declare C=0
#while (C<360)
sphere {0,4,-1/24 scale <rand(seed(C*C))/2+1/2,rand(seed(C*C*C))/2+1/2,rand(seed(C*C*C*C))/2+1/2> 
translate x*5     
translate y*10*rand(seed(C*C*C*C*C))
rotate C*y
}
#declare C=C+45
#end  
#declare C=0
#while (C<360)
sphere {0,2,-1/24 scale <rand(seed(C*C*4))/2+1/2,rand(seed(C*C*C*8))/2+1/2,rand(seed(C*C*C*C*5))/2+1/2> 
translate x*5     
translate y*10*rand(seed(C*C*C*C*C*9))
rotate C*y
}
#declare C=C+5
#end 
texture {
pigment {rgb 1}  
normal {dents scale 1/2}
finish {ambient .1 diffuse .9 phong 2 phong_size 5 metallic}
}        
texture {Scarring scale 4*y}         
texture {Scarring scale 2 scale 4*y}    
texture {Scarring scale 4 scale 4*y}     
texture {Scarring scale 4 scale 4*y}  
scale 1/3  
scale 1.675*y 
scale .95
translate <-10.5,0,-2.5> 
}

#declare C=0
#while (C<40)
object {Paper(seed(C*C*2),.6667)
translate <-rand(seed(C*C/8))-.25*rand(seed(C*C)),rand(seed(C*C*C))/2,0>
rotate (rand(seed(C*C*4))*70000)*y
texture {
pigment {rgb .875}   
normal {wrinkles}
finish {ambient .05 diffuse 1}
}
texture {Scarring scale 1/4}
texture {Scarring scale 1/4}
texture {Scarring scale 1/4}
scale .95   
translate <-10.5,5.6,-2.5> 
}
#declare C=C+1
#end



//Cable(Point1,Point2,CableRadius,SlackAmount,NumNodes,NumPoints,LATS)
#declare CableBundle1 = 
union {
object {Cable(<0,0,0> ,<0,0,50> ,1/6,5,20,15)}
object {Cable(<0,-1,0>,<0,-1,50>,1/6,7,20,15)}  
object {Cable(<0,-1,0>,<0,-1,50>,1/6,6,20,15)}
object {Cable(<0,-1,0>,<0,-1,50>,1/6,4,20,15)}
object {Cable(<0,1,0> ,<0,1,50> ,1/4,3,20,15)}        
object {RBox scale <2,4,3> translate <-1,-2.5,-1.5>}
object {RBox scale <2,4,3> translate <-1,-2.5,-1.5+50>} 
pigment {rgb 1}
normal {dents scale 1/2 turbulence 1}
finish {ambient .1 diffuse .9 phong .05 phong_size 2 crand .1}
texture {Scarring scale <1,4,4>}
texture {Scarring scale <1,4,4> scale 1/2}   
texture {Chipping scale <1,4,4>/2}
bounded_by {box {<-8,-40,-6>,<3,5,56>}}
clipped_by {bounded_by}
} 


union {
object {Cable(<0,0,0> ,<0,-2,50> ,1/4,20,50,25) translate <16,4,15> }
object {Cable(<0,0,0> ,<0,-2,25> ,1/4,40,40,75) translate <-16,3,15+50> }
object {Cable(<0,0,0> ,<0,-2,25> ,1/2,25,40,75) translate <-16,3,65+25> }
object {Cable(<0,0,0> ,<0,-2,50> ,1/2,10,50,25) translate <-16,3,15> }
object {Cable(<20,-6,20> ,<-24,-2,40> ,1/2,35,50,75) translate <-18,3,15-70> } 
object {Cable(<20,-8,20> ,<-24,-2,40> ,1/4,25,50,75) translate <-18,3,15-70> }   
object {Cable(<20,-25,10> ,<-24,-2,50> ,1/2,20,50,75) translate <-18,3,15-70> } 
object {CableBundle1 translate <16,4,-35>}
object {CableBundle1 translate <16,4,15> }
object {CableBundle1 translate <16,4,80> }  
rotate 45*y translate <22.5,50,80>
}


box {0,1
texture {
pigment{
image_map {png "drakedr" interpolate 2}
}
finish {ambient 0 diffuse 3} 
}        
texture {Dirt scale x/4 scale y*2}
texture {Dirt scale x/4 scale y*2 translate 2}
texture {Dirt scale x/4 scale y*2 translate -2}
scale <4,1,.03334>
translate <-4.75,14,0>
}
 
box {0,1
texture {
pigment{
image_map {png "seasiderd" interpolate 2}
}
finish {ambient 0 diffuse 3} 
}        
texture {Dirt scale x/4 scale y*2}
texture {Dirt scale x/4 scale y*2 translate 2}
texture {Dirt scale x/4 scale y*2 translate -2}
scale <4,1,.03334> 
rotate 90*y
translate <-4.75,14,0>
}

object {RRBox scale <1/2,1.25,.25> translate <-5,-.125+14,-.125> 
pigment {rgb 1} 
finish {ambient 0 diffuse 3}
texture {Dirt scale x/4 scale y*2}
texture {Dirt scale x/4 scale y*2 translate 2}
texture {Dirt scale x/4 scale y*2 translate -2}
}

object {Clock
scale 1/6 scale -x rotate -50*y translate <-4.75,-.125+12.5,-.25> 
} 

object {StreetPole scale 1/2 translate <8,2,-9>}
object {StreetPole scale 1/2 translate <8,2,40>}
object {StreetPole scale 1/2 translate <8,2,100>} 

//Cable(Point1,Point2,CableRadius,SlackAmount,NumNodes,NumPoints,LATS)
object {Cable(<0,0,0>,<0,0,60>,.05,8,8,30) translate <8.5,15,-9>} 
object {Cable(<0,0,0>,<0,0,60>,.05,6,8,30) translate <8.75,17,-9>}    
object {Cable(<0,0,0>,<0,0,60>,.1,8,8,30) translate <8.75,22,-9>}  
object {Cable(<0,0,0>,<0,0,59>,.05,8,8,30) translate <8.5,15,50>}      
object {Cable(<0,0,0>,<0,0,60>,.05,6,8,30) translate <8.75,17,50>}    
object {Cable(<0,0,0>,<0,0,70>,.1,4,4,30) translate <8.75,22,50>} 
                                                                   
object {Cable(<0,0,0>,<0,0,6>,.1,4,8,30) rotate 90*x translate <8.75,20,41>}
object {Cable(<0,0,0>,<0,0,10>,.05,4,8,30) rotate 90*x translate <8.5,14,41>} 
object {Cable(<0,0,0>,<0,0,5>,.05,6,8,30) rotate 90*x translate <8.5,14,41>} 


object {Cable(<0,0,0>,<0,0,49>,.05,4,8,40) rotate -100*y translate <8,12.5,-9.5>}
object {Cable(<0,0,0>,<0,0,49>,.025,4,8,40) rotate -100*y translate <8,12.325,-9.5>}
object {Cable(<0,0,0>,<0,0,49>,.025,5,8,40) rotate -100*y translate <8,12.25,-9.5>}

union {
object {Cable(<0,0,0>,<0,0,60>,.1,8,8,10) translate <7.5,15,0>} 
object {Cable(<0,0,0>,<0,0,60>,.2,6,8,10) translate <7.75,17,0>}    
object {Cable(<0,0,0>,<0,0,60>,.1,4,8,10) translate <7.75,22,0>}
rotate 60*y
translate <0,0,190>  
} 
union {
object {Cable(<0,0,0>,<0,0,60>,.1,8,8,10) translate <7.5,15,0>} 
object {Cable(<0,0,0>,<0,0,60>,.2,6,8,10) translate <7.75,17,0>}    
object {Cable(<0,0,0>,<0,0,60>,.1,4,8,10) translate <7.75,22,0>}
translate 60*z
rotate 60*y
translate <0,0,190>  
} 
union {
object {Cable(<0,0,0>,<0,0,60>,.1,8,8,10) translate <7.5,15,0>} 
object {Cable(<0,0,0>,<0,0,60>,.1,6,8,10) translate <7.75,17,0>}    
object {Cable(<0,0,0>,<0,0,60>,.1,4,8,10) translate <7.75,22,0>}
translate 120*z
rotate 60*y
translate <0,0,190>  
}  
union {
object {Cable(<0,0,0>,<0,0,60>,.1,8,8,10) translate <7.5,15,0>} 
object {Cable(<0,0,0>,<0,0,60>,.1,6,8,10) translate <7.75,17,0>}    
object {Cable(<0,0,0>,<0,0,60>,.2,4,8,10) translate <7.75,22,0>}
translate 180*z
rotate 60*y
translate <0,0,190>  
}                                                                               
        
#declare C=0
#while (C<5*60)         
union {
object {
StreetPole scale 1/2
translate <8,2,0>}  
translate C*z
rotate 60*y
translate <0,0,190>         
}
#declare C=C+60
#end


//Ventilators for Building 1
object {Ventilator(1,on) scale 3.5 rotate -90*y translate -4.25*x}
object {Ventilator(30,on) scale 3.5 rotate -90*y translate 2.75*x translate 25*y translate 20*z}
object {Ventilator(5,on) scale 3.5 rotate -90*y translate 2.75*x translate 25*y translate 70*z}


//Ventilators for Building 2
object {Ventilator(4,off) scale 3.5 rotate -90*y translate 2.5*x translate 80*z
translate <85,2,0>
rotate 60*y
translate <-15,0,300>  
}  
object {Ventilator(14,on) scale 3.5 rotate -90*y translate 2.5*x translate 80*z
translate <85,30,0>
rotate 60*y
translate <-15,0,300>  
}  
object {Ventilator(11,on) scale 3.5 rotate -90*y translate 2.5*x translate 80*z
translate <85,55,0>
rotate 60*y
translate <-15,0,300>  
}

//Ventilators for Building 3
object {Ventilator(24,on) scale 3.5 rotate -90*y translate 2.5*x translate 5*z
translate <85,2,0>
rotate 60*y
translate <87.5,0,375>  
}  
object {Ventilator(34,off) scale 3.5 rotate -90*y translate 2.5*x translate 5*z
translate <85,30,0>
rotate 60*y
translate <87.5,0,375> 
} 
object {Ventilator(8,on) scale 3.5 rotate -90*y translate 2.5*x translate 5*z
translate <85,55,0>
rotate 60*y
translate <87.5,0,375> 
}

object {Ventilator(12,off) scale 3.5 rotate -90*y translate 2.5*x translate 30*z
translate <85,2,0>
rotate 60*y
translate <87.5,0,375>  
}  
object {Ventilator(16,on) scale 3.5 rotate -90*y translate 2.5*x translate 30*z
translate <85,30,0>
rotate 60*y
translate <87.5,0,375> 
}  
object {Ventilator(84,on) scale 3.5 rotate -90*y translate 2.5*x translate 30*z
translate <85,55,0>
rotate 60*y
translate <87.5,0,375> 
}