#version unofficial MegaPov 0.4;
global_settings {
max_trace_level 20  
radiosity {brightness .75 count 3}// media on}  
post_process {soft_glow{2/3, 10}}      
}
 
/*camera {
location <0,5,-20>
look_at <0,25,200>
}*/
camera {
location <0,5,-20>
look_at <0,25,200>
} 
//light_source {<10,10,-20> rgb 1/2}
/*camera {
location <500,250,-200>
look_at <0,0,0>
}*/

#declare Scarring =
texture {pigment {bozo color_map {[0 rgb .175 transmit .75][1 rgb .175 transmit 1]}scale 2}}
texture {pigment {bozo pigment_map {[0 bozo color_map {[0 rgb .125 transmit .75][1 rgb .125 transmit 1]}scale .125][.5 rgb .175 transmit 1]}scale 2}translate 25}
#declare Rusting =
texture {pigment {bozo color_map {[0 rgb <1,.5,.4> transmit .75][1 rgb <1,.5,.4> transmit 1]}scale 2}}
texture {pigment {bozo pigment_map {[0 bozo color_map {[0 rgb <1,.5,.4> transmit .75][1 rgb <1,.5,.4> transmit 1]}scale .125][.5 rgb .175 transmit 1]}scale 2}translate 25}
#declare Rusting2 =
texture {pigment {bozo color_map {[0 rgb <1,.5,.4> transmit .875][1 rgb <1,.5,.4> transmit 1]}scale 2}}
texture {pigment {bozo pigment_map {[0 bozo color_map {[0 rgb <1,.5,.4> transmit .875][1 rgb <1,.5,.4> transmit 1]}scale .125][.5 rgb .175 transmit 1]}scale 2}translate 25}
#declare Chipping =
texture {   
pigment {bozo pigment_map {[.4 bozo color_map {[.2 rgb 1 transmit .125][.3 rgb 1 transmit 1]} turbulence 1/2 scale .125/2][.5 rgb .175 transmit 1]}scale 8}
}
#declare Chipping2 =
texture {   
normal {bozo normal_map {[.4 bozo normal_map {[.2 bumps scale 1/16/12 bump_size 1/12][.3 bumps scale 1/8 bump_size 0]} turbulence 1/2 scale .125/2][.5 bumps scale 1/8 bump_size 0]}scale 8}
pigment {bozo pigment_map {[.4 bozo color_map {[.2 rgb 1 transmit .125][.3 rgb 1 transmit 1]} turbulence 1/2 scale .125/2][.5 rgb .175 transmit 1]}scale 8}
}
#declare Chipping3 =
texture {   
pigment {bozo pigment_map {[.4 bozo color_map {[.2 rgb 1.5][.3 rgb 1 transmit 1]} turbulence 1/2 scale .125/2][.5 rgb .175 transmit 1]}scale 8}
}
  
#include "Background.inc"

#declare Scum1 =
function {
noise3d(x,y,z)^1.5
*noise3d(x*2,y*2,z*2)
}
#declare RRBox=
isosurface{
function{(x^(6)+y^(6)+z^(6))}
threshold 1
contained_by {box{-1,1}}
translate <1,1,1>
scale .5
} 
#declare RBox=
isosurface{
function{(x^(12)+y^(12)+z^(12))}
threshold 1
contained_by {box{-1,1}}
translate <1,1,1>
scale .5
} 
#declare RBox2=
isosurface{
function{(x^(24)+y^(24)+z^(24))}
threshold 1
contained_by {box{-1,1}}
translate <1,1,1>
scale .5
} 
#declare RBox3=
superellipsoid {
<.0125, .0125>
translate <1,1,1>
scale .5
} 

//Concrete Pavement
union {
box {<-100000,-100,-100><0,0,100000000> rotate 30*y translate 200*z}
difference {
box {<-10000,-100,-100><2.5,0,100000000>}   
blob {threshold .1  
cylinder {<0,0,0>,<0,0,200>,1,1/2 scale <1,1/3,1>} 
cylinder {<0,-1/3,0>,<0,0,200>,2/3,1 scale <.75,2/3,1>} 
cylinder {<0,-10,0>,<0,20,0>,1/2,1 translate 2*z}   
scale <1,2/3,1>
translate <-3.875,.35,0>
} 
blob {threshold .1  
cylinder {<0,0,0>,<0,0,200>,1,1/2 scale <1,1/3,1>} 
cylinder {<0,-1/3,0>,<0,0,200>,2/3,1 scale <.75,2/3,1>} 
cylinder {<0,-10,0>,<0,20,0>,1/2,1 translate 2*z}   
scale <1,2/3,1>
translate <1.75,.35,-10>
}
}
//Concrete Bumper
union {
object {RBox2 scale <2,2,300> translate <2.5,-1,-100>}
object {RBox2 scale <2,2,20000> translate <2.5,-1,0> rotate 60*y translate 200*z} 

#declare C=0
#while (C<200)
union {
object {RBox scale <2,5,1.5> rotate 30*z translate <0,-.5,-.75>}
object {RBox2 scale <2,4,1> rotate 30*z translate <.25,-.5,-.5>}    
object {RRBox scale <2,4,1> translate <-2,-.5,-.5>}
translate <5.5,-2,C>
}
#declare C=C+20
#end

cylinder {-100*z,200*z,1/3
pigment {rgb <.875,1,.8755>}
finish {ambient 0 diffuse 1 phong .25 phong_size 10}
texture {Scarring scale 4*y}        
texture {Chipping scale 3/4}    
texture {Rusting  translate 45 scale 4*y} 
translate <4.5,1.75,0>
}

//Concrete Bumper Texture  
pigment {rgb 1}
normal {dents scale 1/2 turbulence 1}
finish {ambient .1 diffuse .9 phong .05 phong_size 2 crand .1}
texture {Scarring scale <1,4,4>}
texture {Scarring scale <1,4,4> scale 1/2}   
texture {Chipping scale <1,4,4>/2}
}
//Concrete Pavement Texture
pigment {rgb 1}
normal {dents scale 1 turbulence 1 bump_size 1/3}
finish {ambient .1 diffuse .9 phong .05 phong_size 2 crand .05}
texture {Scarring scale <1,4,4>}
texture {Scarring scale <1,4,4> scale 2}
}


#declare ConcreteGrimeTex1 = 
texture {
pigment {
planar
pigment_map { 
[0 rgb 0 transmit 1]
[1 gradient x triangle_wave 
pigment_map {
/*[0 function {Scum1(x,y,z)} triangle_wave pigment_map {
[0 rgb <1,1,.8>/3 transmit 1] 
[.125*3/4 bozo  color_map {[0 rgb <.3,.32,.2>/2][.5 rgb .15][1 rgb <.2,.25,.2>/3]}turbulence 2 scale 1/16]}
translate y 
scale 1/4
] */
[0 rgb 0]
[1 rgb 0 transmit 1]
}
scale 5
warp {turbulence 1}
scale 1/5
scale 10*x+10*z
] 
} 
}
normal {dents scale 1/3}
finish {ambient 0 diffuse 1 phong 0 crand .1}
}
texture {Scarring scale 1/2 scale 2*z}

//Building1
union {
object {RBox3 scale <80,35,100> translate <-85,-5,0>}
#declare C=0
#while (C<100)
object {RRBox scale <1,35,2> rotate 2*z translate <-5,-5,C>}
#declare C=C+10
#end
#declare C=0
#while (C<20)
object {RRBox scale <1,35,2> rotate 2*z rotate 90*y translate <-22.5+C,-5,0>}
#declare C=C+5
#end  

#declare C=0
#while (C<35)
object {RRBox scale <3,1,2> rotate 5*x translate <-12,C,-2/3>}
#declare C=C+3
#end  
#declare C=0
#while (C<35)
object {RRBox scale <2.5,2,2> translate <-9.75,C+1,-2/3>}
#declare C=C+3
#end 
               
#declare B1SideDetail =
union {
object {RBox scale <8,6,49.5> rotate 45*z translate <-3.5,15,50.25>} 
object {RBox scale <8,8,50> translate <-5.5,20,50>} 
object {RBox scale <2,6,52> translate <-4.5,21,49>}   
object {RBox scale <2,6,52> translate <-2,21,49>}   
object {RBox scale <2,6,52> translate <.5,21,49>}   
object {RBox scale <8,6,50> translate <-5.5,28,50>} 
}
object {B1SideDetail} 
object {B1SideDetail scale .25*z}  

object {RBox2 scale <1,7.5,100> translate <-5.5,-1,-3.75>}  

object {RBox scale <1.5,7,1> translate <-5.75,-1,-3>} 
object {RBox scale <1.5,7,1> translate <-5.75,-1,-1.5>} 


//object {RBox scale <4,6,50> translate <-5,30,50>}
box {<-10000,-100,-100>,<350,100000,-99.5> pigment {rgb 0}}
pigment {rgb <1,.95,.9>}
normal {dents scale 1/4}
finish {ambient .1 diffuse .9 phong .05 phong_size 2 crand .1}
texture {Scarring scale 4*y}
texture {Scarring scale 4*y scale 2}  
texture {Rusting2 scale 2*y scale 1/2 translate 20}
texture {Chipping scale 1/4} 
texture {Rusting scale 2*y scale 2 translate -20}
} 

//Building2
union {
object {RBox3 scale <80,35,100> translate <-85,-5,0>}
#declare C=0
#while (C<100)
object {RRBox scale <1,35,2> rotate 2*z translate <-5,-5,C>}
#declare C=C+10
#end    

#declare C=0
#while (C<20)
object {RRBox scale <1,35,2> rotate 2*z rotate 90*y translate <-22.5+C,-5,0>}
#declare C=C+5
#end  
              
#declare B2SideDetail =
union {
object {RBox scale <8,6,49.5> rotate 45*z translate <-3.5,15,50.25>} 
object {RBox scale <8,8,50> translate <-5.5,20,50>} 
object {RBox scale <2,6,52> translate <-4.5,21,49>}   
object {RBox scale <2,6,52> translate <-2,21,49>}   
object {RBox scale <2,6,52> translate <.5,21,49>}   
object {RBox scale <8,6,50> translate <-5.5,28,50>} 
}
object {B2SideDetail translate -100*z scale .75*z translate 35*z} 
object {B2SideDetail translate -100*z scale .75*z translate 85*z}   
object {B2SideDetail translate -100*z scale .75*z translate -32*y scale -y translate 35*z} 
object {B2SideDetail translate -100*z scale .75*z translate -32*y scale -y translate 85*z}
//object {RBox scale <4,6,50> translate <-5,30,50>}
pigment {rgb <1,.95,.9>}
normal {dents scale 1/4}
finish {ambient .1 diffuse .9 phong .05 phong_size 2 crand .1}
texture {Scarring scale 4*y}
texture {Scarring scale 4*y scale 2}  
texture {Rusting2 scale 2*y scale 1/2 translate 20}
texture {Chipping} 
texture {Rusting scale 2*y scale 2 translate -20}   
translate <85,0,0>
rotate 60*y
translate <-15,0,300>
} 

//Building3
union {
object {RBox3 scale <80,35,100> translate <-85,-5,0>}
#declare C=0
#while (C<100)
object {RRBox scale <1,35,2> rotate 2*z translate <-5,-5,C>}
#declare C=C+10
#end
#declare C=0
#while (C<20)
object {RRBox scale <1,35,2> rotate 2*z rotate 90*y translate <-22.5+C,-5,0>}
#declare C=C+5
#end                 
object {B2SideDetail translate -100*z scale .75*z translate 35*z} 
object {B2SideDetail translate -100*z scale .75*z translate 85*z}   
object {B2SideDetail translate -100*z scale .75*z translate -32*y scale -y translate 35*z} 
object {B2SideDetail translate -100*z scale .75*z translate -32*y scale -y translate 85*z}
//object {RBox scale <4,6,50> translate <-5,30,50>}
pigment {rgb <1,.95,.9>}
normal {dents scale 1/4}
finish {ambient .1 diffuse .9 phong .05 phong_size 2 crand .1}
texture {Scarring scale 4*y}
texture {Scarring scale 4*y scale 2}  
texture {Rusting2 scale 2*y scale 1/2 translate 20}
texture {Chipping} 
texture {Rusting scale 2*y scale 2 translate -20}   
translate <85,0,0>
rotate 60*y
translate <87.5,0,375>
}




 
 

#declare WaterWall = 
union {
box {<-500,0,-100>,<500,.00001,100>
translate <0,0,100>
rotate -45*x
}
#declare C=0
#while (C<100)    
difference {
box {<-2,0,-100>,<2,3,100> translate ((C*10)-500)*x
translate <0,0,100>
rotate -45*x
}
plane {-y,0 translate 143*y 
pigment {rgb 1} 
finish {ambient 0 diffuse 1 crand .1}
texture {Scarring scale 1/2 scale 2*z}
texture {Scarring scale 1/2 scale 2*z} 
texture {Rusting scale 3}
}
}
#declare C=C+1
#end   
pigment {planar color_map {[0 rgb .875][.25 rgb .875][.375 rgb .675][.5 rgb .625][.75 rgb .25][.875 rgb .125][1 rgb 1.25]}scale 2 warp {turbulence .5} scale 1/2 scale 12 translate -40*y
translate <0,142,62.5-100>}
finish {ambient 0 diffuse 1}
texture {Scarring scale 2*y}
texture {Chipping2 scale 1/2 scale 4*z rotate 45*y} 
texture {Rusting2 scale 6*y}
texture {ConcreteGrimeTex1} 
}
//object {WaterWall translate -450*x}  
object {WaterWall translate  450*x rotate -30*y translate <0,-142,-62.5+100>}

#declare LightPost = 
union {
cylinder {0,y*8,1}   
cylinder {-y*2,y*2,1.25}
cone {y*2,1.25,y*4,1}   
difference {  
union {sphere {<-8,11,0>,1}   
cylinder {<-3,11,0>,<-8,11,0>,1} 
intersection {
torus {3,1 rotate 90*x translate <-3,8,0>}
box {<1.2,8,-1.5>,<-3,12,1.5>}
}
}     
object {RRBox scale <2,1,40> translate <-1,0,-20>
translate <-6.5,9.5,0>}  
object {RRBox scale <2,1,40> translate <-1,0,-20>
translate <-3.5,9.5,0>}
}
union {sphere {<-8,11,0>,.8}   
cylinder {<-3,11,0>,<-8,11,0>,.8}  
intersection {
torus {3,.8 rotate 90*x translate <-3,8,0>}
box {<1.2,8,-1.5>,<-3,12,1.5>}
}
pigment {planar color_map {[0 rgb .25][1 rgb 2]} translate 8*y}
finish {ambient 1 diffuse 1 phong 1}
}
translate 2*y     
}

#declare SignPost =
union {
cylinder {0,y*10,1}   
cylinder {-y*4,y*4,1.25}
cone {y*4,1.25,y*6,1}   
intersection {
torus {3,1 rotate 90*x translate <-3,10,0>}
box {<1.2,10,-1.5>,<-3,14,1.5>}
} 
difference {  
union {sphere {<-12,13,0>,1}   
cylinder {<-3,13,0>,<-12,13,0>,1} 
}     
object {RRBox scale <2,1,40> translate <-1,0,-20>
translate <-11,11.5,0>}   
object {RRBox scale <2,1,40> translate <-1,0,-20>
translate <-8,11.5,0>}  
object {RRBox scale <2,1,40> translate <-1,0,-20>
translate <-5,11.5,0>}
}
union {sphere {<-12,13,0>,.8}   
cylinder {<-3,13,0>,<-12,13,0>,.8} 
pigment {planar color_map {[0 rgb .25][1 rgb 2]} translate 13*y}
finish {ambient 1 diffuse 1 phong 1}
} 
object {RBox 
texture {pigment {image_map {tga "SanSign" interpolate 2 once}}
finish {ambient .25 diffuse 1.25 phong 1/2}}
texture {Scarring scale 1/6 scale 4*y}        
texture {Chipping scale 1/24 translate 2}    
texture {Rusting  scale 1/6 translate 45 scale 4*y}
scale <10,6,.1> translate <-12,6,0>}
translate 4*y
}


#macro HighWay(Rot,Trans)
union {
//Traffic =
#declare C=0
#while (C<11000) 
#declare Rand = rand(seed(C*C*C-4))                                                                   
#declare Rand2 = rand(seed(C*C+2))  
#declare Rand3 = rand(seed(C*C*6+4))
box {0,1 scale <12,12,20> 
pigment {planar  pigment_map {[0 rgb 0 transmit 1][.075 planar color_map {[0 rgb 0 transmit 1][.5-.25*Rand3 rgb 0 transmit .35]} rotate 90*x scale 10 translate 10*z]} scale 12*y}
scale 2*z 
scale y*(1+Rand2/2)
translate <2,0,-10010+C> 
rotate Rot
}
#declare C=C+80+(Rand*80)
#end

#declare C=0
#while (C<11000) 
union {
cylinder {0,-y*1000,5 translate <6,0,120>}
cylinder {0,-y*1000,5 translate <-6,0,120>} 
cylinder {0,-y*1000,6 translate <6,-40,120>} 
cylinder {0,-y*1000,6 translate <-6,-40,120>}      
cone {0,6,y*3,5 translate <6,-40,120>}
cone {0,6,y*3,5 translate <-6,-40,120>} 
cone {0,5.5,-y*3,5 translate <6,-20,120>}
cone {0,5.5,-y*3,5 translate <-6,-20,120>} 
cone {0,7.5,-y*2,6 translate <6,-10,120>}
cone {0,7.5,-y*2,6 translate <-6,-10,120>} 
cylinder {0,-y*20,5.5 translate <6,0,120>}
cylinder {0,-y*20,5.5 translate <-6,0,120>} 
cylinder {0,-y*15,6 translate <6,0,120>}
cylinder {0,-y*15,6 translate <-6,0,120>}
cylinder {0,-y*10,7.5 translate <6,0,120>}
cylinder {0,-y*10,7.5 translate <-6,0,120>}  
union {    
object {RBox2 scale <32,1000,-13> translate <-16,-1055,+6.5+120>}  
object {RBox3 scale <30,1000,-14> translate <-15,-1057.5,+7+120>}
pigment {planar color_map {[0 rgb .875][.25 rgb .875][.375 rgb .675][.5 rgb .625][.75 rgb .25][.875 rgb .125][1 rgb 1.25]}scale 2 warp {turbulence .5} scale 1/2 scale 15 translate (-Trans.y-41)*y}
finish {ambient 0 diffuse 1.25} 
texture {Scarring scale 2*y}
texture {Chipping2 scale 1/2 scale 4*z rotate 45*y} 
texture {Rusting2 scale 6*y} 
}
scale <.75,1,.75>
rotate <-Rot.x,0,-Rot.z> 
translate (-10000+C)*z
pigment {rgb .75}
finish {ambient 0 diffuse 1.25} 
texture {Scarring scale 2*y}
texture {Chipping2 scale 2/3 scale 4*z rotate 45*y} 
texture {Rusting2 scale 6*y} 
texture {Chipping2 scale 1/3 scale 4*y} 
rotate Rot 
}
#declare C=C+300
#end

union {
cylinder {0,-y*1000,5 translate <6,0,120>}
cylinder {0,-y*1000,5 translate <-6,0,120>} 
cylinder {0,-y*1000,6 translate <6,-40,120>}
cylinder {0,-y*1000,6 translate <-6,-40,120>} 
cone {0,6,y*3,5 translate <6,-40,120>}
cone {0,6,y*3,5 translate <-6,-40,120>}  
cone {0,5.5,-y*3,5 translate <6,-20,120>}
cone {0,5.5,-y*3,5 translate <-6,-20,120>} 
cone {0,7.5,-y*2,6 translate <6,-10,120>}
cone {0,7.5,-y*2,6 translate <-6,-10,120>} 
cylinder {0,-y*20,5.5 translate <6,0,120>}
cylinder {0,-y*20,5.5 translate <-6,0,120>} 
cylinder {0,-y*15,6 translate <6,0,120>}
cylinder {0,-y*15,6 translate <-6,0,120>}
cylinder {0,-y*10,7.5 translate <6,0,120>}
cylinder {0,-y*10,7.5 translate <-6,0,120>} 
union {    
object {RBox2 scale <32,1000,-13> translate <-16,-1055,+6.5+120>}  
object {RBox3 scale <30,1000,-14> translate <-15,-1057.5,+7+120>}
pigment {planar color_map {[0 rgb .875][.25 rgb .875][.375 rgb .675][.5 rgb .625][.75 rgb .25][.875 rgb .125][1 rgb 1.25]}scale 2 warp {turbulence .5} scale 1/2 scale 15 translate (-Trans.y-41)*y}
finish {ambient 0 diffuse 1.25} 
texture {Scarring scale 2*y}
texture {Chipping2 scale 1/2 scale 4*z rotate 45*y} 
texture {Rusting2 scale 6*y} 
}
scale <.75,1,.75>
rotate <-Rot.x,0,-Rot.z> 
pigment {rgb .75}
finish {ambient 0 diffuse 1.25} 
texture {Scarring scale 2*y}
texture {Chipping2 scale 2/3 scale 4*z rotate 45*y}    
texture {Rusting2 scale 6*y}  
texture {Chipping2 scale 1/3 scale 4*y} 
rotate Rot 
}
object {RBox2 scale <8,7,11000> translate <-4,-4 ,-10000>  translate -5*x rotate Rot}
object {RBox2 scale <8,7,11000> translate <-4,-4 ,-10000>  translate  5*x rotate Rot}  
object {RBox scale <4,7,11000> translate <-2,-8 ,-10000>  translate -5*x rotate Rot}
object {RBox scale <4,7,11000> translate <-2,-8 ,-10000>  translate  5*x rotate Rot}     
#declare C=0
#while (C<11000) 
object {RBox scale <8,7,4> translate <-4,-7.5,-2> translate  (-10000+C)*z rotate Rot}     
#declare C=C+8
#end
#declare C=0
#while (C<11000) 
object {RBox scale <10,7,20> translate <-5,-8.5,-10> translate  (-10000+C)*z rotate Rot}     
#declare C=C+60
#end 
#declare C=0 
#while (C<11000) 
object {LightPost scale 2 translate <15,0,(-10000+C)> scale -x
pigment {rgb <.875,1,.8755>}
finish {ambient 0 diffuse 1 phong .25 phong_size 10}
texture {Scarring scale 4*y}        
texture {Chipping scale 3/4}    
texture {Rusting  translate 45 scale 4*y}   
rotate Rot
} 
#declare C=C+220
#end 

object {RBox scale <10,4,20> translate <12,4,-10+85> rotate Rot}
object {RBox2 scale <20,7,11000>    translate <-10,-2   ,-10000> rotate Rot}
object {RBox2 scale <22,6.75,11000> translate <-11,-1.75,-10000> rotate Rot}
object {RBox2 scale <28,6,11000>    translate <-14,-1   ,-10000> rotate Rot}
object {RBox2 scale <30,5.5,11000>  translate <-15,-.5  ,-10000> rotate Rot}
object {RBox2 scale <32,5,11000>    translate <-16,0    ,-10000> rotate Rot} 
union {
object {RBox2 scale <1,4,11000>    translate <-15,4.5    ,-10000> rotate Rot}
object {RBox2 scale <1,4,11000>    translate <-15,4.5    ,-10000> scale -x rotate Rot}
pigment {rgb 1.25}
finish {ambient 0 diffuse 1.25} 
texture {Scarring scale 2*z rotate Rot scale 2}
texture {Chipping2 scale 1/2 scale 4*z rotate 45*y} 
texture {Rusting2 scale 6*y} 
}
pigment {rgb 1}
finish {ambient -.1 diffuse 1.25} 
texture {Scarring scale 2*z rotate Rot scale 2}
texture {Chipping2 scale 1/2 scale 4*z rotate 45*y} 
texture {Rusting2 scale 6*y} 
translate Trans 
}  
#end 


object {SignPost scale 2 translate <16,8,85>
pigment {rgb <.875,1,.8755>}
finish {ambient 0 diffuse 1 phong .25 phong_size 10}
texture {Scarring scale 4*y}        
texture {Chipping scale 3/4}    
texture {Rusting  translate 45 scale 4*y}
rotate <0,45,0> 
translate <22.5,50,80>
}
object {SignPost scale 2 translate <16,8,70>
pigment {rgb <.875,1,.8755>}
finish {ambient 0 diffuse 1 phong .25 phong_size 10}
texture {Scarring scale 4*y}        
texture {Chipping scale 3/4}    
texture {Rusting  translate 45 scale 4*y}
rotate <0,-60,0> 
translate <82.5,50,320>
}    

//High, Sky highways 
object {HighWay(<0,45,0>,<22.5,50,80>)}
object {HighWay(<-3.75,120,0>,<82.5,200,1020>)}
object {HighWay(<0,-60,0>,<82.5,50,320>)} 


//Wires and Cables hanging beneath the overpass.

#macro PointTo2(p)
  #local RotVector = <0, 0, 0>;
  #local Rd = vlength(p);
  #if(Rd != 0)
    #local RotVector = x*degrees(asin(p.y/Rd));
    #if(p.z != 0)
      #local RotVector = RotVector + y*degrees(atan2(p.x, p.z));
    #end
  #end
  rotate RotVector
#end
  
#macro Cable(Point1,Point2,CableRadius,SlackAmount,NumNodes,NumPoints)
#declare Point2 = <Point2.x,-Point2.y,Point2.z>
#declare TheCableSpline =
spline {
cubic_spline
#declare P=0
#while (P<NumNodes)      
#local Dip = 1-pow(abs(P/NumNodes*2-1),2) 
P/NumNodes,<0,-Dip*SlackAmount,vlength(Point2-Point1)*(P/NumNodes)>   
#declare P=P+1
#end
}    
blob {threshold .1
#declare C=0
#while (C<NumPoints)      
cylinder {TheCableSpline(C/NumPoints),TheCableSpline(C/NumPoints+((.9-.05*(1-(5/NumPoints)))/NumPoints))+.0001,CableRadius,1/4} 
#declare C=C+1
#end   
PointTo2(Point2+Point1)
translate Point1    
pigment {rgb .375}
finish {ambient 0 diffuse 1 phong 2/3}
}
#end   

//Cable(Point1,Point2,CableRadius,SlackAmount,NumNodes,NumPoints,LATS)
#declare CableBundle1 = 
union {
object {Cable(<0,0,0> ,<0,0,50> ,2/3,5,20,15)}
object {Cable(<0,-1,0>,<0,-1,50>,2/3,7,20,15)}
object {Cable(<0,1,0> ,<0,1,50> ,2/3,3,20,15)}        
object {RBox scale <2,4,3> translate <-1,-2.5,-1.5>}
object {RBox scale <2,4,3> translate <-1,-2.5,-1.5+50>} 
pigment {rgb 1}
normal {dents scale 1/2 turbulence 1}
finish {ambient .1 diffuse .9 phong .05 phong_size 2 crand .1}
texture {Scarring scale <1,4,4>}
texture {Scarring scale <1,4,4> scale 1/2}   
texture {Chipping scale <1,4,4>/2}
bounded_by {box {<-8,-40,-6>,<3,5,56>}}
clipped_by {bounded_by}
}

//object {HighWay(<0,45,0>,<22.5,50,80>)}
union {
object {Cable(<0,0,0> ,<0,-2,50> ,2/3,20,50,25) translate <16,4,15> }
object {Cable(<0,0,0> ,<0,-2,25> ,2/3,40,40,75) translate <-16,3,15+50> }
object {Cable(<0,0,0> ,<0,-2,25> ,2/3,25,40,75) translate <-16,3,65+25> }
object {Cable(<0,0,0> ,<0,-2,50> ,2/3,10,50,25) translate <-16,3,15> }
object {Cable(<20,-6,20> ,<-24,-2,40> ,2/3,35,50,75) translate <-18,3,15-70> } 
object {Cable(<20,-8,20> ,<-24,-2,40> ,2/3,25,50,75) translate <-18,3,15-70> }   

object {Cable(<20,-25,10> ,<-24,-2,50> ,2/3,20,50,75) translate <-18,3,15-70> } 

object {CableBundle1 translate <16,4,-35>}
object {CableBundle1 translate <16,4,15> }
object {CableBundle1 translate <16,4,80> }  
rotate 45*y translate <22.5,50,80>
}




#include "CopRobot.inc"
object {CopperBot 
scale 3 rotate <-20,0,-10> translate <-1,1.5,3>
}
object {CopperBot scale 3 rotate <-20,0,20> 
rotate -30*y translate <1,5,-5>
}