// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


#declare pole =
merge {
cone
{
   2*x,  0.1,
  -1*x, 0.15
  }
cone
{
   0.6*x,  0.05,
  0*x, 0.1
  // open

rotate z*45
translate < 1.93,0,0>
}
sphere
{
  <0, 1, 0> // center of sphere <X Y Z>
  0.16       // radius of sphere
  translate < 1.93,-0.97,0>
}}//end pole

//containers for the spots
#declare spots =
union{
difference{

sphere
{
  <0, 1, 0> // center of sphere <X Y Z>
  0.2       // radius of sphere
  hollow on
  }

sphere
{
  <0, 1, 0> // center of sphere <X Y Z>
  0.2       // radius of sphere
    scale <1,2,1> 
  translate y*-0.5
}}}

//actual Light
#declare spots_lights =
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
   
   spotlight
   translate <-1, 0.7, 0>
   point_at <-5, 4, 0>      // direction of spotlight
  radius 2                // hotspot (inner, in degrees)
  tightness 2            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 60               // intensity falloff radius (outer, in degrees)
  fade_distance 0.6
  fade_power 1
}

#declare direct_light =
union{
object {spots_lights}
object {spots
rotate z*50}
}









#declare ad_light =
union{
object{direct_light
translate <3.2,-0.1,0>}
object {pole
}
texture {
    pigment { rgb <0.55, 0.5, 0.45> }
    finish { Metallic_Finish }
}}



#declare pawn_light = 
union { 
 light_source { <0,0,0>//< 3.7,1.5,-5.7 >   color rgb <0.2,0.2,0> 
 looks_like { text
{
  ttf "crystal.ttf", "Emerald City",
  0.1, // depth
  0  // spacing
  
  scale 0.2
  pigment {rgb <0, 0.21, 0>}
  finish {ambient 3 }
  rotate y*90
  translate <3.3,1,-4.7>
}}}

light_source { <0,0,0>//< 3.7,1.5,-5.7 > color rgb <0.2,0.2,0> 
 looks_like {
text
{
  ttf "crystal.ttf", "Gold and Pawn",
  0.1, // depth
  0  // spacing
  scale 0.2 // stretch it taller
  pigment {rgb <0, 0.21, 0> }
  finish {ambient 3 }
  rotate y*90
  translate <3.3,0.85,-4.7>
}}} }

