/******************************************************************************
*
* Superpatch d'aprs Persistence of Vision Raytracer version 3.1
*
* bking.inc
*
* Bohrger King.
*
* Ajouter panneau "No smoking room upstairs"
*
******************************************************************************/

// Salle  l'tage; Y=600  900

#macro BKing_Light(T)
light_source{
  T
  Cream*.7
  fade_distance 300
  fade_power 1.5
  groups "bk"
}
#end

#macro BKing_SalleH()
#local h1=860;
difference{
  box {<-5, 600, 2000>, <0, 900, 3000>} // Faade
  box {<-20, 700, 2050>, <20, h1, 2175>}
  box {<-20, 700, 2205>, <20, h1, 2330>}
  box {<-20, 700, 2360>, <20, h1, 2485>}
  box {<-20, 700, 2515>, <20, h1, 2640>}
  box {<-20, 700, 2670>, <20, h1, 2795>}
  box {<-20, 700, 2825>, <20, h1, 2950>}
  pigment {BakersChoc}
  light_group "std"
}
difference{
  box {<-5, 600, 2000>, <-1000, 900, 3000>}
  box {<5, 610, 2010>, <-990, 890, 2990>}
  pigment {Orange}
  finish {Dull}
  light_group "bk"
}
BKing_Light(<-200, 850, 2020>)
BKing_Light(<-600, 850, 2020>)
BKing_Light(<-200, 850, 2980>)
BKing_Light(<-600, 850, 2980>)
BKing_Light(<-400, 611, 2500>)
#end

#macro BK_Table(T)
union{
  box {<-60, 95, -60>, <60, 100, 60> pigment {Red}}
  box {<-55, 98, -55>, <55, 101, 55> pigment {White}}
  cylinder {-10*y, 95*y, 5 pigment {Red}}
  light_group "bk"
  translate T
}
#end

#macro BK_Frame(Nom)
box {0, 1
  pigment {
    image_map{
      png 
      Nom
      once
      interpolate 2
    }
  }
  translate -.5
}
#end

#macro BKing_SalleB()
difference{
  box {<-105, -10, 2000>, <-1000, 500, 3000>}
  box {<5, 1, 2010>, <-990, 450, 2990>}
  pigment {Orange*.5+White*.5}
  finish {Dull}
  light_group "bk"
}
box {
  <-105, -9, 2000>, <-1000, 5, 3000> 
  pigment {BakersChoc}
  normal {bumps 1 scale 10}
  light_group "bk"
}
BKing_Light(<-200, 250, 2020>)
BKing_Light(<-550, 250, 2020>)
BKing_Light(<-900, 250, 2020>)
BKing_Light(<-200, 250, 2980>)
BKing_Light(<-550, 250, 2980>)
BKing_Light(<-900, 250, 2980>)
BKing_Light(<-375, 490, 2500>)
BKing_Light(<-725, 490, 2500>)

BK_Table(<-200, 5, 2500>)
BK_Table(<-320, 5, 2500>)
BK_Table(<-200, 5, 2800>)
BK_Table(<-200, 5, 2100>)
BK_Table(<-320, 5, 2700>)

object {BK_Frame("bohr2.png")scale <100, 100*292/216, 2> translate <-375, 170, 2990>}
object {BK_Frame("bohr.png")scale <100, 100*75/54, 2> translate <-725, 170, 2990>}

#end

#declare BKingTile=difference{
  intersection {
    box {<-1, 0, -1>, <1, 1, 1>}
    prism {
      conic_sweep
      linear_spline
      1, // sweep the following shape from here ...
      0, // ... up through here
      5, // the number of points making up the shape ...
      <-1, -1>, <-1, 1>, <1, 1>, <1, -1>, <-1, -1>
      scale <1, -10, 1>
      translate 10*y
    }
    rotate 90*x scale <10, 25, 25> translate <0, 25, 25>
  }
  //box {<0, 0, 0>, <10, 50, 50>}
  sphere {0, 1 scale <10, 25, 25> translate <10, 25, 25>}
}

#macro BKing()
union{
  difference {
    box {<0, 0, 2000>, <-110, 600, 3000>}
    cylinder {-100*y, 450*y, 1 scale <100, 1, 1000> translate <0, 0, 2000>}
    box {<0, 0, 2030>, <-100, 330, 2950>}
    box {<-90, 220, 2050>, <-130, 280, 2930>} // Fentre prix
    box {<-90, 20, 2050>, <-130, 200, 2120>} // Portes
    box {<-90, 20, 2130>, <-130, 200, 2220>}
    box {<-90, 20, 2240>, <-130, 80, 2930>} // Fentres
    box {<-90, 90, 2240>, <-130, 200, 2930>}
    no_shadow
  }
  box {<40, 450, 2000>, <-200, 600, 3000>}
  #local Z=2000;
  #while (Z<3000)
    object {BKingTile translate <40, 450, Z>}
    object {BKingTile translate <40, 500, Z>}
    object {BKingTile translate <40, 550, Z>}
    #local Z = Z+50;
  #end
  pigment {Red}
  finish {Shiny}
  light_group "std"
}
text {
  ttf "tt0756m_.ttf" "BOHRGER KING" 
  .1, 0
  scale <100, 100, 10> 
  rotate 90*y
  translate <55, 490, 2850>
  bounded_by{box{<60, 450, 2000><0, 600, 3000>}}
  pigment {White}
  finish {Shiny}
  light_group "std"
}

union{
  #local Y=90;
  #while (Y < 115)
    object {BKingTile scale 10/50 translate <-90, Y, 2110>}
    object {BKingTile scale 10/50 translate <-90, Y, 2100>}
    object {BKingTile scale 10/50 translate <-90, Y, 2090>}
    object {BKingTile scale 10/50 translate <-90, Y, 2130>}
    object {BKingTile scale 10/50 translate <-90, Y, 2140>}
    object {BKingTile scale 10/50 translate <-90, Y, 2150>}
    #local Y = Y+10;
  #end
  pigment {White}
  finish {Shiny}
  light_group "std"
}

BKing_SalleH()
BKing_SalleB()
#end

