/******************************************************************************
*
* Superpatch d'aprs Persistence of Vision Raytracer version 3.1
*
* hk.inc
*
* Pub "hk" d'aprs H&M, dans rectangle <0, 1500, 1000> - <0, 2000, 2000>
*
******************************************************************************/

#macro HK_Neon(DZ, Z)
cylinder {
  0, 400*y, DZ/3
  pigment {
    gradient z color_map{
      [0 LightBlue]
      [1 White]
    }
    scale DZ/3
  }
  finish {ambient 1 diffuse 0}
  translate <0, 1500, Z>
}
#end


#macro HK()
//box {<0, 1500, 1000>, <-200, 2000, 2000> pigment {Pink} light_group "fluo"}
union{
  box {<-5, 1500, 1000>, <-1000, 2000, 2000> pigment {Black}}
  box {
    0, 1
    pigment {
      image_map{
	png "hk.png" //1600x1000
	interpolate 2 once
      }
    }
    finish {ambient 1 diffuse 0}
    scale <640, 400, 10>
    rotate 90*y translate <0, 1530, 1800>
    no_shadow
  }
  text {
    ttf "arial.ttf" "GENEVA - LOS ALAMOS" 
    .1, 0.1*x
    scale <66, 66, 10> 
    rotate 90*y
    translate <10, 1520, 1950>
    bounded_by{box{<20, 1500, 1000><0, 1700, 2000>}}
    pigment {Black}
    //finish {ambient 1 diffuse 0}
  } 
  #local Z=1025;
  #local DZ=20;
  #while (Z<2000)
    HK_Neon(DZ, Z)
    #local Z = Z+DZ;
  #end
  light_group "fluo"
}
#end

