/******************************************************************************
*
* Superpatch d'aprs Persistence of Vision Raytracer version 3.1
*
* immeubles.inc
*
* Picadilly revu et trs corrig
*
******************************************************************************/

#include "mwindow.pov"


#declare IDSeed=seed(5);
#macro IDLum(V1, V2)
  #local LL = .5+.5*rand(IGSeed);
  #local LL2 = rand(IGSeed);
  box {
    V1, V2
    pigment {
      bozo
      turbulence 1
      color_map{
	[0 White*LL]
	[1 rgb <.9, .8, .7>*LL2*LL +Orange*(1-LL2)*LL]
      }
      translate 10*rand(IGSeed)
      scale 10
    }
    finish {ambient 1}
  }
#end

#macro IDFenetre(T)
#if (T = 2)
  object{WCase_2_wl}
  object{Balcony_2_wl}
#end
#if (T = 4)
  object{WCase_4_nl}
#end
#if (T = 6)
  object{WCase_6_wl}
  object{Balcony_3_wl}
#end
#if (rand(IGSeed) > .3) // Volets ouverts
  object{Window_3_c translate z*2}
  #local TH0=15+75*rand(IGSeed);
  #local TH1 = TH0 + 15*(1-2*rand(IGSeed));
  #local TH2 = TH0 + 15*(1-2*rand(IGSeed));
  object{mShutter(4,xL,yL,0.2,0.3,20,5,TH1,TH2,0.7,0.1,rd,0.5,txtV1)}
#else
  object{mShutter(4,xL,yL,0.2,0.3,20,5,0,0,0.7,0.1,rd,0.5,txtV1)}
#end
#end

#macro IDEtg(T, Ybase0)
#local dX = 350;
#local X0 = -1200;
#local Xmax = -3000;
#local Base=200;

#local X=X0;
#while (X>Xmax)
  union{
    IDFenetre(T)
    scale Base/yL rotate -0*y translate <X, Ybase0, 0>
  }
  #local X = X-dX;
#end
#declare IDTrous=union{
  #local X=X0;
  #while (X>Xmax)
    box {<X, Ybase0, 0>-<xL/yL*Base, 0, 100>, <X, Ybase0, 0>+<xL/yL*Base, 100, 250>  }
    #local X = X-dX;
  #end
}

#local X=X0;
#while (X>Xmax)
  IDLum(<X, Ybase0, 0>-<xL/yL*Base,30, 0>, <X, Ybase0, 0>+<xL/yL*Base, -100, Base>)
  #local X = X-dX;
#end

#end

#macro ImmDroite() //Immeuble traditionnel de droite
#declare rd=seed(18908);
#declare xL=3;
#declare yL=9;
#declare txtFen1=texture{pigment{ForestGreen}}         
#declare txtFen2=texture{pigment{White}}
#declare txtVit1=texture{pigment{Clear}}
#declare txtBalcon1=texture{pigment{Green*0.3}}
#declare txtBalcon2=texture{pigment{rgb<1,0.9,0.8>*1.3}}
#declare txtTF=texture{pigment{rgb<1,0.9,0.8>*1.3}}
#declare txtToit=texture{pigment{rgb<0.8,0.7,0.9>*0.3}}
#declare txtV1=texture{pigment{SkyBlue}}
#declare txtV2=texture{pigment{rgb<1,0.8,0.5>}}
#declare Window_3_c=object{mWindow(2,xL,yL,0.2,0.3,0.1,0.1,1,3,0,0,0.5,0.1,txtFen1,txtFen2,txtVit1)}
#declare Balcony_2_wl=object{mBalcony(2,3.3,4,1.3,0.1,0.5,0  ,5,txtBalcon1)}
#declare Balcony_5_wl=object{mBalcony(5,xL+1,3,2.6 ,0.2,0.12,0,10,txtBalcon2)}
#declare Balcony_3_wl=object{mBalcony(3,3.7,4,1.3,0.1,0.5,0  ,5,txtBalcon1)}
#declare WCase_2_wl=object{mWindowCase(2,xL,yL,0.4,1,0.1,  0,1,  2,0.5,3.5,txtTF,txtToit)}
#declare WCase_4_nl=object{mWindowCase(4,xL,yL,0.4,1,0.1,0.6,0,  0,0.5,0.5,txtTF,txtToit)}
#declare WCase_6_wl=object{mWindowCase(6,xL,yL, 25,1,0.1,0.2,2,0.1,0.5,3.5,txtTF,txtToit)}
#declare Shutter_4_o=object{mShutter(4,xL,yL,0.2,0.3,20,5,75,56,0.7,0.1,rd,0.5,txtV1)}
#local dX = 350;
#local X0 = -1200;
#local Xmax = -3000;
#local Base=200;

union{
  //---------------- Rez de chausse
  IDEtg(2, 100)
  #local Trous_RC=IDTrous
  //---------------- 1er tage
  IDEtg(4, 400)
  #local Trous_Etg1=IDTrous
  //---------------- 2me tage
  IDEtg(4, 700)
  #local Trous_Etg2=IDTrous
  //---------------- 3me tage
  IDEtg(4, 1000)
  #local Trous_Etg3=IDTrous
  //---------------- 4me tage
  IDEtg(4, 1300)
  #local Trous_Etg4=IDTrous
  //---------------- 5me tage
  IDEtg(4, 1600)
  #local Trous_Etg5=IDTrous
  //---------------- Immeuble
  
  difference{
    box {<-1000, 0, 0>, <-10000, 2000, 300> }
    object {Trous_RC}
    object {Trous_Etg1}
    object {Trous_Etg2}
    object {Trous_Etg3}
    object {Trous_Etg4}
    object {Trous_Etg5}
    pigment {Cream}
    normal {granite scale 10}
    finish {Dull}
  }
  light_group "std"
}

#end






#declare IGSeed=seed(50);
#macro IGLum(V1, V2)
  #local LL = .5+.5*rand(IGSeed);
  #local LL2 = rand(IGSeed);
  box {
    V1, V2
    pigment {
      bozo
      turbulence 1
      color_map{
	[0 White*LL]
	[1 rgb <.9, .8, .7>*LL2*LL +Orange*(1-LL2)*LL]
      }
      translate 10*rand(IGSeed)
      scale 10
    }
    finish {ambient 1}
  }
#end

#macro IGFenetre(T)
#if (T = 2)
  object{WCase_2_wl}
  object{Balcony_5_wl}
#end
#if (T = 4)
  object{WCase_4_nl}
#end
#if (T = 6)
  object{WCase_6_wl}
  object{Balcony_5_wl}
#end
#if (rand(IGSeed) > .3) // Volets ouverts
  object{Window_3_c translate z*2}
  #local TH0=15+75*rand(IGSeed);
  #local TH1 = TH0 + 15*(1-2*rand(IGSeed));
  #local TH2 = TH0 + 15*(1-2*rand(IGSeed));
  object{mShutter(4,xL,yL,0.2,0.3,20,5,TH1,TH2,0.7,0.1,rd,0.5,txtV1)}
#else
  object{mShutter(4,xL,yL,0.2,0.3,20,5,0,0,0.7,0.1,rd,0.5,txtV1)}
#end
#end

#macro ImmGauche() //Immeuble traditionnel de gauche
#local rd=seed(18908);
#declare xL=3;
#declare yL=9;
#declare txtFen1=texture{pigment{ForestGreen}}         
#declare txtFen2=texture{pigment{White}}
#declare txtVit1=texture{pigment{Clear}}
#declare txtBalcon1=texture{pigment{Green*0.3}}
#declare txtBalcon2=texture{pigment{rgb<1,0.95,0.9>*1.3}}
#declare txtTF=texture{pigment{rgb<1,0.95,0.9>*1.3}}
#declare txtToit=texture{pigment{rgb<0.8,0.7,0.9>*0.3}}
#declare txtV1=texture{pigment{White*.3} finish {phong 0.3 phong_size 3}}
#declare txtV2=texture{pigment{rgb<1,0.8,0.5>}}
#declare Window_3_c=object{mWindow(2,xL,yL,0.2,0.3,0.1,0.1,1,3,0,0,0.5,0.1,txtFen1,txtFen2,txtVit1)}
#declare Balcony_5_wl=object{mBalcony(5,xL+1,3,2.6 ,0.2,0.12,0,10,txtBalcon2)}
#declare WCase_6_wl=object{mWindowCase(6,xL,yL, 25,1,0.1,0.2,2,0.1,0.5,3.5,txtTF,txtToit)}
#declare WCase_2_wl=object{mWindowCase(2,xL,yL,0.4,1,0.1,  0,1,  2,0.5,3.5,txtTF,txtToit)}
#declare WCase_4_nl=object{mWindowCase(4,xL,yL,0.4,1,0.1,0.6,0,  0,0.5,0.5,txtTF,txtToit)}
//#declare Shutter_4_o=object{mShutter(4,xL,yL,0.2,0.3,20,5,75,56,0.7,0.1,rd,0.5,txtV1)}
//box {<-1000, 0, 0>, <-10000, 2000, 300> pigment {Cream} finish{Dull}}
#local dZ = 350;
#local Zmax = 4000;
#local Base=200;
union{
  //---------------- Rez de chausse
  #local Ybase0=100; 
  #local Z=3200;
  #while (Z<Zmax)
    union{
      IGFenetre(2)
      scale Base/yL rotate -90*y translate <0, Ybase0, Z>
    }
    #local Z = Z+dZ;
  #end
  #local Trous_RC=union{
    #local Z=3200;
    #while (Z<Zmax)
      box {<0, Ybase0, Z>-<100, 0, xL/yL*Base>, <0, Ybase0, Z>+<100, 250, xL/yL*Base>  }
      #local Z = Z+dZ;
    #end
  }
  
  #local Z=3200;
  #while (Z<Zmax)
    IGLum(<0, Ybase0, Z>-<30, 0, xL/yL*Base>, <0, Ybase0, Z>+<-100, Base, xL/yL*Base>)
    #local Z = Z+dZ;
  #end
  
  //---------------- 1er tage
  #local Ybase1=400; 
  #local Z=3200;
  #while (Z<Zmax)
    union{
      IGFenetre(4)
      scale Base/yL rotate -90*y translate <0, Ybase1, Z>
    }
    #local Z = Z+dZ;
  #end
  #local Trous_Etg1=union{
    #local Z=3200;
    #while (Z<Zmax)
      box {<0, Ybase1, Z>-<100, 0, xL/yL*Base>, <0, Ybase1, Z>+<100, Base, xL/yL*Base>  }
      #local Z = Z+dZ;
    #end
  }
  #local Z=3200;
  #while (Z<Zmax)
    IGLum(<0, Ybase1, Z>-<30, 0, xL/yL*Base>, <0, Ybase1, Z>+<-100, Base, xL/yL*Base>)
    #local Z = Z+dZ;
  #end
  
  //---------------- 2me tage
  #local Ybase1=700; 
  #local Z=3200;
  #while (Z<Zmax)
    union{
      IGFenetre(4)
      scale Base/yL rotate -90*y translate <0, Ybase1, Z>
    }
    #local Z = Z+dZ;
  #end
  #local Trous_Etg2=union{
    #local Z=3200;
    #while (Z<Zmax)
      box {<0, Ybase1, Z>-<100, 0, xL/yL*Base>, <0, Ybase1, Z>+<100, Base, xL/yL*Base>  }
      #local Z = Z+dZ;
    #end
  }
  #local Z=3200;
  #while (Z<Zmax)
    IGLum(<0, Ybase1, Z>-<30, 0, xL/yL*Base>, <0, Ybase1, Z>+<-100, Base, xL/yL*Base>)
    #local Z = Z+dZ;
  #end
  
  //---------------- 3me tage
  #local Ybase1=1000; 
  #local Z=3200;
  #while (Z<Zmax)
    union{
      IGFenetre(4)
      scale Base/yL rotate -90*y translate <0, Ybase1, Z>
    }
    #local Z = Z+dZ;
  #end
  #local Trous_Etg3=union{
    #local Z=3200;
    #while (Z<Zmax)
      box {<0, Ybase1, Z>-<100, 0, xL/yL*Base>, <0, Ybase1, Z>+<100, Base, xL/yL*Base>  }
      #local Z = Z+dZ;
    #end
  }
  #local Z=3200;
  #while (Z<Zmax)
    IGLum(<0, Ybase1, Z>-<30, 0, xL/yL*Base>, <0, Ybase1, Z>+<-100, Base, xL/yL*Base>)
    #local Z = Z+dZ;
  #end
  
  //---------------- 4me tage
  #local Ybase1=1300; 
  #local Z=3200;
  #while (Z<Zmax)
    union{
      IGFenetre(4)
      scale Base/yL rotate -90*y translate <0, Ybase1, Z>
    }
    #local Z = Z+dZ;
  #end
  #local Trous_Etg4=union{
    #local Z=3200;
    #while (Z<Zmax)
      box {<0, Ybase1, Z>-<100, 0, xL/yL*Base>, <0, Ybase1, Z>+<100, Base, xL/yL*Base>  }
      #local Z = Z+dZ;
    #end
  }
  #local Z=3200;
  #while (Z<Zmax)
    IGLum(<0, Ybase1, Z>-<30, 0, xL/yL*Base>, <0, Ybase1, Z>+<-100, Base, xL/yL*Base>)
    #local Z = Z+dZ;
  #end
  
  //---------------- 5me tage
  #local Ybase1=1600; 
  #local Z=3200;
  #while (Z<Zmax)
    union{
      IGFenetre(6)
      scale Base/yL rotate -90*y translate <0, Ybase1, Z>
    }
    #local Z = Z+dZ;
  #end
  #local Trous_Etg5=union{
    #local Z=3200;
    #while (Z<Zmax)
      box {<0, Ybase1, Z>-<100, 0, xL/yL*Base>, <0, Ybase1, Z>+<100, Base, xL/yL*Base>  }
      #local Z = Z+dZ;
    #end
  }
  #local Z=3200;
  #while (Z<Zmax)
    IGLum(<0, Ybase1, Z>-<30, 0, xL/yL*Base>, <0, Ybase1, Z>+<-100, Base, xL/yL*Base>)
    #local Z = Z+dZ;
  #end
  
  //---------------- Immeuble
  difference{
    box {<0, 0, 3000>, <-300, 2000, 10000> }
    object {Trous_RC}
    object {Trous_Etg1}
    object {Trous_Etg2}
    object {Trous_Etg3}
    object {Trous_Etg4}
    object {Trous_Etg5}
    pigment {Cream}
    normal {granite scale 10}
    finish {Dull}
  }
  light_group "std"
}
#end

