/*****************************************************************************\
*
* Superpatch d'aprs Persistence of Vision Raytracer version 3.1
*
* vehicules.inc - 03/00
*
* Wrapper pour meshes de vhicules
*
\*****************************************************************************/

#declare Bus_Seed = seed(321);

#macro Bus_PC1(R) // Pare-chocs 1/4 cercle rayon R
intersection{
  box {<0, -20, 0>, <R+5, 20, R+5>}
  union{
    torus {R, 3 translate 5*y}
    torus {R, 3 translate -5*y}
    difference{
      cylinder {-5*y, 5*y, R+1}
      cylinder {-10*y, 10*y, R-1}
    }
  }
}
#end

#macro Bus_PC2() // Pare-chocs droit -x  +x
union{
  box {<-1, -5, -1>, <1, 5, 1>}
  cylinder {<-1, -5, -1>, <1, -5, -1>, 3}
  cylinder {<-1, 5, -1>, <1, 5, -1>, 3}
}
#end

#macro Bus_Fen(X, Y, WIDTH)
#local DEPTH=8;
#local R=WIDTH*sqrt(2)/(sqrt(2)-1);
union{
  box{<-(X/2+WIDTH-R), Y/2-.1, -DEPTH/2>, <X/2+WIDTH-R, Y/2+WIDTH, DEPTH/2>}
  box{<-(X/2+WIDTH-R), -Y/2+.1, -DEPTH/2>, <X/2+WIDTH-R, -Y/2-WIDTH, DEPTH/2>}
  box{<X/2-.1, -(Y/2+WIDTH-R), -DEPTH/2>, <X/2+WIDTH, Y/2+WIDTH-R, DEPTH/2>}
  box{<-X/2+.1, -(Y/2+WIDTH-R), -DEPTH/2>, <-X/2-WIDTH, Y/2+WIDTH-R, DEPTH/2>}
  difference{
    union {
      cylinder {-DEPTH/2*z, DEPTH/2*z, R translate <-(X/2+WIDTH-R), (Y/2+WIDTH-R), 0>}
      cylinder {-DEPTH/2*z, DEPTH/2*z, R translate <(X/2+WIDTH-R), (Y/2+WIDTH-R), 0>}
      cylinder {-DEPTH/2*z, DEPTH/2*z, R translate <-(X/2+WIDTH-R), -(Y/2+WIDTH-R), 0>}
      cylinder {-DEPTH/2*z, DEPTH/2*z, R translate <(X/2+WIDTH-R), -(Y/2+WIDTH-R), 0>}
    }
    box {<-(X/2+WIDTH-R), -(Y/2+WIDTH+1), -DEPTH>, <(X/2+WIDTH-R), (Y/2+WIDTH+1), DEPTH>}
    box {<-(X/2+WIDTH+1), -(Y/2+WIDTH-R), -DEPTH>, <(X/2+WIDTH+1), (Y/2+WIDTH-R), DEPTH>}
    cylinder {-DEPTH*z, DEPTH*z, R-WIDTH translate <-(X/2+WIDTH-R), (Y/2+WIDTH-R), 0>}
    cylinder {-DEPTH*z, DEPTH*z, R-WIDTH translate <(X/2+WIDTH-R), (Y/2+WIDTH-R), 0>}
    cylinder {-DEPTH*z, DEPTH*z, R-WIDTH translate <-(X/2+WIDTH-R), -(Y/2+WIDTH-R), 0>}
    cylinder {-DEPTH*z, DEPTH*z, R-WIDTH translate <(X/2+WIDTH-R), -(Y/2+WIDTH-R), 0>}
  }
  //bounded_by{box{<-(X/2+WIDTH-R), -(Y/2+WIDTH-R), -DEPTH>, <(X/2+WIDTH-R), (Y/2+WIDTH-R), DEPTH>}}
  texture {TBus_Metal}
}
#if (rand (Bus_Seed) < .3)
  #local YH=Y/2*rand(Bus_Seed);
#else
  #local YH=Y/2;
#end
box {
  <-X/2, -Y/2, -.3>, <X/2, YH, .3>
  pigment {
    gradient y+z color_map{
      [0.0 rgbt <1, 1, 1, 0>]
      [0.2 rgbt <1, 1, 1, .8>]
      [0.5 rgbt <1, 1, 1, 1>]
      [1.0 rgbt <1, 1, 1, 1>]
    }
    turbulence <0, 0, .4>
    scale <10, 80, 10> translate <1000*rand(Bus_Seed), YH, 0>
  }
  no_shadow
}
#end

#macro Bus_Banc1()
superellipsoid {
  <0.3, 0.3>
  bounded_by{box{-1, 1}}
  rotate 90*y
  scale <30, 50, 5>
  translate 50*y
  rotate -10*x
  translate 10*y
  pigment {Orange}
}
#end

#macro Bus_Banc()
object{Bus_Banc1() translate 90*x}
object{Bus_Banc1() translate 30*x}
object{Bus_Banc1() translate -90*x}
#end

#macro Bus_Ext()
  // Extrieur
  union{
    difference{
      union{
	box {<-130, 0, -620>, <130, 200, 700>}
	box {<0, 0, -620>, <130, 200, -700>}
	cylinder {0.001*y, 200.01*y, 1 scale <130, 1, 80> translate <0, 0, -620>}
	cylinder {-620*z, 620*z, 1 scale <130, 10, 1> translate <0, 200, 0>}
	cylinder {0*x, 130*x, 1 scale <1, 10, 80> translate <0, 200, -620>}
	sphere {0, 1 scale <130, 10, 80> translate <0, 200, -620>}
      }
      intersection{
	cylinder {1*y, 190.01*y, 1 scale <125, 1, 75> translate <0, 0, -620>}
	box {<-130, .5, -620>, <130, 200, -700>}
      }
      box {<0, 50, -695>, <135, 190, -620>}
      box {<-150, 100, -710>, <150, 185, -620>}
      box {<-125, 50, -610>, <125, 195, 700>}//intrieur
      box {<-150, 100, -600>, <150, 160, -500>}
      box {<-150, 100, -480>, <150, 160, -380>}
      box {<-150, 100, -360>, <150, 160, -260>}
      box {<-150, 100, -240>, <150, 160, -140>}
      box {<-150, 100, -120>, <150, 160, -20>}
      cylinder {<-150, -5, -550>, <150, -5, -550>, 40}
      box {<-128, -5, -605>, <-100, 40, -400>}
      box {<-120, 50, -550>, <-70, 160, -630>}
      box {<-40, 100, -550>, <120, 160, -630>}
      bounded_by{box {<-150, 0, -700>, <150, 210, 700>}}
    }
    difference{
      box {<-125, 0.1, -620>, <130, 198, -625>}
      box {<-100, 50, -550>, <-50, 160, -630>}
      box {<-20, 100, -550>, <120, 160, -630>}
      bounded_by{box {<-125, 0, -620>, <130, 200, -625>}}
    }
    cylinder {<-125, 80, -620>, <-125, 190, -620>, 5}
    //Feux arrire
    cylinder {<-80, 35, -620>, <-80, 45, -700>, 10}
    cylinder {<-80, 65, -620>, <-80, 65, -700>, 10}
    box {<-70, 35, -620>, <-90, 65, -699.9>}
    //Tour pub latrale
    difference {
      box {<-128, 33, -278>, <-132, 87, -482>}
      box {<-128, 35, -280>, <-135, 85, -480>}
      bounded_by{box {<-128, 33, -278>, <-132, 87, -482>}}
    }
    bounded_by{box {<-150, 0, -700>, <150, 250, 700>}}
    texture {TBus}
  }
#end

#macro Bus_Int()
// Intrieur
difference{
  box {<-126, 50, -611>, <126, 196, 700>}
  box {<-124, 50, -609>, <124, 194, 700>}
  box {<-150, 100, -600>, <150, 160, -500>}
  box {<-150, 100, -480>, <150, 160, -380>}
  box {<-150, 100, -360>, <150, 160, -260>}
  box {<-150, 100, -240>, <150, 160, -140>}
  box {<-150, 100, -120>, <150, 160, -20>}
  bounded_by{box {<-126, 50, -611>, <126, 196, 700>}}
  texture {TBus2}
  no_shadow
}
#end

#macro Bus()
#declare TBus=texture{
    pigment {
      marble turbulence 0.2 octaves 4 color_map {
	[0 Red]
	[1 rgb <.9, .2, 0>]
      }
      rotate 90*z scale 100
    }
    normal {dents 0.3 scale 30}
    finish {Shiny}
}
#declare TBus2=texture{
    pigment {
      marble turbulence 0.2 octaves 4 color_map {
	[0 rgb <1, .8, .6>]
	[1 White]
      }
      rotate 90*z scale 100
    }
    normal {bozo 0.1 scale <30, 1, 30>}
    finish {Dull}
}
#declare TBus_Metal=texture {
  pigment {White}
  normal {granite bump_size .1 scale <50, 3, 50>}
  finish {phong 4 phong_size 10}
}

#local Bus_Lampe=light_source{
  <0, 180, 0> rgb <1, .9, .8>*.3/MBSamples fade_distance 150 fade_power 1.5
  groups "bus"
}
//////////////////////////////////////////////////////////////////
motion_blur{
union{
  Bus_Ext()
  Bus_Int()
  //Fentres
  union {Bus_Fen(100, 60, 5) rotate 90*y translate <127, 130, -550>}
  union {Bus_Fen(100, 60, 5) rotate 90*y translate <127, 130, -430>}
  union {Bus_Fen(100, 60, 5) rotate 90*y translate <127, 130, -310>}
  union {Bus_Fen(100, 60, 5) rotate 90*y translate <127, 130, -190>}
  union {Bus_Fen(100, 60, 5) rotate 90*y translate <127, 130, -70>}
  
  union {Bus_Fen(100, 60, 5) rotate -90*y translate <-127, 130, -550>}
  union {Bus_Fen(100, 60, 5) rotate -90*y translate <-127, 130, -430>}
  union {Bus_Fen(100, 60, 5) rotate -90*y translate <-127, 130, -310>}
  union {Bus_Fen(100, 60, 5) rotate -90*y translate <-127, 130, -190>}
  union {Bus_Fen(100, 60, 5) rotate -90*y translate <-127, 130, -70>}
  //box {<-100, 50, -550>, <-50, 160, -630>}
  //box {<-20, 100, -550>, <120, 160, -630>}
  union {Bus_Fen(50, 110, 5) rotate 0*y translate <-75, 105, -628>}
  union {Bus_Fen(140, 60, 5) rotate 0*y translate <5, 130, -628>}
  // Roues
  superellipsoid {
    <1, .3> bounded_by{box{-1, 1}}rotate 90*y scale <12, 38, 38>
    pigment {White*.2}
    //normal {spiral2 20 rotate 90*z}
    finish {phong 0.3 phong_size 3}
    translate <-110, 8, -550>}
  sphere {0, 1 scale <5, 20, 20> texture {TBus} translate <-120, 8, -550>}
  superellipsoid {
    <1, .3> bounded_by{box{-1, 1}} rotate 90*y scale <12, 38, 38>
    pigment {White*.2}
    normal {spiral2 20 rotate 90*z}
    finish {phong 0.3 phong_size 3}
    translate <110, 8, -550>}
  sphere {0, 1 scale <5, 20, 20> texture {TBus} translate <120, 8, -550>}
  // Barreaux plate-forme
  union{
    #local X = 0;
    #local dX = 20;
    #while (X <= 128)
    cylinder {90*y, 198*y, 2 translate <X, 0, -697>}
      #local X = X+dX;
    #end
    #local dTH = 10/180*3.14159;
    #local TH = dTH;
    #while (TH < 90/180*3.14159)
    cylinder {90*y, 198*y, 2 translate <0-127*sin (TH), 0, -620-77*cos(TH)>}
      #local TH = TH+dTH;
    #end
    //texture {T_Copper_3A}
    texture {TBus_Metal}
  }
  //Pare-chocs
  union{
    //arrire
    object{Bus_PC1(30) rotate -90*y translate <-120, 20, -630>}
    object{Bus_PC2() scale <30, 1, 1> rotate 90*y translate <-150, 20, -660>}
    object{Bus_PC1(30) rotate 180*y translate <-120, 20, -690>}
    object{Bus_PC2() scale <120, 1, 1> rotate 0*y translate <0, 20, -720>}
    object{Bus_PC1(20) rotate 90*y translate <120, 20, -700>}
    //latraux
    object{Bus_PC1(20) rotate 180*y translate <-130, 20, -470>}
    object{Bus_PC2() scale <470, 1, 1> rotate 90*y translate <-150, 20, 0>}
    texture {TBus_Metal}
  }
  // Lampes
  union{
    object {Bus_Lampe translate <0, 0, -600>}
    object {Bus_Lampe translate <-100, 0, -450>}
    object {Bus_Lampe translate <100, 0, -450>}
    object {Bus_Lampe translate <0, 0, -300>}
    object {Bus_Lampe translate <-100, 0, -150>}
    object {Bus_Lampe translate <100, 0, -150>}
    object {Bus_Lampe translate <0, 0, 0>}
  }
  //Bancs
  union{
    union{Bus_Banc() translate -600*z}
    union{Bus_Banc() translate -500*z}
    union{Bus_Banc() translate -400*z}
    union{Bus_Banc() translate -300*z}
    union{Bus_Banc() translate -200*z}
    union{Bus_Banc() translate -100*z}
  }
  // Destinations
  union{
    cylinder {<-130, 174, -600>, <-130, 174, 600>, 1}
    cylinder {<-130, 191, -600>, <-130, 191, 600>, 1}
    texture {TBus}
  }
  box {
    <-131, 175, -600>, <-129, 190, 0>
    pigment {White}
    finish {phong 1.4 phong_size 30}
  }
  text {
    ttf "gothicb.ttf" "Oxford Circus - Picadilly - Leicester Square"
    1, 0.1*x
    scale <15, 15, 1>
    rotate -90*y
    translate <-132, 178, -590>
    bounded_by{box{<-135, 175, -600>, <-131, 190, 0>}}
  }
  // Publicit
  box {
    0, 1
    pigment {
      image_map{
	png "LdB.png"
	once
      }
    }
    finish {phong 1.0 phong_size 300 metallic}
    scale <200, 50, 1>
    rotate -90*y
    translate <-131, 35, -480>
    no_shadow
  }
  // Feux arrire
  sphere {0, 1 pigment {Red} finish {ambient 1} scale <7, 7, 4> translate <-80, 65, -700>}
  sphere {0, 1 pigment {Orange} finish {ambient .3} scale <7, 7, 4> translate <-80, 55, -700>}
  sphere {0, 1 pigment {White} finish {ambient .3} scale <7, 7, 4> translate <-80, 45, -700>}
  translate 30*y
  light_group "bus"
  bounded_by{box {<-150, 0, -700>, <150, 250, 700>}}
  translate 10*clock*z
}
}
#end
  
/*****************************************************************************\
*
* Jaguar XJ-6
*
\*****************************************************************************/
  
  #macro Jag(T)
  #include "JAGUAR.inc"
  #local JJJ=union {
  object{Jag1 pigment {Black}}//sous la caisse
  object{Jag2 pigment {ForestGreen} finish {Shiny}}//carosserie
  object{Jag3 pigment {Clear}}//vitres
  object{Jag4 pigment {White*.2} finish {phong 0.1 phong_size 3}
}//roues
  object{
    Jag5
    pigment {
      gradient y color_map{
	[0 Gold]
	[1 White]
      }
      scale 2/30
    }
    finish {ambient 1}
  }//Phares
  object{Jag6 pigment {Red} finish {ambient 1}}//Feux arrire
  object{Jag7 pigment {Black}}//Autour phares
  object{Jag8 texture {T_Chrome_3C}}//Calendre
  object{Jag9 pigment {White}}//Plaque immat.
  object{Jag10 texture {T_Chrome_3C}}//Pare-chocs

}
#local J0=min_extent(JJJ);
#local J1=max_extent(JJJ);
motion_blur{
  union{
    object {
      JJJ
      translate <-(J0.x+J1.x)/2, -J0.y, -(J0.z+J1.z)/2>
      //  #debug concat("\nAvant=", str((J1.z-J0.z)/2*30, 0, 3),"")
      scale 33
      rotate 180*y
      translate T
    }
    #local JagLS=light_source {
      <0, 50, -270>
      Silver*2/MBSamples
      fade_distance 300
      fade_power 1.5
      spotlight
      point_at <0, 20, -500>
      radius 30
      falloff 50
      groups "std,bus"
    }
    object {JagLS translate -90*x + T}
    object {JagLS translate  90*x + T}
    // Chapeaux de roues: <110, 35, 135 et -185>
    union{
      sphere {0, 1 scale <5, 20, 20> translate <100, 35, 135>+T}
      sphere {0, 1 scale <5, 20, 20> translate <100, 35, -185>+T}
      pigment {ForestGreen}
      finish{Shiny}
    }
    light_group "std"
  }
  translate 20*clock*z
}
#end
  
/*****************************************************************************\
*
* Petite voiture jaune
*
\*****************************************************************************/

#macro M_CAR(T)
#include "m_car01.inc"
#local JJJ=union{
  union{
    object {m_car01}//carrosserie
    object {m_car06}//Toit ouvrant
    pigment {
      gradient y color_map{
	[0 White*.3]
	[.5 Yellow]
      }
      turbulence .1
      scale 150
    }
    finish {Shiny}
  }
  union{
    object {m_car02}//Pare-brise
    object {m_car03}//Vitre arrire
    object {m_car04}//Vitre gauche
    object {m_car05}//Vitre droite
    pigment {Clear} finish {ambient 1}
  }
  object {m_car07 pigment {White} finish {ambient 1}}//Phare avant gauche
  object {m_car08 pigment {White} finish {ambient 1}}//phare avant droit
  object {m_car09 pigment {Black} finish {ambient 1}}//Phare arrire droit
  object {m_car10 pigment {Black} finish {ambient 1}}//Phare arrire gauche
  object {m_car11 texture {T_Chrome_3C}}//Calandre
  object {m_car12 pigment {Black} finish {ambient 1}}//Dessous?
  union{
    object {m_car14}//Pneu AvD
    object {m_car15}//Pneu AvG
    object {m_car17}//Pneu ArG
    object {m_car19}//Pneu ArD
    pigment {Black} finish {Dull}
    translate -50*x
  }
  union{
    object {m_car13}//Jante AvD
    object {m_car16}//Jante AvG
    object {m_car18}//Jante ArG
    object {m_car20}//Jante ArD
    texture {T_Chrome_3C}
    translate -50*x
  }
}
#local J0=min_extent(JJJ);
#local J1=max_extent(JJJ);
motion_blur{
  union{
    object {
      JJJ
      translate <-(J0.x+J1.x)/2, -J0.y, -(J0.z+J1.z)/2>
      //#debug concat("\nHaut=", str((J1.y-J0.y), 0, 3),"")
      //#debug concat("\nAvant=", str((J1.z-J0.z)/2, 0, 3),"")
      scale 1
      rotate 180*y*0
      translate T
    }
    #local JagLS=light_source {
      <0, 50, -230>
      Silver*2/MBSamples
      fade_distance 500
      fade_power 1.5
      spotlight
      point_at <0, 20, -500>
      radius 30
      falloff 50
      groups "std,bus"
    }
    object {JagLS translate -80*x + T}
    object {JagLS translate 80*x + T}
    light_group "std"
  }
  translate 20*clock*z
}
#end



/*****************************************************************************\
*
* Vieille BMW srie 3
*
\*****************************************************************************/

#macro Bmw(T)
//#include "BMW.inc"
#include "bmw.pov"
#local JJJ=union{
//#include "bmw.pov"
  object {BMW_1//carrosserie
    pigment {White*.93}
    finish {Shiny}
    //finish {ambient .3}
  }
  object {BMW_2//intrieur
    pigment {Black}
  }
  rotate -90*x
  }
#local J0=min_extent(JJJ);
#local J1=max_extent(JJJ);
motion_blur{
  union{
    object {
      JJJ
      translate <-(J0.x+J1.x)/2, -J0.y, -(J0.z+J1.z)/2>
      //#debug concat("\nHaut=", str((J1.y-J0.y), 0, 3),"")
      //#debug concat("\nAvant=", str((J1.z-J0.z)/2, 0, 3),"")
      scale 100
      rotate 180*y
      translate T+20*y
    }
    #local JagLS=light_source {
      <0, 50, -230>
      Silver*2/MBSamples
      fade_distance 500
      fade_power 1.5
      spotlight
      point_at <0, 20, -500>
      radius 30
      falloff 50
      groups "std,bus"
    }
    object {JagLS rotate 180*y translate -80*x + T}
    object {JagLS rotate 180*y translate 80*x + T}
    #local Pneu=difference{
      superellipsoid { <1, .3> bounded_by{box{-1, 1}} rotate 90*y scale <10, 30, 30>}
      cylinder {-12*x, 12*x, 14/2*2.54}
      pigment {White*.1}
      finish {phong 0.3 phong_size 3}
    }
    #local Jante=union{
      torus {14/2*2.54, 1 rotate 90*z scale <9, 1, 1>}
      superellipsoid { <1, .3> bounded_by{box{-1, 1}} rotate 90*y scale <10, 8, 8>}
      #local i=0;
      #while (i<7)
	cylinder {0, 25*y, 1 scale <5, 1, 3> translate 2*x rotate i*360/7*x}
	#local i = i+1;
      #end
      texture {T_Chrome_3A}
    }
    #local Roue=union{object{Pneu} object{Jante}}
    object {Roue translate <75, 30, 150> + T}
    object {Roue translate <80, 30, -135> + T}
    object {Roue rotate 180*y translate <-75, 30, 150> + T}
    object {Roue rotate 180*y translate <-80, 30, -135> + T}
    #local Feu=union{
      box {<30, 50, -200>, <50, 70, -230>
	pigment {wood color_map {[0 Red*.8][1 Red*.6]}scale 20 translate <40, 60, 0>}
	finish {ambient 1}}
      box {<50, 50, -200>, <65, 70, -230>
	pigment {wood color_map {[0 Red*1][1 Red*.8]}scale 20 translate <57.5, 60, 0>}
	finish {ambient 1}}
      box {<65, 50, -200>, <80, 60, -230> pigment {Orange} finish {ambient .1}}
      box {<65, 60, -200>, <80, 70, -230> pigment {White} finish {ambient .1}}
      no_shadow
    }
    object {Feu translate T}
    object {Feu scale <-1, 1, 1> translate T}
    light_group "std"
  }
  translate -10*clock*z
}
#end


