/******************************************************************************
*
* Superpatch d'aprs Persistence of Vision Raytracer version 3.1
*
* whs.inc
*
* Boutique W. H. Smith -> R.P.Feynman
*
* La vitrine verte est en fait l'entre.
*
******************************************************************************/

#declare WHS_Seed1=seed(1);

#macro WHS_Curve(T, R) // Text, Radius
#local N=strlen(T);
#local AR=array[N]
//substr(str, pos, len)
#local i = 0;
#local Xtot=0;
#local Ymax = 0;
#while (i < N)
  #local AR[i]=text{
    ttf "times.ttf" substr(T, i+1, 1) 
    1, 0
  }
  #local Xtot = Xtot + max_extent(AR[i]).x;
  #local Ymax = max(Ymax, max_extent(AR[i]).y);
  #local i = i+1;
#end
#local R1 = Xtot/2/N/sin(3.1415926/2/N);
#local R2 = R1 + Ymax;
union{
  #local i = 0;
  #local Alpha = 90;
  #while (i<N)
    #local dAlpha = 2*atan2(max_extent(AR[i]).x/2, R1) * 180/3.1415926;
    object {
      AR[i]
      pigment {Gold}
      finish {phong 1.5 phong_size 3 ambient .4}
      normal {gradient x scale 2 translate 1000}
      translate <-max_extent(AR[i]).x/2, R1, 0>
      rotate z*(Alpha - dAlpha/2)
    }
    #local i = i+1;
    #local Alpha = Alpha - dAlpha;
  #end
  scale <R/R2, R/R2, 1>
  bounded_by{box{<-R, 0, -2>, <R, R, 2>}}
}
#end

#macro WHS_Nom2(rot)
intersection{
  object{
    WHS_Curve ("R.P. Feynman", 160)
    scale <1, 1, 30>
    rotate 90*y
    translate <970, 0, 0>
    rotate rot*y
  }
  cylinder {0*y, 200*y, 985}
  //texture {T_Stone6}
  //bounded_by {box {<1000-200, 0, 900>, <1000+200, 200, 985>}}
  translate <-1000, 400, 1000>
  pigment {Gold}
  finish {phong 1.5 phong_size 3 ambient .4}
  light_group "std"
}
#end

#macro WHS_Colonne(a)
union{
  difference{
    box {<-10, 0, -15>, <10, 320, 15>}
    cylinder {-5*y, 400*y, 3 translate <10, 0, -12>}
    cylinder {-5*y, 400*y, 3 translate <10, 0, -4>}
    cylinder {-5*y, 400*y, 3 translate <10, 0, 4>}
    cylinder {-5*y, 400*y, 3 translate <10, 0, 12>}
    texture {T_Stone6 translate 100*rand(WHS_Seed1) scale 10}
  }
  union{
    box {<-10, 570, -15>, <10, 590, 15>}
    cylinder {<10, 430, -10>, <10, 430, 10>, 10}
    box {<-10, 390, -10>, <10, 440, 10>}
    #ifdef(skin)
      object {skin translate 50*y rotate 90*y scale 1 translate <5, 450, 0>}
    #end
    pigment {Cream}
  }
  translate 1000*x
  rotate a*y
  translate <-1000, 0, 1000>
  light_group "std"
}
#end

#macro WHS_Vitrine(C)
difference{
  box {<950, 70, -150>, <990, 200, 150>}
  box {<960, 71, -149>, <1100, 199, 149>}
  pigment {
    bozo turbulence 0.3 color_map{
      [0 C*.8]
      [1 C*1.25]
    }
    translate 100*rand(WHS_Seed1)
    scale 30
  }
}
#end

#macro WHS_Nom1(rot)
intersection{
  text {
    ttf "times.ttf" "R.P.Feynman" 
    10, 0
    scale <60, 60, 30>
    bounded_by {box{<-200, -50, -40>, <200, 150, 40>}}
    rotate 90*y
    translate <900, 250, 160>
    rotate rot*y
  }
  cylinder {230*y, 310*y, 1010}
  translate <-1000, 0, 1000>
  //texture {T_Gold_5C}
  pigment {Gold}
  finish {phong 1.5 phong_size 3 ambient .4}
  normal {gradient z scale 2 translate 1000}
  light_group "std"
}
#end

#declare WHS_Seed1=seed(0);
#macro WHS_Sales(A, B, X, Y)//Angle vitrine, Angle propre, x, y
box{
  0,1
  pigment {
    image_map{
      png "sales1.png" //408x145
      interpolate 2 once
    }
  }
  translate -.5
  scale <408, 145, 1>*0.5
  rotate B*z
  rotate 90*y
  translate <990+rand(WHS_Seed1), Y, X>
  rotate A*y
  translate <-1000, 0, 1000>
  no_shadow
}
#end

#macro WHSmith(SKIN)
#if (SKIN != 0)
  #include "Honey.inc"
#end
intersection{
  box {<500, -100, -500>, <-1000, 2100, 1000>}
  union{
    difference {
      union{
	cylinder {0*y, 600*y, 1000 }
	torus {1000, 10 translate 330*y}
	torus {1000, 10 translate 390*y}
	torus {1000, 10 translate 590*y}
	box {<950, 570, -10>, <1010, 590, 10> rotate (11.25+00.0)*y}
	box {<950, 570, -10>, <1010, 590, 10> rotate (11.25+22.5)*y}
	box {<950, 570, -10>, <1010, 590, 10> rotate (11.25+45.0)*y}
	box {<950, 570, -10>, <1010, 590, 10> rotate (11.25+67.5)*y}
      }
      intersection{
	union{
	  cone {0, 0, 1001*x, 170 translate 400*y rotate (11.25+22.5)*y}
	  cone {0, 0, 1001*x, 170 translate 400*y rotate (11.25+45.0)*y}
	  cone {0, 0, 1001*x, 170 translate 400*y rotate (11.25+67.5)*y}
	  cone {0, 0, 1001*x, 170 translate 400*y rotate (11.25+00.0)*y}
	}
	box {<-1000, 400, -1000>, <1000, 600, 1000>}
      }
      box {<950, 70, -150>, <1100, 200, 150> rotate (11.25+22.5)*y}
      box {<950, 70, -150>, <1100, 200, 150> rotate (11.25+45.0)*y}
      box {<950, 70, -150>, <1100, 200, 150> rotate (11.25+67.5)*y}
      box {<950, 70, -150>, <1100, 200, 150> rotate (11.25+00.0)*y}
      pigment {Cream}
    }
    cylinder {350*y, 600*y, 980 pigment {rgb <.4, .7, 1>}}
    object {WHS_Vitrine(rgb <1, .3, .7>) rotate (11.25+00.0)*y}
    object {WHS_Vitrine(Red) rotate (11.25+22.5)*y}
    object {WHS_Vitrine(Green) rotate (11.25+45.0)*y}
    object {WHS_Vitrine(Cyan) rotate (11.25+67.5)*y}
    cylinder {
      230*y, 310*y, 1005 
      pigment {BakersChoc} 
      finish {phong 0.3 phong_size 3}
    }
    translate <-1000, 0, 1000>
  }
  light_group "std"
}
WHS_Colonne( 1.0)
WHS_Colonne(22.5)
WHS_Colonne(45.0)
WHS_Colonne(67.5)
WHS_Colonne(89.0)
WHS_Nom1(11.25+00.5)
WHS_Nom1(11.25+22.5)
WHS_Nom1(11.25+45.0)
WHS_Nom1(11.25+67.0)
WHS_Nom2(11.25+00.5)
WHS_Nom2(11.25+22.5)
WHS_Nom2(11.25+45.0)
WHS_Nom2(11.25+67.0)
WHS_Sales(11.25+00.5,  15,  20, 140)
WHS_Sales(11.25+00.5,  -5, -15, 120)
WHS_Sales(11.25+22.5, -10, -20, 140)
WHS_Sales(11.25+22.5,   0,  30, 110)
WHS_Sales(11.25+45.0,  10,  30, 150)
WHS_Sales(11.25+45.0, -10, -30, 120)
WHS_Sales(11.25+67.0, -10,  30, 130)
#end
