/******************************************************************************
*
* Superpatch d'aprs Persistence of Vision Raytracer version 3.1
*
* cola.inc
*
* Pub "Hpsi-cola", dans rectangle <0, 1000, 2000> - <0, 1900, 3000>
*
******************************************************************************/

#macro YU_Neon(DY, Y)
cylinder {
  2000*z, 1020*z, DY/3
  pigment {
    gradient y color_map{
      [0 Orange]
      [1 Red]
    }
    scale DY/3
  }
  finish {ambient 1 diffuse 0}
  translate <0, Y, 0>
}
#end


#macro Yukawa()
#local Yu_yellow=color rgb<1, 1, .5>;
union{
  box {<-5, 1000, 1000>, <-1000, 1500, 2000> pigment {Black}}
  text {
    ttf "tt0247m_.ttf" "YUKAWA" 
    .1, 0.0*x
    scale <150, 180, 10> 
    rotate 90*y
    translate <10, 1200, 1750>
    bounded_by{box{<20, 1000, 1000><0, 1500, 2000>}}
    pigment {Yu_yellow}
    finish {ambient 1 diffuse 0}
  } 
    box {
    0, 1
    pigment {
      image_map{
	png "yukawa.png" //545x545
	interpolate 2 once
      }
    }
    finish {ambient 1 diffuse 0}
    scale <150, 150, 10>
    rotate 90*y translate <0, 1200, 1950>
    no_shadow
  }
  text {
    ttf "tt0246m_.ttf" "Quantic Synthetisers" 
    .1, 0.0*x
    scale <80, 80, 10> 
    rotate 90*y
    translate <10, 1120, 1900>
    bounded_by{box{<20, 1000, 1000><0, 1500, 2000>}}
    pigment {Yu_yellow}
    finish {ambient 1 diffuse 0}
  } 
  text {
    ttf "tt0246m_.ttf" "Tunnel Effect ATVs" 
    .1, 0.0*x
    scale <80, 80, 10> 
    rotate 90*y
    translate <10, 1040, 1850>
    bounded_by{box{<20, 1000, 1000><0, 1500, 2000>}}
    pigment {Yu_yellow}
    finish {ambient 1 diffuse 0}
  } 
  #local Y=1005;
  #local DY=20;
  #while (Y<1400)
    YU_Neon(DY, Y)
    #local Y = Y+DY;
  #end
  light_group "fluo"
}
#end

