
// Persistence of Vision Ray Tracer Scene Description File
// File: js_ToyCity.pov
// Vers: 3.1
// Desc: a Tale of two cities
// Date: 02/04/2000
// Auth: Johann Snyman - mwsny001@mweb.co.za
// Web : http://johannhome.cjb.net
// a toy city in a real city, or is it a toy city in a toy city in a...

#include "stones.inc"
#include "povlab.inc"
#include "metals.inc"

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10

}


background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <    -15.107,     -52.924,      28.853>
  direction <        0.0,         0.0,      1.2730> 
  sky       <    0.00000,     0.00000,     1.00000> 
  up        <        0.0,         0.0,         1.0> // Z is op
  right     <    1.33333,         0.0,         0.0> 
  look_at   <      8.466,       1.966,       9.001>
}


 


light_source {   // inside light
  <13.209, -32.178, 35.581>
  color rgb <0.5, 0.5, 0.5>
}





//light_source {   // OutsideLight
//  <3.262, 71.582, 30.787>
//  color rgb <0.800, 0.8000, .8000>
//}


light_source    //outside area light
{
  0*x 
  color rgb 0.7 
  
  area_light
  <8, 0, 0> <0, 0, 8> 
  4, 4                
  adaptive 0          
  jitter              
  translate <3.262, 71.582, 30.787>  
}



light_source {   // Light001   dowwe binnelig
  <-23.506, -44.669, 10.505>
  color rgb <0.267, 0.267, 0.267>
}




#include "js_toycity.inc"
#include "colors.inc"
#include "js_toycity_2cities.inc"
#include "js_toycity_objects.inc"
#include "flowers1.inc"
#include "ToyCity1_brcase.inc"

union { // Book
  box { // BookCover
    <-1, -1, -1>, <1, 1, 1>
    pigment {
image_map
{
  gif "bookcover1.gif" 
  map_type 0 
  interpolate 2 
   once
} // image_map
 scale 2
 translate  <-1,-1,0>
 
 }
    
    scale <2.001099, 2.728841, 0.051862>
    rotate <0.0, 0.0, -198.60214>
    translate  <18.485967, -2.360623, 9.88174>
  //18.60214
  }
  box { // BookPages
    <-1, -1, -1>, <1, 1, 1>
   texture {
    Page_Texture
  }
    scale <2.001099, 2.728841, 0.255035>
    rotate <0.0, 0.0, -198.60214>
    translate  <18.485967, -2.360623, 9.557248>
  }

  scale 1.257576
  translate  <-6.463971, 0.567297, -2.474108>
}



box { // Pelmit
  <-1, -1, -1>, <1, 1, 1>
  pigment {
    P_Copper2
  }
  scale <69.795067, 0.511311, 3.735958>
  translate  <-2.529115, 41.047994, 32.868917>
}







box { // Pavement
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Pearl
  }
  scale <133.211685, 106.870667, 1.0>
  translate  <-0.0, 162.459516, 0.551138>
}




difference { // Wall'n'Window
  box { // Wall1
    <-1, -1, -1>, <1, 1, 1>
    scale <-73.639908, -1.729087, -19.200001>
    rotate <-180.0, 0.0, -180.0>
    translate  <-1.129325, 49.414763, 19.0>
texture {Black_Vein_Granit
}
}

 
  box { // Venster
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Glass_p
    }
    scale <-36.384052, -2.582394, -13.935091>
    rotate <-180.0, 0.0, -180.0>
    translate  <8.098084, 49.051243, 15.860153>
  }
}


box { // SmallCarpet
  <-1, -1, -1>, <1, 1, 1>
pigment {

 image_map
  {
   gif "carpet1.gif" // the file to read (iff/gif/tga/png/sys)
   map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
   interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance

   
}  // image_map
 scale 0.5
 rotate z*90
 }


  scale <26.035065, -14.679022, -0.838967>
  translate  <9.197371, -0.031973, -0.389217>
}


box { // Wall2
  <-1, -1, -1>, <1, 1, 1>
  scale <-2.505449, 65.881737, 19.0>
  translate  <70.416227, -16.402182, 18.7>
texture {Black_Vein_Granit
        scale 10
        }
}

#include "textures.inc"
box { // Floor
  <-1, -1, -1>, <1, 1, 1>
  scale <75.99263, 75.99263, 0.253309>
  translate  <-0.1, -21.8, -0.1>
 
    texture {
    brick texture{Pierre9}, texture{Dark_Wood}
   
    
    
    //color Red, color Gray
    brick_size <7,4,4>   // size of brick
    mortar     0.1       // width of mortar
  scale 2.1
  }
 
 
}   

union { // StickYucca
  object { plantleaves
        //pigment {LimeGreen}
         
         texture {EWGreens}
         }
  object { planttrunk
        
       texture { 
        pigment {MediumWood}
          normal { bumps 0.6
                turbulence 0.6
                scale 0.05
                }
        
         }}
  object { plantsoil 
        pigment {DarkBrown}
        }
  object { plantpot
        pigment {LightBlue}
         }
  scale 5.152027
  translate  <45.16002, 31.546632, 3.872402>

}

sphere { // teddyeye1
  <0,0,0>,1
  scale 0.201114
  translate  <44.579566, 2.238213, 6.358601>
pigment {Black}
}


sphere { // teddyeye2
  <0,0,0>,1
  scale 0.201114
  translate  <44.527784, 3.799001, 6.371282>
pigment {Black}
}


sphere { // teddynose
  <0,0,0>,1
  scale 0.201114
  translate  <43.35999, 2.86269, 6.392302>
pigment {Black}
}



#declare stems_Ref = object {
  X1
pigment {ForestGreen}
}
#declare X5_Ref = object {
  X5
  pigment {
    MediumBlue
  }
}
#declare X2_Ref = object {
  X2
  pigment {
    Med_Purple
  }
}
#declare X3_Ref = object {
  X3
  pigment {
    Light_Purple
  }
}
#declare X4_Ref = object {
  X4
  pigment {
    OrangeRed
  }
}
#declare X6_Ref = object {
  X6
  pigment {
    SlateBlue
  }
}
#declare X7_Ref = object {
  X7
  pigment {
    SummerSky
  }
}
union { // flowers1_group
  object { stems_Ref }
  object { X5_Ref }
  object { X2_Ref }
  object { X3_Ref }
  object { X4_Ref }
  object { X6_Ref }
  object { X7_Ref }
  scale 0.0015
  rotate 48.165546*x
  translate  <4.691656, 0.0, 8.831353>
}

union { // flowers1_group
  object { stems_Ref }
  object { X5_Ref }
  object { X2_Ref }
  object { X3_Ref }
  object { X4_Ref }
  object { X6_Ref }
  object { X7_Ref }
  scale 0.0015
  rotate 78.165546*x
  translate  <4.691656, 0.0, 8.831353>
}






