//*****************************************************************************************************************************
// scene environment
//*****************************************************************************************************************************
#version unofficial MegaPov 0.4;
#local quality = 1;
#declare cam_l = <1,100,-1000>;     
#declare cam_lat =  <0,0,0>;

#macro blobradius(bthreshold,bstrength,bdistance)
	(bdistance/sqrt(1-sqrt(bthreshold/bstrength)))
#end
            
global_settings {
	max_trace_level 30
	number_of_waves 20
	post_process {
//		focal_blur{vlength(cam_l-cam_lat),vlength(cam_l-cam_lat), 8}
//		soft_glow{1,8}
	}
	#if (quality >=1)
		#if(quality >= 2)
	  		// High Quality - slow rendering
		  	ini_option "+QR"
		  	ini_option "Preview_Start_Size=8"
		  	ini_option "Preview_End_Size=4"
		  
		  	radiosity{
			    count 80             // CHANGE range from 20 to 150
			    nearest_count 6      // CHANGE range from 3 to 10
			    error_bound 1        // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
			                         //   1 : preview_end_size = 4
			                         //   3 : preview_end_size = 8
			                         //   use preview_start_size = 16 (or 8 for high quality)
			                         // you can go lower than 1, but then you probably will want to set
			                         // preview_end_size to 2, which is really slow
			    recursion_limit 4    // CHANGE
			    
			    low_error_factor .5  // leave this
			    gray_threshold 0.0   // leave this
			    minimum_reuse 0.015  // leave this
			    brightness 1         // leave this
			    
			    max_sample 1         // CHANGE - this should be the same as the brightest object
			    adc_bailout 0.01/1   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
			    normal on
		  	}
		#else
		  	// Medium Quality - works for most scenes
		  	ini_option "+QR"
		  	ini_option "Preview_Start_Size=16"
		  	ini_option "Preview_End_Size=8"
		  
		  	radiosity{
			    count 40             // CHANGE range from 20 to 150
			    nearest_count 3      // CHANGE range from 3 to 10
			    error_bound 3        // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
			                         //   1 : preview_end_size = 4
			                         //   3 : preview_end_size = 8
			                         //   use preview_start_size = 16
			                         // you can go lower than 1, but then you probably will want to set
			                         // preview_end_size to 2, which is really slow
			    recursion_limit 3    // CHANGE
			    
			    low_error_factor .5  // leave this
			    gray_threshold 0.0   // leave this
			    minimum_reuse 0.015  // leave this
			    brightness 1         // leave this
			    
			    max_sample 1         // CHANGE - this should be the same as the brightest object
			    adc_bailout 0.01/1   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
			    normal on
			}
		#end
	#end
}

#declare T_BMetal = texture {
	pigment { rgb 0 }
	normal { facets 0.5 size 0.2 }
	finish { brilliance 6 specular 1 ambient 0 diffuse 0 }
}
texture {
	pigment {
		bozo
		scale 0.5
		turbulence 0.4
		colour_map {
			[0.7 rgbt <0,0,0,1>]
			[0.95 rgbt <0.2,0,0,0>]
		}
	}
	finish {
		ambient 0
		diffuse 0.3
	}
}

#declare T_Metal = texture {
	pigment {
		granite
		scale 0.1
		colour_map {
			[0 rgb <0.5,0.9,1>]
			[1 rgb 0.9]
		}
	}
	normal { facets 0.5 size 0.2 }
	finish {
		ambient 0
		diffuse 0.9
		reflection 0.1
		specular 1
		brilliance 6
		metallic
	}
}
texture {
	pigment {
		bozo
		scale 0.5
		turbulence 0.4
		colour_map {
			[0.7 rgbt <0,0,0,1>]
			[0.95 rgbt <0.2,0,0,0>]
		}
	}
	finish {
		ambient 0
		diffuse 0.3
	}
}

#declare T_FlatSnow = texture {
	pigment {
		rgb 1
	}
	finish {
		ambient 0
		diffuse 1
	}
}

#declare T_Snow1 = texture {
	pigment {
		rgb 1
	}
	normal {
		crackle -0.5*750
		turbulence 0.2
		scale 1/750
	}
	finish {
		ambient 0
		diffuse 1
	}
}

#declare T_Snow2 = texture {
	pigment {
		rgb 1
	}
	normal {
		bozo -0.5
	}
	finish {
		ambient 0
		diffuse 1
	}
}

#declare T_Snow = texture {
	slope y
	texture_map {
		[0.3 T_FlatSnow ]
		[0.4 T_Snow1 ]
		[0.6 T_Snow1 ]
		[0.7 T_FlatSnow ]
	}
}

#declare T_Rock = texture {
	pigment {
		granite
		scale 3
		colour_map {
			[0 rgb 0.4]
			[1 rgb 0.2]
		}
	}
	normal {
		granite 0.2
	}
	finish {
		diffuse 0.8
		ambient 0
	}
}

#declare T_Landscape = texture {
	slope y*3,y,<0.5,1>,<0,1>
	texture_map {
		[1/3 T_Rock]
		[1/3 T_Snow]
	}
}

#declare T_Granite = texture {
	pigment {
		granite
		colour_map {
			[0 rgb 0.7]
			[1 rgb 0.8]
		}
	}
	normal { granite 0.1 }
	finish { ambient 0 diffuse 0.8 }
}

#macro MT_Snow(dens)
	bozo
	scale 10
	texture_map {
		[dens T_Snow2 scale 10 ]
		[dens T_Granite]
	}
	warp { reset_children }
#end

#declare T_Window = texture {
	pigment { 
		crackle
		metric 1
		scale <5,3,5>
		colour_map {
			[0.2 rgb 0]
			[0.2 rgb <1,1,0>]
			[1 rgb <1,1,1>]
		}
	}
	finish {
		reflection 0.1
		ambient 0.9
		diffuse 0
		specular 1
	}
}

#declare T_Windows = texture {
	gradient y
	translate y*-1000
	scale 3
	texture_map {
		[0 T_Granite]
		[0.4 T_Granite]
		[0.4 T_Window]
		[0.7 T_Window]
		[0.7 T_Granite]
		[1 T_Granite]
	}
	warp{reset_children}
}

#declare T_Structure = texture {
	slope y
	texture_map {
		[ 0.5 T_Granite ]
		[ 0.55 MT_Snow(1/6)]
		[ 0.6 MT_Snow(1/3)]
		[ 0.65 MT_Snow(1/2)]
		[ 0.7 MT_Snow(2/3)]
		[ 0.75 MT_Snow(5/6)]
		[ 0.8 MT_Snow(1)]
	}
}

#declare T_Windowed_Structure = texture {
	slope y
	texture_map {
		[ 0.499 T_Granite]
		[ 0.5 T_Windows]
		[ 0.501 T_Granite ]
		[ 0.53 MT_Snow(0.1)]
		[ 0.545 MT_Snow(0.15)]
		[ 0.56 MT_Snow(0.2)]
		[ 0.575 MT_Snow(0.25)]
		[ 0.59 MT_Snow(0.3)]
		[ 0.605 MT_Snow(0.35)]
		[ 0.62 MT_Snow(0.4)]
		[ 0.635 MT_Snow(0.45)]
		[ 0.65 MT_Snow(0.5)]
		[ 0.665 MT_Snow(0.55)]
		[ 0.68 MT_Snow(0.6)]
		[ 0.695 MT_Snow(0.65)]
		[ 0.71 MT_Snow(0.7)]
		[ 0.725 MT_Snow(0.75)]
		[ 0.74 MT_Snow(0.8)]
		[ 0.755 MT_Snow(0.85)]
		[ 0.77 MT_Snow(0.9)]
		[ 0.785 MT_Snow(0.95)]
		[ 0.8 MT_Snow(1.0)]
	}
}

#declare T_Black = texture {
	slope y
	texture_map {
		[ 0.5 pigment { rgb 0 } finish { brilliance 6 specular 1 ambient 0 diffuse 0 } ]
		[ 0.55 MT_Snow(1/6)]
		[ 0.6 MT_Snow(1/3)]
		[ 0.65 MT_Snow(1/2)]
		[ 0.7 MT_Snow(2/3)]
		[ 0.75 MT_Snow(5/6)]
		[ 0.8 MT_Snow(1)]
	}
}

#declare _landscape = function { "ridgedmf",<1,2,10,1.1,2> }

#if (quality>=0.5)
	#declare landscape = isosurface {
		function {
			_landscape(x,0,z)-y
		}
		max_gradient 35
		accuracy 0.001
		sign -1
		all_intersections
		contained_by { box { <-1000,-3,-1000> <1000,3,1000> } }
		scale <4,1,4>
		scale 1/3
		texture { T_Landscape }
		scale 3
		scale 250
	}
#else
	#declare landscape = box { <-1000,-3,-1000> <1000,0,1000>
		scale <4,1,4>
		scale 1/3
		texture { T_Landscape }
		scale 3
		scale 250
	}
#end

object { landscape }

#local cam_l = <0,2,0>+trace(landscape,cam_l+y*1000000,y*-1);
#if (quality<0.5)
	#local cam_l = cam_l + 18*y;
#end
#if (quality<=0.5)
	light_source {
		cam_l
		rgb <0,0,0.5>
	}
#end
#local cam_lat = <0,0,0>+trace(landscape,cam_lat+y*1000000,y*-1);

light_source {
	<1,1,-0.1>*1000000
	rgb #if (quality >=1) <1,1,0.5> #else <1,1,1> #end
}

#local CamZ = 1;

#local CamD = vnormalize(cam_lat-cam_l);
#local CamR = vnormalize(vcross(y,CamD));
#local CamU = vnormalize(vcross(CamD,CamR));

camera {
  location cam_l
  up CamU
  right CamR*4/3
  direction CamD*CamZ
}        

height_field {
	gif "jw_cits.gif"
	smooth
	water_level 0.1
	translate -0.5
	rotate x*-90
	scale <4,1,0.05>
	scale 0.11
	rotate x*20
	rotate y*-10
	translate <-0.4,-0.4,CamZ>
  	matrix < CamR.x,CamR.y,CamR.z,
		CamU.x,CamU.y,CamU.z,
    	CamD.x,CamD.y,CamD.z,
		cam_l.x,cam_l.y,cam_l.z >
	texture {
		pigment { rgbf <1,2/3,1/3,5/6> }
		finish { ambient 0.2 specular 0.8 metallic diffuse 0 }
	}
}

sky_sphere {
	pigment {
		planar
		colour_map {
			[0 rgb <0,0,0.5>]
			[0.8 rgb <0,0,1>]
			[1 rgb <0,1,1>]
		}
	}
}

#local pold = trace(landscape,<-20,1000,-200>,y*-1).y;
#local pph = trace(landscape,<-20,1000,-100>,y*-1).y;

#local pylonc=-220;
#while (pylonc>-1000)
	#local p1 = trace(landscape,<1,1000,1>+z*pylonc-20*x,y*-1).y;
	#local p2 = trace(landscape,<1,1000,-1>+z*pylonc-20*x,y*-1).y;
	#local p3 = trace(landscape,<-1,1000,1>+z*pylonc-20*x,y*-1).y;
	#local p4 = trace(landscape,<-1,1000,-1>+z*pylonc-20*x,y*-1).y;
	#local ph = max(max(p1,p2),max(p3,p4));
	union{
		triangle { <1,0,1> <1,0,-1> <0,10,0> }
		triangle { <1,0,-1> <-1,0,-1> <0,10,0> }
		triangle { <-1,0,-1> <-1,0,1> <0,10,0> }
		triangle { <-1,0,1> <1,0,1> <0,10,0> }
		box { -1,1 translate y*-1 scale <1,10,1> }
		translate <-20,ph,pylonc>
		texture { T_Structure }
	}
	sphere { 0 1
		scale 1/2
		translate <-20,ph+10,pylonc>
		texture {
			pigment{rgb <1,0,0>} finish{ambient 0.9 diffuse 0.1 specular 1}
		}
	}
	sphere_sweep {
		catmull_rom_spline_sphere_sweep
		5,
		<-20,pold+1,pylonc+20>,0.1
		<-20,pold,pylonc+20>,0.1
		<-20,(ph+pold)/2-5,pylonc+10>,0.1
		<-20,ph,pylonc>,0.1
		<-20,ph+1,pylonc>,0.1
		translate y*7.5
		texture { T_Black }
	}
	#local pold = ph;
	#local pylonc=pylonc - 20;
#end

blob {
	threshold 0.5
	cylinder { <-20,0,-100> <-20,(pph+20)*10,-100> 200 1 scale <1,1/10,1> }
	sphere { <-20,pph+20,-100> 100 1 }
	#local sp = 0;
	#while (sp < 360)
		cylinder { <0,0,-100> <0,pph+120,-100> 10 1 rotate y*sp translate <-20,0,-100> }
		#local sp = sp + 30;
	#end
	sphere { 0 1 1 scale <200,100,200> translate <-20,100,-100> texture { T_Structure } }
	texture { T_Windowed_Structure }
}	

#declare quadjet=union {
	blob {
		#local thold = 0.9;
		threshold thold
		cylinder { <0,0,-10> <0,0,10> blobradius(thold,1,2.5) 1 }
		cylinder { <0,2,-5> <0,2,10> blobradius(thold,1,1) 1 }
		cylinder { <0,-2.5,-15> <0,0,15> blobradius(thold,1,1) 1 pigment {rgb <0,1,0>} finish { ambient 0 diffuse 0.8 brilliance 2 specular 1 } }
		cylinder { <-10,0,-10> <10,0,-10> blobradius(thold,1,0.5) 1 }
		cylinder { <-10,0,10> <10,0,10> blobradius(thold,1,0.5) 1 }
		cylinder { <5,-4.75,10> <5,-4.75,-10> blobradius(thold,1,0.25) 1 pigment {rgb <1,0,0>} finish { ambient 0 diffuse 0.8 brilliance 2 specular 1 } }
		cylinder { <-5,-4.75,10> <-5,-4.75,-10> blobradius(thold,1,0.25) 1 pigment {rgb <1,0,0>} finish { ambient 0 diffuse 0.8 brilliance 2 specular 1 } }
		cylinder { <-5,-4.5,5> <5,-4.5,5> blobradius(thold,1,0.1) 1 }
		cylinder { <-5,-4.5,-5> <5,-4.5,-5> blobradius(thold,1,0.1) 1 }
		cylinder { <5,-4.5,5> <2.5,0,5> blobradius(thold,1,0.1) 1 }
		cylinder { <-5,-4.5,5> <-2.5,0,5> blobradius(thold,1,0.1) 1 }
		cylinder { <5,-4.5,-5> <2.5,0,-5> blobradius(thold,1,0.1) 1 }
		cylinder { <-5,-4.5,-5> <-2.5,0,-5> blobradius(thold,1,0.1) 1 }
	}
	union {
		sphere { <-1,0,-15> 1 }
		sphere { <1,0,-15> 1 }
		texture {
			pigment { rgb 0 }
			finish { ambient 0 diffuse 0 specular 1 phong 2 phong_size 20 reflection <0.25,0.5,1> }
		}
	}
	#local jet = union {
		cone { <0,2.6,0> 1 <0,2,0> 1.5 open texture { T_BMetal }}
		cone { <0,2.6,0> 1 <0,1.5,0> 0 open texture { T_Metal }}
		cone { <0,2,0> 1.5 <0,0,0> 0.5 texture { T_Metal }}
		cone { <0,0,0> 0.5 <0,-1.5,0> 1.5 texture { T_Metal }}
		cone { <0,-1.5,0> 1.5 <0,-2.6,0> 1 texture { T_BMetal }}
		#local cc = 0;
		#while (cc < 360 )
			cylinder { <0,-2,1> <0,2,1> 0.4 rotate y*cc texture { T_BMetal } }
			sphere { <0,-2,1> 0.4 rotate y*cc texture { T_BMetal } }
			#local cc = cc+30;
		#end
		cylinder { <0,0,0> <0,-5,0> 1
			pigment { rgbf 1 }
			hollow
			interior {
				media {
					absorption 0.8
					emission <1,0.6,0>
					intervals 1
					samples 5,5
					method 3
					confidence 1-1/10
					variance 1/64
					density {
						planar
						colour_map{
							[0 rgb 0]
							[1 rgb 1]
						}
						scale 5
					}
				}
			}
			translate y*-2.6
		}
	}
	object { jet translate <10,0,10> }
	object { jet translate <-10,0,10> }
	object { jet translate <10,0,-10> }
	object { jet translate <-10,0,-10> }
	texture {
		pigment { rgb <1,1,0> }
		finish { ambient 0 diffuse 0.8 brilliance 2 specular 1 }
	}
	texture {
		pigment {
			slope y
			colour_map {
				[0.45 rgbt <0,0,0,1>]
				[0.49 rgbt <0,0,0,0>]
				[0.51 rgbt <0,0,0,0>]
				[0.55 rgbt <0,0,0,1>]
			}
		}
		finish {
			ambient 0
			diffuse 0
			specular 1
		}
	}
	texture {
		pigment {
			granite
			scale <1,1,10>
			colour_map {
				[0 rgbt <0,0,0,0.7>]
				[1 rgbt <0,0,0,0.3>]
			}
		}
		finish {
			ambient 0
			diffuse 0
		}
	}
}

object { quadjet
	rotate y*30
	translate <20,trace(landscape,<20,10000,-900>,-y).y+20,-900>
}

#local ph = trace(landscape,<200,10000,-400>,-y).y+20;

object { quadjet
	rotate y*-80
	translate <200,ph+10,-400>
}

#macro simple_rbox(bsize,crad,pos)
	#local ibox = bsize - crad;
	union {
		#if (crad>=bsize)
			#local crad = bsize;
		#end
		#if (crad>0)
			sphere { <ibox,ibox,ibox> crad }
			sphere { <ibox,ibox,-ibox> crad }
			sphere { <ibox,-ibox,ibox> crad }
			sphere { <ibox,-ibox,-ibox> crad }
			sphere { <-ibox,ibox,ibox> crad }
			sphere { <-ibox,ibox,-ibox> crad }
			sphere { <-ibox,-ibox,ibox> crad }
			sphere { <-ibox,-ibox,-ibox> crad }
			#if (ibox != 0)
				cylinder { <ibox,ibox,-ibox> <-ibox,ibox,-ibox> crad }
				cylinder { <ibox,ibox,-ibox> <ibox,-ibox,-ibox> crad }
				cylinder { <-ibox,-ibox,-ibox> <-ibox,ibox,-ibox> crad }
				cylinder { <-ibox,-ibox,-ibox> <ibox,-ibox,-ibox> crad }
				cylinder { <ibox,ibox,ibox> <-ibox,ibox,ibox> crad }
				cylinder { <ibox,ibox,ibox> <ibox,-ibox,ibox> crad }
				cylinder { <-ibox,-ibox,ibox> <-ibox,ibox,ibox> crad }
				cylinder { <-ibox,-ibox,ibox> <ibox,-ibox,ibox> crad }
				cylinder { <ibox,ibox,ibox> <ibox,ibox,-ibox> crad }
				cylinder { <-ibox,ibox,ibox> <-ibox,ibox,-ibox> crad }
				cylinder { <ibox,-ibox,ibox> <ibox,-ibox,-ibox> crad }
				cylinder { <-ibox,-ibox,ibox> <-ibox,-ibox,-ibox> crad }
				box { <-ibox,-ibox,-bsize> <ibox,ibox,bsize> }
				box { <-ibox,-bsize,-ibox> <ibox,bsize,ibox> }
				box { <-bsize,-ibox,-ibox> <bsize,ibox,ibox> }
			#end
		#else
			box { -bsize,bsize }
		#end
		translate pos
	}
#end

union {
	intersection {
		plane { y, -5
			texture {
				pigment {
					onion
					triangle_wave
					scale 10
					pigment_map {
						[0 radial frequency 10 triangle_wave colour_map { [0 rgb <1,1,0>] [1 rgb <1,0,0>] } ]
						[1 radial frequency 10 triangle_wave colour_map { [0 rgb <1,0,0>] [1 rgb <1,1,0>] } ]
					}
				}
				normal { crackle 1 }
				finish { ambient 0 diffuse 0 brilliance 5 specular 1 metallic roughness 1}
			}
		}
		blob {
			#local thold = 0.8;
			threshold thold
			sphere { 0 blobradius(thold,1,20) 1 }
			cylinder { <20,0,20> <20,-20,20> blobradius(thold,1,1) 1 }
			cylinder { <-20,0,20> <-20,-20,20> blobradius(thold,1,1) 1 }
			cylinder { <20,0,-20> <20,-20,-20> blobradius(thold,1,1) 1 }
			cylinder { <-20,0,-20> <-20,-20,-20> blobradius(thold,1,1) 1 }
			cylinder { 0 <-100,0,0> blobradius(thold,1,15) 1 }
		}
	}
	intersection {
		cylinder { <-80,0,0> <-110,0,0> 15 }
		cylinder { <-79,0,0> <-111,0,0> 14 inverse texture { T_Black } }
	}
	simple_rbox(40,5,<-140,0,0>)
	simple_rbox(20,5,<-140,-10,-55>)
	simple_rbox(60,5,<-120,-70,-40>)
	box { -1,1 scale <100,5,5> translate <-230,30,0> }
	cylinder { <-330,35,0> <-130,35,0> 5 }
	cylinder { <-330,25,0> <-130,25,0> 5 }
	translate <200,ph,-400>
	texture { T_Windowed_Structure }
}

#declare buildings = array[5][5]

#local xc = 0;
#while (xc<5)
	#local zc = 0;
	#while (zc < 5)
		#declare buildings[xc][zc] = min(min(trace(landscape,<-100*xc-160,10000,-100*zc-340>,-y).y,trace(landscape,<-100*xc-160,10000,-100*zc-260>,-y).y),min(trace(landscape,<-100*xc-80,10000,-100*zc-340>,-y).y,trace(landscape,<-100*xc-80,10000,-100*zc-260>,-y).y));
		#local zc = zc +1;
	#end
	#local xc = xc + 1;
#end

#local jwr1=seed(42*42*42); //tripleanswer
union {
	#local xc = 0;
	#while (xc<5)
		#local zc = 0;
		#while (zc < 5)
			simple_rbox(40,5,<-100*xc-120,buildings[xc][zc]+30,-100*zc-300>)
			#if (rand(jwr1)>1/3)
				simple_rbox(30,5,<-100*xc-120,buildings[xc][zc]+70,-100*zc-300>)
				#if (rand(jwr1)>1/3)
					simple_rbox(20,5,<-100*xc-120,buildings[xc][zc]+100,-100*zc-300>)
				#end
			#end
			#if (xc = 0)
				union {
					cylinder { <0,0,0> <0,buildings[xc][zc]+60,0> 30 }
					sphere { <0,buildings[xc][zc]+60,0> 30 }
					translate <-100*xc-80,0,-100*zc-300>
				}
			#end
			#local zc = zc + 1;
		#end
		#local xc = xc + 1;
	#end
	texture { T_Windowed_Structure }
}


#macro stars(maxstars)
	#local sp = seed(42);
	#local scol = seed(42);
	#local sc = 0;
	#while (sc < maxstars)
		#local scolpos=(rand(scol)*pi/4) - (pi/8);
		#local scolour=<cos(scolpos-(pi/8)),cos(scolpos),cos(scolpos+(pi/8))>;
		sphere {
			0 0.1
			pigment {rgb scolour }
			finish {
				ambient 1
				diffuse 0
			}
			no_shadow
			scale 800
			translate (100000+100000*rand(sp))*y
			rotate x*(90*rand(sp))
			rotate y*(360*rand(sp))
		}
		#local sc = sc +1;
	#end
#end

stars(1000)

		