#version unofficial Megapov 0.4;
//=============================
#local Render =0; // for Work
//===============================================
#if(Render)
#include "colors.inc"	   // Standard Color definitions
#include "textures.inc"	   // Standard Texture definitions
#include "mega_metals.inc" // MegaPOV Metals definitions 
#include "hasard.inc"      // Hasard de R.Gelaude     
#declare Trans =1;     // transparence
#declare CamJm =1;     // Camera Tournante
#declare Light =1;     // Lumieres un peu partout
#declare ftre  =0;     // fenetres
#declare Text  =0;     // texture complexe
#declare disp  =0;     // dispertion de la lumiere dans les transparences 
//===========================================
#include "etalon.inc"   //  ETALON (m) on  fait glisser l'axe des X  
//object {Etalon (0) translate <10,0.0,5> }                     
//=========================================== 
#end 
//===== End Works

//===Declaration Mesure du Cafe

#declare Cfx=4;
#declare Cfz=15;
#declare Cfh=3.5;
//==========AFICHE_Paint_POV===========

#declare T_Affiche=texture {  pigment { image_map {
                                                png "Paint.png"
                                                once interpolate 4  }
                         } 
                         finish { ambient .5 diffuse .7 phong 1 }
                         scale <306/440,1,1>    
}
//========Tags===========
#declare T_Tag_Mr= texture {  pigment { image_map {
                                                png "tag_mr.png"
                                                once interpolate 4  transmit 0,1}
                         } 
                         finish { ambient .3 diffuse .7 phong 1}
}
//----------
#declare T_Tag_Pov= texture {  pigment { image_map {
                                                png "tag_pov.png"
                                                once interpolate 4 transmit 3,1 }
                         } 
                         finish { ambient .3 diffuse .7 phong 1}
}
//------------
#declare T_Tag=texture { T_Tag_Mr  scale <374/242,1,1>   }
               texture { T_Tag_Pov scale <364/206,1,1>  translate <-.4,-.1,0> } 

//========ENSEIGNE========

#declare M_Ensg1=material { //texture enseigne
                  texture {              
                        pigment { color rgb <0.3,0.3,10>}
                        finish { ambient 1 diffuse 1.0 phong 1 reflection 0}
                  }
                 
}
#declare M_Ensg_lght=material { //texture light_enseigne
                  texture {              
                        pigment { color rgbf <0.0,0.0,2,1>}
                        finish { ambient 0 diffuse 0.1 }
                  }
                 
}

#declare T_Bare=material {Mega_M_Brass_1A}
//--
#declare Font_Pov="comic.ttf"
#declare Enseigne_POV=union {
#declare Eseg=0.3;
                cylinder {<-.8,0.2,2*cm><5*cm,0.2,2*cm>2*cm material {T_Bare}}
                cylinder {<-.8,0.7,2*cm><5*cm,0.7,2*cm>2*cm material {T_Bare}}
                text { ttf Font_Pov 
                        "P" Eseg,0 
                        scale <1.5,1.0,1>
                        rotate z*15
                }
                text { ttf Font_Pov 
                        "o" Eseg,0
                        scale <1.2,0.8,1>
                        translate <10*cm,0.1,0>
                }
                text { ttf Font_Pov
                        "v" Eseg,0
                        scale <1.2,1.1,1>
                        rotate z*-45
                        translate <31*cm,0.25,0>
                }
                
                material { M_Ensg1 }
}
#declare Enseigne_POV_light= light_source { 0*x rgb 2 looks_like {Enseigne_POV material{M_Ensg_lght} scale 1.01 } }
#declare Enseigne_POV      = union {  object {Enseigne_POV} object{Enseigne_POV_light}}

//=========CAFE==================================

#declare M_Vitre=material {
                           texture {  pigment { rgb <1,1,0>}
                                     pigment {  color rgbt <1.0,1.0,1.0,0.85> }
                                     finish {ambient 0.0 diffuse 0.3 }   
                           }                                             
                           interior { ior 1.5   
                            #if(disp)  dispersion 1.05     disp_nelems 15    #end                           
                               }
}
#declare M_Sous_Vitre=material { 
                        texture {    
                                pigment {
                                        marble 
                                        color_map 
                                                { [0.0 rgb <.0,.0,.0>]
                                                  [0.1 rgb <0.8,0.8,0.8>]
                                                  [1.0 rgb <.0,.0,.0>] 
                                                }
                                  turbulence .9
                                  octaves 5
                                  omega .4
                                  lambda 4             
                                }
                                finish {ambient 0.32 diffuse .6 reflection 0.3 brilliance 7}
                             scale .5 }
                             rotate x*90
}
#declare M_Cafe_Plc = material {texture {pigment { checker  rgb 1 , rgb 0 }}} //plancher
#declare T_Sale     =texture {
                                pigment {
                                leopard 
                                color_map {
                                [0.0 rgbf <0.3,0.3,0.3,1.0>]
                                [0.5 rgbf <0.0,0.0,0.0,0.4>]
                                [1.0 rgbf <0.3,0.3,0.3,0.4>]
                                }
                                turbulence .6 omega 1 lambda 5.0 octaves 5 phase 2
                        }
                        finish {ambient 0.3 diffuse .6  }
                          scale <.2,1.2,1.> //scale <.15,1.2,1.5>
}  
#declare T_Crasse = texture {
        pigment {
                wrinkles
                color_map {
                        [0.0 Clear]
                        [1.0 DarkBrown*.5 filter 0.5]
                }
        }
}


#declare T_Enduit  =texture {    
                                pigment  {rgb <.9,.8,.6> } // { rgb <0.5,0.6,.8> } //
                                normal {bump_map {png "enduit.png" bump_size 20 }scale 2 }
                                normal {granite 0.3} 
                                finish {ambient 0.3 diffuse .6 reflection 0.01 }
                                scale .5 rotate y*-90 
}

#declare M_Cafe_Mur = material {texture {pigment { color rgb <0.824,0.851,0.698> }} 
                        #if (Text)
                        texture {T_Crasse }
                        texture {T_Sale   }
                        #end
                        }
#declare M_Cafe_MurX = material {texture {pigment { color rgb <0.824,0.851,0.698> }} 
                        #if (Text)
                          texture {T_Crasse scale 3}
                          texture {T_Sale   }  
                          texture {T_Tag scale 2.1 translate<.1,.4,0> }  
                        #end
                        }
                        
#declare M_Cafe_fnd = material {texture {pigment { color rgb <0.824,0.851,0.698> }}texture { T_Crasse }}

#declare M_Cafe_1er = material {  
                        #if (Text)
                        texture {T_Enduit }
                         texture {T_Crasse }
                        texture {T_Affiche  scale <4,4,.001> translate <0.8,6,0>     }   
                         
                        texture {T_Sale scale 2 translate <.1,-0,0> } 
                        #else 
                        texture { pigment {rgb <0.9,0.7,0.1>}}
                        #end
                        
}
#macro T_Cafe_I(Pg_CInt) 
#declare M_Cafe_Int=material {texture {pigment { rgb Pg_CInt } } } 
#end
                       

#declare M_Anneau   = material {Mega_M_Silver_5A}
#declare M_Rond     = material {Mega_M_Chrome_5E}      // Mega_M_Copper_5A
//------------
#declare M_Coin = 
material {
         texture {  
                pigment { rgb <0.95,.95,.95> } 
                                finish {
                                        ambient 0.3 
                                        diffuse 0.6 
                                        crand .1
                                        specular .5 
                                        roughness 0.01
                                        reflection 0.2
                                        }
                                normal {   wrinkles .3  }
         }
   interior { ior 20}
}
//--Texte "Cafe"

#declare Cafe_texte = text {ttf "comic.ttf" "Cafe" .01,0 //mont.ttf
                        pigment { color rgb <2,0,0> }   //  <0.969,0.553,0.047>
                        finish  { ambient 0.8 diffuse 0.8 brilliance 10 metallic}
}
//--------------------------
#declare ISOF_Porte_N=  function{pigment{wood}}// function ( y *(z))
#declare T_Patio=texture { 
                pigment {color rgb <0.984,0.816,0.216> }
                finish {ambient 0.3 diffuse 0.6 reflection <0.3,0.25,0.15>}
                normal {  function ISOF_Porte_N *(x*y*z)*1.0}
}
 texture {T_Crasse scale .5 }                
 texture {T_Crasse scale .1 }

//---------
#declare T_Sol_Patio= texture { pigment {rgb .6 } finish{ambient .3 diffuse .4} }
//=========================================================
#declare mfz=(Cfz-4)*m;
#declare Entrez_Fond= union {
                      box { <-Cfx,0.00,Cfz-.1><(Cfx),Cfh,mfz>*m  material { M_Cafe_fnd }}  // fond  
                      box { <Cfx,0, mfz><Cfx-.1,Cfh,Cfz+(2*cm)>  material {M_Cafe_Mur } }
               }
               
#declare  R_Porte=((Cfz-.8)-(Cfz-3.2))/2;
#declare Sol_Patio= box{  <-Cfx-.1,0.00,Cfz-.8><Cfx,1*cm,Cfz-3.2>*m  texture { T_Sol_Patio } }

#declare Patio = merge {
                        box { <-Cfx-.1,0.00,Cfz-.8><Cfx,Cfh-2.3,Cfz-3.2>*m  }  // Porte        
                        cylinder {<-Cfx-.1,Cfh-2.3,Cfz-2><Cfx,Cfh-2.3,Cfz-2>R_Porte}
                        texture { T_Patio rotate x*90}
}      

#declare fn_Pierre_Patio=function{pigment {granite}}          
#declare  T_Pierre=texture{pigment {rgb 1} finish {ambient .3 diffuse 0.6} normal {function fn_Pierre_Patio(x,y,z)*1.5} }
#declare Patio_Pierre=box{<-.05,0,-.1><0.1,.4,0> }
#declare Arond_Bord_Patio = difference {   
        cylinder {<-.1,0,0><0.1,0,0>R_Porte+.1}    
        cylinder {<-.5,0,0><0.5,0,0>R_Porte}   
        plane { y, 0 } 
        box{<-1,-.025,-2><1,.15,2> }   
        box{<-1,-.025,-2><1,.025,2> rotate x*45}
        box{<-1,-.025,-2><1,.025,2> rotate x*90}  
        box{<-1,-.025,-2><1,.025,2> rotate x*135}
         translate  <Cfx,Cfh-2.3,Cfz-2>
          }
#declare Patio_Bord_Pierre=union {
object {   Patio_Pierre translate <Cfx,0.00,Cfz-3.2> }
object {   Patio_Pierre translate <Cfx,0.45,Cfz-3.2>     }
object {   Patio_Pierre translate <Cfx,0.90,Cfz-3.2> }   
}
#declare Patio_Bord_Pierre=union {
object {Patio_Bord_Pierre}
object {   Patio_Pierre translate <Cfx,0.00,Cfz-.7> }
object {   Patio_Pierre translate <Cfx,0.45,Cfz-.7>    }
object {   Patio_Pierre translate <Cfx,0.90,Cfz-.7> }   

object {Arond_Bord_Patio}  
texture {T_Pierre}
}             
#declare Entrez_Fond=union {
                     difference {
                        object { Entrez_Fond} 
                        object {Patio scale <3,1,1>}
                     }   
                 //   object {Entrez_Fond}
                // Lumiere dans le PATIO
                     light_source { 0*x color rgb <3,1,1>//<0.992,0.965,0.835>*5
                        spotlight 
                        translate <Cfx-5.5,Cfh-2,Cfz-2> 
                        radius 50 falloff 50 
                        point_at <Cfx+2,0.0,Cfz-2>
                        fade_distance 10
                        fade_power 1
                     }    
                object { Patio_Bord_Pierre }
                object { Sol_Patio } 
              

}   

//========BAR========
#declare M_Bar_Sur=material {
                        texture
      {      
         pigment
         {
            wrinkles
            color_map
            {
               [ 0.0     rgb <0.558333, 0.0, 0.0> ]
               [ 0.5     rgb <0.829167, 0.3354, 0.5> ]
               [ 1.0     rgb <1.0, 1.0, 1.0> ]
            }
         }      
         finish
         {
            ambient 0.1
            reflection 0.043133
            
         }
      }
}

#declare M_Bar_Sous=material {
                        texture
      {      
         pigment
         {
            wrinkles
            color_map
            {
               [ 0.0     rgb <0.458333, 0.0, 0.0> ]
               [ 0.5     rgb <0.729167, 0.6354, 0.5> ]
               [ 1.0     rgb <1.0, 1.0, 1.0> ]
            }
         }      
         finish
         {
            ambient 0.1
            reflection 0.043133
            
         }
      }
}
//==========================================
#declare Verre=
difference {
        cone {<0,0,0>.05<0,.15,0>.06 }  
        cone {<0,0.01,0>.048<0,.15,0>.058 } 
        texture {NBglass}
}
                      
                             
#declare T_eau=texture  { pigment { gradient x*z
                        color_map {
                        [0.1 rgbf <1,1,.9,.95>]
                        [0.9 rgbf <1,1,1,.5>]
                        [1.1 rgbf <1,1,.9,.95>]
                         }
                         turbulence 1 octaves 5
                         } 
                         normal { bumps scallop_wave scale .2 octaves 5} 
                         finish { ambient .1 diffuse .1 phong 1}
}     

#declare Deborde=height_field { png "deborde.png"  
                        scale <1,.05,1.1>*.5
                        water_level 0.5
                        smooth inverse texture  { T_eau}
                        interior { ior 1.33 }
                        
                   //     rotate x*-90 
}
#include "canette.inc"
/*
#declare T_Bouteille=texture {NBwinebottle}
                      texture {
                             pigment { image_map  { png "povkein.png" map_type 2
                             transmit 0,1 interpolate 4 once
                                 } 
                             }
                             scale .20 translate y*.01
                      }

#declare Bouteille = 
lathe{
	cubic_spline
	8,
	<0.000000,1.003987>,
	<0.050199,1.003987>,
	<0.053785,0.964545>,
	<0.068128,0.839046>,
	<0.143427,0.645420>,
	<0.143427,0.322710>,
	<0.143427,0.000000>,
	<0.000000,0.000000>
	scale <.4,.3,.4>
	texture {T_Bouteille}
}
*/

#declare Bar_Sous=
        union {
               box {<-3,0,0><3,1.2,.5> }         
               cylinder {<3,0,0.5><3,1.2,.5>.5 }  
               material {M_Bar_Sous}
}
        
#declare Bar_Dessus= union {
               box {<-3.1,1.20,-.10><3,1.25,.60>}
                cylinder {<3,1.20,0.5><3,1.25,.5>.60  }
          material {M_Bar_Sur}
}

#declare Bar=union {
                 object {Bar_Sous}   
               object {Bar_Dessus} 
                 
}                                            
#declare Bar=difference  {
                object { Bar }
                box { <-3.2,0,.50><2.8,2,2>}
}                                           
#declare Bouteilles=union {
                        object {Bouteille rotate y*45 translate <3.2,1.25,.50>}
                        object {Bouteille  translate <3.0,1.25,.60>}
                        object {Bouteille rotate y*15 translate <3.3,1.25,.70>}
                        object {Bouteille rotate y*15 translate <3.4,1.25,.50>}
                        object {Bouteille rotate y*20 translate <3.1,1.25,.40>}
                        object {Bouteille rotate <0,10,-90> rotate y*45 translate <3.2,1.31,.50>}
                        object {Deborde translate <3.0,1.25,.10>}
}
#declare Bar=union {

object {Bar}
object {Verre translate <3.3,1.25,.10>}
object {Verre translate <3.2,1.25,.20>}
object {Bouteilles}
object {Deborde translate <2.8,1.23,-.10>}

}
//=====================================
#declare Etagere=
        union { 
                box {<3.05,0,-.10><3,2.5,.60>}
                box {<-3.05,0,-.10><-3,2.5,.60>}
                box {<-3,1.50,-.10><3,1.55,.60>}
              //  box {<-3,1.90,-.10><3,1.95,.60>}
                box {<-3.05,2.5,-.10><3.05,2.55,.60>}
               difference {
                box {<-3,0,-.10><3,1.25,.60>}
                box {<-2.95,.05,-.20><2.95,1.25,.55>}
               }
               box {<1,0.05,0><0,1.22,.05>  rotate y*180 translate <2.95,0,0>}
               box {<0,0.05,0><1,1.22,.05>  rotate y*30 translate <1,0,-.05>}
               box {<0,0.05,0><1,1.22,.05>  rotate y*10 translate <0,0,-.05>}
                box {<0,0.05,0><1,1.22,.05>  rotate y*0 translate <-1,0,-.05>}
                box {<0,0.05,0><1,1.22,.05>  rotate y*40 translate <-2,0,-.05>}
                 box {<0,0.05,0><1,1.22,.05>  rotate y*10 translate <-3,0,-.05>}
                
                
 material {M_Bar_Sous}
}
//======================
#declare coupe1 = 
lathe{
	cubic_spline
	10,
	<0.270886,1.354432>,
	<0.270886,1.038398>,
	<0.180591,0.632068>,
	<0.045148,0.541773>,
	<0.090295,0.316034>,
	<0.045148,0.135443>,
	<0.090295,0.090295>,
	<0.180591,0.045148>,
	<0.180591,0.000000>,
	<0.000000,0.000000>
	texture {Gold_Nugget}
}
#declare coupe2 = 
lathe{
	cubic_spline
	10,
	<0.548140,1.644421>,
	<0.548140,1.041467>,
	<0.219256,0.767397>,
	<0.054814,0.657769>,
	<0.109628,0.383698>,
	<0.054814,0.164442>,
	<0.109628,0.109628>,
	<0.328884,0.109628>,
	<0.383698,0.000000>,
	<0.000000,0.000000>
	texture {Gold_Nugget}
	
}
                                
#declare coupe3 = 
lathe{
	cubic_spline
	15,
	<0.599913,0.927138>,
	<0.490838,0.981675>,
	<0.545375,0.981675>,
	<0.599913,0.763525>,
	<0.436300,0.654450>,
	<0.272688,0.545375>,
	<0.218150,0.436300>,
	<0.218150,0.381763>,
	<0.109075,0.327225>,
	<0.109075,0.218150>,
	<0.163613,0.163613>,
	<0.163613,0.109075>,
	<0.327225,0.054538>,
	<0.381763,0.000000>,
	<0.000000,0.000000>
	texture {Gold_Nugget}
}
#declare coupe4 = 
lathe{
	cubic_spline
	15,
	<0.190010,1.567584>,
	<0.190010,1.045056>,
	<0.190010,0.665036>,
	<0.047503,0.570031>,
	<0.142508,0.570031>,
	<0.047503,0.522528>,
	<0.142508,0.427523>,
	<0.047503,0.427523>,
	<0.142508,0.285015>,
	<0.047503,0.190010>,
	<0.142508,0.190010>,
	<0.047503,0.047503>,
	<0.095005,0.047503>,
	<0.190010,0.000000>,
	<0.000000,0.000000>
	texture {Gold_Nugget}
}
//===================================
#declare Etagere=union {
                object { Etagere }
                object {coupe2 scale .8 translate <1,1.55,.25>}
                object {coupe1 scale .7 translate <1.8,1.55,.1>}
                object {coupe3 scale .5 translate <2.4,1.55,.1>}
                object {coupe4 scale .6 translate <0.8,1.55,.1>}
}
//=========Table======
#declare T_Crasse = texture {
        pigment {
                wrinkles
                color_map {
                        [0.0 Clear]
                        [1.0 DarkBrown*.5 filter 0.5]
                }
        }        
        
}

#declare T_Alu_Table = 
texture {
	pigment { color rgb<.9, .92, .95>*.7 }
	 normal { bozo 
	        normal_map {
	                [0.0  granite .1 scale .1 ]
	     [ 1.0  bumps .2 scallop_wave scale .5 ]
	        }
	        }
	finish { ambient .3 diffuse .6
		specular .5 roughness .05
		metallic
	}
}
#declare M_Pied_Table = material {
        texture {T_Alu_Table}
        texture {T_Crasse scale .1} 
}



#declare T_Table=texture {
                        pigment {color rgb <0.984,0.686,0.604> }
                        finish {ambient 0.3 diffuse .6 phong 1 phong_size 40}
                        normal { bumps 1 cubic_wave scale .5 }

}  
#declare Material1 = 
   material  // Material1
   {   
      texture
      {      
         pigment
         {
            wrinkles
            color_map
            {
               [ 0.0     rgbft <0.458333, 0.0, 0.0, 0.0, 0.0> ]
               [ 0.5     rgbft <0.729167, 0.6354, 0.5, 0.0, 0.0> ]
               [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            }
         }
      }
   }
#declare T_Table=    texture
      {      
         pigment
         {
            wrinkles
            color_map
            {
               [ 0.0     rgb <0.458333, 0.0, 0.0> ]
               [ 0.5     rgbt <0.729167, 0.6354, 0.50> ]
               [ 1.0     rgb <1.0, 1.0, 1.0> ]
            }
         }      
         finish
         {
            ambient 0.3
            reflection 0.043133
            
         }
      }

//=========================================
#declare Pied_Table=
        union {  cylinder {<0,.10,0><0,.70,0>.030}
                difference {
                         cone {<0,0,0>.15<0,.10,0>.05}
                         box{ <-.25,-0.05,-.05><.25,.05,.05>}
                         box{ <-.05,-0.05,-.25><.05,.05,.25>}
                }
                material {M_Pied_Table}
        }
#declare rtbl=.35;        
#declare Table =union {
        
                object {Pied_Table} 
                torus {rtbl,.025  material {M_Pied_Table} translate y*.70 }      
                cylinder{<0,0,0><0,.025,0>rtbl translate y*.70}
                texture {T_Table}
}
#declare Table_pleine=
        union { 
               object {Table }
               object {Verre translate <0.10,.70,-.3>}
               object {Bouteille translate < .10,.70,-.2>}
               object {Bouteille translate < .15,.70,-.1>}
               object {Bouteille translate <-.05,.70,-.2>}
               object {Deborde translate   < .10,.70,-.10>}
        }
        
                                                  
                                                
//--------CAFE------
#declare Cafe= union { //Le Rez de Chausse
              
                object {Cafe_texte scale <1.5,1.1,1> rotate y*-90 translate <Cfx,1.5,Cfz/6> }// texte Cafe
                box { <-Cfx, Cfh,0><(Cfx),Cfh-.2,Cfz>*m   material {M_Cafe_Mur}}   // plafond
                box { <-Cfx,1*cm,0><(Cfx),0,Cfz-3.5>*m    material {M_Cafe_Plc}}   // plancher
                box { <-Cfx,0.00,0><-(Cfx)+.5,Cfh,Cfz>*m  material {M_Cafe_Mur}}   // a doite
                box { <-Cfx,0.00,Cfz-.1><(Cfx),Cfh,Cfz>*m material {M_Cafe_fnd}}   // fond
                box { < Cfx-.5,0,0><(Cfx),Cfh,.5>*m       material {M_Cafe_Mur}}   // Coin
                
                difference { 
                        union {         
                                box { < Cfx-0.2, 1.00,0.1><Cfx-.1,Cfh,mfz >*m material { M_Vitre  }} //Vitre Z
                                box { < Cfx    , 0.00,0.1><Cfx-.3,1.0,mfz>*m material { M_Sous_Vitre}} //Cfz+(2*cm) Vitre  Z bas
                            //  box { < Cfx    , 0.00,0.1><Cfx-.3,1.0,Cfz+(2*cm)>*m material { M_Sous_Vitre}} //Cfz+(2*cm) Vitre  Z bas
                            //  box { <-Cfx,0.00,Cfz-.1><(Cfx),Cfh,Cfz+(2*cm)>*m  material {M_Cafe_fnd}}  // fond
                        }
                        box { < Cfx-1,0, 1 ><Cfx+1,2.1,2.2> } // trou de la porte
                }
                object { Entrez_Fond }   // PAtio
                box { <0,0,0><1*cm,2.1,1.2> material {M_Vitre} rotate y*-60 translate <Cfx,0,1> } //- porte du cafe
                //--------------
                 box { <-Cfx-.1, 0.00,0><Cfx-.1,Cfh,0.1>*m material {M_Cafe_MurX  }} // mur X
                //--- lumieres dans le cafe
                #if (Light)
                 light_source { 0*x color rgb <0.957,0.969,0.796>*2 fade_distance 5 fade_power 1 translate <Cfx/4,3,(Cfz/2)> }
                #end
                
//-------Rond-Avance_Cafe-----------    
                 union {
                        #declare Rcy=.40;
                        #declare E_Cyl=.8;
                        sphere   { <-(Cfx),Cfh,0>Rcy }   
                        cylinder { <-(Cfx),Cfh,0><(Cfx),Cfh,0>Rcy }
                        sphere   { <(Cfx),Cfh,0>Rcy }
                        cylinder { <(Cfx),Cfh,0><(Cfx),Cfh,Cfz-5>Rcy }
                        sphere   { <(Cfx),Cfh,Cfz-5>Rcy }
                        cone { <(Cfx),Cfh,Cfz-5>Rcy<(Cfx)-.5,Cfh,Cfz>Rcy-.2 }
                        sphere {<(Cfx)-.5,Cfh,Cfz>Rcy-.2 }
                 union {
                        cylinder { <0,0,0>< 0,0,0.2>Rcy+.05 translate <(Cfx),Cfh,Cfz/4> }
                        cylinder { <0,0,0>< 0,0,0.2>Rcy+.05 translate <(Cfx),Cfh,Cfz/8> }
                        cylinder { <0,0,0><.2,0,0>Rcy+.05   translate <(Cfx/2),Cfh,0>   }
                        cylinder { <0,0,0><.2,0,0>Rcy+.05   translate <(Cfx/8),Cfh,0>   }
                        material { M_Anneau }
                        }
                         material {M_Rond }     // 
                         translate <E_Cyl,0,-E_Cyl>  
                 }
                 
//----Etage et --
    //  #include "hasard.inc" 
      #local i=0;
      #declare Trou=box { <-10,1,.8><11,3.15,2.3> } 
      #declare Papier_Peint=pigment {rgb  <1,.98,.8>}  
#declare Cafe_1er=  
       #while (i<=3)       
             union {   
                     difference {                      //}
                             box { <-(Cfx),0,0><(Cfx),Cfh,Cfz>*m  }//
                             box { <-(Cfx)*.9,.9,.9><(Cfx)*.9,Cfh*.9,Cfz*.9>*m  pigment {Papier_Peint} }
                             object {Trou translate z*.5}
                             object {Trou translate z* 8}
                     }  
                   //    #declare hasard=seed(52);  
                  //   #render concat ("\n","hasard  dans fenetre   : ",str(seed(final),0,8),"\n")
                        #declare AnD=Rand()*180;
                        #declare AnG=Rand()*180;
                        #if (ftre)
                           #include "fenetre.inc"
                           object { fenetre rotate y*-90 translate <Cfx+.10,1,1.5+.5> }  
                           #render concat("Render FenetreA_",str(i,0,0)," AnD ",str(AnD,0,0)," AnG ",str(AnG,0,0),"\n") 
                        #end
                        
                        #declare AnD=Rand()*180;
                        #declare AnG=Rand()*180; 
                        #if (ftre)
                            #include "fenetre.inc"  
                            object { fenetre rotate y*-90 translate <Cfx+.10,1, 1.5+8> }
                            #render concat("Render FenetreB_",str(i,0,0)," AnD ",str(AnD,0,0)," AnG ",str(AnG,0,0),"\n") 
                         #end
                         
                         #if (Light) light_source { 0*x rgb 1 translate <Cfx/2,Cfh/1.5,Cfz/2.5>} #end
                translate y*Cfh*i   
                 material { M_Cafe_1er }    
}
         #local i=i+1;      
#end // While        
     
//----Cables----------
#declare T_Cable=texture { pigment {rgb <.5,.5,.5>} finish {Shiny} }
#declare T_Anno =texture { pigment {rgb <.4,.4,.3>} finish {Shiny metallic reflection .01} }

#init_3d_spline {"Cabl1",<4.6,5.05,6.1>,<4.20,3.50,6>,<4.00,3.95,3>,<4.00,3.90,-.1>,<3.95,3.90,-.1>,<3.70,0,-.20>}
#init_3d_spline {"Cabl2",<4.6,5.05,6.1>,<4.18,3.60,6>,<4.00,4.02,3>,<3.95,3.97,-.1>,<3.90,3.95,-.1>,<3.60,0,-.22>}
#declare c=0;
#declare Cables=
        union{
        torus {.15,.04 texture {T_Anno} scale <1.8,1,1> rotate x*90 translate <4.00,4.05,2.3>}       
        torus {.18,.04 texture {T_Anno} scale <1,1,1.5> translate <3.60,.5,-.05>}       

        #while (c<1)
         sphere { eval_3d_spline ("Cabl1",c),.04 texture{T_Cable}}    
         sphere { eval_3d_spline ("Cabl2",c),.04 texture{T_Cable}}     
        #declare c=c+0.001;
        #end
        }
 object {Cables }

//-----Goutiere-------
#include "Goutiere.inc"                 
                object {Goutiere translate <Cfx-(10*cm),0,-15*cm>}
//-----EnseignePOV
           object {Enseigne_POV  scale <2,3,1> translate <Cfx+.6,Cfh+.3,6>}  
//----Coin    
            difference {            
                box {<-.1,0,-.2><.1,20,.2>  }    
               box {<0,0,.05><1,20,1> } 
               
               material {M_Coin}   
              translate  <(Cfx),0,Cfz>*m 
            }    
//------Bar------
        object { Bar translate <-.8,-.1,7.5>}  
        object {Etagere translate <.75,0,10.4>}
//-----Table--------------
object { Table_pleine translate <1.5,.1,6>}  
object { Table_pleine translate <2,.1,4>}  
object { Table_pleine translate <3,.1,5>} 
                 
}

//////////////////////////////////////
#if (Render)
//-----------------------------------
//  camera  Autor : Jean Montambeault
//------------------------------------
#declare Zoom=1.5;
#declare Right=5/6*x;   // pour changer le rapport x/y ;                        
//------------------------------------
#include "camera.inc" 
//Camera (Distance, Azimut, Elevation, CentreD_Interet,FocalBlur) //, Angle
Camera (25, 10,20,<4.75,5,-5>,0)
//=====================================
light_source { 0*x color rgb <0.961,0.933,0.796>*.8 translate <0,2000,-4000> shadowless}             // 
background {color rgbt <0.153,0.169,0.170>}
plane { y,-.2 pigment {rgb  .2}}
//===================================== 
  
object { Cafe rotate y*15 translate x*-5}
object { Table_pleine translate <3,.1,5>  rotate y*15 translate x*-5} 

//====================================
#end  //fin if_Render

 