// Canette.inc autor Martial.Rameaux
#local Render=0;
//================================================
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	   // Standard Color definitions
#include "textures.inc"	   // Standard Texture definitions
#include "mega_metals.inc" // MegaPOV Metals definitions only with MegaPov
#include "hasard.inc"
//==============================================

#declare F_PovCanette = finish { ambient 0.3 diffuse 0.6 specular 1  metallic } 
#declare T_Chrome_Pov = material {Mega_M_Chrome_5E}
#declare T_PovCanette = material { 
                                 texture {
                                     pigment { 
                                     image_map  { png "povkein.png" map_type 2
                                                  transmit 0,1 interpolate 4 once
                                        } 
                                      }
                                     finish { F_PovCanette } 
                                } 
}



#macro Pov_Canette(Pg_C)
union {
    //    difference {
           union    {  
                difference { //Haut
                              difference {   
                                        sphere   { 0,2.2 }
                                        sphere   { 0,2.19 }
                                        clipped_by { box{<-4,0,-4><4,4,4> } } 
                                        scale <1,.2,1> 
                               }
                    sphere   { 0,.5   scale <1,2,1.2> translate <0,.5,-.8> }
                         translate y*8        
                }
                difference {
                        cylinder { <0,0,0><0,1,0>2.5   material {T_PovCanette rotate y*90 }  scale <1,8,1> rotate <0,-90,0> }
                        cylinder { <0,0,0><0,1.2,0>2.49  open   pigment {Pg_C}  scale <1,8,1> rotate <0,-90,0> }
                        cylinder { <0,0,0><0,1.2,0>2.485 open   material {Mega_M_Silver_5A}  scale <1,8,1> rotate <0,-90,0> }
                }
               
           }
        //   cylinder   { <0,-1,0>,<0,1,0>.6 scale <1,1,1.2> translate <0,8,-.8>}
    //}      
        union {
               torus    { 2.3,.2 translate y*8  }   // bords rond du haut 
                torus    { 2.2,.2 translate y*8.1 }    
                 torus    { 2.2,.2 translate y*-.1 }  //           du bas 
        }
           
               difference {   // fond
                        sphere   { 0,2.2 }
                        sphere   { 0,2.19 }
                        clipped_by { box{<-4,0,-4><4,4,4> } }  translate y*-.1 scale <1,.5,1>
                }
        // Anneau
        difference {
                union {
                cylinder { <0,0,0><0,0,.1>.6 clipped_by { box { <-1,-.7,-1><1,1,1> }}}
                torus    { .6,0.1  rotate x*90 }
                box {<-.4,-.5,-.01><.4,.3,.01> translate y*-.5}
                }
                sphere { 0,.5 translate y*.1}
                scale <.9,1.2,1> 
                rotate x*60
                translate <0,9.3,.8>     
        }       
                material {T_Chrome_Pov}
                scale 1/10
}
#end // macro_canete
#declare Bouchon=
        union {
               torus    { 2.3,.2 translate y*8  }   // bords rond du haut 
                torus    { 2.2,.2 translate y*8.1 }    
                        difference {
                union {
                cylinder { <0,0,0><0,0,.1>.6 clipped_by { box { <-1,-.7,-1><1,1,1> }}}
                torus    { .6,0.1  rotate x*90 }
                box {<-.4,-.5,-.01><.4,.3,.01> translate y*-.5}
                }
                sphere { 0,.5 translate y*.1}
                scale <.9,1.2,1> 
                rotate x*60
                translate <0,9.3,.8>     
        }       
                material {T_Chrome_Pov}
                scale 1/10
}

//=======BOUTEILLE=============================
#declare T_Bouteille=texture {NBwinebottle}
                      texture {
                             pigment { image_map  { png "povkein.png" map_type 2
                             transmit 0,1 interpolate 4 once
                                 } 
                             }
                             finish {ambient 0.3 diffuse 0.6 phong 1 }
                             scale .5 translate y*.05
                      }

#declare Bouteille =union { 
lathe{
	cubic_spline
	8,
	<0.000000,1.003987>,
	<0.050199,1.003987>,
	<0.053785,0.964545>,
	<0.068128,0.839046>,
	<0.143427,0.645420>,
	<0.143427,0.322710>,
	<0.143427,0.000000>,
	<0.000000,0.000000>
	
texture {T_Bouteille}
	
}
sphere {0,.1 scale <1,.1,1> texture {NBwinebottle}
}
scale <.4,.3,.4>
}



//////////////////////////////////////
#if (Render)
//-----------------------------------
//  camera  Autor : Jean Montambeault
//------------------------------------
#declare Zoom=1.5;
#declare Right=5/6*x;   // pour changer le rapport x/y ;                        
//------------------------------------
#include "camera.inc" 
Camera (25, 10, 20, <4.75,1,5>,no) //, Angle
//=====================================
light_source { 0*x rgb 2 translate <0, 100,0>}
//light_source { 0*x rgb 2 translate <-10,-100,-100>}
plane { y,-.0 pigment {rgb .6}}
//=====================================   
#declare P_C=pigment {rgb <rand(hasard)/1,rand(hasard),rand(hasard)/1>}
#declare i= 0;
#while (i<100)
#declare Pg_C=pigment {rgb <rand(hasard)/1,rand(hasard),rand(hasard)/1>}
#declare t_x=rand(hasard)*8;
#declare t_z=rand(hasard)*5+(i/1.5);
#if (mod(i,7)=0 )
                 object {Bouteille  scale 4 rotate x*90  rotate y*Rand()*-360 translate <t_x,0.25,t_z> }        //
                 #else
                 #if (mod(i,3)=0 )
               
               object { Pov_Canette(Pg_C) scale <1,.1,1> rotate y*Rand()*-360  translate <t_x,0.05,t_z> }
                 #else
                object { Pov_Canette(Pg_C) rotate <0,Rand()*10,90> rotate y*Rand()*-360  translate <t_x,0.25,t_z> }
                #end
#end 
             
#declare i=i+1;  
#end

//object { Pov_Canette(P_C) scale 2 translate <5,0.25,2> }
//  object {Bouteille  scale 4   rotate y*Rand()*-360 translate <t_x,0.35,2> } 
//====================================
#end  //fin if_Render

        