// Persistence of Vision Ray Tracer Scene			
// Unofficial compile of Pov-Ray rendering for windows version 3.1g wmp 0.4 WinMegapov0.4
// Fichier        : mrstreet (04_0..) by  Martial Rameaux
// Date           : Mars_Avril 2000
// Description    :                     
// Web       -> http://martial.rameaux.free.fr/
// mile ;-) -> martial.rameaux@free.fr
//==========================================
// 18h00m11s hight-radiosite
// Thanks to Bouf, Gilles Tran,
// Rodolph Gelaud, and all news_group nzn.3d.pov.fr.
// Fabien Legeron, Coline Rameaux (my daughter)
// Jean-Marie Martin my good colleague ...
//  
// Tools used .....
// sometime ColorPicker by Jamis Buck http://students.cs.byu.edu/~buck
// SpilinEditor by Alexandro Falapa  http://www.flashnet.it/users/fn027571/spil/  for the colone of the balcon;                            
// Spatch by Mike Clifton for the garbage bag
// PaintShopPro for paint affiche, tag and heightfield for placard MegaStore and hubcap;
// My Colleague's photo at the works; 
// thanks Jean-Marie for autorisation to use it!
//
// -- 3D model from 3Dcafe.....http://www.3dcafe.com/
// Pittbull, Man4, jaguard !! 
// converted by Crossroads 3D http://www.europa.com/~keithr/crossroads/
//
// -- include needed .......
// Mega_metals.inc by Eric Freeman 
// Hasard.inc  by Rodolphe Gelaude
// mwindow.pov by Gilles Tran
// camera.inc by Jean Montambeault  
//
// -- in this scene by myself
// cafe.inc
// poubelle.inc 
// canette.inc  
// mgstore.inc 
// graph.inc
// echfdag.inc
// petitmag.inc
// au44.inc
// sacp1.inc
// sacp2.inc
//==========================================
#version unofficial Megapov 0.4;
// ==== POV-Ray Includes ====
#include "colors.inc"	   // Standard Color definitions
#include "textures.inc"	   // Standard Texture definitions
#include "mega_metals.inc" // MegaPOV Metals definitions 
#include "hasard.inc"      // Hasard de R.Gelaude     
#include "etalon.inc"      // Etalon le metre (m)  

//===Declaration de Rendu  for render in small or great window and bad or good quality 
#declare Div   =5/6; #declare Image_Length = 500/Div;  #declare Image_Height = 600/Div;// 5/6 
#declare Ini   =on; // fonction ini_option de megapov
#declare Ini_Taille=concat ("+q9 +h",str(Image_Height,0,0)," +w",str(Image_Length,0,0)," +A.3" ) //+A0.01 +AM2 +R3 
#render concat("\n","RENDER_INI :",Ini_Taille,"\n") 

#declare high_quality=yes; //yes or no for high_quality Radiosite

//---DECLARATION DE TRAVAIL-------------    
#declare Trans =1;     // Transparence
#declare CamJm =1;     // Camera Tournante
#declare Fog   =1;     // The Fog
#declare A_Lght=1;     // Lumire Globale
#declare Light =1;     // Lumieres un peu partout
#declare Caf   =1;     // affiche le cafe
#declare ftre  =1;     // et ses fenetres
#declare Gra   =1;     // affiche le batiemnt Graph
#declare MStr  =1;     // affiche le MegaStore
#declare vitre =1;     // les vitre du MegaStore et Graph
#declare Echf  =1;     // Echaffaudages 
#declare Mur   =1;     // Mur en Travaux (in Echf)
#declare Ptmg  =1;     // PetitMagasin
#declare Au44  =1;     // Au 44bis 
#declare Reverb=1;     // Reverber
#declare Canet =1;     // Canettes
#declare Evi   =1;     // bouteil Evian
#declare Papier=1;     // Papier Gras
#declare megot =1;     // Megot
#declare BrsGl =1;     // Bris de Glasse 
#declare Crot  =1;     // Poopdog
#declare Poubel=1;     // Poubelle
#declare Scp   =1;     // Sac poubelle
#declare Pit   =0;     // PittBull  
#declare Man4  =0;     // Man attache_case
#declare Car   =0;     // Totomobile 
#declare Rte   =1;     // Route
#declare Text  =1;     // texture complexe
#declare disp  =1;     // dispertion de la lumiere dans les transparences

#declare WkLu  =0;     // Lumiere de Tavail

//=====CAMERA===================================
#if (CamJm)
//--Position de la Camera Autor : Jean Montambeault  
#declare Zoom      = 1.5; //1.5;
#declare Right=Image_Length/Image_Height*x;   // pour changer le rapport x/y ;                        
#include "camera.inc" 
//Camera (Distance, Azimut, Elevation, CentreD_Interet,FocalBlur) 
//Camera (25, 10, 20, <4.75,5,-5>,no) //for memorie
Camera (25, 10, 20, <4.75,5,-5>,no) //VUE NORMAL
//Camera (100, -90,90, <4.75,5,35>,no) // vue d'en haut
//Camera (18, 50,10, <-1.75,1,10>,no) // vue dans le caf
#else
//--Sinon Camera Normal----------
camera {location <10,9,-15> right Image_Length/Image_Height*x up y look_at <3.9,3,0>}
camera {location <10,9,-15> right Image_Length/Image_Height*x up y look_at <3.9,3,0>}

#end //If camera
//=====GLOBAL SETTING========
global_settings
 {
  #if(Ini)
  ini_option Ini_Taille  
  #end
  assumed_gamma 2.2
#if(high_quality)
    radiosity{
    pretrace_start 0.08
    pretrace_end   0.02
    count 80             // CHANGE range from 20 to 150
    nearest_count 5      // CHANGE range from 3 to 10
    error_bound 1        // CHANGE - range from 1 to 3 - should correspond with pretrace_end
    recursion_limit 4    // CHANGE
    
    low_error_factor .5  // leave this

    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1         // leave this
    adc_bailout 0.01/2   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
    }
#else
  radiosity {
     pretrace_start 0.08
     pretrace_end   0.02
     brightness 2 
     count 20
     recursion_limit 4
     adc_bailout 0.01/2   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
     }
 #end
  ambient_light .1
 }

//====Lumiere Globale et Background =============
#if(A_Lght)
light_source { 0*x color rgb <0.961,0.933,0.796>*.8 translate <0,2000,-4000> shadowless}             // 
#end
background {color rgbt <0.153,0.169,0.170>}

//====DEBUT DE LA SCENE======================

//===FOG======================================
#if (Fog) 
fog {
	distance 300
	color rgbt<0.2, 0.2, 0.7, 0.2>
	turbulence 0.2
	turb_depth 0.3
}
fog {
	distance 10
	color rgbft<0.5 0.5, 0.2,0.0,0.3>
	fog_type 2
	turbulence 0.2
	turb_depth 0.3
	fog_offset 2
	fog_alt 1
} 
#end
//===Texture pour toute la scene=============
#declare T_Crasse = texture { // by Bouf from JV Picqueres
        pigment {
                wrinkles
                color_map {
                        [0.0 Clear]
                        [1.0 DarkBrown*.5 filter 0.5]
                }
        }
}

// from Mega_Metal.inc
#declare P_Revb= color rgb <0.95, 0.95, 0.95>;
#declare P_Bare=color rgb <0.70, 0.55, 0.40>;
#declare F_Bare=
finish {
    ambient 0.1
    brilliance 6
    diffuse 0.7
    metallic
    reflect_metallic
    blinn 3.1 facets .12
    reflection 1.05
}
#declare MegaInt=interior { ior 20 }
#declare T_Chrm=texture{pigment{P_Revb }finish{F_Bare}}
#declare T_Brss=texture{pigment{P_Bare }finish{F_Bare}}

#declare M_Bare=material {texture {T_Brss }
                        //  texture {T_Crasse scale 0.5 }
                          interior {MegaInt}
}

//===Declaration Position du Cafe
#declare Cfx=4;
#declare Cfz=15;
//==========Reverberber
#if (Reverb)

#declare M_Reverber= material  { Mega_M_Chrome_5E }
#declare M_Globe   = material  { 
                                texture {
                                         pigment { rgbf <1,0.8,0.8,1> }
                                         finish { ambient 0.0 diffuse 0.0 reflection 1
                                         } 
                                } 
                                 interior { ior 1.5 #if(disp) dispersion 1.05 disp_nelems 15 #end   }
}

#declare M_Lampe   = material  { texture { pigment { rgbf <1,1,.9,0> } finish { ambient 2.0 diffuse 1 }  } } 
#declare h_rev = 10*m; // hauteur reverber
#declare h_fio =  8*m; // hauteur lampe
#declare Lampe =  sphere { <0,0.1,0>,20*cm material { M_Lampe } }
#declare Reverber  = union {
                        #declare Fioritures=1;
                        cone { <0,0,0>,0.20<0,h_rev,0>,.03 } //poteaux
                        sphere {0,5*cm translate y*h_rev}  //
                        torus { 1*m,3*cm clipped_by { box {<-2,-1,-2><2,2,0>}} rotate x*90  translate <1,h_fio,0>} 
                        
                     #if (Fioritures)
                        torus { 14*cm,3*cm  rotate x*90 translate <17*cm,h_fio+.83,0>}// rond 
                        cylinder { <0,0,0><.9*m,0,0>3*cm translate <0,h_fio+1,0>} // transversale 
                     #end    
                        sphere { 0,30*cm clipped_by {box { <-1,1,-1><1,0,1>}} translate <2,h_fio,0>}
                        sphere { 0,29*cm material { M_Globe } translate <2,h_fio,0> }
                        torus  { 30*cm,3*cm translate <2,h_fio,0>}
                        #if (Light)
                        light_source {0*x color rgb <0.949,0.894,0.894>*4 
                                      spotlight  translate <2,h_fio,0> radius 30*cm falloff 500 point_at <5,0,0> 
                                      looks_like { object {Lampe} }
                                      }
                        //object {Lum translate  <2,h_fio,0>}// no good whith radiosity
                        #end
                        material  {M_Reverber }
}
#end // If Reverb
//==========BARRIEREdeVILLE==========================
#declare P_Barriere=color rgb <0.70, 0.55, 0.40>;
#declare F_Barriere=
finish {
    ambient 0.1
    brilliance 6
    diffuse 0.7
    metallic
    reflect_metallic
    blinn 3.1 facets .12
    reflection 1.05
}

#declare Fct_N_Barriere1=function { pigment { granite }}
#declare Fct_N_Barriere2=function { pigment { bozo}}
#declare Fct_N_Barriere=function {Fct_N_Barriere1 + Fct_N_Barriere2 }

#declare M_Barriere = material { texture {pigment {P_Barriere}finish {F_Barriere} normal { function (Fct_N_Barriere*(x*y*z)*.1)} } }
#declare Barriere = union {
                            #declare Bh =  1.2* m; // hauteur barriere
                            #declare Br =  5  *cm; // rayon barriere
                            #declare Brs=  6  *cm; // rayon boule barriere
                            #declare Rb =  2  * m; // rayon de la courbure de la barriere
                            #declare Ec1= 60  *cm; // ecart des bareaux 
                            #declare Ecc= 24  *cm; // ecart des bareaux dans l'arrondi
                            
                            cylinder { <-1.1,Bh,-Rb><0,Bh,-Rb>Br }// en x
                            sphere   { <-1.1,Bh,-Rb>Brs }
                            cylinder { <Rb,Bh,1.1><Rb,Bh,0>Br}    // en z
                            sphere   { <Rb,Bh,1.1>Brs }
                            torus    { Rb,Br clipped_by { box { <0,-3,-3><3,3,0>}}translate <0,Bh,0> }
                            
                         //-- En x potelet
                            #declare hsp =1.5; //  position haute de la Sphere
                            #declare Sclsph=<1,1.6,1>; //Scale Sphere
                            #declare i=1.01 ;
                            #while (i > 0) 
                            cylinder {<-i,0,-Rb><-i,Bh,-Rb>Br }
                           // sphere {0,Brs scale Sclsph translate <-i,Bh/hsp,-Rb> }
                            #declare i=i-Ec1;
                            #end   
                         //-- En z
                            #declare i= 1.01 ; 
                            #while (i > 0) 
                            cylinder {<Rb,0,i><Rb,Bh,i>Br }
                          //  sphere {0,Brs scale Sclsph translate <Rb,Bh/hsp,i>  }
                            #declare i=i-Ec1;
                            #end 
                         //-- In Circle
                            #declare i= .95 ; 
                             #while (i > 0.1) 
                          //   union {
                            cylinder {<0,0,0><0,Bh,0>Br   translate x*2
                              rotate y*(90*i)    }
                         //   sphere {0,Brs scale Sclsph translate <0,Bh/hsp,0> }
                            //} 
                            #declare i=i-Ecc;
                            #end
                            //--
                            material  {M_Barriere}
                translate <-10*cm,0,10*cm>                             
}
#declare Barriere2=union {
                        sphere   { <Rb,Bh,0>Brs }
                        cylinder { <Rb,Bh,0><Rb,Bh,4.1>Br}    // en z
                        sphere   { <Rb,Bh,3.1>Brs }
                            #declare i= 4; 
                            #while (i > 0) 
                            cylinder {<Rb,0,i><Rb,Bh,i>Br }
                        // sphere {0,Brs scale Sclsph translate <Rb,Bh/hsp,i>  }
                            #declare i=i-Ec1;
                            #end 
                        material  {M_Barriere}
                        translate <-10*cm,0,10*cm>
}
#declare Barriere=union { 
                       object {Barriere} 
                       object {Barriere2 translate z*3} 
                       object {Barriere2 rotate y*90 translate <-7.2,0,0>}
                       }
//===========TROTOIRE===============================
#declare T_Sale_trotoire = texture {
                                pigment {
                                bozo 
                                color_map {
                                [0.0 rgbf <0.3,0.3,0.3,0.5>]
                                [0.5 rgbf <0.0,0.0,0.0,1.0>]
                                [1.0 rgbf <0.3,0.3,0.3,0.0>]
                                }
                                turbulence .1
                                octaves 6 
                                lambda 2.0
                                omega 1
                                
                                }
                        normal {granite 0.8}        
                        finish {ambient 0.3 diffuse .6  }
                        scale <1,1,5> 
                        translate x*-.5
                        
}  

#declare T_Trotoire =texture { 
                                pigment { rgb 0.5 }
                                finish { ambient .3 diffuse 0.5 }
                                normal {granite 0.001 }
                                  }

#declare T_Trotoire = material { 
                         texture { T_Trotoire }
                         #if(Text)
                         texture { T_Sale_trotoire}
                         #end 
}

                 


#declare fn_Bordure=function{"rounded_box",<0.1,0.4,0.5,1>}
#declare fn_Bumps=function{pigment {granite}}

#declare Bordure=
isosurface{
	function {fn_Bordure(x,y,z)+fn_Bumps(x,y,z)*0.01}
	contained_by{box{<-0.4,-0.0,-1>,<0.4,0.5,1>}}
	pigment {rgb .6} // { rgb <2,0,0>}//
	scale <.2,.2,.48>
}
#declare i=0;
#declare BordureD=
                union {
                #while (i<100)
                object { Bordure translate z*i}
                        #declare i=i+1; 
                        #end
 }        
#declare Joint_Bordure=object {BordureD pigment {rgb .4} scale <1,1,.2>}
#declare Bordure=union { object {BordureD}object { Joint_Bordure translate z*1}}

#declare N_Bordure=function {pigment {granite}}
#declare M_Bordure_Courbe=material{texture{pigment {rgb .6}normal {function N_Bordure(x,y,z)*0.1}}}
#declare Bordure_Courbe= cylinder{ <0,0,0><0,10*cm,0>2.1}   
#declare Bordure_Courbe=difference { object {Bordure_Courbe} 
                                     cylinder { <0,-1,0><0,12*cm,0>2 } 
                                    clipped_by {box{<0,-2,-3><3,1,0>}}
                                     material {M_Bordure_Courbe} 
}

#declare Trotoire1 =union { #declare LT=2;
                        box { <Cfx-LT,0,0><Cfx+LT,10*cm,Cfz+80> }
                        cylinder { <Cfx,0,0><Cfx,10*cm,0>LT }
                        object { Barriere translate x*Cfx }
                        object { Bordure translate <Cfx+LT,0*cm,0.1> }
                        object { Bordure_Courbe translate <Cfx,0*cm,-.0>}   
                        
                        object { Bordure rotate y*-90 translate <Cfx+LT-2.5,0*cm,-2> }
                         
                        object { Bordure translate <Cfx+LT+6,0*cm,0> }                       
                        object { Bordure_Courbe rotate y*90 translate <Cfx+10,0*cm,-.0>}  

                        object { Bordure rotate y*90 translate <Cfx+LT+8.5,0*cm,-2> }
                       #if (Reverb)                                                  
                                object {  Reverber translate <5.5,0,3.0>}// translate <5.5,0,3.5>
                                object {  Reverber translate <5.5,0,26>} 
                                object {  Reverber translate <5.5,0,50>}
                       #end 

                        material {T_Trotoire rotate y*90}   
}

 #declare Trotoire2 =union { #declare LT=2;
                        box { <Cfx,0,-LT><-30,10*cm,LT> }
                        cylinder { <Cfx,0,0><Cfx,10*cm,0>LT } 
              //          #if (Reverb) object {  Reverber rotate y*180 translate <12.5,0,5.5>} #end
                        material {T_Trotoire }   
}

#declare Trotoire3 =union { #declare LT=2;
                        box { <Cfx-LT,0,0><Cfx+LT,10*cm,Cfz+30> }
                        cylinder { <Cfx,0,0><Cfx,10*cm,0>LT }   
                        #if (Reverb) object {  Reverber translate <5.5,0,5.5>} #end
                      //  object {  Reverber translate <5.5,0,22>}
                        object {  Barriere  translate x*Cfx}
                        material {T_Trotoire }   
}
//====Plaque_d'Egout=========================
#declare P_Plaque=pigment{ rgb <.4,.4,.5>}
#declare F_Plaque=finish {Mega_F_MetalA}
#declare M_Plaque=material {  texture {pigment{ P_Plaque} normal {    
    quilted 1
    control0 0
    control1 1
    scale <.1,1,.1> }
    finish {F_Plaque}
    }
    texture {T_Crasse scale .5}
    interior {ior 20}
}
#declare M_Tour_Plaque=material {  texture {pigment{P_Plaque} finish {F_Plaque} } interior {ior 20} }
#declare Plaque_Degout=union{
                difference {
                cylinder {<0,0,0><0,.05,0>.40 }
                box {<-.05,-1,-.05><.05,1,.05,> }
                 material {M_Plaque} 
                 rotate y*45
               //  rotate z*-0.2
                }
                #declare LgTrou=.47;
               difference {
                cylinder {<0,0,0><0,.05,0>.45}
                cylinder {<0,-1,0><0,1,0>LgTrou}
               material {M_Tour_Plaque}
                }
      
}
//=========Route==================================

#declare T_roue =texture {
                                pigment {
                                        leopard 
                                        color_map {
                                        [0.0 rgbf <0.5,0.5,0.5,0.6>]
                                        [0.5 rgbf <0.0,0.0,0.0,0.2>]
                                        [1.0 rgbf <0.3,0.3,0.3,0.4>]
                                        }
                                        turbulence .6 omega 1 lambda 10.0 octaves 5 phase 0
                                         }
                                        scale <.3,1,10> 
}  
#declare T_roue_route =texture {
                                pigment {
                                        leopard 
                                        color_map {
                                        [0.0 rgbf <0.3,0.3,0.3,0.6>]
                                        [0.5 rgbf <0.0,0.0,0.0,0.8>]
                                        [1.0 rgbf <0.3,0.3,0.3,0.4>]
                                        }
                                        turbulence .6 omega 1 lambda 5.0 octaves 5 phase 0
                                         }
                                        scale <.25,1,20> 
                                        translate x*.6
                                        }  

#declare T_Route = material {texture {pigment {rgb <0.5,0.5,0.5>}}
                           //  texture { T_Pssaroue }
//interior { ior 20}
}
#declare T_Axial  =material { texture {pigment {rgb 1}} 
                               #if (Text)  
                               texture { T_roue }
                               #end
}

#declare T_Passage=material {
                             texture {pigment {rgb 1 }}
                             #if (Text)  
                             texture { T_roue }
                             #end
}
#declare Pointille= box { <0,0.0,0><50*cm,0.1*mm,30*cm> }
#declare Passage  = box { <0,0.0,0><50*cm,0.1*mm,3*m> }      
#declare Passage  = union {
                        #declare i=-4.5;
                        #while (i < 4 )
                        object { Passage  translate x*i }
                        #declare i=i+1;
                        #end
                        box {<0,0.0,0><20*cm,0.1*mm,15*m>   translate z*3.5} 
                        box {<0,0.0,0><20*cm,0.1*mm, 3*m>   translate z*20 }
                        box {<0,0.0,0><20*cm,0.1*mm, 3*m>   translate z*24.5 } 
                        box {<0,0.0,0><20*cm,0.1*mm, 3*m>   translate z*28} 
material { T_Passage }
}
#declare T_Passage2 = material { texture {pigment {checker rgbf 1, rgb 1.5 } normal { granite 0.01}}
                               #if (Text)  
                               texture {T_roue rotate y*-45}
                               texture {T_roue rotate y* 45}
                                #end
}

                         
#declare Route   = box { <-3.0,0,-10><3.0,0.001*mm,500> texture {T_roue_route }}   
#declare Passage2= box { <-4.3,0,-5.><4.3,0.1*mm,5> material {T_Passage2 rotate y*45 } }
#declare Fond    = plane {y,0 material {T_Route} normal { granite 0.01} hollow}//texture {txtSW scale <0.1,1,0.1> }}//

//=========CANETTE_DE_POV==============================
#if(Canet)
// Pov_Canette(Pigment_Canette)
#include "canette.inc"
//-------Canette 
#declare  Canette1=union {
        #render "Render Canette1 \n"        
        #declare i=0;
        #while (i<100)
                #declare Pg_C=pigment {rgb  <rand(hasard),rand(hasard),rand(hasard)/2>}
                #declare t_x=rand(hasard)*5;
                #declare t_z=rand(hasard)*5+(i/1.0); 
                        
                        #if (t_z < 10  )            #declare t_x=rand(hasard)*2; #end 
                        #if (t_z > 30 & t_z < 60 ) #declare t_x=rand(hasard)*7; #end
                        #if (t_z > 60 )           
                                         #declare t_x=(rand(hasard)*1.5); 
                                         #declare t_z=t_z+(rand(hasard)*20); 
                        #end
#if (mod(i,3)=0 )
                 object {Bouteille  scale 4 rotate x*90  rotate y*Rand()*-360 translate <t_x,0.35,t_z> }        //
                 #else
                object { Pov_Canette(Pg_C) rotate <0,Rand()*10,90> rotate y*Rand()*-360  translate <t_x,0.25,t_z> }
#end 
                             #declare i=i+1;
        #end // While 
}

#declare  Canette2=union {
        #render "Render Canette2 \n"                
        #declare i=0;
        #while (i<20)
                #declare Pg_C=pigment {rgb  <rand(hasard),rand(hasard),rand(hasard)/2>}
                #declare t_x=rand(hasard)*10;
                #declare t_z=rand(hasard)*5+(i/5);
#if (mod(i,3)=0 )
                 object {Bouteille  scale 4 rotate x*90  rotate y*Rand()*-360 translate <t_x,0.35,t_z> }        //
                 #else
                object { Pov_Canette(Pg_C) rotate <0,Rand()*10,90> rotate y*Rand()*-360  translate <t_x,0.25,t_z> }
#end 
                            // object { Pov_Canette(Pg_C) rotate <0,Rand()*10,90> rotate y*Rand()*-360  translate <t_x,0.25,t_z> }
                #declare i=i+1;
        #end
}

#declare  Canette3=union {
        #render "Render Canette3 \n"        
        #declare i=0;
        #while (i<20)
                #declare Pg_C=pigment {rgb  <rand(hasard),rand(hasard),rand(hasard)/2>}
                #declare t_x=rand(hasard)*10;
                #declare t_z=rand(hasard)*5+(i/5);
#if (mod(i,3)=0 )
                 object {Bouteille  scale 4 rotate x*90  rotate y*Rand()*-360 translate <t_x,0.35,t_z> }        //
                 #else
                object { Pov_Canette(Pg_C) rotate <0,Rand()*10,90> rotate y*Rand()*-360  translate <t_x,0.25,t_z> }
#end 
             
                //object { Pov_Canette(Pg_C) rotate <0,Rand()*10,90> rotate y*Rand()*-360  translate <t_x,0.25,t_z> }
                #declare i=i+1;
        #end
}
#declare  Canette4=union {
        #render "Render Canette4 \n"       
        #declare i=0;
        #while (i<10)
                #declare Pg_C=pigment {rgb  <rand(hasard),rand(hasard),rand(hasard)/2>}
                #declare t_x=rand(hasard)*10;
                #declare t_z=rand(hasard)*5+(i/5);
#if (mod(i,3)=0 )
                 object {Bouteille  scale 4 rotate x*90  rotate y*Rand()*-360 translate <t_x,0.35,t_z> }        //
                 #else
                object { Pov_Canette(Pg_C) rotate <0,Rand()*10,90> rotate y*Rand()*-360  translate <t_x,0.25,t_z> }
#end 
                             //object { Pov_Canette(Pg_C) rotate <0,Rand()*10,90> rotate y*Rand()*-360  translate <t_x,0.25,t_z> }
                #declare i=i+1;
        #end
}
#end

//===========Papier_Gras==============================
#if (Papier)
#declare T_Papier=material {texture {
	pigment { image_map {png "manif.png"  once interpolate 4}  }
	finish { phong 0.9 }
	}        
	translate 0
}
#declare Papier1=
        box { <0,0,0><1,1,.00001*1/1000> 
        material {T_Papier}  
        scale <397/561,1,1>*29*cm  
        rotate x*90
        no_shadow 
}

#macro Papier2(Ang)
        merge {
        box { <0,0,0><1,.5,.0001>   rotate x*-Ang  }
        box { <0,0,0><1,.5,.0001>   rotate x* Ang  }      
        material {T_Papier }
        scale <397/561,1,1>*29*cm 
        no_shadow
        }
#end

   

#declare  Papiers=union {
#render concat ("Render Papiers ","\n")        
#declare i=0;
#while (i<600)
#declare t_x=rand(hasard)*15;
#declare t_z=rand(hasard)*3+(i/8);
#declare Papier_Rand = Rand()*2;
#if ( Papier_Rand < 1.9 ) 
        #declare Papier_Rand = object { Papier1 }   
                #if (mod(i,2)= 0)        
                   #declare Papier_Rand = object { Papier1  pigment { color rgb <0.063,0.969,0.898> } scale .3 } 
                #end
                #if (mod(i,5)=0)
                   #declare Papier_Rand = object { Papier1  pigment { color rgb <0.957,0.129,1.000> } scale .4 } 
                #end         
#else 
        #declare Papier_Rand = object { Papier2(Rand()*80) }
#end
object { Papier_Rand  rotate y*Rand()*-360  translate <t_x,0.25,t_z> no_shadow}
#declare i=i+1;
#end
}
#end // (if papier)

//===================Megots
#if (megot)
#declare M_bout_Cig=material {
        texture {
        	pigment { color rgb <0.800,0.561,0.090> }
        	finish {ambient 0.4 diffuse 0.6 }
        	}        
}
#declare M_Cig=material {
        texture {
        	pigment {color rgb <0.992,0.980,0.910> }
        	finish {ambient 0.4 diffuse 0.6 }
        	}        
}
#declare M_Cendre_Cig=material {
        texture {
        	pigment {color rgb <0.667,0.667,0.678> }
        	finish {ambient 0.3 diffuse 0.6 }
        	}        
}
#macro Cigarette(Lg_Bt)
                union{ #declare  Bt= Lg_Bt;
                        cylinder { <0,0,0><2.5*cm,0,0>8*mm     material {M_bout_Cig}}
                        cylinder { <2.5*cm,0,0><Bt*cm,0,0>8*mm material {M_Cig}}
                        cylinder { <Bt*cm,0,0><(Bt*cm)+(1.5*cm),0,0>8*mm material {M_Cendre_Cig}}
                        translate y*.5
                }
#end           
    
#macro Megots(Qt,larg,lng)
union {
        #render concat ("Render Megots ","\n")        
        #declare i=0;
        #while (i<Qt)
                #declare t_x=rand(hasard)*larg;
                #declare t_z=rand(hasard)*lng+(i/8);
                object {Cigarette(Rand()*6.5)rotate y*Rand()*-360 scale <Rand()*2.5,1,1> translate <t_x,0.25,t_z> no_shadow}
                #declare i=i+1;
        #end
      //  scale 1.5
}
#end // macro_megot
   
#end //If_mego

//=======POOPDOG==========================

#declare M_Poopdog = 
   material  
   {   
      texture
      {      
         pigment
         {
            wrinkles
            color_map
            {
               [ 0.0     rgbft <0.1875, 0.1979, 0.0, 0.0, 0.0> ]
               [ 0.455516  rgbft <0.375, 0.2604, 0.2604, 0.0, 0.0> ]
               [ 0.864769  rgbft <0.5, 0.354167, 0.281233, 0.0, 0.0> ]
               [ 0.932384  rgbft <0.781233, 0.515625, 0.460925, 0.0, 0.0> ]
               [ 0.966192  rgbft <0.5729, 0.5, 0.5104, 0.0, 0.0> ]
               [ 1.0     rgbft <0.677067, 0.645833, 0.640617, 0.0, 0.0> ]
            }
            warp
            {
               turbulence <1.0, 1.0, 1.0>

            }
         }      
         normal
         {
            bozo , 2.0
            slope_map
            {
               [ 0.0  <1.0 , 1.0> ]
               [ 0.5  <0.0 , 0.0> ]
               [ 1.0  <1.0 , 0.0> ]
            }
         }      
         finish
         {
            ambient 0.1
            phong_size 0.0
            specular 0.143867
            roughness 0.097733
            crand 0.546733
         }
      }
   }


//----------------------------------
#declare i=1;
#declare Poopdog=
union {
#while (i>0)
#declare A=i;  
sphere {0,A  translate  <.2+A,0,0> rotate y*(A+.3)*360 translate y*A material{M_Poopdog }scale <1,.6,1>}
#declare i=i-.001;
#end
scale .06
}
//====Carton=========================
#declare M_Carton =
  material {
                  texture {
                        pigment { gradient x
                              color_map {  
                                 [ 0.0    color rgb <0.949,0.898,0.655> ]
                                 [ 1.0     rgb <0.666667, 0.670588, 0.427451> ]
                              }
                        }
                        finish { ambient 0.2 diffuse .5 phong .3}
                  }
               texture {T_Crasse scale .5  }
}                        
                                        
#declare Carton=
        union {
                box{<0,0,0><1,0.01,1.3>}
                cylinder {<0,0.02,0><0,0.02,1.3>0.03}
                cylinder {<0,0.02,0><0,0.02,1.3>0.03 translate x*.10}
                cylinder {<0,0.02,0><0,0.02,1.3>0.03 translate x*.20} 
                cylinder {<0,0.02,0><0,0.02,1.3>0.03 translate x*.30} 
                cylinder {<0,0.02,0><0,0.02,1.3>0.03 translate x*.40} 
                cylinder {<0,0.02,0><0,0.02,1.3>0.03 translate x*.25} 
                cylinder {<0,0.02,0><0,0.02,1.3>0.03 translate x*.50} 
                cylinder {<0,0.02,0><0,0.02,1.3>0.03 translate x*.60} 
                cylinder {<0,0.02,0><0,0.02,1.3>0.03 translate x*.70} 
                cylinder {<0,0.02,0><0,0.02,1.3>0.03 translate x*.80} 
                cylinder {<0,0.02,0><0,0.02,1.3>0.03 translate x*.90}
                box{<0,0.02,0><1,0.03,1.3> }   
                material {M_Carton}                                                             
        }
        
//====Bris_de_Glace===================

#declare F_Glass = finish {
  ambient 0.1
  diffuse 0.1
  reflection .8
  specular 1
  roughness 0.001
}

#declare T_Glass = texture {
  pigment {
    color rgbf <0.98, 1.0, 0.99, 0.99> 
  }
  finish {
    F_Glass 
  }
}

#declare T_Phare_Glass=texture {
  pigment {checker
    color rgbf <0.9, 1.0, 0.9, 0.9>,
    color rgbf <1.0, 1.0, 0.9, 0.9> 
  }
  finish {  
          ambient 0.1
          diffuse 0.1
          reflection .2
          specular 1
          roughness 0.001
  }
  scale .1
}

#declare T_Bris_Glass=texture {T_Glass}
                     // texture {T_Crasse scale .5}  
                     

//---------
#macro mcr_Bris(brs1,brs2)
        prism {
          linear_spline
          linear_sweep
          0.0,
          0.1,
          4,
          <0,0>,<0,brs1><brs2,0>,<0,0>
          scale .15
        }
#end

#declare Bout_de_Phare=
union {
difference {
        torus { .08,.05 }
        cylinder {<0,-.5,0><0,.5,0>.08}
        material {Mega_M_Chrome_5E}
} 
 cylinder {<0,.04,0><0,.045,0>.15 texture {T_Phare_Glass}}
}
#declare Pov_Enloliveur=height_field { png "enjoliv2.png"  
                        scale <.6,.05,.6> //103/101
                        water_level 0.5
                        smooth    material {Mega_M_Chrome_5E }
}


#declare i=0;
#declare Bris_Glass=
union {
#render "Render Bris de Glace \n" 
object {Pov_Enloliveur  rotate <-15,-45,0> translate <-1.0,0.2,0.6>} 
object {Bout_de_Phare  rotate <0,-45,0> translate <-1.3,0.2,0.6>} 
#while (i<300) 
object { mcr_Bris(rand(hasard)*.2,rand(hasard)*.2)  texture {T_Bris_Glass} translate <rand(hasard),0,rand(hasard)*1.2> rotate y*rand(hasard)*360}
#declare i=i+1;
#end 
}
//===========Feux Ar==========
#declare T_Bris_Feux=
                texture {
                     pigment {
                                leopard 
                                color_map{
                                [0.0 color rgbf <0.992,0.059,0.008,0.2>]
                                [1.0 color rgbf <0.957,0.957,0.957,0.2>]
                                }
                                scale .2
                     }
                     normal {leopard scale .2}
                         finish { ambient 0.3
                                  diffuse 0.6
                                  reflection .5
                                  specular 1
                                  roughness 0.01
                                }
} 

#macro mcr_Feux(Feux1,Feux2)
        prism {
          linear_spline
          linear_sweep
          0.0,
          0.2,
          4,
          <0,0>,<0,Feux1><Feux2,0>,<0,0>
          scale .35
        }
#end
#declare i=0;
#declare Bris_Feux=
union {
#render "Render Bris de Feux \n" 
#while (i<5) 
object { mcr_Feux(rand(hasard)*.5,rand(hasard)*0.4)  texture {T_Bris_Feux} translate <rand(hasard)*.8,0,rand(hasard)*.8> rotate y*rand(hasard)*360}
#declare i=i+1;
#end 
}
//===========Morceau de Verre=======
#declare F_Verre = finish {
  ambient 0.1
  diffuse 0.1
  reflection .8
  specular 1
  roughness 0.001
}


#declare T_Bris_Verre=texture {NBwinebottle}//{T_Verre}

//---------
#macro mcr_Verre(Verre1,Verre2)
        prism {
          linear_spline
          linear_sweep
          0.0,
          0.1,
          4,
          <0,0>,<0,Verre1><Verre2,0>,<0,0>
          scale .4
        }
#end

#declare i=0;
#declare Bris_Verre=
union {
#render "Render Bris de Verre \n" 
#while (i<200) 
object { mcr_Verre(rand(hasard)*.2,rand(hasard)*.2)  texture {T_Bris_Verre} translate <rand(hasard)*.8,0,rand(hasard)*.8> rotate y*rand(hasard)*360}
#declare i=i+1;
#end 
}


//===========AFFICHAGES===========================
#if (WkLu)light_source { 0*x rgb 2 translate <1000,2000,-1000>} #end
//================================================
union {
        //--------Route passage et plaque d'egout---
    difference {  
        #declare Trsl_Plaque=<(Cfx)+5.1,-.045,3.0>;
       union { 
               object { Fond      translate y*-0.5 hollow}
               #if(Rte)
               object { Route     translate x*(Cfx+6) hollow} 
               object { Route     rotate y*90 translate <0,0,-5> hollow }
               #end 
               object {Passage   translate <(Cfx)+6,0,1> }                
       }
        cylinder {<0,-1,0><0,1,0>LgTrou+.01 translate Trsl_Plaque}
    }                
        object {Plaque_Degout  translate Trsl_Plaque }
        
        //-------------
        
        object { Passage   rotate y* 90 translate <(Cfx)+11.85,0,-5> }
        object { Passage   rotate y*-90 translate <4,0,-5> }
        object { Passage2  translate <10,0,-6.0>}
        object { Trotoire1 translate x*1.0}  
        object { Trotoire2 translate x*0.8}
        object { Trotoire2 rotate y*90 translate <15,0,5>}
        object { Trotoire3 rotate y*90 translate <15,0,4>}
        //object {Poteaux_Rue  translate <16.7,10*cm,1.5>}
        
//-------LES BATIMENTS   
#if (Caf)  #include "cafe.inc"     object { Cafe translate y*10*cm} #end
#if (Gra)  #include "graph.inc"    object { Graph rotate y*-90 translate <Cfx,10*cm,Cfz>}  #end
#if (MStr) #include "mgastore.inc"    object { MegaStore translate <17,10*cm,4> } #end //<17,10*cm,4>
#if (Echf) #include "echfdag.inc"  object { Echafaudage translate <4.5,10*cm,Cfz+8.2> } #end
#if (Mur)  object { Mur_Travaux translate <4  ,10*cm,Cfz+8> }#end
#if (Ptmg) #include "petitmag.inc" object { Petit_Mag translate <Cfx+1,10*cm,38.4> } #end
#if (Au44) #include "au44.inc" object { au_44  translate <Cfx+1,10*cm,38.4+15>  }#end
//#if (Au44) #include "au44_bis.inc" object { Au44_bis  translate <Cfx+1,10*cm,38.4+15>  }#end

//--------
#if(Canet)
        object { Canette1 scale 1/5 rotate y*0 translate < 4,0.1,3.>}
        object { Canette2 scale 1/5 rotate y*0 translate < 7,0.0,0.>}
        object { Canette3 scale 1/5 rotate y*0 translate <11,0.0,0.>}
        object { Canette3 scale 1/5 rotate y*0 translate <13,0.1,0.>}
        object { Canette4 scale 1/5 rotate y*0 translate < 1,0.1,-2>}

#end
//----------Poubelle----------------------------
#if (Poubel)
     #include "poubelle.inc"
    //PouBelle(Poub,PoubRet,Ang_Poub,CouvHaut,CouvBas,CouvRet)    
    object { PouBelle(0,1,-10.,0,0,1)   translate <Cfx+9.6,10*cm,3.1> }  //trotoire de droite
    object { PouBelle(1,0,0.0,1,0,0)   translate <Cfx+9.7,10*cm,6.0> }
    
    object { PouBelle(1,0,0.0,0,0,0)   translate <Cfx+0.5,10*cm,2.9> }     // rive Gauche :-)      16
    object { PouBelle(1,0,0.0,1,0,0)   translate <Cfx+1.5,10*cm,14> }
    object { PouBelle(0,1,-30,0,0,0)   translate <Cfx+1.5,10*cm,13> }
    
#end
//-----------Sac-Poubelle------------------------
#if(Scp)
#include "sacp1.inc" 
#include "sacp2.inc"
object {Sacpoubelle1 scale .3 rotate <-80,-40,0> translate   <Cfx+9.5,30*cm,2.6>}//a droite
object {Sacpoubelle1 scale .3 translate   <Cfx+10.2,30*cm,2.0>}
object {Sacpoubelle2 scale .3 translate <Cfx+9.4,30*cm,1.8>}

object {Sacpoubelle1 scale .3 translate   <Cfx+1.4,30*cm,11.8>} //a Gauche translate <5.5,0,3.5>
object {Sacpoubelle2 scale .3 rotate <-85,-40,0> translate <Cfx+1.6,30*cm,12.0>  }
object {Sacpoubelle2 scale .3 rotate <20,0,20> translate   <Cfx+2.9,30*cm,10.8>} 
object {Sacpoubelle1 scale .3 translate  <Cfx+0.5,70*cm,2.9> } 
#end

#if (Papier) 
        object { Papiers translate <5,-.2,-20> no_shadow} 
        object { Papiers rotate y*90 translate <-10,-.2,0> no_shadow} 
#end   

#if (megot) 
        //Megots(Qt,larg,lng)
        object { Megots(500, 5,2)  translate <5,0.20,-5> no_shadow}
        object { Megots(300, 5,3)  translate <12,0.20,-5> no_shadow}
        object { Megots(300,10,3) rotate y*90 translate <-10,0.10,-5> no_shadow}
        object { Megots(100, 5,3)  translate <0,.12,0> no_shadow}      
#end   
//----3D M
//-------Chien---------
#if(Pit)
#include "pittbull.inc"
object { Pittbull scale .2 rotate y*-50 translate <0,.3,0> translate <5,.9,11>}  
#end    

//-------Monsieur avec Attache_Case---------
#if (Man4)
#include "man_4_mcr.inc"
object { Man_Case(40) translate <11,10*cm,3>  }
#end                                           
//----------Jaguar-------------------------
#if(Car)
#include "jaguard.inc"
object { Jaguar scale 0.4 rotate y*175 rotate z*-5 translate <7.5,1.5,16>}
#end
//----------Poopdog------------------------
#if(Crot)
union {
object { Poopdog  rotate y*90 translate <Cfx+1.8,10*cm,10.8> }
object { Poopdog  rotate y*45 translate <Cfx+1.9,10*cm,10.5> }
translate <.9,0,-2.5>
}
union {
object { Poopdog  rotate y*10 translate <Cfx+1.6,10*cm,0.6> }        
object { Poopdog  rotate y*90 translate <Cfx+1.8,10*cm,0.8> }
object { Poopdog  rotate y*45 translate <Cfx+1.9,10*cm,0.5> }
translate <.6,0,2.5>
}
union {
object { Poopdog  rotate y*20 translate <Cfx+1.6,10*cm,0.6> }        
object { Poopdog  rotate y*45 translate <Cfx+1.8,10*cm,0.8> }
object { Poopdog  rotate y*90 translate <Cfx+1.9,10*cm,0.5> }
translate <9,0,-2.0>
}
#end
//---------Evian---------------------
#if(Evi)
#include "evian.inc"
 object { Evian scale .05 rotate x*90 rotate y* 20 translate <7.3,.15,3.5>}
 object { Evian scale .05 rotate x*90 rotate y* 160 translate <15,.25,2>}
#end
//------Carton-----------------------------
object { Carton rotate <0,-10,0>  translate <Cfx+.8,.10,-1.0>}  
object { Carton rotate <0,-15,0>  translate <Cfx+.8,.13,-1.2>}
object { Carton rotate <0,-20,0>  translate <Cfx+.8,.16,-.9>}
object { Carton rotate <0,-25,0>  translate <Cfx+.8,.19,-1.3>}
object { Carton rotate <0,-30,0>  translate <Cfx+.8,.21,-.9>}
object { Carton rotate <0,-22,0>  translate <Cfx+.8,.24,-.9>}

//-----Bris de Glasse et de Verre-----------------
#if(BrsGl) object {Bris_Glass translate <8.0,0,-3.0> }
           object {Bris_Feux translate  <8.0,0,-3.0> }     
           object {Bris_Verre translate <8.0,0,1.8> }
           object {Bris_Verre translate <14.4,.10,1.1> }
#end


//-----Position de la rue ----------
        rotate y*15
        translate x*-5                           
}
//==========FIN_de_FICHIER========

