// Persistence of Vision Ray Tracer Scene Poubelle.inc
// autor Martial.Rameaux
#version unofficial Megapov 0.4;
//=============================    
#declare Render=0;
//=============================
#include "colors.inc"  
#include "hasard.inc"  
#include "Mega_metals.inc"
#include "etalon.inc"
//=============================
#declare T_P0=texture {
                                pigment {rgb <.90,.91,.90> }    
                                finish {ambient 0.3 
                                        diffuse 0.4 
                                        brilliance 1
                                        diffuse 0.3
                                        metallic
                                        reflection 0.05
                                        reflect_metallic
                                        blinn 2.0 
                                        facets 0.28
                                         }
}
 
#declare T_P1=texture {
                        pigment {
                                gradient x 
                                color_map {
                                           [0.0 rgbf <0.5,0.4,0.4,.5>]
                                           [Rand()*0.5 rgbf <1,1,1,1 >]  
                                           [Rand()*0.75 rgbf <.3,.3,0,.5 >]  
                                           [1.0 rgbf <0.5,0.2,0.1,0.4>]  
                                }
                                turbulence .9
                                octaves 10
                                omega   .5
                                lambda 2 
                        }
} 

#declare T_Poubelle=material{  
          texture {T_P0}
          texture {T_P1}
}   
           
                                         
#declare i=0;
#declare Crand   =union { 
        #while (i < 360 ) 
                          merge {     
                         sphere   { 0,5*cm }
                         cylinder { <0,0,0><0,60*cm,0>5*cm }
                         sphere   { 0,2*cm translate y*60*cm } 
                         translate <0,35*cm,60*cm>
                         rotate y*i 
                         material {T_Poubelle }
                         }
        #declare i=i+20;
        #end    
}
#declare Poignee=
        union {
                torus { 8*cm,3*cm 
                        clipped_by { 
                                box { <-12*cm,-12*cm,0><0,12*cm,12*cm>}
                        }    
                rotate x*-90   
                }
                cylinder { <0,0,0><8*cm,0,0>3*cm translate y*8*cm}
                torus { 8*cm,3*cm 
                        clipped_by { 
                                box { <-12*cm,-12*cm,0><0,12*cm,12*cm>}
                        }    
                rotate <-90,180,0> 
                translate x*8*cm  
                }
        }
        

                        
#declare Poubelle=
        union {      
       
              difference {  
              cone {<0,0,0>55*cm<0,1.2,0>61*cm } 
              cone {<0,10*cm,0>48*cm<0,1.5,0>59*cm } 
              object { Crand  }  
              }
              torus  { 61*cm,2*cm translate y*1.2} 
              torus  { 55*cm,2*cm }

              object { Poignee rotate <-90, 90,0> translate <-58*cm,100*cm,0>  }
              object { Poignee rotate <-90,-90,0> translate < 58*cm,100*cm,0>  }

              material {T_Poubelle }
            
        }       

#declare Couvercle_Poubelle=
        union {
               difference {
               sphere {0,61*cm }
               sphere {0,60*cm}
                        clipped_by {
                                    box {<-1,0,-1><1,1,1>}
                        }
                        scale <1,.25,1>
               }  
               torus { 61*cm,2*cm}
               
               difference {
               cylinder {<0,0,0><0,10*cm,0>64*cm} 
               cylinder {<0,-.02,0><0,21*cm,0>63*cm}  
               translate y*-10*cm
               }
               object { Poignee translate y*16*cm  }
                material {T_Poubelle } 
               
        }
        
#macro PouBelle(Poub,PoubRet,Ang_Poub,CouvHaut,CouvBas,CouvRet)
        union {             
            #if (PoubRet)  
                  object { Poubelle rotate rand(hasard)*y*-360 rotate x*-90 rotate y*Ang_Poub translate y*.608 } 
                  #declare Poub=0;
            #end
            #if(Poub) object {Poubelle} #end
            #if (CouvRet)  
                  object { Couvercle_Poubelle translate y*0.10 rotate x*-172 translate <150*cm,35*cm,0> } 
                  #declare CouvBas=0; 
                  #declare CouvHaut=0;  
            #end
            #if (CouvHaut) object { Couvercle_Poubelle translate y*1.2 } #declare CouvBas=0; #end    
            #if (CouvBas)  object { Couvercle_Poubelle translate <1.2,0.10,0>} #end
               
          scale .65 //   scale .75 
        }
        #end
      
//====================================
#if (Render)       

camera {location <0,1,-5> direction z*1.5 look_at 0}

light_source { 0*x rgb 1 translate <0,1000,-1000>}
background { Silver }       
plane {y,0 pigment { Gold}}
//===================================
// PouBelle(PoubRert,Poub,Ang_Poub_Ret,CouvHaut,CouvBas,CouvRert)
// If no Poubelle  then the Couvercle is on the flood 
// If Poubelle and Couvercle the Couverle is on the Poubelle
object { PouBelle(1,1,-10,1,1,1) }
//object { PouBelle(0,0,0,0,0,1) rotate rand(hasard)*y*-360 translate x*1.5}

//object {Couvercle_Poubelle translate y*105*cm}
#end // if Render       