 
landforms.mcr     8"D  P     ÁTEXTMPS          5	  贝2^                       V  // landforms.mcr

#debug "\rlandforms.mcr - macros to build landscapes.\r"

// Define the LandForm variables in the main file - use these samples:
//#declare LandFormMin=<-4080,    0,-4080>*ft;
//#declare LandFormMax=< 1360,   20, 4080>*ft;
//#declare LandFormScl=80*ft;
//#declare LandFormSeed=seed(4457);

// Calculate what's needed:
#declare LandFormXXX=(LandFormMax.x-LandFormMin.x)/LandFormScl;
#declare LandFormZZZ=(LandFormMax.z-LandFormMin.z)/LandFormScl;
// one boolean for every point in the area
#write(DebugFile,"Xsize=",LandFormXXX,", Zsize=",LandFormZZZ,"\n")
#declare LandFormInt=array[1+LandFormXXX][1+LandFormZZZ]
#declare LandFormHgt=array[1+LandFormXXX][1+LandFormZZZ]
#declare LandFormNrm=array[1+LandFormXXX][1+LandFormZZZ]
#local Xc=0;
#while (Xc<=LandFormXXX)
	#local Zc=0;
	#while (Zc<=LandFormZZZ)
		#declare LandFormInt[Xc][Zc]=0;
		#declare LandFormHgt[Xc][Zc]=<0,0,0>;
		#local Zc=Zc+1;
	#end
	#local Xc=Xc+1;
#end
/*
#declare LandForm
*/

// Define the LandForm macros
#macro LandFormSet(CoordHeight)
	#local XValue=floor(0.5+(CoordHeight.x-LandFormMin.x)/LandFormScl);
	#local ZValue=floor(0.5+(CoordHeight.z-LandFormMin.z)/LandFormScl);
	//#write(DebugFile,"XValue=",XValue,", ZValue=",ZValue,"\n")
	#declare LandFormInt[XValue][ZValue]=1;
	#declare LandFormHgt[XValue][ZValue]=CoordHeight;
#end

#macro LandFormGet(Coordinate)
	//#write(DebugFile,"LandFormGet(",Coordinate,")\n")
	#local XValue=(Coordinate.x-LandFormMin.x)/LandFormScl;
	#local XValueR=floor(0.5+XValue);
	#local ZValue=(Coordinate.z-LandFormMin.z)/LandFormScl;
	#local ZValueR=floor(0.5+ZValue);
	#if ((XValue=XValueR)&(ZValue=ZValueR)) //It's exactly on a ref. point
		//#write(DebugFile,"  Path: Exact point\n")
		#local YValue=LandFormHgt[XValue][ZValue];
	#else /*Average the nearest four - temporarily
		#local YValue=(LandFormHgt[XValue][ZValue]+LandFormHgt[XValue][ZValue+1]+
			LandFormHgt[XValue+1][ZValue]+LandFormHgt[XValue+1][ZValue+1])/4;*/
		//#write(DebugFile,"  Path: Calculated point\n")
		//Scale the nearest four, first in X to give two points, then scale them in Z
		#local fX=(Coordinate.x-LandFormMin.x)-XValueR*LandFormScl;
		#local fZ=(Coordinate.z-LandFormMin.z)-ZValueR*LandFormScl;
		//#write(DebugFile,"  fX=",fX,", fZ=",fZ,"\n")
		#local Ht1=(LandFormHgt[XValue+1][ZValue].y-LandFormHgt[XValue][ZValue].y)/LandFormScl*fX+LandFormHgt[XValue][ZValue].y;
		#local Ht2=(LandFormHgt[XValue+1][ZValue+1].y-LandFormHgt[XValue][ZValue+1].y)/LandFormScl*fX+LandFormHgt[XValue][ZValue+1].y;
		//#write(DebugFile,"  Ht1=",Ht1,", Ht2=",Ht2,"\n")
		#local YValue=<0,(Ht2-Ht1)/LandFormScl*fZ+Ht1,0>;
	#end
	//#write(DebugFile,"  Result=",YValue.y,"\n")
  <Coordinate.x,YValue.y,Coordinate.z>
  //<Coordinate.x,Coordinate.y,Coordinate.z>
#end

#macro LandFormAdjust(CoordHeight,Radius)
	//Find coordinate of centre
	#local XValue=floor(0.5+(CoordHeight.x-LandFormMin.x)/LandFormScl);
	#local ZValue=floor(0.5+(CoordHeight.z-LandFormMin.z)/LandFormScl);
	//#write(DebugFile,"XValue=",XValue,", ZValue=",ZValue,"\n")
	#local Direction=CoordHeight.y-LandFormHgt[XValue][ZValue].y;
	#if (Direction=0) //There's nothing to do, stop now.
		#debug "\rNo change in LandFormAdjust\r"
		//#write(DebugFile,"\nNo change: LandFormAdjust(",CoordHeight,",",Radius,")\n")
	#else
		#local YY=1;//raise each layer recursively
		#while (YY<=Radius)
			#local ZZ=ZValue-Radius+YY;
			#while (ZZ<=ZValue+Radius-YY)
				#local XX=XValue-Radius+YY;
				#while (XX<=XValue+Radius-YY)
					//#write(DebugFile,"\nAdjust: (",XX,",",ZZ,") -> ",YY)
					#local NewHeight=Direction/(Radius+1)*(0.5+rand(LandFormSeed))*YY;
					#if ((XX>=0)&(XX<=LandFormXXX)&(ZZ>=0)&(ZZ<=LandFormZZZ))
						#declare LandFormInt[XX][ZZ]=1;
						#if (Direction>0)
							#declare LandFormHgt[XX][ZZ]=LandFormHgt[XX][ZZ]+max(0,NewHeight);
						#else
							#declare LandFormHgt[XX][ZZ]=LandFormHgt[XX][ZZ]+min(0,NewHeight);
						#end
					#end
					#local XX=XX+1;
				#end
				#local ZZ=ZZ+1;
			#end
			#local YY=YY+1;
		#end
	#end
#end

/* Write out a file of LandFormSet values as the basis for editing.
  Filename: To be created; any existing file of this name will be overwritten.
	Minxz:    vector <least X value,ignored,least Z value> (will be multiplied by ft)
	Maxxz:    vector <biggest X value,standard Y value,biggest Z value> (will be multiplied by ft)
// Used:
	LandFormScl: Spacing between points.
*/
#macro LandFormBlockWrite(Filename,Minxz,Maxxz)
	#local Minx=Minxz.x;#local Minz=Minxz.z;
	#local Maxx=Maxxz.x;#local YY=Maxxz.y;#local Maxz=Maxxz.z;
	#local Inc=LandFormScl/ft;
  #fopen LandFormFile Filename write
	// Header
	#write(LandFormFile,"// ",Filename,"\n\n#debug \"\\r",Filename," - Build ? for the village.\\r\"\n\n")
	#write(LandFormFile,"// N-S scale: position ?; E-W scale: position ?.\n")
	#write(LandFormFile,"// <",Minx,",    ?,",Minz,">*ft to <",Maxx,",    ?,",Maxz,">*ft\n\n//\n")
	// Body of file
	#local ZZ=Minz;
	#while (ZZ<=Maxz)
		#local XX=Minx;
		#while (XX<=Maxx)
			#write(LandFormFile,"LandFormSet(<",str(XX,6,0),",",str(YY,6,0),",",str(ZZ,6,0),">*ft)\n")
			#local XX=XX+Inc;
		#end
		#write(LandFormFile,"//\n")
		#local ZZ=ZZ+Inc;
	#end
	#fclose LandFormFile
#end


/*
	Dstyle: Drawing style: 0 height points, 1 lines only, 2 triangle, 3 smooth_triangle
*/
#macro LandFormDraw(Dstyle)
	#if (Dstyle=0)
		#local Xc=0;
		#while (Xc<=LandFormXXX)
			#local Zc=0;
			#while (Zc<=LandFormZZZ)
				#if (LandFormInt[Xc][Zc]=1)
					cylinder{
						LandFormHgt[Xc][Zc]*<1,0,1>-<0,10,0>,LandFormHgt[Xc][Zc],5*yd
						texture{Ground}
					}
				#else
					cylinder{
						<Xc*LandFormScl,0,Zc*LandFormScl>,<Xc*LandFormScl,500*ft,Zc*LandFormScl>,5*yd
						texture{pigment{colour rgb <1,.25,.25>}}
					}
				#end
				#local Zc=Zc+1;
			#end
			#local Xc=Xc+1;
		#end
	#end
	#local Xc=0;
	#while (Xc<LandFormXXX)
		#local Zc=0;
		#while (Zc<LandFormZZZ)
		  #if ((LandFormInt[Xc][Zc]=1)&(LandFormInt[Xc][Zc+1]=1)&(LandFormInt[Xc+1][Zc]=1)&(LandFormInt[Xc+1][Zc+1]=1))
				#if (Dstyle=1)
					cylinder{
						LandFormHgt[Xc][Zc],LandFormHgt[Xc][Zc+1],1*yd
						texture{Ground}
					}
					cylinder{
						LandFormHgt[Xc][Zc],LandFormHgt[Xc+1][Zc],1*yd
						texture{Ground}
					}
					cylinder{
						LandFormHgt[Xc][Zc+1],LandFormHgt[Xc+1][Zc+1],1*yd
						texture{Ground}
					}
					cylinder{
						LandFormHgt[Xc+1][Zc],LandFormHgt[Xc+1][Zc+1],1*yd
						texture{Ground}
					}
				#end
				#if (Dstyle=2)
					triangle{
						LandFormHgt[Xc][Zc],LandFormHgt[Xc][Zc+1],LandFormHgt[Xc+1][Zc]
						texture{Ground}
					}
					triangle{
						LandFormHgt[Xc][Zc+1],LandFormHgt[Xc+1][Zc],LandFormHgt[Xc+1][Zc+1]
						texture{Ground}
					}
				#end
				#if (Dstyle=3)
					smooth_triangle{
						LandFormHgt[Xc][Zc],LandFormNrm[Xc][Zc],
						LandFormHgt[Xc][Zc+1],LandFormNrm[Xc][Zc+1],
						LandFormHgt[Xc+1][Zc],LandFormNrm[Xc+1][Zc]
						texture{Ground}
					}
					smooth_triangle{
						LandFormHgt[Xc][Zc+1],LandFormNrm[Xc][Zc+1],
						LandFormHgt[Xc+1][Zc],LandFormNrm[Xc+1][Zc],
						LandFormHgt[Xc+1][Zc+1],LandFormNrm[Xc+1][Zc+1]
						texture{Ground}
					}
				#end
			#end
			#local Zc=Zc+1;
		#end
		#local Xc=Xc+1;
	#end
#end

// This assumes all points exist, and doesn't check.
#macro LandFormNormalise()
	#local Xc=1;
	#while (Xc<=LandFormXXX-1)
		#local Zc=1;
		#while (Zc<=LandFormZZZ-1)
			#declare LandFormNrm[Xc][Zc]=vcross(
				(LandFormHgt[Xc+1][Zc+1]-LandFormHgt[Xc-1][Zc-1]),
				(LandFormHgt[Xc-1][Zc+1]-LandFormHgt[Xc+1][Zc-1])
			);
			#local Zc=Zc+1;
		#end
		#local Xc=Xc+1;
	#end
	//patch the edges - copy the adjacent normals over.
	#local Xc=1;
	#while (Xc<=LandFormXXX-1)
		#declare LandFormNrm[Xc][0]=LandFormNrm[Xc][1];
		#declare LandFormNrm[Xc][LandFormZZZ]=LandFormNrm[Xc][LandFormZZZ-1];
		#local Xc=Xc+1;
	#end
	#local Zc=1;
	#while (Zc<=LandFormZZZ-1)
		#declare LandFormNrm[0][Zc]=LandFormNrm[1][Zc];
		#declare LandFormNrm[LandFormXXX][Zc]=LandFormNrm[LandFormXXX-1][Zc];
		#local Zc=Zc+1;
	#end
	//patch the corners
		#declare LandFormNrm[0][0]=(LandFormNrm[1][0]+LandFormNrm[0][1])/2;
		#declare LandFormNrm[LandFormXXX][0]=(LandFormNrm[LandFormXXX-1][0]+LandFormNrm[0][1])/2;
		#declare LandFormNrm[0][LandFormZZZ]=(LandFormNrm[1][LandFormZZZ]+LandFormNrm[0][LandFormZZZ-1])/2;
		#declare LandFormNrm[LandFormXXX][LandFormZZZ]=(LandFormNrm[LandFormXXX-1][LandFormZZZ]+LandFormNrm[LandFormXXX][LandFormZZZ-1])/2;
#end

/*
	Dstyle: Drawing style - 0 centre points, 1 road, 2 road with pavement on right,
		3 road with pavement on left, 4 road with both pavements
	Width and RTexture are array[3] 0 road 1 right pavement 2 left pavement
*/
#macro DrawRoad(vFrom,vTo,iWidth,Dstyle,RTexture)
	// How long is the road section?
	#local Temp=vTo-vFrom;#local Temp2=sqrt(Temp.x*Temp.x+Temp.z*Temp.z);
	#write(DebugFile,"Offsets are ",Temp,"\n")
	#write(DebugFile,"Size is ",Temp2,"\n")
	#if (vTo.z<=vFrom.z)
		#local Adj=-180;
	#else
		#local Adj=0;
	#end
	#if (Temp2>100*yd)
		#write(DebugFile,"Needs splitting.\n")
	#end
	#switch (Dstyle)
	#case (0)
		//cylinder{vFrom,vTo,iWidth/2 texture{pigment{Red}}}
		cylinder{vFrom-<0,50,0>*ft,vFrom+<0,50,0>*ft,1*ft texture{pigment{Red}}}
		cylinder{vFrom-<0,0,0.5>*ft,vTo-<0,0,0.5>*ft,0.5*ft texture{pigment{Red}}}
		cylinder{vTo-<0,50,0>*ft,vTo+<0,50,0>*ft,1*ft texture{pigment{Red}}}
		union{
			cylinder{//mark ends
				vFrom-<iWidth/2,0,0>,vFrom+<iWidth/2,0,0>,1*ft texture{pigment{Red}}
				translate -vFrom
			}
			cylinder{//mark ends
				vTo-<iWidth/2,0,0>,vTo+<iWidth/2,0,0>,1*ft texture{pigment{Red}}
				translate -vFrom // yes - vFrom is the origin for the rotations
			}
			rotate -x*degrees(asin(Temp.y/Temp2))
			rotate y*(degrees(atan2(Temp.x/Temp.z,1))+Adj)
			translate vFrom
		}
	#break
	#case (1)
		box{
		  <-iWidth/2,-48*in,-iWidth/5>,<iWidth/2,1*in,Temp2+iWidth/5>
			rotate -x*degrees(asin(Temp.y/Temp2))
			rotate y*(degrees(atan2(Temp.x/Temp.z,1))+Adj)
			translate vFrom
			texture{RTexture}
		}
	#break
	Dstyle: Drawing style - 0 centre points, 1 road, 2 road with pavement on right,
		3 road with pavement on left, 4 road with both pavements
	Width and RTexture are array[3] 0 road 1 right pavement 2 left pavement
	#range (2,4)
		union{
			box{// Road always present
				<-iWidth[0]/2,-48*in,-iWidth[0]/5>,<iWidth[0]/2,1*in,Temp2+iWidth[0]/5>
				texture{RTexture[0]}
			}
			// Right pavement
			#if ((Dstyle=2)|(Dstyle=4))
				box{
					<iWidth[0]/2.1,-48*in,0>,<iWidth[0]/2+iWidth[1],4*in,Temp2>
					texture{RTexture[1]}
				}
			#end
			// Left pavement
			#if ((Dstyle=3)|(Dstyle=4))
				box{
					<-iWidth[0]/2.1,-48*in,0>,<-iWidth[0]/2-iWidth[2],4*in,Temp2>
					texture{RTexture[2]}
				}
			#end
			rotate -x*degrees(asin(Temp.y/Temp2))
			rotate y*(degrees(atan2(Temp.x/Temp.z,1))+Adj)
			translate vFrom
		}
	#break
	#end
#end

/*
	Dstyle: Drawing style - 0 centre points, 1 wall
*/
#macro DrawWall(vFrom,vTo,iWidth,iHeight,Dstyle,RTexture)
	// How long is the wall section?
	#local Temp=vTo-vFrom;#local Temp2=sqrt(Temp.x*Temp.x+Temp.z*Temp.z);
	//#write(DebugFile,"Offsets are ",Temp,"\n")
	//#write(DebugFile,"Size is ",Temp2,"\n")
	#if (vTo.z<=vFrom.z)
		#local Adj=-180;
	#else
		#local Adj=0;
	#end
	#if (Temp2>100*yd)
		#write(DebugFile,"Needs splitting.\n")
	#end
	#switch (Dstyle)
	#case (0)
		//cylinder{vFrom,vTo,iWidth/2 texture{pigment{Red}}}
		cylinder{vFrom-<0,50,0>*ft,vFrom+<0,50,0>*ft,1*ft texture{pigment{Red}}}
		cylinder{vFrom-<0,0,0.5>*ft,vTo-<0,0,0.5>*ft,0.5*ft texture{pigment{Red}}}
		cylinder{vTo-<0,50,0>*ft,vTo+<0,50,0>*ft,1*ft texture{pigment{Red}}}
	#break
	#case (1)
		box{
		  <-iWidth/2,-24*in,0>,<iWidth/2,iHeight,Temp2>
			rotate -x*degrees(asin(Temp.y/Temp2))
			rotate y*(degrees(atan2(Temp.x/Temp.z,1))+Adj)
			translate vFrom
			texture{RTexture}
		}
	#break
	#end
#end

/*
	Locn: The basic location, though there's a random offset
	Rotn: Rotation, though there's a random offset
	Dstyle: 0 sphere 1 marker of random style
*/
#macro GraveStone(Locn,Rotn,Dstyle)
  #local Locn=Locn+6*in*<-1+rand(GravePos),-1+rand(GravePos),-1+rand(GravePos)>;
  #local Rotn=Rotn+10*<-1+rand(GraveRtn),-1+rand(GraveRtn),-1+rand(GraveRtn)>;
	#if (Dstyle=0)
	  sphere{<0,0,0>,12*in texture{pigment{Red}} rotate Rotn translate Locn}
	#else
		#local WhichGrave=floor(0.5+10*rand(GraveStyle));
		#switch (WhichGrave)
		#case (1)
		#case (4)
		#case (7)
			//straight stone
		  box{<-1.5,-1,-0.25>*ft,<1.5,4,0.25>*ft texture{WallStone} rotate Rotn translate Locn}
		#break
		#case (2)
		#case (5)
		#case (8)
			//curved-topped stone
			union{
				box{<-1.5,-1,-0.25>*ft,<1.5,3.5,0.25>*ft}
				cylinder{
					<-1.5,0,-0.25>*ft,<1.5,0,0.25>*ft,1*ft
					scale <1.5,0.5,1> translate <0,3.5,0>*ft
				}
				texture{Stone} rotate Rotn translate Locn
			}
		#break
		#case (3)
		#case (6)
		#case (9)
		#case (10)
			//cross
			union{
				box{<-1.5,2.5,-0.25>*ft,<1.5,3,0.25>*ft}
				box{<-0.5,-1,-0.25>*ft,<0.5,4,0.25>*ft}
				texture{Stone} rotate Rotn translate Locn
			}
		#break
		#else //if it gets here, I slipped up!
		  box{<-1.5,-1,-0.25>*ft,<1.5,4,0.25>*ft texture{Stone} rotate Rotn translate Locn}
		#end
	#end
#end

#macro SomeTree(Locn,Rotn,Dstyle)
  #if (Dstyle=0)
		cone{Locn,0,Locn+<0,40,0>*ft,5*ft texture{Foliage2}}
	#else
		union{
			cylinder{Locn,Locn+<0,20,0>*ft,5*ft}
			#local Turn=floor(0.5+30*rand(TreeVal));
			#while (Turn<360)
				cylinder{
					Locn+<0,20,0>*ft,Locn+<0,35,0>*ft,2*ft
					rotate x*floor(40.5+40*rand(TreeVal))
					rotate y*Turn
				}
				#local Turn=Turn+floor(0.5+30*rand(TreeVal));
			#end
			texture{Trunk}
		}
	#end
#end

#debug "\r----\rEnd of landscape building\r----\r"
                                                                                                                                  R                              
landforms.mcr-180Apr 20009t com TEXTMPS                       5	   s t        iM
U                            TEXTMPS                                                              $  6 , 7                           H 	Monaco  Bu the village.\r"    6  62^  4P  4P  1      6  6  1                     R@E    R MPSR  NwPo   *   (       t>$                                 