 offices.mcr       8"D  P J    ÁTEXTMPS  
          @uе2@                       	;  // Persistence Of Vision INCLUDE file
// File:        offices.mcr
// Vers:        3.1g.r1 Mac PPC
// Desc:        Office buildings
// Auth:        Peter Murray

#debug "\r  offices.mcr - Office buildings.\r"

// Measurements might already be defined.
#ifndef(in)
	#declare in = 1;
	#declare ft = 12;
#end

#local LightLevel=10;
#declare LightS=seed(2246);
#declare GroundF=seed(1630);

#declare TudorWood=
texture{
	pigment{colour rgb <0.05,0.05,0.05>}
}

#declare TudorPlaster=
texture{
	pigment{colour rgb <0.85,0.85,0.75>}
}

/*
#declare FluoFitting=
union{
  cylinder{//tube
    <-1.5*ft,0,0>,<1.5*ft,0,0>,1*in
    texture{
      pigment{colour rgb <.8,.8,.8>}
      finish{ambient 1.5}
    }
  }
  cylinder{//end fittings
    <-1.5*ft,0,0>,<-1.75*ft,0,0>,1.2*in
  }
  box{
    <-1.5*ft,0,-1.2*in>,<-1.75*ft,1.2*in,1.2*in>
  }
  cylinder{
    <1.5*ft,0,0>,<1.75*ft,0,0>,1.2*in
  }
  box{
    <1.5*ft,0,-1.2*in>,<1.75*ft,1.2*in,1.2*in>
  }
  box{
    <-1.75*ft,1.2*in,-1.2*in>,<1.75*ft,2*in,1.2*in>
  }
  texture{
    pigment{colour rgb <.7,.73,.7>}
  }
}

#macro FluoLight(lightlevel)
	#if ((lightlevel=0)|((10*rand(LightS))>lightlevel))
		object{FluoFitting}
	#else
		light_source{
			<0,9*ft-2*in,0> colour rgb <.75,.8,.75> looks_like{FluoFitting}
			fade_distance 5*ft fade_power 1
		}
	#end
#end

#declare LightFitting=
union{
  cylinder{
    <0,.2*in,0>,<0,.5*in,0>,.4*in
    texture{
      pigment{colour rgb <.6,.6,.6>}
    }
  }
  cylinder{
    <0,.1*in,0>,<0,2*in,0>,.1*in
    texture{
      pigment{colour rgb <.6,.6,.6>}
    }
  }
  cone{
    <0,1.9*in,0>,.3*in,<0,2*in,0>,.4*in
    texture{
      pigment{colour rgb <.6,.6,.6>}
    }
  }
  sphere{
    <0,0*in,0>,.75*in scale <1,.5,1>
    texture{
      pigment{colour rgb <.8,.8,.8>}
      finish{ambient 1.5}
    }
  }
}

#declare CeilingLight=
light_source{
  <0,7.75*ft,0> colour rgb <.8,.8,.75> looks_like{LightFitting}
  fade_distance 4*ft fade_power 2
}
*/

#declare OldBlock=
union{
	difference{
		box{
			<-5,0,-5>*ft,<5,10,5>*ft
		}
		box{<-6,1,-4.5>*ft,<6,9,4.5>*ft}
		box{<-4.5,1,-6>*ft,<4.5,9,6>*ft}
		box{<-4,-1,-4>*ft,<4,9,4>*ft}
		texture{pigment{colour rgb <.6,.6,.6>}}
	}
	//object{FluoLight(LightLevel)}
}

#declare TenBlock=
union{
	difference{
		box{
			<-5,0,-5>*ft,<5,10,5>*ft
		}
		box{<-5.5,0.01,-5.5>*ft,<5.5,9,5.5>*ft}
		//box{<-5.5,8.9,-5.5>*ft,<5.5,10.5,5.5>*ft}
		//box{<-4.5,-1,-4.5>*ft,<4.5,1,4.5>*ft}
		texture{pigment{colour rgb <.6,.6,.6>}}
	}
	/*
	sphere{<-5,0,-5>*ft,6*in texture{pigment{colour rgb <.1,.1,.1>}}}
	sphere{< 5,0,-5>*ft,6*in texture{pigment{colour rgb <.1,.1,.1>}}}
	sphere{<-5,0, 5>*ft,6*in texture{pigment{colour rgb <.1,.1,.1>}}}
	sphere{< 5,0, 5>*ft,6*in texture{pigment{colour rgb <.1,.1,.1>}}}
	*/
	//object{FluoLight(LightLevel)}
}

#declare DoorBlock=
union{
	difference{
		box{<-5,0,4.5>*ft,<5,10,5>*ft}//wall
		box{<-1.5,.25,4>*ft,<1.5,7,5.5>*ft}//door
		box{<2.5,.25,4>*ft,<5.5,7,5.5>*ft}//door
	}
	box{<-5,9,-5>*ft,<5,10,5>*ft}
	box{<-5.5,0,-5>*ft,<-4.5,10,-4>*ft}
	box{<5.5,9,-5>*ft,<4.5,10,-4>*ft}
	box{<-5.5,0,5>*ft,<-4.5,10,4>*ft}
	box{<5.5,7,5>*ft,<4.5,10,4>*ft}
	// reception desk
	box{<-1,0,10.25>*ft,<5,3,10>*ft texture{pigment{colour rgb <.25,.2,.15>}}}
	box{<-1,0,10>*ft,<-0.75,3,12>*ft texture{pigment{colour rgb <.25,.2,.15>}}}
	box{<-1.125,3,9.875>*ft,<5,3.25,12.125>*ft texture{pigment{colour rgb <.35,.3,.25>}}}
	//object{FluoLight(LightLevel)}
	texture{pigment{colour rgb <.6,.6,.6>}}
}

#declare GroundCorner=
union{
	box{<-5,9,-5>*ft,<5,10,5>*ft}
	box{<-5.5,0,-5>*ft,<-4.5,10,-4>*ft}
	box{<5.5,0,-5>*ft,<4.5,10,-4>*ft}
	box{<-5.5,0,5>*ft,<-4.5,10,4>*ft}
	box{<5.5,0,5>*ft,<4.5,10,4>*ft}
	texture{pigment{colour rgb <.6,.6,.6>}}
}

#macro GroundFront(Style)
union{
	#write(DebugFile,"Style: ",Style,"\n")
	difference{
		box{<-5,0,4.5>*ft,<5,10,5>*ft}//wall
		box{<-3,4,4>*ft,<3,7,5.5>*ft}//window
		cylinder{<-3,4,4.75>*ft,<3,4,4.75>*ft,3*in}
	}
	box{<-5,9,-5>*ft,<5,10,5>*ft}
	box{<-5.5,0,-5>*ft,<-4.5,10,-4>*ft}
	box{<5.5,0,-5>*ft,<4.5,10,-4>*ft}
	box{<-5.5,0,5>*ft,<-4.5,10,4>*ft}
	box{<5.5,0,5>*ft,<4.5,10,4>*ft}
	//object{FluoLight(LightLevel)}
	difference{
		box{<-5,0,14.5>*ft,<5,10,15>*ft}
		#switch (Style)
		#range (0,10)
		  box{<-1.25,0.08,14.25>*ft,<1.25,7,15.25>*ft}
		  box{<-4.5,3.5,14.25>*ft,<-1.5,7,15.25>*ft}
		  box{<4.5,3.5,14.25>*ft,<1.5,7,15.25>*ft}
		#end
	}
	texture{pigment{colour rgb <.6,.6,.6>}}
}
#end

#declare GroundBlock=
union{
	cylinder{
		<-5,0,5>*ft,<-5,10,-5>*ft,6*in
	}
	cylinder{
		<5,0,5>*ft,<5,10,-5>*ft,6*in
	}
	//object{FluoLight(LightLevel)}
	texture{pigment{colour rgb <.6,.6,.6>}}
}

#declare LiftBlock=
union{
	difference{
		box{<-5,0,-5>*ft,<5,10,5>*ft}
		box{<-4.75,-0.5,-4.75>*ft,<4.75,10.5,4.75>*ft}
		box{<-4,0.08,-5.5>*ft,<-1,7.5,-4.5>*ft}
		box{<4,0.08,-5.5>*ft,<1,7.5,-4.5>*ft}
	}
	box{<-4,0.08,-4.9>*ft,<-1,7.5,-4.8>*ft texture{finish{Metal} pigment{colour rgb .8}}}
	box{<4,0.08,-4.9>*ft,<1,7.5,-4.8>*ft texture{finish{Metal} pigment{colour rgb .8}}}
	texture{pigment{colour rgb <.6,.6,.6>}}
}

#declare Corner=
cylinder{
	<5,0,5>*ft,<-5,10,-5>*ft,6*in
	texture{pigment{colour rgb <.6,.6,.6>}}
}

#declare UpperFront=
union{
	difference{
		box{<-5,0,-4.25>*ft,<5,10,-4.75>*ft}//wall
		box{<-3,3.5,-4>*ft,<3,8,-5>*ft}//window
		cylinder{
			<-3,3.5,-4.5>*ft,<3,3.5,-4.5>*ft,3*in
			texture{pigment{colour rgb <.6,.5,.5>}}
		}
	}
	box{<-5,9,-5>*ft,<5,10,5>*ft}
	box{<-5.5,0,-5>*ft,<-4.5,10,-4>*ft}
	box{<5.5,0,-5>*ft,<4.5,10,-4>*ft}
	difference{
		box{<-5,0,14.5>*ft,<5,10,15>*ft}
		box{<-1.25,0.08,14.25>*ft,<1.25,7,15.25>*ft}
		box{<-4.5,3.5,14.25>*ft,<-1.5,7,15.25>*ft}
		box{<4.5,3.5,14.25>*ft,<1.5,7,15.25>*ft}
		translate <0,0,-5>*ft
		texture{pigment{colour rgb <.6,.6,.6>} finish{ambient 0.8}}
	}
	//object{FluoLight(LightLevel)}
	texture{pigment{colour rgb <.6,.6,.6>}}
}

#declare UpperCorner=
union{
	difference{
		box{<-5,0,-4.25>*ft,<5,10,-4.75>*ft}//front wall
		box{<-3,3.5,-4>*ft,<3,8,-5>*ft}//window
		cylinder{
			<-3,3.5,-4.5>*ft,<3,3.5,-4.5>*ft,3*in
			texture{pigment{colour rgb <.6,.5,.5>}}
		}
	}
	difference{
		box{<-4.25,0,-5>*ft,<-4.75,10,5>*ft}//side wall
		box{<-4,3.5,-3>*ft,<-5,8,3>*ft}//window
		cylinder{
			<-4.5,3.5,-3>*ft,<-4.5,3.5,3>*ft,3*in
			texture{pigment{colour rgb <.6,.5,.5>} finish{ambient 0.8}}
		}
	}
	box{<-5,9,-5>*ft,<5,10,5>*ft}
	box{<-5.5,0,-5>*ft,<-4.5,10,-4>*ft}
	box{<5.5,0,-5>*ft,<4.5,10,-4>*ft}
	box{<-5,0,4.5>*ft,<-4,10,5.5>*ft}
	//object{FluoLight(LightLevel) rotate y*45}
	texture{pigment{colour rgb <.6,.6,.6>}}
}

#declare OffFront=object{GroundFront(int(0.5+10*rand(GroundF)))}
#declare OffRear=GroundFront(int(0.5+10*rand(GroundF)))
#declare OffSide=GroundFront(int(0.5+10*rand(GroundF)))

#declare Shop1Block=
union{
	difference{
		box{<-2.5,0,-2.5>*ft,<2.5,8,2.5>*ft}
		//box{<-2.75,0.08,-2.25>*ft,<2.75,7.75,2.25>*ft}
		//box{<-2.25,0.08,-2.75>*ft,<2.25,7.75,2.75>*ft}
		box{<-2.75,0.08,-2.75>*ft,<2.75,7.75,2.75>*ft}
		texture{Brick}
	}
	//object{CeilingLight}
}

#declare Shop1Front=
union{
	difference{
		box{<-2.5,0,-2.5>*ft,<2.5,8,2.5>*ft}
		box{<-2.75,0.08,-2.25>*ft,<2.75,7.75,2.75>*ft}
		box{<-2.25,2,-2.75>*ft,<2.25,6,-2>*ft}//window
		texture{Brick}
	}
	box{<-2.5,0.08,-2.25>*ft,<2.5,2,2.25>*ft texture{StructureWood}}//shelf
	//object{CeilingLight}
}

#declare Shop1Side=
union{
	difference{
		box{<-2.5,0,-2.5>*ft,<2.5,8,2.5>*ft}
		box{<-2.75,0.08,-2.25>*ft,<2.75,7.75,2.75>*ft}
		texture{Brick}
	}
	//object{CeilingLight}
}

#declare Shop1Corner=
union{
	difference{
		box{<-2.5,0,-2.5>*ft,<2.5,8,2.5>*ft}
		box{<-2.25,0.08,-2.25>*ft,<2.75,7.75,2.75>*ft}
		box{<-2.25,2,-2.75>*ft,<2.75,6,2.75>*ft}//window
		texture{Brick}
	}
	box{<-2.25,0.08,-2.25>*ft,<2.5,2,2.25>*ft texture{StructureWood}}//shelf
	//object{CeilingLight}
}

#declare Shop1UCorner=
union{
	difference{
		box{<-2.5,0,-2.5>*ft,<2.5,8,2.5>*ft}
		box{<-2.25,0.08,-2.25>*ft,<2.75,7.75,2.75>*ft}
		box{<-1.5,3.5,-2.75>*ft,<1.5,6,2.75>*ft}//window
		texture{Brick}
	}
	//object{CeilingLight}
}

#declare Shop1Door=//single central door
union{
	difference{
		box{<-2.5,0,-2.5>*ft,<2.5,8,2.5>*ft}
		box{<-2.25,0.08,-2.75>*ft,<2.25,6.5,2.25>*ft}
		box{<-1.5,0.25,2>*ft,<1.5,6.25,2.75>*ft}//door
		box{<-2.75,2,-2.25>*ft,<-2,6,2>*ft}//window
		box{<2.75,2,-2.25>*ft,<2,6,2>*ft}//window
		texture{Brick}
	}
	//object{CeilingLight}
}

#declare Shop1DoorR=//door at front-right
union{
	difference{
		box{<-2.5,0,-2.5>*ft,<2.5,8,2.5>*ft}
		box{<-2.25,0.08,-2.75>*ft,<2.25,6.5,2.25>*ft}
		box{<-1.5,0.25,2>*ft,<1.5,6.25,2.75>*ft}//door
		box{<-2.75,2,-2.25>*ft,<-2,6,2>*ft}//window
		texture{Brick}
	}
	//object{CeilingLight}
}

#declare Shop1DoorL=//door at front-left
union{
	difference{
		box{<-2.5,0,-2.5>*ft,<2.5,8,2.5>*ft}
		box{<-2.25,0.08,-2.75>*ft,<2.25,6.5,2.25>*ft}
		box{<-1.5,0.25,2>*ft,<1.5,6.25,2.75>*ft}//door
		box{<2.75,2,-2.25>*ft,<2,6,2>*ft}//window
		texture{Brick}
	}
	//object{CeilingLight}
}

#declare Shop1DoorH=//door at front-left
union{
	difference{
		box{<-2.5,0,-2.5>*ft,<2.5,8,2.5>*ft}
		box{<-2.25,0.08,-2.75>*ft,<2.25,6.5,2.25>*ft}
		box{<-1.5,0.25,2>*ft,<1.5,6.25,2.75>*ft}//door
		texture{Brick}
	}
	box{<-1.5,0.25,2.125>*ft,<1.5,6.25,2.375>*ft texture{DoorWood}}//door
	//object{CeilingLight}
}

#declare Shop1DoorW=//wide central door
union{
	difference{
		box{<-2.5,0,-2.5>*ft,<2.5,8,2.5>*ft}
		box{<0.25,0.08,-2.75>*ft,<2.75,6,2.25>*ft}
		box{<1,0.25,2>*ft,<4,5.9,2.75>*ft}//door
		box{<-2.75,0.08,-2.25>*ft,<0,7.75,2.75>*ft}
		box{<-2.75,2,-2.75>*ft,<0.5,6,2>*ft}//window
		texture{Brick}
	}
	box{<-2.5,0.08,-2.25>*ft,<0,2,2.25>*ft texture{StructureWood}}//shelf
	//object{CeilingLight}
}

#declare Shop1UFront=
union{
	difference{
		box{<-2.5,0,-2.5>*ft,<2.5,8,2.5>*ft}
		box{<-2.75,0.08,-2.25>*ft,<2.75,7.75,2.75>*ft}
		box{<-2.5,3.5,-2.75>*ft,<1.5,6,2.75>*ft}//window
		texture{Brick}
	}
	//object{CeilingLight}
}

#declare TudorBlock=//<12,8,6>*ft
union{
	difference{
		box{<-6,0,-3>*ft,<6,8,3>*ft}
		//box{<-5.75,0.08,-2.75>*ft,<5.75,7.75,2.75>*ft}
		box{<-5.75,0.25,-3.25>*ft,<5.75,7.75,3.25>*ft}
		box{<-6.25,0.25,-2.75>*ft,<6.25,7.75,2.75>*ft}
	}
	//object{CeilingLight}
	texture{TudorWood}
}

#declare TudorSide=//<12,8,6>*ft
union{
	difference{
		box{<-3,0,-6>*ft,<3,8,6>*ft}
		box{<-2.75,0.08,-5.75>*ft,<2.75,7.75,5.75>*ft}
		box{<-2.75,0.25,-6.25>*ft,<2.75,7.75,6.25>*ft}
		box{<-3.25,0.25,-5.75>*ft,<3.25,7.75,5.75>*ft}
	}
	box{<-2.8,0,-5.92>*ft,<2.8,8,-5.84>*ft texture{TudorPlaster}}
	box{<-2.8,1.92,-6>*ft,<2.8,2.08,-5.75>*ft}
	#local XX=-2;
	#while (XX<=2)
		box{<XX-0.08,0.08,-6>*ft,<XX+0.08,8,-5.75>*ft}
		#local XX=XX+1;
	#end
	box{<-2.8,5.42,-6>*ft,<2.8,5.58,-5.75>*ft}
	//object{CeilingLight}
	texture{TudorWood}
}

#declare TudorBackCorner=//<12,8,6>*ft
union{
	difference{
		box{<-6,0,-3>*ft,<6,8,3>*ft}
		box{<-5.75,0.08,-2.75>*ft,<5.75,7.75,2.75>*ft}
		box{<-5.75,0.25,-3.25>*ft,<5.75,7.75,3.25>*ft}
		box{<-6.25,0.25,-2.75>*ft,<6.25,7.75,2.75>*ft}
	}
	box{<-5.92,0,-2.8>*ft,<-5.84,8,2.8>*ft texture{TudorPlaster}}
	difference{
		box{<-5.92,0,-2.84>*ft,<5.92,8,-2.92>*ft}
		box{<-3,2,-3.1>*ft,<3,5.5,-2.7>*ft}
		texture{TudorPlaster}
	}
	box{<-6,1.92,-2.8>*ft,<-5.75,2.08,2.8>*ft}
	#local ZZ=-2;
	#while (ZZ<=2)
		box{<-6,0.08,ZZ-0.08>*ft,<-5.75,8,ZZ+0.08>*ft}
		#local ZZ=ZZ+1;
	#end
	box{<-6,5.42,-2.8>*ft,<-5.75,5.58,2.8>*ft}
	box{<-5.8,1.92,-3>*ft,<5.8,2.08,-2.75>*ft}
	#local XX=-5;
	#while (XX<=5)
		box{<XX-0.08,0.08,-3>*ft,<XX+0.08,2,-2.75>*ft}
		box{<XX-0.08,5.5,-3>*ft,<XX+0.08,8,-2.75>*ft}
		#local XX=XX+1;
	#end
	box{<-5-0.08,2,-3>*ft,<-5+0.08,5.5,-2.75>*ft}
	box{<-4-0.08,2,-3>*ft,<-4+0.08,5.5,-2.75>*ft}
	box{<-3-0.08,2,-3>*ft,<-3+0.08,5.5,-2.75>*ft}
	box{<3-0.08,2,-3>*ft,<3+0.08,5.5,-2.75>*ft}
	box{<4-0.08,2,-3>*ft,<4+0.08,5.5,-2.75>*ft}
	box{<5-0.08,2,-3>*ft,<5+0.08,5.5,-2.75>*ft}
	box{<-5.8,5.42,-3>*ft,<5.8,5.58,-2.75>*ft}
	//object{CeilingLight}
	texture{TudorWood}
}

#declare TudorFrontCorner=//<12,8,6>*ft
union{
	difference{
		box{<-6,0,-2.5>*ft,<6,8,3>*ft}
		box{<-5.75,0.08,-2.25>*ft,<5.75,7.75,2.75>*ft}
		box{<-5.75,0.25,-2.75>*ft,<5.75,7.75,3.25>*ft}
		box{<-6.25,0.25,-2.25>*ft,<6.25,7.75,2.75>*ft}
	}
	box{<-5.92,0,-2.3>*ft,<-5.84,8,2.8>*ft texture{TudorPlaster}}
	difference{
		box{<-5.92,0,-2.34>*ft,<5.92,8,-2.42>*ft}
		box{<-3,2,-2.6>*ft,<3,5.5,-2.2>*ft}
		texture{TudorPlaster}
	}
	box{<-6,1.92,-2.3>*ft,<-5.75,2.08,2.8>*ft}
	#local ZZ=-2;
	#while (ZZ<=2)
		box{<-6,0.08,ZZ-0.08>*ft,<-5.75,8,ZZ+0.08>*ft}
		#local ZZ=ZZ+1;
	#end
	box{<-6,5.42,-2.3>*ft,<-5.75,5.58,2.8>*ft}
	box{<-5.8,1.92,-2.5>*ft,<5.8,2.08,-2.25>*ft}
	#local XX=-5;
	#while (XX<=5)
		box{<XX-0.08,0.08,-2.5>*ft,<XX+0.08,2,-2.25>*ft}
		box{<XX-0.08,5.5,-2.5>*ft,<XX+0.08,8,-2.25>*ft}
		#local XX=XX+1;
	#end
	box{<-5-0.08,2,-2.5>*ft,<-5+0.08,5.5,-2.25>*ft}
	box{<-4-0.08,2,-2.5>*ft,<-4+0.08,5.5,-2.25>*ft}
	box{<-3-0.08,2,-2.5>*ft,<-3+0.08,5.5,-2.25>*ft}
	box{<3-0.08,2,-2.5>*ft,<3+0.08,5.5,-2.25>*ft}
	box{<4-0.08,2,-2.5>*ft,<4+0.08,5.5,-2.25>*ft}
	box{<5-0.08,2,-2.5>*ft,<5+0.08,5.5,-2.25>*ft}
	box{<-5.8,5.42,-2.5>*ft,<5.8,5.58,-2.25>*ft}
	//object{CeilingLight}
	texture{TudorWood}
}

#declare TudorUBack=//<12,8,6>*ft
union{
	difference{
		box{<-6,0,-3>*ft,<6,8,3>*ft}
		box{<-5.75,0.08,-2.75>*ft,<5.75,7.75,2.75>*ft}
		box{<-5.75,0.25,-3.25>*ft,<5.75,7.75,3.25>*ft}
		box{<-6.25,0.25,-2.75>*ft,<6.25,7.75,2.75>*ft}
	}
	difference{
		box{<-5.92,0,-2.84>*ft,<5.92,8,-2.92>*ft}
		box{<-3,2,-3.1>*ft,<3,5.5,-2.7>*ft}
		texture{TudorPlaster}
	}
	box{<-5.8,1.92,-3>*ft,<5.8,2.08,-2.75>*ft}
	#local XX=-5;
	#while (XX<=5)
		box{<XX-0.08,0.08,-3>*ft,<XX+0.08,2,-2.75>*ft}
		box{<XX-0.08,5.5,-3>*ft,<XX+0.08,8,-2.75>*ft}
		#local XX=XX+1;
	#end
	box{<-5-0.08,2,-3>*ft,<-5+0.08,5.5,-2.75>*ft}
	box{<-4-0.08,2,-3>*ft,<-4+0.08,5.5,-2.75>*ft}
	box{<-3-0.08,2,-3>*ft,<-3+0.08,5.5,-2.75>*ft}
	box{<3-0.08,2,-3>*ft,<3+0.08,5.5,-2.75>*ft}
	box{<4-0.08,2,-3>*ft,<4+0.08,5.5,-2.75>*ft}
	box{<5-0.08,2,-3>*ft,<5+0.08,5.5,-2.75>*ft}
	box{<-5.8,5.42,-3>*ft,<5.8,5.58,-2.75>*ft}
	//object{CeilingLight}
	texture{TudorWood}
}

#declare TudorBack=//<12,8,6>*ft
union{
	difference{
		box{<-6,0,-3>*ft,<6,8,3>*ft}
		box{<-5.75,0.08,-2.75>*ft,<5.75,7.75,2.75>*ft}
		box{<-5.75,0.25,-3.25>*ft,<5.75,7.75,3.25>*ft}
		box{<-6.25,0.25,-2.75>*ft,<6.25,7.75,2.75>*ft}
	}
	difference{
		box{<-5.92,0,-2.84>*ft,<5.92,8,-2.92>*ft}
		box{<-4,2,-3.1>*ft,<-2,5.5,-2.7>*ft}
		box{<-1.5,0.08,-3.1>*ft,<1.5,5.5,-2.7>*ft}
		box{<4,2,-3.1>*ft,<2,5.5,-2.7>*ft}
		texture{TudorPlaster}
	}
	box{<-5.8,1.92,-3>*ft,<-1.5,2.08,-2.75>*ft}
	box{<1.5,1.92,-3>*ft,<5.8,2.08,-2.75>*ft}
	#local XX=-5;
	#while (XX<=-2)
		box{<XX-0.08,0.08,-3>*ft,<XX+0.08,2,-2.75>*ft}
		box{<-XX-0.08,0.08,-3>*ft,<-XX+0.08,2,-2.75>*ft}
		#local XX=XX+1;
	#end
	#local XX=-5;
	#while (XX<=5)
		box{<XX-0.08,5.5,-3>*ft,<XX+0.08,8,-2.75>*ft}
		#local XX=XX+1;
	#end
	box{<-5-0.08,2,-3>*ft,<-5+0.08,5.5,-2.75>*ft}
	box{<-4-0.08,2,-3>*ft,<-4+0.08,5.5,-2.75>*ft}
	box{<-2-0.08,2,-3>*ft,<-2+0.08,5.5,-2.75>*ft}
	box{<-1.5-0.08,0.08,-3>*ft,<-1.5+0.08,5.5,-2.75>*ft}
	box{<1.5-0.08,0.08,-3>*ft,<1.5+0.08,5.5,-2.75>*ft}
	box{<2-0.08,2,-3>*ft,<2+0.08,5.5,-2.75>*ft}
	box{<4-0.08,2,-3>*ft,<4+0.08,5.5,-2.75>*ft}
	box{<5-0.08,2,-3>*ft,<5+0.08,5.5,-2.75>*ft}
	box{<-5.8,5.42,-3>*ft,<5.8,5.58,-2.75>*ft}
	//object{CeilingLight}
	texture{TudorWood}
}

#declare TudorFront=//<12,8,6>*ft//use as Door, not Front.
union{
	difference{
		box{<-6,0,-2.5>*ft,<6,8,3>*ft}
		box{<-5.75,0.08,-2.25>*ft,<5.75,7.75,2.75>*ft}
		box{<-5.75,0.25,-2.75>*ft,<5.75,7.75,3.25>*ft}
		box{<-6.25,0.25,-2.25>*ft,<6.25,7.75,2.75>*ft}
	}
	//beside door
	box{<-2.04,0,-2.3>*ft,<-1.96,5.5,0.1>*ft texture{TudorPlaster}}
	box{<-2,0,0.08>*ft,<-1.5,5.5,0.16>*ft texture{TudorPlaster}}
	box{<2,0.08,0>*ft,<1.5,5.5,0.16>*ft texture{TudorPlaster}}
	box{<2.04,0,-2.3>*ft,<1.96,5.5,0.1>*ft texture{TudorPlaster}}
	difference{
		box{<-5.92,0,-2.34>*ft,<5.92,8,-2.42>*ft}
		box{<-5,2,-2.6>*ft,<-3,5.5,-2.2>*ft}
		box{<-2,0.08,-2.6>*ft,<2,5.5,-2.2>*ft}
		box{<5,2,-2.6>*ft,<3,5.5,-2.2>*ft}
		texture{TudorPlaster}
	}
	box{<-5.8,1.92,-2.5>*ft,<-2,2.08,-2.25>*ft}
	box{<2,1.92,-2.5>*ft,<5.8,2.08,-2.25>*ft}
	#local XX=-5;
	#while (XX<=-3)
		box{<XX-0.08,0.08,-2.5>*ft,<XX+0.08,2,-2.25>*ft}
		box{<-XX-0.08,0.08,-2.5>*ft,<-XX+0.08,2,-2.25>*ft}
		#local XX=XX+1;
	#end
	#local XX=-5;
	#while (XX<=5)
		box{<XX-0.08,5.5,-2.5>*ft,<XX+0.08,8,-2.25>*ft}
		#local XX=XX+1;
	#end
	box{<-5-0.08,2,-2.5>*ft,<-5+0.08,5.5,-2.25>*ft}
	box{<-3-0.08,2,-2.5>*ft,<-3+0.08,5.5,-2.25>*ft}
	box{<-2-0.08,2,-2.5>*ft,<-2+0.08,5.5,-2.25>*ft}
	box{<-2-0.08,0.08,0>*ft,<-2+0.08,5.5,0.25>*ft}
	box{<-1.5-0.08,0.08,0>*ft,<-1.5+0.08,5.5,0.25>*ft}
	box{<1.5-0.08,0.08,0>*ft,<1.5+0.08,5.5,0.25>*ft}
	box{<2-0.08,0.08,0>*ft,<2+0.08,5.5,0.25>*ft}
	box{<2-0.08,2,-2.5>*ft,<2+0.08,5.5,-2.25>*ft}
	box{<3-0.08,2,-2.5>*ft,<3+0.08,5.5,-2.25>*ft}
	box{<5-0.08,2,-2.5>*ft,<5+0.08,5.5,-2.25>*ft}
	box{<-5.8,5.42,-2.5>*ft,<5.8,5.58,-2.25>*ft}
	//diagonal beams by door
	box{
		<-0.08,-1.75,-0.125>*ft,<+0.08,1.75,0.125>*ft
		rotate z*-15 translate <-5.5,3.75,-2.375>*ft
	}
	box{
		<-0.08,-1.75,-0.125>*ft,<+0.08,1.75,0.125>*ft
		rotate z*15 translate <-2.5,3.75,-2.375>*ft
	}
	box{
		<-0.08,-1.75,-0.125>*ft,<+0.08,1.75,0.125>*ft
		rotate z*-15 translate <2.5,3.75,-2.375>*ft
	}
	box{
		<-0.08,-1.75,-0.125>*ft,<+0.08,1.75,0.125>*ft
		rotate z*15 translate <5.5,3.75,-2.375>*ft
	}
	//object{CeilingLight translate <-4,0,1>*ft}
	//object{CeilingLight translate <4,0,1>*ft}
	texture{TudorWood}
}

#declare TudorUFront=//<12,8,6>*ft
union{
	difference{
		box{<-6,0,-3>*ft,<6,8,3>*ft}
		box{<-5.75,0.08,-2.75>*ft,<5.75,7.75,2.75>*ft}
		box{<-5.75,0.25,-3.25>*ft,<5.75,7.75,3.25>*ft}
		box{<-6.25,0.25,-2.75>*ft,<6.25,7.75,2.75>*ft}
	}
	difference{
		box{<-5.92,0,-2.84>*ft,<5.92,8,-2.92>*ft}
		//box{<-4,2,-3.1>*ft,<-2,5.5,-2.7>*ft}
		box{<-3,0,-3.1>*ft,<3,8,-2.7>*ft}
		//box{<4,2,-3.1>*ft,<2,5.5,-2.7>*ft}
		texture{TudorPlaster}
	}
	//
	//box{<-5.92,0,2.84>*ft,<5.92,8,2.92>*ft texture{TudorPlaster}}
	//
	box{<-5.8,1.92,-3>*ft,<-3,2.08,-2.75>*ft}
	box{<3,1.92,-3>*ft,<5.8,2.08,-2.75>*ft}
	#local XX=-5;
	#while (XX<=-4)
		box{<XX-0.08,0.08,-3>*ft,<XX+0.08,8,-2.75>*ft}
		box{<-XX-0.08,0.08,-3>*ft,<-XX+0.08,8,-2.75>*ft}
		#local XX=XX+1;
	#end
	//box{<-5-0.08,2,-3>*ft,<-5+0.08,5.5,-2.75>*ft}
	//box{<-4-0.08,2,-3>*ft,<-4+0.08,5.5,-2.75>*ft}
	//box{<-2-0.08,2,-3>*ft,<-2+0.08,5.5,-2.75>*ft}
	box{<-3-0.08,0.08,-3>*ft,<-3+0.08,5.5,-2.75>*ft}
	box{<3-0.08,0.08,-3>*ft,<3+0.08,5.5,-2.75>*ft}
	//box{<2-0.08,2,-3>*ft,<2+0.08,5.5,-2.75>*ft}
	//box{<4-0.08,2,-3>*ft,<4+0.08,5.5,-2.75>*ft}
	//box{<5-0.08,2,-3>*ft,<5+0.08,5.5,-2.75>*ft}
	box{<-5.8,5.42,-3>*ft,<3,5.58,-2.75>*ft}
	box{<3,5.42,-3>*ft,<5.8,5.58,-2.75>*ft}
	// what do you call the bit that juts out?
	box{<-2.92,0,-3>*ft,<-2.84,8,-4.42>*ft texture{TudorPlaster}}
	box{<2.92,0,-3>*ft,<2.84,8,-4.42>*ft texture{TudorPlaster}}
	box{<-2.92,0,-4.34>*ft,<2.92,2,-4.42>*ft texture{TudorPlaster}}
	box{<-2.92,5.5,-4.34>*ft,<2.92,8,-4.42>*ft texture{TudorPlaster}}
	box{<-3.08,0,-4.5>*ft,<3.08,0.25,-3>*ft}
	box{<-3.08,7.75,-4.5>*ft,<3.08,8,-3>*ft}
	box{<-3-0.08,0.08,-4.5>*ft,<-3+0.08,8,-4.25>*ft}
	box{<-3,1.92,-4.5>*ft,<3,2.08,-4.25>*ft}
	box{<-3,5.42,-4.5>*ft,<3,5.58,-4.25>*ft}
	box{<3-0.08,0.08,-4.5>*ft,<3+0.08,8,-4.25>*ft}
	#local XX=-2;
	#while (XX<=2)
		box{<XX-0.08,0.08,-4.5>*ft,<XX+0.08,2,-4.25>*ft}
		box{<XX-0.08,5.5,-4.5>*ft,<XX+0.08,8,-4.25>*ft}
		#local XX=XX+1;
	#end
	#local XX=-3;
	#while (XX<=3)
		box{
			<XX-0.08,0,0>*ft,<XX+0.08,-2.828,0.25>*ft
			rotate x*-45 translate <0,0,-4.5>*ft
		}
		#local XX=XX+1;
	#end
	//object{CeilingLight}
	texture{TudorWood}
}

#declare Block60=//<20,8,15>*ft
union{
	difference{
		box{
			<-10,0,0>*ft,<10,9,15>*ft
		}
		box{
			<-9.75,0.25,-0.25>*ft,<9.75,8.5,15.25>*ft
		}
	}
	texture{Wall}
}

#declare Block60Front=//<20,8,15>*ft
union{
	difference{
		box{
			<-10,0,0>*ft,<10,9,15>*ft
		}
		box{
			<-9.75,0.25,-0.25>*ft,<9.75,8.5,15.25>*ft
		}
		box{
			<-10.25,0.25,0.5>*ft,<10.25,8.5,5.5>*ft
		}
	}
	difference{//front wall
		box{
			<-9.75,0.25,6>*ft,<9.75,8.5,6.5>*ft
			texture{WhitePaint}
		}
		box{//front door
			<1.25,0.5,5.9>*ft,<3.75,7,6.6>*ft
		}
		box{//kitchen window
			<5,3.5,5.9>*ft,<9,6,6.6>*ft
		}
		box{//bedroom windows
			<-9,3.5,5.9>*ft,<-5,6,6.6>*ft
		}
		box{
			<-4.5,3.5,5.9>*ft,<-0.5,6,6.6>*ft
		}
	}
	box{//balcony
		<-9.75,3.5,0>*ft,<9.75,3.75,0.5>*ft
		texture{WhitePaint}
	}
	#local Loop=-9;
	#while (Loop<=9)
		cylinder{<Loop,0.2,0.25>*ft,<Loop,3.6,0.25>*ft,0.125*ft texture{WhitePaint}}
		#local Loop=Loop+1;
	#end
	// Fittings
	box{//front door
		<1.25,0.5,6.125>*ft,<3.75,7,6.375>*ft
		texture{pigment{colour rgb <0.4,0.9,0.4>}}
	}
	texture{Wall}
}

#declare Block60Corner=
union{
	object{Block60Front}
	box{
		<-10,0.25,0.5>*ft,<-9.75,8.5,5.5>*ft
		texture{Wall}
	}	
}

#declare Block60Back=//<20,8,15>*ft
union{
	difference{
		box{
			<-10,0,0>*ft,<10,9,15>*ft
		}
		box{
			<-9.75,0.25,-0.25>*ft,<9.75,8.5,15.25>*ft
		}
	}
	difference{
		box{//rear wall
			<-9.75,0.25,7>*ft,<9.75,8.5,7.5>*ft
			texture{WhitePaint}
		}
		box{//lounge door
			<-6.25,0.5,6.9>*ft,<-3.75,7,7.6>*ft
		}
		box{//bedroom door
			<6.25,0.5,6.9>*ft,<3.75,7,7.6>*ft
		}
		box{//lounge windows
			<-9.25,3.5,6.9>*ft,<-6.75,6,7.6>*ft
		}
		box{
			<-3.25,3.5,6.9>*ft,<-0.5,6,7.6>*ft
		}
		box{//bedroom windows
			<9.25,3.5,6.9>*ft,<6.75,6,7.6>*ft
		}
		box{
			<3.25,3.5,6.9>*ft,<0.5,6,7.6>*ft
		}
	}
	box{//balcony
		<-9.75,3.5,0>*ft,<9.75,3.75,0.5>*ft
		texture{WhitePaint}
	}
	#local Loop=-9;
	#while (Loop<=9)
		cylinder{<Loop,0.2,0.25>*ft,<Loop,3.6,0.25>*ft,0.125*ft texture{WhitePaint}}
		#local Loop=Loop+1;
	#end
	//Fittings
	box{//lounge door
		<-6.25,0.5,7.125>*ft,<-3.75,7,7.375>*ft
		texture{pigment{colour rgb <0.4,0.9,0.4>}}
	}
	box{//bedroom door
		<6.25,0.5,7.125>*ft,<3.75,7,7.375>*ft
		texture{pigment{colour rgb <0.4,0.9,0.4>}}
	}
	texture{Wall}
}

#declare Block60Mid=//<20,8,15>*ft
union{
	difference{
		box{
			<-10,0,0>*ft,<10,9,15>*ft
		}
		box{
			<-9.75,0.25,-0.25>*ft,<9.75,8.5,15.25>*ft
		}
	}
	texture{Wall}
}

#declare Block60Side=object{Block60Mid rotate y*-90}

/*
	pLoc Origin of building - centre front ground (front is actually
	     0.5*block-depth into the building.
	pRtn Rotation about building origin.
	Blocks Array[14] of modular blocks: GF - ground floor, UF - other floors.
		0 GF door, 1 GF front, 2 GF back, 3 GF side,
		4 GF front-left corner, 5 GF back-left corner, 6 GF interior,
		7 UF front, 8 UF back, 9 UF side,
		10 UF front-left corner, 11 UF back-left corner, 12 UF interior,
		13 Lift block
	Vectors Array[3] of vector data:
		0 <width,height,depth> of building in modules,
		1 module size in feet,
		2 <X,R,Z> XZ lift shaft location in modules from front left,
			R rotation about y-axis.  If X or Z are negative, no lift.
	Switches Array[1] of integers:
		0 Door: 0 central, 1 front-right, 2 front-left
*/
#macro OfficeBuilding(pLoc,pRtn,Blocks,Vectors,Switches)
union{
	// some of these will be dropped, some will become parameters
	#local Width=Vectors[0].x;#local Depth=Vectors[0].z;#local Height=Vectors[0].y;
	#local MinX=-Width/2+0.5;#local MaxX=Width/2;
	#local WHD=Vectors[1];#local Lift=Vectors[2];
	//#write(DebugFile,"Min,Max = ",<MinX,0,0>,",",<MaxX,Height,Depth>,"\n")
	// Ground floor
	#local XX=MinX;
	#while (XX<MaxX)
		#local ZZ=0;
		#while (ZZ<Depth)
			#local Translation=<XX*WHD.x,0,(ZZ-0.5)*WHD.z>*ft;
			#if ((XX=MinX)&(ZZ=0))//front-left corner
				#if (Switches[0]=2)
					object{
						Blocks[0] translate Translation
					}
				#else
					object{
						Blocks[4] translate Translation
					}
				#end
			#else
				#if ((XX=MinX)&(ZZ=Depth-1))//rear-left corner
					object{
						Blocks[5] scale <1,1,-1> translate Translation
					}
				#else
					#if ((XX=MaxX-0.5)&(ZZ=0))//front-right corner
						#if (Switches[0]=1)
							object{
								Blocks[0] translate Translation
							}
						#else
							object{
								Blocks[4] scale <-1,1,1> translate Translation
							}
						#end
					#else
						#if ((XX=MaxX-0.5)&(ZZ=Depth-1))//rear-right corner
							object{
								Blocks[5] scale <-1,1,-1> translate Translation
							}
						#else
							#if ((ZZ=0)&((XX<1)&(XX>-1)))//central door
								#if (Switches[0]=0)
									object{
										Blocks[0]
										#if (XX>0)
											scale <-1,1,1>
										#end
										translate Translation
									}
								#else
									object{
										Blocks[1] rotate y*0 translate Translation
									}
								#end
							#else
								#if (ZZ=0)//front edge
									object{
										Blocks[1] rotate y*0 translate Translation
									}
								#else
									#if (ZZ=Depth-1)//rear edge
										object{
											Blocks[2] rotate y*180 translate Translation
										}
									#else
										#if (XX=MinX)//left edge
											object{
												Blocks[3] rotate y*90 translate Translation
											}
										#else
											#if (XX=MaxX-0.5)//right edge
												object{
													Blocks[3] rotate y*-90 translate Translation
												}
											#else
												#if ((XX-MinX=Lift.x)&(ZZ=Lift.z))//lift
													object{
														Blocks[13] rotate y*Lift.y translate Translation
													}
												#else
													object{
														Blocks[6] translate Translation
													}
												#end
											#end
										#end
									#end
								#end
							#end
						#end
					#end
				#end
			#end
			//#write(DebugFile,"XYZ = ",<XX*WHD.x,0,(ZZ-0.5)*WHD.z>,"\n")
			#local ZZ=ZZ+1;
		#end
		#local XX=XX+1;
	#end
	// Intermediate floors
	#local YY=1;
	#while (YY<Height)
		#local XX=MinX;
		#while (XX<MaxX)
			#local ZZ=0;
			#while (ZZ<Depth)
				#local Translation=<XX*WHD.x,WHD.y*YY,(ZZ-0.5)*WHD.z>*ft;
				#if ((XX=MinX)&(ZZ=0))//front-left corner
					object{
						Blocks[10] translate Translation
					}
				#else
					#if ((XX=MinX)&(ZZ=Depth-1))//rear-left corner
						object{
							Blocks[11] scale <1,1,-1> translate Translation
						}
					#else
						#if ((XX=MaxX-0.5)&(ZZ=0))//front-right corner
							object{
								Blocks[10] scale <-1,1,1> translate Translation
							}
						#else
							#if ((XX=MaxX-0.5)&(ZZ=Depth-1))//rear-right corner
								object{
									Blocks[11] scale <-1,1,-1> translate Translation
								}
							#else
								#if (ZZ=0)//front edge
									object{
										Blocks[7] rotate y*0 translate Translation
									}
								#else
									#if (ZZ=Depth-1)//rear edge
										object{
											Blocks[8] rotate y*180 translate Translation
										}
									#else
										#if (XX=MinX)//left edge
											object{
												Blocks[9] rotate y*90 translate Translation
											}
										#else
											#if (XX=MaxX-0.5)//right edge
												object{
													Blocks[9] rotate y*-90 translate Translation
												}
											#else
												#if ((XX-MinX=Lift.x)&(ZZ=Lift.z))//lift
													object{
														Blocks[13] rotate y*Lift.y translate Translation
													}
												#else
													object{
														Blocks[12] translate Translation
													}
												#end
											#end
										#end
									#end
								#end
							#end
						#end
					#end
				#end
				//#write(DebugFile,"XYZ = ",<XX*WHD.x,YY*WHD.y,(ZZ-0.5)*WHD.z>,"\n")
				#local ZZ=ZZ+1;
			#end
			#local XX=XX+1;
		#end
		#local YY=YY+1;
	#end
	// Roof volume
	// Temporary lights
	rotate pRtn
	translate pLoc
}
#end

/*
	pLoc Origin of building - centre front ground (front is actually
	     0.5*block-depth into the building).
	pRtn Rotation about building origin.
	Vectors Array[3] of vector data:
		0 <width,height,depth> of building in modules,
		1 module size in feet,
		2 <X,R,Z> XZ lift shaft location in modules from front left,
			R rotation about y-axis.  If X or Z are negative, no lift.
	Textures array[1]
		0 basic structure
*/
#macro FlatRoof(pLoc,pRtn,Vectors,Textures)
union{
	#local tSize=Vectors[0]*Vectors[1];
	#write(DebugFile,"\ntSize=",tSize,"\n")
	box{
		<-tSize.x/2,tSize.y,-Vectors[1].z>*ft,
		<tSize.x/2,tSize.y+0.25*Vectors[1].y,tSize.z-Vectors[1].z>*ft
		texture{Textures[0]}
	}
	//Put a block above the lifts.
	#if ((Vectors[2].x>0)|(Vectors[2].z>0))
		box{
			Vectors[1]*<-0.5,0,-0.5>*ft,Vectors[1]*<0.5,1,0.5>*ft
			texture{Textures[0]}
			translate <Vectors[1].x*Vectors[2].x-tSize.x/2+Vectors[1].x*0.5,
				tSize.y,Vectors[1].z*Vectors[2].z>*ft
		}
	#end
	//Reference photos of real buildings show an unknown lump on many :-)
	box{
		<-tSize.x/2,tSize.y,tSize.z/3>*ft,
		<-tSize.x/4,tSize.y+Vectors[1].y,tSize.z-Vectors[1].z>*ft
		texture{Textures[0]}
	}
	rotate pRtn
	translate pLoc
}
#end

/*
//First test office block.
#declare SamplerName=
union{
	object{//Scaler=3.5?
		OfficeBuilding(0,0,
			array[14]{
				DoorBlock,
				OffFront,OffRear,OffSide,
				GroundCorner,GroundCorner,TenBlock,
				UpperFront,UpperFront,UpperFront,
				UpperCorner,UpperCorner,TenBlock,
				LiftBlock
			},
			array[3]{
				<8,5,6>,<10,10,10>,<4,0,2>
			},
			array[1]{
				0
			}
		)
	}
	object{
		FlatRoof(0,0,
			array[3]{
				<8,5,6>,<10,10,10>,<4,0,2>
			},
			array[1]{
				texture{pigment{colour rgb <.6,.6,.6>}}
			}
		)
	}
}
#declare SamplerBBox = array[2]{<-40,0,0>*ft,<40,50,60>*ft}
*/

/*
//First brick-built shop
#declare SamplerName=union{
	object{//Scaler=2.2
		OfficeBuilding(0,0,
			array[14]{
				Shop1Door,
				Shop1Front,Shop1UFront,Shop1Side,
				Shop1Corner,Shop1UCorner,Shop1Block,
				Shop1UFront,Shop1UFront,Shop1Side,
				Shop1UCorner,Shop1UCorner,Shop1Block,
				Shop1Block
			},
			array[3]{
				<5,4,4>,<5,8,5>,<-1,0,-1>
			},
			array[1]{
				0
			}
		)
	}
	object{
		MakeRoof(
			<0,32,5>*ft,<0,0,0>,
			box{<-12.5,0,-10>*ft,<12.5,8,10>*ft texture{Brick}},
			<25,8,20>*ft,
			Roof
		)
	}
}
#declare SamplerBBox = array[2]{<-12.5,0,0>*ft,<12.5,40,20>*ft}
*/

/*
//Second brick-built shop
#declare SamplerName=union{//Scaler=3
	object{
		OfficeBuilding(0,0,
			array[14]{
				Shop1DoorL,// or Shop1DoorR,
				Shop1Front,Shop1UFront,Shop1Side,
				Shop1Corner,Shop1UCorner,Shop1Block,
				Shop1UFront,Shop1UFront,Shop1Side,
				Shop1UCorner,Shop1UCorner,Shop1Block,
				Shop1Block
			},
			array[3]{
				<4,2,3>,<5,8,5>,<-1,0,-1>
			},
			array[1]{
				2
			}
		)
	}
	object{
		MakeRoof(
			<0,16,2.5>*ft,<0,0,0>,
			box{<-10,0,-7.5>*ft,<10,7,7.5>*ft texture{Brick}},
			<20,7,15>*ft,
			Roof
		)
	}
}
#declare SamplerBBox = array[2]{<-10,0,0>*ft,<10,23,15>*ft}
*/

/*
//Third brick-built shop, with double-width central door
#declare SamplerName=union{//Scaler=3
	object{
		OfficeBuilding(0,0,
			array[14]{
				Shop1DoorW,
				Shop1Front,Shop1UFront,Shop1Side,
				Shop1Corner,Shop1UCorner,Shop1Block,
				Shop1UFront,Shop1UFront,Shop1Side,
				Shop1UCorner,Shop1UCorner,Shop1Block,
				Shop1Block
			},
			array[3]{
				<4,2,3>,<5,8,5>,<-1,0,-1>
			},
			array[1]{
				0
			}
		)
	}
	object{
		MakeRoof(
			<0,16,2.5>*ft,<0,0,0>,
			box{<-10,0,-7.5>*ft,<10,7,7.5>*ft texture{Brick}},
			<20,7,15>*ft,
			Roof
		)
	}
}
#declare SamplerBBox = array[2]{<-10,0,0>*ft,<10,23,15>*ft}
*/

/*
//Brick-built house
#declare SamplerName=union{//Scaler=3
	object{
		OfficeBuilding(0,0,
			array[14]{
				Shop1DoorH,
				Shop1UFront,Shop1UFront,Shop1Side,
				Shop1UCorner,Shop1UCorner,Shop1Block,
				Shop1UFront,Shop1UFront,Shop1Side,
				Shop1UCorner,Shop1UCorner,Shop1Block,
				Shop1Block
			},
			array[3]{
				<4,2,3>,<5,8,5>,<-1,0,-1>
			},
			array[1]{
				2
			}
		)
	}
	object{
		MakeRoof(
			<0,16,2.5>*ft,<0,0,0>,
			box{<-10,0,-7.5>*ft,<10,7,7.5>*ft texture{Brick}},
			<20,7,15>*ft,
			Roof
		)
	}
}
#declare SamplerBBox = array[2]{<-10,0,0>*ft,<10,23,15>*ft}
*/

/*
//Tudor-style building.
#declare SamplerName=union{//Scaler=2.5
	object{
		OfficeBuilding(0,<0,0,0>,
			array[14]{
				TudorFront,
				TudorFront,TudorBack,TudorSide,
				TudorFrontCorner,TudorBackCorner,TudorBlock,
				TudorUFront,TudorUBack,TudorSide,
				TudorBackCorner,TudorBackCorner,TudorBlock,
				TudorBlock
			},
			array[3]{
				<3,2,3>,<12,8,6>,<-1,0,-1>
			},
			array[1]{
				0
			}
		)
	}
	object{
		MakeRoof(
			<0,16,3>*ft,<0,0,0>,
			box{<-18,0,-9>*ft,<18,8,9>*ft texture{TudorPlaster}},
			<36,8,18>*ft,
			Roof
		)
	}
}
#declare SamplerBBox = array[2]{<-18,0,0>*ft,<18,24,18>*ft}
*/

/*
//60s-style block of flats.
#declare SamplerName=union{
	object{//Scaler=1
		OfficeBuilding(0,<0,0,0>,
			array[14]{
				Block60Front,
				Block60Front,Block60Back,Block60Side,
				Block60Corner,Block60Back,Block60Mid,
				Block60Front,Block60Back,Block60Side,
				Block60Corner,Block60Back,Block60Mid,
				Block60
			},
			array[3]{
				<5,3,3>,<20,9,15>,<-1,0,-1>
			},
			array[1]{
				0
			}
		)
	}
	object{
		FlatRoof(<0,0,7.5>*ft,0,
			array[3]{
				<5,3,2>,<20,9,15>,<-1,0,-1>
			},
			array[1]{
				Wall
			}
		)
	}
}
#declare SamplerBBox = array[2]{<-50,0,0>*ft,<50,27,45>*ft}
*/

/*
	Blocks Array[14] of modular blocks: GF - ground floor, UF - other floors.
		0 GF door, 1 GF front, 2 GF back, 3 GF side,
		4 GF front-left corner, 5 GF back-left corner, 6 GF interior,
		7 UF front, 8 UF back, 9 UF side,
		10 UF front-left corner, 11 UF back-left corner, 12 UF interior,
		13 Lift block
	Vectors Array[] of vector data:
		0 <width,height,depth> of building in modules,
		1 module size in feet,
		2 <X,R,Z> XZ lift shaft location in modules from front left,
			R rotation about y-axis.  If X or Z are negative, no lift.
	Switches Array[1] of integers:
		0 Door: 0 central, 1 front-right, 2 front-left
*/

//
//Tudor-style pub.
#declare SamplerName=union{//Scaler=2.5
	box{
		<-30,-5,-19>*ft,<30,0,12>*ft
		texture{pigment{Green}}
	}
	object{
		OfficeBuilding(0,<0,0,0>,
			array[14]{
				TudorFront,
				TudorFrontCorner,TudorBack,TudorSide,
				TudorFrontCorner,TudorBackCorner,TudorBlock,
				TudorBackCorner,TudorUBack,TudorSide,
				TudorBackCorner,TudorBackCorner,TudorBlock,
				TudorBlock
			},
			array[3]{
				<5,2,3>,<12,8,6>,<-1,0,-1>
			},
			array[1]{
				0
			}
		)
	}
	object{
		MakeRoof(
			<0,16,3>*ft,<0,0,0>,
			union{
				box{<-30,0,-9>*ft,<30,8,9>*ft texture{TudorPlaster}}
				box{<-30.08,0,-2.84>*ft,<30.08,8,-3.16>*ft texture{TudorWood}}
				box{<-30.08,0,2.84>*ft,<30.08,8,3.16>*ft texture{TudorWood}}
				box{<-30.08,1.92,-9>*ft,<30.08,2.08,9>*ft}
				box{<-30.08,5.42,-9>*ft,<30.08,5.58,9>*ft}
			},
			<62,8,18>*ft,
			Roof
		)
	}
}
#declare SamplerBBox = array[2]{<-18,0,0>*ft,<18,24,18>*ft}
//

/*
//60s-style block of flats.
#declare SamplerName=object{//Scaler=1
	OfficeBuilding(0,<0,0,0>,
		array[14]{
			Block60,
			Block60Front,Block60Back,Block60Side,
			Block60Corner,Block60Back,Block60Mid,
			Block60Front,Block60Back,Block60Side,
			Block60Corner,Block60Back,Block60Mid,
			Block60
		},
		array[3]{
			<5,3,3>,<20,9,15>,<-1,0,-1>
		},
		array[1]{
			0
		}
	)
}
#declare SamplerBBox = array[2]{<-50,0,0>*ft,<50,27,45>*ft}
*/
//plane{y,0 texture{pigment{colour rgb <0.2,0.8,0.2>}}}                                                                                                             zALTHALTH                       offices.mcr-127rPlug 20009r)am. TEXTMPS  
                    u    @             )%JVWRBMPp                              +%JVWRJFIF                              ,%JVWRPNTG                          %  %         
 
    
         $  6                             H 	Monaco 0 
     W ": W ":2@  jf  jk  i    ( W ": W ":       i                     z@A^    z SELc   "MPSR  .styl   FNwPo   R           N       =T           &                                                                    