 village.inc       8"D  P     ÀTEXTMPS  @         2                       _  // bvillage.inc

#debug "\rbvillage.inc - Build the village.\r"

// Define the LandForm variables
// Central area only:
//#declare LandFormMin=<-1360,    0,-1360>*ft;
//#declare LandFormMax=< 1360,   20, 1360>*ft;

// Central area and surrounding blocks:
//#declare LandFormMin=<-4080,    0,-4080>*ft;
//#declare LandFormMax=< 1360,   20, 4080>*ft;

// Area used in City round:
#declare LandFormMin=<-4080,    0,-1360>*ft;
#declare LandFormMax=< 1360,   20, 4080>*ft;

#declare LandFormScl=80*ft;
#declare LandFormSeed=seed(4457);
#declare GravePos=seed(1741);
#declare GraveRtn=seed(3081);
#declare GraveStyle=seed(2118);
#declare TreeVal=seed(5601);

#include "landforms.mcr"

//=======================================================================
// Now define and build the landscape from large, half-mile square blocks.
#include "vill_ll.inc"
#include "vill_lm.inc"
// #include "vill_ln.inc"
#include "vill_ml.inc"
#include "vill_mm.inc"
// #include "vill_mn.inc"
// #include "vill_nl.inc"
// #include "vill_nm.inc"
// #include "vill_nn.inc"
#debug "\r----\rEnd of landscape building\r----\r"
// To write out the next block along:
//LandFormBlockWrite("vill_ll.inc",<-4080,    0, 1360>,< -1360,  200, 4080>)
//LandFormBlockWrite("vill_lm.inc",<-1360,    0, 1360>,<  1360,  200, 4080>)
//LandFormBlockWrite("vill_ln.inc",< 1360,    0, 1360>,<  4080,  200, 4080>)
//
//LandFormBlockWrite("vill_ml.inc",<-4080,    0,-1360>,< -1360,  200, 1360>)
//LandFormBlockWrite("vill_mn.inc",< 1360,    0,-1360>,<  4080,  200, 1360>)
//
//LandFormBlockWrite("vill_nl.inc",<-4080,    0,-4080>,< -1360,  200,-1360>)
//LandFormBlockWrite("vill_nm.inc",<-1360,    0,-4080>,<  1360,  200,-1360>)
//LandFormBlockWrite("vill_nn.inc",< 1360,    0,-4080>,<  4080,  200,-1360>)
//

#include "rtdhc.inc"

// Build
LandFormNormalise()
LandFormDraw(3)
/*
box{
	<LandFormMin.x,   -3*ft,LandFormMin.z>,<LandFormMax.x,    0,LandFormMax.z>
	texture{Ground}
}
*/
box{
	<LandFormMin.x,  180*ft,LandFormMin.z>,<LandFormMax.x,  190*ft,LandFormMax.z>
	texture{Stream}
}

#declare BusWheel=
union{
	difference{
	  cylinder{<0,16,0>*in,<0,16,9>*in,16*in}
	  cylinder{<0,16,-1>*in,<0,16,10>*in,5*in}
		texture{pigment{Black}}
	}
  cylinder{<0,16,3>*in,<0,16,8>*in,5*in texture{Chrome_Metal}}
}

#declare Bus=
union{
	difference{
		union{
			box{<-47.5,9.5,0>*in,<47.5,109.5,380>*in}
			box{<-44.25,23,-0.1>*in,<-22.75,43.75,0.1>*in texture{Chrome_Metal}}
			box{<44.25,23,-0.1>*in,<22.75,43.75,0.1>*in texture{Chrome_Metal}}
		}
		box{<-47.25,38.25,6>*in,<47.25,109.25,379.75>*in}
		//front
		box{<-44,90,-1>*in,<44,105,3>*in}
		box{<-44,57,-1>*in,<44,85,8>*in}
		box{<-33.25,24,-1>*in,<-23.75,42.75,3>*in}//headlights
		box{<-43.25,24,-1>*in,<-33.75,33,3>*in}
		box{<-43.25,33.75,-1>*in,<-33.75,42.75,3>*in}
		box{<33.25,24,-1>*in,<23.75,42.75,3>*in}
		box{<43.25,24,-1>*in,<33.75,33,3>*in}
		box{<43.25,33.75,-1>*in,<33.75,42.75,3>*in}
		//back
		box{<-28,57.5,379>*in,<28,87.5,381>*in}
		//door
		box{<-47.25,13.5,9.5>*in,<48,105,49.5>*in}
		//windows
		box{<-48,71,9.5>*in,<-47,105,57.5>*in}//driver's window
		box{<-48,71,66.5>*in,<48,105,106.5>*in}
		box{<-48,71,114>*in,<48,105,154>*in}
		box{<-48,71,161.5>*in,<48,105,201.5>*in}
		box{<-48,71,208>*in,<48,105,248>*in}
		box{<-48,71,255.5>*in,<48,105,295.5>*in}
		box{<-48,71,303>*in,<48,105,343>*in}
		box{<-48,71,350.5>*in,<48,105,375>*in}
		//wheelarches
		box{<-48,9,57>*in,<48,38,95>*in}
		box{<-48,9,256>*in,<48,38,294>*in}
	}
	//indicator box
	box{<-44,90,0.25>*in,<44,105,3>*in texture{pigment{Black}}}
	//bumper
	box{<-48,19,-5>*in,<48,29,3>*in}
	box{<-23,10,-0.1>*in,<23,18,0.1>*in texture{pigment{White}}}
	//front lights
	box{<-33.25,24,-1>*in,<-23.75,42.75,3>*in}//headlights
	box{<33.25,24,-1>*in,<23.75,42.75,3>*in}
	box{<-43.25,24,-1>*in,<-33.75,33,3>*in}//trafficators
	box{<43.25,24,-1>*in,<33.75,33,3>*in}
	box{<-43.25,33.75,-1>*in,<-33.75,42.75,3>*in}//sidelights
	box{<43.25,33.75,-1>*in,<33.75,42.75,3>*in}
	//wheels
	object{BusWheel rotate y*-90 translate <46,0,76>*in}
	object{BusWheel rotate y*90 translate <-46,0,76>*in}
	object{BusWheel rotate y*-90 translate <46,0,276>*in}
	object{BusWheel rotate y*90 translate <-46,0,276>*in}
	texture{pigment{colour rgb <0.2,0.7,0.3>}}
}

#declare RoundTower=
union{
  difference{
	  union{
			cylinder{<0,0,0>,<0,32,0>*ft,10*ft}
			cylinder{<0,29,0>*ft,<0,32,0>*ft,11*ft}
			cone{<0,26,0>*ft,10*ft,<0,29,0>*ft,11*ft}
		}
		cylinder{<0,-1,0>,<0,33,0>*ft,8.5*ft}
		#local Rotn=-30;//windows
		#while (Rotn<=120)
			box{<8,4,-0.5>*ft,<10.5,6,0.5>*ft rotate y*Rotn}
			box{<8,11,-0.75>*ft,<10.5,14.5,0.75>*ft rotate y*Rotn}
			box{<8,19,-0.75>*ft,<10.5,22.5,0.75>*ft rotate y*Rotn}
			#local Rotn=Rotn+30;
		#end
		#local Rotn=0;//crenellations
		#while (Rotn<=180)
			box{<-11.5,30,-0.75>*ft,<11.5,33,0.75>*ft rotate y*Rotn}
			#local Rotn=Rotn+30;
		#end
	}
}

#declare SquareTower=
union{
	difference{
		union{
			box{<-15,0,-10>*ft,<0,30,10>*ft}
			box{<-15.5,27,-11>*ft,<0.5,30,11>*ft}
		}
		box{<-13.5,-1,-8.5>*ft,<-1.5,31,8.5>*ft}
		//windows
		box{<-15.5,  4,-6.5 >*ft,<-13,  6  ,-5.5 >*ft}
		box{<-15.5,  4,-0.5 >*ft,<-13,  6  , 0.5 >*ft}
		box{<-15.5,  4, 6.5 >*ft,<-13,  6  , 5.5 >*ft}
		box{<-15.5, 11,-6.75>*ft,<-13, 14.5,-5.25>*ft}
		box{<-15.5, 11,-0.75>*ft,<-13, 14.5, 0.75>*ft}
		box{<-15.5, 11, 6.75>*ft,<-13, 14.5, 5.25>*ft}
		box{<-15.5, 19,-6.75>*ft,<-13, 22.5,-5.25>*ft}
		box{<-15.5, 19,-0.75>*ft,<-13, 22.5, 0.75>*ft}
		box{<-15.5, 19, 6.75>*ft,<-13, 22.5, 5.25>*ft}
		#local ZZ=-9;//crenellations
		#while (ZZ<=9)
		  box{<-16,28,ZZ-0.5>*ft,<-13,31,ZZ+0.5>*ft}
			#local ZZ=ZZ+3;
		#end
	}
}

#declare Barbican=
union{
	difference{
		union{
			box{<-5,0,7.5>*ft,<10,35,20>*ft}
			box{<-5.5,31,7.5>*ft,<10.5,35,20.5>*ft}
			box{<-10,0,9>*ft,<5,35,-9>*ft}
			box{<-10.5,31,9>*ft,<5.5,35,-9>*ft}
			box{<-5,0,-7.5>*ft,<10,35,-20>*ft}
			box{<-5.5,31,-7.5>*ft,<10.5,35,-20.5>*ft}
		}
		//hollow out each tower separately
		box{<-3.5,-1,9>*ft,<8.5,36,18.5>*ft}
		box{<-8.5,-1,7.5>*ft,<3.5,36,-7.5>*ft}
		box{<-3.5,-1,-9>*ft,<8.5,36,-18.5>*ft}
		//cut out remaining inner walls
		box{<-3.49,-1,11>*ft,<3.49,36,-11>*ft}
		//windows [7.5] 9.75 13.75 17.75 [20]
		box{<  0,  4,  9.25>*ft,< 11,  6, 10.25>*ft}
		box{<  0,  4, 13.25>*ft,< 11,  6, 14.25>*ft}
		box{<  0,  4, 17.25>*ft,< 11,  6, 18.25>*ft}
		box{<  0,  4,- 9.25>*ft,< 11,  6,-10.25>*ft}
		box{<  0,  4,-13.25>*ft,< 11,  6,-14.25>*ft}
		box{<  0,  4,-17.25>*ft,< 11,  6,-18.25>*ft}
		box{<-11, 11,  9.00>*ft,< 11,14.5, 10.50>*ft}
		box{<-11, 11, 13.00>*ft,< 11,14.5, 14.50>*ft}
		box{<-11, 11, 17.00>*ft,< 11,14.5, 18.50>*ft}
		box{<-11, 11,- 9.00>*ft,< 11,14.5,-10.50>*ft}
		box{<-11, 11,-13.00>*ft,< 11,14.5,-14.50>*ft}
		box{<-11, 11,-17.00>*ft,< 11,14.5,-18.50>*ft}
		box{<-11, 19,  9.00>*ft,< 11,22.5, 10.50>*ft}
		box{<-11, 19, 13.00>*ft,< 11,22.5, 14.50>*ft}
		box{<-11, 19, 17.00>*ft,< 11,22.5, 18.50>*ft}
		box{<-11, 19,- 9.00>*ft,< 11,22.5,-10.50>*ft}
		box{<-11, 19,-13.00>*ft,< 11,22.5,-14.50>*ft}
		box{<-11, 19,-17.00>*ft,< 11,22.5,-18.50>*ft}
		box{<-11, 27,  9.00>*ft,< 11,30.5, 10.50>*ft}
		box{<-11, 27, 13.00>*ft,< 11,30.5, 14.50>*ft}
		box{<-11, 27, 17.00>*ft,< 11,30.5, 18.50>*ft}
		box{<-11, 27,- 9.00>*ft,< 11,30.5,-10.50>*ft}
		box{<-11, 27,-13.00>*ft,< 11,30.5,-14.50>*ft}
		box{<-11, 27,-17.00>*ft,< 11,30.5,-18.50>*ft}
		//central windows [9] 6 3 0 -3 -6 [-9]
		box{<-11, 19,- 6.75>*ft,< 11,22.5,- 5.25>*ft}
		box{<-11, 19,- 3.75>*ft,< 11,22.5,- 2.25>*ft}
		box{<-11, 19,- 0.75>*ft,< 11,22.5,  0.75>*ft}
		box{<-11, 19,  2.25>*ft,< 11,22.5,  3.75>*ft}
		box{<-11, 19,  5.25>*ft,< 11,22.5,  6.75>*ft}
		box{<-11, 27,- 6.75>*ft,< 11,30.5,- 5.25>*ft}
		box{<-11, 27,- 3.75>*ft,< 11,30.5,- 2.25>*ft}
		box{<-11, 27,- 0.75>*ft,< 11,30.5,  0.75>*ft}
		box{<-11, 27,  2.25>*ft,< 11,30.5,  3.75>*ft}
		box{<-11, 27,  5.25>*ft,< 11,30.5,  6.75>*ft}
		//gateway
		box{<-11,-1,5>*ft,<6,9,-5>*ft}
		cylinder{
			<-11,0,0>*ft,<6,0,0>*ft,5*ft
			scale <1,0.5,1>
			translate <0,9,0>*ft
		}
		box{<4.5,-1,6>*ft,<6,9,-6>*ft}
		cylinder{
			<4.5,0,0>*ft,<6,0,0>*ft,6*ft
			scale <1,0.5,1>
			translate <0,9,0>*ft
		}
		//crenellations
		#local ZZ=-16.5;
		#while (ZZ<=16.5)
		  box{<-11,33,ZZ-0.5>*ft,<11,36,ZZ+0.5>*ft}
			#local ZZ=ZZ+3;
		#end
	}
}

#declare EastWallC=
union{
	difference{
		union{
			box{<-5,0,20>*ft,<5,20,35>*ft}
			box{<4,19,20>*ft,<6,22,35>*ft}
			box{<-5,0,-35>*ft,<5,20,-20>*ft}
			box{<4,19,-20>*ft,<6,22,-35>*ft}
		}
		box{<-3.5,-1,20>*ft,<3.5,19,35>*ft}
		box{<-3.5,-1,-20>*ft,<3.5,19,-35>*ft}
		//crenellations and arrowslits
		#local ZZ=21.5;
		#while (ZZ<=33.5)
		  box{<3,21,ZZ-0.5>*ft,<7,23,ZZ+0.5>*ft}
		  box{<3,21,-ZZ-0.5>*ft,<7,23,-ZZ+0.5>*ft}
			box{<3,4,ZZ-0.5>*ft,<7,6,ZZ+0.5>*ft}
			box{<3,4,-ZZ-0.5>*ft,<7,6,-ZZ+0.5>*ft}
			box{<3,12,ZZ-0.5>*ft,<7,14,ZZ+0.5>*ft}
			box{<3,12,-ZZ-0.5>*ft,<7,14,-ZZ+0.5>*ft}
			#local ZZ=ZZ+3;
		#end
	}
}

#declare SouthWallC=
union{
	difference{
		union{
			box{<-42.5,0,0>*ft,<-10,20,-10>*ft}
			box{<-42.5,19,-9>*ft,<-10,22,-11>*ft}
			box{<10,0,0>*ft,<45,20,-10>*ft}
			box{<10,19,-9>*ft,<45,22,-11>*ft}
		}
		box{<-42.5,-1,-1.5>*ft,<-10,19,-8.5>*ft}
		box{<10,-1,-1.5>*ft,<45,19,-8.5>*ft}
		//crenellations [-42.5] -40.75 -37.75 -34.75 -31.75 -28.75 -25.75 -22.75 -19.75 -16.75 -13.75 -10.75 1.25 10.25 13.25 16.25 19.25 22.25 25.25 28.25 31.25 34.25 37.25 40.25 43.25 [45]
		#local XX=-40.75;
		#while (XX<=43.25)
		  box{<XX-0.5,21,-8>*ft,<XX+0.5,23,-12>*ft}
		  box{<XX-0.5,4,-8>*ft,<XX+0.5,6,-12>*ft}
		  box{<XX-0.5,12,-8>*ft,<XX+0.5,14,-12>*ft}
			#local XX=XX+3;
		#end
	}
}

#declare NorthWallC=
union{
	difference{
		union{
			box{<-42.5,0,0>*ft,<-10,20,10>*ft}
			box{<-42.5,19,9>*ft,<-10,22,11>*ft}
			box{<10,0,0>*ft,<45,20,10>*ft}
			box{<10,19,9>*ft,<45,22,11>*ft}
		}
		box{<-42.5,-1,1.5>*ft,<-10,19,8.5>*ft}
		box{<10,-1,1.5>*ft,<45,19,8.5>*ft}
		//crenellations [-42.5] -40.75 -37.75 -34.75 -31.75 -28.75 -25.75 -22.75 -19.75 -16.75 -13.75 -10.75 1.25 10.25 13.25 16.25 19.25 22.25 25.25 28.25 31.25 34.25 37.25 40.25 43.25 [45]
		#local XX=-40.75;
		#while (XX<=43.25)
		  box{<XX-0.5,21,8>*ft,<XX+0.5,23,12>*ft}
		  box{<XX-0.5,4,8>*ft,<XX+0.5,6,12>*ft}
		  box{<XX-0.5,12,8>*ft,<XX+0.5,14,12>*ft}
			#local XX=XX+3;
		#end
	}
}

#declare WestWallC=
union{
	difference{
		union{
			box{<-10,0,-35>*ft,<0,20,-10>*ft}
			box{<-11,19,-35>*ft,<-9,22,-10>*ft}
			box{<-10,0,10>*ft,<0,20,35>*ft}
			box{<-11,19,35>*ft,<-9,22,10>*ft}
		}
		box{<-8.5,-1,-35>*ft,<-1.5,19,-10>*ft}
		box{<-8.5,-1,35>*ft,<-1.5,19,10>*ft}
		//crenellations & arrowslits
		#local ZZ=10.5;
		#while (ZZ<=34.5)
		  box{<-12,21,ZZ-0.5>*ft,<-8,23,ZZ+0.5>*ft}
		  box{<-12,21,-ZZ-0.5>*ft,<-8,23,-ZZ+0.5>*ft}
			box{<-11,4,ZZ-0.5>*ft,<1,6,ZZ+0.5>*ft}
			box{<-11,4,-ZZ-0.5>*ft,<1,6,-ZZ+0.5>*ft}
			box{<-11,12,ZZ-0.5>*ft,<1,14,ZZ+0.5>*ft}
			box{<-11,12,-ZZ-0.5>*ft,<1,14,-ZZ+0.5>*ft}
			#local ZZ=ZZ+3;
		#end
	}
}

#declare Ruination=
union{
	blob{
		threshold 1
		sphere  {< 45, 32,-35>*ft,                 10*ft,10*ft}
		cylinder{< 45, 25,-35>*ft,<  5, 25,-30>*ft,10*ft,10*ft}
		sphere  {<-50, 32,-40>*ft,                 12*ft,15*ft}
		cylinder{<-50, 25,-32>*ft,<  5, 20,-30>*ft,12*ft,11*ft}
		sphere  {<-50, 22,-40>*ft,                 10*ft,11*ft}
		cylinder{<-55, 22,-40>*ft,<-55, 22, 40>*ft,10*ft,11*ft}
		cylinder{<-45, 25,-40>*ft,<-45, 25, 40>*ft,10*ft,11*ft}
		cylinder{<-50, 40, 40>*ft,<-50,  5, 40>*ft,15*ft,20*ft}
		sphere  {< 50, 32, 40>*ft,                 12*ft,15*ft}
		cylinder{< 40, 32, 30>*ft,< 40, 10, 30>*ft,10*ft,10*ft}
		cylinder{<  0, 30,-45>*ft,<  0, -1,-50>*ft,10*ft,15*ft}
		cylinder{<  0, 30,-45>*ft,<  0, 11,-45>*ft,15*ft,15*ft}
		cylinder{< 55, 32, 35>*ft,< 55, 32,-35>*ft,12*ft,12*ft
			scale <1,2,1> translate <0,-32,0>*ft}
		cylinder{< 57, 21, 30>*ft,< 58, 23,-30>*ft,12*ft,12*ft
			scale <1,2,1> translate <0,-22,0>*ft}
		cylinder{< 60, 10, 35>*ft,< 60, 12,-35>*ft,12*ft,12*ft
			scale <1,2,1> translate <0,-11,0>*ft}
		sphere  {<  0,  8, 40>*ft,                 15*ft,14*ft}
		sphere  {<  0, 16, 40>*ft,                 15*ft,15*ft}
		sphere  {<  0, 24, 40>*ft,                 15*ft,16*ft}
		sphere  {<  0, 32, 40>*ft,                 15*ft,17*ft}
		sphere  {<  0, 40, 40>*ft,                 15*ft,18*ft}
		cylinder{<-50, 24, 40>*ft,< 50, 24, 40>*ft,15*ft,16*ft}
		cylinder{<-50, 24,-40>*ft,< 40, 24,-40>*ft,15*ft,16*ft}
		cylinder{<-50,  0,-40>*ft,< 40, 24,-40>*ft,15*ft,16*ft}
		cylinder{<-50,  8,-40>*ft,<-50, 16, 40>*ft,15*ft,16*ft}
	}
	box{<45,8,20>*ft,<60,18,24>*ft}
	box{<45,4,30>*ft,<60,10,34>*ft}
	box{<45,9,45>*ft,<60,16,49>*ft}
	texture{WallStone}
}

#declare Castle=
union{
	union{//building
		//gatehouse
		object{Barbican translate <50,0,0>*ft}
		//towers
		object{RoundTower rotate y*0 translate < 50,0,-40>*ft}
		object{SquareTower rotate y*-90 translate <0,0,-35>*ft}
		object{RoundTower rotate y*90 translate <-50,0,-40>*ft}
		object{SquareTower rotate y*0 translate <-42.5,0,0>*ft}
		object{RoundTower rotate y*180 translate <-50,0, 40>*ft}
		object{SquareTower rotate y*90 translate <0,0,35>*ft}
		object{RoundTower rotate y*270 translate < 50,0, 40>*ft}
		//walls
		object{EastWallC translate <50,0,0>*ft}
		object{SouthWallC translate <0,0,-35>*ft}
		object{NorthWallC translate <0,0,35>*ft}
		object{WestWallC translate <-42.5,0,0>*ft}
		texture{WallStone}
	}
}

#declare Hologram=
texture{
	pigment{colour rgbf <0.9,0.9,0.4,0.8>}
	finish{reflection 0.2}
}

#declare HoloCastle=
union{
	union{//building
		//gatehouse
		object{Barbican translate <50,0,0>*ft}
		//towers
		object{RoundTower rotate y*0 translate < 50,0,-40>*ft}
		object{SquareTower rotate y*-90 translate <0,0,-35>*ft}
		object{RoundTower rotate y*90 translate <-50,0,-40>*ft}
		object{SquareTower rotate y*0 translate <-42.5,0,0>*ft}
		object{RoundTower rotate y*180 translate <-50,0, 40>*ft}
		object{SquareTower rotate y*90 translate <0,0,35>*ft}
		object{RoundTower rotate y*270 translate < 50,0, 40>*ft}
		//walls
		object{EastWallC translate <50,0,0>*ft}
		object{SouthWallC translate <0,0,-35>*ft}
		object{NorthWallC translate <0,0,35>*ft}
		object{WestWallC translate <-42.5,0,0>*ft}
		interior{ior 1.5}
		texture{Hologram}
	}
}

#declare CastleMound=
union{
	prism{
		conic_sweep quadratic_spline
		0.9,1,16
		// the <u,v> points
		< 71,-30>*ft,
		< 71,-51>*ft,< 61,-61>*ft,
		< 21,-61>*ft,<-21,-61>*ft,
		<-61,-61>*ft,<-71,-51>*ft,
		<-71,-21>*ft,<-71, 21>*ft,
		<-71, 51>*ft,<-61, 61>*ft,
		<-21, 61>*ft,< 21, 61>*ft,
		< 61, 61>*ft,< 71, 51>*ft,
		< 71,-51>*ft
		translate <0,-0.9,0>
		scale <1,-200*ft,1>
	}
	box{
		<60,0,-8>*ft,<80,-150,8>*ft
	}
	box{
		<60,0,0>*ft,<80,-150,20>*ft
		rotate x*10
		translate <0,0,8>*ft
	}
	texture{Ground}
}

// Add the buildings, street by street
// special buildings first
#if (Year<1700)
	//full castle
	object{
		Castle
		//#write(DebugFile,"Castle pre-1700 - ")
		translate LandFormGet(<- 120*ft,  320*ft, 1000*ft>)
	}
#else
	//ruined castle
	difference{
	//union{
		object{Castle}
		object{Ruination}
		//#write(DebugFile,"Castle post-1700 - ")
		translate LandFormGet(<- 120*ft,  320*ft, 1000*ft>)
	}
#end
#if (Year>=2058)
	object{
		HoloCastle
		translate LandFormGet(<- 120*ft,  320*ft, 1000*ft>)
	}
#end
#if (Year>=2057)
	object{
		Dome2
		translate LandFormGet(<- 120*ft,  320*ft, 1000*ft>)-<0,-10,0>*ft
	}
#end


//#write(DebugFile,"Castlemound - ")
object{CastleMound translate LandFormGet(<- 120*ft,  320*ft, 1000*ft>)}

#include "simple1.cst"

#declare Person1=
object{
  RTDH2(
		0,<0,0,0>,
		array[7]{
			<1.05,1.1,1>,<1.05,1.2,1>,<1.05,1.1,1>,<1.05,1.1,1>,
			<1.05,1.1,1>,<1.05,0.8,1>,<1.05,0.8,1>
		},
		array[9]{<15,5,0>,
			<0,0,0>,<20,0,0>,<-10,0,0>,<0,0,0>,
			<15,0,0>,<-10,0,0>,<0,10,0>,<0,0,0>
		},
		array[1]{0},
    <0,0,0>,<0,10,0>,<0,0,2>
	)
}

#include "simple2.cst"

#declare Person2=
object{
  RTDH2(
		0,<0,0,0>,
		array[7]{
			<0.95,0.95,0.95>,<0.95,0.95,0.95>,<0.95,0.95,0.95>,<0.95,0.95,0.95>,
			<0.95,0.95,0.95>,<0.95,0.95,0.95>,<0.95,0.95,0.95>
		},
		array[9]{<0,0,0>,
			<-20,0,-2>,<30,0,0>,<0,0,0>,<0,0,0>,
			<0,0,0>,<0,0,0>,<-10,0,0>,<-20,0,0>
		},
		array[1]{0},
		<0,0,0>,<0,-7,0>,<0,0,-6>
	)
}

#include "simple3.cst"

#declare Person3=
object{
  RTDH2(
		0,<0,0,0>,
		array[7]{
			<1,1,1>,<1,1.2,1>,<1,1,1>,<1,1,1>,
			<1,1,1>,<1,0.8,1>,<1,0.8,1>
		},
		array[9]{<-5,2,0>,
			<35,0,0>,<0,0,100>,<25,0,0>,<0,0,-100>,
			<0,0,-10>,<0,0,-6>,<0,0,0>,<0,0,0>
		},
		array[1]{0},
		<0,0,0>,<0,4,0>,<0,0,3>
	)
}

//object{Person1 rotate y*50 translate <-64*ft, 310*ft, 1000*ft>}

//object{Person2 rotate y*-140 translate <-66*ft, 310*ft, 995*ft>}

//object{Person3 translate <-75, 310, 1004>*ft}

#declare ChurchRoof=
box{
	<-.5,-.5,-.5>*ft,<.5,.5,.5>*ft
	rotate x*45
}

#declare ChurchDoorCut=
union{
	box{
		<-3,.25,-.5>*ft,<3,6,1>*ft
	}
	intersection{
	  cylinder{
		  <-3,6,-.5>*ft,<-3,6,1.1>*ft,6*ft
		}
	  cylinder{
		  <3,6,-1>*ft,<3,6,1>*ft,6*ft
		}
	}
}

#declare ChurchWindow1Cut=
union{
	box{
		<-3,3,-.5>*ft,<3,6,1>*ft
	}
	intersection{
	  cylinder{
		  <-3,6,-.5>*ft,<-3,6,1.1>*ft,6*ft
		}
	  cylinder{
		  <3,6,-1>*ft,<3,6,1>*ft,6*ft
		}
		box{
			<-3,4,-1.5>*ft,<3,12,1.2>*ft
		}
	}
}

union{// church
	difference{
		union{
			box{
				<-20,0,-15>*ft,<20,18,15>*ft
			}
			object{
				ChurchRoof
				scale <1,1,1/sqrt(2)>*<40,18,30>
				translate <0,18,0>*ft
			}
			box{
				<-10,0,-25>*ft,<0,18,25>*ft
			}
			object{
				ChurchRoof rotate y*90
				scale <1/sqrt(2),1,1>*<10,12,50>
				translate <-5,18,0>*ft
			}
		}
		box{
			<-19.5,1,-14.5>*ft,<19.5,31,14.5>*ft
		}
		box{
			<-9.5,1,-24.5>*ft,<-0.5,27,24.5>*ft
		}
		object{ChurchDoorCut rotate y*0 translate <-5,0,-25>*ft}
		object{ChurchWindow1Cut rotate y*0 translate <-15,0,-15>*ft}
		object{ChurchWindow1Cut rotate y*0 translate <5,0,-15>*ft}
		object{ChurchWindow1Cut rotate y*0 translate <15,0,-15>*ft}
		object{ChurchDoorCut rotate y*180 translate <-5,0,25>*ft}
		object{ChurchWindow1Cut rotate y*180 translate <-15,0,15>*ft}
		object{ChurchWindow1Cut rotate y*180 translate <5,0,15>*ft}
		object{ChurchWindow1Cut rotate y*180 translate <15,0,15>*ft}
		object{ChurchWindow1Cut rotate y*-90 scale <1,2,1> translate <20,0,0>*ft}
	}
	object{
		ChurchRoof
		scale <1,1,1/sqrt(2)>*<39,17.5,29>
		translate <0,18,0>*ft
		texture{RoofLead}
	}
	object{
		ChurchRoof rotate y*90
		scale <1/sqrt(2),1,1>*<9,11.5,49>
		translate <-5,18,0>*ft
		texture{RoofLead}
	}
	difference{
		union{
			box{
				<-35,0,-10>*ft,<-20,54,10>*ft
			}
			box{
				<-36,48,-11>*ft,<-19,54,11>*ft
			}
		}
		box{
			<-34.5,1,-9.5>*ft,<-20.5,55,9.5>*ft
		}
	}
	object{Person1 rotate y*90 translate <10,0,25>*ft}
	object{Person2 rotate y*-90 translate <12,0,28>*ft}
	object{Person3 rotate y*120 translate <18,0,34>*ft}
	// graves
	union{
		#local XX=-120;
		#while (XX<-30)
			#local ZZ=40;
			#while (ZZ>-90)
				object{
					GraveStone(<XX,0,ZZ>*ft,<0,-90,0>,1)
				}
				#local ZZ=ZZ-9;
			#end
			#local XX=XX+14;
		#end
	}
	texture{WallStone}
	//#write(DebugFile,"Church - ")
	translate LandFormGet(<-  60*ft,  230*ft,  660*ft>)
}

// Wall around churchyard
#declare Churchwall=
union{
	//#write(DebugFile,"Churchwall calls - ")
	DrawWall(
		LandFormGet(<-80,300,760>*ft)+<0,10,0>*ft,LandFormGet(<0,300,820>*ft)+<0,0,0>*ft,
		6*in,4*ft,1,WallStone2
	)
	DrawWall(
		LandFormGet(<0,300,820>*ft)+<0,0,0>*ft,LandFormGet(<66.5,300,750>*ft)+<0,5,0>*ft,
		6*in,4*ft,1,WallStone2
	)
	DrawWall(
		LandFormGet(<66.5,300,750>*ft)+<0,5,0>*ft,LandFormGet(<133,300,680>*ft)+<0,6,0>*ft,
		6*in,4*ft,1,WallStone2
	)
	DrawWall(
		LandFormGet(<-80,300,760>*ft)+<0,10,0>*ft,LandFormGet(<-160,300,740>*ft)+<0,0,0>*ft,
		6*in,4*ft,1,WallStone2
	)
	DrawWall(
		LandFormGet(<-160,300,740>*ft)+<0,0,0>*ft,LandFormGet(<-200,300,730>*ft)+<0,25,0>*ft,
		6*in,4*ft,1,WallStone2
	)
	DrawWall(
		LandFormGet(<-200,300,730>*ft)+<0,25,0>*ft,LandFormGet(<-240,300,720>*ft)+<0,5.5,0>*ft,
		6*in,4*ft,1,WallStone2
	)
	DrawWall(
		LandFormGet(<-240,300,720>*ft)+<0,5.5,0>*ft,LandFormGet(<-240,300,630>*ft)+<0,12,0>*ft,
		6*in,4*ft,1,WallStone2
	)
	DrawWall(
		LandFormGet(<-240,300,630>*ft)+<0,12,0>*ft,LandFormGet(<-240,300,540>*ft)+<0,0,0>*ft,
		6*in,4*ft,1,WallStone2
	)
	DrawWall(
		LandFormGet(<-240,300,540>*ft)+<0,0,0>*ft,LandFormGet(<-80,300,580>*ft)+<0,3,0>*ft,
		6*in,4*ft,1,WallStone2
	)
	DrawWall(
		LandFormGet(<-80,300,580>*ft)+<0,3,0>*ft,LandFormGet(<0,300,580.001>*ft)+<0,5,0>*ft,
		6*in,4*ft,1,WallStone2
	)
	DrawWall(
		LandFormGet(<0,300,580.001>*ft)+<0,5,0>*ft,LandFormGet(<133,300,680>*ft)+<0,6,0>*ft,
		6*in,4*ft,1,WallStone2
	)
	// wall on other side of the footpath
	DrawWall(
		LandFormGet(<-240,300,530>*ft)+<0,0,0>*ft,LandFormGet(<-80,300,570>*ft)+<0,3,0>*ft,
		6*in,4*ft,1,WallStone2
	)
	DrawWall(
		LandFormGet(<-80,300,570>*ft)+<0,3,0>*ft,LandFormGet(<0,300,570.001>*ft)+<0,5,0>*ft,
		6*in,4*ft,1,WallStone2
	)
	DrawWall(
		LandFormGet(<0,300,570.001>*ft)+<0,5,0>*ft,LandFormGet(<133,300,670>*ft)+<0,6,0>*ft,
		6*in,4*ft,1,WallStone2
	)
}

//Garden wall
#declare Gardenwall=
object{
	DrawWall(<0,0,0>*ft,<0,0,120>*ft,6*in,6*ft,1,WallStone2)
	rotate x*-6
}

#declare ChurchFootpath=
union{
	//#write(DebugFile,"Church footpath calls - ")
	DrawRoad(
		LandFormGet(<-240,300,535>*ft)+<0,-5,0>*ft,LandFormGet(<-200,300,545>*ft)+<0,7.5,0>*ft,
		5*ft,1,RoadTar
	)
	DrawRoad(
		LandFormGet(<-200,300,545>*ft)+<0,7.5,0>*ft,LandFormGet(<-180,300,550>*ft)+<0,11,0>*ft,
		5*ft,1,RoadTar
	)
	DrawRoad(
		LandFormGet(<-180,300,550>*ft)+<0,11,0>*ft,LandFormGet(<-160,300,555>*ft)+<0,2,0>*ft,
		5*ft,1,RoadTar
	)
	DrawRoad(
		LandFormGet(<-160,300,555>*ft)+<0,2,0>*ft,LandFormGet(<-80,300,575>*ft)+<0,2,0>*ft,
		5*ft,1,RoadTar
	)
	DrawRoad(
		LandFormGet(<-80,300,575>*ft)+<0,2,0>*ft,LandFormGet(<3.5,300,575.01>*ft)+<0,2,0>*ft,
		5*ft,1,RoadTar
	)
	DrawRoad(
		LandFormGet(<3.5,300,575.01>*ft)+<0,2,0>*ft,LandFormGet(<138,300,675>*ft)+<0,7,0>*ft,
		5*ft,1,RoadTar
	)
}

// bus queue

object{Bus rotate y*180 translate <-250,210,688>*ft}

//object{Person1 rotate y*-90 translate <-265,230,690>*ft}

//object{Person2 rotate y*180 translate <-264.5,230,685>*ft}

//object{Person3 rotate y*180 translate <-265,230,680>*ft}


union{
	object{Churchwall translate <20,0,-15>*ft}
	object{ChurchFootpath translate <20,0,-15>*ft}
}

// Roads and streets

// The new bridge required some landscaping:
LandFormAdjust(<-240,225,800>*ft,10)
LandFormAdjust(<-320,225,840>*ft,5)
LandFormAdjust(<-320,225,760>*ft,5)

LandFormAdjust(<-480,225,800>*ft,5)
LandFormAdjust(<-400,225,840>*ft,5)
LandFormAdjust(<-400,225,760>*ft,5)

#declare AveryRoad=
union{
	//bridge
	DrawRoad(
		LandFormGet(<-550,300,370>*ft)+<0,8.5,0>*ft,LandFormGet(<-1360,300,370>*ft)+<0,5,0>*ft,
		array[3]{25*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
}

#declare Bridge=
union{
	box{//roadbed
		<100,-1,-18>*ft,<-100,0,18>*ft texture{WallStone}
	}
	box{//road
		<110,0,-12.5>*ft,<-110,.25,12.5>*ft texture{RoadTar}
	}
	box{//road markings
		<100,0.25,0.125>*ft,<-100,0.30,0.375>*ft texture{WhitePaint}
	}
	box{
		<100,0.25,-0.125>*ft,<-100,0.30,-0.375>*ft texture{WhitePaint}
	}
	box{//pavement
		<100,0,-12.5>*ft,<-100,.75,-17.5>*ft texture{Pavement}
	}
	box{//pavement
		<100,0,12.5>*ft,<-100,.75,17.5>*ft texture{Pavement}
	}
	box{//wall
		<97,0,18>*ft,<-97,3,17.5>*ft texture{WallStone}
	}
	box{
		<97,0,-18>*ft,<-97,3,-17.5>*ft texture{WallStone}
	}
	//temporary arch; replace before showing in close-up
	difference{
		box{<100,-1,-18>*ft,<-100,-50,18>*ft}
		cylinder{<0,-40,-19>*ft,<0,-40,19>*ft,35*ft scale <2.5,1,1>}
		texture{WallStone}
	}
	//roundabout at eastern end
	difference{
		cylinder{
			<138,0,0>*ft,<138,0.25,0>*ft,38*ft
		}
		cylinder{
			<138,-0.25,0>*ft,<138,0.5,0>*ft,16*ft
		}
		texture{RoadTar}
	}
	//pavement around eastern roundabout
	difference{
		cylinder{
			<138,0,0>*ft,<138,0.75,0>*ft,43*ft
		}
		cylinder{
			<138,-1,0>*ft,<138,1,0>*ft,38*ft
		}
		box{//bridge exit
			<95,-1,-12.5>*ft,<140,1,12.5>*ft
		}
		texture{Pavement}
	}
	cone{//embankment - east
		<138,0,0>*ft,43*ft,<138,-25,0>*ft,50*ft
		texture{Ground}
	}
	//roundabout at western end
	difference{
		cylinder{
			<-138,0,0>*ft,<-138,0.25,0>*ft,38*ft
		}
		cylinder{
			<-138,-0.25,0>*ft,<-138,0.5,0>*ft,16*ft
		}
		texture{RoadTar}
	}
	//pavement around western roundabout
	difference{
		cylinder{
			<-138,0,0>*ft,<-138,0.75,0>*ft,43*ft
		}
		cylinder{
			<-138,-1,0>*ft,<-138,1,0>*ft,38*ft
		}
		box{//bridge exit
			<-95,-1,-12.5>*ft,<-140,1,12.5>*ft
		}
		box{//Avery Road exit
			<-175,-1,-12.5>*ft,<-182,1,12.5>*ft
		}
		box{//Meadow Road exit
			<-150.5,-1,37>*ft,<125.5,1,44>*ft
		}
		box{//Owen Road exit
			<-150.5,-1,-37>*ft,<125.5,1,-44>*ft
		}
		texture{Pavement}
	}
	cone{//embankment - west
		<-138,0,0>*ft,43*ft,<-138,-25,0>*ft,50*ft
		texture{Ground}
	}
	//object{Person1 rotate y*90 translate <-70,0.75,-15>*ft}
	//object{Person2 rotate y*-90 translate <-40,0.75,15>*ft}
	//object{Person3 rotate y*120 translate <-95,0.75,16>*ft}
	object{Bus rotate y*270 translate <-25,0.25,5>*ft}
	/*object{
		Genericar1999saloon(<60,0,-6>*ft,<0,90,0>,
			texture{Metal pigment{rgb <.60,.15,.15>}},
			array[4]{<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,},
			array[6]{0,0,0,0,0,0}
		)
	}
	object{
		Genericar1999saloon(<105,0,7>*ft,<0,270,0>,
			texture{pigment{rgb <.30,.35,.15>}},
			array[4]{<0,-40,0>,<0,-40,0>,<0,0,0>,<0,0,0>,},
			array[6]{0,0,0,0,0,0}
		)
	}*/
	//#write(DebugFile,"Bridge - ")
	//translate LandFormGet(<-250,300,800>*ft)+<-100,20,0>*ft
	//#write(DebugFile,"Bridge=",LandFormGet(<-250,300,800>*ft),"\n")
	//translate LandFormGet(<-240,300,720>*ft)+<-138,-33,0>*ft
	translate LandFormGet(<-240,300,370>*ft)+<-138,0,0>*ft
}
// old bridge centred about: 	translate LandFormGet(<-340,300,720>*ft)+<0,25,0>*ft



#declare CastleRoad=
union{
	//#write(DebugFile,"CastleRoad calls - ")
	//DrawRoad(
	//	LandFormGet(<25,300,840>*ft)+<0,-8,0>*ft,LandFormGet(<178,300,665>*ft)+<0,-4,0>*ft,
	//	array[3]{20*ft,6*ft,4*ft},4,array[3]{RoadTar,Pavement,Pavement}
	//)
	DrawRoad(
		LandFormGet(<31.5,300,832.5>*ft)+<0,-8,0>*ft,LandFormGet(<178,300,665>*ft)+<0,-4,0>*ft,
		array[3]{20*ft,6*ft,4*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	object{
		Car1(
			LandFormGet(<38,300,810>*ft)+<0,-8,0>*ft,<0,130,0>,
			array[5]{
				Carpaint2,Carskirt,Carpaint2,WhitePlastic,Glass
			}
		)
	}
	// Church Lane
	DrawRoad(
		LandFormGet(<178,300,665>*ft)+<0,-4,0>*ft,LandFormGet(<248,300,515>*ft)+<0,-3.5,0>*ft,
		array[3]{20*ft,6*ft,4*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	// Lewis Street
	DrawRoad(//<308,300,275>*ft
		LandFormGet(<248,300,515>*ft)+<0,-3.5,0>*ft,LandFormGet(<278,300,353>*ft)+<0,1,0>*ft,
		array[3]{20*ft,6*ft,4*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<278,300,353>*ft)+<0,1,0>*ft,LandFormGet(<308,300,190>*ft)+<0,4,0>*ft,
		array[3]{20*ft,6*ft,4*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	// River Lane
}

#declare ChurchLane=
union{
	//#write(DebugFile,"ChurchLane calls - ")
	DrawRoad(
		LandFormGet(<178,300,665>*ft)+<0,-4,0>*ft,LandFormGet(<333,300,765>*ft)+<0,-2.5,0>*ft,
		array[3]{12*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	// Keaton Street
	DrawRoad(
		LandFormGet(<333,300,765>*ft)+<0,-2.5,0>*ft,LandFormGet(<453,300,865>*ft)+<0,3,0>*ft,
		array[3]{12*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<453,300,865>*ft)+<0,3,0>*ft,LandFormGet(<613,300,965>*ft)+<0,3.25,0>*ft,
		array[3]{12*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<613,300,965>*ft)+<0,3.25,0>*ft,LandFormGet(<703,300,1015>*ft)+<0,1.5,0>*ft,
		array[3]{12*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
}

#declare ChurchRoad=
union{
	//#write(DebugFile,"ChurchRoad calls - ")
	object{Tree4 translate LandFormGet(<5,300,870>*ft)+<0,-8,0>*ft}
	DrawRoad(
		LandFormGet(<25,300,840>*ft)+<0,-8,0>*ft,LandFormGet(<-10,300,813>*ft)+<0,-30,0>*ft,
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	object{
		Car1(
			LandFormGet(<25,300,840>*ft)+<0,-8,0>*ft,<0,-90,0>,
			array[5]{
				Carpaint1,Carskirt,Carpaint1,WhitePlastic,Glass
			}
		)
	}
	object{
		Car1(
			LandFormGet(<-40,300,775>*ft)+<0,-8,0>*ft,<0,50,0>,
			array[5]{
				Carpaint3,Carskirt,Carpaint3,WhitePlastic,Glass
			}
		)
	}
	//SomeTree(LandFormGet(<-10,300,840>*ft)+<0,-30,0>*ft,<0,0,0>,1)
	//object{Tree2 translate LandFormGet(<-10,300,860>*ft)+<0,-30,0>*ft}
	DrawRoad(
		LandFormGet(<-10,300,813>*ft)+<0,-30,0>*ft,LandFormGet(<-45,300,787>*ft)+<0,-12,0>*ft,
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	//SomeTree(LandFormGet(<-38,300,805>*ft)+<0,-12,0>*ft,<0,0,0>,1)
	//object{Tree3 translate LandFormGet(<-38,300,815>*ft)+<0,-28,0>*ft}
	DrawRoad(
		LandFormGet(<-45,300,787>*ft)+<0,-12,0>*ft,LandFormGet(<-62.5,300,768.5>*ft)+<0,-11,0>*ft,
		//20*ft,0,RoadTar
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	//SomeTree(LandFormGet(<-57,300,793>*ft)+<0,-11,0>*ft,<0,0,0>,1)
	object{Tree4 translate LandFormGet(<-57,300,803>*ft)+<0,-17,0>*ft}
	DrawRoad(
		LandFormGet(<-62.5,300,768.5>*ft)+<0,-11,0>*ft,LandFormGet(<-80,300,760>*ft)+<0,-13,0>*ft,
		//20*ft,0,RoadTar
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	//SomeTree(LandFormGet(<-85,300,785>*ft)+<0,-13,0>*ft,<0,0,0>,1)
	object{Tree2 translate LandFormGet(<-85,300,785>*ft)+<0,-16,0>*ft}
	DrawRoad(
		LandFormGet(<-80,300,760>*ft)+<0,-13,0>*ft,LandFormGet(<-160,300,740>*ft)+<0,-32,0>*ft,
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	object{Tree3 translate LandFormGet(<-165,300,780>*ft)+<0,-32,0>*ft}
	DrawRoad(
		LandFormGet(<-160,300,740>*ft)+<0,-32,0>*ft,LandFormGet(<-240,300,720>*ft)+<0,-33,0>*ft,
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
}

#declare ChurchRoadNorth=
union{
	//#write(DebugFile,"ChurchRoadNorth calls - ")
	DrawRoad(
		LandFormGet(<80,300,1360>*ft)+<0,0,0>*ft,LandFormGet(<82.5,300,1260>*ft)+<0,1,0>*ft,
		array[3]{20*ft,4*ft,4*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<82.5,300,1260>*ft)+<0,1,0>*ft,LandFormGet(<85,300,1160>*ft)+<0,0,0>*ft,
		array[3]{20*ft,4*ft,4*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<85,300,1160>*ft)+<0,0,0>*ft,LandFormGet(<90,300,960>*ft)+<0,-10,0>*ft,
		array[3]{20*ft,4*ft,4*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<90,300,960>*ft)+<0,-10,0>*ft,LandFormGet(<58,300,900>*ft)+<0,-22,0>*ft,
		array[3]{20*ft,4*ft,4*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<58,300,900>*ft)+<0,-22,0>*ft,LandFormGet(<31.5,300,852>*ft)+<0,-8,0>*ft,
		//20*ft,0,RoadTar
		array[3]{20*ft,4*ft,4*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<31.5,300,852>*ft)+<0,-8,0>*ft,LandFormGet(<25,300,840>*ft)+<0,-8,0>*ft,
		//20*ft,0,RoadTar
		array[3]{20*ft,4*ft,4*ft},2,array[3]{RoadTar,Pavement,Pavement}
	)
}

#declare KeatonStreet=
union{
	//#write(DebugFile,"KeatonStreet calls - ")
	DrawRoad(
		LandFormGet(<333,300,765>*ft)+<0,-3,0>*ft,LandFormGet(<383,300,665>*ft)+<0,-2.5,0>*ft,
		array[3]{12*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<383,300,665>*ft)+<0,-2.5,0>*ft,LandFormGet(<408,300,615>*ft)+<0,1,0>*ft,
		array[3]{12*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<408,300,615>*ft)+<0,1,0>*ft,LandFormGet(<433,300,565>*ft)+<0,0,0>*ft,
		array[3]{12*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
}

#declare LewisStreet=
union{
	//#write(DebugFile,"LewisStreet calls - ")
	DrawRoad(
		LandFormGet(<248,300,515>*ft)+<0,-3.5,0>*ft,LandFormGet(<329,300,555>*ft)+<0,-1,0>*ft,
		array[3]{12*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<329,300,555>*ft)+<0,-1,0>*ft,LandFormGet(<410,300,596>*ft)+<0,0,0>*ft,
		array[3]{12*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
}

#declare MeadowRoad=
union{
	//bridge
	DrawRoad(
		LandFormGet(<-516,300,408>*ft)+<0,5,0>*ft,LandFormGet(<-516,300,1360>*ft)+<0,0,0>*ft,
		array[3]{25*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
}

#declare OwenRoad=
union{
	//bridge
	DrawRoad(
		LandFormGet(<-516,300,335>*ft)+<0,6.5,0>*ft,LandFormGet(<-516,300,0>*ft)+<0,0,0>*ft,
		array[3]{25*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
}

#declare Riveredge=
union{
	#write(DebugFile,"Riveredge calls - ")
	DrawRoad(
		LandFormGet(<-240,300,720>*ft)+<0,-33,0>*ft,LandFormGet(<-240,300,630>*ft)+<0,8,0>*ft,
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<-240,300,630>*ft)+<0,8,0>*ft,LandFormGet(<-240,300,580>*ft)+<0,-6,0>*ft,
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<-240,300,580>*ft)+<0,-6,0>*ft,LandFormGet(<-240,300,540>*ft)+<0,-16,0>*ft,
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<-240,300,540>*ft)+<0,-16,0>*ft,LandFormGet(<-240,300,460>*ft)+<0,0,0>*ft,
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<-240,300,460>*ft)+<0,0,0>*ft,LandFormGet(<-200,300,340>*ft)+<0,6,0>*ft,
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	//#write(DebugFile,"Height = ",LandFormGet(<-200,300,360>*ft).y,"\n")
	DrawRoad(
		LandFormGet(<-200,300,340>*ft)+<0,6,0>*ft,LandFormGet(<-190,300,240>*ft)+<0,8,0>*ft,
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<-190,300,240>*ft)+<0,8,0>*ft,LandFormGet(<-180,300,160>*ft)+<0,9,0>*ft,
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<-180,300,160>*ft)+<0,9,0>*ft,LandFormGet(<-170,300,120>*ft)+<0,20,0>*ft,
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<-170,300,120>*ft)+<0,20,0>*ft,LandFormGet(<-160,300,80>*ft),
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	/*
	// River Lane
	DrawRoad(
		LandFormGet(<-160,300,80>*ft),LandFormGet(<0,300,-240>*ft)+<0,10,0>*ft,
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<0,300,-240>*ft),LandFormGet(<160,300,-400>*ft),
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<160,300,-400>*ft),LandFormGet(<330,300,-560>*ft),
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<330,300,-560>*ft),LandFormGet(<430,300,-720>*ft),
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<430,300,-720>*ft),LandFormGet(<480,300,-880>*ft),
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	*/
}

#declare RiverLane=
union{
	//#write(DebugFile,"RiverLane calls - ")
	// River Edge
	DrawRoad(
		LandFormGet(<-160,300,80>*ft),LandFormGet(<-55,300,95>*ft)+<0,2,0>*ft,
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<-55,300,95>*ft)+<0,2,0>*ft,LandFormGet(<50,300,110>*ft)+<0,6,0>*ft,
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<50,300,110>*ft)+<0,6,0>*ft,LandFormGet(<200,300,140>*ft)+<0,9.8,0>*ft,
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<200,300,140>*ft)+<0,9.8,0>*ft,LandFormGet(<254,300,165>*ft)+<0,.5,0>*ft,
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
	DrawRoad(
		LandFormGet(<254,300,165>*ft)+<0,.5,0>*ft,LandFormGet(<308,300,190>*ft)+<0,3,0>*ft,
		array[3]{20*ft,6*ft,6*ft},4,array[3]{RoadTar,Pavement,Pavement}
	)
}

object{AveryRoad}
object{Bridge}
object{CastleRoad}
object{ChurchLane}
object{ChurchRoad}
object{ChurchRoadNorth}
object{KeatonStreet}
object{LewisStreet}
object{MeadowRoad}
//Millway
//NelsonStreet
object{OwenRoad}
object{Riveredge}
object{RiverLane}
//RomerStreet

/*
union{//Test road
	#local Start=<-255,230,-520>*ft;
	#local End=<-55,230,-440>*ft;
	DrawRoad(
		LandFormGet(Start),LandFormGet(End)+<0,15,0>*ft,
		20*ft,0,RoadTar
	)
	DrawRoad(
		LandFormGet(Start),LandFormGet(End)+<0,15,0>*ft,
		20*ft,1,RoadTar
	)
	//
	DrawRoad(
		LandFormGet(Start),LandFormGet(End+<-300,0,200>*ft),
		20*ft,0,RoadTar
	)
	DrawRoad(
		LandFormGet(Start),LandFormGet(End+<-300,0,200>*ft),
		20*ft,1,texture{pigment{Blue}}
	)
	//
	DrawRoad(
		LandFormGet(Start),LandFormGet(End+<-300,0,-200>*ft),
		20*ft,0,RoadTar
	)
	DrawRoad(
		LandFormGet(Start),LandFormGet(End+<-300,0,-200>*ft),
		20*ft,1,texture{pigment{Yellow}}
	)
	//
	DrawRoad(
		LandFormGet(Start),LandFormGet(End+<-300,0,-80>*ft),
		20*ft,0,RoadTar
	)
	DrawRoad(
		LandFormGet(Start),LandFormGet(End+<-300,0,-80>*ft),
		20*ft,1,texture{pigment{Green}}
	)
	//
	/*
	cylinder{Start-<0,150,0>*ft,Start+<0,150,0>*ft,1*ft texture{pigment{Red}}}
	cylinder{End-<0,150,0>*ft,End+<0,150,0>*ft,1*ft texture{pigment{Red}}}
	cylinder{LandFormGet(Start),LandFormGet(End),1*ft texture{pigment{Red}}}
	*/
}
*/

// Houses
/*
#local HouseN=-3;
#while (HouseN<3)
  object{
    RHouse(
      <HouseN*45,0,0>*ft,<0,0,0>,
      <37*ft,2,50*ft>,<45*ft,1*ft,120*ft>,<4*ft,0,20*ft>,
      2,WallStone,ChimneyMaterial,DoorWood,Roof,Lawn,PicketTex,WallStone
    )
  }
  #local HouseN=HouseN+1;
#end
*/

#declare RiveredgeHouse=
union{
	box{
		<-18,-5,-6>*ft,<18,0,15>*ft
		texture{BuildUp}
	}
	OfficeBuilding(0,<0,0,0>,
		array[14]{
			TudorFront,
			TudorFront,TudorBack,TudorSide,
			TudorFrontCorner,TudorBackCorner,TudorBlock,
			TudorUFront,TudorUBack,TudorSide,
			TudorBackCorner,TudorBackCorner,TudorBlock,
			TudorBlock
		},
		array[3]{<3,2,3>,<12,8,6>,<-1,0,-1>},
		array[1]{0}
	)
	object{
		MakeRoof(
			<0,16,3>*ft,<0,0,0>,
			box{<-18,0,-9>*ft,<18,8,9>*ft texture{TudorPlaster}},
			<36,8,18>*ft,
			Roof
		)
	}
}

#declare BrickShop1=
union{
	box{
		<-10,-5,0>*ft,<10,0,15>*ft
		texture{BuildUp}
	}
	//
	object{
		OfficeBuilding(<0,0,2.5>*ft,0,
			array[14]{
				Shop1DoorW,
				Shop1Front,Shop1UFront,Shop1Side,
				Shop1Corner,Shop1UCorner,Shop1Block,
				Shop1UFront,Shop1UFront,Shop1Side,
				Shop1UCorner,Shop1UCorner,Shop1Block,
				Shop1Block
			},
			array[3]{
				<4,2,3>,<5,8,5>,<-1,0,-1>
			},
			array[1]{
				0
			}
		)
	}
	object{
		MakeRoof(
			<0,16,5>*ft,<0,0,0>,
			box{<-10,0,-7.5>*ft,<10,7,7.5>*ft texture{Brick}},
			<20,7,15>*ft,
			Roof
		)
	}
	//
}

#declare BrickShop2=
union{
	box{
		<-10,-5,0>*ft,<10,0,15>*ft
		texture{BuildUp}
	}
	/*
	object{
		OfficeBuilding(<0,0,2.5>*ft,0,
			array[14]{
				Shop1DoorL,// or Shop1DoorR,
				Shop1Front,Shop1UFront,Shop1Side,
				Shop1Corner,Shop1UCorner,Shop1Block,
				Shop1UFront,Shop1UFront,Shop1Side,
				Shop1UCorner,Shop1UCorner,Shop1Block,
				Shop1Block
			},
			array[3]{
				<4,2,3>,<5,8,5>,<-1,0,-1>
			},
			array[1]{
				2
			}
		)
	}
	object{
		MakeRoof(
			<0,16,5>*ft,<0,0,0>,
			box{<-10,0,-7.5>*ft,<10,7,7.5>*ft texture{Brick}},
			<20,7,15>*ft,
			Roof
		)
	}
	*/
}

#declare BrickShop3=
union{
	box{
		<-10,-5,0>*ft,<10,0,15>*ft
		texture{BuildUp}
	}
	/*
	object{
		OfficeBuilding(<0,0,2.5>*ft,0,
			array[14]{
				Shop1DoorR,
				Shop1Front,Shop1UFront,Shop1Side,
				Shop1Corner,Shop1UCorner,Shop1Block,
				Shop1UFront,Shop1UFront,Shop1Side,
				Shop1UCorner,Shop1UCorner,Shop1Block,
				Shop1Block
			},
			array[3]{
				<4,2,3>,<5,8,5>,<-1,0,-1>
			},
			array[1]{
				3
			}
		)
	}
	object{
		MakeRoof(
			<0,16,5>*ft,<0,0,0>,
			box{<-10,0,-7.5>*ft,<10,7,7.5>*ft texture{Brick}},
			<20,7,15>*ft,
			Roof
		)
	}
	*/
}

#declare BrickHouse1R=
union{
	box{
		<-10,-5,0>*ft,<10,0,30>*ft
		texture{BuildUp}
	}
	box{<-10.125,0,0>*ft,<-9.875,3.5,15>*ft texture{Brick}}
	box{<10,0,0>*ft,<9.75,3.5,15>*ft texture{Brick}}
	box{<-10.125,0,0>*ft,<6,3.5,0.25>*ft texture{Brick}}
	box{<6,0,0>*ft,<5.75,4.5,0.25>*ft texture{Brick}}
	box{<9,0,0>*ft,<9.25,4.5,0.25>*ft texture{Brick}}
	box{<9,0,0>*ft,<10,3.5,0.25>*ft texture{Brick}}
	object{
		OfficeBuilding(<0,0,17.5>*ft,0,
			array[14]{
				Shop1DoorH,
				Shop1UFront,Shop1UFront,Shop1Side,
				Shop1UCorner,Shop1UCorner,Shop1Block,
				Shop1UFront,Shop1UFront,Shop1Side,
				Shop1UCorner,Shop1UCorner,Shop1Block,
				Shop1Block
			},
			array[3]{
				<4,2,3>,<5,8,5>,<-1,0,-1>
			},
			array[1]{
				1
			}
		)
	}
	object{
		MakeRoof(
			<0,16,20>*ft,<0,0,0>,
			box{<-10,0,-7.5>*ft,<10,7,7.5>*ft texture{Brick}},
			<20,7,15>*ft,
			Roof
		)
	}
}

#declare BrickHouse1L=
union{
	box{
		<-10,-5,0>*ft,<10,0,30>*ft
		texture{BuildUp}
	}
	box{<10.125,0,0>*ft,<9.875,3.5,15>*ft texture{Brick}}
	box{<-10,0,0>*ft,<-9.75,3.5,15>*ft texture{Brick}}
	box{<10.125,0,0>*ft,<-6,3.5,0.25>*ft texture{Brick}}
	box{<-6,0,0>*ft,<-5.75,4.5,0.25>*ft texture{Brick}}
	box{<-9,0,0>*ft,<-9.25,4.5,0.25>*ft texture{Brick}}
	box{<-9,0,0>*ft,<-10,3.5,0.25>*ft texture{Brick}}
	object{
		OfficeBuilding(<0,0,17.5>*ft,0,
			array[14]{
				Shop1DoorH,
				Shop1UFront,Shop1UFront,Shop1Side,
				Shop1UCorner,Shop1UCorner,Shop1Block,
				Shop1UFront,Shop1UFront,Shop1Side,
				Shop1UCorner,Shop1UCorner,Shop1Block,
				Shop1Block
			},
			array[3]{
				<4,2,3>,<5,8,5>,<-1,0,-1>
			},
			array[1]{
				2
			}
		)
	}
	object{
		MakeRoof(
			<0,16,20>*ft,<0,0,0>,
			box{<-10,0,-7.5>*ft,<10,7,7.5>*ft texture{Brick}},
			<20,7,15>*ft,
			Roof
		)
	}
}

#declare Pub=
union{
	box{
		<-30,-5,-19>*ft,<30,0,12>*ft
		texture{BuildUp}
	}
	box{<-30,3,-19>*ft,<-29.5,3.5,-5>*ft texture{TudorWood}}
	box{<-30,3,-19>*ft,<-3,3.5,-18.5>*ft texture{TudorWood}}
	box{<30,3,-19>*ft,<3,3.5,-18.5>*ft texture{TudorWood}}
	box{<30,3,-19>*ft,<29.5,3.5,-5>*ft texture{TudorWood}}
	#local Loop=-19;
	#while (Loop<-6)
		box{<-30,0,Loop>*ft,<-29.5,3,Loop+0.5>*ft texture{TudorWood}}
		box{<30,0,Loop>*ft,<29.5,3,Loop+0.5>*ft texture{TudorWood}}
		#local Loop=Loop+2;
	#end
	#local Loop=3;
	#while (Loop<30)
		box{<Loop,0,-19>*ft,<Loop+0.5,3,-18.5>*ft texture{TudorWood}}
		box{<-Loop,0,-19>*ft,<-Loop-0.5,3,-18.5>*ft texture{TudorWood}}
		#local Loop=Loop+2;
	#end
	object{
		OfficeBuilding(0,<0,0,0>,
			array[14]{
				TudorFront,
				TudorFrontCorner,TudorBack,TudorSide,
				TudorFrontCorner,TudorBackCorner,TudorBlock,
				TudorBackCorner,TudorUBack,TudorSide,
				TudorBackCorner,TudorBackCorner,TudorBlock,
				TudorBlock
			},
			array[3]{
				<5,2,3>,<12,8,6>,<-1,0,-1>
			},
			array[1]{
				0
			}
		)
	}
	//Sign bracket
	cylinder{<2,7,-5>*ft,<2,7,-8>*ft,0.125*ft texture{pigment{Black}}}
	cylinder{<2,8,-5>*ft,<2,7,-8>*ft,0.125*ft texture{pigment{Black}}}
	box{<1.875,6.75,-5.5>*ft,<2.125,4.75,-8>*ft
		texture{pigment{colour rgb <0.6,0.4,0.3>}}
	}
	object{
		MakeRoof(
			<0,16,3>*ft,<0,0,0>,
			union{
				box{<-30,0,-9>*ft,<30,8,9>*ft texture{TudorPlaster}}
				box{<-30.08,0,-2.84>*ft,<30.08,8,-3.16>*ft texture{TudorWood}}
				box{<-30.08,0,2.84>*ft,<30.08,8,3.16>*ft texture{TudorWood}}
				box{<-30.08,1.92,-9>*ft,<30.08,2.08,9>*ft}
				box{<-30.08,5.42,-9>*ft,<30.08,5.58,9>*ft}
			},
			<62,8,18>*ft,
			Roof
		)
	}
}

#declare Office1=
union{
	object{
		OfficeBuilding(0,0,
			array[14]{
				DoorBlock,
				OffFront,OffRear,OffSide,
				GroundCorner,GroundCorner,TenBlock,
				UpperFront,UpperFront,UpperFront,
				UpperCorner,UpperCorner,TenBlock,
				LiftBlock
			},
			array[3]{
				<10,8,15>,<10,10,10>,<4,0,2>
			},
			array[1]{
				0
			}
		)
	}
	object{
		FlatRoof(0,0,
			array[3]{
				<10,8,15>,<10,10,10>,<4,0,2>
			},
			array[1]{
				texture{pigment{colour rgb <.6,.6,.6>}}
			}
		)
	}
}

#declare Unbuilt=
object{
	OfficeBuilding(0,0,
		array[14]{
			TenBlock,
			TenBlock,TenBlock,TenBlock,
			TenBlock,TenBlock,TenBlock,
			TenBlock,TenBlock,TenBlock,
			TenBlock,TenBlock,TenBlock,
			TenBlock
		},
		array[3]{
			<12,8,15>,<10,10,10>,<-1,0,-1>
		},
		array[1]{
			0
		}
	)
}

//1 Riveredge - fX=300, fZ=120, Ht1=2640.6, Ht2=2533.92, Result=2627.26
//#write(DebugFile,"1 Riveredge - ")
object{
	RiveredgeHouse rotate y*75
	translate LandFormGet(<-215,300,490>*ft)+<0,-6,0>*ft
}

object{Gardenwall rotate y*75 translate LandFormGet(<-215,300,490>*ft)+<5,-6,-20>*ft}

//2 Riveredge - fX=420, fZ=-360, Ht1=2660.06, Ht2=2654.82, Result=2662.03
//#write(DebugFile,"2 Riveredge - ")
object{
	RiveredgeHouse rotate y*75
	translate LandFormGet(<-205,300,450>*ft)+<0,-7,0>*ft
}

object{Gardenwall rotate y*75 translate LandFormGet(<-205,300,450>*ft)+<5,-7,-20>*ft}

//3 Riveredge - fX=-420, fZ=120, Ht1=2560.74, Ht2=2555.29, Result=2560.06
//#write(DebugFile,"3 Riveredge - ")
object{
	RiveredgeHouse rotate y*75
	translate LandFormGet(<-195,300,410>*ft)+<0,2,0>*ft
}

object{Gardenwall rotate y*75 translate LandFormGet(<-195,300,410>*ft)+<5,2,-20>*ft}

//4 Riveredge - fX=-300, fZ=-360, Ht1=2544.15, Ht2=2574.93, Result=2532.61
//#write(DebugFile,"4 Riveredge - ")
object{
	RiveredgeHouse rotate y*75
	translate LandFormGet(<-185,211,370>*ft)+<0,5.5,0>*ft
}

object{Gardenwall rotate y*75 translate LandFormGet(<-185,211,370>*ft)+<2.5,5.5,-20>*ft}

//5 Riveredge - fX=-240, fZ=120, Ht1=2550.96, Ht2=2582.03, Result=2554.84
//#write(DebugFile,"5 Riveredge - ")
object{
	RiveredgeHouse rotate y*80
	translate LandFormGet(<-180,300,330>*ft)+<0,4,0>*ft
}

object{Gardenwall rotate y*80 translate LandFormGet(<-180,300,330>*ft)+<2.5,4,-20>*ft}

//6 Riveredge - fX=-180, fZ=-408, Ht1=2405.57, Ht2=2557.77, Result=2340.89
//#write(DebugFile,"6 Riveredge - ")
object{
	RiveredgeHouse rotate y*80
	translate LandFormGet(<-175,300,286>*ft)+<0,19,0>*ft
}

object{Gardenwall rotate y*80 translate LandFormGet(<-175,300,286>*ft)+<2.5,19,-22>*ft}

//7 Riveredge - fX=-120, fZ=24, Ht1=2413.61, Ht2=2564.58, Result=2417.38
//#write(DebugFile,"7 Riveredge - ")
object{
	RiveredgeHouse rotate y*80
	translate LandFormGet(<-170,300,242>*ft)+<0,8,0>*ft
}

object{Gardenwall rotate y*80 translate LandFormGet(<-170,300,242>*ft)+<2.5,8,-22>*ft}

//8 Riveredge - fX=-60, fZ=456, Ht1=2413.75, Ht2=2421.64, Result=2417.5
//#write(DebugFile,"8 Riveredge - ")
object{
	RiveredgeHouse rotate y*80
	translate LandFormGet(<-165,300,198>*ft)+<0,7,0>*ft
}

object{Gardenwall rotate y*80 translate LandFormGet(<-165,300,198>*ft)+<2.5,7,-22>*ft}

//9 Riveredge - fX=0, fZ=-72, Ht1=2407.53, Ht2=2539.3, Result=2397.65
//#write(DebugFile,"9 Riveredge - ")
object{
	RiveredgeHouse rotate y*80
	translate LandFormGet(<-160,300,154>*ft)+<0,9,0>*ft
}

object{Gardenwall rotate y*80 translate LandFormGet(<-160,300,154>*ft)+<2.5,9,-22>*ft}

//10 Riveredge - fX=60, fZ=360, Ht1=2414.93, Ht2=2546.62, Result=2464.32
//#write(DebugFile,"10 Riveredge - ")
object{
	RiveredgeHouse rotate y*80
	translate LandFormGet(<-155,300,110>*ft)+<0,0,0>*ft
}

// Keaton Street
union{
	object{
		BrickShop1
		translate <0,-1,0>*ft
	}
	object{
		BrickShop1
		translate <20,0,0>*ft
	}
	object{
		BrickShop1
		translate <40,1,0>*ft
	}
	object{
		BrickShop1
		translate <60,2.5,0>*ft
	}
	object{
		BrickShop1
		translate <80,3.5,0>*ft
	}
	object{
		BrickShop1
		translate <100,5,0>*ft
	}
	object{
		BrickShop1
		translate <120,6,0>*ft
	}
	object{
		BrickShop1
		translate <140,7,0>*ft
	}
	rotate y*65
	translate LandFormGet(<356,300,755>*ft)
}

// Lewis Street
union{
	object{
		BrickShop1
		translate <0,0,0>*ft
	}
	object{
		BrickShop1
		translate <20,0,0>*ft
	}
	object{
		BrickShop1
		translate <40,0,0>*ft
	}
	object{
		BrickShop1
		translate <60,0,0>*ft
	}
	object{
		BrickShop1
		translate <80,0,0>*ft
	}
	object{
		BrickShop1
		translate <100,-0.5,0>*ft
	}
	object{
		BrickShop1
		translate <120,-1.5,0>*ft
	}
	object{
		BrickShop1
		translate <140,-2,0>*ft
	}
	rotate y*153.5
	translate LandFormGet(<400,300,580>*ft)
}

// Castle Road side of square
union{
	object{
		BrickShop1
		translate <0,-2,0>*ft
	}
	object{
		BrickShop1
		translate <20,-2,0>*ft
	}
	object{
		BrickShop1
		translate <40,-3,0>*ft
	}
	object{
		BrickShop1
		translate <60,-3,0>*ft
	}
	object{
		BrickShop1
		translate <80,-4,0>*ft
	}
	object{
		BrickShop1
		translate <100,-4.5,0>*ft
	}
	object{
		BrickShop1
		translate <120,-5,0>*ft
	}
	object{
		BrickShop1
		translate <140,-5.5,0>*ft
	}
	rotate y*246
	translate LandFormGet(<223,300,520>*ft)
}

// Church Lane side of square
union{
	object{
		BrickShop1
		translate <0,-9,0>*ft
	}
	object{
		BrickShop1
		translate <20,-9.5,0>*ft
	}
	object{
		BrickShop1
		translate <40,-9.5,0>*ft
	}
	object{
		BrickShop1
		translate <60,-9.5,0>*ft
	}
	object{
		BrickShop1
		translate <80,-9.5,0>*ft
	}
	object{
		BrickShop1
		translate <100,-9.5,0>*ft
	}
	object{
		BrickShop1
		translate <120,-9.5,0>*ft
	}
	object{
		BrickShop1
		translate <140,-9,0>*ft
	}
	rotate y*-33
	translate LandFormGet(<192,300,688>*ft)
}

// Castle Road opposite the church
union{
	object{
		Pub
		translate <0,-8,0>*ft
	}
	object{
		BrickHouse1L
		translate <45,-8,-18>*ft
	}
	object{
		BrickHouse1R
		translate <65,-8,-18>*ft
	}
	object{
		BrickHouse1L
		translate <85,-6,-18>*ft
	}
	object{
		BrickHouse1R
		translate <105,-6,-18>*ft
	}
	object{
		BrickHouse1L
		translate <125,-4,-18>*ft
	}
	object{
		BrickHouse1R
		translate <145,-4,-18>*ft
	}
	rotate y*49
	translate LandFormGet(<86,300,829>*ft)
}

// OldBlock TenBlock

// out-of-town shopping
#if (Year>2015)
	union{
		box{
			<-215,-1,800>*ft,<-15,0,0>*ft
			texture{BuildUp}
		}
		object{Unbuilt rotate y*-90 translate <-25,0,85>*ft}
		object{Unbuilt rotate y*-90 translate <-25,0,235>*ft}
		object{Unbuilt rotate y*-90 translate <-25,0,385>*ft}
		object{Unbuilt rotate y*-90 translate <-25,0,535>*ft}
		box{<-20,0,5>*ft,<-21,10,605>*ft texture{DoorWood}}
		box{
			<-215,-1,-800>*ft,<-15,0,-50>*ft
			texture{BuildUp}
		}
		object{Office1 rotate y*-90 translate <-20,0,-110>*ft}
		box{
			<-415,-1,800>*ft,<-215,5,0>*ft
			texture{RoadTar}
		}
		box{
			<-415,-1,-800>*ft,<-215,10,-50>*ft
			texture{RoadTar}
		}
		box{
			<-615,-1,800>*ft,<-415,15,0>*ft
			texture{BuildUp}
		}
		box{
			<-615,-1,-800>*ft,<-415,20,-50>*ft
			texture{BuildUp}
		}
		object{Office1 rotate y*-90 translate <-420,20,-110>*ft}
		object{Office1 rotate y*-90 scale <1,1.75,1.25> translate <-420,20,-350>*ft}
		box{
			<-815,-1,800>*ft,<-415,25,0>*ft
			texture{BuildUp}
		}
		box{
			<-815,-1,-800>*ft,<-615,30,-50>*ft
			texture{RoadTar}
		}
		translate LandFormGet(<-516,300,408>*ft)+<0,6,0>*ft
	}
#end

object{
	Car1(
		<-180,520,620>*ft,<0,-135,0>,
		array[5]{
			Carpaint3,Carskirt,Carpaint1,WhitePlastic,Glass
		}
	)
}

// Hoarding
union{
	difference{
		box{<-21,-1,-1>*ft,<21,21,1>*ft}
		box{<-20,0,-2>*ft,<20,20,0>*ft texture{Credits}}
	}
	box{<-21,-10,-0.9>*ft,<21,-1,0.9>*ft}
	texture{DoorWood}
	rotate y*-70
	translate LandFormGet(<35,300,950>*ft)+<5,15,0>*ft
}


// Add the details

/* Long long checklist:
// Bridge
	- Fit an arch to the new bridge
	- Humpback bridge before 1982 - needs building from scratch
	- New bridge after 1982
	- Bridge mall from 2065
// Castle
	- correct ruination to cut properly
	- add details to windows and arrowslits
	- detail gateway
	- detail each tower
	- add visitor centre
	- add protective dome
	- add hologram from 2058
	- mound wasn't there before 1240
	- castle wasn't there before 1250
// Church
	- correct floor
	- fix lead's reflectivity
	- add doors
	- add window detailing
	- add drainpipes and other little details
	- add interior detail - pews
	- add interior detail - internal walls and doors
	- add interior detail - altar
	- add interior detail to steeple
	- add boundary wall
	- add paths through cemetery
	- add sign
	- add noticeboard
	- add graves to cemetery
// Church Road
	- fix road
// Meadow development
	- Out of town shops develop from 2001
// Riveredge
	- Add bus stops
	- Build 1882 houses
	- Build 2030+ redevelopment
// School
//...misc
	- Add a bus at the Riveredge stop
	- Scatter some cars around
	- Relandscape as needed
	- Tree museum
	- Clean up the warning messages
*/

                                                            n   n   >                              village.incs(EX) Apr 20009e fil TEXTMPS  @                        s t        iM
U                            TEXTMPS                                                              H 	Monaco  Buthe village.\r"  2  >  >  >$      >$               n   n   >@Eh    >  MPSR  
           L>l                                                                                    