// 000317: IRTC. Topic: The City
 
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

#include "..\inc\metric-m.pov"  // Metric measure, meters

#declare BKx = 100*m;
#declare BKy = 100*m;
#declare BKz = 100*m;
#declare Fr = 0.5*m;
#declare SFr = 0.125*m;
#declare ABx = BKx - 2 * Fr;
#declare ABy = BKy - 2 * Fr;
#declare ABz = BKz - 2 * Fr;
#declare FLy = ABy / 50;         // Floor height
#declare AptSeed1 = seed(1);     // Unit sizes
#declare AptSeed2 = seed(2);     // Unit light levels
#declare AptSeed3 = seed(3);     // Depth of detail unit
#declare CameraLoc = <1*m , 3 * BKy , -2.5 * BKz>;
#declare ComplexThreshold = 10 * BKx;
#declare ComposeOnly = 0;        // Composition mode uses simple objects
#declare D = 0.0001;             // CSG overlap
#declare DetailThreshold = 6 * BKx;
#declare EarthR = 6371377*m;
#declare GlassRefl = 0.5;
#declare IAx = 0.25 * ABx;
#declare IAz = 0.25 * ABz;
#declare IBx = 0.75 * ABx;
#declare IBz = 0.75 * ABz;
#declare IlluminatedAmbience = 1.0;
#declare MidBlock = 0;           // Flag to render only middle of detail blocks
#declare OrbitH = 15000*m;
#declare OrbitR = EarthR + OrbitH;
#declare UnitFloorTex = array[100]
#declare UnitInTex = array[100]
#declare UnitLocations = array[50][4][52]
#declare UnitLight = array[50][4][52]
#declare UnitOutTex = array[100]

#declare FlatFill = texture { pigment { rgb <0.7, 0.7, 0.8> } }
#declare FloorTex = texture { pigment { rgb <0.8, 0.8, 0.8> } finish { ambient IlluminatedAmbience } }
#declare Frame = texture { pigment { rgb <1, 1, 1> }  finish { diffuse 0.85 reflection GlassRefl - 0.1 } }
#declare Window = texture { pigment { rgbt <1, 1, 1, 0.9> }  finish { reflection GlassRefl } }

camera
{
  location  CameraLoc
  look_at   <0.0 , 0.0 , 0.0>
}

light_source
{
  <-10*m, 200*m, -100*m> color rgb <1, 1, 1>
}

light_source
{
  <-10*m, 10*1000*1000*m, 10*1000*1000*m> color rgb <1, 1, 1>
}

#macro UnitSize()
   #local Ur = rand(AptSeed1);
   #switch (Ur)
   #range (0, 0.05)
      #declare Unit = 5*m;
   #range (0.05, 0.25)
      #declare Unit = 4*m;
   #range (0.25, 0.65)
      #declare Unit = 3*m;
   #else
      #declare Unit = 2*m;
   #end
#end

#macro ComputeUnitLocations()
   // Initialize all elements so we can debug
   #local Floor = 50;
   #while (Floor)
      #local Floor = Floor - 1;       
      // Count through the four sides of the block
      #local Side = 4;
      #while (Side)
         #local Side = Side - 1;
         #local Col = 52;
         #while (Col)
            #local Col = Col - 1;
            #declare UnitLocations[Floor][Side][Col] = -1;            
            #declare UnitLight[Floor][Side][Col] = -1;            
         #end
      #end
   #end
   // Loop for each floor in the block
   #local Floor = 50;
   #while (Floor)
      #local Floor = Floor - 1;       
      // Count through the four sides of the block
      #local Side = 4;
      #while (Side)
         #local Side = Side - 1;
         // Calcualte a weighted random allocation of unit sizes
         #local Disp = 0;
         #local Col = 0;
         // calculate displacement limit such that the last step is at least 2m
         #if ((Side = 0) | (Side = 2))
            #local Max = ABx;
         #else
            #local Max = ABz;
         #end
         #local Limit = Max - 2*m;
         #while (Disp <= Limit)
            #local Ur = rand(AptSeed1);
            #switch (Ur)
            #range (0, 0.05)
               #local Unit = 5*m;
               #break
            #range (0.05, 0.25)
               #local Unit = 4*m;
               #break
            #range (0.25, 0.65)
               #local Unit = 3*m;
               #break
            #else
               #local Unit = 2*m;
               #break
            #end           
            #declare UnitLocations[Floor][Side][Col] = Disp;
            #declare UnitLight[Floor][Side][Col] = rand(AptSeed2);
            #local Disp = Disp + Unit;
            #local Col = Col + 1;
         #end
         #declare UnitLocations[Floor][Side][Col] = Max;
         #declare UnitLocations[Floor][Side][Col + 1] = 0;
         #declare UnitLight[Floor][Side][Col + 1] = rand(AptSeed2);
         // Ensure the light in the corner units is always the same
         // on both sides.
         #if (Side = 3)
            // Remember the location until side 0 is done
            #declare Wrap = Col - 1;
         #else
            // Set the first light to the same as last light of previous side
            #declare UnitLight[Floor][Side][Col - 1] = UnitLight[Floor][Side + 1][0];
         #end  // Unit allocation
      #end  // Sides
      // Copy the last light of the last side to the first location of first side
      #declare UnitLight[Floor][3][Wrap] = UnitLight[Floor][0][0];
   #end  // Floors
#end

#macro UnitTex()
   #local Threshold = 0.7;
   #local Ind=100;
   #while (Ind)
      #local Ind = Ind -1;
      #local Light = Ind / 100;
      // Computes unit textures based on a number from 0 to 1 
      #if (Light < Threshold)
         #declare UnitOutTex[Ind] = texture {
            pigment { rgb <0.4, 0.4, 0.5> }
            finish { reflection GlassRefl }
         }
         #declare UnitInTex[Ind] = texture {
            pigment { rgb <0.4, 0.4, 0.5> }
         }
         #declare UnitFloorTex[Ind] = texture {
            pigment { rgb <0.4, 0.4, 0.5> }
         }
      #else
         #local Bright = (Light - Threshold) / (1 - Threshold);
         #declare UnitOutTex[Ind] = texture {
            pigment { rgb <0.5, 0.5, 0.5> + Bright * <0.6, 0.6, 0.0> }
            finish { ambient IlluminatedAmbience reflection GlassRefl }
         }
         #declare UnitInTex[Ind] = texture {
            pigment { rgb <0.5, 0.5, 0.5> + Bright * <0.6, 0.6, 0.0> }
            finish { ambient IlluminatedAmbience }
         }
         #declare UnitFloorTex[Ind] = texture {
            pigment { rgb <0.4, 0.4, 0.4> + Bright * <0.5, 0.5, 0.0> }
            finish { ambient IlluminatedAmbience }
         }
      #end
   #end
#end

#macro UnitTexOld(P)
   // Texture selection for rooms
   // keep corner units same
   #if (P)
      // Not the first position, so allocate a new light value
      #declare RoomLight = rand(AptSeed2);
   #end
   UnitTex(RoomLight)
#end

#macro UnitFace(Complexity, Floor, Side, Col)
   #local More = UnitLocations[Floor][Side][Col + 1];
   #switch (Side)
   #case (0)
      #local dV = <UnitLocations[Floor][Side][Col - 1], Floor * FLy, 0>;
      #local rV = <0, 0, 0>;
      #break
   #case (1)
      #local dV = <ABx, Floor * FLy, UnitLocations[Floor][Side][Col - 1]>;
      #local rV = <0, 270, 0>;
      #break
   #case (2)
      #local dV = <ABx - UnitLocations[Floor][Side][Col - 1], Floor * FLy, ABz>;
      #local rV = <0, 180, 0>;
      #break
   #case (3)
      #local dV = <0, Floor * FLy, ABz - UnitLocations[Floor][Side][Col - 1]>;
      #local rV = <0, 90, 0>;
      #break
   #end
   #local US = UnitLocations[Floor][Side][Col] - UnitLocations[Floor][Side][Col - 1]; 
   #if (UnitLight[Floor][Side][Col] = -1)
      //#debug concat("no light at ", str(Floor,0,0), " ", str(Side,0,0), " ", str(Col,0,0), "\n")
      #local UL = 0;
   #else
      #local UL = floor(UnitLight[Floor][Side][Col] * 100);
   #end
   #if (Complexity <= 1)
      // Just create a face on the unit
      triangle {
         <0, 0, 0> + dV, vrotate(<US, 0, 0>, rV) + dV, vrotate(<US, FLy, 0>, rV) + dV
         texture { UnitOutTex[UL] }
      }
      triangle { 
         <0, 0, 0> + dV, vrotate(<0, FLy, 0>, rV) + dV, vrotate(<US, FLy, 0>, rV) + dV
         texture { UnitOutTex[UL] }
      }
   #else
      // Create a unit interior
      // calculate a depth
      #local UD = ceil(3 * rand(AptSeed3) + 1) * m;
      #if (Col)
         // Left face
         triangle {
            vrotate(<0.01, 0, 0>, rV) + dV, vrotate(<0.01, 0, UD>, rV) + dV, vrotate(<0.01, FLy, UD>, rV) + dV
            texture { UnitInTex[UL] }
         }
         triangle {
            vrotate(<0.01, 0, 0>, rV) + dV, vrotate(<0.01, FLy, UD>, rV) + dV, vrotate(<0.01, FLy, 0>, rV) + dV
            texture { UnitInTex[UL] }
         }
      #end
      // Back wall
      triangle {
         vrotate(<0, 0, UD>, rV) + dV, vrotate(<US, 0, UD>, rV) + dV, vrotate(<US, FLy, UD>, rV) + dV 
         texture { UnitInTex[UL] }
      }
      triangle {
         vrotate(<0, 0, UD>, rV) + dV, vrotate(<0, FLy, UD>, rV) + dV, vrotate(<US, FLy, UD>, rV) + dV
         texture { UnitInTex[UL] }
      }
      // Floor
      triangle {
         vrotate(<0, D, 0>, rV) + dV, vrotate(<0, D, UD>, rV) + dV, vrotate(<US, D, UD>, rV) + dV 
         texture { UnitFloorTex[UL] }
      }
      triangle {
         vrotate(<0, D, 0>, rV) + dV, vrotate(<US, D, UD>, rV) + dV, vrotate(<US, D, 0>, rV) + dV
         texture { UnitFloorTex[UL] }
      }
      // Ceiling
      triangle {
         vrotate(<0, FLy - D, 0>, rV) + dV, vrotate(<0, FLy - D, UD>, rV) + dV, vrotate(<US, FLy - D, UD>, rV) + dV 
         texture { UnitFloorTex[UL] }
      }
      triangle {
         vrotate(<0, FLy - D, 0>, rV) + dV, vrotate(<US, FLy - D, UD>, rV) + dV, vrotate(<US, FLy - D, 0>, rV) + dV
         texture { UnitFloorTex[UL] }
      }
      #if (More)
         // Right face
         triangle {
            vrotate(<US - 0.01, 0, 0>, rV) + dV, vrotate(<US - 0.01, 0, UD>, rV) + dV, vrotate(<US - 0.01, FLy, UD>, rV) + dV
            texture { UnitInTex[UL] }
         }
         triangle {
            vrotate(<US - 0.01, 0, 0>, rV) + dV, vrotate(<US - 0.01, FLy, UD>, rV) + dV, vrotate(<US - 0.01, FLy, 0>, rV) + dV
            texture { UnitInTex[UL] }
         }
      #end
      // Front Window
      triangle {
         vrotate(<0, 0, 0>, rV) + dV, vrotate(<US, 0, 0>, rV) + dV, vrotate(<US, FLy, 0>, rV) + dV 
         texture { Window }
      }
      triangle {
         vrotate(<0, 0, 0>, rV) + dV, vrotate(<0, FLy, 0>, rV) + dV, vrotate(<US, FLy, 0>, rV) + dV
         texture { Window }
      }
   #end
#end

#macro AptBlock(Complexity)

   union {
      // Build a heavy outside frame
      // Bottom edges
      cylinder { <  0,   0,   0> <ABx,   0,   0> Fr texture { Frame } }
      cylinder { <ABx,   0,   0> <ABx,   0, ABz> Fr texture { Frame } }
      cylinder { <  0,   0, ABz> <ABx,   0, ABz> Fr texture { Frame } }
      cylinder { <  0,   0,   0> <  0,   0, ABz> Fr texture { Frame } }
      sphere {   <  0,   0,   0> Fr texture { Frame } }
      sphere {   <ABx,   0,   0> Fr texture { Frame } }
      sphere {   <ABx,   0, ABz> Fr texture { Frame } }
      sphere {   <  0,   0, ABz> Fr texture { Frame } }
      // Top edges
      cylinder { <  0, ABy,   0> <ABx, ABy,   0> Fr texture { Frame } }
      cylinder { <ABx, ABy,   0> <ABx, ABy, ABz> Fr texture { Frame } }
      cylinder { <  0, ABy, ABz> <ABx, ABy, ABz> Fr texture { Frame } }
      cylinder { <  0, ABy,   0> <  0, ABy, ABz> Fr texture { Frame } }
      sphere {   <  0, ABy,   0> Fr texture { Frame } }
      sphere {   <ABx, ABy,   0> Fr texture { Frame } }
      sphere {   <ABx, ABy, ABz> Fr texture { Frame } }
      sphere {   <  0, ABy, ABz> Fr texture { Frame } }
      // Vertical edges   
      cylinder { <  0,   0,   0> <  0, ABy,   0> Fr texture { Frame } }
      cylinder { <ABx,   0,   0> <ABx, ABy,   0> Fr texture { Frame } }
      cylinder { <ABx,   0, ABz> <ABx, ABy, ABz> Fr texture { Frame } }
      cylinder { <  0,   0, ABz> <  0, ABy, ABz> Fr texture { Frame } }
      // Build a heavy inside frame
      // Bottom edges
      cylinder { <IAx,   0, IAz> <IBx,   0, IAz> Fr texture { Frame } }
      cylinder { <IBx,   0, IAz> <IBx,   0, IBz> Fr texture { Frame } }
      cylinder { <IAx,   0, IBz> <IBx,   0, IBz> Fr texture { Frame } }
      cylinder { <IAx,   0, IAz> <IAx,   0, IBz> Fr texture { Frame } }
      sphere {   <IAx,   0, IAz> Fr texture { Frame } }
      sphere {   <IBx,   0, IAz> Fr texture { Frame } }
      sphere {   <IBx,   0, IBz> Fr texture { Frame } }
      sphere {   <IAx,   0, IBz> Fr texture { Frame } }
      // Top edges
      cylinder { <IAx, ABy, IAz> <IBx, ABy, IAz> Fr texture { Frame } }
      cylinder { <IBx, ABy, IAz> <IBx, ABy, IBz> Fr texture { Frame } }
      cylinder { <IAx, ABy, IBz> <IBx, ABy, IBz> Fr texture { Frame } }
      cylinder { <IAx, ABy, IAz> <IAx, ABy, IBz> Fr texture { Frame } }
      sphere {   <IAx, ABy, IAz> Fr texture { Frame } }
      sphere {   <IBx, ABy, IAz> Fr texture { Frame } }
      sphere {   <IBx, ABy, IBz> Fr texture { Frame } }
      sphere {   <IAx, ABy, IBz> Fr texture { Frame } }
      // Vertical edges   
      cylinder { <IAx,   0, IAz> <IAx, ABy, IAz> Fr texture { Frame } }
      cylinder { <IBx,   0, IAz> <IBx, ABy, IAz> Fr texture { Frame } }
      cylinder { <IBx,   0, IBz> <IBx, ABy, IBz> Fr texture { Frame } }
      cylinder { <IAx,   0, IBz> <IAx, ABy, IBz> Fr texture { Frame } }
      // Diagonal links to tie the frames together
      // Bottom
      cylinder { <  0,   0,   0> <IAx,   0, IAz> Fr texture { Frame } }
      cylinder { <ABx,   0,   0> <IBx,   0, IAz> Fr texture { Frame } }
      cylinder { <ABx,   0, ABz> <IBx,   0, IBz> Fr texture { Frame } }
      cylinder { <  0,   0, ABz> <IAx,   0, IBz> Fr texture { Frame } }
      // Top
      cylinder { <  0, ABy,   0> <IAx, ABy, IAz> Fr texture { Frame } }
      cylinder { <ABx, ABy,   0> <IBx, ABy, IAz> Fr texture { Frame } }
      cylinder { <ABx, ABy, ABz> <IBx, ABy, IBz> Fr texture { Frame } }
      cylinder { <  0, ABy, ABz> <IAx, ABy, IBz> Fr texture { Frame } }
      mesh {
         // Simple material to cover top and bottom
         // Bottom
         triangle { <  0,   0,   0>, <ABx,   0,   0>, <IBx,   0, IAz> }
         triangle { <  0,   0,   0>, <IAx,   0, IAz>, <IBx,   0, IAz> }         
         triangle { <ABx,   0,   0>, <ABx,   0, ABz>, <IBx,   0, IBz> }
         triangle { <ABx,   0,   0>, <IBx,   0, IBz>, <IBx,   0, IAz> }         
         triangle { <ABx,   0, ABz>, <  0,   0, ABz>, <IAx,   0, IBz> }
         triangle { <ABx,   0, ABz>, <IBx,   0, IBz>, <IAx,   0, IBz> }         
         triangle { <  0,   0, ABz>, <  0,   0,   0>, <IAx,   0, IAz> }
         triangle { <  0,   0, ABz>, <IAx,   0, IBz>, <IAx,   0, IAz> }
         // Top
         triangle { <  0, ABy,   0>, <ABx, ABy,   0>, <IBx, ABy, IAz> }
         triangle { <  0, ABy,   0>, <IAx, ABy, IAz>, <IBx, ABy, IAz> }
         triangle { <ABx, ABy,   0>, <ABx, ABy, ABz>, <IBx, ABy, IBz> }
         triangle { <ABx, ABy,   0>, <IBx, ABy, IBz>, <IBx, ABy, IAz> }
         triangle { <ABx, ABy, ABz>, <  0, ABy, ABz>, <IAx, ABy, IBz> }
         triangle { <ABx, ABy, ABz>, <IBx, ABy, IBz>, <IAx, ABy, IBz> }
         triangle { <  0, ABy, ABz>, <  0, ABy,   0>, <IAx, ABy, IAz> }
         triangle { <  0, ABy, ABz>, <IAx, ABy, IBz>, <IAx, ABy, IAz> }
         // Simple material to cover inner core
         triangle { <IAx,   0, IAz>, <IAx, ABy, IAz>, <IBx, ABy, IAz> }
         triangle { <IAx,   0, IAz>, <IBx, ABy, IAz>, <IBx,   0, IAz> }
         triangle { <IAx,   0, IAz>, <IAx, ABy, IAz>, <IAx, ABy, IBz> }
         triangle { <IAx,   0, IAz>, <IAx, ABy, IBz>, <IAx,   0, IBz> }
         triangle { <IBx,   0, IBz>, <IBx, ABy, IBz>, <IBx, ABy, IAz> }
         triangle { <IBx,   0, IBz>, <IBx, ABy, IAz>, <IBx,   0, IAz> }
         triangle { <IBx,   0, IBz>, <IBx, ABy, IBz>, <IAx, ABy, IBz> }
         triangle { <IBx,   0, IBz>, <IAx, ABy, IBz>, <IAx,   0, IBz> }
         texture { FlatFill }
      }
      // Demark each level
      #if (Complexity = 0)
         // Create an average yellow-gray panel for each face
         box { <  0,   0,   0> <ABx, ABy, 0.1>
            texture {
               pigment { rgb <0.55, 0.55, 0.4> }
               finish { reflection GlassRefl ambient IlluminatedAmbience }
            }
         }
         box { <ABx,   0,   0> <ABx - 0.1, ABy, ABz>
            texture {
               pigment { rgb <0.55, 0.55, 0.4> }
               finish { reflection GlassRefl ambient IlluminatedAmbience }
            }
         }
         box { <  0,   0, ABz> <ABx, ABy, ABz - 0.1>
            texture {
               pigment { rgb <0.55, 0.55, 0.4> }
               finish { reflection GlassRefl ambient IlluminatedAmbience }
            }
         }
         box { <  0,   0,   0> <0.1, ABy, ABz>
            texture {
               pigment { rgb <0.55, 0.55, 0.4> }
               finish { reflection GlassRefl ambient IlluminatedAmbience }
            }
         }
      #end
      // If there are individual units, allocate space and lights for them
      #if (Complexity != 0)
         ComputeUnitLocations()
         // Create the unit mesh
         mesh {
            #declare Floor = 50;
            #declare By = ABy / 50;
            #while (Floor)      
               #declare Floor = Floor - 1;
               #if ((MidBlock = 0) | (abs(By - ABy * 0.5) < 10))   // test only, just render in the middle
                  #if (Complexity = 2.1)
                     // Insert floor
                     #local Fy = By - FLy + SFr;
                     triangle { <  0,  Fy,   0>, <ABx,  Fy,   0>, <IBx,  Fy, IAz> texture { FloorTex } }
                     triangle { <  0,  Fy,   0>, <IBx,  Fy, IAz>, <IAx,  Fy, IAz> texture { FloorTex } }
                     triangle { <ABx,  Fy,   0>, <ABx,  Fy, ABz>, <IBx,  Fy, IBz> texture { FloorTex } }
                     triangle { <ABx,  Fy,   0>, <IBx,  Fy, IBz>, <IBx,  Fy, IAz> texture { FloorTex } }
                     triangle { <ABx,  Fy, ABz>, <  0,  Fy, ABz>, <IAx,  Fy, IBz> texture { FloorTex } }
                     triangle { <ABx,  Fy, ABz>, <IAx,  Fy, IBz>, <IBx,  Fy, IBz> texture { FloorTex } }
                     triangle { <  0,  Fy, ABz>, <  0,  Fy,   0>, <IAx,  Fy, IAz> texture { FloorTex } }
                     triangle { <  0,  Fy, ABz>, <IAx,  Fy, IAz>, <IAx,  Fy, IBz> texture { FloorTex } }
                  #end
                  #if (Complexity != 0)
                     // Fill in room lights
                     #local Side = 4;
                     #while (Side)
                        #local Side = Side - 1;
                        #declare UI = 1;
                        #while (UnitLocations[Floor][Side][UI])
                           // Fill in demarks for each unit 
                           UnitFace(Complexity, Floor, Side, UI)
                           #declare UI = UI + 1;
                        #end
                     #end
                  #end // if complexity = 0
               #end // test restriction to middle of unit
               #declare By = By + FLy;
            #end
         }
         // Fill in pillars
         #declare By = FLy; // + ABy;
         #while (By <= ABy)
            #if ((MidBlock = 0) | (abs(By - ABy * 0.5) < 10))   // test only, just render in the middle
               #if (By < ABy)
                  cylinder { <  0,  By,   0> <ABx,  By,   0> SFr texture { Frame } }
                  cylinder { <ABx,  By,   0> <ABx,  By, ABz> SFr texture { Frame } }
                  cylinder { <  0,  By, ABz> <ABx,  By, ABz> SFr texture { Frame } }
                  cylinder { <  0,  By,   0> <  0,  By, ABz> SFr texture { Frame } }
               #end
               #if (Complexity != 034)
                  // Fill in room lights
                  // Front face
                  #declare Bx = 0;
                  #while (0)
                     // Fill in demarks for each unit
                     #declare Bx = Bx + Unit;
                     #if (Bx != ABx)
                        cylinder { <Bx + Fr, By - FLy, 0> <Bx + Fr, By, 0> SFr texture { Frame } }
                     #end
                  #end
                  // Right face
                  #declare Bz = 0;
                  #while (0)
                     // Fill in demarks for each unit
                     #declare Bz = Bz + Unit;
                     #if (Bz != ABz)
                        cylinder { <ABx, By - FLy, Bz + Fr> <ABx, By, Bz + Fr> SFr texture { Frame } }
                     #end
                  #end
                  // Back face
                  #declare Bx = ABx;
                  #while (0)
                     // Fill in demarks for each unit
                     #declare Bx = Bx - Unit;
                     #if (Bx != 0)
                        cylinder { <Bx + Fr, By - FLy, ABz> <Bx + Fr, By, ABz> SFr texture { Frame } }
                     #end
                  #end
                  // Left face
                  #declare Bz = ABz;
                  #while (0)
                     // Fill in demarks for each unit
                     #declare Bz = Bz - Unit;
                     #if (Bz != 0)
                        cylinder { <0, By - FLy, Bz> <0, By, Bz> SFr texture { Frame } }
                     #end
                  #end
               #end // if complexity = 0
            #end // test restriction to middle of unit
            #declare By = By + FLy;
         #end
      #end
   }
#end

// Predefine a pallette of textures, somewhat inefficiently,
// so that meshes can be used
UnitTex()


#declare JustOne = 0;
#if (JustOne)
   object { AptBlock(0) }
#else
   #if (ComposeOnly)
      #declare SimpleBlock = box {
         <0, 0, 0> <ABx, ABy, ABz>
         texture { pigment { Green } finish { reflection GlassRefl } }
      }
   #else
      #declare SimpleBlock = AptBlock(0)
   #end
   #if (ComposeOnly)
      #declare ComplexBlock = box {
         <0, 0, 0> <ABx, ABy, ABz>
         texture { pigment { Blue } finish { reflection GlassRefl } }
      }
   #else
      #declare ComplexBlock = AptBlock(1)
   #end
   #if (ComposeOnly)
      #declare DetailBlock = box {
         <0, 0, 0> <ABx, ABy, ABz>
         texture { pigment { Red } finish { reflection GlassRefl } }
      }
   #else
      #declare DetailBlock = AptBlock(2)
   #end   
   #declare Bx = -1;
   #while (Bx < 1)
      #declare By = -10;
      #while (By < 10)
         #declare Bz = -3;
         #while (Bz < 5) // 20)
            #local BlockBase = <2 * ABx * Bx + (ABx * 0.5), 
                              1.5 * ABy * By + (ABy * 0.25),
                              1.5 * ABz * Bz + (ABz * 0.25)>;
            #local YZRange = vlength((BlockBase * <0, 1, 1> + <0, ABy, ABz> / 2) - CameraLoc);
            object {
               #if (YZRange < DetailThreshold)
                  DetailBlock
               #else
               #if (YZRange < ComplexThreshold )
                  ComplexBlock
               #else
                  SimpleBlock
               #end
               #end
               translate BlockBase
            }
            #declare Bz = Bz + 1;
         #end
         #declare By = By + 1;
      #end
      #declare Bx = Bx + 1;
   #end
#end
#if(0)
   #declare EarthUnit = sphere {
      <0,0.5,0> 0.5
      pigment {
         image_map { png "..\EarthMap.png" map_type 2 }
      }
      translate <0, -0.5,0>
      rotate 115*y
      rotate 50*z
   }
#end

#local SFx = 256 * 500*m;
#local SFy = 192 * 500*m;

#declare SanFran = box {
   <0, 0, 0> <1, 1, 0.1>
   pigment {
      image_map { png "..\namerica_sanfran.png" map_type 0 interpolate 2 }
   }
   scale <SFx, SFy, 1>
   rotate <90, -90, 0>
   translate <0.42 * SFx, -OrbitH, -0.4 * SFy>
}

object { SanFran }

//eof