// Persistence of Vision Ray Tracer Scene Description File
// File: car.inc
// Vers: .4
// Desc: City Topic
// Date: April 30, 2000
// Auth: Jim Charter


#version unofficial MegaPov 0.4; 

//tires

#declare tires = array[5]
#declare tires[1] =
torus { .75 .35 texture { pigment { Black } } }

#declare tires[2] = 
cylinder { (y*-1), (y*1), 1.02 texture { pigment { Black } } }

#declare tires[3] =
intersection {
                object { tires[1] }
                object { tires[2] }
                }
#declare tires[4] = 
union {
cylinder { (y*0), (y*.34), .65 texture { pigment { Silver } } }  //hubcaps              
object { tires[3] }  
}

//body

#declare body = array[20]

#declare body[1] =     //hood   
        cone { <0,0,0> .26 <0,.85,4.25> .3 scale < 8, .5, 1 >   translate < 0, 1.45, -2.00 > }    
#declare body[2] =     //fender
difference {       
        cone { <0,0,0> .24 <.75,0,4.25> .36 scale < .5, 3.1, 1 >   rotate (z*5) translate < 2.2, 0.75, -2.00 > }           
        cylinder { <-1, 0, 0> <1, 0, 0> .85 scale < 1, 1.2, 1.4 > translate < 2.5,-.05, .1 >    }  //wheel well
}
#declare body[3] =     //door
                                                             
        cone { <0,0,0> .36 <.25,0,3.00> .38 scale < .5, 3.1, 1 >   rotate (z*5) translate < 2.57, 0.78,  2.25 > }                  
 
#declare body[4] =     //door
difference {       
        cone { <.25,0,0> .38 <0,0,3.00> .36 scale < .5, 3.1, 1 >   rotate (z*5) translate < 2.57, 0.78,  5.20 > }
        cylinder { <-1, 0, 0> <1, 0, 0> .85 scale < 1, 1.3, 1.4 > translate < 2.5,-.2, 8.2 >  }  //wheel well                  
} 
#declare body[5] =     //rear fender
difference {       
        cone { <.45,0,0> .36 <0,0.1,2.90> .24 scale < .5, 3.1, 1 >   rotate (z*5) translate < 2.35, 0.75,  8.15 > }
        cylinder { <-1, 0, 0> <1, 0, 0> .85 scale < 1, 1.3, 1.4 > translate < 2.3,-.2, 8.2 >   }  //wheel well                  
}
#declare body[6] =     //bumper
        cylinder { <0,0,0> <0,.7,0> 2.6 scale < 1, 1, .5> translate < 0,0,-1.8 >  } 
        
#declare body[7] =     //trunk   
        cone { <0,.25,0> .31 <0,0,2.5> .28 scale < 8, .2, 1 >   translate < 0, 1.80, 8.45 > } 
#declare body[8] =     //roof   
        cone { <0,0,0> .25 <0,0,3.7> .25 scale < 8.2, .7, 1 >   translate < 0, 3.45, 3.7 > } 
#declare body[9] =     //grill 
intersection {
        cone { <0,0,0> 2.6 <0,4, 1.0> 2.0  scale < .935, 1, .5> translate < 0, 0,-1.8 >  }         
        object { body[6] translate < 0, .7, 0 >   }
}        
#declare body[10] =     //grill top
intersection {
        cone { <0,0,0> 2.6 <0,4, 1.0> 2.0  scale < .935, 1, .5> translate < 0, 0,-1.8 >   }         
        object { body[1] translate < 0, -.11, -.9 >  } 
         
}
#declare body[11] =
difference { 
        object { body[9]   }
        box { < 1.251, 0, -2 > <2.51, 1, 0 > translate < 0, .5, -2.0 > pigment { Silver }  }    //wells for headlights
        box { <-1.251, 0, -2 > <-2.51, 1, 0 > translate < 0, .5, -2.0 > pigment { Silver }  }
}
#declare body[12] =     //grill  top
difference { 
        object { body[10] translate < 0, .016, 0 > }
        box { < -2.5, 0, 0 > < 2.5, 1, 2 > translate < 0, 1, -2.0  >   }  //clips back
        
}
#declare body[13] =    //wheel well    
difference {         
  cylinder { <-.5, 0, 0> <1, 0, 0> .85 scale  < 1, 1.2, 1.4 > translate < 1.5,-.05, .2 >    }  
  cylinder { < -1, 0, 0> <1.1, 0, 0> .80 scale  < 1, 1.2, 1.4 > translate < 1.5,-.15, .2 >    }
  cylinder { < -1, 0, 0> <1, 0, 0> .85 scale (< 1, 1.2, 1.4 >*1.2) translate < 1.5,-.62, 0 >    } 
}  
#declare body[14] =      //window post  lf
difference {
        cone { <0,0,0> .125 < -0.93, 1.75, 1.60 > .075 scale < .5, 1, 1 > translate < 2.48, 1.75, 2.25 > } 
        box { <0,0,0><1,1,1> translate < 1.48, 3.45, 3.25 >  }
  
}
#declare body[15] =      //window post rf
difference {
        cone { <0,0,0> .125 <  0.80, 1.75, 1.60 > .075 scale < .5, 1, 1 > translate < -2.33, 1.75, 2.25 > } 
        box { <0,0,0><1,1,1> translate < -2.48, 3.45, 3.25 >  }
  
}
#declare body[16] =      //window post l
difference {
        cone { <0,0,0> .125 < -1.31, 1.75, 0 > .090 scale < .5, 1, 1.4 > translate < 2.63, 1.75, 5.25 > } 
        box { <0,0,0><1,1,1> translate < 1.48, 3.45, 5.00 >  }
  
}
#declare body[17] =      //window post lr
difference {
        cone { <0,0,.48> .125 <  -1.47, 1.75, 0 > .110  scale < .25, 1, 2.4 > translate < 2.41, 1.75, 7.10 > } 
        box { <0,0,0><1,1,1> translate <  1.48, 3.45, 6.70 >   }
  
}

#declare body[0] =
union {
        object { body[1] }   //hood
        object { body[2] }   //fender
        object { body[3] }   //door  
        object { body[4] }   //rear door 
        object { body[5] }   //rear fender      
        object { body[6] pigment { Grey10 }}   //bumper 
        object { body[7] }   //trunk      
        object { body[8] }   //roof 
        object { body[11]  pigment { Grey30 } }   //grill       
        object { body[12] }  //grill 
        object { body[13] pigment { Black } }  //well     
        object { body[13] pigment { Black } translate < .05, .16, 8 > }  //well
        object { body[14] }  //window post lf
        object { body[15] }  //window post rf  
        object { body[16] }  //window post  l     
        object { body[17] }  //window post lr 
}
                                    
#declare fixtures = array[12]
#declare fixtures[1] =   //headlight cover
difference {
        object { body[9] }
        box { < 1.25, 0, -2 > <-1.25, 1, 0 > translate < 0, .5, -2.0 > }
        translate (z*-.002)
         
}
#declare fixtures[2] =  //headlight lamp
union {
        cone { (z*0) .25 (z*.25) 0 translate < 1.50,1.0, -2.45 >  }
        cone { (z*0) .25 (z*.25) 0 translate < 1.70,1.0, -2.15 >  } 
        cone { (z*0) .25 (z*.25) 0 translate <-1.50,1.0, -2.45 >  } 
        cone { (z*0) .25 (z*.25) 0 translate <-1.70,1.0, -2.15 >  }  
}
#declare fixtures[0] =   //headlight assembly
union {
        object { fixtures[1] pigment { Silver transmit .3 } finish { phong .5 phong_size 70 reflection .5}  }
        object { fixtures[2] pigment { White*4 }}
}
#declare fixtures[3] =    //license plate
        box { <-.4,0,0><.4, .4, .1 > translate <0, -.05,-3.1 > } 
        
#declare fixtures[4] =  
difference {  
                cone { <0,0,0> 3 <0,6,4.30> 2 }
                box  { <-4, -1, -4 > < 4, 1.8, 4 > }     
                box  { <-5, 2.245, -5 > < 5, 8, 5 > rotate (x*40) }
                box  { < -3, -2, -4> < 3, 2, 4 > rotate (z*4) translate < 3.7, 3, 0 >}   
                box  { < -3, -2, -4> < 3, 2, 4 > rotate (z*-4) translate < -3.68, 3, 0 >}
          }        
#declare fixtures[5] =     //windshield
difference {  
        object { fixtures[4] scale < 3 , 1, 1 >  translate < 0, 0, 4.45 > }         //pigment { DarkBlue }
        cone { <0,-.1,0> 3 <0,6,4.30> 2 scale < 3 , 1, 1 >  translate < 0, 0, 4.55 > }      //pigment { DarkBlue }                                                                                  
}


#declare fixtures[6] =  
difference {  
                cone { <0,0,0> 2.85 <0,6,0> 1.40 }        
                box  { <-4, -1, -4 > < 4, 1.8, 4 > }     
                box  { <-5, 3.45, -5 > < 5, 8, 5 >  }
          }        
#declare fixtures[7] =     //windshield
intersection {  
        object { fixtures[6] scale < 1, 1, 5 >   translate < 0, 0, 5 > }      
        cone { <0,-.1,0> 3 <0,6,4.30> 2 scale < 3 , 1, 1 >   translate < 0, 0, 4.5 > } //clips front excess                                                                                       
}                      
#declare fixtures[8] =     //windows
intersection {  
        object { fixtures[7] }     //rotate (z*3) translate < .15, 0, 0 > 
        cone { <0, 1,1> 4 <0, 6, 0> 2   scale < 3, 1, 1 >   translate < 0, 0, 3.57 > }    //clips back excess                                                                                     
}                      
#declare fixtures[9] =     //running light    
union {
        sphere { 0 .1 scale < .7, 3.5, 1 > translate < 2.2, .95, -2.07 >  }   
        sphere { 0 .1 scale < .7, 3.5, 1 > translate < -2.2, .95, -2.07 >  }
}                              
#declare chasis = 
union {
        object { tires[4] rotate (z*-90) translate < 2.1,-.09, .1>} 
        object { tires[4] rotate (z*-90) translate <-2.1,-.09, .1>} 
        object { tires[4] rotate (z*-90) translate <-2.2,-.09,8.2>} 
        object { tires[4] rotate (z*-90) translate < 2.2,-.09,8.2>} 
        }

#declare fixtures[0] =             //car with lights off
union {        
        object { fixtures[1] texture { t_headlight  }  }                //headlight shield
        object { fixtures[2] texture { t_headlight_bright[0]  }  }      //headlight lamp
        object { fixtures[3] pigment { Wheat*1.3 }   }                  //license         
        object { fixtures[5] texture { t_windshield }  }                //windshield
        object { fixtures[8] texture { t_windshield }  }                //windows
        object { fixtures[9] texture { t_running[0]    }  }
         
}

#declare fixtures[10] =            //car with lights on
union {        
        object { fixtures[1] texture { t_headlight  }  }                //headlight shield
        object { fixtures[2] texture { t_headlight_bright[1]  }  }      //headlight lamp
        object { fixtures[3] pigment { Wheat*1.3 }  }                   //license        
        object { fixtures[5] texture { t_windshield }  }                //windshield
        object { fixtures[8] texture { t_windshield }  }                //windows
        object { fixtures[9] texture { t_running[1]    }  }
        object { fixtures[9] translate (y*.8) scale < .9, .5, 1 > texture { t_running[1]    }  } 
}

#declare car = array[2]

#declare car[0]  = 
union {
        object { chasis }
        object { body[0] rotate (x*-2) }
        object { fixtures[0] rotate (x*-2) }
        }        
#declare car[1]  = 
union {
        object { chasis }
        object { body[0] rotate (x*-2) }
        object { fixtures[10] rotate (x*-2) }
        }        
                
