// Persistence of Vision Ray Tracer Scene Description File
// File: city.pov
// Vers: .4
// Desc: City Topic
// Date: April 30, 2000
// Auth: Jim Charter

//#version 3.1;   
#version unofficial MegaPov 0.4;       
#include "city_textures.inc"                                                                                                               
#local R1 = seed(999);
                                                                                                                             
//global_settings { ambient_light 4.0 }
global_settings { max_trace_level 50 }
global_settings { motion_blur 20,5 }
// ----------------------------------------

#declare camera_location = <  45,   4.5,   -135 >;    //*
//#declare camera_location = <  0,   140,       0 >;    
camera
{
     location camera_location     
       look_at < -3, 8, 0>                
         angle 43
     
}
 
sky_sphere { pigment { gradient y color_map { [ .1 LightBlue*Grey50 ] [ .95 Silver*Gold ] } } }        
  
                                                                       

light_source
{
  (0*x)  
  color LightBlue*1.1   
  area_light
  <60, 0, 0> <0, 0, 60>  
  3, 2                    
  adaptive 0           
  jitter              
  translate <  100, 400,  200 >   
}   

light_source { 0  Silver*Gold*.4         translate <  -80, 4000,  -180 >  }
//light_source { 0  White*.2              translate camera_location shadowless }

//render control switches------------------------
#declare render_trees           = 1;
#declare render_building        = 1;
#declare render_pavement        = 1;
#declare use_reflection         = 1;
#declare render_sidewalk        = 1;
#declare render_cinderella      = 1;
#declare render_traffic_light   = 1;
#declare render_car             = 1;
#declare render_people          = 1; 
#declare render_figure          = 1;               
#declare use_media              = 1;

plane { y, -4 pigment { Grey15 } }

#switch ( render_building )
#case ( 1 ) 
                                                                                         

#declare light =
sphere { <0,0,0>, 0.95 pigment {color rgb <.98, .94, .90>*1.2 filter 1}  
        interior { 
               media {
                   emission <0.95, .90, .85>
                   scattering {1, .8}
                   density {
                       spherical scale .9
                       color_map {
                             [0.00 rgb <0,0,0>]        
                             [0.65 rgb <0.98, 0.96, 0.6>] 
                             [1.00 rgb <1,1,1>]
                       }
                         
                       
	               omega .25  
                   }
              }
        }
        hollow                       
}
#declare redlight =
sphere { <0,0,0>, 0.95 pigment {color rgb <.98, .04, .01>*1.2 filter 1}  
        interior { 
               media {
                   emission <0.95, .90, .85>
                   scattering {1, .8}
                   density {
                       spherical scale .9
                       color_map {
                             [0.00 rgb <0,0,0>]        
                             [0.65 rgb <0.98, 0.01, 0.01>] 
                             [1.00 rgb <1,1,1>]
                       }
                         
                       
	               omega .25   
                   }
              }
        }
        hollow                       
}
  
#declare window = array[10]
#declare window[1] =    
                union {

                        box { < 0, 3.2, -.15> < -2.8, 6, .85 >  texture { t_ledge }}              //upper pane
                        box { < 0, 3.0, -.2> < -2.8, 3.21, .80> texture { t_ledge }}
                        box { < 0, 0, -.1 > < -2.8, 3.01,  .9 > texture { t_ledge }}              //window makes the opening lower pane
                                               
                      } 
                      
#declare window[2] =  
                union { 
                        box { < 0, 0, -1.1 > <  2, 1.5,   1 > rotate <0,0,-10>   translate <   .05, 6, 0 >    }    
                        box { < 0, 0, -1.5 > < -2, 1.5,   1 > rotate <0,0, 10>   translate < -2.85, 6, 0 >    }    
                      }
                                              
#declare window[3] =  
           difference { 
                        box { < 1, 6, -0.65 > < -4, 6.85,  .5 >   } 
                        object { window[2]    }
                      }
                                       
#declare window[4] =  
                union {
                        
                        box { < 0, 3.2, -.2> < -2.8, 6, .8 > }              //upper pane
                        box { < 0, 0, 0 > < -2.8, 3,  1 >  }                //window   lower pane
                                               
                        object { window[3] texture { t_casement[2] } }                                  
                        box { < -1.00, 6, -0.65  > < -1.80,   7.5,   0.2 > texture { t_casement[2] }   }
                        
                        box { < -2.65, 0, -.6  > <  -2.85,   6,   0.2 > texture { t_casement[2] }   }
                        box { <   .05, 0, -.6  > <   -.15,   6,   0.2 > texture { t_casement[2] }   }
                        
                        box { < .05, 0, 0 > < -2.85, -.5,  -1.0 >   texture { t_ledge }   }       //ledge
                      }
 

                      
                      
#declare window[5] =  
                union {
                        
                        box { < 0, 3.2, -.2> < -2.8, 6, .8 > }              //upper pane
                        box { < 0, 0, 0 >    < -2.8, 3,  1 >  }              //window   lower pane
                                             
                        box { < .30, 5.9, 0 > < -3.15, 6.2,  -0.70 > texture { t_ledge }   }  
                        box { < .40, 6.2, 0 > < -3.25, 6.5,  -0.75 > texture { t_ledge }   }  
                        box { < .50, 6.5, 0 > < -3.35, 6.8,  -0.85 > texture { t_ledge }   }  
                        box { < .60, 6.8, 0 > < -3.45, 7.0,  -0.90 > texture { t_ledge }   }
                        
                          
                        box { < -2.75, 0, -0.65  > < -3.15,     6,   0.2 > texture { t_casement[2] }   }
                        box { <    .3, 0, -0.65  > <   -.1,     6,   0.2 > texture { t_casement[2] }   }
                        box { <    .3, 0,     0  > <  -3.15,  -.5,  -1.0 > texture { t_ledge    }   }       //ledge
                      
                      }
#declare window[6] =  
                union {
                       
                        box { < 0, 0, 0> < -2.8, 6,  -.15 > }              //upper pane
                         
                                             
                        box { < .30, 5.9, 0 > < -3.15, 6.2,  -0.30 > texture { t_ledge }   }  
                        
                        
                          
                        box { < -2.75, 0, 0  > < -2.8,     6,   -0.3 > texture { t_casement[2] }   }
                        box { <     0, 0, 0  > <   -.1,     6,   -0.3 > texture { t_casement[2] }   }
                        box { <    0, 0,     0  > <  -2.75,  -.3,  -0.3 > texture { t_ledge    }   }       //ledge
                      
                      }
#declare window[7] =              //for cooper union
                union {
                        
                        box { < 0, 0, 0> < 2, 5,  -.1 > }               
                        box { < 0, 0, 0> < 2, 5,  -.1 > translate < 3, 0, 0 > }   
                        box { < 0, 0, 0> < 2, 5,  -.1 > translate < 6, 0, 0 > }                       
                        pigment { Wheat*.5 } finish { reflection .25 }
                      
                      }
#declare window[8] =              //for cooper union
                union {
                        
                        box { < 0, 0, 0> < 2.5, 15,  -.1 > }               
                        box { < 0, 0, 0> < 2.5, 15,  -.1 > translate < 3, 0, 0 > }   
                                        
                        pigment { Wheat*.5 } finish { reflection .25 }
                      
                      }
                                                                                        
#declare fire_escape = array[12]  
                #declare fire_escape[11] =           //outer edge of platform
                difference {    
                                box { < 0, -.4, 0 > <  -11, -.8, -2.5 > }
                                box { < -.1, -.3, .1 > < -10.9, -.9, -2.4 > }
                           }

#declare fire_escape[10] =                             //grating
                union {
                        #local cnt=0;#while ( cnt > -2.5 ) 
                              box { <  0,  -.4,  0 > <   -11,   -0.3,  -.10 > translate (z*cnt) }  
                              #local cnt=(cnt-.4);
                        #end 
                         object { fire_escape[11] } 
                      }

#declare fire_escape[9] =                          //platform with well
                difference {
                              object { fire_escape[10] }                    
                              box { <  -2,  0,  -1  > <  -8.5,   -1.1,  -2.4 > pigment { Red } }
                           }
                            
#declare fire_escape[8] =
                union {    
                        box { <  0,  -.4,  0 > <   -.1,   -1.7,   -.15 >}  //struts
                        box { <-11,  -.4,  0 > < -10.9,   -1.7,   -.15 >}
                        box { <  0,    0,  0 > <   -.1,    -.2,  -2.6 >  rotate < 30, 0, 0 > translate <0, -1.7, 0> }  //struts   
                        box { <-11,    0,  0 > < -10.9,    -.2,  -2.6 >  rotate < 30, 0, 0 > translate <0, -1.7, 0> }  //          
                      }
     
#declare fire_escape[7] =
                difference {                                               //railing
                                box { <  0,  2,  0 > <   -11,   2.1,  -2.5 > }
                                box { <  -.1,  1.9,   .1 > <   -10.9,   2.2,  -2.4 > }
                           }
                            
                           
#declare fire_escape[6] =
                union {
                        #declare cnt = -11;
                        #while ( cnt < 0 )
                                box { < 0, -.4, -2.4 > < .05, 2, -2.45 > translate < cnt, 0, 0 > }                  
                                #declare cnt = (cnt + 11/22); 
                        #end
                        
                        #declare cnt = -2.2;
                        #while ( cnt < 0 )
                                  
                                box { < 0, -.4, -.2 > < -.05, 2, 0 > translate < 0, 0,  -.75 > }        //side railing spokes  
                                box { < 0, -.4, -.2 > < -.05, 2, 0 > translate < 0, 0, -1.50 > }
                                box { < 0, -.4, -.2 > < -.05, 2, 0 > translate < 0, 0, -2.25 > }
                                                    
                                #declare cnt = (cnt + .7); 
                        #end
                        
                        box { < -11, -.4, -.2 > < -11.05, 2, 0 > translate < 0, 0,  -.75 > }    //side railing spokes  
                        box { < -11, -.4, -.2 > < -11.05, 2, 0 > translate < 0, 0, -1.50 > }
                        box { < -11, -.4, -.2 > < -11.05, 2, 0 > translate < 0, 0, -2.25 > }                    
                 
                        }
                        
                         
#declare fire_escape[5]  =
                union {
                        box { < 0, 0, 0 > < .2, 11, .1 >  }
                        box { < 0, 0, 0 > < .2, 11, .1 >  translate < 0, 0, -1.1 >}
                        #declare cnt = 0;
                        #while ( cnt < 11 )
                                box { < .05, 0, 0 > < .15, .1, -1.1 >  translate < 0, cnt, 0 > }                 
                        #declare cnt = (cnt + 1); 
                        #end
                      }
                                    
#declare fire_escape[0]  =
                union {
                        object { fire_escape[9]                        }  //platform
                        object { fire_escape[8]                        }  //structs
                        object { fire_escape[7]                        }  //railing  
                        object { fire_escape[6]                        }  //railing
                        
                        box { < -1, 2.2, 0 > < -1.1, 11, .1 > rotate <0,0,-40> translate < -9, -.4, -1 > } 
                        box { < -1, 2.2, 0 > < -1.1, 11, .1 > rotate <0,0,-40> translate < -9, -.4, -2.4 > }                       
                        box { < 0, 0, 0 > < .4, 12, .1 > rotate <0,0,-40> translate < -9, -.4, -1 > } 
                        box { < 0, 0, 0 > < .4, 12, .1 > rotate <0,0,-40> translate < -9, -.4, -2.4 > }
                        #declare cnt = 0;
                        #while ( cnt < 12 )
                                box { < 0, 0, 0 > < .2, .1, -1.4 > rotate <0,0,40> translate < 0, (cnt-.4), -1 > rotate <0,0,-40> translate < -8.5, 0, 0 >}    //rotate z*42              
                        #declare cnt = (cnt + 1); 
                        #end
                      } 
                      
 
#declare fire_escape[1]  =
                union {
                        object { fire_escape[9]                        }  //platform
                        object { fire_escape[8]                        }  //structs 
                        object { fire_escape[7]                        }  //railing  
                        object { fire_escape[6]                        }  //railing
                        
                        box { < 1, 2.2, 0 > < 1.1, 11, .1 >     rotate  <0,0,40> translate < -2, -.4, -1 > } 
                        box { < 1, 2.2, 0 > < 1.1, 11, .1 >     rotate  <0,0,40> translate < -2, -.4, -2.4 > }
                        box { < 0, 0, 0 > < .4, 11, .1 >        rotate  <0,0,40> translate < -2, -.4, -1 > } 
                        box { < 0, 0, 0 > < .4, 11, .1 >        rotate  <0,0,40> translate < -2, -.4, -2.4 > } 
                        #declare cnt = 0;
                        #while ( cnt < 12 )
                                box { < 0, 0, 0 > < .2, .1, -1.4 > rotate <0,0,-40>  translate < 0, (cnt-.4), -1 > rotate  <0,0,40> translate < -2, 0, 0 >}   //rotate z*-42               
                        #declare cnt = (cnt + 1); 
                        #end
                      }
                                            
#declare fire_escape[2]  =
                union {
                        object { fire_escape[9]                        }  //platform
                        object { fire_escape[8]                        }  //struts
                        object { fire_escape[7]                        }  //railing 
                        object { fire_escape[6]                        }  //railing
                        
                      
                      }
                      
                    
                      
                       
                      
                      
                      
#declare cornice = array[6]


#declare cornice[0] =     //cornice
union {
        box { < 0, 0, 0> < .1, 2, 80 > }
        box { < -.1, 1.9, 0 > < 1.4, 2.25, 80 >  }
        box { < -.1, 2.1, 0 > < 1.7, 2.55, 30 >  } 
        box { < -.1, 2.1,50 > < 1.7, 2.55, 80 >  }
        box { < 0,  .35, 0> < -80, 2.75, -.1 > texture { t_casement[1] } } 
        box { < 0, -.70, 0> < -80,  .35, -.1 > texture { t_casement[2] } }
        texture { t_casement[0] }
      }






#declare cornice[1] =
difference {
                box      { < -.1, 0, 0 > <  .1, 2, -2 >   }
                cylinder { < -2, 0,  .4 > < -2, 0, -.4 > 1.85 scale <1,1,1.1> rotate  <0,-90,0>  }
           }

        
#declare cornice[2] = 
union {
        box { < 0, 0,    1.5 > < -24, 2,   -.1  > }
        box { < .4, 2,   1.5 > < -24.4, 2.5, -2.4 > }
        box { < .7, 2.5, 1.5 > < -24.7, 2.8, -2.7 > }     
         
        #declare cnt=-0;#while ( cnt > -25 )   
                object { cornice[1] translate (x*cnt) }
                #declare cnt=(cnt-4);
        #end
      }                                                              
       
#declare cornice[3] =
difference {

             object { cornice[2] }
             box { < 1, 0, 0 > < -25, 5, -2 > rotate <-20,0,0> translate <0,0,-1.55>  }
           }

#declare cornice[4] =
difference {

             object { cornice[2] }
             box { < 1, 0, 0 > < -25, 5, -2 > rotate <-20,0,0> translate <0,0,-1.25>  }
           }
#declare cornice[5] = 
union {
        box { < 0, 0,    0 > < .5, 2,   9 > }
        box { < 0, 2,    0 > < 1, 2.5, 9 > }
        box { < 0, 2.5,  0 > < 1.5, 2.8, 9 > }     
}                                           
#declare bldg = array[25]

#declare bldg[1]= 
        union { 

                        box { < 0, 0, 0 > < -80, 60,  80 >     texture { t_brick_sim[0] } } 
                        box { < 0, 0, 0 > < -80, 11,   1 > translate < 0,0,-.1 >  pigment { Black } }
                        box { < 0, 0, 0 > <   0, 11,  80 > translate < 0,0,-.1 >  pigment { Black } }
               }
              
#declare bldg[2]=

        union { 
                #declare outer_count = 1;     
                #while ( outer_count < 14 )
                
                        #declare inner_count = 1;
                        #while ( inner_count < 6 )
                                object { window[1] translate < (-1*outer_count*6+3), (inner_count*9+6), -.2 > }
                                #declare inner_count=(inner_count+1);
                        #end
                        #declare outer_count=(outer_count+1);
                
                #end 
                //receding side of building
                #declare ztrans = array[12] { 4.5, 12, 17.5, 23, 28.5, 34, 45, 50.5, 56, 61.5, 67, 75 }
                #declare outer_count = 0;     
                #while ( outer_count < 12 )
                
                        #declare inner_count = 1;
                        #while ( inner_count < 6 )
                        
                                
                                        object { window[1] rotate (y*-90) translate <  .2, (inner_count*9+6),  ztrans[outer_count] >  texture { t_glass_sim } }  
                               
                                 
                                                       
                                #declare inner_count=(inner_count+1);
                        #end
                        
                        #declare outer_count=(outer_count+1);
                
                #end
              }
              
#declare bldg[3]=

        union { 
        
                //near side of building
                #declare outer_count = 1;     
                #while ( outer_count < 14 )
                
                        #declare inner_count = 1;
                        #while ( inner_count < 6 )
                        
                                #if ( mod(inner_count,2) = 0 )
                                        object { window[4] translate < (-1*outer_count*6+3), (inner_count*9+6),  .6 >  texture { t_glass_sim } }  
                                #else
                                        object { window[5] translate < (-1*outer_count*6+3), (inner_count*9+6),  .6 >  texture { t_glass_sim } }  
                                #end
                                 
                                #if ( outer_count = 2 |  outer_count = 6 |  outer_count = 10 )
                                         
                                                #if ( inner_count < 5 )  
                                                       
                                                        #if ( outer_count = 2 )                                                         
                                                                object { fire_escape[0] translate < (-1*outer_count*6-2), (inner_count*9+6),  0 > }
                                                                
                                                                #if ( inner_count = 1 )
                                                                        object { fire_escape[5] translate < (-1*outer_count*6-2), (inner_count*9+4), -2 > }
                                                                #end
                                                        #else 
                                                                object { fire_escape[1] translate < (-1*outer_count*6-2), (inner_count*9+6),  0 > } 
                                                                
                                                                #if ( inner_count = 1 )
                                                                        object { fire_escape[5] translate < (-1*outer_count*6-13), (inner_count*9+4), -2 > }
                                                                #end

                                                        #end
                                                             
                                                 #else
                                                        object { fire_escape[2] translate < (-1*outer_count*6-2), (inner_count*9+6),  0 >  }
                                                 #end 
                                                 
                                #end      
                                                              
                                #declare inner_count=(inner_count+1);
                        #end
                        
                        #declare outer_count=(outer_count+1);
                
                #end
                //receding side of building
                #declare ztrans = array[12] { 4.5, 12, 17.5, 23, 28.5, 34, 45, 50.5, 56, 61.5, 67, 75 }
                #declare outer_count = 0;     
                #while ( outer_count < 12 )
                
                        #declare inner_count = 1;
                        #while ( inner_count < 6 )
                        
                                #if ( mod(inner_count,2) = 0 )
                                        object { window[4] rotate (y*-90) translate < -.6, (inner_count*9+6),  ztrans[outer_count] >  texture { t_glass_sim } }  
                                #else
                                        object { window[5] rotate (y*-90) translate < -.6, (inner_count*9+6),  ztrans[outer_count] >  texture { t_glass_sim } }  
                                #end
                                 
                                                             
                                #declare inner_count=(inner_count+1);
                        #end
                        
                        #declare outer_count=(outer_count+1);
                
                #end
                texture { t_fire_escape }
              }
              


#declare bldg[5]= 
union {                
        box { < 0, 0, 0 > < -24, 60,  80 >  } 
        #local cnt = 1;#while ( cnt < 6 ) 
                                object { window[4] translate <  -2, (cnt*9+6), 0 >  texture { t_glass_sim }} 
                                object { window[4] translate <  -8, (cnt*9+6), 0 >  texture { t_glass_sim }}
                                object { window[4] translate < -14, (cnt*9+6), 0 >  texture { t_glass_sim }} 
                                object { window[4] translate < -20, (cnt*9+6), 0 >  texture { t_glass_sim }}
                                #if ( cnt < 5 )
                                        object { fire_escape[1] translate <  -8, (cnt*9+6), 0 > texture { t_fire_escape } }
                                #else
                                        object { fire_escape[2] translate <  -8, (cnt*9+6), 0 > texture { t_fire_escape } }
                                #end
                                #local cnt=(cnt+1); 
                       #end 
        object { cornice[3] translate < 0, 58.5, 2.1 > texture { t_cornice } }   
        rotate (y*180) translate < -54, 0,  -80 >
      }

#declare bldg[6]= 
union { 

        box { < 0, 0, 0 > < -24, 30,  80 >   }
        object { window[5] scale 2 translate <  -6, (9+6),  0 >   texture { t_glass_sim }} 
        object { window[5] scale 2 translate <  -12, (9+6), 0 >  texture { t_glass_sim }}
        rotate (y*180) translate < -78, 0,  -80 >                 
      }


#declare bldg[7]= 
union {                
        box { < 0, 0, 3 > < -24, 60,  80 > texture { t_brick_sim[7] } }
        box { < 0, 0, 0 > < -24, 60,   3 >   } 
        #local cnt = 1;#while ( cnt < 6 ) 
                                object { window[5] translate <  -2,(cnt*9+6), 0 >  texture { t_glass_sim }} 
                                object { window[5] translate <  -8,(cnt*9+6), 0 >  texture { t_glass_sim }}
                                object { window[5] translate < -14,(cnt*9+6), 0 >  texture { t_glass_sim }} 
                                object { window[5] translate < -20,(cnt*9+6), 0 >  texture { t_glass_sim }}
                                #if ( cnt < 5 )
                                        object { fire_escape[1] translate <  -8, (cnt*9+6), 0 > texture { t_fire_escape } }
                                #else
                                        object { fire_escape[2] translate <  -8, (cnt*9+6), 0 > texture { t_fire_escape } }
                                #end
                                #local cnt=(cnt+1); 
                       #end 
        object { cornice[3] translate < 0, 58.5, 2.1 > texture { t_cornice } }   
        rotate (y*180) translate < -102, 0, -80 >
      }
                 
 

#declare bldg[8]=
union {
                 
        box { < 0, 0, 0 > < -24, 58,  80 >   }  
        #local cnt = 1;#while ( cnt < 6 ) 
                        object { window[5] translate <  -2, (cnt*9+4), 0 >  texture { t_glass_sim }} 
                        object { window[5] translate <  -8, (cnt*9+4), 0 >  texture { t_glass_sim }}
                        object { window[5] translate < -14, (cnt*9+4), 0 >  texture { t_glass_sim }} 
                        object { window[5] translate < -20, (cnt*9+4), 0 >  texture { t_glass_sim }}
                        #if ( cnt < 5 )
                                object { fire_escape[1] translate <  -2, (cnt*9+4), 0 > texture { t_fire_escape } }
                        #else
                                object { fire_escape[2] translate <  -2, (cnt*9+4), 0 > texture { t_fire_escape } }
                        #end
                        #local cnt=(cnt+1); 
                       #end
        object { cornice[3] translate < 0, 56.5, 2.1 > texture { t_cornice_light } }   
        rotate (y*180) translate < -126, 0, -80 >

        }


#declare bldg[9]=
union {                  //gap bldg
box { < 0, 0, 0 > <  24, 55,  80 > texture { t_brick_sim[1] } translate < 50, 0, 0 > } 
object { fire_escape[0] rotate (y*90) translate < 50, 15,  15 > texture { t_fire_escape }}
object { fire_escape[0] rotate (y*90) translate < 50, 24,  15 > texture { t_fire_escape }} 
object { fire_escape[0] rotate (y*90) translate < 50, 33,  15 > texture { t_fire_escape }} 
object { fire_escape[0] rotate (y*90) translate < 50, 42,  15 > texture { t_fire_escape }} 
object { fire_escape[2] rotate (y*90) translate < 50, 51,  15 > texture { t_fire_escape }}   
}

#declare bldg[10]=                 //my bldg
box { < 0, 0, 0 > <  30, 30, -20 > texture { t_brick_sim[1] } translate < 65, 0, -78 > }



#declare bldg[12]= 
union {                
        box { < 0, 0, 0 > < -24, 60,  80 >   } 
        #local cnt = 1;#while ( cnt < 6 ) 
                                object { window[6] translate <  -4, (cnt*9+6), .125 >   texture { t_glass_sim }} 
                                object { window[6] translate < -12, (cnt*9+6), .125 >   texture { t_glass_sim }}                  
                                object { window[6] translate < -20, (cnt*9+6), .125 >   texture { t_glass_sim }}
                                #if ( cnt < 5 )
                                        object { fire_escape[1] translate <  -8, (cnt*9+6), 0 > texture { t_fire_escape } }
                                #else
                                        object { fire_escape[2] translate <  -8, (cnt*9+6), 0 > texture { t_fire_escape } }
                                #end
                                #local cnt=(cnt+1); 
                       #end  
 
        object { cornice[3] translate < 0, 58.5, 0 > texture { t_cornice } }
        rotate (y*-90) translate < 0, 0, 104 >
      } 
#declare bldg[13]= 
union {                
        box { < 0, 0, 0 > < -24, 60,  80 >   } 
        #local cnt = 1;#while ( cnt < 6 ) 
                                object { window[6] translate <  -4, (cnt*9+6), .125 >   texture { t_glass_sim }}              
                                object { window[6] translate < -12, (cnt*9+6), .125 >   texture { t_glass_sim }}  
                                object { window[6] translate < -20, (cnt*9+6), .125 >   texture { t_glass_sim }}
                                #if ( cnt < 5 )
                                        object { fire_escape[1] translate <  -8, (cnt*9+6), 0 > texture { t_fire_escape } }
                                #else
                                        object { fire_escape[2] translate <  -8, (cnt*9+6), 0 > texture { t_fire_escape } }
                                #end
                                #local cnt=(cnt+1); 
                       #end  
 
        object { cornice[4] translate < 0, 58.5, 0 > texture { t_cornice } }
        rotate (y*-90) translate < 0, 0, 104 >
      }
#declare bldg[14]= 
union {                
        box { < 0, 0, 0 > < -24, 70,  80 >   } 
        #local cnt = 1;#while ( cnt < 7 ) 
                                object { window[6] translate <  -2, (cnt*9+6), .125 >   texture { t_glass_sim }}    
                                object { window[6] translate <  -8, (cnt*9+6), .125 >   texture { t_glass_sim }}                    
                                object { window[6] translate < -14, (cnt*9+6), .125 >   texture { t_glass_sim }}    
                                object { window[6] translate < -20, (cnt*9+6), .125 >   texture { t_glass_sim }}    
                                #if ( cnt < 5 )
                                        object { fire_escape[1] translate <  -8, (cnt*9+6), 0 > texture { t_fire_escape } }
                                #else
                                        object { fire_escape[2] translate <  -8, (cnt*9+6), 0 > texture { t_fire_escape } }
                                #end
                                #local cnt=(cnt+1); 
                       #end  
 
        object { cornice[3] translate < 0, 67, 0 >  }
        rotate (y*-90) translate < 0, 0, 104 >
      }
#declare bldg[15]= 
union {                
        box { < 0, 0, 0 > < -24, 60,  80 >   } 
        #local cnt = 1;#while ( cnt < 6 ) 
                                object { window[5] translate <   -4, (cnt*9+6), .29 >   texture { t_glass_sim }}    
                                object { window[5] translate <  -12, (cnt*9+6), .29 >   texture { t_glass_sim }}                                                     
                                object { window[5] translate <  -20, (cnt*9+6), .29 >   texture { t_glass_sim }}    
                                 #if ( cnt < 5 )
                                        object { fire_escape[1] translate <  -8, (cnt*9+6), 0 >  texture { t_fire_escape3 } }
                                #else
                                        object { fire_escape[2] translate <  -8, (cnt*9+6), 0 >  texture { t_fire_escape3 } }
                                #end
                                #local cnt=(cnt+1); 
                       #end  
 
        object { cornice[3] translate < 0, 58.5, 2.1 > texture { t_cornice } }     
        rotate (y*-90) translate < 0, 0, 104 >
      }
#declare bldg[16]= 
union {                
        box { < 0, 0, 0 > < -24, 60,  80 >   } 
        #local cnt = 1;#while ( cnt < 6 ) 
                                object { window[6] translate <   -4, (cnt*9+6), .27 >   texture { t_glass_sim }}    
                                object { window[6] translate <  -12, (cnt*9+6), .27 >   texture { t_glass_sim }}                                                     
                                object { window[6] translate <  -20, (cnt*9+6), .27 >   texture { t_glass_sim }}    
                                 #if ( cnt < 5 )                              
                                        object { fire_escape[1] translate <  -8, (cnt*9+6), 0 >  texture { t_fire_escape2 } }
                                #else
                                        object { fire_escape[2] translate <  -8, (cnt*9+6), 0 >  texture { t_fire_escape2 } }
                                #end
                                #local cnt=(cnt+1); 
                       #end  
 
        object { cornice[3] translate < 0, 58.5, 2.1 > texture { t_cornice } }    
        rotate (y*-90) translate < 0, 0, 104 >
      }
      
      
#declare bldg[17]=           //distant highrise
union {                
        box { < 0, 0, 0 > < -90, 400,  90 >  texture { pigment { Grey50 } } }
        #local cnt=150;#while ( cnt < 400 )
                box { <0,0,0> < -15, 2, -1 > translate < -15, cnt, 0 >  texture { pigment {  Grey30 } } }  
                box { <0,0,0> < -15, 2, -1 > translate < -60, cnt, 0 >  texture { pigment {  Grey30 } } } 
                #local cnt=(cnt+10);
        #end 
        box { < -40, 400, 20 > < -70, 430, 50 > texture { pigment { Grey50 } } }        
      }
                
#declare bldg[18]=
difference {                 //dime bank
box { < 0, 0, 0 > < -30,  30, -80 >  translate < 0, 0, -78 > }
box { < 1, 0, 0 > < -2, 5.5, -3 >  translate < 0, 4.8, -83 > texture { pigment { Grey50 } } }  
box { < 1, 0, 0 > < -2, 5.5, -3 >  translate < 0,  15, -83 > texture { pigment { Grey50 } } }
}

#declare bldg[19]=
union {                 //dime bank
object { bldg[18] }
box { < .1, 0, 0 > < -30, 4.5, -80 >  translate < 0, 0, -78 > texture { pigment { Black } } }
text { ttf "ariblk.ttf", "DIME", .25, 0 scale (<5,6,3>*.70)  rotate (y*-90) translate < .5, 11, -90.5 >  pigment { Red } finish { ambient .25 } }  
cylinder { (x*0) (x*.45) .36 translate < 0, 11.4, -80.0 > pigment { Red } finish { ambient .25 } }                  

}

#declare bldg[20]=       //cooper union
union {
box { < 0,12,0 > < 80, 70, 50 > }
box { < 0,0,0 > < 80, 12, 50 > pigment { DarkGreen } }

object { window[8] translate < 66, 10, 0 > } //windows
object { window[7] translate < 65, 30, 0 > } 
object { window[7] translate < 65, 40, 0 > }  
object { window[7] translate < 65, 50, 0 > }  
object { window[7] translate < 65, 60, 0 > }
 
object { window[8] translate < 46, 10, 0 > } 
object { window[7] translate < 45, 30, 0 > } 
object { window[7] translate < 45, 40, 0 > }
object { window[7] translate < 45, 50, 0 > }
object { window[7] translate < 45, 60, 0 > }
  
object { window[7] translate < 25, 40, 0 > } 
object { window[7] translate < 25, 50, 0 > } 
object { window[7] translate < 25, 60, 0 > }

box { < 0,0,0 > < 84, 1, -4 > translate < 0, 12, 0 > } //scaffolds 
box { < 0,0,0 > < 84, 1, -4 > translate < 0, 21, 0 > }
box { < 0,0,0 > < 84, 1, -4 > translate < 0, 30, 0 > }
box { < 0,0,0 > < 84, 1, -4 > translate < 0, 39, 0 > }
box { < 0,0,0 > < 84, 1, -4 > translate < 0, 48, 0 > }
box { < 0,0,0 > < 84, 1, -4 > translate < 0, 57, 0 > } 
box { < 0,0,0 > < 84, 1, -4 > translate < 0, 66, 0 > }  
}

#declare bldg[21]=       //behind cooper union
union { 
box { < 0,0,0 > < 80, 80, 50 >    }
box { < 78, 78, 0 > < 83, 81, 50 > } 
}
#declare bldg[22]=           //2nd distant highrise
union {                
        box { < 0, 0, 0 > < -90, 350,  90 >  texture { pigment { Grey50 } } }
        #local cnt=150;#while ( cnt < 350 )
                   
                box { <0,0,0> < -5, 5, -1 > translate < -2, cnt, 0 >  texture { pigment {  Grey30 } } } 
                #local cnt=(cnt+10);
        #end 
               
      }            
#declare bldg[0]= 
union {

        difference {
        
                        object { bldg[1] }
                        object { bldg[2] }
                        
                   }
        object { bldg[3] }
        object { cornice[0]   translate (y*58.5) }
        object { cornice[5]   translate < 0, 11, 35 >  texture { t_cornice } }
      }


#declare gem_spa = array[15]


#declare gem_spa[1] =
                        box { < 0, 0, 0 > < -11, 2.5, -.1 >
                                pigment {
                                                image_map { tga "gem_spa.tga" }   scale < 11, 2.5, 1 > 
                                        }
                                finish  { ambient .2 }      //.4
                            translate < 0, 10.5, 0 >
                            }
#declare gem_spa[2] =   
                union {
                        box { < 0, 0, 0 > < -11, -5.5, -.1 >  rotate (x*65)
                                pigment {
                                                image_map { tga "gem_spa2.tga" }    scale (< 11, 5.5, 1 >*.95) translate (y*1.2) 
                                        }
                                finish  { ambient .2 }    //.4
                            translate < 0, 10.5, 0 >
                            }
                        box { < 0, 0, 0 > < -11, -1, -.1 >  rotate (x*5) translate < 0,  8.2, -4.95  >   pigment { Yellow } }
                        
                                                                                                                                                       
                      }
                      
#declare gem_spa[3] = 
                    union {
                        box { < -6, 0, 0 > < 6, -4.2, -.1 >  rotate (x*56)      rotate (y*-45)
                                pigment {
                                             Yellow
                                        }
                                finish  { ambient .2 }       //.3
                             
                            } 
                        
                    }                                    
                       
                       
#declare gem_spa[4] =   
                union {
                        box { < -2, 1, 0 > < 9, -7, 9 >   
                                pigment {   Yellow   }
                                finish  { ambient .2 }      //.3                      
                            } 
                        box { < 0, 1,  2 > < -9, -7,-9 >   
                                pigment {   Yellow  }
                                finish  { ambient .2 }      //.3                       
                            } 
                      }
#declare gem_spa[5] =   
                difference {
                       object { gem_spa[3] }
                       object { gem_spa[4] }
                       translate < 0, 10.5, 0 >
                      } 
#declare gem_spa[6] =          //angled fringe of awning
                box { < -3.55, 0, 0 > < 3.55, -1, -.1 > rotate (x*5)   rotate (y*-45)  translate < 2.42, 8.2, -2.42 >      pigment {   Yellow    } } 
#declare gem_spa[7] =  
union {
        box { <0,0,0><.5,1,1.4> rotate (z*-30) pigment { White*Wheat} }
        box { <0,0,0><.5,1,1.4> rotate (z*-30) translate <0,1,0> pigment { White*Yellow} }
        box { <0,0,0><.5,1,1.4> rotate (z*-30) translate <0,2,0> pigment { White*Wheat} }
        box { <0,0,0><.5,1,1.4> rotate (z*-30) translate <0,3,0> pigment { White} }
        box { <0,0,0><.5,1,1.4> rotate (z*-30) translate <0,4,0> pigment { White*Pink} } 
        box { <0,0,0><.5,1,1.4> rotate (z*-30) translate <0,5,0> pigment { White*Wheat} }
        box { <0,0,0><.5,1,1.4> rotate (z*-30) translate <0,6,0> pigment { White} }
        box { <0,0,0><.5,1,1.4> rotate (z*-30) translate <0,7,0> pigment { White*Pink} }   
        box { <0,0,0><.5,1,1.4> rotate (z*-30) translate <0,7.5,0> pigment { White*Yellow} }
        box { <0,-1,-.1><.5,7.5,1.4> pigment { White } }               
}
#declare gem_spa[8] =  
union {
        box { <0,0,0><.5,1,1.4> rotate (z*-30) pigment { White*Wheat} }
        box { <0,0,0><.5,1,1.4> rotate (z*-30) translate <0,1,0> pigment { White } }
        box { <0,0,0><.5,1,1.4> rotate (z*-30) translate <0,1.8,0> pigment { White*Pink} }
        box { <0,0,0><.5,1,1.4> rotate (z*-30) translate <0,3,0> pigment { White} }
        box { <0,0,0><.5,1,1.4> rotate (z*-30) translate <0,4.2,0> pigment { White*Wheat} } 
        box { <0,0,0><.5,1,1.4> rotate (z*-30) translate <0,5,0> pigment { White*Wheat} }
        box { <0,0,0><.5,1,1.4> rotate (z*-30) translate <0,5.5,0> pigment { White} }
        box { <0,0,0><.5,1,1.4> rotate (z*-30) translate <0,7.1,0> pigment { White*Pink} }   
        box { <0,0,0><.5,1,1.4> rotate (z*-30) translate <0,7.5,0> pigment { White } }
        box { <0,-1,-.1><.5,7.5,1.4> pigment { White } }               
}
#declare gem_spa[9] =  
        box {  < 0, 0, 0 > <  6,  4.5,  -.5 >   
                        pigment {
                                     image_map { tga "backgem.tga" }    scale < 6, 4.5, .5 >  
                                }
            } //wall above wicket
        
#declare gem_spa[10] = 
union {         
        box {  < -5, 0, 0 > < -11,  3.5, -1.5> pigment { Grey80 } }                             //counter
        box {  < -2.8, 0, 0 > < -4.5, 5, -.1 > texture { t_door scale 10 translate (y*.5) } }             //door 
        
        
         
        box {  < 0,0,0> < 2.5, 6, 2.5 > pigment { DarkRed } }  
        box {  < 2.5,0,0> < 5, 6, 2.5 > pigment { DarkRed } }  
        box {  < 0,0, 7.5> < 2.5, 6, 10 > pigment { DarkRed } }  
        box {  < 2.5,0, 7.5> <  5, 6, 10 > pigment { DarkRed } }
        box {  < 0,0,0 > < 3, 3, -.1 > rotate (y*-15)      //sign
                      pigment {
                                    image_map { tga "sign.tga" }    scale < 3, 3, .1 >   //
                               }           
                      finish { ambient .2 }        
                      translate < 1, 5, -1 > 
        }       
        
        //wicket
        #if ( use_media = 0 )
                box {  < -5,4, 0 > < -9, 5,  -.1 > pigment { p_wicket[2]   }}
        #else
                object { light scale .9 translate < -6, 4,  -.5 > }
                object { light scale .9 translate < -6, 5,  -.5 > }
                object { light scale .9 translate < -6.5, 4.5,  -.5 > }
                object { light scale .9 translate < -7, 4,  -.5 > }
                object { light scale .9 translate < -7, 5,  -.5 > } 
                object { light scale .9 translate < -7.5, 4.5,  -.5 > }
                object { light scale .9 translate < -8, 4,  -.5 > }
                object { light scale .9 translate < -8, 5,  -.5 > }
                object { light scale .9 translate < -8.5, 4.5,  -.5 > }
                object { light scale .9 translate < -9, 5,  -.5 > }
                object { light scale .9 translate < -9, 4,  -.5 > }
        #end        
}
#declare gem_spa[11] =               //paper bundle
union { 
        
        #local cnt = 0;
        #while ( cnt < 10 )
                box { <0,0,0> <(1+(.1*rand(R1))),(cnt/5),(1+(.1*rand(R1)))> pigment { rgb < (.75+rand(R1)),(.75+rand(R1)),(.75+rand(R1)) >} }
                #local cnt = (cnt+1); 
        #end
}
#declare gem_spa[12] =          //atm ad
box {  < 0,0,0 > < 1, .5, .1 > 
                         pigment {
                                     image_map { tga "atm.tga" }    scale < 1, .5, .1 >  
                                }  
                        finish {ambient .2}      //.4
        }        


              
#declare gem_spa[0] = 
union  {
        object { gem_spa[1] }
        object { gem_spa[1] rotate (y*-90) translate (z*11) }   //receding side
        object { gem_spa[2] }
        object { gem_spa[2] rotate (y*-90) translate (z*11) }   //receding side
        object { gem_spa[5] }
        object { gem_spa[6] }
        object { gem_spa[7] translate < -11,0,-4.5 > }
        object { gem_spa[8] translate < -11.25,0,-3.00 > } 
        object { gem_spa[9] translate < -11,5.5,0> }
        object { gem_spa[10] }                                                 //various fixtures including video arcades
        object { gem_spa[11] translate < -8.5, 0, -3.0 > }                     //bundles of papers
        object { gem_spa[11] translate < -6.5, 0, -3.0 > }  
        object { gem_spa[11] rotate (z*180) translate < -6.5, 4, -3.0 > }  
        object { gem_spa[11] rotate (z*180) translate < -8.5, 2, -3.0 > }  
        object { gem_spa[11] translate < -10, 2, -3.0 > }             
        object { gem_spa[11] translate < -10.5, 3.5, -3.0 > }
        
        object { gem_spa[11] translate < -2.5, 0, -1.0 > }  
        object { gem_spa[11] translate < -2.5, 2, -1.0 > }
        object { gem_spa[11] translate <  0, 0, -1.0 > }
        object { gem_spa[11] translate <  1.5, 0, -1.0 > } 
        object { gem_spa[11] translate <  2.5, 0, -1.0 > }
            
        object { gem_spa[12] translate <-1.7,4.2,-3.05> scale 1.5 }    //atm
        object { gem_spa[12] translate <-7.3,4.2,-3.05> scale 1.5  }    //atm                               
}
                      
#declare pauls = array[10]
#declare pauls[2] = 
box { < 0, 0, 0  > < -18, -1.2, -.1 >  
        pigment {
                        image_map { tga "pauls2.tga" }   scale < 18, 1.2,  1 > 
                }
        finish  { ambient .2 }       //.3
    }
#declare pauls[1] = 
        union {
                    box { < 0, 0, 0 > < -18, 2.5, -1.1 >
                        pigment {
                                        image_map { tga "pauls.tga" }   scale < 18, 2.5, 1 > translate (y*-.05)
                                }
                        finish  { ambient .4 }    //.4
                    translate < -11, 10.2, 0 >
                    }
                    box { < 0, 0, 0 > < -18, -5.5, -.1 >  rotate (x*75)
                        pigment {
                                        Black*Brown
                                }
                        finish  { ambient .3 }    //.3
                    translate < -11, 10.0, 0 >
                    }
                    object { pauls[2]   rotate (x*-75) translate <0,-5.5,0> rotate (x*75)   
                       
                                        translate < -11, 10.0, 0 >
                    }
                    box { < 0, 0, 0 > < -1.85, 6, 1 > translate < -18, 0, -.5 > texture { t_pauls[0] scale .5 }  } 
                    box { < 0, 0, 0 > < -1.85, 6, 1 > rotate (z*90) translate < -20, 2, -.5 > texture { t_pauls[0] scale .5 }  }
                      
                    text { ttf "Lhandw.ttf", "really", .2, 0 scale .6 translate < -21, 9.0, -.5 >  pigment { White } finish { ambient .75 } }  
                    text { ttf "Lhandw.ttf", "great", .2, 0 scale .6 translate < -21, 8.5, -.5 >  pigment { White } finish { ambient .75 } }  
                    text { ttf "Lhandw.ttf", "pauls", .2, 0 scale .6 translate < -21, 8.0, -.5 >  pigment { White } finish { ambient .75 } }  
                  
                    
                                     
                    box { < 0, 0, 0 > < -2.5, 1.2, .1 > translate < -20, 3, -.1 > texture { t_pauls[3] }
                    }
                   
                    torus {1.5, .3  scale <1,1,.6> rotate (x*90) translate < -15, 8, -.5 > pigment { Red } finish { ambient .5 } } 
                    torus {1.5, .3  scale <1,1,.6> rotate (x*90) translate < -15, 7.4, -.5 > pigment { Red } finish { ambient .5 } }
                     
                    object { light   translate < -19, 7.5, -3 > }
                
                    text { ttf "Lhandw.ttf", "pauls", .2, 0 scale .6 translate < -25, 6.5, -.5 >  pigment { Cyan } finish { ambient .75 } }  
                    text { ttf "Lhandw.ttf", "pauls", .2, 0 scale .6 translate < -25, 6.0, -.5 >  pigment { White } finish { ambient .95 } }  
                    text { ttf "Lhandw.ttf", "pauls", .2, 0 scale .6 translate < -25, 5.5, -.5 >  pigment { Cyan } finish { ambient .75 } }  
                    text { ttf "Lhandw.ttf", "hamburg", .2, 0 scale .6 translate < -25, 5.0, -.5 >  pigment { Cyan } finish { ambient .75 } }
                    text { ttf "Lhandw.ttf", "pauls", .2, 0 scale .6 translate < -28, 6.5, -.5 >  pigment { Cyan } finish { ambient .75 } }    
                    text { ttf "Lhandw.ttf", "hotdog", .2, 0 scale .6 translate < -28, 6.0, -.5 >  pigment { White } finish { ambient .95 } }  
                    text { ttf "Lhandw.ttf", "pauls", .2, 0 scale .6 translate < -28, 5.5, -.5 >  pigment { Cyan } finish { ambient .75 } }  
                    text { ttf "Lhandw.ttf", "pauls", .2, 0 scale .6 translate < -28, 5.0, -.5 >  pigment { Cyan } finish { ambient .75 } }  
                  
        }        
  
#declare cinderella = array[7]
#declare cinderella[5] = 
        box { <0,0,0> <-8,  9,  -.2>   texture { t_cinderella } } 

#if ( render_cinderella = 1 )
        #declare cinderella[4] = 
        union {
                object {
                        #declare fontMode = 3
                        #declare Message = "CINDERELLA"
                        #declare Message2 = "SHISHKABOB"
                        #declare Rad = 15
                        #declare Spacing = 2
                        #declare SpaceWidth = 0.2
                        #declare Thick = 1
                        #declare Tilt = 0
                        #declare Gap = 10
                        #include "font.inc"  
                        pigment { Orange*5 }
                        scale .065
                } 
                object {
                        #declare fontMode = 3
                        #declare Message = "CINDERELLA"
                        #declare Message2 = "SHISHKABOB"
                        #declare Rad = 15
                        #declare Spacing = 2
                        #declare SpaceWidth = 0.2
                        #declare Thick = 1
                        #declare Tilt = 0
                        #declare Gap = 10
                        #include "font.inc"  
                        pigment { Pink*5 }
                        scale .06
                } 
                text { ttf "Lhandw.ttf", "ORIGINAL", .2, 0      scale <.1,.1,.1> translate <- .1,0,00>          pigment { Red*White } finish { ambient .75 } }  
                text { ttf "Lhandw.ttf", "FALAFELGYRO", .2, 0   scale <.1,.1,.1> translate <- .1,-.02,00>       pigment { Red*White } finish { ambient .75 } }  
                
        }
        object { cinderella[4] translate < -32, 5,   -3 >          } 

#end

#declare cinderella[3] =
        union   {
                        box { < 0,0,0 > < -8, 2.9, -2.9 > rotate (x*45) }
                        box { < 0,-2,2.35 > <-8, 2,  -2.1 > }   
                        rotate (y*90)  
                        pigment { 
                                
                                image_map { tga "cinderella2.tga"   }
                                  
                                scale < 18, 6.5, 5 > translate < 1,-1.5,0> 
                                rotate (y*-90)  
                                 
                        }
                        scale .50
                        finish { ambient .4 }              
                        //pigment { Cyan }
                }        
                        
#declare cinderella[2] =
        difference {
                        cylinder { < 0, 0, 0 > < -11, 0, 0 > 3  }  
                        box { < -12, -4, 0 > < 1, 4, 4 > }
                        box { < -12, 0, -4 > < 1, -4, 1 > }                                                            
        }
#declare cinderella[1] =
        union {  
                object { cinderella[2]  }
                box { <0,0,0> <-11, -2, -3> }
                
                pigment {    
                                image_map { tga "cinderella.tga" }   scale < 11, 5, 1 > translate (y*3.5) 
                                
                        }
                        finish { ambient .4 } 
                
                 
                
                
              }   
         
#declare cinderella[0] =   
union {  
         object { cinderella[1] translate < -29, 9.9, 0 >           }
         object { cinderella[3] translate < -36, 8.8, -10 >         }         
         //object { cinderella[4] translate < -32, 5,   -3 >          }      
         object { cinderella[5] translate < -30, 0,   -.1 >         }  
}

#declare tacoma = 
union {

        box { <0,0,0> <-11,  4,  -2>  translate < -39,   9, 0 > pigment { Grey95 } }   
        box { <0,0,0> <-1.5, 10, -2>  translate < -48.5, 0, 0 > pigment { Grey95 } }
        box { <0,0,0> <-8,  9,  -.2>  translate < -41 ,  0, 0,> texture { t_tacoma[3] } }
}


#declare bhdairy =
union {
        
        box { < 0, 0, 0 > < -10.5, 3, -1 >
               pigment {
                               image_map { tga "bhdairy.tga" }   scale < 10.5, 3, 1 > 
                       }
               finish  { ambient .3 }    //.4
             
             
               translate < -50.2, 10, 0 >
            }
        object {        
                box { < 0,0,0 > <-2.5, 1.2,  -10 > }           
                pigment { Brown }
                translate < -50.2, 8, 0 >
        }
        #if ( use_media = 0 )
                box { <0,0,0> <-8,  6,  -.2>  translate < -50 ,  0, 0>          texture { t_bhdairy  } }
                box { <0,0,0> < -2, 6,  -1 >  translate < -54 ,  0, 0>          pigment { Black } } 
                box { <0,0,0> <-8,  2,  -.2>  translate < -50 ,  0, 0>          pigment { Black } } 
        #else
                object { light scale 1.3 translate < - 53, 5.5, -1 > }
                object { light scale 1.5 translate < - 53, 6, -1 > }
                object { light scale 1.1 translate < - 55, 5.0 -1 > }
                object { light scale 1.0 translate < - 55, 6.5 -1 > } 
        #end
}
                                               
#declare korean = array[2]
#declare korean[1] =
union {         
        triangle {  <0,  0,  0>   < 0,  3,   0>   < 6,  0,  0>   }
        triangle {  <0,  3,  0>   < 0,  3,  15>   < 6,  0, 15>   }
        triangle {  <0,  3,  0>   < 6,  0,  15>   < 6,  0,  0>   }
        box { < 0, 0, 0 > < 6, -.5, 15 > }
}


 
#declare korean[0] =
union {
        object { korean[1] pigment { SlateGray } }
        object { light translate < 6, -2,  2 > }   
        object { light scale .75 translate < 6.5, -1.1,  5 > }
        object { light scale .75 translate < 6.8, -0.9,  8 > }
        object { light scale .75 translate < 6.5, -1.2,  11 > }
        object { light scale .75 translate < 5.5, -0.8,  1 > }
        object { light scale .75 translate < 5.5,   -2,  10 > }
        object { light scale .75 translate < 5.0, -1.4,  4 > }
}
#declare villageX = array[4]
#declare villageX[1] =
union {         
        triangle {  <0,  0,  0>   < 10,  3,   0>   < 10,  0,  0>   }  
        triangle {  <0,  0,  0>   <  0,  3,   0>   < 10,  3,  0>   }
        pigment {
                                image_map { tga "villageX.tga" }   scale < 10, 3, .1 >   
                                 
                        }
                        finish { ambient .4 }
}
#declare villageX[2] =
union {                 
        triangle {  <10,  0,  0>   < 10,  3,   0>   < 10,  3,  15>   }
        triangle {  <10,  0,  0>   < 10,  3,  15>   < 10,  0,  15>   }
        pigment { Black }
}         
#declare villageX[0] =
union {
      object { villageX[1] }
      object { villageX[2] }
      box { <0,0,0> < 10, -8, 15 > pigment { Black }}
      //box { <5,-.1,0> <  8, -7, -.2 > texture { t_villageX } }
      box { <0,0,0> < 3, -7, -.2 >  texture { t_villageX } rotate (y*90) translate < 10.1, -.2, 4 > } 
      box { <0,0,0> < 3, -7, -.2 >  texture { t_villageX } translate < 6, -.2, 0 > }
      box { <0,0,0> < 3, -7, -.2 >  texture { t_villageX } translate < 2, -.2, 0 >}
}                                                         




               
object { bldg[0] scale .9 } 

object { bldg[5] texture { t_brick_sim[4] } }
object { bldg[6] texture { t_brick_sim[2] } }
object { bldg[7] texture { t_brick_sim[3] } }
object { bldg[8] texture { t_brick_sim[4] }}
object { bldg[7] texture { t_brick_sim[3] }} 

object { bldg[9] }       //gap                                                     
object { bldg[10] }      //home
object { bldg[12] scale .9 texture { t_brick_sim[2] }}  
object { bldg[13] translate (z*26 ) scale <.9, .85, .9> texture { t_brick_sim[5] }} 
object { bldg[13] translate (z*52 ) scale <.9, .82, .9> texture { t_brick_sim[5] }}
object { bldg[14] translate (z*78 ) scale <.9, .82, .9> texture { t_brick_sim[2] }} 
object { bldg[15] translate (z*104) scale <.9, .83, .9> texture { t_brick_sim[5] }}              
object { bldg[16] translate (z*130) scale <.9, .78, .9> texture { t_brick_sim[3] }}
object { bldg[15] translate (z*156) scale <.9, .80, .9> texture { t_brick_sim[4] }}
object { bldg[14] translate (z*182) scale <.9, .72, .9> texture { t_brick_sim[2] }}

object { bldg[17] translate < -40, 0, 1600 > scale <.9, .72, .9> }     
object { bldg[17] translate < -40, 0, 1750 > scale <.9, .72, .9> }
object { bldg[19] texture { t_brick_sim[1] } } //dime   
object { bldg[20] translate < -70, 0, 500 > texture { t_brick_sim[6] } } //cooper   
object { bldg[21] translate < -65, 0, 680 >  pigment {rgb < 1, .45, .15 >*.5}  } 
object { bldg[22] translate < -190, 0, 1680 > scale <.8, .75, .9> pigment {rgb < 1, .45, .15 >*.5}  }   

object { gem_spa[0] }
object { pauls[1] }
object { cinderella[0] }      
object { tacoma }   
object { bhdairy }
object { korean[0] translate < 0, 9, 12 > }    
object { villageX[0] translate < -4, 8, 43 >   }

box { <-20, -5, 700 > <  10, 70, 8000 > pigment { rgb < .2, .1, 0 > } } 
box { <-20, -5, 1200 > <  20, 60, 2000 > pigment { rgb < .2, 0, 0 > } }

#end //render bldgs 

 
#switch ( render_pavement )
#case ( 1 ) 

#declare pavement = array[10]
#declare pavement[1] = 
difference {
                cylinder { (y*0) (y*.1) 1.1 }
                #local cnt = 0;#while ( cnt < 360 )
                        sphere { 0 .05 scale <1,3,1> translate < .1, .1, 0 > rotate (y*cnt) texture { t_manhole} }  
                        sphere { 0 .05 scale <1,3,1> translate < .3, .1, 0 > rotate (y*cnt) texture { t_manhole} } 
                        sphere { 0 .05 scale <1,3,1> translate < .5, .1, 0 > rotate (y*cnt) texture { t_manhole} } 
                        sphere { 0 .05 scale <1,3,1> translate < .7, .1, 0 > rotate (y*cnt) texture { t_manhole} } 
                        sphere { 0 .05 scale <1,3,1> translate < .9, .1, 0 > rotate (y*cnt) texture { t_manhole} } 
                        #local cnt=(cnt+40);
                #end 
                scale 1.05
                
                texture { t_manhole }
                     
             }

#declare pavement[2] = 
 object {
 
         #include "pavement.inc" 
        
         #if ( use_reflection = 1 )
               texture { t_pavement3 }
         #else
               pigment { Grey25*LightBlue }
         #end
    
         
               
 }//object   

object { pavement[1] rotate (z*-1  ) translate < 34, -.72, -98 >}
object { pavement[2] }     
     
#end


#switch ( render_sidewalk )
#case ( 1 )
 





#declare sidewalk = array[15] 
#declare sidewalk[0] =        //large slab dark
union {
        box { < (-1.96+.04*rand(R1)), -1, -1.94 > < (1.96+.04*rand(R1)), .5, 1.94 >  
                                                         texture {      pigment { p_sidewalk[0] } 
                                                                        finish { reflection .1    }
                                                                         
                                                                 } 
        }
        box { < -1.84, -1, -1.72 > < 1.84, .505, 1.72 >  
                                                         texture {      pigment { p_sidewalk[0] } 
                                                                        finish { reflection .05    }
                                                                     
                                                                 }
        }
} 
#declare sidewalk[1] =    //small slab dark
union {
        box { < (-1.46+.04*rand(R1)), -1, -1.94 > < (1.46+.04*rand(R1)), .500, 1.94 >  
                                                         texture {      pigment { p_sidewalk[0] } 
                                                                        finish { reflection .1 }
                                                                         
                                                                 }
        }
        box { < -1.34, -1, -1.72 > < 1.34, .505, 1.72 >  
                                                         texture {      pigment { p_sidewalk[0] } 
                                                                        finish { reflection .05 }
                                                                      
                                                                 }
        }
}
#declare sidewalk[2] =   //large slab light
union {
        box { < (-1.96+.04*rand(R1)), -1, -1.94 > < (1.96+.04*rand(R1)), .500, 1.94 >  
                                                         texture {    
                                                                        pigment { p_sidewalk[3] }  
                                                                        finish { reflection .3  }
                                                                      
                                                                 }
        }
        box { < -1.82, -1, -1.72 > < 1.82, .505, 1.72 >  
                                                         texture {    
                                                                        pigment { p_sidewalk[3] }   
                                                                        finish { reflection .05  }
                                                                
                                                                 }
        }
        
} 
#declare sidewalk[3] =   //small slab light
union {
        box { < (-1.46+.04*rand(R1)), -1, -1.94 > < (1.46+.04*rand(R1)), .500, 1.94 >  
                                                         texture {      
                                                                        pigment { p_sidewalk[3] }
                                                                        finish { reflection .3 }
                                                                        
                                                                 }
        }
        box { < -1.32, -1, -1.72 > < 1.32, .505, 1.72 >  texture {       
                                                                        pigment { p_sidewalk[3] }
                                                                        finish { reflection .05 }
                                                                       
                                                                 }
        }
         
}
#declare sidewalk[4] =      //curb stones
 
        box { < -.2, -1, (-4.96+.04*rand(R1)) > < 0, .500, (4.96+.04*rand(R1)) >      
                                                         texture {      pigment { dents pigment_map { [ .3 Grey30*Sienna][ .4 Grey50 ][ .5 Sienna ][ 1 Grey30*Sienna] } } 
                                                                        finish { reflection .2 }
                                                                        
                                                                 } 
        } 
#declare sidewalk[6] = 
        box { < 0, -1, (-2.40+.08*rand(R1)) > < .25, .500, (2.40+.08*rand(R1)) >      
                                                         texture {      pigment { Grey45 } 
                                                                        finish { reflection .2  }
                                                                        
                                                                 } 
        }          
 
#declare sidewalk[5] = 
 
        box { < -1.96, -1, -1.94 > < 1.96, .500, 1.94 >  
                                                         texture {      pigment { Grey50 }    }                                                                
        }
        
  
union {
//near corner
object { sidewalk[6] translate < 37,     -.42,   -60 > }
object { sidewalk[6] translate < 37,     -.42,   -65 > }
object { sidewalk[6] translate < 37,     -.42,   -70 > }
object { sidewalk[6] translate < 37,     -.42,   -75 > }
object { sidewalk[6] translate < 37,     -.42,   -80 > }
object { sidewalk[6] translate < 37,     -.42,   -85 > }
object { sidewalk[6] translate < 37,     -.42,   -90 > }
object { sidewalk[6] translate < 37,     -.42,   -95 > }
object { sidewalk[6] translate < 37,     -.42,   -100 > }
object { sidewalk[6] translate < 37,     -.42,   -105 > }
object { sidewalk[6] translate < 37,     -.42,   -110 > }
object { sidewalk[6] translate < 37,     -.42,   -115 > }
object { sidewalk[6] translate < 37,     -.42,   -120 > }
object { sidewalk[6] translate < 37,     -.42,   -125 > }

object { sidewalk[4] translate < 37,     -.42,   -60 > }
object { sidewalk[4] translate < 37,     -.42,   -70 > }
object { sidewalk[4] translate < 37,     -.42,   -80 > }
object { sidewalk[4] translate < 37,     -.42,   -90 > }
object { sidewalk[4] translate < 37,     -.42,   -100 > }
object { sidewalk[4] translate < 37,     -.42,   -110 > }
object { sidewalk[4] translate < 37,     -.42,   -120 > }


  
object { sidewalk[1] translate < 39.5,    0,  -62 >  }  
object { sidewalk[1] translate < 39.5,    0,  -66 >  } 
object { sidewalk[1] translate < 39.5,    0,  -70 >  } 
object { sidewalk[1] translate < 39.5,    0,  -74 >  }      
                                          

object { sidewalk[0] translate <  43,    0,  -62 >  }  
object { sidewalk[0] translate <  43,    0,  -66 >  } 
object { sidewalk[0] translate <  43,    0,  -70 >  } 
object { sidewalk[0] translate <  43,    0,  -74 >  } 
                                          
object { sidewalk[0] translate <  47,    0,  -62 >  }  
object { sidewalk[0] translate <  47,    0,  -66 >  } 
object { sidewalk[0] translate <  47,    0,  -70 >  } 
object { sidewalk[0] translate <  47,    0,  -74 >  } 


object { sidewalk[1] translate < 39.5, 0,  -78 >  }    
object { sidewalk[1] translate < 39.5, 0,  -82 >  }
object { sidewalk[1] translate < 39.5, 0,  -86 >  }
object { sidewalk[1] translate < 39.5, 0,  -90 >  }
                                                                    
object { sidewalk[0] translate <  43, 0,  -78  >  }    
object { sidewalk[0] translate <  43, 0,  -82  >  }
object { sidewalk[0] translate <  43, 0,  -86  >  }
object { sidewalk[0] translate <  43, 0,  -90  >  }
                                                  
object { sidewalk[0] translate <  47, 0,  -78  >  }    
object { sidewalk[0] translate <  47, 0,  -82  >  }
object { sidewalk[0] translate <  47, 0,  -86  >  }
object { sidewalk[0] translate <  47, 0,  -90  >  }
                                                                                
object { sidewalk[3] translate < 39.5, 0, -94  >  }    
object { sidewalk[3] translate < 39.5, 0, -98  >  }
object { sidewalk[3] translate < 39.5, 0, -102 >  }
object { sidewalk[3] translate < 39.5, 0, -106 >  }
                                          
object { sidewalk[2] translate <  43, 0,  -94  >  }    
object { sidewalk[2] translate <  43, 0,  -98  >  }
object { sidewalk[2] translate <  43, 0,  -102 >  }
object { sidewalk[2] translate <  43, 0,  -106 >  }
                                          
object { sidewalk[0] translate <  47, 0,  -94  >  }    
object { sidewalk[0] translate <  47, 0,  -98  >  }
object { sidewalk[0] translate <  47, 0,  -102 >  }
object { sidewalk[0] translate <  47, 0,  -106 >  }
                                                                                         
object { sidewalk[1] translate < 39.5, 0, -110 >  }    
object { sidewalk[1] translate < 39.5, 0, -114 >  }
object { sidewalk[3] translate < 39.5, 0, -118 >  }
object { sidewalk[3] translate < 39.5, 0, -122 >  }
                                          
object { sidewalk[0] translate <  43, 0,  -110 >  }    
object { sidewalk[0] translate <  43, 0,  -114 >  }
object { sidewalk[2] translate <  43, 0,  -118 >  }
object { sidewalk[2] translate <  43, 0,  -122 >  }
                                          
object { sidewalk[0] translate <  47, 0,  -110 >  }    
object { sidewalk[0] translate <  47, 0,  -114 >  }
object { sidewalk[0] translate <  47, 0,  -118 >  }
object { sidewalk[0] translate <  47, 0,  -122 >  }   



//dime corner

object { sidewalk[6]  translate < 9.75,    -.8,   -60 > }
object { sidewalk[6]  translate < 9.75,    -.8,   -65 > }
object { sidewalk[6]  translate < 9.75,    -.8,   -70 > }
object { sidewalk[6]  translate < 9.75,    -.8,   -75 > }
object { sidewalk[6]  translate < 9.75,    -.8,   -80 > }
object { sidewalk[6]  translate < 9.75,    -.8,   -85 > }
object { sidewalk[6]  translate < 9.75,    -.8,   -90 > }
object { sidewalk[6]  translate < 9.75,    -.8,   -95 > }
object { sidewalk[6]  translate < 9.75,    -.8,   -100 > }
object { sidewalk[6]  translate < 9.75,    -.8,   -105 > }
object { sidewalk[6]  translate < 9.75,    -.8,   -110 > }
object { sidewalk[6]  translate < 9.75,    -.8,   -115 > }
object { sidewalk[6]  translate < 9.75,    -.8,   -120 > }
object { sidewalk[6]  translate < 9.75,    -.8,   -125 > }

object { sidewalk[4]  translate < 10.2,   -.1,   -60 > }
object { sidewalk[4]  translate < 10.2,   -.1,   -70 > }
object { sidewalk[4]  translate < 10.2,   -.1,   -80 > }
object { sidewalk[4]  translate < 10.2,   -.1,   -90 > }
object { sidewalk[4]  translate < 10.2,   -.1,   -100 > }
object { sidewalk[4]  translate < 10.2,   -.1,   -110 > }
object { sidewalk[4]  translate < 10.2,   -.1,   -120 > }

object { sidewalk[0] translate < 0, 0,  -62 >  }  
object { sidewalk[0] translate < 0, 0,  -66 >  } 
object { sidewalk[0] translate < 0, 0,  -70 >  } 
object { sidewalk[0] translate < 0, 0,  -74 >  }      
                                    
object { sidewalk[0] translate < 4, 0,  -62 >  }  
object { sidewalk[0] translate < 4, 0,  -66 >  } 
object { sidewalk[0] translate < 4, 0,  -70 >  } 
object { sidewalk[0] translate < 4, 0,  -74 >  } 
                                    
object { sidewalk[0] translate < 8, 0,  -62 >  }  
object { sidewalk[0] translate < 8, 0,  -66 >  } 
object { sidewalk[0] translate < 8, 0,  -70 >  } 
object { sidewalk[0] translate < 8, 0,  -74 >  } 


object { sidewalk[0] translate < 0, 0,  -78 >  }    
object { sidewalk[0] translate < 0, 0,  -82 >  }
object { sidewalk[0] translate < 0, 0,  -86 >  }
object { sidewalk[0] translate < 0, 0,  -90 >  }
                                         
object { sidewalk[0] translate < 4, 0,  -78 >  }    
object { sidewalk[0] translate < 4, 0,  -82 >  }
object { sidewalk[0] translate < 4, 0,  -86 >  }
object { sidewalk[0] translate < 4, 0,  -90 >  }
                                              
object { sidewalk[0] translate < 8, 0,  -78 >  }    
object { sidewalk[0] translate < 8, 0,  -82 >  }
object { sidewalk[0] translate < 8, 0,  -86 >  }
object { sidewalk[0] translate < 8, 0,  -90 >  }
                                                
                                                
object { sidewalk[1] translate < 0, 0, -94  >  }    
object { sidewalk[1] translate < 0, 0, -98  >  }
object { sidewalk[1] translate < 0, 0, -102 >  }
object { sidewalk[1] translate < 0, 0, -106 >  }
                                          
object { sidewalk[0] translate < 4, 0,  -94  >  }    
object { sidewalk[0] translate < 4, 0,  -98  >  }
object { sidewalk[0] translate < 4, 0,  -102 >  }
object { sidewalk[0] translate < 4, 0,  -106 >  }
                                          
object { sidewalk[0] translate < 8, 0,  -94  >  }    
object { sidewalk[0] translate < 8, 0,  -98  >  }
object { sidewalk[0] translate < 8, 0,  -102 >  }
object { sidewalk[0] translate < 8, 0,  -106 >  }

//gem spa
object { sidewalk[5] translate < 0, 0,   -3  >  }  
object { sidewalk[5] translate < 0, 0,   -7  >  } 
object { sidewalk[5] translate < 0, 0,   -11 >  } 
object { sidewalk[5] translate < 0, 0,   -15 >  }      
                                    
object { sidewalk[5] translate < 4, 0,   -3  >  }  
object { sidewalk[5] translate < 4, 0,   -7  >  } 
object { sidewalk[5] translate < 4, 0,   -11 >  } 
object { sidewalk[5] translate < 4, 0,   -15 >  } 
                                    
object { sidewalk[5] translate < 8, 0,   -3  >  }  
object { sidewalk[5] translate < 8, 0,   -7  >  } 
object { sidewalk[5] translate < 8, 0,   -11 >  } 
object { sidewalk[5] translate < 8, 0,   -15 >  } 


 
        #local cnt = 1;#while ( cnt < 200 )
                object { sidewalk[5] translate < 0, 0,  cnt >  } 
                object { sidewalk[5] translate < 4, 0,  cnt >  }
                object { sidewalk[5] translate < 8, 0,  cnt >  }     
               #local cnt=(cnt+4);
        #end                                                     





        #local cnt = 4;#while ( cnt < 200 )
                object { sidewalk[5] translate < -cnt, 0,   -3  >  }  
                object { sidewalk[5] translate < -cnt, 0,   -7  >  } 
                object { sidewalk[5] translate < -cnt, 0,   -11 >  } 
                object { sidewalk[5] translate < -cnt, 0,   -15 >  }      
               #local cnt=(cnt+4);
        #end                                                                 

}//end union

#end
                          

#switch ( render_traffic_light )
#case ( 1 )

#declare traffic_light = array[20]
#declare traffic_light[19] =      
     box { < 0, 0, 0 > < 1.60, .40, .1 >
                      pigment {
                                      image_map { tga "stmarks.tga" }   scale  < 1.60, .40, .1 >  
                              }
                      finish  { ambient .4 }
                  
         } 
         
#declare traffic_light[18] =
     box { < 0, 0, 0 > < 1.60, .40, .1 >
                      pigment {
                                      image_map { tga "2ave.tga" }   scale  < 1.60, .40, .1 >    
                              }
                      finish  { ambient .4 }
                  
         }
#declare traffic_light[17] =         
union {         
     object { traffic_light[19]    rotate (y*-90)     translate < .4, 0, 0 > }
     object { traffic_light[18]    translate < -1.6, .4, -.4 > }
}
#declare traffic_light[16] =
        box { <0,0,0> <.05,1.5,1> pigment { Red  } }                    
#declare traffic_light[14] =
union {
        box { <0,0,1> <.45,1,2.5> }
        box { <.06,.08,1.08> <.47,.92,2.44> pigment { Black }   }
        box { <-1,0,0> <-2.5,1,-.45> } 
        box { <-1.08,.08,-.06> <-2.42,.92,-.47> pigment { Black }  } 
        text { ttf "ariblk.ttf", "WALK", .2, 0 scale <.30,.4,.2> translate <-2.20,.1,-.50>  pigment { Cyan*White } finish { ambient .75 } }  
                  
        pigment { Yellow }
       }  
#declare traffic_light[13] =
union {
        box { <0,0,1> <.45,1,2.5> }
        box { <.06,.08,1.08> <.47,.92,2.44> pigment { Black }   }
        box { <-1,0,0> <-2.5,1,-.45> } 
        box { <-1.08,.08,-.06> <-2.42,.92,-.47> pigment { Black }  } 
        text { ttf "ariblk.ttf", "DONT", .2, 0 scale <.25,.4,.2> translate <-2.40,.5,-.50>  pigment { Pink*White } finish { ambient .75 } }  
                  
        pigment { Yellow }
       }
       
#declare traffic_light[12] =
       
       box { < 0, 0, 0 > < 2.8, .7, .1 >
                        pigment {
                                        image_map { tga "oneway.tga" }   scale < 2.8, .7, .1 > 
                                }
                        finish  { ambient .4 }
                    
           }
#declare traffic_light[11] =
       
       box { < 0, 0, 0 > < 2, 2.5, .1 >
                        pigment {
                                        image_map { tga "bike.tga" }   scale < 2, 2.5, .1 > 
                                }
                        finish  { ambient .3 }     //.4
                    
           }

#declare traffic_light[9] =
union {
        
      
        #declare spline_smoothness =  10;
                #declare spline_smoothness = (1 / spline_smoothness);  
                #declare spline_clock = .05;
                #declare final_rad = .08;
                #declare delta = .15;
                
               
                #declare delta = .05;
                #while (spline_clock <= 1)        
         
                        #declare spline_segments = 1;

                        #declare point0 = <    -2,          -3,         0   >;
                        #declare point1 = <     0,          12,         0   >;
                        #declare point2 = <    18,          17,         0   >;
                        #declare point3 = <     2,           0,         0   >;                   
                        #include "SplineR.inc"                                
                                            
                        #if (spline_clock = .05) 
                                #declare prev_spline_pos = spline_pos;
                                #declare prev_spline_clock = spline_clock;
                        #else
                                cone { prev_spline_pos, (final_rad+(delta*(1-prev_spline_clock))), spline_pos, (final_rad+(delta*(1-spline_clock))) }     
                                #declare prev_spline_pos = spline_pos;
                                #declare prev_spline_clock = spline_clock;
                        #end      
                        #declare spline_clock = (spline_clock + spline_smoothness); 
                #end //end while 
                                              
        }
#declare traffic_light[8] =    
difference {
                cylinder { (x*0) (x*.8) .28 open } 
                cylinder { (x*0) (x*.8) .28 translate < .05, -.35, 0 > }
        }         
                
#declare traffic_light[7] =
union {
        box { < 0, 0, 0 > < .2, 2, .6 > }
        cylinder { < .1, 2, .25 > < .1, 2.7, .25 > .1 texture { t_traffic_light }}
        object { traffic_light[8] translate < .1, (1/3), .3 > } 
        object { traffic_light[8] translate < .1, (3/3), .3 > }
        object { traffic_light[8] translate < .1, (5/3), .3 > }
        //object { redlight scale .9 translate < .1, (1/3), .3 > }
      }
#declare traffic_light[6] =
union {
        box { < 0, 0, 0 > < .2, 2, .6 > }
        object { traffic_light[8] translate < .1, (1/3), .3 > } 
        object { traffic_light[8] translate < .1, (3/3), .3 > }
        object { traffic_light[8] translate < .1, (5/3), .3 > }
        //object { redlight scale .9 translate < .1, (1/3), .3 > }
      }
#declare traffic_light[5] =
union {
        object { traffic_light[6] translate < .25, 0, -.5 > }
        object { traffic_light[6] rotate (y*-90) translate < -.25, 0,  .5 > }
        cylinder { < .25, 2.0, -.5 > < -.25, 2.0,  .5 > .1  texture { t_traffic_light } }
        cylinder { < 0, 2.0, 0 > < 0, 2.7, 0 > .1 texture { t_traffic_light } }
} 

#declare traffic_light[4] =        //lamp
union {
        sphere { 0, .25 scale < 2.5, .5, 1.5 >      }
        sphere { 0, .20 scale < 1.5, .75, 1 > translate < .2, -.15, 0 >     }
        
        
}
#declare traffic_light[3] =
union {
        
      
        #declare spline_smoothness =  10;
                #declare spline_smoothness = (1 / spline_smoothness);  
                #declare spline_clock = .05;
                #declare final_rad = .06;
                #declare delta = .10;
                
               
                #declare delta = .05;
                #while (spline_clock <= 1)        
         
                        #declare spline_segments = 1;

                        #declare point0 = <     0,          -3,         0   >;
                        #declare point1 = <     0,          21.5,       0   >;
                        #declare point2 = <     5,          27,         0   >;
                        #declare point3 = <     2,           0,         0   >;                   
                        #include "SplineR.inc"                                
                                            
                        #if (spline_clock = .05) 
                                #declare prev_spline_pos = spline_pos;
                                #declare prev_spline_clock = spline_clock;
                        #else
                                cone { prev_spline_pos, (final_rad+(delta*(1-prev_spline_clock))), spline_pos, (final_rad+(delta*(1-spline_clock))) }     
                                #declare prev_spline_pos = spline_pos;
                                #declare prev_spline_clock = spline_clock;
                        #end      
                        #declare spline_clock = (spline_clock + spline_smoothness); 
                #end //end while 
                object { traffic_light[4] translate < 5,        27,     0 > }     //street light                     
        }
#declare traffic_light[0] =
union {
        cone { (y*0), .50, (y*3), .40   }                                               //light standard base
        cone { (y*0), .37, (y*22), .15    }                                             //light standard
        cylinder { (x*-2),  (x*2), .12   translate < 0, 17, .3 > }         //cross brace
        object { traffic_light[9] rotate (y*90)  }                                                              //traffic light arm
        object { traffic_light[7] rotate (y*-90) translate < 18, 14.2, 0 > rotate (y*90) pigment {  Yellow } }  //traffic light
        object { traffic_light[3] rotate (y*90) translate <0,0,-.1> }                   //street light
        object { traffic_light[3] translate <.1,0,0>   }                                //street light
        object { traffic_light[14] translate < 0,7,0 > }                               //walk / don't walk signal 
        object { traffic_light[12] rotate (y*-90) translate <.4,10.5,-1.25> }          //one way  
        object { traffic_light[17] translate <0,11.5,0> }                              //street names
        object { traffic_light[16] translate <.45,8.4,-.5> }                               //snow route
}                                                                                                 


#declare traffic_light[1] =
union {                           
        cone { (y*0), .50, (y*3), .40    }                                    //base
        cone { (y*0), .37, (y*17), .15   }                                    //standard
        cylinder { (x*-2),  (x*2), .12 rotate (y*45) translate < -.2, 17, -.2 > }  //brace at top
        object { traffic_light[9] rotate (y*-45) }                            //traffic light arm
        object { traffic_light[5] rotate (y*45) translate < 17.5, 14.2, 0 > rotate (y*-45) pigment {  Yellow } }   //traffic light
        object { traffic_light[13] rotate (y*-90) translate < 0,7,0 > }                                           //walk/dontwalk  signal  
        object { traffic_light[12] rotate (y*-90) translate <.4,10,-1.25> }                                       //one way 
        object { traffic_light[12] translate <-1.4,10.8,0> }                                                      //one way
        object { traffic_light[11] rotate (y*-90) translate < .4,13,-1> }   
} 

object { traffic_light[0] texture { t_traffic_light } translate < 4,0,-14> }   
object { traffic_light[1] texture { t_traffic_light } translate < 8,0,-66> }
#end



#switch ( render_trees )
#case ( 1 )
 

#declare txtTree=texture{pigment { Brown } finish { ambient .12}} // Bark texture
#declare tree5 =  #include "citytree5.inc"
#declare tree3 =  #include "citytree3.inc"
#declare tree2 =  #include "citytree2.inc"
#declare tree1 =  #include "citytree1.inc"        
#declare tree0 =  #include "citytree0.inc" 

object { tree3 scale .3 translate < 44, -1,  25  > }
object { tree5 scale .4 translate < 45 , -1, 75  > }        
object { tree2 scale .5 translate < 43, -1, 150  > }
object { tree0 scale .5 translate < 46, -1, 200  > }

object { tree3 scale .4 translate < 8, -1, 60 > }
object { tree2 scale .55 translate < 8, -1, 120> }
object { tree3 scale .5 translate < 8, -1, 160 > }

object { tree1 scale .45 translate < -25, -1, -10 > }
object { tree0 scale .45 translate < -55, -1, -10 > } 

object { tree0 scale .4 rotate (y*90 ) translate < 8, -1, -105 > }
#end//render tree



#switch ( render_car )
#case ( 1 )
 
#include "car.inc"

object { car[0] scale .9            
        //rotate (y*20)             
        translate <13,0.90,-90>
        pigment { White*1.4 }     
}
motion_blur { 

        car[1]  scale 1.1           
        //rotate (y*20) 
         translate < 27,.54,(-75-clock) >            
        
        pigment { LightSteelBlue5*1.1 }
              
}                                                                       

#end//render car



#switch ( render_people )
#case ( 1 )
 
#include "people.inc"

object { person[1] scale .9 rotate (y*-120) translate < 45, .4, -70 >  }                           
                                                       
object { person[2] scale .9 translate < 12, 0, -45 >  }          
                                                       
object { person[3] scale .9 translate <  8, 0, -10 >  }  
object { person[3] scale .9 translate <  0, 0,  -8 >  } 
object { person[3] scale .9 translate < -4, 0,  -9 >  } 
object { person[3] scale .9 translate < -8, 0, -10 >  } 

object { person[4] scale .9 translate < 52, .12, -50 >  }  
object { person[4] scale .9 translate < 46, .18, -48 >  }  
object { person[4] scale .9 translate < 45, .10, -45 >  }  
object { person[4] scale .9 translate < 43, .11, -42 >  }  
object { person[4] scale .9 translate < 50, .15, -48 >  }  
object { person[4] scale .9 translate < 44, .10, -51 >  } 

#local cnt=0;#while ( cnt < 10 )

        object { p1 ( < rand(R1), rand(R1), rand(R1) >, < rand(R1), rand(R1), rand(R1) >, < rand(R1), rand(R1), rand(R1) >, (3*rand(R1)) ) 
                 scale .9
                 translate < (40+10*rand(R1)), (.1*rand(R1)), (55*rand(R1)) > 
        }
        object { p1 ( < rand(R1), rand(R1), rand(R1) >, < rand(R1), rand(R1), rand(R1) >, < rand(R1), rand(R1), rand(R1) >, (3*rand(R1)) ) 
                 scale .9
                 translate < (40+10*rand(R1)), (.1*rand(R1)), (-55*rand(R1)) > 
        }
        object { p1 ( < rand(R1), rand(R1), rand(R1) >, < rand(R1), rand(R1), rand(R1) >, < rand(R1), rand(R1), rand(R1) >, (3*rand(R1)) ) 
                 scale .9
                 translate < (10*rand(R1)), (.1+.1*rand(R1)), (150*rand(R1)) > 
        }  
        object { p1 ( < rand(R1), rand(R1), rand(R1) >, < rand(R1), rand(R1), rand(R1) >, < rand(R1), rand(R1), rand(R1) >, (3*rand(R1)) ) 
                 rotate (y*90)
                 scale .9
                 translate < (-10+(-80*rand(R1))), (.3+.1*rand(R1)), (-10*rand(R1)) > 
        }  
        object { p1 ( < rand(R1), rand(R1), rand(R1) >, < rand(R1), rand(R1), rand(R1) >, < rand(R1), rand(R1), rand(R1) >, (3*rand(R1)) ) 
                 rotate (y*90*rand(R1))
                 scale .9
                 translate < (-30*rand(R1)), (.1+.1*rand(R1)), (-80*rand(R1)) > 
        }  
        
        
        object { p2 ( < rand(R1), rand(R1), rand(R1) >, < rand(R1), rand(R1), rand(R1) >, < rand(R1), rand(R1), rand(R1) >, (3*rand(R1)) ) 
                 scale .9
                 translate < (40+10*rand(R1)), (.1+.1*rand(R1)), (55*rand(R1)) > 
        }
        object { p2 ( < rand(R1), rand(R1), rand(R1) >, < rand(R1), rand(R1), rand(R1) >, < rand(R1), rand(R1), rand(R1) >, (3*rand(R1)) ) 
                 scale .9
                 translate < (40+10*rand(R1)), (.1+.1*rand(R1)), (-55*rand(R1)) > 
        }
        object { p2 ( < rand(R1), rand(R1), rand(R1) >, < rand(R1), rand(R1), rand(R1) >, < rand(R1), rand(R1), rand(R1) >, (3*rand(R1)) ) 
                 scale .9
                 translate < (10*rand(R1)), (.1+.1*rand(R1)), (150*rand(R1)) > 
        }  
        object { p2 ( < rand(R1), rand(R1), rand(R1) >, < rand(R1), rand(R1), rand(R1) >, < rand(R1), rand(R1), rand(R1) >, (3*rand(R1)) ) 
                 rotate (y*90)
                 scale .9
                 translate < (-10+(-80*rand(R1))), (.3+.1*rand(R1)), (-10*rand(R1)) > 
        }
        
        
        #local cnt=(cnt+1);  
#end 
 

#end//render people  

#switch ( render_figure )
#case ( 1 ) 

#declare aimer = union {
                cylinder { <-1,0,0> <1,0,0> .005  }      //x      
                cylinder { <0,-1,0> <0,1,0> .005  }      //y
                cylinder { <0,0,-1> <0,0,1> .005  }      //z 
        }      
 
  


light_source
{
  0*x                     // light's position (translated below)
  color Gold*.03          // light's color
  spotlight               // this kind of light source
  cylinder                // this variation
  translate <  15, 40,  -30 >+< 43.5, -1.85, -120 > // <x y z> position of light
  point_at < 43.5, 4, -120 >      // direction of spotlight
  radius 5                // hotspot (inner, in degrees)
  tightness 5             // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)
}




#include "couple1.inc" 

motion_blur { couple1 scale 10  rotate (y*170) rotate (y*6*clock)  translate < 43, -1.85, -120 >    }      

#include "couple2.inc"
  
motion_blur { couple2 scale 10  rotate (y*170) rotate (y*-6*clock)  translate < 43, -1.85, -120 >    }      



#end//render figure     