// Persistence of Vision Ray Tracer Scene Description File
// File: people.inc
// Vers: .4
// Desc: City Topic
// Date: April 30, 2000
// Auth: Jim Charter
 
 
#version unofficial MegaPov 0.4;       
       
 
#declare person = array[6]

#declare person[1] =
blob { threshold .4
        sphere { 0, 1, 1 scale < .45, .8, .8 >*.8 rotate < 10, 0, 0 >  translate < 0, 5.55, -.15 > texture { pigment { rgb < .56, .20, .09 >*2 } }} //hair
 
        sphere { 0, 1, 1 scale < .45, .8, .8 >*.85 rotate < 10, 0, 0 > translate < 0, 5.5, -.15 > texture { pigment { rgb < .96, .80, .69 >*2 } }} //head 
        
        //torso
        #declare spline_smoothness =  10;
        #declare spline_smoothness = (1 / spline_smoothness);  
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,        -.1  >; 
                #declare point1 =  <    0,       4.3,          0  >;
                #declare point2 =  <    0,       3.0,          0  >;
                #declare point3 =  <    0,       -.1,         .1  >;
                #include "SplineR.inc" 
            
                #if ( spline_clock < .5 ) #local scl = (.5+(1-spline_clock)*.5); #else #local scl = (.5+spline_clock*.5); #end
    
                sphere {<0,0,0>, 1, 1 
                        scale < scl, 1, 1 >
                        texture { pigment { rgb < .7, .7, .5 > } }    
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
        
        //arm
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,        -.1  >; 
                #declare point1 =  <   .7,       4.5,          0  >;
                #declare point2 =  <   .6,       2.8,        -.4  >;
                #declare point3 =  <    0,       -.1,        -.1  >;
                #include "SplineR.inc" 
            
                #local scl = (.25+(1-spline_clock)*.2); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb < .7, .7, .5 > } }   
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
  
        //arm
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,        -.1  >; 
                #declare point1 =  <  -.7,       4.5,          0  >;
                #declare point2 =  <  -.6,       2.9,        -.3  >;
                #declare point3 =  <    0,       -.1,        -.1  >;
                #include "SplineR.inc" 
            
                #local scl = (.25+(1-spline_clock)*.2); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb < .7, .7, .5 > } }   
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
 
        //leg
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,         .1  >; 
                #declare point1 =  <   .4,       3.0,          0  >;
                #declare point2 =  <   .3,        .4,         .6  >;
                #declare point3 =  <    0,       -.1,         .1  >;
                #include "SplineR.inc" 
            
                #local scl = (.30+(1-spline_clock)*.3); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb < .1, .1, .1 > } }    
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
 
        //leg
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,         .05  >; 
                #declare point1 =  <  -.4,       3.0,          0  >;
                #declare point2 =  <  -.3,        .2,         .1  >;
                #declare point3 =  <    0,       -.1,         .05  >;
                #include "SplineR.inc" 
            
                #local scl = (.30+(1-spline_clock)*.3); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb < .1, .1, .1 > }  }  
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
            
        //foot
        sphere { 0, 1, 1 rotate ( x*-8) scale < .3, .2, .6 > translate <  .4,        .4,         .4  > texture { pigment { rgb < .1, .1, .1 > } } }
        sphere { 0, 1, 1 scale < .3, .2, .6 > translate < -.4,        .2,        -.1  > texture { pigment { rgb < .1, .1, .1 > } } }
 
}//end blob 
 
 
#declare person[2] = 
union {
blob { threshold .3
        sphere { 0, 1, 1 scale < .5, .9, .8 >*.85 rotate < 10, 0, 0 >  translate < 0, 5.45, -.08 > texture { pigment { rgb < .26, .10, .09 >*2 } }} //hair
 
        sphere { 0, 1, 1 scale < .5, .9, .7 >*.9 rotate < 10, 0, 0 > translate < 0, 5.4, 0 > texture { pigment { rgb < .96, .80, .69 >*2} } }//head 
        #declare spline_smoothness =  15;
        #declare spline_smoothness = (1 / spline_smoothness);  
        //torso
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,        -.1  >; 
                #declare point1 =  <    0,       4.2,          0  >;
                #declare point2 =  <    0,       1.5,          0  >;
                #declare point3 =  <    0,       -.1,         .1  >;
                #include "SplineR.inc" 
            
                #local scl = (.5+spline_clock*.5); 
                                                                                                   
                sphere {<0,0,0>, 1, 1 
                        scale < scl, 1, 1 >
                        texture { pigment { rgb < .7, .5, .5 > }  }  
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
        
        //arm
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,        -.1  >; 
                #declare point1 =  <   .5,       4.5,          0  >;
                #declare point2 =  <   .5,       3.2,          0  >;
                #declare point3 =  <    0,       -.1,        -.1  >;
                #include "SplineR.inc" 
            
                #local scl = (.15+(1-spline_clock)*.1); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb < .7, .7, .5 > }  }  
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
  
        //arm
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,        -.1  >; 
                #declare point1 =  <  -.5,       4.5,          0  >;
                #declare point2 =  <  -.5,       2.7,        -.0  >;
                #declare point3 =  <    0,       -.1,        -.1  >;
                #include "SplineR.inc" 
            
                #local scl = (.15+(1-spline_clock)*.1); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb < .6, .6, .5 > }  }  
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
 
        //leg
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,         .1  >; 
                #declare point1 =  <   .3,       3.0,          0  >;
                #declare point2 =  <   .3,        .1,        1.2  >;
                #declare point3 =  <    0,       -.1,        -.1  >;
                #include "SplineR.inc" 
            
                #local scl = (.25+(1-spline_clock)*.2); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb < .1, .1, .1 > }  }  
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
 
        //leg
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,         .05  >; 
                #declare point1 =  <  -.3,       3.0,           0  >;
                #declare point2 =  <  -.3,        .1,        -1.2  >;
                #declare point3 =  <    0,       -.1,         .05  >;
                #include "SplineR.inc" 
            
                #local scl = (.25+(1-spline_clock)*.2); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb < .1, .1, .1 > }   } 
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
            
        //foot
        sphere { 0, 1, 1 scale < .4, .3, .8 > translate <  .3,        0,          1.1  > texture { pigment {rgb < .1, .1, .1 > }} } 
        sphere { 0, 1, 1 scale < .4, .3, .8 > translate < -.3,        0,         -1.3  > texture { pigment {rgb < .1, .1, .1 > }} }
       
}//end blob  
    //bag
        cone { (y*0) 1 (y*1) 0 scale < .4, 1,  .7 > translate <  .7,       1.4,          0  > texture { pigment {rgb < .7, .5, .1 > } }} 
}//end union  


#declare person[3] =
blob { threshold .4
        
        sphere { 0, 1, 1 scale < .5, 1, .8 >*.8 rotate < 10, 0, 0 > translate < 0, 5.6, 0 > texture { pigment { rgb < .96, .80, .69 >*2 } }} //head 
        
        //torso
        #declare spline_smoothness =  10;
        #declare spline_smoothness = (1 / spline_smoothness);  
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,        -.1  >; 
                #declare point1 =  <    0,       4.3,          0  >;
                #declare point2 =  <    0,       3.0,          0  >;
                #declare point3 =  <    0,       -.1,         .1  >;
                #include "SplineR.inc" 
            
                #if ( spline_clock < .5 ) #local scl = (.5+(1-spline_clock)*.5); #else #local scl = (.5+spline_clock*.5); #end
    
                sphere {<0,0,0>, 1, 1 
                        scale < scl, 1, 1 >
                        texture { pigment { rgb < .7, .7, .5 > } }    
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
        
        //arm
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,        -.1  >; 
                #declare point1 =  <   .7,       4.5,          0  >;
                #declare point2 =  <   .6,       2.8,        -.4  >;
                #declare point3 =  <    0,       -.1,        -.1  >;
                #include "SplineR.inc" 
            
                #local scl = (.25+(1-spline_clock)*.2); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb < .7, .7, .5 > } }   
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
  
        //arm
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,        -.1  >; 
                #declare point1 =  <  -.7,       4.5,          0  >;
                #declare point2 =  <  -.6,       2.9,        -.3  >;
                #declare point3 =  <    0,       -.1,        -.1  >;
                #include "SplineR.inc" 
            
                #local scl = (.25+(1-spline_clock)*.2); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb < .7, .7, .5 > } }   
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
 
        //leg
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,         .1  >; 
                #declare point1 =  <   .4,       3.0,          0  >;
                #declare point2 =  <   .3,        .2,         .3  >;
                #declare point3 =  <    0,       -.1,         .1  >;
                #include "SplineR.inc" 
            
                #local scl = (.30+(1-spline_clock)*.3); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb < .1, .1, .1 > } }    
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
 
        //leg
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,         .05  >; 
                #declare point1 =  <  -.4,       3.0,          0  >;
                #declare point2 =  <  -.3,        .2,         .1  >;
                #declare point3 =  <    0,       -.1,         .05  >;
                #include "SplineR.inc" 
            
                #local scl = (.30+(1-spline_clock)*.3); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb < .1, .1, .1 > }  }  
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
            
        //foot
        sphere { 0, 1, 1 scale < .3, .2, .8 > translate <  .4,        .2,         .3  > texture { pigment { rgb < .1, .1, .1 > } } }
        sphere { 0, 1, 1 scale < .3, .2, .8 > translate < -.4,        .2,         .1  > texture { pigment { rgb < .1, .1, .1 > } } }
 
}//end blob 
 


#declare person[4] =
blob { threshold .3
        sphere { 0, 1, 1 scale < .4, .1, .4 >*.8 rotate < 10, 0, 0 > translate < 0, 5.8, 0 > texture { pigment { rgb < .6, .4, .1 >  } }} //head 
        
        sphere { 0, 1, 1 scale < .5, 1, .8 >*.8 rotate < 10, 0, 0 > translate < 0, 5.5, 0 > texture { pigment { rgb < .96, .80, .69 >*1.2 } }} //head 
        
        //torso
        #declare spline_smoothness =  10;
        #declare spline_smoothness = (1 / spline_smoothness);  
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,        -.1  >; 
                #declare point1 =  <    0,       4.3,          0  >;
                #declare point2 =  <    0,       3.0,          0  >;
                #declare point3 =  <    0,       -.1,         .1  >;
                #include "SplineR.inc" 
            
                #if ( spline_clock < .5 ) #local scl = (.5+spline_clock*.5); #else #local scl = (.5+(1-spline_clock)*.5); #end
    
                sphere {<0,0,0>, 1, 1 
                        scale < scl, 1, 1 >
                        texture { pigment { rgb < .3, .7, .8 > } }    
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
        
        //arm
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,        -.1  >; 
                #declare point1 =  <   .4,       4.5,          0  >;
                #declare point2 =  <   .5,       2.8,         .4  >;
                #declare point3 =  <    0,       -.1,        -.1  >;
                #include "SplineR.inc" 
            
                #local scl = (.25+(1-spline_clock)*.2); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb < .7, .7, .5 > } }   
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
  
        //arm
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,        -.1  >; 
                #declare point1 =  <  -.4,       4.5,          0  >;
                #declare point2 =  <  -.5,       2.9,        -.3  >;
                #declare point3 =  <    0,       -.1,        -.1  >;
                #include "SplineR.inc" 
            
                #local scl = (.25+(1-spline_clock)*.2); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb < .7, .7, .5 > } }   
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
 
        //leg
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,         .1  >; 
                #declare point1 =  <   .3,       3.0,          0  >;
                #declare point2 =  <   .2,        .2,         .3  >;
                #declare point3 =  <    0,       -.1,         .1  >;
                #include "SplineR.inc" 
            
                #local scl = (.30+(1-spline_clock)*.3); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb < .7, .1, .1 > } }    
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
 
        //leg
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,         .05  >; 
                #declare point1 =  <  -.3,       3.0,          0  >;
                #declare point2 =  <  -.2,        .2,         .1  >;
                #declare point3 =  <    0,       -.1,         .05  >;
                #include "SplineR.inc" 
            
                #local scl = (.30+(1-spline_clock)*.3); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb < .7 , .1, .1 > }  }  
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
            
        //foot
         
 
}//end blob 
                                                    
                                                                                               
                                                    
#macro p1 ( top, legs, hair, amp )  
blob { threshold .3 

        
        sphere { 0, 1, 1 scale < .5, 1, .8 >*.9  translate < 0, 5.6, .02 >   texture { pigment { rgb hair*.5  } }} //head 
        
        sphere { 0, 1, 1 scale < .5, 1, .8 >*.8    translate < 0, 5.5, 0 > texture { pigment { rgb < .96, .80, .69 >*amp } }} //head 
        
        //torso
        #declare spline_smoothness =  10;
        #declare spline_smoothness = (1 / spline_smoothness);  
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,        -.1  >; 
                #declare point1 =  <    0,       4.3,          0  >;
                #declare point2 =  <    0,       3.0,          0  >;
                #declare point3 =  <    0,       -.1,         .1  >;
                #include "SplineR.inc" 
            
                #if ( spline_clock < .5 ) #local scl = (.5+spline_clock*.5); #else #local scl = (.5+(1-spline_clock)*.5); #end
    
                sphere {<0,0,0>, 1, 1 
                        scale < scl, 1, 1 >
                        texture { pigment { rgb top*amp } }    
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
        
        //arm
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,        -.1  >; 
                #declare point1 =  <   .4,       4.5,          0  >;
                #declare point2 =  <   .5,       2.8,         .4  >;
                #declare point3 =  <    0,       -.1,        -.1  >;
                #include "SplineR.inc" 
            
                #local scl = (.25+(1-spline_clock)*.2); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb top*amp } }   
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
  
        //arm
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,        -.1  >; 
                #declare point1 =  <  -.4,       4.5,          0  >;
                #declare point2 =  <  -.5,       2.9,        -.3  >;
                #declare point3 =  <    0,       -.1,        -.1  >;
                #include "SplineR.inc" 
            
                #local scl = (.25+(1-spline_clock)*.2); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb top*amp  } }   
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
 
        //leg
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,         .1  >; 
                #declare point1 =  <   .3,       3.0,          0  >;
                #declare point2 =  <   .2,        .2,         .3  >;
                #declare point3 =  <    0,       -.1,         .1  >;
                #include "SplineR.inc" 
            
                #local scl = (.30+(1-spline_clock)*.3); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb legs } }    
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
 
        //leg
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,         .05  >; 
                #declare point1 =  <  -.3,       3.0,          0  >;
                #declare point2 =  <  -.2,        .2,         .1  >;
                #declare point3 =  <    0,       -.1,         .05  >;
                #include "SplineR.inc" 
            
                #local scl = (.30+(1-spline_clock)*.3); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb legs }  }  
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
            
        //foot
         
 
}//end blob 
 

#end//end macro 




#macro p2 ( top, legs, hair, amp ) 
blob { threshold .3
       
        sphere { 0, 1, 1 scale < .5, .5, .7 >*.9  translate < 0, 5.7, .02 >    texture { pigment { rgb hair*.5  } }} //head 
     
        sphere { 0, 1, 1 scale < .5, .9, .7 >*.9  translate < 0, 5.4, 0 > texture { pigment { rgb < .96, .80, .69 >*amp} } }//head 
        #declare spline_smoothness =  15;
        #declare spline_smoothness = (1 / spline_smoothness);  
        //torso
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,        -.1  >; 
                #declare point1 =  <    0,       4.2,          0  >;
                #declare point2 =  <    0,       1.5,          0  >;
                #declare point3 =  <    0,       -.1,         .1  >;
                #include "SplineR.inc" 
            
                #local scl = (.5+spline_clock*.5); 
                                                                                                   
                sphere {<0,0,0>, 1, 1 
                        scale < scl, 1, 1 >
                        texture { pigment { rgb  top*amp  }  }  
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
        
        //arm
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,        -.1  >; 
                #declare point1 =  <   .5,       4.5,          0  >;
                #declare point2 =  <   .5,       3.2,          0  >;
                #declare point3 =  <    0,       -.1,        -.1  >;
                #include "SplineR.inc" 
            
                #local scl = (.15+(1-spline_clock)*.1); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb top*amp }  }  
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
  
        //arm
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,        -.1  >; 
                #declare point1 =  <  -.5,       4.5,          0  >;
                #declare point2 =  <  -.5,       2.7,        -.0  >;
                #declare point3 =  <    0,       -.1,        -.1  >;
                #include "SplineR.inc" 
            
                #local scl = (.15+(1-spline_clock)*.1); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb top*amp }  }  
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
 
        //leg
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,         .1  >; 
                #declare point1 =  <   .3,       3.0,          0  >;
                #declare point2 =  <   .3,        .1,        1.2  >;
                #declare point3 =  <    0,       -.1,        -.1  >;
                #include "SplineR.inc" 
            
                #local scl = (.25+(1-spline_clock)*.2); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb legs }  }  
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
 
        //leg
        #declare spline_clock = .05;
        #while (spline_clock <= 1)        
                   
                #declare point0 =  <    0,        .1,         .05  >; 
                #declare point1 =  <  -.3,       3.0,           0  >;
                #declare point2 =  <  -.3,        .1,        -1.2  >;
                #declare point3 =  <    0,       -.1,         .05  >;
                #include "SplineR.inc" 
            
                #local scl = (.25+(1-spline_clock)*.2); 
    
                sphere {<0,0,0>, 1, 1 
                        scale  scl
                        texture { pigment { rgb legs }   } 
                        translate spline_pos
                       }
                
                #declare spline_clock = (spline_clock + spline_smoothness); 
        #end
            
        //foot
        sphere { 0, 1, 1 scale < .4, .3, .8 > translate <  .3,        0,          1.1  > texture { pigment {rgb < .1, .1, .1 > }} } 
        sphere { 0, 1, 1 scale < .4, .3, .8 > translate < -.3,        0,         -1.3  > texture { pigment {rgb < .1, .1, .1 > }} }
       
}//end blob  
 
 
#end//end macro












 