// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc:ant_farm
// Date: 03/22/00
// Auth: Teri
//

#version 3.1;

#include "colors.inc"
#include "ant.inc"










// >>> pigEarth (from file "exgrass1.pov", line 33) <<<

// Constants from file "colors.inc"
#declare Tan = color red 0.858824 green 0.576471 blue 0.439216;

// Constants from file "exgrass1.pov"
#declare Green1 = rgb<230,170,50>/255;

#declare pigEarth1 = pigment {
  spotted
  color_map {
    [0 color Tan*0.93]
    [0.6 color Tan*0.3]
    
    [1 color Tan*0.84]
  }
}   
// >>> Brown_Agate (from file "ptexture.inc", line 95) <<<
#declare Brown_Agate = pigment {
  agate
  color_map {
    [0.0 0.5 color red 1.0 green 1.0 blue 1.0
    color red 0.9 green 0.7 blue 0.6]
    [0.5 0.6 color red 0.9 green 0.7 blue 0.6
    color red 0.9 green 0.7 blue 0.4]
    [0.6 1.001 color red 0.9 green 0.7 blue 0.4
    color red 0.7 green 0.4 blue 0.2]
  }
}


// >>> Plexiglas (from file "povlab.inc", line 499) <<<
#declare Plexiglas1 = texture {
  pigment {
    color rgbf <1, 1, 1, 1.0> 
  }
  finish {
    ambient 0
    diffuse 0
    reflection 0.05
    //refraction 0.85
    ior 1.5
    //phong 0.3
    //phong_size 60
  }
}

// >>> Cork (from file "textures.inc", line 1210) <<<
#declare Cork = texture {
  pigment {
    granite
    color_map {
      [0.00 rgb <0.93, 0.71, 0.532>]
      [0.60 rgb <0.98, 0.81, 0.60>]
      [0.60 rgb <0.50, 0.30, 0.20>]
      [0.65 rgb <0.50, 0.30, 0.20>]
      [0.65 rgb <0.80, 0.53, 0.46>]
      [1.00 rgb <0.85, 0.75, 0.35>]
    }
  }
  finish {
    specular 0.1 
    roughness 0.5 
  }
  scale 0.25 
}  

// >>> Berg_Tex (from file "textur.inc", line 64) <<<

// Constants from file "colors.inc"
#declare ForestGreen = color red 0.137255 green 0.556863 blue 0.137255;
#declare DarkGreen = color red 0.184314 green 0.309804 blue 0.184314;
#declare White = rgb 1;
#declare Gray35 = White*0.35;
#declare Gray50 = White*0.50;

#declare Berg_Tex = texture {
  pigment {
    gradient y
    color_map {
      [ 0 color ForestGreen ]
      [ 0.5 color DarkGreen]
      [ 0.7 color Gray35 ]
      [ 1 color Gray50 ]
    }
    turbulence 0.1
    scale 1500
  }
  finish {
    ambient 0.7
  }
}
         
         
         // >>> Green_Dull (from file "povlab.inc", line 1115) <<<
#declare Green_Dull = texture {
  pigment {
    color rgb <0, 1, 0> 
  }
  finish {
    phong 1.0 
  }
}

                                              
                                              
                                         
// ----------------------------------------  
 /*
camera
{
  location  <0.0, 0.5, -4.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}

 */


//------------------------------

      // 
#declare dirt=
height_field{gif "ant_farm.gif" smooth water_level 0.4 texture{ Cork scale 0.00002 }scale<1.6,0.2,1>translate<-0.5,-0.5,-0.5>}


  



#declare green_frame=union{ 
box{<0,0,0><1.8,0.2,0.1>texture{Green_Dull}} 
box{<0,0,0><1.8,0.2,0.1>texture{Green_Dull}translate<0,0,1.35>}  
box{<0,0,0><0.1,0.2,1.25>  texture{Green_Dull}translate<0,0,0.1>}    
box{<0,0,0><0.1,0.2,1.25> texture{Green_Dull}translate<1.7,0,0.1>} 
 }

#declare farm=union{
object{dirt}
object{green_frame translate<-0.6,-0.475,-0.6>}
//box{<0,0,0><1.8,0.01,1.1>texture{Plexiglas1 }translate<-0.6,-0.45,-0.25>}
//box{<0,0,0><1.8,0.01,1.1>texture{Plexiglas1 } translate<-0.6,-0.28,-0.37>}
} 

#declare ant_farm=union{
object{farm rotate<-90,0,0>} 
object{ant scale 0.01 translate<0.05,0.055,0.35>}   
object{ant scale 0.01 translate<0.2,0.05,0.35>}
object{ant scale 0.01 rotate<0,180,-25>translate<0.77,0.36,0.35>} 
object{ant scale 0.01 rotate<0,180,0>translate<0.07,0.185,0.35>}
object{ant scale 0.01 rotate<0,0,5>translate<-0.3,0.27,0.35>} 
object{ant scale 0.01 translate<0.9,0.15,0.35>}  
object{ant scale 0.01 rotate<0,180,10>translate<0.24,0.125,0.35>}  
object{ant scale 0.01 rotate<0,180,-20>translate<0.8,0.275,0.35>}
object{ant scale 0.01 rotate<0,0,-20>translate<-0.4,0.045,0.35>} 
object{ant scale 0.01 rotate<0,0,-10>translate<0.1,-0.115,0.35>} 
object{ant scale 0.01 rotate<0,180,15>translate<1,-0.1675,0.35>}  
object{ant scale 0.01 rotate<0,0,20>translate<0.3,-0.35,0.35>}
object{ant scale 0.01 rotate<0,180,-5>translate<0.25,-0.465,0.35>}
object{ant scale 0.01 rotate<0,0,15>translate<0,-0.465,0.35>} 
object{ant scale 0.01 translate<0.175,0.38,0.35>}  //top ant 
}

//object{ant_farm}     
  

