// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc:camera apartment object{camera_apart}
// Date: 03/15/00
// Auth: Teri
//

//#version 3.1

#include "colors.inc"
#include "desk.inc" 
#include "bookshelves.inc" 
#include "bookend.inc"  
#include "desk_chair.inc"  
#include "venetian_blinds.inc" 
#include "loveseat.inc"
#include "chair.inc"
#include "coffee_table.inc" 
#include "ant_farm.inc"


//--------------------------------------
 // >>> Grass (from file "povlab.inc", line 2234) <<<
#declare Grass = texture {
  pigment {
    granite
    turbulence 0.7
    color_map {
      [0.00 0.07 color rgbf <0.7743, 0.3353, 0.5701, 0.98>
      color rgbf <0.5210, 0.1044, 0.0333, 0.45>]
      [0.07 0.13 color rgbf <0.5210, 0.1044, 0.0333, 0.45>
      color rgbf <0.3663, 0.5682, 0.0687, 0.82>]
      [0.13 0.31 color rgbf <0.3663, 0.5682, 0.0687, 0.82>
      color rgbf <0.0887, 0.9886, 0.4438, 0.01>]
      [0.31 0.39 color rgbf <0.0887, 0.9886, 0.4438, 0.01>
      color rgbf <0.1308, 0.9083, 0.5524, 0.74>]
      [0.39 0.55 color rgbf <0.1308, 0.9083, 0.5524, 0.74>
      color rgbf <0.4840, 0.3945, 0.7343, 0.69>]
      [0.55 1.00 color rgbf <0.4840, 0.3945, 0.7343, 0.69>
      color rgbf <0.1755, 0.5095, 0.4480, 0.43>]
    }
  }
  finish {
    phong 0.66 phong_size 81
  }
  scale <0.98 0.87 0.81>
}

 

// >>> T_Gold_5A (from file "golds.inc", line 194) <<<

// Constants from file "golds.inc"
#declare GoldBase = <1.00, 0.875, 0.575>;
#declare CVect5 = GoldBase - <0.00, 0.00, 0.00>;
#declare P_Gold5 = rgb CVect5;
#declare CVect1 = GoldBase - <0.00, 0.20, 0.40>;
#declare P_Gold1 = rgb CVect1;
#declare R_GoldA = P_Gold1 * 0.30 + 0.25;
#declare A_GoldA = P_Gold1 * 0.12 + 0.1;
#declare D_GoldA = 1-(((R_GoldA.red+R_GoldA.green+R_GoldA.blue)/3)
+ ((A_GoldA.red+A_GoldA.green+A_GoldA.blue)/3));
#declare D_GoldA = max(D_GoldA, 0);
#declare M = 1;
#declare F_MetalA = finish {
  brilliance 2
  diffuse D_GoldA
  ambient A_GoldA
  reflection R_GoldA
  metallic M
  specular 0.20
  roughness 1/20
}

#declare T_Gold_5A = texture {
  pigment {
    P_Gold5 
  }
  finish {
    F_MetalA 
  }
}             

// >>> Black_Dull (from file "povlab.inc", line 1130) <<<
#declare Black_Dull = texture {
  pigment {
    color rgb <0, 0, 0> 
  }
  finish {
    phong 0.2 
  }
}
          
// >>> TuerTex (from file "textur.inc", line 309) <<<

// Constants from file "colors.inc"
#declare White = rgb 1;

#declare TuerTex = texture {
  pigment {
    color White
  }
  finish {
    specular 0.75 roughness 0.01
  }
}

// >>> NurseryGlass (from file "sjvtextr.inc", line 49) <<<

// Constants from file "colors.inc"
#declare White = rgb 1;

// Constants from file "textures.inc"
#declare Glass_Finish = finish {
  specular 1
  roughness 0.001
  ambient 0
  diffuse 0
  reflection 0.01
  ior 1.5
}

#declare NurseryGlass = texture {
  pigment {
    color White filter 0.95 
  }
  finish {
    Glass_Finish 
  }
}    

// >>> Blue_Dull (from file "povlab.inc", line 1120) <<<
#declare Blue_Dull = texture {
  pigment {
    color rgb <0, 0, 1> 
  }
  finish {
    phong 0.2 
  }
}


//----------------------------------------------

 

// ----------------------------------------   





#declare trim=difference{
box{<0,0,0><1.0,0.3,0.25>texture{Blue_Dull }} 
torus{0.5,0.2 texture{Blue_Dull } scale<1,12,1> rotate<0,0,-90>translate<-4,0.125,0.5>}}
   
#declare blue_sash=union{
object{trim scale<6,1,1>}  
object{trim scale<6,1,1>rotate<0,0,-180> translate<6,4,0>}  
object{trim scale<4,1,1>rotate<0,0,-90>translate<0,4,0>}
object{trim scale<4,1,1>rotate<0,0,90>translate<6,0,0>}
//box{<0,0,0><6.2,4.2,0.01>texture{NurseryGlass}translate<-0.1,-0.1,0.05>}
}

#declare inside_wall=union{
object{trim scale<30,1,1>translate<0,3.85,-0.05>} 
box{<0,0,0><30,8,0.05> pigment{color rgb <0.000000, 0.750000, 0.000000>}translate<0,8,0>} 
box{<0,0,0><30,4,0.05> texture{Grass}}}
 
#declare front_wall=difference{
object{inside_wall}
box{<0,0,0><6,4,0.5> pigment{color rgb 0} translate<1,4,-0.25>}   
box{<0,0,0><6,4,0.5> pigment{color rgb 0} translate<23,4,-0.25>} 
box{<0,0,0><12,8,0.5> pigment{color rgb 0} translate<9,1,-0.25>} } 

#declare front_wall1=union{ 
object{front_wall}
object{blue_sash translate<1,4,-0.175>}}

#declare arch_wall=difference{
object{inside_wall}
cylinder{<0,0,0><0,0,2>, 2.5 pigment{color rgb <0.000000, 0.750000, 0.000000>}translate<12.5,7,-1.0>}
box{<0,0,0><5,6,2> pigment{color rgb <0.000000, 0.750000, 0.000000>}translate<10,1,-1.0>}}

#declare blue_floor= 
box{<0,0,0><30,0.05,30>texture{pigment{color rgb <0.000000, 0.000000, 0.750000>}  
normal{
wrinkles 0.5 }
}}  

#declare ceiling=
box{<0,0,0><30,0.01,30>pigment{color rgb <0.000000, 0.750000, 0.000000>}}
      
#declare camera_apart=union{
object{inside_wall rotate<0,-90,0>translate<0.05,0,-10>}
object{front_wall1 translate<0,0,20>}  
object{arch_wall rotate<0,180,0>translate<30,0,0>}
object{blue_floor translate<0,1,-10>}   
object{arch_wall rotate<0,-90,0>translate<21.5,0,-10> }
object{inside_wall rotate<0,90,0> translate<30,0,20>} 
object{inside_wall translate<0,0,-10>} 
object{ceiling translate<0,11.99,-10>}
}

//--------------LAMP--------------------    

 #declare lamp_bottom=difference{ 
sphere{<0,0,0>, 0.15 texture{T_Gold_5A} scale<1,0.35,1>translate<0,-.27,0>}  
box{<0,0,0><0.5,0.25,1> texture{Black_Dull}translate<-.25,-.55,-0.25>} }  

#declare bulb=union{
cone
{
  0.05*y,  0.075,
  0*y, 0.025
 texture{T_Gold_5A}
}   
cylinder{<0,0,0><0,0.15,0>, 0.075 texture{T_Gold_5A}translate<0,0.05,0>} 
cylinder{<0,0,0><0.1,0,0>, 0.01 texture{Black_Dull}translate<0.05,0.1,0>} 
cylinder{<0,0,0><0,0.075,0>, 0.075 texture{TuerTex}translate<0,0.2,0>}  
cone{ 0.2*y, 0.15, 0*y, 0.075 texture{TuerTex} translate<0,0.25,0>}
sphere{<0,0,0>, 0.15 texture{TuerTex}  translate<0,0.45,0>}}


#declare grass_lamp=union{
sphere{<0,0,0>, .25 texture{pigment{color rgb <0.000000, 0.750000, 0.000000>}}}
cylinder{<0,0,0><0,0.1,0>, 0.125 texture{T_Gold_5A} translate<0,-0.250,0>}
object{lamp_bottom }     
cylinder{<0,0,0><0,0.75,0>, 0.025 texture{T_Gold_5A}translate<0,-0.25,0>}   
object{bulb scale 0.75 translate<0,0.5,0>}
cylinder{<0,0,0><0,0.5,0>, 0.45  open  texture{Grass scale 0.25} translate<0,0.5,0> } 
cylinder{<0,0,0><0,0.5,0>, 0.44  open  pigment{color rgb <0.000000, 0.000000, 0.750000>}translate<0,0.5,0> }
torus{0.45, 0.01 texture{T_Gold_5A}  translate<0,0.5,0>}  
torus{0.45, 0.01 texture{T_Gold_5A}  translate<0,1,0>}    
}                                                         

//------------BOOKENDS------------------  

// >>> Cyan_Metalic (from file "povlab.inc", line 13335) <<<
#declare Cyan_Metalic = texture {
  finish {
    metallic
    ambient < 0.100, 0.100, 0.100 >
    diffuse 0.8
    brilliance 6.0
    reflection < 0.600, 0.600, 0.600 >
    phong 1.0
    phong_size 80
  }
  pigment {
    agate
    color_map {
      [ 0.000 rgb < 0.000, 0.000, 0.900 > ]
      [ 0.300 rgb < 0.000, 0.000, 0.800 > ]
      [ 0.300 rgb < 0.000, 0.000, 0.800 > ]
      [ 1.000 rgb < 0.000, 0.000, 0.400 > ]
    }
  }
}


#declare bookend1=difference{   
  object{bookend texture{Cyan_Metalic}scale 0.4}  
box{<0,0,0><1,1,1.5> texture{Cyan_Metalic}translate<0,-0.1,-0.5>} }


//------------BOOKS------------

#declare book1=union{ 
box{<0,0,0><0.25,1,0.025> texture{pigment{image_map{png "book1"}rotate<0,0,-90>translate<-0.35,0,0>}}}
box{<0,0,0><0.2,0.9,0.7>pigment{color rgb 1}translate<0.025,0.05,0.025>} 
box{<0,0,0><0.025,1,0.75>  pigment{color rgb<0,  0, 0.62>}}    
box{<0,0,0><0.025,1,0.75>  pigment{color rgb<0,  0, 0.62>}translate<0.25,0,0>}}

  
#declare book2=union{ 
box{<0,0,0><0.25,1,0.025> texture{pigment{image_map{png "book2"}rotate<0,0,-90>translate<-0.35,0,0>}}}
box{<0,0,0><0.2,0.9,0.7>pigment{color rgb 1}translate<0.025,0.05,0.025>} 
box{<0,0,0><0.025,1,0.75>  pigment{color rgb< 0.53,  0,  0>}}    
box{<0,0,0><0.025,1,0.75>  pigment{color rgb<0.53,0,0>}translate<0.25,0,0>}} 


#declare book3=union{ 
box{<0,0,0><0.25,1,0.025> texture{pigment{image_map{png "book3"}rotate<0,0,-90>translate<-0.4,0,0>}}}
box{<0,0,0><0.2,0.9,0.7>pigment{color rgb 1}translate<0.025,0.05,0.025>} 
box{<0,0,0><0.025,1,0.75>  pigment{color rgb<   0, 0.59, 0.59>}}    
box{<0,0,0><0.025,1,0.75>  pigment{color rgb<0,0.59,0.59>}translate<0.25,0,0>}}  


#declare book4=union{ 
box{<0,0,0><0.25,1,0.025> texture{pigment{image_map{png "book4"}rotate<0,0,-90>translate<-0.35,0,0>}}}
box{<0,0,0><0.2,0.9,0.7>pigment{color rgb 1}translate<0.025,0.05,0.025>} 
box{<0,0,0><0.025,1,0.75>  pigment{color rgb 0}}    
box{<0,0,0><0.025,1,0.75>  pigment{color rgb 0}translate<0.25,0,0>}}  


#declare book5=union{ 
box{<0,0,0><0.25,1,0.025> texture{pigment{image_map{png "book5"}rotate<0,0,-90>translate<-0.4,0,0>}}}
box{<0,0,0><0.2,0.9,0.7>pigment{color rgb 1}translate<0.025,0.05,0.025>} 
box{<0,0,0><0.025,1,0.75>  pigment{color rgb<  0.69, 0.53, 0.28>}}    
box{<0,0,0><0.025,1,0.75>  pigment{color rgb<  0.69, 0.53, 0.28>}translate<0.25,0,0>}} 

#declare book6=union{ 
box{<0,0,0><0.25,1,0.025> pigment{color rgb <0.730000, 0.230000, 0.710000>}}
box{<0,0,0><0.2,0.9,0.7>pigment{color rgb 1}translate<0.025,0.05,0.025>} 
box{<0,0,0><0.025,1,0.75>  pigment{color rgb <0.700000, 0.700000, 0.700000>}}    
box{<0,0,0><0.025,1,0.75>  pigment{color rgb <0.700000, 0.700000, 0.700000>}translate<0.225,0,0.025>}  
rotate<0,0,90>  }
                              
 
// >>> Brown_Agate (from file "ptexture.inc", line 95) <<<
#declare Brown_Agate = pigment {
  agate
  color_map {
    [0.0 0.5 color red 1.0 green 1.0 blue 1.0
    color red 0.9 green 0.7 blue 0.6]
    [0.5 0.6 color red 0.9 green 0.7 blue 0.6
    color red 0.9 green 0.7 blue 0.4]
    [0.6 1.001 color red 0.9 green 0.7 blue 0.4
    color red 0.7 green 0.4 blue 0.2]
  }
}
 


#declare book7=union{ 
box{<0,0,0><0.25,1,0.025> pigment{color rgb <0.870588, 0.721569, 0.529412>}}
box{<0,0,0><0.2,0.9,0.7>pigment{color rgb 1}translate<0.025,0.05,0.025>} 
box{<0,0,0><0.025,1,0.75>  pigment{Brown_Agate}}    
box{<0,0,0><0.025,1,0.75>  pigment{Brown_Agate}translate<0.225,0,0.025>}  
rotate<0,0,90>  } 
            

// >>> Granite9 (from file "pascal.inc", line 241) <<<
#declare Granite9 = pigment {
  bozo
  turbulence 0.5
  octaves 4
  lambda 6
  omega .55
  color_map {
    [ 0.00 color rgb < 0.235 0.035 0.027 > ]
    [ 0.12 color rgb < 0.545 0.255 0.184 > ]
    [ 0.43 color rgb < 0.816 0.537 0.027 > ]
    [ 0.63 color rgb < 1.000 1.000 0.588 > ]
    [ 0.91 color rgb < 0.839 0.604 0.071 > ]
  }
  scale < 3.8 , 1.8 , 2.1 >
  rotate < -25 , 0 , 0 > 
} 

// >>> eye_texture (from file "nosefly.inc", line 80) <<<

// Constants from file "colors.inc"
#declare Orange = color red 1 green 0.5 blue 0.0;

#declare eye_texture = texture {
  pigment {
    Orange 
  }
  finish {
    ambient 0.30
    diffuse 0.50
    brilliance 1.00
    phong 0.70
    phong_size 20.00
  }
}



#declare book8=union{ 
box{<0,0,0><0.25,1,0.025> pigment{Granite9}}
box{<0,0,0><0.2,0.9,0.7>pigment{color rgb 1}translate<0.025,0.05,0.025>} 
box{<0,0,0><0.025,1,0.75>  texture{eye_texture }}    
box{<0,0,0><0.025,1,0.75> texture{eye_texture }translate<0.225,0,0.025>}  
rotate<0,0,90>  } 

      

// >>> thorax_texture (from file "nosefly.inc", line 35) <<<

// Constants from file "colors.inc"
#declare VeryDarkBrown = color red 0.35 green 0.16 blue 0.14;

// Constants from file "nosefly.inc"
#declare Body_Color = color red 0.310 green 0.318 blue 0.231  ;

#declare thorax_texture = texture {
  pigment {
    granite
    color_map {
      [0.5 color VeryDarkBrown ]
      [1.0 color Body_Color ]
    }
    scale <0.5, 0.5, 0.5>
  }
  finish {
    ambient 0.30
    diffuse 0.50
    brilliance 1.00
    phong 0.70
    phong_size 20.00
  }
}

    
// >>> T4 (from file "tiles.inc", line 80) <<<

// Constants from file "tiles.inc"
#declare C4 = color rgb <1/4, 0, 0>   ;
#declare Tfinish = finish {
  specular 1.0
  roughness 0.01
  diffuse 0.95
  ambient 0.05
}

#declare T4 = texture {
  pigment {
    color C4 
  }
  finish {
    Tfinish 
  }
}


#declare book9=union{ 
box{<0,0,0><0.25,1,0.025> texture{ T4}}
box{<0,0,0><0.2,0.9,0.7>pigment{color rgb 1}translate<0.025,0.05,0.025>} 
box{<0,0,0><0.025,1,0.75>  texture{thorax_texture }}    
box{<0,0,0><0.025,1,0.75> texture{thorax_texture}translate<0.225,0,0.025>}  
rotate<0,0,90>  } 

object{book9}    

//----------------LETTER-------------------

#declare letter=
box{<0,0,0><1,1,0.01> texture{pigment{image_map{png "blank_letter.png" once}}}scale<1,1.25,1>} 

//-------------PENCIL---------------
// >>> Pine_WoodX (from file "trhmtex.inc", line 160) <<<
#declare Pine_WoodX = texture {
  pigment {
    granite
    turbulence 0.2
    color_map {
      [0.0 0.8 color red 1.0 green 0.7875 blue 0.37
      color red 1.0 green 0.7875 blue 0.57]
      [0.8 1.01 color red 0.55 green 0.4 blue 0.066
      color red 0.54 green 0.3 blue 0.033]
    }
  }
  scale <10, 0.2, 0.3>
  translate <10, 10, 10>
  rotate <5, -2, 0>
}
        
// >>> Psychedelik_1 (from file "povlab.inc", line 2914) <<<
#declare Psychedelik_1 = texture {
  pigment {
    wood
    turbulence 1.0
    color_map {
      [0 0.09 color rgb <0.9138, 0.3142, 0.3359>
      color rgb <0.9138, 0.3142, 0.3359>]
      [0.09 0.86 color rgb <0.2600, 0.8661, 0.4363>
      color rgb <0.3114, 0.7216, 0.6458>]
      [0.86 0.00 color rgb <0.5377, 0.2882, 0.5914>
      color rgb <0.5984, 0.8569, 0.8621>]
      [0.00 1.001 color rgb <0.5984, 0.8569, 0.8621>
      color rgb <0.2072, 0.0735, 0.4433>]
    }
  }
  finish {
    phong 1.0 
ambient 0.4
  }
  scale <2.0 1.5 1.0>
  rotate <272 31 39>
}

// >>> Copper_Texture (from file "textures.inc", line 921) <<<

// Constants from file "textures.inc"
#declare Metal = finish {
  metallic
  ambient 0.2
  diffuse 0.7
  brilliance 6
  reflection 0.25
  phong 0.75
  phong_size 80
}

#declare Copper_Texture = texture {
  pigment {
    rgb <0.72, 0.45, 0.20>
  }
  finish {
    Metal 
  }
}


#declare pencil=union{
sphere{<0,0,0>, 0.01texture{BLACK_BOX }} 
cylinder{<0,0,0><0.1,0,0>, 0.01    texture{BLACK_BOX }}    
cone{0*x 0.01, 0.2*x 0.05 texture{Pine_WoodX }translate<0.05,0,0>} 
cylinder{<0,0,0><1.25,0,0>, 0.05  texture{Psychedelik_1 scale 0.05}translate<0.25,0,0>} 
cylinder{<0,0,0><0.15,0,0>, 0.05  texture{ Copper_Texture}translate<1.5,0,0>} 
torus{0.05025, 0.01 texture{Copper_Texture}rotate<0,0,-90>translate<1.52,0,0>} 
torus{0.05025, 0.01 texture{Copper_Texture}rotate<0,0,-90>translate<1.545,0,0>}
torus{0.05025, 0.01 texture{Copper_Texture}rotate<0,0,-90>translate<1.57,0,0>} 
torus{0.05025, 0.01 texture{Copper_Texture}rotate<0,0,-90>translate<1.595,0,0>}
cylinder{<0,0,0><0.05,0,0>,0.05 pigment{color rgb <1.000000, 0.300000, 0.300000>}translate<1.65,0,0>} 
sphere{<0,0,0>, 0.05    pigment{color rgb <1.000000, 0.300000, 0.300000>}translate<1.7,0,0>}}  

//-----------------CARD-----------------
#declare card=
box{<0,0,0><1,1,0.01>texture{pigment{image_map{png "card.png"}}}scale<0.5,0.25,1>}

//------------LIGHT----------------
// >>> Green_Glass (from file "povlab.inc", line 527) <<<
#declare Green_Glass = texture {
  pigment {
    color rgbf <0.8, 1, 0.95, 0.9> 
  }
  finish {
    ambient 0.1
    diffuse 0.1
    specular 0.8
    reflection 0.1
    //refraction 0.9
    ior 1.45 
    roughness 0.0003
    phong 1
    phong_size 400
  }
}

#declare overhead_light=
box{<0,0,0><1,0.25,4> hollow texture{Green_Glass}}   




 // ----------------------------------------
/*
camera
{
  location  <4.0, 4.75, 15.25>
  direction 1.5*z
  right     4/3*x
  look_at   <4.0, 4.5,  30>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}*/
/*
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <12, 5.75, 1.25>
}*/

// An area light (creates soft shadows)
// WARNING: This special light can significantly slow down rendering times! 
/*
light_source
{
  0*x // light's position (translated below)
  color rgb 1.0  // light's color
  // <widthVector> <heightVector> nLightsWide mLightsHigh
  area_light
  <3, 0, 0> <0, 0, 3> // lights spread out across this distance (x * z)
  2, 2                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 1          // 0,1,2,3... 
  jitter              // adds random softening of light
  translate<35,95.75,94>   // <x y z> position of light 
looks_like {overhead_light}
}


  light_source
{
  0*x // light's position (translated below)
  color red 10  green 10  blue 10  // light's color
  translate <330, 6000, -30>
}
   */

//-----------------FINAL SCENE------------------  

  
#declare final_cam_apart=union{                                             
object{camera_apart} 
object{desk translate<1.5,3.75,16.95>}
object{short_bookshelf rotate<0,-90,0>translate<8.5,1,16>} 
//object{grass_lamp translate<5.5,4.25,19.25>}   
object{bookend1 translate<1.85,3.95,19.25>}
object{book3 translate<1.85,3.95,18.95>}     
object{book1 scale<0.8,1.25,1>translate<2.15,3.95,18.95>}
object{book5 scale<0.65,1,1>translate<2.4,3.95,18.95>}
object{book2 translate<2.6,3.95,18.95>} 
object{bookend1 rotate<0,-180,0>translate<2.95,3.95,19.25>} 
object{book6 scale <2,1,1.5>rotate<0,90,0> translate<7.25,3.95,18.5>} 
object{book8 scale <1.5,1.25,1>rotate<0,90,0> translate<7.5,4.25,18.45>}
object{book7 rotate<0,90,0> translate<7.375,3.95, 17>}
object{book9 scale 0.8 rotate<0,90,0>translate<7.5,4.25,17.1>}
object{letter rotate<90,-45,0> translate<2.75,3.975,17>}  
object{pencil  scale 0.5 rotate<0,-47,0>translate<2.5,4,17.55>}   
//object{desk_chair  rotate<0,-150,0>translate<2.5,4,13.25>} 
//object{card rotate<0,35,0>translate<4.25,4,17.2>}                        
object{venetian_blinds scale<1.85,1,1>translate<0.85,8,19.7>}  
object{short_bookshelf rotate<0,-90,0>translate<2,1,4>} 
object{short_bookshelf rotate<0,-90,0>translate<2,1,8.5>}  
object{loveseat scale 3.5 rotate<0,-180,0>translate<9,3,0>}
object{chair scale 3 rotate<0,90,0> translate<14,3,4>}  
object{table scale<1,2,2>translate<2,3,0.5>} 
object{grass_lamp scale 2 translate<3,3.5,1.25>}     
object{table scale<1,2,2>translate<11,3,0.5>}
object{grass_lamp scale 2 translate<12,3.5,1.25>}    
object{table scale<2,1,4>translate<4.5,2,3>}
object{ant_farm rotate<0,37,0>translate<4.250,4.5,17.25>}}  
//object{final_cam_apart}  



