// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

//#version 3.1

#include "colors.inc" 

#include "apartment2.inc"
#include "camera_apart.inc"


// >>> Sunny_Cloud_Sky (from file "povlab.inc", line 5211) <<<
#declare Sunny_Cloud_Sky = texture {
  pigment {
    bozo
    turbulence 0.5
    octaves 3 
    lambda 6 
    color_map {
      [0.0 0.1 color rgb <2/3, 2/3, 1>
      color rgb <2/3, 2/3, 1> ]
      [1.0 color rgb <1, 1, 1,> ]
    }
  }
  finish {
    ambient 1 diffuse 0 
  }
  scale <0.1666,0.1666,0.1666> 
}


// ----------------------------------------
camera
{
  location  <34.0, 88.9, 115.25>
  direction 1.5*z
  right     4/3*x
  look_at   <34.0, 88.5,  130.0>
}



light_source
{
  0*x // light's position (translated below)
  color red 9  green 8  blue 8  // light's color
  translate <330, 5000, 200>
}   

light_source
{
  0*x // light's position (translated below)
  color rgb 1  // light's color
  // <widthVector> <heightVector> nLightsWide mLightsHigh
  area_light
  <1, 0, 0> <0, 0, 5> // lights spread out across this distance (x * z)
  1, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 1          // 0,1,2,3... 
  jitter              // adds random softening of light
  translate<30.75,89,115>   // <x y z> position of light 
  looks_like {overhead_light}
} 
 
// ----------------------------------------    

sphere{<0,0,0>, 50000 hollow texture{Sunny_Cloud_Sky scale 20000} scale<3,0.25,3>}  
box{<0,0,0><10000,1,10000> pigment{color rgb 0.05}translate<-3000,0,0>} 

object{final_cam_apart translate<30,84,100>} 



object{apartment translate<-100,0.5,300>}    
object{apartment translate<-100,25.5,600>}
 
object{apartment translate<125,50.5,1200>}    
object{apartment translate<100,0.5,1600>} 

//object{apartment translate<150,25.5,300>}
object{apartment translate<150,0.5,400>}      
object{apartment translate<150,25.5,800>}


 
 
                                               
                                               
                                               



