// Persistence of Vision Ray Tracer Scene Description File
// File: bldg1.pov
// Vers: 3.1g.wmp.0.3
// Desc: beta for cities irtc entry
// Date: 22/mar/00
// Auth: Tom Melly, tom@tomandlu.f9.co.uk
//
// bldgs should be approx 2 units wide

#version unofficial MegaPov 0.4;
#declare Rand2 = seed(28563);

// extrude a closed 2-D shape along an axis
#declare roof_object =
prism {
  conic_sweep
  0,        // height 1
  1,        // height 2
  5,          // number of points
  <-2,-2>,<2,-2>,<2,2>,<-2,2>,<-2,-2>
  pigment{RandPig2}
  finish{ambient 0.35}
  normal{wrinkles scale 0.01}
  rotate z*180
  translate y*1
  scale <1,3,1>
}

/*
#declare roof_tile_object =
difference{
  cylinder{<0,0,0>,<0,0.05,0>,0.4}
  box{<-0.5,0.0,-0.5>,<0.5,0.1,0.5> rotate x*10 translate y*0.05}
  pigment{RandPig2}
  normal{bumps scale 0.01}
  finish{ambient 0.2}
}

// tile a roof

#declare roof_tiles =
union{
  #declare y_shift = 0.02;
  #declare x_count = -1.1;
  #while (x_count <= 1.1)
    #declare z_count = -1.1;
    #while (z_count <= 1.1)
      #declare norm_reg = <0,0,0>;
      #declare tile_pos = trace(roof_object, <x_count, 100, z_count>, <x_count, -100, z_count>, norm_reg);
      #if (norm_reg.x != 0 | norm_reg.y != 0 | norm_reg.z != 0)
        object{roof_tile_object Reorient(y, norm_reg) translate tile_pos translate y*y_shift}
        #declare y_shift = - y_shift;
      #end
      #declare z_count = z_count + 0.2;
    #end
    #declare x_count = x_count + 0.2;
  #end
}
*/

#declare windows =
union{
  #declare x_win = 0;
  #while (x_win <= 1)
    #declare y_win = 0;
    #while (y_win <= 0.5)
      #if (rand(Rand2) > 0.25)
        box{<-0.5 + x_win, 0 + y_win, 5>,<-0.6 + x_win, 0.005 + y_win, -5>} 
      #end
      #declare y_win = y_win + 0.01;
    #end
    #declare x_win = x_win + 0.2;
  #end
}

#declare bldg1 =
difference{
  prism{
    conic_sweep
    0,        // height 1
    1,        // height 2
    5,          // number of points
    <-1,-1>,<1,-1>,<1,1>,<-1,1>,<-1,-1>
    rotate z*180
    translate y*0.5
  }

  plane{ -y, -0.2}

  plane{ x, -0.5}
  plane{ -x, -0.5}
  plane{ z, -0.5}
  plane{ -z, -0.5}

  object{windows}

  pigment{RandPig}
  finish{ambient 0.35}
  normal{wrinkles scale 0.01}
  
  scale <5, 120, 5>
}


#declare bldg_object =
union{
  object{bldg1}
  object{roof_object translate y*24}
//  object{ roof_tiles translate y*24}
  rotate y*(360*rand(Rand2))
  scale 0.5
  translate z*1
}