// Persistence of Vision Ray Tracer Scene Description File
// File: city.pov
// Vers: 3.1g.wmp.0.3
// Desc: beta for cities irtc entry
// Date: 22/mar/00
// Auth: Tom Melly, tom@tomandlu.f9.co.uk
//
// bldgs should be approx 2 units wide

#version unofficial MegaPov 0.4;

//make platform
#declare platform_base =
cylinder
{
  <0,0,0>, <0,0.1,0>,  1.5
}

//struts
#declare platform_struts =
intersection{
  union{
    #declare rot_y = -50;
    #while (rot_y <= 50)
      cylinder{<0,0,0>, <0,3,0>,  0.1 rotate x*-35 rotate y*rot_y}
      cylinder{<0,0,0>, <0,3,0>,  0.1 rotate x*-35 rotate y*rot_y}
      cylinder{<0,0,0>, <0,3,0>,  0.1 rotate x*-35 rotate y*rot_y}
      cylinder{<0,0,0>, <0,3,0>,  0.1 rotate x*-35 rotate y*rot_y}
      cylinder{<0,0,0>, <0,3,0>,  0.1 rotate x*-35 rotate y*rot_y}
      #declare rot_y = rot_y + 25;
    #end
  }  
  plane{y, 1.749}
}
#declare window =
box{<-0.25, 0.01,-1>, <0.25, 0.5, 1>
  pigment{RandPig}
  finish{ambient 0.35}
  normal{wrinkles scale 0.1}
}

#declare dwelling =
difference{
  union{
    box{
      <-0.75, 0.01, -0.75>  // one corner position <X1 Y1 Z1>
      < 0.75, 2,  0.75>  // other corner position <X2 Y2 Z2>
      pigment{RandPig}
      finish{ambient 0.35}
      normal{wrinkles scale 0.1}
    }
    sphere{<0,0,0>, 0.75
      pigment{RandPig2}
      finish{ambient 0.35}
      normal{wrinkles scale 0.1}
      translate y*2
    }
    cone{
      4*y,  0.0,
      2*y, 0.25
      pigment{RandPig2}
      finish{ambient 0.35}
      normal{wrinkles scale 0.1}
    }
  }
  object{window}
  object{window translate <-0.35, 0.75, 0>}
  object{window translate <0.35, 0.75, 0>}
  object{window translate <0, 1.25, 0>}
}

// platform + struts
#declare supported_platform =
union{
  object{platform_base}
  object{platform_struts translate y*-1.75}
  pigment{rgb <1,1,0.8>}
  finish{ambient 0.5}
  normal{wrinkles 2 scale 1}
}

#declare bldg_object =
union{
  object{supported_platform}
  object{dwelling}
  scale 1.5
}