// Persistence of Vision Ray Tracer Scene Description File
// File: city.pov
// Vers: 3.1g.wmp.0.3
// Desc: cities irtc entry
// Date: 22/Mar/00 - 
// Auth: Tom Melly, tom@tomandlu.f9.co.uk
// Parsetime: 0 hours, 51 mins, 15 secs
// Rendertime: 4 hours, 21 mins, 24 secs
// Totaltime: 5 hours, 12 mins, 39 secs

#version unofficial MegaPov 0.4;

global_settings{max_trace_level 10 ambient_light 1.00}// post_process{focal_blur{15, 500000, 5}}} //hmm?

#declare do_sky =           1;
#declare do_snow =          1;
#declare do_buildings =     1;
#declare do_fog =           1;
#declare do_balloons =      1;
#declare do_big_balloon =   1; // no effect if do_balloons off
#declare do_mountains =     1;

#declare speedAdd =         0; // 0 for full render
#declare only_citymount =   0; // 0 for all mountains, 1 for just city_peak

#include "city.inc"

light_source{<0,0,0> color rgb<1.0,0.8,0.8> * 0.99 translate <-600,150,-300>}
light_source{<0,0,0> color rgb<1,1,1.25> * 0.5 translate <0,10,-250.1> shadowless}

camera{location  <0,10,-250> look_at <0,0,0>}

#if (do_fog = 1)
fog{
  fog_type 1
  distance 6000
  color rgbt<1,1,1,0.7>
}
#end

#debug concat("Doing sky...", "\n")
#if (do_sky = 1)
  sky_sphere{
    pigment{
      gradient y
      rotate x*15
      rotate y*45
      color_map{
        [0.01 color rgb<1.0,0.4,0.4>]
        [0.2 color rgb<1.0,0.6,0.6>]
        [0.5 rgb<0.4,0.4,0.5>]
        [0.7 rgb<0.1,0.1,0.3>]
      }
    }
  }
  sphere{<0,0,0>, 50000
    inverse
    pigment{
      wrinkles scale 5000
      pigment_map{
        [0.60 rgbf<1,1,1,1>]
        [0.85 rgbf<1,1,1,0.5>]
      }
    }
  }
  sphere{<0,0,0>, 1
    inverse
    texture{
      planar
      translate y*-0.75
      rotate z*-70
      texture_map{
        [0.0 pigment{rgbf 1}]
        [0.1
          pigment{
            wrinkles scale 0.25
            pigment_map{
              [0.3 rgbf<1,1,1,1>]
              [0.5 rgbf<1,1,1,0.75>]
              [1.0 rgbf<1,1,1,0.5>]
            }
          }
        ]
      }
    }
    scale 500000
  }
#else
  sky_sphere{pigment{Blue}}
#end
#debug concat("Finished sky...", "\n")

#if (do_mountains = 1)
#debug concat("Doing mountains...", "\n")
  #if (only_citymount != 1)
    object {far_range translate <1000,-3000, 2400>}
    object {near_range translate <0.5,2.5,-245>}
  #end
  object {
    city_peak
    translate <25,-220,0>
    texture{city_rock_texture}
  }
#debug concat("Finished mountains...", "\n")
#end

#if (do_snow = 1)
  #debug concat("Doing snow....", "\n")
  #declare snow_blobs =
  blob{
    threshold 0.5
    snow_blobs_macro()  
    texture{
      pigment{rgb<1,1,1.2>}
      normal {agate 0.1 scale 0.1 turbulence 0.5}
      finish{ambient 0.1 diffuse 0.65 blinn 1 facets 1.5}
    }
    interior {ior 20}
    translate <0.5,2.5,-245>
  }
  object{snow_blobs}
  #debug concat("Finished snow....", "\n")
#end

//make the buildings
#if (do_buildings = 1)
  #debug concat("Doing buildings...", "\n")
  #declare xCount = -350/6;
  #declare zCount = -150/6;
  #while (xCount<350/6)
    #while (zCount<150/6)

      #declare pigchoice = rand(Rand1);
      #if (pigchoice < 0.33 & pigchoice >= 0)
        #declare RandPig = pigment{rgb<1,1,1>}
        #declare RandPig2 = pigment{rgb<1,0.5,0.5>}
      #end
      #if (pigchoice < 0.66 & pigchoice >= 0.33)
        #declare RandPig = pigment{rgb<1,1,0.95>}
        #declare RandPig2 = pigment{rgb<0.75,1,0.75>}
      #end
      #if (pigchoice < 1.1 & pigchoice >= 0.66)
        #declare RandPig = pigment{rgb<1,0.95,1>}
        #declare RandPig2 = pigment{rgb<0.5,0.5,1>}
      #end
      
      #declare scale_and_align = 1;
      #declare bldgchoice = rand(Rand1);
      #if (bldgchoice < 0.33 & bldgchoice >= 0)
        #include "bldg1.inc"
      #end
      #if (bldgchoice < 0.66 & bldgchoice >= 0.33)
        #include "bldg2.inc"
      #end
      #if (bldgchoice < 0.96 & bldgchoice >= 0.66)
        #include "bldg3.inc"
      #end
      #if (bldgchoice <= 1.0 & bldgchoice >= 0.96)
        #include "bldg4.inc"
      #end

      MakeBuilding(bldg_object, city_peak, xCount,zCount)
      #declare zCount = zCount + 1 + speedAdd;
    #end
    #declare zCount = -150/6;
    #declare xCount = xCount + 1 + speedAdd;
  #end
  #debug concat("Finished buildings...", "\n")
#end

#if (do_balloons = 1)
  #debug concat("Doing balloons...", "\n")
  #include "balloon.inc"

  #if (do_big_balloon = 1)
    make_balloon(1)
    object{whole_balloon scale 0.25 rotate y*10 rotate z*-10 rotate x*10 translate<-4, 8.5, -238>} // near balloon
  #end

  make_balloon(2)
  object{whole_balloon scale 0.25 translate<-8, -9, -10>}
  make_balloon(3)
  object{whole_balloon scale 0.25 translate<13, 16, -14>}
  make_balloon(4)
  object{whole_balloon scale 0.25 translate<-6, 41, 0>}
  
  make_balloon(5)
  object{whole_balloon scale 0.25 translate<34, -1, -8>}
  make_balloon(6)
  object{whole_balloon scale 0.25 translate<10, 7, 10>}
  make_balloon(7)
  object{whole_balloon scale 0.25 translate<29, 11, 8>}

  make_balloon(8)
  object{whole_balloon scale 0.25 translate<70, 32, -8>}
  make_balloon(9)
  object{whole_balloon scale 0.25 translate<65, 50, 10>}
  make_balloon(10)
  object{whole_balloon scale 0.25 translate<80, 87, 8>}
  #debug concat("Finished balloons...", "\n")
#end

#debug concat("Finished parsing...", "\n")