global_settings {
  assumed_gamma 1.0
  max_intersections 64
  max_trace_level 10
}

media 
   {
    intervals 15
    samples 1,1
    ratio 0.5
    absorption rgb <0.005,0.005,0.001>
    scattering {1,rgb 0.003}
   }

#declare fd =  1;
#declare fp =  2;
#declare in = 100;

// lumire en plus pour rajouter quelques ombres

light_source {<200,-100,150> color rgb <1,1,1>/10 media_attenuation off}
             
camera {
  location  <80,-170,200>
  sky     <0,0,1>
  up    <0,0,1>
  right   <4/3,0,0>
  direction <-1.2,1.2,0>
  look_at   <-10,10,0>
}



// TEXTURES -------------------------------------------------------------------


#declare Sol = 
   texture{ 
      pigment{color rgb <0.6,0.3,0.1>}      
      normal {bumps 0.5  scale  0.2}      
      finish  {ambient 0.5 diffuse 1}
    }

#declare Metal_jaune = 
    texture{      
      pigment{color rgb <1,0.7,0>}      
      finish{ambient 0.3 diffuse 1 brilliance 15 phong 0.4 phong_size 5}
    }

#declare Craft_glass = 
  material{   
    texture{      
      pigment{color rgbf <0.5,0.5,1,1>}      
      finish{ambient 0.1 diffuse 0.1 phong 0.3 phong_size 60 reflection 0.5}
    }   
    interior{ior 0.9}
  }

#declare lumin = 
    texture{      
      pigment{color rgb <1,1,0.8>*5}      
      finish{ambient 1 diffuse 0}
    }
 
#declare Bulle_glass = 
  material{   
    texture{      
      pigment{color rgbf <0.98,0.98,0.98,0.9>}      
      finish{ambient 0.1 diffuse 0.1 phong 1 phong_size 100 specular 0.8 roughness 0.0003 reflection 0.1}
    }   
    interior{ior 0.9}
  }

#declare Metal_gris = 
  texture{      
    pigment{color rgb <0.7,0.56,0.37>}      
    finish{ambient 0.3 diffuse 1 brilliance 15 phong 0.4 phong_size 5}
  }
    
#declare ttour = texture {
  gradient z
  texture_map {
    [ 0.0 Metal_gris ]
    [ 0.5 Metal_jaune ]
    [ 1.0 Metal_gris ]
  }
  scale<1,1,5>}
 
//DECLARATIONS DES OBJETS------------------------------------------------------


#declare bulle = 
union {
  object { 
    intersection {
      box {<-22,-22,0>, <22,22,22> texture {Metal_gris}}
      object {
        union {
          torus {20.25,0.25 rotate <0,0,-90> texture {Metal_gris}}
          torus {20.25,0.25 texture {Metal_gris}}
          torus {20.25,0.25 rotate <-90,0,0> texture {Metal_gris}}
          sphere {<0,0,0>,20 material {Bulle_glass} hollow}
          box {<-2,-22,0>, <2,-18,4> texture {Metal_gris}}
          box {<-2,18,0>, <2,22,4> texture {Metal_gris}}
          box {<-22,-2,0>, <-18,2,4> texture {Metal_gris}}
          box {<18,-2,02>, <22,2,4> texture {Metal_gris}}
          object { 
            light_source {<0,0,19> color rgb <1,1,1>*in*2 fade_distance fd fade_power fp media_attenuation on}
          }
          object { 
            intersection {
              box {<-15,-15,18>, <15,15,22> texture {Metal_gris}}
              object {
                difference {
                  sphere {<0,0,0>,20 texture {Metal_gris}}
                  sphere {<0,0,0>,19.8 texture {Metal_gris}}
                }
              }
            }
          }
          torus {8.95,0.25  rotate <-90,0,0> translate  <0,0,18> texture {Metal_gris}}
        }
      }
    }
  }
  object {disc{<0,0,0.01>, <0,0,1>, 20  texture {Metal_gris}}}
}


#declare tubeoff =
union {
  cylinder {<-1.8,-5,1.81>, <-1.8,5,1.81>, 0.25 texture {Metal_gris}}
  cylinder {<1.8,-5,1.81>, <1.8,5,1.81>, 0.25 texture {Metal_gris}}
  torus {1.8, 0.25 translate <0,0,1.81> texture {Metal_gris}}
  cylinder {<0,-5,1.81>, <0,5,1.81>, 1.8 open material {Bulle_glass} hollow }
}

#declare tubeon =
union {
  object { tubeoff }
  object {
    light_source {<0,0,3.35> color rgb <1,1,1>*in fade_distance fd fade_power fp media_attenuation on}
  }
}


#declare craft= union {
  sphere {<-1.7,-1.5,0>,0.2 texture {lumin} no_shadow hollow}
  sphere {<1.7,-1.5,0>,0.2 texture {lumin} no_shadow hollow}
  torus {1.5,0.5 rotate <-90,0,0> texture {Metal_jaune} scale <0.3,0.3,3> translate  <-2,0,3>}
  torus {1.5,0.5 rotate <-90,0,0> texture {Metal_jaune} scale <0.3,0.3,3> translate  <2,0,3>}
  box {<-1.7,-2,0>, <1.7,-1,5> texture {Metal_jaune}}
  torus {1.5, 0.5 rotate <-90,0,0> texture {Metal_jaune} translate  <0,0,5>}
  sphere {<0,0,0>,2 material {Craft_glass} hollow}
  sphere {<0,0,0>,2 scale <1,1,0.001> texture { pigment {image_map
{
  gif "human.gif"
  map_type 0 once
  interpolate 2
} translate <-0.5,-0.5,0> scale <4,4,1>}}      finish  {ambient 1 diffuse 1.0}
}
  object { 
    light_source {<-1.7,-1.5,-0.01> color rgb <1,1,0.6>*in*2 spotlight
    point_at  <-1.7,-1.5,-2>
    falloff  5
    radius   6
    fade_distance fd fade_power fp media_attenuation on}
  }
  object {
    light_source {<1.7,-1.5,-0.01> color rgb <1,1,0.6>*in*2 spotlight
    point_at  <1.7,-1.5,-2>
    falloff  5
    radius   6
    fade_distance fd fade_power fp media_attenuation on}
  }
  sphere {<0,0,0>,0.5 texture {Metal_jaune} scale <1, 1, 4> translate <0,2,2.5>}
  cylinder {<1.7,-1.5,5>, <1.7,-1.5,0>, 0.5 texture {Metal_jaune}}
  cylinder {<-1.7,-1.5,5>, <1.7,-1.5,0>, 0.5 texture {Metal_jaune}}
  object {
    difference {
      cylinder {<0,0,5>, <0,0,0>, 2}
      sphere {<0,0,0>,2}
      texture {Metal_jaune}
    }
  }
  rotate <0,180,0>
  rotate <100,0,0>
  translate  <0,0,7>
}

#declare rock = height_field{gif "fond.gif" texture {Sol} smooth rotate<90,0,0> scale<440,440,10> translate<-220,220,-1>}


#declare spot1 = light_source {<0,0,0>
  color rgb <1,1,1>*in/1.5
  spotlight
    point_at  <1,0,0>
    falloff    5
    radius     5
  fade_distance fd fade_power fp    media_attenuation on
  looks_like {sphere {<0,0,0> 1 hollow no_shadow texture{lumin}}}  
}

#declare tour1 = union{
  light_source {<0,0,68> color rgb <1,1,1>*in/2
    fade_distance fd fade_power fp
    media_attenuation on
    looks_like {sphere{<0,0,68> 1 texture{lumin}}}}
  cylinder {<0,0,18> <0,0,67.99> 8.99  texture {ttour}}
  object{ spot1 translate<9,0,25>}
  object{ spot1 translate<9,0,35>}
  object{ spot1 translate<9,0,45>}
  object{ spot1 translate<9,0,55>}
  object{ spot1 rotate <0,0,90> translate<0,9,25>}
  object{ spot1 rotate <0,0,90> translate<0,9,35>}
  object{ spot1 rotate <0,0,90> translate<0,9,45>}
  object{ spot1 rotate <0,0,90> translate<0,9,55>}
  object{ spot1 rotate <0,0,180> translate<-9,0,25>}
  object{ spot1 rotate <0,0,180> translate<-9,0,35>}
  object{ spot1 rotate <0,0,180> translate<-9,0,45>}
  object{ spot1 rotate <0,0,180> translate<-9,0,55>}
  object{ spot1 rotate <0,0,-90> translate<0,-9,25>}
  object{ spot1 rotate <0,0,-90> translate<0,-9,35>}
  object{ spot1 rotate <0,0,-90> translate<0,-9,45>}
  object{ spot1 rotate <0,0,-90> translate<0,-9,55>} 
}


// LES OBJETS -----------------------------------------------------------------

plane { z,0 texture {Sol}}
object {rock}

object{ tour1 translate <45,45,0>}
object{ tour1 translate <-45,-45,0>}
object{ tour1 translate <-45,45,0>}
object{ tour1 translate <45,-45,0>}
object{ tour1 translate <45,135,0>}

object { tubeon translate <45,0,30>}
object { tubeon translate <45,10,30>}
object { tubeon translate <45,20,30>}
object { tubeon translate <45,30,30>}
object { tubeon translate <45,-10,30>}
object { tubeon translate <45,-20,30>}
object { tubeon translate <45,-30,30>}
object { tubeon translate <-45,0,50>}
object { tubeon translate <-45,10,50>}
object { tubeon translate <-45,20,50>}
object { tubeon translate <-45,30,50>}
object { tubeon translate <-45,-10,50>}
object { tubeon translate <-45,-20,50>}
object { tubeon translate <-45,-30,50>}
object { tubeon translate <45,90,40>}
object { tubeon translate <45,100,40>}
object { tubeon translate <45,110,40>}
object { tubeon translate <45,120,40>}
object { tubeon translate <45,80,40>}
object { tubeon translate <45,70,40>}
object { tubeon translate <45,60,40>}
object { tubeon rotate <0,0,90> translate <0,45,40>}
object { tubeon rotate <0,0,90> translate <10,45,40>}
object { tubeon rotate <0,0,90> translate <20,45,40>}
object { tubeon rotate <0,0,90> translate <30,45,40>}
object { tubeon rotate <0,0,90> translate <-10,45,40>}
object { tubeon rotate <0,0,90> translate <-20,45,40>}
object { tubeon rotate <0,0,90> translate <-30,45,40>}
object { tubeon rotate <0,0,90> translate <0,-45,30>}
object { tubeon rotate <0,0,90> translate <10,-45,30>}
object { tubeon rotate <0,0,90> translate <20,-45,30>}
object { tubeon rotate <0,0,90> translate <30,-45,30>}
object { tubeon rotate <0,0,90> translate <-10,-45,30>}
object { tubeon rotate <0,0,90> translate <-20,-45,30>}
object { tubeon rotate <0,0,90> translate <-30,-45,30>}



object{ bulle translate <45,45,0>}
object{ bulle translate <-45,-45,0>}
object{ bulle translate <-45,45,0>}
object{ bulle translate <45,-45,0>}
object{ bulle translate <45,135,0>}
object{ bulle translate <-135,45,0>}


object { tubeon translate <45,0,0>}
object { tubeon translate <45,10,0>}
object { tubeon translate <45,20,0>}
object { tubeon translate <45,-10,0>}
object { tubeon translate <45,-20,0>}
object { tubeon translate <-45,0,0>}
object { tubeon translate <-45,10,0>}
object { tubeon translate <-45,20,0>}
object { tubeon translate <-45,-10,0>}
object { tubeon translate <-45,-20,0>}
object { tubeon translate <45,90,0>}
object { tubeon translate <45,100,0>}
object { tubeon translate <45,110,0>}
object { tubeon translate <45,80,0>}
object { tubeon translate <45,70,0>}
object { tubeon rotate <0,0,90> translate <0,45,0>}
object { tubeon rotate <0,0,90> translate <10,45,0>}
object { tubeon rotate <0,0,90> translate <20,45,0>}
object { tubeon rotate <0,0,90> translate <-10,45,0>}
object { tubeon rotate <0,0,90> translate <-20,45,0>}
object { tubeon rotate <0,0,90> translate <0,-45,0>}
object { tubeon rotate <0,0,90> translate <10,-45,0>}
object { tubeon rotate <0,0,90> translate <20,-45,0>}
object { tubeon rotate <0,0,90> translate <-10,-45,0>}
object { tubeon rotate <0,0,90> translate <-20,-45,0>}

object { tubeoff rotate <0,0,90> translate <-90,45,0>}
object { tubeoff rotate <0,0,90> translate <-80,45,0>}
object { tubeoff rotate <0,0,90> translate <-70,45,0>}

object {craft rotate<0,0,20> translate <-70,45,10>}
object {craft rotate<0,0,30> translate <-90,55,15>}
object {craft rotate<0,0,90> translate <-80,35,10>}
object {craft rotate<0,0,70> translate <-105,40,0>}
object {craft rotate<0,0,-50> translate <-85,60,5>}  

object {craft rotate<-50,0,0> translate <40,-120,150>}


