// Persistence Of Vision raytracer version 3.1 sample file.



global_settings { assumed_gamma 2.2 }

#include "colors.inc" 
#include "chars.inc"  
#include "glass.inc"
#include "shapes.inc"
#include "textures.inc" 
#include "metals.inc" 
#include "nycauburnhair.inc"
#include "nyccar.inc"
#include "nyccarr.inc" 


 camera {
   location  <0,0,-8>
   direction <0, 0,  1>
   up        <0,  1,  0>
   right     <4/3, 0,  0>
   look_at   <0, 0, 0>
   } 

 light_source {<-300, 0, -1000> color White}
//begin fmale 
   
#declare Qtft =
difference {

torus
{
  0.9,
  0.2 
  
  translate 1*z
} 


box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  
  scale <1,2,2> 
  translate 1*x
  
  
}  

box
{
  <-1, -1, -1>  
  < 1,  1,  1>
  scale <2,2,1 >  
  translate 2*z
  
  
  
} scale <1,2,1>} 
#declare Lleg = 
merge{
object {Qtft}

cone
{
  2*y,  1.2,
  0*y, .65
  scale <1,3,1>
  translate -.3*y  
  rotate 30*x
  
}

sor
{
    7, 
    <0.0, 0.0> 
    <0.2, 0.1>
    <0.3, 0.3>
    <0.4, 0.6>
    <0.4, 0.9>
    <0.37, 1.0>
    <0.35, 1.1>
    scale <2,8,2>
    translate -8*y  
    
    

rotate -30*x}  

sphere
{
  <0, 0, 0> 
  0.6 
  translate -.1*y
  scale <1,1,.65> 
  translate -.34*z     
  
}


 pigment {color Flesh}}


 #declare Rleg = 
merge{
cone
{
  2*y,  1.2,
  0*y, .7
  scale <1,3,1>
  translate -.3*y  
  rotate -10*x
  
}

sor
{
    7, 
    <0.0, 0.0> 
    <0.2, 0.1>
    <0.3, 0.3>
    <0.4, 0.6>
    <0.4, 0.9>
    <0.37, 1.0>
    <0.35, 1.1>
    scale <2,8,2>
    translate -8*y  
    
    

rotate -15*x}  

sphere
{
  <0, 0, 0> 
  0.6 
  translate -.1*y
  scale <1,1,.65> 
  translate -.45*z     
  
}


 pigment {color Flesh}}

                                               

#declare Hand = union {
blob {
    threshold .65
    sphere { <-.23,-.32,0>,.43, 1 scale <1.95,1.05,.8> }   //palm
    sphere { <+.12,-.41,0>,.43, 1 scale <1.95,1.075,.8> }  //palm
    sphere { <-.23,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
    sphere { <+.19,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
    sphere { <-.22,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
    sphere { <+.19,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
    cylinder { <-.65,-.28,0>, <-.65,.28,-.05>, .26, 1 }    //lower pinky
    cylinder { <-.65,.28,-.05>, <-.65, .68,-.2>, .26, 1 }  //upper pinky
    cylinder { <-.3,-.28,0>, <-.3,.44,-.05>, .26, 1 }      //lower ring
    cylinder { <-.3,.44,-.05>, <-.3, .9,-.2>, .26, 1 }     //upper ring
    cylinder { <.05,-.28,0>, <.05, .49,-.05>, .26, 1 }     //lower middle
    cylinder { <.05,.49,-.05>, <.05, .95,-.2>, .26, 1 }    //upper middle
    cylinder { <.4,-.4,0>, <.4, .512, -.05>, .26, 1 }      //lower index
    cylinder { <.4,.512,-.05>, <.4, .85, -.2>, .26, 1 }    //upper index
    cylinder { <.41, -.95,0>, <.85, -.68, -.05>, .25, 1 }  //lower thumb
    cylinder { <.85,-.68,-.05>, <1.2, -.4, -.2>, .25, 1 }  //upper thumb 
    
      sphere { <-.65,.28,-.05>, .26, -1 } //counteract pinky knuckle bulge
  sphere { <-.65,-.28,0>, .26, -1 }   //counteract pinky palm bulge
  sphere { <-.3,.44,-.05>, .26, -1 }  //counteract ring knuckle bulge
  sphere { <-.3,-.28,0>, .26, -1 }    //counteract ring palm bulge
  sphere { <.05,.49,-.05>, .26, -1 }  //counteract middle knuckle bulge
  sphere { <.05,-.28,0>, .26, -1 }    //counteract middle palm bulge
  sphere { <.4,.512,-.05>, .26, -1 }  //counteract index knuckle bulge
  sphere { <.4,-.4,0>, .26, -1 }      //counteract index palm bulge
  sphere { <.85,-.68,-.05>, .25, -1 } //counteract thumb knuckle bulge
  sphere { <.41,-.7,0>, .25, -.89 }   //counteract thumb heel bulge
    
    
    pigment { Flesh }
  }  
  
 
cylinder
{
  0*y,  -3*y,  .45
  scale <1,1,.3> 
  translate -1.1*y
  pigment {Flesh}
} }

declare Lhand = union{
 union{
blob {
    threshold .65
    sphere { <-.23,-.32,0>,.43, 1 scale <1.95,1.05,.8> }   //palm
    sphere { <+.12,-.41,0>,.43, 1 scale <1.95,1.075,.8> }  //palm
    sphere { <-.23,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
    sphere { <+.19,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
    sphere { <-.22,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
    sphere { <+.19,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
    cylinder { <-.65,-.28,0>, <-.65,.28,-.05>, .26, 1 }    //lower pinky
    cylinder { <-.65,.28,-.05>, <-.65, .68,-.2>, .26, 1 }  //upper pinky
    cylinder { <-.3,-.28,0>, <-.3,.44,-.05>, .26, 1 }      //lower ring
    cylinder { <-.3,.44,-.05>, <-.3, .9,-.2>, .26, 1 }     //upper ring
    cylinder { <.05,-.28,0>, <.05, .49,-.05>, .26, 1 }     //lower middle
    cylinder { <.05,.49,-.05>, <.05, .95,-.2>, .26, 1 }    //upper middle
    cylinder { <.4,-.4,0>, <.4, .512, -.05>, .26, 1 }      //lower index
    cylinder { <.4,.512,-.05>, <.4, .85, -.2>, .26, 1 }    //upper index
    //cylinder { <.41, -.95,0>, <.85, -.68, -.05>, .25, 1 rotate 180*y translate -1*x }  //lower thumb
    //cylinder { <.85,-.68,-.05>, <1.2, -.4, -.2>, .25, 1  rotate 180*y translate -1*x}  //upper thumb 
    
  sphere { <-.65,.28,-.05>, .26, -1 } //counteract pinky knuckle bulge
  sphere { <-.65,-.28,0>, .26, -1 }   //counteract pinky palm bulge
  sphere { <-.3,.44,-.05>, .26, -1 }  //counteract ring knuckle bulge
  sphere { <-.3,-.28,0>, .26, -1 }    //counteract ring palm bulge
  sphere { <.05,.49,-.05>, .26, -1 }  //counteract middle knuckle bulge
  sphere { <.05,-.28,0>, .26, -1 }    //counteract middle palm bulge
  sphere { <.4,.512,-.05>, .26, -1 }  //counteract index knuckle bulge
  sphere { <.4,-.4,0>, .26, -1 }      //counteract index palm bulge
 // sphere { <.85,-.68,-.05>, .25, -1 } //counteract thumb knuckle bulge
  //sphere { <.41,-.7,0>, .25, -.89 }   //counteract thumb heel bulge
    
    pigment { Flesh }
  } rotate  180*y  }
 union  {
 blob {
 threshold .65 
  sphere { <-.22,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
    sphere { <+.19,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
 
 cylinder { <.41, -.95,0>, <.85, -.68, -.05>, .25, 1 }  //lower thumb
    cylinder { <.85,-.68,-.05>, <1.2, -.4, -.2>, .25, 1 }  //upper thumb  
   }  
  //sphere { <.85,-.68,-.05>, .25, -1 } //counteract thumb knuckle bulge
  //sphere { <.41,-.7,0>, .25, -.89 }   //counteract thumb heel bulge 
  pigment {Flesh}
  rotate 180*y
 translate .1*y
// translate -.2*x
   } } 
   
declare Lftarm = union{   
  object {Hand rotate 180*z scale <.2,.2,.2> rotate -30*y //
} 
  
cylinder
{
  .19*y,  1*y,  .13
   pigment {color NavyBlue}
}
cylinder
{
  .19*y,  1*y,  .13
   pigment {color NavyBlue}
   rotate 30*z  
   translate .75*y 
   translate .1*x
}
torus
{
  0.8,
  0.2 
  pigment {color NavyBlue}
  scale <.15,.1,.15>
  translate 1*y  
  translate -.05*x
}
torus
{
  0.8,
  0.2 
  pigment {color NavyBlue}
  scale <.14,.1,.15>
  translate .95*y 
  rotate 20*x
  translate -.31*z 
 translate -.005*x
}

 }
 declare Rtarm = union{   
  object {Hand rotate 180*z // rotate 180*y
  scale <.2,.2,.2> rotate 45*y } 
  
cylinder
{
  .19*y,  1*y,  .13
   pigment {color NavyBlue}
}
cylinder
{
  .19*y,  1*y,  .13
   pigment {color NavyBlue}
   rotate 30*z  
   translate .75*y 
   translate .1*x
}
torus
{
  0.8,
  0.2 
  pigment {color NavyBlue}
  scale <.15,.1,.15>
  translate 1*y  
  translate -.05*x
}
torus
{
  0.8,
  0.2 
  pigment {color NavyBlue}
  scale <.14,.1,.15>
  translate .95*y 
  rotate 20*x
  translate -.31*z 
 translate -.005*x
}

 }

#declare Button =
difference{

cylinder
{
  0*z, .2*z,  1  
 
   pigment {color Black}
}
cylinder
{
  -.1*z, .3*z,  .2  
  translate <.3,.3,0>
   pigment {color Black}
} 
cylinder
{
  -.1*z, .3*z,  .2
  translate <.3,-.3,0>
   pigment {color Black}
} 
cylinder
{
  -.1*z, .3*z,  .2 
  translate <-.3,.3,0>
   pigment {color Black}
} 

cylinder
{
  -.1*z, .3*z,  .2 
    translate <-.3,-.3,0>
   pigment {color Black}
} 
scale <.1,.1,.5>

}   

#declare Ffoot =
union{
object {Qtft rotate 90*x //rotate 90*y 
scale <3,1,1>}  

object {Qtft rotate -90*x rotate 180*y 
scale <3,1,1>
translate -5.25*x translate -1.5*y}
difference {
sphere
{
  <0,0, 0> 
  0.5       
}

box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  translate 1*x
}  scale <5,.5,.8>  translate -1.5*y translate -4.75*x}
 
 
 
 
 } 


#declare Fcoat =
union { 

sphere
{
  <0, 0, 0> 
  0.5      
   scale <2.8,1,1> 
   pigment {color NavyBlue}
   translate .8*y 
   translate 1*x  
   
}

union{   
object {Button translate -1*z  translate .5*y}
object {Button translate -1*z }
object {Button translate -1*z  translate -.5*y}
object {Button translate -1*z translate -1*y} 
object {Button translate -1*z translate -1.5*y}
object {Button translate -1*z translate -2*y}
object {Button translate -1*z translate -2.5*y  } 
object {Button translate -1*z translate -3*y  } 
translate 1.2*x translate -.5*y       }
//union {
union{   
object {Button translate -1*z  translate .5*y}
 object {Button translate -1*z }
object {Button translate -1*z  translate -.5*y}
object {Button translate -1*z translate -1*y} 
object {Button translate -1*z translate -1.5*y}
object {Button translate -1*z translate -2*y}
object {Button translate -1*z translate -2.5*y  } 
object {Button translate -1*z translate -3*y  } 
translate 1.5*x translate -.5*y       }
 object {Lftarm rotate 30*z rotate -90*y scale <2,2,2>
 translate -.2*x translate -1.6*y translate 2.4*z} 
 
 
object {Rtarm   rotate -30*z rotate -90*y   translate 1.05*x scale<2,2,2> translate -1.1*z
translate -2.3*y} 

difference {
torus
{
  0.8,
  0.2
  pigment {color NavyBlue}
}
torus
{
  0.8,
  0.2
  pigment {color NavyBlue} 
  translate .1*z
} 



box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  pigment {color NavyBlue} 
  scale <.3,1,1>
  translate -1*z
}  
rotate -30*x translate 1*x  translate 1*y
}
sphere
{
  <0, 1, 0> 
  0.5       
  scale <2,1,1>    
  translate 1.0*x
  pigment{color NavyBlue}
}

cone
{
  1*y,  .95,
  -1.5*y, 1.0
  open  
  scale <1,2,.5> 
  translate -1*y  
  translate 1*x
  pigment {color NavyBlue}
} 
difference{
cone
{
  1*y,  .95,
  -.1*y, 1.0
  open  
  scale <1,2,.5> 
  translate -1*y  
  translate 1*x
  pigment {color NavyBlue}
}

box
{
  <0, -1, -1>  
  < 1,  1,  1> 
  pigment {color NavyBlue}
  scale <1,4,1> 
}

 
scale <1,2,.5> 
  translate -1.6*y  
  //translate 1*x 
  translate -.5*z} 
  
  
translate 1.5*y translate .5*x }  

#declare Hiheel =
union{
difference{

lathe {
  linear_spline 
  7, 
  <.2, 0>, <.25, .2>, <.3, .4>, <.35, .6>, <.4, .8> , <.4, 1>, <.2, 0> 
}

box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
   translate -1*x
} scale <1,1,.8>}
difference{
sphere
{
  <0, 0, 0> 
  0.5       
   scale <1,.4,.5> 
} 
box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
   translate -1*y
}
box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
   translate 1*x
}
 scale 2 translate -2*x }  
difference{
cylinder
{
  1*y,  1.5*y,  .5
 open  
 translate -.1*x  
 
}
cylinder
{
  -1*z,  1.5*z,  .5
  
 translate .5*y 
 
 translate 1.1*y
 translate -.1*x
}  

box
{
  <-1, -1, -1>  
  < 1,  1,  1>   
  scale <1,5,1>
  translate -1*x
}

//translate -.02*x
}


 pigment {color Black}         }


 
//object {Button}
//object {Hat  translate -2*x rotate -20*x} 
declare Fmale = 
union{   
object {Faceaub scale <.75,.77,.75> translate 5.0*y
translate 1.75*x}
object {Fcoat  } 
union{
object {Lleg translate 5.7*x translate -2*z}  
object {Rleg translate 3.3*x } scale <.35,.35,.35> translate -3*y translate 1*z       }
union{ 
object {Ffoot scale <1,4,6> scale 2.0*x translate 7*y  translate .5*x
 pigment {color Flesh}
 }
object {Ffoot scale <1,4,6> scale 2.0*x translate 7*y  translate .5*x
scale 1.1*z scale 1*x  translate -.1*y pigment {color Black}
 } 
object {Hiheel scale <.3,.3,.3> }
scale <.1,.1,.08>
rotate -90*y   
translate -7.1*y 
translate 4*z   
translate .75*y 
translate 1.2*x
//rotate -30*x
 }  
  
union{ 
object {Ffoot scale <1,4,6> scale 2.0*x translate 7*y  translate .5*x
 pigment {color Flesh}
 }
object {Ffoot scale <1,4,6> scale 2.0*x translate 7*y  translate .5*x
scale 1.1*z scale 1*x  translate -.1*y pigment {color Black}
 } 
object {Hiheel scale <.3,.3,.3> }
scale <.1,.1,.08>
rotate -90*y   
translate -7.1*y 
translate 4*z
translate 2.2*x
translate .75*y
 }    
  
}







//end fmale
//begin car red
//end car red
//begin car blue
//end blue car
//begin taxi
 
#declare Taxtop =
difference{
difference{
sphere
{
  <0, 0, 0> 
  .5      
  
}

box
{
  <-1, -1, -1>  
  < 1,  .3,  1>
    
} }

box
{
  <-1, -1, -1>  
  < 1,  1,  1>
  pigment {color Yellow} 
  translate -1.25*x 
}   

box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  pigment {color Yellow}
  translate 1.25*x  
}






}



#declare Bodytemplate =
union{

box
{
  <-1, -1, -1> 
  < 1,  1,  1>  
  scale <4,2.2,10>
  texture {T_Glass1}
}

box
{
  <-1, -1, -1> 
  < 1,  1,  1>  
  scale <4,1.5,3.7>  
  translate 3.7*y
  texture {T_Glass1}
}   }




#declare Bumperc =
difference {
cylinder
{
  0*y,  1*y,  1 
  pigment {color VLightGray}
  
} 

cylinder
{
  -.1*y,  1.1*y,  1 
   translate .475*x
   translate .475*z
   pigment {color  VLightGray}
  
} 

torus
{
  1.5,
  .6
  translate .5*y
  pigment {color VLightGray}
} 


box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  pigment {color VLightGray} 
  
  translate 1*z}

box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  pigment {color VLightGray}
  translate 1*x 
  }  
  


 } 
 
  
#declare Bumperf =

difference{

box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  pigment {color VLightGray} 
  }

cylinder
{
  -3*x,  3*x,  .9
 translate -.75*z   
 pigment {color VLightGray}
}   }



#declare Bumpers = 

object {Bumperf
scale <1,.7,.3>
rotate 90*y
}
 
#declare Bumper =
union{
object {Bumperf
scale <5,.7,.3>
translate -.80*z }
 
object {Bumpers
translate -5.6*x
rotate 180*y
translate 1*z}

object {Bumpers
translate -5.6*x
translate 1*z} 

 
 object {Bumperc 
 translate -4.9*x
 scale <1,1.3,1>
 translate -.55*y
 }  
 
 
 object {Bumperc
 rotate 180*z
 translate 4.9*x  
 scale <1,1.3,1> 
 translate .55*y
 }
 }


declare Gfrt =

difference{

torus
{
  0.8,
  0.2 
  pigment {color VLightGray}
  
} 


box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  pigment {color VLightGray} 
  translate -1.3*z
}
scale <4,1.5,.5>  
  
  }
  
#declare Grill =
union{  
object {Gfrt
scale <.95,1,1>
}  

cylinder
{
  -3.5*x,  3.5*x,  .2
  pigment {color VLightGray}
  translate -2*z
  
}

cylinder
{
  -1*x,  1*x,  .2
  pigment {color VLightGray}
 rotate 90*y
 translate 3.5*x 
 translate -.8*z 
 rotate 5*y
  
}
cylinder
{
  -1*x,  1*x,  .2
  pigment {color VLightGray}
  rotate 90*y
  translate -3.5*x  
  translate -.8*z
  rotate -5*y
  
}

cylinder
{
  -3.5*x,  3.5*x,  .2
  pigment {color VLightGray}
  translate -2*z
  
}

cylinder
{
  -3.5*x,  3.5*x,  .14
  pigment {color VLightGray}
 
  
}

cylinder
{
  -3.5*x,  3.5*x,  .14
  pigment {color VLightGray}
  translate -1.55/4*z
  
}

cylinder
{
  -3.5*x,  3.5*x,  .14
  pigment {color VLightGray}
  translate -1.55/2*z
  
}
cylinder
{
  -3.5*x,  3.5*x,  .14
  pigment {color VLightGray}
  translate -1.55*3/4*z
  
}

cylinder
{
  -3.5*x,  3.5*x,  .14
  pigment {color VLightGray}
  translate -1.55*z
  
}  


cylinder
{
  -1.2*x,  1.2*x,  .07
  pigment {color VLightGray}
  rotate 90*y  
  translate -.67*z
  
}
cylinder
{
  -1.15*x,  1.15*x,  .07
  pigment {color VLightGray}
  rotate 90*y    
  translate 1.15*x
  translate -.67*z
  
}

cylinder
{
  -1.11*x,  1.11*x,  .07
  pigment {color VLightGray}
  rotate 90*y  
  translate 2.3*x
  translate -.7*z
  
}


cylinder
{
  -1.15*x,  1.15*x,  .07
  pigment {color VLightGray}
  rotate 90*y   
  translate -1.15*x
  translate -.67*z
  
}

cylinder
{
  -1.13*x,  1.13*x,  .07
  pigment {color VLightGray}
  rotate 90*y   
  translate -2.3*x
  translate -.7*z
  
}


box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  scale <3.5,1,1>
  translate -1*y 
  translate -1*z
  pigment {color Black}
}



}


 
#declare Hood =
merge {
difference{
cylinder
{
  -.9*z,  .9*z,  1 
  pigment {color Yellow}
  
} 



box
{
  <-1, -1, -1>  
  < 1,  1,  1>
  translate -1.75*x
  pigment {color Yellow}
  
}
  
box
{
  <-1, -1, -1>  
  < 1,  1,  1>
  translate 1.75*x 
   pigment {color Yellow} 
} 

box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
   pigment {color Yellow}
   
translate -.75*y  }
}
 
 
difference{
torus
{
  0.8,
  0.6   
  pigment {color Yellow}
 
}  
box
{
  <-1, -1, -1>  
  < 1,  1,  1>
  translate -1.8*x
  pigment {color Yellow}
  
}
  
box
{
  <-1, -1, -1>  
  < 1,  1,  1>
  translate 1.8*x 
   pigment {color Yellow} 
} 

box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
   pigment {color Yellow}
   scale <2,2,5>
   
translate 4.35*z  }  

box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
   pigment {color Yellow}
   scale <2,2,2>
   
translate 1.65*y  }


  rotate 90*x  
  scale <.92,1.1,1>
  translate -.54*z
 translate -.42*y
  }

 
 }

#declare Tire =
union {
difference {

cylinder
{
  0*z,  .5*z,  1
  pigment {color Black}
  
}
cylinder

{
  -1*z,  1*z,  .6
  scale <1,1,2>
  pigment {color Black}
  
}}


sphere
{
  <0, 0, 0> 
  0.6       
scale <1,1,.2> 
texture{T_Silver_5A}
} 

sphere
{
  <0, 0, 0> 
  0.4       
scale <1,1,.5> 
texture{T_Silver_5A}
}
scale <1.5,1.5,1.5>  
   
 rotate 90*y  
   
    }   


 


#declare Taxsign =
union { 
box
{
  <-1, -1, -1>  
  < 1,  1,  1>
 scale <2.2,1.0,.18> 
  pigment {color Yellow}
}  

box
{
  <-1, -1, -1>  
  < 1,  1,  1>
 scale <2,.8,.2> 
  pigment {color Black}
}  

text
{
  ttf             
  "crystal.ttf",  
  "TAXI",      
  .5,             
  0 
  scale <1.3,1.3,.2>
  translate -2*z
  translate -1.9*x
  translate -.6*y 
  pigment {color Yellow}            
} }
   


#declare Tlbk =

difference{

cylinder
{
  0*z,  1*z,  1 
  
  pigment {color Black}
  
}  

box
{
  <-1, -1, -1>  
  < 1,  1,  1>
  scale <1.1,1.1,1.1>
  translate 1.5*y
  pigment {color Black}
}  

box
{
  <-1, -1, -1>  
  < 1,  1,  1>
   scale <1.1,1.1,1.1>
  translate -1.5*y
  pigment {color Black}
}  }  
#declare Tlr =

difference{

cylinder
{
  0*z,  1*z,  1 
  
  pigment {color Red}
  
}  

box
{
  <-1, -1, -1>  
  < 1,  1,  1>
  scale <1.1,1.1,1.1>
  translate 1.5*y
  pigment {color Red}
}  

box
{
  <-1, -1, -1>  
  < 1,  1,  1>
   scale <1.1,1.1,1.1>
  translate -1.5*y
  pigment {color Red}
} 
scale <.4,.8,1> } 

#declare Taillt =
union{
object {Tlr 
scale <.9,.8,1>
translate .5*x
translate  -.1*z}
object {Tlr 
scale <.9,.8,1> 
translate -.4*x
translate -.1*z}
object {Tlbk}
}


#declare Headlight =
union {
sphere
{
  <0, 0, 0> 
  1       
   scale <1,.2,1>
   texture {T_Old_Glass} 
}  

cylinder
{
  0*z,  .1*z,  1
  pigment {color rgb <1,1,.7>}
}}  

 
#declare Ffender =
difference {
sphere
{
  <0, 0, 0>, 
  1       
 pigment {color Yellow} 
} 


box
{ <-1, -1, -1>  
  < 1,  1,  1> 
 scale <1,3,3>
  translate 1.75*x
  pigment {color Yellow}
  
}  

box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  scale <1,3,3>
  translate -1.1*x
  pigment {color Yellow} 
  
}  
}


 
 #declare Hltrim =
difference {
sphere
{
  <0, 0, 0>, 
  1       
 pigment {color Gray70} 
} 


box
{ <-1, -1, -1>  
  < 1,  1,  1> 
 scale <1,3,3>
  translate 1.8*x
  pigment {color Gray70}
  
}  

box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  scale <1,3,3>
  translate .1*x
  pigment {color Gray70} 
  
}  
}
   
declare Dhl =
union {
object {Headlight} 
object {Headlight
translate 2.2*x} 


} 

declare Dhlwt = union{
object {Dhl
translate -.2*z} 
object {Hltrim
rotate 90*y
scale <7,5,2>
translate 1.2*x}}  
 
#declare Ffwt = union {
object {Dhlwt scale <.175,.175,.2>
translate -6*z
translate -.25*x} 
object {Ffender
scale <7,.7,1>
rotate 90*y
}
translate 1*y
translate 3*x
}  
#declare Doorb =
difference{

cylinder
{
  0*x,  1*x,  1
  pigment {color Yellow}
}

cylinder
{
  -.1*x, 1.2*x,  1  
  translate .2*z
  pigment {color Yellow}
}


box
{
  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
  scale <1.2,1.2,1.2>
  translate .4*z
} 



}

#declare  Rsffender =
difference {
object {Doorb
scale <5,3,3>}

prism {
  linear_sweep 
   linear_spline 
  -0.5,       
   0.5,        
  5,          
  
  < -1.3, -.3>, < 1,  -.3>, < .75, .75>, < -.6,  .75>, <-1.3,-.3>
  rotate -90*x 
  scale <1.3,1.3,15> 
  translate -1.5*y 
  translate 3*x
  pigment {color Yellow}
  
  
}

cylinder
{
  -10*z,  10*z,  1
  pigment {color Yellow}
  scale <.9,.35,1>
  translate 3.1*x 
  translate -.7*y
}

}
 
#declare  Lsffender =
difference {
object {Doorb
scale <5,3,3>
rotate 180*y}

prism {
  linear_sweep 
   linear_spline 
  -0.5,       
   0.5,        
  5,          
  
  < -1.3, -.3>, < 1,  -.3>, < .75, .75>, < -.6,  .75>, <-1.3,-.3>
  rotate -90*x 
  scale <1.3,1.3,15> 
  translate -1.5*y 
  translate 3*x
  pigment {color Yellow}
  
  
}

cylinder
{
  -10*z,  10*z,  1
  pigment {color Yellow}
  scale <.9,.35,1>
  translate 3.1*x 
  translate -.7*y
}

}
 


 

 #declare Taxi =
 union{   
 
box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <.2,2,.1>
  translate 1.77*y 
  translate -2*x
  translate 3*z   
  rotate 15*x   
  rotate -7.5*z
  pigment {color Yellow}
}
 
box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <.2,2,.1>
  translate 1.65*y 
  translate -2*x
  translate 6*z 
  rotate -5*z  
  
  pigment {color Yellow}
}
box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <.2,2,.1>
  translate 1.2*y 
  rotate -10*x
  translate -2*x
  translate 9.25*z 
  rotate -5*z  
  
  pigment {color Yellow}
}

 
box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <.2,2,.1>
  translate -3.0*y 
  translate -2*x
  translate 9.5*z   
  rotate -25*x   
  rotate -5*z
  pigment {color Yellow}
} 
union{
box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <.2,2,.1>
  translate 1.77*y 
  translate -2*x
  translate 3*z   
  rotate 15*x   
  rotate 7.5*z
  pigment {color Yellow}
}
 
box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <.2,2,.1>
  translate 1.65*y 
  translate -2*x
  translate 6*z 
  rotate 5*z  
  
  pigment {color Yellow}
}
box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <.2,2,.1>
  translate 1.2*y 
  rotate -10*x
  translate -2*x
  translate 9.25*z 
  rotate 5*z  
  
  pigment {color Yellow}
}

 
box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <.2,2,.1>
  translate -3.0*y 
  translate -2*x
  translate 9.5*z   
  rotate -25*x   
  rotate 5*z
  pigment {color Yellow}
} 
translate 4*x}
 /*
 object {Bodytemplate 
 scale <.9,.75,1>
 translate 6*z
 translate -.2*y}  */
 object {Hood scale <4.5,2,3>}
 object {Grill 
scale <.9,1,.6> 
scale <.75,.75,.75>
rotate -90*x
translate -3.7*z
translate .4*y 
  
} 
object {Tire rotate 180*y translate 3.5*x translate -.75*z translate -1.5*y}
 object {Tire  translate -3.5*x translate -.75*z translate -1.5*y}  
object {Tire rotate 180*y translate 3.5*x translate 11*z translate -1.5*y}
 object {Tire translate -3.5*x translate 11*z translate -1.5*y}
object {Bumper 
scale <.7,.7,.5>
translate -1*y 
translate -4.5*z
 } 
object {Bumper
rotate -180*y
scale <.7,.7,.5>
translate -1*y 
translate 17*z
 }   
 
   
object {Rsffender
rotate 90*y 
scale <.5,.85,1.0>
translate -2.5*x  
translate 2.4*z 
translate -.4*y
}   

    
object {Rsffender
rotate 90*y 
scale <.5,.9,1.1>
translate -2.75*x  
translate 14.1*z 
translate -.35*y
}   

object {Lsffender
rotate 90*y 
scale <1,.8,1.2>
translate 1.5*x  
translate 1.8*z 
translate -.4*y
}   
 

 object {Taxsign scale <.4,.4,.4> translate 4.35*y translate 6*z}  
 
 
object {Taillt translate 2.0*x  translate .2*y  translate -15*z    rotate 180*y}
 object {Taillt translate -2.0*x translate .2*y   translate -15*z      
 rotate 180*y}
 object {Ffwt 
 scale <1.3,1,1>
 translate 0*y
 translate -2*x
 translate 2*z}
 
 object {Ffwt 
 scale <1.3,1,1>
 translate 0*y
 translate -6.5*x
 translate 2*z} 
 
   
 object {Doorb  
 scale <3,2.5,2.15>
 rotate 90*y  
 translate -.2*y
 translate .55*z
 translate -2*x
 translate 5.0*z}
 
 object {Doorb  
 scale <3,2.5,2.15>
 rotate 90*y   
 translate 8.65*z 
 translate -.2*y
 translate -2*x}
 
 
cylinder
{
  -1*z,  1*z, .5
  scale <1,1,3.5>
  pigment {color Yellow}
  translate -2.5*x
  translate -1.5*y 
  translate 6*z
  
}

 
 object {Doorb  
 scale <3,2.5,5>
 rotate -90*y
 translate 1.5*x
 translate 5.0*z} 
 object {Doorb  
 scale <3,2.5,5>
 rotate -90*y   
 translate 8*z
 translate 1*x}
  
/*
box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
   scale<3.4,.4,2>
  pigment {color Yellow}
  translate -2.75*z  
  translate -1.1*y
}   */



/*
sphere
{
  <0, 0, 0> 
  0.5      
  scale <1.35,2.7,1> 
  pigment {color Yellow}
  translate -2.8*z
  translate -3.9*x 
  translate -.4*y
}  */

cylinder
{
  0*y,  3*y,  3
  scale <1.3,.8,.4>
  pigment {color Yellow}
  //translate -3.3*x
  translate -2.4*z 
  translate -1.8*y
}  
object {Taxtop scale <10,4,8> pigment {color Yellow} translate 2.0*y translate 6.5*z}  
object {Hood scale <4,1,3> rotate 180*y translate 12*z translate .9*y} 
difference{
cylinder
{
  0*y,  1*y,  3
  
} 

box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  scale <2,1.1,3>
  pigment{color Yellow}
  translate 2.65*x
}
box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  scale <2,1.2,3>
  pigment{color Yellow}
  translate -2.65*x
}
 scale <5,3,1>  
  translate -1.3*y
  pigment{color Yellow}
  translate 13*z
  translate -.2*y 
   }   
 } 
 /*
box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  scale <3,.2,3.3>
  pigment{color Yellow}
  translate 1.3*z
} */


//end taxi 
 
 
   
 // light_source {<-20, 50, 0> color White} 
 
 background {color Black} 
 
//start theater 
  
#declare Theaterfront =  

difference{
box
{
  <-1, -1, -1> 
  < 1,  1,  1>     
  scale <3,10,4>
  
  pigment
  {
    brick      color Gray, color .6*Gold
    brick_size <.3,.4,.2>   // size of brick
    mortar     0.04       // width of mortar
  } translate 5*y}
box
{
  <-1, -1, -1> 
  < 1,  1,  1>     
  scale <2,1,6>
  
  pigment
  {
    brick      color Gray, color Gray30
    brick_size <.3,.4,.2>   // size of brick
    mortar     0.04       // width of mortar
  }  translate -.2*z translate -4*y}
scale <1.5,1,1>
translate 1.5*y
  
}  



          
 


#declare Theater =
union{  
object {Theaterfront
translate 10*z}
prism {
  linear_sweep 
  linear_spline 
  -0.5,        
   0.5,        
  5,         
  
  < -(.5+1/sqrt(2)), 0>, <(.5+1/sqrt(2)),0>, < .5, 1/sqrt(2)>, < -.5,  1/sqrt(2)>, < -(.5+1/sqrt(2)),  0>  
  scale <2,2,2>
  rotate -180*y
  translate -1*z   
  pigment {color White} 
  scale <1,.8,1>
  
}
//1st marquis 
union{ 
difference {
box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1.2,.8,.2>
  pigment {color Yellow}  
} 
box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1.2,.8,1.2>
  scale <.9,.9,1>
  pigment {color Yellow}  
}                   
translate -1.5*z
} 
//start of lines in theater marquis  

box               
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.002,.2>
  pigment {color Black}
  translate -1.8*z 
  translate .2*y 
} 


 box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.002,.2>
  
  pigment {color Black}
  translate -1.8*z 
  translate .4*y 
}

box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.002,.2>
  
  pigment {color Black}
  translate -1.8*z 
  translate .6*y 
}  
box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.002,.2>
  
  pigment {color Black}
  translate -1.8*z
  translate -.2*y  
} 
 box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.002,.2>
  
  pigment {color Black}
  translate -1.8*z  
  translate -.4*y
  
}

box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.002,.2>
  
  pigment {color Black}
  translate -1.8*z  
  translate -.6*y
}  

 box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.002,.2>
  
  pigment {color Black}
  translate -1.8*z  
} 



text
{
  ttf             
  "crystal.ttf",  
  "THE OLD MAN",     
  2,              
  0 
  pigment {color Black}
  scale <.3,.3,.5>
  translate -1.75*z 
  translate .2*y
  translate -.9*x            
} 

text
{
  ttf             
  "crystal.ttf",  
  "AND",     
  2,              
  0  
 pigment {color Black}   
 scale <.3,.3,.5>
 translate -.2*y  
 translate -1.75*z  
 translate -.3*x
               
}
text
{
  ttf             
  "crystal.ttf",  
  "THE SEA",     
  2,              
  0    
  scale <.3,.3,.5>
 pigment {color Black}
 translate -.6*y 
 translate -1.75*z 
 translate -.6*x
               
}


text
{
  ttf             
  "crystal.ttf",  
  "EMPIRE",     
  2,              
  0    
  scale <.5,.5,.1>
 pigment {color Red}
 translate .8*y 
 translate -1.75*z 
 translate -.75*x
               
}
translate -1*z  
}
//2nd marquis  
union{ 
difference {
box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1.2,.8,.2>
  pigment {color Yellow}  
} 
box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1.2,.8,1.2>
  scale <.9,.9,1>
  pigment {color Yellow}  
}                   
translate -2.3*z 
translate -.6*x
} 
//start of lines in theater marquis
box               
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.003,.2>
  pigment {color Black}
  translate -1.8*z 
  translate .2*y 
} 
 box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.003,.2>
  
  pigment {color Black}
  translate -1.8*z 
  translate .4*y 
}

box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.003,.2>
  
  pigment {color Black}
  translate -1.8*z 
  translate .6*y 
}  
box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.003,.2>
  
  pigment {color Black}
  translate -1.8*z
  translate -.2*y  
} 
 box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.003,.2>
  
  pigment {color Black}
  translate -1.8*z  
  translate -.4*y
  
}

box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.003,.2>
  
  pigment {color Black}
  translate -1.8*z  
  translate -.6*y
}  

 box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.003,.2>
  
  pigment {color Black}
  translate -1.8*z  
} 
 box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.003,.2>
  
  pigment {color Black}
  translate -1.8*z  
}

box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.003,.2>
  
  pigment {color Black}
  translate -1.8*z  
}  

text
{
  ttf             
  "crystal.ttf",  
  "THE OLD MAN",     
  2,              
  0 
  pigment {color Black}
  scale <.3,.3,.2>
  translate -1.8*z 
  translate .3*y
  translate -.9*x            
}
text
{
  ttf             
  "crystal.ttf",  
  "AND",     
  2,              
  0  
 pigment {color Black}   
 scale <.3,.3,.2>
 translate -.1*y  
 translate -1.8*z  
 translate -.3*x
               
}
text
{
  ttf             
  "crystal.ttf",  
  "THE SEA",     
  2,              
  0    
  scale <.3,.3,.2>
 pigment {color Black}
 translate -.4*y 
 translate -1.8*z 
 translate -.6*x
               
}
 text
{
  ttf             
  "crystal.ttf",  
  "THE SEA",     
  2,              
  0    
  scale <.3,.3,.2>
 pigment {color Black}
 translate -.4*y 
 translate -1.8*z 
 translate -.6*x
               
}
text
{
  ttf             
  "crystal.ttf",  
  "EMPIRE",     
  2,              
  0    
  scale <.5,.5,.1>
 pigment {color Red}
 translate .8*y 
 translate -1.8*z 
 translate -.6*x
               
}rotate -45*y
translate .5*x
translate .3*z  

} 

//3rd marquis
union{ 
difference {
box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1.2,.8,.2>
  pigment {color Yellow}  
} 
box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1.2,.8,1.2>
  scale <.9,.9,1>
  pigment {color Yellow}  
}                   
translate -2.05*z} 
//start of lines in theater marquis
box               
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.003,.2>
  pigment {color Black}
  translate -1.8*z 
  translate .2*y 
} 
 box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.003,.2>
  
  pigment {color Black}
  translate -1.8*z 
  translate .4*y 
}

box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.003,.2>
  
  pigment {color Black}
  translate -1.8*z 
  translate .6*y 
}  
box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.003,.2>
  
  pigment {color Black}
  translate -1.8*z
  translate -.2*y  
} 
 box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.003,.2>
  
  pigment {color Black}
  translate -1.8*z  
  translate -.4*y
  
}

box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.003,.2>
  
  pigment {color Black}
  translate -1.8*z  
  translate -.6*y
}  

 box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.003,.2>
  
  pigment {color Black}
  translate -1.8*z  
} 
 box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.003,.2>
  
  pigment {color Black}
  translate -1.8*z  
}

box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,.003,.2>
  
  pigment {color Black}
  translate -1.8*z  
}  

text
{
  ttf             
  "crystal.ttf",  
  "THE OLD MAN",     
  2,              
  0 
  pigment {color Black}
  scale <.3,.3,.2>
  translate -1.75*z 
  translate .3*y
  translate -.9*x            
}
text
{
  ttf             
  "crystal.ttf",  
  "AND",     
  2,              
  0  
 pigment {color Black}   
 scale <.3,.3,.2>
 translate -.1*y  
 translate -1.75*z  
 translate -.3*x
               
}
text
{
  ttf             
  "crystal.ttf",  
  "THE SEA",     
  2,              
  0    
  scale <.3,.3,.2>
 pigment {color Black}
 translate -.4*y 
 translate -1.75*z 
 translate -.6*x
               
}
 text
{
  ttf             
  "crystal.ttf",  
  "THE SEA",     
  2,              
  0    
  scale <.3,.3,.2>
 pigment {color Black}
 translate -.4*y 
 translate -3*z 
 translate -.5*x
               
}
text
{
  ttf             
  "crystal.ttf",  
  "EMPIRE",     
  2,              
  0    
  scale <.5,.5,.1>
 pigment {color Red}
 translate .8*y 
 translate -2*z 
 translate -.6*x
               
}
rotate 45*y
translate -.2*x
translate -.3*z
}



 }  
 





//end theater
//start bar 


#declare Bar =  
union{
difference{
box
{
  <-1, -1, -1> 
  < 1,  1,  1>     
  scale <3,5,4>
  
  pigment
  {
    brick      color Gray, color Firebrick
    brick_size <.3,.15,.2>   // size of brick
    mortar     0.04       // width of mortar
  } }
box
{
  <-1, -1, -1> 
  < 1,  1,  1>     
  scale <2,1,6>
  
  pigment
  {
    brick      color Gray, color Firebrick
    brick_size <.3,.15,.2>   // size of brick
    mortar     0.04       // width of mortar
  }  translate -.2*z translate -4*y}

  
}  


text
{
  ttf             
  "crystal.ttf",  
  "BEER",      
  2,              
  0 
  pigment {color White}
  translate 5*x
    
  scale <.5,.5,.2>
            
}

text
{
  ttf             
  "crystal.ttf",  
  "PIZZA",      
  2,              
  0 
  pigment {color Yellow}
  scale <.7,.7,.7>
  //translate 5*x  
  
  //rotate 90*y  
     translate -5*z
 translate -1*y             
} }








//end bar 
 
//start fire alarm box
  
#declare Falhandle =
union{ 
union{ 
cylinder
{
  -1*z,  1*z,  .3
  scale <.9,.3,.3>
  scale <2,2,1> 
  translate .70*y 
  translate .5*z
  pigment {color White}
 
}

text
{
  ttf             
  "crystal.ttf",  
  "PULL",      
  2,              
  0 
  scale <.3,.3,2>
  translate .55*y
  translate -.3*x  
  translate -1.5*z            
}
translate -2*z}

 
cylinder
{
  -1*z,  .9*z,  .32   
  scale <1,.4,.3>
  pigment {color Black} 
  translate -1.0*z 
  translate .35*y 
  scale <2,2,1>
} 



text
{
  ttf            
  "crystal.ttf",  
  "L",      
  2,              
  0 
  scale <.3,.3,.3>
  pigment {color White}
  translate -.25*z  
  //translate -.3*y             
}
text
{
  ttf            
  "crystal.ttf",  
  "I",      
  2,              
  0   
  
   scale <.3,.3,.3>
  pigment {color White} 
  translate -.25*z  
  translate -.3*y                 
}

text
{
  ttf            
  "crystal.ttf",  
  "F",      
  2,              
  0    
  
  
   scale <.3,.3,.3>
  pigment {color White} 
  translate -.25*z   
  translate -.6*y                
}

text
{
  ttf            
  "crystal.ttf",  
  "T",      
  2,              
  0 
  
   scale <.3,.3,.3>
  pigment {color White} 
  translate -.25*z
  translate -.9*y                   
}
box
{
  <-1, -1, -1>  
  < 1,  1,  1>    
  scale <.3,1,.1>
  pigment {color Red}  
} 
difference{
difference {
box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  scale <1,.15,.1> 
  translate .85*y 
  pigment {color Red}
    
}  

box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  scale <1.1,.15,.3> 
  translate .65*y 
   
  pigment {color Red}
    
}   }  


cylinder
{
 -2*z,  2*z,  .25
  pigment {color Red}
  translate 1.0*x
  translate .8*y 
  translate 1.5*z
}

cylinder
{
 -2*z,  2*z,  .25
  pigment {color Red}
  translate -1.0*x
  translate .8*y 
  translate 1.5*z
} }

cylinder
{
 -1*z,  1*z,  .25
  pigment {color Red}
  translate -.5*x
  translate .8*y 
  translate .899*z
} 

cylinder
{
 -1*z,  1*z,  .25
  pigment {color Red}
  translate .5*x
  translate .8*y 
  translate .899*z
} 
difference{
box
{
  <-1, -1, -1>  
  < 1,  1,  1>
  scale < .55,.30,.1> 
  translate .6*y
  pigment {color Red} 
} 


 cylinder
{
 -1*z,  1*z,  .25
  pigment {color Red} 
  scale <1,1,2>
  translate .6*x
  translate .3*y 
  translate .899*z
}

 cylinder
{
 -1*z,  1*z,  .25
  pigment {color Red} 
  scale <1,1,2>
  translate -.6*x
  translate .3*y 
  translate .899*z
}

 } 


difference {
cylinder
{
  -.35*x,  .35*x,  .5
  pigment {color Red}
  
} 

 cylinder
{
  -.4*x,  .4*x,  .5 
  translate .2*z 
  pigment {color Red}
  
}  scale <.95,1,1> translate .5*z translate -1.0*y} 


 




#declare Fal =
union{

box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,1.5,.5> 
  pigment {color .7*Red}
} 
box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  scale <1,1.5,.5>  
  scale <.8,.8,1>
  pigment {color .8*Red}
  translate -.2*z
}

text
{
  ttf             
  "crystal.ttf",  
  "FIRE ALARM",      
  2,             
  0 
  scale <.28,.28,1>
  translate -.7*x   
  translate .85*y
  pigment {color White}
  translate -1.2*z             
}

text
{
  ttf             
  "crystal.ttf",  
  "F.D. N.Y.",      
  2,             
  0 
  scale <.35,.35,1>
  translate -.75*x   
  translate -1*y
  pigment {color White}
  translate -1.2*z             
}
cylinder
{
  -.75*x,  .75*x,  .1
  translate -.75*z 
  translate .55*y
  pigment {color .8*Green}
}
cylinder
{
  -.75*x,  -.55*x,  .13
  translate -.75*z 
  translate .55*y 
  pigment {color .8*Blue}
} 
cylinder
{
  .55*x,  .75*x,  .13
  translate -.75*z 
  translate .55*y 
  
  pigment {color .8*Blue}
  
}

}     }

#declare Fabox =
union{
object {Fal
scale <5,5,1> }  
object{Falhandle scale<2,2,2> translate -2*z  }  
}   
                     
//end fire alram box                      
 
 
 
// start diner

  
# declare Stool =
union { 

sor
{
    7, 
    <0.000000, 0.000000> 
    <0.9, 0.000000>
    <0.85, 0.540084>
    <0.6, 0.827004>
    <0.55, 0.962025>
    <0.3, 1.000000>
    <0.2, 1.033755>
    texture {T_Silver_1A}
    translate -3*y 
    scale <1.0.75,1.0>
    
}

cylinder
{
  -2*y,  3*y,  .2
  texture {T_Silver_1A}
 }
cylinder
{
  3*y,  3.4*y,  1
  texture {T_Silver_1A} 
  
 } 

sphere
{
  <0, 3.3, 0> 
  0.9      
  scale <1,.2,1> 
  pigment{color Red}
  translate 2.8*y
} rotate -20*x   }
 
 







  
#declare Trimdecor =
difference{
box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
}

cylinder
{
 -3*y,  3*y,  1
 translate 1*z
 translate 1*x
  
}
cylinder
{
 -3*y,  3*y,  1
 translate -1*z
 translate 1*x
  
}
cylinder
{
 -3*y,  3*y,  1
 translate 1*z
 translate -1*x
  
}
cylinder
{
 -3*y,  3*y,  1
 translate -1*z
 translate -1*x
  
}
 }
#declare Trimdeco =  
union{
difference{
object {Trimdecor scale <1.3,1.3,1.3> pigment {color Black}}
object {Trimdecor scale <1,1.4,1.0> pigment {color Black}}}
object {Trimdecor texture {T_Silver_1A}} rotate 90*x }  

#declare Qtb =
difference {

torus
{
  0.9,
  0.05 
    translate 1*z
} 


box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
    scale <1,2,2> 
  translate 1*x
  
  
}  

box
{
  <-1, -1, -1>  
  < 1,  1,  1>
  scale <2,2,1 >  
  translate 2*z
    
  
} }

#declare Neonb =
union{
object {Qtb pigment{color NeonBlue}  }

cylinder
{
  0*x,  3.5*x,  .05
   open 
   translate 0*x
   translate .11*z
   pigment {color 1.5*NeonBlue}
   
} 
cylinder
{
  0*x,  3*x,  .05
   open   
   rotate 90*y
   translate -.9*x  
   pigment {color 1.5NeonBlue}
   translate 4*z
}  


}


#declare Dinface =
union{
object {Qtb texture {T_Silver_1A}}

cylinder
{
  0*x,  5*x,  .05
   open 
   translate 0*x
   translate .11*z
   texture {T_Silver_1A}
   
} 
cylinder
{
  0*x,  3*x,  .05
   open   
   rotate 90*y
   translate -.9*x  
   texture {T_Silver_1A}
   translate 4*z
}  


}



 
#declare Restw =
union {
difference{
cylinder
{
  -1*y,  1*y,  1  
  texture {T_Old_Glass}
  hollow
  
}

box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  translate 1*x
  texture {T_Old_Glass} 
  hollow
}
 
 

box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  translate 1*z 
  texture {T_Old_Glass}
  hollow
} }


box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  translate 1*x
  texture {T_Old_Glass} 
  hollow
}
 
 

box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  translate 1*z 
  texture {T_Old_Glass}
  hollow
} }

#declare Restw2 =
union {
difference{
cylinder
{
  -1*y,  1*y,  1  
  texture {T_Silver_5A}
  hollow
  
}

box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  translate 1*x
  texture {T_Silver_5A} 
  hollow
}
 
 

box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  translate 1*z 
  texture {T_Silver_5A}
  hollow
} }


box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  translate 1*x
  texture {T_Silver_5A} 
  hollow
}
 
 

box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  translate 1*z 
  texture {T_Silver_5A}
  hollow
} } 
#declare Restbk = 

union {

cylinder
{
  -1*y,  1*y,  1  
  texture {T_Silver_5A}
  
  
}

box
{
  <-1, -1, -1>  
  < 1,  1,  1>
  scale <3,1,1>
  translate 1.75*x  
  translate 1*x
  texture  {T_Silver_5A} 
  
  hollow
}
 
 

box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  translate 1*z 
  texture {T_Silver_5A}
} }  
#declare Resttrim = 

union {

cylinder
{
  -1*y,  1*y,  1  
  pigment {color NeonBlue}
  
  
}

box
{
  <-1, -1, -1>  
  < 1,  1,  1>
  scale <3,1,1>
  translate 1.75*x  
  translate 1*x
  pigment {color NeonBlue}
  
  hollow
}
 
 

box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  translate 1*z 
  pigment {color NeonBlue}
}scale <1,.3,1>
translate 2*y }


#declare Rest =
union{   
object {Dinface  scale <1,2.5,.2> translate <0,-.5,-1.6>  } 
object {Dinface  scale <1,2.5,.2> translate <0,-.8,-1.6>  } 
object {Dinface  scale <1,2.5,.2> translate <0,-1.1,-1.6>  }                                     
object {Stool scale <.2,.2,.2> translate 1*y}
object {Trimdeco scale <.2,.2,.2>  translate -.8*z translate 1.95*y translate -.2*x rotate 30*y}
object {Trimdeco scale <.2,.2,.2>  translate -.9*z translate 1.98*y translate -.1*x rotate 20*y}
object {Trimdeco scale <.2,.2,.2>  translate -1.0*z translate 1.95*y}
object {Trimdeco scale <.2,.2,.2>  translate -1*z translate .5*x translate 1.95*y} 
object {Trimdeco scale <.2,.2,.2>  translate -1*z translate 1*x translate 1.95*y} 
object {Trimdeco scale <.2,.2,.2>  translate -1*z translate .5*x translate 1.95*y} 
object {Trimdeco scale <.2,.2,.2>  translate -1*z translate 1.5*x translate 1.95*y}
object {Trimdeco scale <.2,.2,.2>  translate -1*z translate 2*x translate 1.95*y} 
object {Trimdeco scale <.2,.2,.2>  translate -1*z translate 2.5*x translate 1.95*y}
object {Trimdeco scale <.2,.2,.2>  translate -1*z translate 3*x translate 1.95*y} 
object {Trimdeco scale <.2,.2,.2>  translate -1*z translate 3.5*x translate 1.95*y}
object {Trimdeco scale <.2,.2,.2>  translate -1*z translate 4*x translate 1.95*y} 
object {Trimdeco scale <.2,.2,.2>  translate -1*z translate 4.5*x translate 1.95*y}


object {Resttrim scale <1.1,1,1.1>} 
object {Resttrim scale <1.1,1.4,1.5>  translate -.02*z translate -.02*x translate -3.8*y}
difference{
object {Restbk scale <1.02,3,1.02> translate -1*y} 
object {Restw2 scale <1.1,.6,1.1>}}
object {Restw scale <1,.6,1>} 
difference{
torus
{
  0.38,
  0.05
} 
box  {
<-1, -1, -1>  
  < 1,  1,  1>
  translate -1*x
    } pigment {color 1.2*NeonBlue}  rotate 90*x translate 3.3*x translate -1.1*z translate 1.15*y}


    
box  {
<-1, -1, -1>  
  < 1,  1,  1>
  pigment {color Gray30}
  scale <20,1,20>
  translate -2.7*y
    }  
//side walk    
union{  
cylinder
{
  -1*y,  1*y,  1  
  pigment {color Gray}
  
  
}

box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  translate 1*x
 pigment {color Gray} 
 scale <12,1,1> }
box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  translate 1*z 
  
  pigment {color Gray}
  
}
scale <1.7,.1,1.7>
translate -1.5*y 
 } 

text
{
  ttf             
  "crystal.ttf",  
  "EVELYN'S DINER",      
  .2,              
  0  
  pigment {color Red}
  scale <.5,.5,.5>
  translate .98*y  
  translate -.3*x
  translate -1.3*z
  //rotate 4*z            
} 


difference {
object {Restw}
object {Restw
scale <1,1.2,1>
translate .1*z
translate .1*x}

translate .5*x} 


object {Neonb 
translate -.2*x
translate -1.3*z
translate .75*y}  
object {Neonb
translate -1.3*z 
translate -.2*x
translate 1.5*y}                 
               
  } 
#declare Dinscene =
union{ 
object {Rest}

box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  
  scale <4,10,1> 
  translate 5.5*x
 
  pigment
  {
    brick      color Gray, color Firebrick
    brick_size <.3,.2,.2>   
    mortar     0.05       
  }
  translate -5*y 
  translate 2.5*z
}

 }


   




//end diner 
 
//start street light
 
 #declare Qtbk =
difference {

torus
{
  0.9,
  0.2 
  pigment {color Gray20} 
  translate 1*z
} 


box
{
  <-1, -1, -1>  
  < 1,  1,  1> 
  pigment {color Gray20}
  scale <1,2,2> 
  translate 1*x
  
  
}  

box
{
  <-1, -1, -1>  
  < 1,  1,  1>
  scale <2,2,1 >  
  translate 2*z
  pigment {color Gray20}
  
  
} }
#declare Est =
union{

box
{
  <-1, -1, -1>  
  < 1,  1,  1>
  scale <1.8,.5,.4>
  pigment {color White} 
   
} 

box
{
  <-1, -1, -1>  
  < 1,  1,  1>
  scale <2.1,1.0,.25>
  pigment {color Gray20} 
   
} 
text {
ttf             
  "crystal.ttf",  
  "E.34ST",     
  2,              
  0    
  translate -.72*z
  translate -1.4*x
  translate -.3*y
  pigment {color Gray20} 

  
}  }    

 #declare Av5 =
union{

box
{
  <-1, -1, -1>  
  < 1,  1,  1>
  scale <1.8,.5,.4>
  pigment {color White} 
   
} 

box
{
  <-1, -1, -1>  
  < 1,  1,  1>
  scale <2.1,1.0,.25>
  pigment {color Gray20} 
   
} 
text {
ttf             
  "crystal.ttf",  
  "5th AV",     
  2,              
  0    
  translate -1*z   
  translate -1.4*x
  translate -.3*y
  pigment {color Gray20} 

  
}  }  


  
#declare Ltshade = 
union{
difference { 
difference{
cylinder
{
  0*x,  .75*x,  .5
  pigment {color Gray20}
} 
cylinder
{
  -.1*x,  1.1*x,  .5 
  scale <.95,.95,.6>
  pigment {color Gray20}
}
cylinder
{
  -1*x,  1*x,  .7 
  scale <5,.6,.6> 
  translate -.168*y
  translate -.2*x  
  translate .2*z
  rotate 90*y
  pigment {color Green}
} 
box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
translate -.385*x 
  translate -1.1*y  
  pigment {color Magenta}
}

 }
difference {
box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  translate -.5*x
  pigment {color Red}
}

cylinder
{
  -1*x,  1*x,  .5 
  scale <10,1,1>
  rotate 90*y     
  translate .6*x
  translate .8*y
  pigment {color Red}
}

translate -.1*x 
translate -.1*y}



//translate -.8*x
//translate -.2*y
}

sphere
{
  <0,0, 0> 
  0.6       
  scale <.87,.87,.2>
  pigment {color Red}

 //translate .25*z 
 translate -.3*x
 //translate -1.1*y


} 


 }


 
#declare Slpole =
union{

cylinder
{
  0*y,  5*y,  1
  pigment {color Gray20}
}
cylinder
{
 0*y,  5*y,  .25
  translate .5*y
  
 pigment {color Gray20}
  }
cylinder
{
 0*y,  5*y,  .2
  translate 1*x
  
 pigment {color Gray20}
  }
cylinder
{
  0*y,  5*y,  .2
  translate -1*x
    pigment {color Gray20}
}translate -2*y
scale <.4,1,.4>}
#declare Lampole = union{
object {Slpole
scale <1,5,1>} 
object {Slpole
scale <1,5,1>
rotate 30*y} 
object {Slpole
scale <1,5,1>
rotate 60*y} 
 object {Slpole
scale <1,5,1>
rotate 90*y}
object {Slpole
scale <1,5,1>
rotate 120*y}
object {Slpole
scale <1,5,1>
rotate 150*y}  }
#declare  Slbase =

sor
{
    7, 
    <0.000000, 0.000000> 
    <.01, 1>
    <1, 1.1>
    <1.1, 1.2>
    <1.3, 1.3>
    <.8, 1.35>
    <1.1, 1.4>
    pigment {color Gray20}
}




#declare Ltbulb =
union{
sor
{
    11, 
    <0.000000, 0.000000> 
    <0.8, 0.000000>
    <0.9, 0.2>
    <0.8, 0.3>
    <0.7, 0.5>
    <0.6, .6>
    <0.5, .7>
    <0.46, .9>
    <.2, 1> 
    <.1, 1.2>
     <.1, 1.4>
    pigment {color Gray20}  
 scale <1,2.2,1>   
} 

sphere
{
  <0, 0, 0> 
  0.7 
  pigment {color Yellow}
  scale <1,1.2,1>      
  
} }
#declare Lamp =
union{  

object {Slbase   rotate 180*z scale <1,10,1>  translate -10*y} 

object {Est  scale <.75,.75,.75> translate -2*x rotate -30*y translate -6.7*y translate -2*z}
object {Av5 scale <.75,.75,.75> translate 2*x translate -7*y}

sphere
{
  <0, 1, 0> 
  0.8       
  pigment {color Gray20} 
  translate 5*y
  
}

cylinder
{
  -3*x,  3*x,  .15
  pigment {color Gray20}
  translate 6*y
}
cylinder
{
  -8*y,  6*y,  .20
  pigment {color Gray20}
} 






object {Ltbulb      translate 3.6*x     translate 2.6*y } 
    
object {Ltbulb     translate -3.6*x     translate 2.6*y }   
    
object {Slpole  scale <1,4,1> translate -16*y} 
object {Slpole  scale <.75,4,.75> translate -14*y} 

sor
{
    16, 
    <0.000000, 0.000000> 
    <0.2, 0.000000>
    <0.50253, 0.3>
    <0.65, 0.35>
    <0.62, 0.4>
    <0.20, .41>
    <0.2, .6> 
     <0.4, .8> 
    <0.45, .85>
    <0.4, 0.9>
    <0.2, 1.2>
    <0.3, 1.3>
    <.4,1.4>
    <.3,1.5>
    <.2,1.6>
    <.1,1.7>
      translate 6.65*y  
      scale <.5,1,.5>
} 


sor
{
    8, 
    <0.000000, 0.000000> 
    <0.5, 0.000000>
    <0.55, 0.1>
    <0.5, 0.2>
    <0.2, 0.4>
    <0.25, .6>
    <0.4, .8> 
     
    <0.45, .85>
    
      translate 4.55*y  
      scale <.9,1,.9>
} 
sor
{
    8, 
    <0.000000, 0.000000> 
    <0.5, 0.000000>
    <0.55, 0.1>
    <0.5, 0.2>
    <0.2, 0.4>
    <0.25, .6>
    <0.4, .8> 
     
    <0.45, .85>
    
      translate -2*y  
      scale <.9,1,.9>   
      
} 
object {Qtbk 

rotate 90*x
translate -2.7*x
translate 6.1*y} 
object {Qtbk 
rotate 90*x
rotate 180*y
translate 2.7*x
translate 6.1*y}  
 sphere
{
  <0, 1, 0> 
  0.8       
  pigment {color Gray20} 
  translate -5*y 
  } scale <.2,.2,.2> }
  
//end street light
//begin traffic light
#declare Oneway =
union{

box
{
  <-1, -1, -1>  
  < 1,  1,  1>
  scale <2,.5,.4>
  pigment {color White} 
   
} 

box
{
  <-1, -1, -1>  
  < 1,  1,  1>
  scale <3.0,1.0,.25>
  pigment {color Black} 
   
} 


prism {
  linear_sweep 
  linear_spline 
  -0.5,        
   0.5,       
  4,          
  
  < -1,0>, < 1,0>, < 0,1.44>, < -1,0>
  pigment {color White}
  rotate 90*x
  rotate 90*z  
  translate 1.5*x
  
}  } 


#declare Ltshade = 
union{
difference { 
difference{
cylinder
{
  0*x,  .75*x,  .5
  pigment {color Black}
} 
cylinder
{
  -.1*x,  1.1*x,  .5 
  scale <.95,.95,.6>
  pigment {color Black}
}
cylinder
{
  -1*x,  1*x,  .7 
  scale <5,.6,.6> 
  translate -.168*y
  translate -.2*x  
  translate .2*z
  rotate 90*y
  pigment {color
  Black}
} 
box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
translate -.35*x

 
  translate -1.1*y  
  pigment {color Black}
}

 }
difference {
box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  translate -.5*x
  pigment {color Black}
}

cylinder
{
  -1*x,  1*x,  .5 
  scale <10,1,1>
  rotate 90*y     
  translate .6*x
  translate .8*y
  pigment {color Black}
}

translate -.1*x 
translate -.1*y}



//translate -.8*x
//translate -.2*y
}

sphere
{
  <0,0, 0> 
  0.6       
  scale <.2,.8,.8>
  pigment {color Red}

 //translate 2*z 
 translate .75*x
 //translate -1.1*y


} 
difference{
cylinder
{
  -.5*x,  .75*x,  .5
  pigment {color Black}  
  translate .75*x
} 
 
cylinder
{
  -.6*x,  .8*x,  .45
  pigment {color Black}  
  translate .75*x
}  
 
translate .5*x 
 
 }  }
#declare Ltshadeg = 
union{
difference { 
difference{
cylinder
{
  0*x,  .75*x,  .5
  pigment {color Black}
} 
cylinder
{
  -.1*x,  1.1*x,  .5 
  scale <.95,.95,.6>
  pigment {color Black}
}
cylinder
{
  -1*x,  1*x,  .7 
  scale <5,.6,.6> 
  translate -.168*y
  translate -.2*x  
  translate .2*z
  rotate 90*y
  pigment {color
  Black}
} 
box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
translate -.35*x

 
  translate -1.1*y  
  pigment {color Black}
}

 }
difference {
box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  translate -.5*x
  pigment {color Black}
}

cylinder
{
  -1*x,  1*x,  .5 
  scale <10,1,1>
  rotate 90*y     
  translate .6*x
  translate .8*y
  pigment {color Black}
}

translate -.1*x 
translate -.1*y}



//translate -.8*x
//translate -.2*y
}

sphere
{
  <0,0, 0> 
  0.6       
  scale <.2,.8,.8>
  pigment {color .2*Green}

 //translate 2*z 
 translate .75*x
 //translate -1.1*y


} 
difference{
cylinder
{
  -.5*x,  .75*x,  .5
  pigment {color Black}  
  translate .75*x
} 
 
cylinder
{
  -.6*x,  .8*x,  .45
  pigment {color Black}  
  translate .75*x
}  
 
translate .5*x 
 
 }  }


#declare Slpole =
union{

cylinder
{
  0*y,  5*y,  1
  pigment {color Black}
}
cylinder
{
 0*y,  5*y,  .25
  translate .5*y
  
 pigment {color Gray30}
  }
cylinder
{
 0*y,  5*y,  .2
  translate 1*x
  
 pigment {color Gray30}
  }
cylinder
{
  0*y,  5*y,  .2
  translate -1*x
    pigment {color Gray30}
}translate -2*y
scale <.6,1,.6>} 





#declare  Slbase =

sor
{
    7, 
    <0.000000, 0.000000> 
    <0.9, 0.000000>
    <0.9, .8>
    <0.8, 0.827004>
    <0.7, 0.962025>
    <0.6, 1.000000>
    <0.55, 1.033755>  
    translate -2*y 
    scale <.5,1.5,.5>
    pigment {color Gray30}
}  

#declare Trflight =
union{ 

union{object {Slpole
scale <1,5,1>} 
object {Slpole
scale <1,5,1>
rotate 30*y} 
object {Slpole
scale <1,5,1>
rotate 60*y} 
 object {Slpole
scale <1,5,1>
rotate 90*y}
object {Slpole
scale <1,5,1>
rotate 120*y}
object {Slpole
scale <1,5,1>
rotate 150*y} translate -9*y }  





  
union{object {Slpole
scale <1,5,1>} 
object {Slpole
scale <1,5,1>
rotate 30*y} 
object {Slpole
scale <1,5,1>
rotate 60*y} 
 object {Slpole
scale <1,5,1>
rotate 90*y}
object {Slpole
scale <1,5,1>
rotate 120*y}
object {Slpole
scale <1,5,1>
rotate 150*y}scale <.75,1,.75> } 
 union{
object {Oneway }

text
{
  ttf             
  "crystal.ttf",  
  "ONE WAY",     
  2,              
  0    
  
  pigment {color Black} 
  translate -2*z 
  translate -.3*y
  translate -1.3*x           
} 
translate -1*z  
translate 5*y
}
union{
object {Oneway



rotate 180*z}
 text
{
  ttf             
  "crystal.ttf",  
  "ONE WAY",     
  1,              
  0 
  pigment {color Black} 
  translate -1*z  
  translate -1.7*x
  translate -.35*y
    
} 
translate 16.5*y
translate -.5*z}
union{
object {Ltshade 
scale <2,2,2> 
translate -3*x
rotate 90*y

}   

object {Ltshade 
scale <2,2,2>

translate -3*x}

object {Ltshade 
scale <2,2,2>
translate -3*x
rotate 180*y}

object {Ltshade 
scale <2,2,2> 
rotate 270*y
translate -3*z}

translate 14*y  }
 

object {Slbase
scale <3,3,3>
translate -10*y}  
union{
object {Ltshadeg 
scale <2,2,2> 
translate -3.0*x
rotate 90*y

}   

object {Ltshadeg 
scale <2,2,2>

translate -3.0*x}

object {Ltshadeg 
scale <2,2,2>
translate -3.0*x
rotate 180*y}

object {Ltshadeg 
scale <2,2,2> 
rotate 270*y
translate -3.0*z}

translate 11.5*y  } }



//end traffic light  
 
#declare Sidewalk =
union {
difference{
cylinder
{
  -1*y,  1*y,  1  
  pigment{color Magenta}
  
  
}

box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  translate 1*x
  pigment {Magenta}
  
}
 
 

box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  translate 1*z 
   pigment {Magenta}
  
} }


box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  translate 1*x
   pigment {Magenta} 
  
}
 
 

box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
  translate 1*z 
   pigment {Magenta}
  
}scale <1,1,1> rotate 90*y translate 2.5*x  translate 4.8*y}  
     


object {Rest translate 1.3*x }  
object {Theater scale <.2,.2,.2> translate -1*x translate 5.5*z  rotate -90*y} 
object {Bar scale <.5,.5,.5> translate -5*x rotate -90*y translate 25*z} 
//object {Fmale scale <.1,.1,.1> translate -4*z translate -.1*y ] 
object {Fabox scale <.02,.02,.02> translate 3.3*x translate -2.5*z translate -.5*y}

object {Taxi rotate 90*y
scale <.1,.1,.1>
translate -2.5*z
translate -1.2*y} 
 
object {Taxi rotate -90*y
scale <.1,.1,.1>
translate -4*z 
translate -2*x
translate -1.2*y}   
 
object {Taxi rotate -180*y
scale <.1,.1,.1>
translate .5*z 
translate -2.5*x
translate -1.2*y}
object {Lamp translate -2.5*z translate .5*y}

object {Bcar
scale <.1,.1,.1>
translate -1*x
translate 1.5*z translate -.5*y} 

object {Rcar
scale <.1,.1,.1>
translate -1*x
translate -1.5*z translate -.5*y}  
 object {Rcar
scale <.1,.1,.1>
rotate -90*y
translate 3*x
translate -4*z translate -1.2*y}                     
                     
object {Trflight scale <.1,.1,.1> translate -3.3*x translate -2.5*z translate .5*y}                     
object{Sidewalk rotate 180*y translate -4*x translate -8*y} 
object {Dinscene}