//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 2 lights, 7 materials and 119 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 06/20/2000    (20.06.2000)
// 

// Copyright 2000  Johannes Ewers

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 2.2
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.094,0.184,0.337> }

fog {
  fog_type 1    // Constant
  distance     120.0
  color <0.035294,0.235294,0.396078,-0.019608,-0.788235>
  turbulence   <0.0,0.5,0.0>
    omega      0.5
    lambda     2.0
    octaves    6
    turb_depth 20.0
}

fog {
  fog_type 2    // Ground Fog
  distance     30.0
  color <0.015686,0.584314,0.666667,0.0,-0.87451>
  turbulence   <0.5,0.5,0.5>
    omega      0.5
    lambda     2.0
    octaves    6
    turb_depth 4.0
  up           <0,0,1>
  fog_offset   0.0
  fog_alt      -8.0
}

fog {
  fog_type 2    // Ground Fog
  distance     30.0
  color <0.0,0.0,0.454902,0.0,0.039216>
  turbulence   <0.0,0.0,1.0>
    omega      0.5
    lambda     2.0
    octaves    6
    turb_depth 2.0
  up           <0,0,1>
  fog_offset   -80.0
  fog_alt      1.0
}

camera {  //  Camera StdCam
  location  <     -0.276,     -43.523,     -32.747>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.36548,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         45.00000    // Vertical      33.750
  look_at   <     -2.262,      42.408,     -41.306>
}

//
// *******  L I G H T S *******
//

light_source {   // Light2
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  scale <3.047324, 1.0, -0.023662>
  translate  <34.548833, 42.692637, 233.972597>
}

light_source {   // Light1
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.5713
  scale <3.047324, 1.0, -0.023662>
  translate  <41.942925, 160.372334, 24.184199>
}


//
// ********  MATERIALS  *******
//

#include "kelp-00.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare leaf07 = object { // leaf07
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.809401, -0.472729, -1.232974>, <13.703770, -24.780233, -10.934627>, <26.871347, 31.720515, -17.627248>, <33.932905, -11.772944, -3.387386>, 
      <-0.008574, -0.326277, -0.271549>, <13.703770, -24.225439, -10.934627>, <26.871347, 32.275308, -17.627248>, <38.059312, -18.417342, -1.234177>, 
      <-0.008574, 0.228517, -0.271549>, <13.703770, -23.670645, -10.934627>, <26.871347, 32.830102, -17.627248>, <38.059312, -17.862548, -1.234177>, 
      <2.809401, 0.579140, -1.232974>, <13.703770, -23.115851, -10.934627>, <26.871347, 33.384896, -17.627248>, <33.932905, -10.108563, -3.387386>
    }
  }
  rotate <0.0, 0.0, 0.0>
  translate  <0.0, 0.11175, -0.0>
  material {
    kelpMskin
  }
  scale 0.1
  rotate 6.710013*z
  translate  -0.011175*y
}
#declare leaf06 = object { // leaf06
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.186358, -0.365449, 0.611816>, <13.525317, -7.768592, 16.501444>, <23.530623, 10.824013, 11.008310>, <32.122798, 3.755912, 3.848398>, 
      <0.143679, -0.241696, 0.000000>, <13.557051, -5.708970, 16.501444>, <23.530623, 12.118796, 11.008310>, <35.195413, 4.260313, 2.187755>, 
      <0.143679, 0.227110, 0.000000>, <13.525829, -3.154355, 16.501444>, <23.530623, 13.411518, 11.008310>, <35.195413, 4.729118, 2.187755>, 
      <3.186358, 0.523389, 0.611816>, <13.462949, -1.574384, 16.501444>, <23.508343, 14.331788, 11.008310>, <32.122798, 5.162329, 3.848398>
    }
  }
  material {
    kelpMskin
  }
  scale 0.1
  rotate -9.566662*z
}
#declare leaf05 = object { // leaf05
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.757404, -0.469827, 0.262207>, <9.895075, -0.913433, 13.758119>, <15.600618, -10.425796, -19.222737>, <24.038290, -0.913433, -17.553103>, 
      <0.195935, -0.310728, 0.000000>, <9.895075, -0.310728, 13.758119>, <15.600618, -9.823091, -19.222737>, <25.813586, -0.264967, -15.124545>, 
      <0.195935, 0.291977, 0.000000>, <9.895075, 0.291977, 13.758119>, <15.600618, -9.220386, -19.222737>, <25.813586, 0.337738, -15.124545>, 
      <2.757404, 0.672879, 0.262207>, <9.895075, 0.894681, 13.758119>, <15.600618, -8.617682, -19.222737>, <24.038290, 0.894681, -17.553103>
    }
  }
  material {
    kelpMskin
  }
  scale 0.1
  rotate 3.854669*z
}
#declare leaf04 = object { // leaf04
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.357430, -0.298293, 0.127065>, <12.710914, 12.625732, 17.650821>, <25.637983, -0.779164, 6.791029>, <31.682858, 1.576184, 16.786974>, 
      <-0.151757, -0.125828, 0.127065>, <12.710914, 13.279067, 17.650821>, <25.637983, -0.125828, 6.791029>, <37.206645, 4.815654, 19.378515>, 
      <-0.151757, 0.527507, 0.127065>, <12.710914, 13.932403, 17.650821>, <25.637983, 0.527507, 6.791029>, <37.206645, 5.468989, 19.378515>, 
      <1.357430, 0.940407, 0.127065>, <12.710914, 14.585738, 17.650821>, <25.637983, 1.180843, 6.791029>, <31.682858, 3.536191, 16.786974>
    }
  }
  material {
    kelpMskin
  }
  scale 0.1
  rotate -5.137404*z
}
#declare leaf03 = object { // leaf03
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.834611, -0.554709, 0.677463>, <15.837395, -19.159463, 19.646427>, <21.482034, -19.159463, -18.911801>, <33.482963, -1.078459, -2.928174>, 
      <0.154195, -0.366866, 0.000000>, <15.837395, -15.517971, 19.646427>, <21.482034, -15.517971, -18.911801>, <37.993357, -0.312837, -2.928174>, 
      <0.154195, 0.344727, 0.000000>, <15.837395, -11.876478, 19.646427>, <21.482034, -11.876478, -18.911801>, <37.993357, 0.398756, -2.928174>, 
      <4.834611, 0.794445, 0.677463>, <15.837395, -8.234985, 19.646427>, <21.482034, -8.234985, -18.911801>, <33.482963, 1.056319, -2.928174>
    }
  }
  material {
    kelpMskin
  }
  scale 0.1
  rotate 1.884795*z
}
#declare leaf02 = object { // leaf02
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.312990, -1.623149, 0.000000>, <15.319809, 13.171743, -10.873877>, <26.207790, -23.356324, 19.177621>, <34.698618, -2.325013, -0.117738>, 
      <0.584505, -1.371425, 0.000000>, <15.319809, 14.125330, -10.873877>, <26.207790, -22.402737, 19.177621>, <40.564849, -1.299023, -4.462668>, 
      <0.584505, -0.417838, 0.000000>, <15.319809, 15.078917, -10.873877>, <26.207790, -21.449150, 19.177621>, <40.564849, -0.345436, -4.462668>, 
      <5.312990, 0.184817, 0.000000>, <15.319809, 16.032504, -10.873877>, <26.207790, -20.495563, 19.177621>, <34.698618, 0.535749, -0.117738>
    }
  }
  material {
    kelpMskin
  }
  scale 0.1
  rotate 2.293438*z
}
#declare leaf01 = object { // leaf01
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.098976, -0.862926, 1.307588>, <18.268947, -1.365416, 1.330501>, <21.443132, 12.141484, 17.987732>, <28.362257, -0.956286, 11.199557>, 
      <-0.070563, -0.682708, 0.075883>, <18.268947, -0.682708, 1.330501>, <21.443132, 12.824104, 17.981510>, <30.253640, -0.274481, 10.332033>, 
      <-0.070563, 0.000000, 0.075883>, <18.268947, 0.000000, 1.330501>, <21.443132, 13.506724, 17.975288>, <30.253640, 0.408139, 10.325811>, 
      <4.098976, 0.431463, 1.307588>, <18.268947, 0.682708, 1.330501>, <21.443132, 14.189344, 17.969066>, <28.362257, 1.091575, 11.180891>
    }
  }
  material {
    kelpMskin
  }
  scale 0.1
  rotate <-0.246886, 4.605617, -3.071748>
}
#declare stem00 = object {
  cylinder { // stem00
    <0,0,1>, <0,0,0>, 1 
    material {
      kelpMskin
    }
    scale <0.2, 0.2, 2.0>
  }
}
#declare plantseg00 = union { // plantseg00
  object { // leaf21->leaf07
    leaf07
    rotate -60.0*z
    translate  <-0.058845, 0.154891, 0.529678>
  }
  object { // leaf20->leaf07
    leaf07
    rotate 19.532621*z
    translate  <-0.10115, 0.057716, 1.402314>
  }
  object { // leaf18->leaf06
    leaf06
    rotate 10.391731*z
    translate  <-0.11664, -0.009703, 0.392127>
  }
  object { // leaf17->leaf05
    leaf05
    rotate 99.59201*z
    translate  <0.019606, -0.204516, 0.490057>
  }
  object { // leaf16->leaf05
    leaf05
    rotate 14.857734*z
    translate  <-0.116241, -0.024134, 0.833628>
  }
  object { // leaf15->leaf04
    leaf04
    rotate 146.747635*z
    translate  <0.057821, -0.067924, 0.773481>
  }
  object { // leaf14->leaf04
    leaf04
    rotate 15.75919*z
    translate  <-0.067924, -0.043541, 1.440914>
  }
  object { // leaf12->leaf03
    leaf03
    rotate 68.51532*z
    translate  <-0.05822, -0.22293, 0.945828>
  }
  object { // leaf11->leaf02
    leaf02
    rotate -138.304855*z
    translate  <0.213475, 0.150527, 1.656482>
  }
  object { // leaf10->leaf02
    leaf02
    rotate -60.232296*z
    translate  <-0.164758, 0.238106, 0.7551>
  }
  object { // leaf08->leaf01
    leaf01
    rotate <0.0, -0.0, -100.531288>
    translate  <0.009504, 0.135848, 1.083481>
  }
  object { // stem01->stem00
    stem00
  }
}
#declare kelpplantB00 = union { // kelpplantB00
  object { // plantseg32->plantseg00
    plantseg00
    scale <1.5, 1.5, 1.0>
    rotate 170.0*z
    translate  <-0.009341, -0.056975, 19.685391>
  }
  object { // plantseg33->plantseg00
    plantseg00
    rotate <6.564039, 6.521382, -134.62561>
    translate  <0.198592, 0.0, 17.725026>
  }
  object { // plantseg34->plantseg00
    plantseg00
    rotate -80.0*z
    translate  <0.198592, 0.0, 15.755579>
  }
  object { // plantseg35->plantseg00
    plantseg00
    scale <1.5, 1.5, 1.0>
    rotate <-2.514711, 5.375258, -25.118069>
    translate  <0.015276, 0.0, 13.801408>
  }
  object { // plantseg36->plantseg00
    plantseg00
    rotate 30.0*z
    translate  <0.045829, 0.0, 11.83196>
  }
  object { // plantseg37->plantseg00
    plantseg00
    rotate <-5.731249, -0.500571, 85.025047>
    translate  <0.229145, 0.0, 9.877789>
  }
  object { // plantseg38->plantseg00
    plantseg00
    rotate <4.221974, -5.014161, 139.815033>
    translate  <0.015276, 0.0, 7.923618>
  }
  object { // plantseg39->plantseg00
    plantseg00
    scale <1.5, 1.5, 1.0>
    rotate -165.0*z
    translate  <0.01242, 0.0, 5.950319>
  }
  object { // plantseg40->plantseg00
    plantseg00
    rotate <3.042158, 1.106597, -109.970619>
    translate  <0.119013, 0.0, 3.978361>
  }
  object { // plantseg41->plantseg00
    plantseg00
    rotate <-2.823131, 1.975195, -55.048676>
    translate  2.0*z
  }
  object { // plantseg42->plantseg00
    plantseg00
  }
  scale <2.0, 2.0, 2.5>
  rotate -55.0*z
}


#declare kelpplantA00 = union { // kelpplantA00
  object { // plantseg21->plantseg00
    plantseg00
    rotate <3.024273, -8.247818, -20.2181>
    translate  <0.157829, 0.0, 39.280999>
  }
  object { // plantseg20->plantseg00
    plantseg00
    rotate 35.0*z
    translate  <0.140293, 0.0, 37.333609>
  }
  object { // plantseg19->plantseg00
    plantseg00
    scale <1.5, 1.5, 1.0>
    rotate <9.717345, -0.0, 90.0>
    translate  <-0.192903, 0.0, 35.438829>
  }
  object { // plantseg18->plantseg00
    plantseg00
    rotate 145.0*z
    translate  <-0.210439, 0.0, 33.544048>
  }
  object { // plantseg17->plantseg00
    plantseg00
    rotate <3.789021, 10.290565, -159.658676>
    translate  <0.152763, 0.0, 31.679197>
  }
  object { // plantseg16->plantseg00
    plantseg00
    scale <1.5, 1.5, 1.0>
    rotate -105.0*z
    translate  <0.307941, 0.0, 29.606298>
  }
  object { // plantseg15->plantseg00
    plantseg00
    rotate <-3.382715, 2.834472, -50.083706>
    translate  <-0.015276, 0.0, 27.740302>
  }
  object { // plantseg14->plantseg00
    plantseg00
    rotate <-0.518858, -5.909449, 5.026781>
    translate  <0.16804, 0.0, 25.801408>
  }
  object { // plantseg13->plantseg00
    plantseg00
    rotate 60.0*z
    translate  <0.183316, 0.0, 23.923618>
  }
  object { // plantseg12->plantseg00
    plantseg00
    scale <1.3, 1.3, 1.0>
    rotate <4.258461, -1.983133, 114.92627>
    translate  <0.030553, 0.0, 21.984724>
  }
  object { // plantseg11->plantseg00
    plantseg00
    rotate 170.0*z
    translate  <0.030553, 0.0, 20.137487>
  }
  object { // plantseg10->plantseg00
    plantseg00
    rotate <6.564039, 6.521382, -134.62561>
    translate  <0.198592, 0.0, 17.725026>
  }
  object { // plantseg09->plantseg00
    plantseg00
    rotate -80.0*z
    translate  <0.198592, 0.0, 15.755579>
  }
  object { // plantseg08->plantseg00
    plantseg00
    scale <1.5, 1.5, 1.0>
    rotate <-2.514711, 5.375258, -25.118069>
    translate  <0.015276, 0.0, 13.801408>
  }
  object { // plantseg07->plantseg00
    plantseg00
    rotate 30.0*z
    translate  <0.045829, 0.0, 11.83196>
  }
  object { // plantseg06->plantseg00
    plantseg00
    rotate <-5.731249, -0.500571, 85.025047>
    translate  <0.229145, 0.0, 9.877789>
  }
  object { // plantseg05->plantseg00
    plantseg00
    rotate <4.221974, -5.014161, 139.815033>
    translate  <0.015276, 0.0, 7.923618>
  }
  object { // plantseg04->plantseg00
    plantseg00
    scale <1.5, 1.5, 1.0>
    rotate -165.0*z
    translate  <0.01242, 0.0, 5.950319>
  }
  object { // plantseg03->plantseg00
    plantseg00
    rotate <3.042158, 1.106597, -109.970619>
    translate  <0.119013, 0.0, 3.978361>
  }
  object { // plantseg02->plantseg00
    plantseg00
    rotate <-2.823131, 1.975195, -55.048676>
    translate  2.0*z
  }
  object { // plantseg01->plantseg00
    plantseg00
  }
  scale <2.8, 2.8, 2.5>
  translate  <0.428362, 0.0, -0.520151>
}






















//
// ********  OBJECTS  *******
//



#declare wingMleftMtop1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.000536, -4.441828, 0.000000>, <-0.766239, -3.955211, 0.000000>, <-2.990828, -3.036046, -0.438185>, <-3.541221, -2.657566, 0.000000>, 
      <0.028131, -1.909886, 0.350170>, <-0.948525, -1.909886, 0.116723>, <-3.964062, -1.927909, -0.250391>, <-4.836123, -1.621520, 1.502347>, 
      <0.028131, -0.909886, 0.350170>, <-0.948525, -0.909886, 0.116723>, <-4.000107, -1.018023, -0.250391>, <-4.854145, -1.216274, 1.502347>, 
      <0.019119, -0.063080, 0.350170>, <-0.948525, 0.009011, 0.116723>, <-3.477927, -0.018023, -0.125196>, <-4.468508, -0.108137, 0.907668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.019119, -0.063080, 0.350170>, <-0.948525, 0.009011, 0.116723>, <-3.477927, -0.018023, -0.125196>, <-4.468508, -0.108137, 0.907668>, 
      <0.010108, 0.783726, 0.350170>, <-0.948525, 0.927909, 0.116723>, <-2.955747, 0.981977, 0.000000>, <-4.082871, 1.000000, 0.312989>, 
      <0.010108, 1.891863, 0.350170>, <-0.856353, 1.927909, 0.000000>, <-2.252856, 2.036046, 0.000000>, <-3.306924, 2.018023, -0.187793>, 
      <-0.018559, 2.711634, 0.000000>, <0.008744, 3.648822, 0.000000>, <-0.378480, 4.045325, 0.000000>, <-2.153462, 2.945931, 0.000000>
    }
  }
  material {
    mantaMtopMskin
  }
}
#declare wingMleftMbottom1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.000536, -4.441828, 0.000000>, <-0.766239, -3.955211, 0.000000>, <-2.990828, -3.036046, -0.438185>, <-3.541221, -2.657566, 0.000000>, 
      <0.004786, -1.909886, -0.303481>, <-1.018559, -1.909886, -0.233447>, <-3.987406, -1.927909, -0.390459>, <-4.836123, -1.621520, 1.502347>, 
      <0.004786, -0.909886, -0.303481>, <-1.018559, -0.909886, -0.233447>, <-4.023452, -1.018023, -0.390459>, <-4.854145, -1.216274, 1.502347>, 
      <-0.004225, -0.063080, -0.303481>, <-1.018559, 0.009011, -0.233447>, <-3.501272, -0.018023, -0.265264>, <-4.468508, -0.108137, 0.907668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.004225, -0.063080, -0.303481>, <-1.018559, 0.009011, -0.233447>, <-3.501272, -0.018023, -0.265264>, <-4.468508, -0.108137, 0.907668>, 
      <-0.013237, 0.783726, -0.303481>, <-1.018559, 0.927909, -0.233447>, <-2.979091, 0.981977, -0.140068>, <-4.082871, 1.000000, 0.312989>, 
      <-0.013237, 1.891863, -0.303481>, <-0.856353, 1.927909, 0.000000>, <-2.252856, 2.036046, 0.000000>, <-3.306924, 2.018023, -0.187793>, 
      <-0.018559, 2.711634, 0.000000>, <0.008744, 3.648822, 0.000000>, <-0.378480, 4.045325, 0.000000>, <-2.153462, 2.945931, 0.000000>
    }
  }
  material {
    mantaMbottomMskin
  }
}
#declare wingMrightMbottom1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000536, -4.441828, 0.000000>, <0.766239, -3.955211, 0.000000>, <2.990828, -3.036046, -0.438185>, <3.541221, -2.657566, 0.000000>, 
      <-0.004786, -1.909886, -0.303481>, <1.018559, -1.909886, -0.233447>, <3.987406, -1.927909, -0.390459>, <4.836123, -1.621520, 1.502347>, 
      <-0.004786, -0.909886, -0.303481>, <1.018559, -0.909886, -0.233447>, <4.023452, -1.018023, -0.390459>, <4.854145, -1.216274, 1.502347>, 
      <0.004225, -0.063080, -0.303481>, <1.018559, 0.009011, -0.233447>, <3.501272, -0.018023, -0.265264>, <4.468508, -0.108137, 0.907668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.004225, -0.063080, -0.303481>, <1.018559, 0.009011, -0.233447>, <3.501272, -0.018023, -0.265264>, <4.468508, -0.108137, 0.907668>, 
      <0.013237, 0.783726, -0.303481>, <1.018559, 0.927909, -0.233447>, <2.979091, 0.981977, -0.140068>, <4.082871, 1.000000, 0.312989>, 
      <0.013237, 1.891863, -0.303481>, <0.856353, 1.927909, 0.000000>, <2.252856, 2.036046, 0.000000>, <3.306924, 2.018023, -0.187793>, 
      <0.018559, 2.711634, 0.000000>, <-0.008744, 3.648822, 0.000000>, <0.378480, 4.045325, 0.000000>, <2.153462, 2.945931, 0.000000>
    }
  }
  material {
    mantaMbottomMskin
  }
}
#declare wingMrightMtop1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000536, -4.441828, 0.000000>, <0.766239, -3.955211, 0.000000>, <2.990828, -3.036046, -0.438185>, <3.541221, -2.657566, 0.000000>, 
      <-0.028131, -1.909886, 0.350170>, <0.948525, -1.909886, 0.116723>, <3.964062, -1.927909, -0.250391>, <4.836123, -1.621520, 1.502347>, 
      <-0.028131, -0.909886, 0.350170>, <0.948525, -0.909886, 0.116723>, <4.000107, -1.018023, -0.250391>, <4.854145, -1.216274, 1.502347>, 
      <-0.019119, -0.063080, 0.350170>, <0.948525, 0.009011, 0.116723>, <3.477927, -0.018023, -0.125196>, <4.468508, -0.108137, 0.907668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.019119, -0.063080, 0.350170>, <0.948525, 0.009011, 0.116723>, <3.477927, -0.018023, -0.125196>, <4.468508, -0.108137, 0.907668>, 
      <-0.010108, 0.783726, 0.350170>, <0.948525, 0.927909, 0.116723>, <2.955747, 0.981977, 0.000000>, <4.082871, 1.000000, 0.312989>, 
      <-0.010108, 1.891863, 0.350170>, <0.856353, 1.927909, 0.000000>, <2.252856, 2.036046, 0.000000>, <3.306924, 2.018023, -0.187793>, 
      <0.018559, 2.711634, 0.000000>, <-0.008744, 3.648822, 0.000000>, <0.378480, 4.045325, 0.000000>, <2.153462, 2.945931, 0.000000>
    }
  }
  material {
    mantaMtopMskin
  }
}
#declare bodyMright1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.000173, -3.515722, 0.000000>, <0.512857, -3.264631, 0.000000>, <0.768474, -2.975876, 0.000000>, <1.925036, -2.373256, 0.000000>, 
      <-0.023574, -1.709791, 0.980700>, <0.559659, -1.719432, 0.299758>, <0.803576, -1.797673, 0.000000>, <2.229251, -1.772564, 0.000000>, 
      <-0.023574, -1.209535, 0.980700>, <0.544027, -1.259753, 2.808185>, <0.117892, -1.209535, 0.010985>, <2.428161, -1.284862, 0.000000>, 
      <-0.023574, -0.872488, 0.980700>, <0.558789, -0.918048, 1.592522>, <0.489985, -0.910152, 0.005493>, <2.428161, -0.947815, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.023574, -0.872488, 0.980700>, <0.558789, -0.918048, 1.592522>, <0.489985, -0.910152, 0.005493>, <2.428161, -0.947815, 0.000000>, 
      <-0.023574, -0.535441, 0.980700>, <0.573551, -0.576343, 0.376860>, <0.862079, -0.610769, 0.000000>, <2.428161, -0.610769, 0.000000>, 
      <0.020665, 0.843635, 0.910696>, <0.559659, 0.768307, 0.547494>, <0.873779, 0.818525, 0.000000>, <2.229251, 0.655316, 0.000000>, 
      <-0.011874, 3.478168, 0.000000>, <0.618162, 3.490722, 0.000000>, <0.920582, 2.938321, 0.000000>, <2.053742, 1.143018, 0.000000>
    }
  }
  material {
    mantaMtopMskin
  }
  translate  <0.0, -0.213489, -0.046217>
}
#declare eyeMgroupMright1 = union {
  sphere { // Sphere004
    <0,0,0>,1
    material {
      eyeMskin
    }
    scale <1.349977, 1.383294, 0.585911>
  }
  torus { // Torus003
    2.5, 1.5  rotate -x*90
    sturm
    material {
      mantaMtopMskin
    }
    scale <1.0, 1.0, 0.5>
  }
  scale 0.06
  rotate <2.366691, 49.930527, -11.269181>
  translate  <0.648579, -1.781849, 0.625053>
}
#declare tail1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.704756, 0.066144, 0.000000>, <-1.176152, -1.769149, 0.000000>, <1.176152, -1.769149, 0.000000>, <0.704756, 0.066147, 0.000000>, 
      <-0.704756, 0.066144, 8.953636>, <-1.176152, -1.769149, 8.953636>, <1.176152, -1.769149, 8.953636>, <0.704756, 0.066147, 8.953636>, 
      <0.377236, -0.215883, 21.231885>, <-0.094159, -1.769149, 21.513913>, <2.258144, -1.769149, 21.513913>, <1.786749, 0.066147, 21.513913>, 
      <-0.143834, 0.862354, 28.488482>, <-0.635155, -0.490114, 28.664227>, <1.717148, -0.490114, 28.664227>, <1.265678, 1.003376, 28.669320>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.704756, 0.066147, 0.000000>, <0.233361, 1.901442, 0.000000>, <-0.233361, 1.901438, 0.000000>, <-0.704756, 0.066144, 0.000000>, 
      <0.704756, 0.066147, 8.953636>, <0.233361, 1.901442, 8.953636>, <-0.233361, 1.901438, 8.953636>, <-0.704756, 0.066144, 8.953636>, 
      <1.786749, 0.066147, 21.513913>, <1.315354, 1.901442, 21.513913>, <0.848631, 1.337382, 20.949857>, <0.377236, -0.215883, 21.231885>, 
      <1.265678, 1.003376, 28.669320>, <0.814208, 2.496866, 28.674413>, <0.347487, 2.214822, 28.312737>, <-0.143834, 0.862354, 28.488482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.143834, 0.862354, 28.488482>, <-0.635155, -0.490114, 28.664227>, <1.717148, -0.490114, 28.664227>, <1.265678, 1.003376, 28.669320>, 
      <-0.664905, 1.940592, 35.745079>, <-1.176152, 0.788922, 35.814542>, <1.176152, 0.788922, 35.814542>, <0.744607, 1.940606, 35.824728>, 
      <-1.714789, 3.295671, 42.620353>, <-1.905326, 2.432375, 42.617250>, <-0.623686, 2.432375, 42.612151>, <-1.045326, 3.483704, 42.617837>, 
      <-4.693928, 4.789870, 49.588617>, <-4.828305, 3.932919, 49.586096>, <-3.760760, 3.932919, 49.581849>, <-4.172429, 4.883893, 49.586479>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.265678, 1.003376, 28.669320>, <0.814208, 2.496866, 28.674413>, <0.347487, 2.214822, 28.312737>, <-0.143834, 0.862354, 28.488482>, 
      <0.744607, 1.940606, 35.824728>, <0.313063, 3.092290, 35.834914>, <-0.153658, 3.092263, 35.675616>, <-0.664905, 1.940592, 35.745079>, 
      <-1.045326, 3.483704, 42.617837>, <-1.466967, 4.535032, 42.623524>, <-1.524252, 4.158968, 42.623456>, <-1.714789, 3.295671, 42.620353>, 
      <-4.172429, 4.883893, 49.586479>, <-4.584098, 5.834866, 49.591109>, <-4.559552, 5.646820, 49.591138>, <-4.693928, 4.789870, 49.588617>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.693928, 4.789870, 49.588617>, <-4.828305, 3.932919, 49.586096>, <-3.760760, 3.932919, 49.581849>, <-4.172429, 4.883893, 49.586479>, 
      <-7.673068, 6.284068, 56.556880>, <-7.751284, 5.433464, 56.554942>, <-6.897834, 5.433464, 56.551546>, <-7.299531, 6.284082, 56.555120>, 
      <-12.996524, 8.384766, 66.590789>, <-13.018580, 7.634517, 66.589433>, <-12.379225, 7.634517, 66.586889>, <-12.770951, 8.384779, 66.589406>, 
      <-4.614742, 17.717495, 78.122743>, <-4.580638, 17.067602, 78.121969>, <-4.155378, 17.067602, 78.120277>, <-4.537132, 17.717509, 78.121737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.172429, 4.883893, 49.586479>, <-4.584098, 5.834866, 49.591109>, <-4.559552, 5.646820, 49.591138>, <-4.693928, 4.789870, 49.588617>, 
      <-7.299531, 6.284082, 56.555120>, <-7.701229, 7.134700, 56.558693>, <-7.594851, 7.134672, 56.558819>, <-7.673068, 6.284068, 56.556880>, 
      <-12.770951, 8.384779, 66.589406>, <-13.162676, 9.135042, 66.591923>, <-12.974468, 9.135015, 66.592146>, <-12.996524, 8.384766, 66.590789>, 
      <-4.537132, 17.717509, 78.121737>, <-4.918887, 18.367416, 78.123198>, <-4.648846, 18.367389, 78.123517>, <-4.614742, 17.717495, 78.122743>
    }
  }
  material {
    mantaMtopMskin
  }
  scale 0.15
  rotate <91.862434, 0.0, 180.0>
  translate  <0.141049, 0.190397, 0.09567>
}
#declare bodyMleft1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000173, -3.515722, 0.000000>, <-0.512857, -3.264631, 0.000000>, <-0.768474, -2.975876, 0.000000>, <-1.925036, -2.373256, 0.000000>, 
      <0.023574, -1.709791, 0.980700>, <-0.559659, -1.719432, 0.299758>, <-0.803576, -1.797673, 0.000000>, <-2.229251, -1.772564, 0.000000>, 
      <0.023574, -1.209535, 0.980700>, <-0.544027, -1.259753, 2.808185>, <-0.117892, -1.209535, 0.010985>, <-2.428161, -1.284862, 0.000000>, 
      <0.023574, -0.872488, 0.980700>, <-0.558789, -0.918048, 1.592522>, <-0.489985, -0.910152, 0.005493>, <-2.428161, -0.947815, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.023574, -0.872488, 0.980700>, <-0.558789, -0.918048, 1.592522>, <-0.489985, -0.910152, 0.005493>, <-2.428161, -0.947815, 0.000000>, 
      <0.023574, -0.535441, 0.980700>, <-0.573551, -0.576343, 0.376860>, <-0.862079, -0.610769, 0.000000>, <-2.428161, -0.610769, 0.000000>, 
      <-0.020665, 0.843635, 0.910696>, <-0.559659, 0.768307, 0.547494>, <-0.873779, 0.818525, 0.000000>, <-2.229251, 0.655316, 0.000000>, 
      <0.011874, 3.478168, 0.000000>, <-0.618162, 3.490722, 0.000000>, <-0.920582, 2.938321, 0.000000>, <-2.053742, 1.143018, 0.000000>
    }
  }
  material {
    mantaMtopMskin
  }
  translate  <0.0, -0.2131, -0.04594>
}
#declare eyeMgroupMleft1 = union {
  sphere { // Sphere005
    <0,0,0>,1
    material {
      eyeMskin
    }
    scale <1.349977, 1.383294, 0.585911>
  }
  torus { // Torus004
    2.5, 1.5  rotate -x*90
    material {
      mantaMtopMskin
    }
    scale <1.0, 1.0, 0.5>
  }
  scale 0.06
  rotate <-2.36669, -49.930531, 11.26918>
  translate  <-0.596981, -1.758976, 0.588905>
}
union { // manta1
  object { wingMleftMtop1 }
  object { wingMleftMbottom1 }
  object { wingMrightMbottom1 }
  object { wingMrightMtop1 }
  object { bodyMright1 }
  object { eyeMgroupMright1 }
  object { tail1 }
  object { bodyMleft1 }
  object { eyeMgroupMleft1 }
  scale 2.0
  rotate <-5.6588, 6.09874, 23.669748>
  translate  <-11.761342, 33.107287, -37.668666>
}


cylinder { // deepMwater
  <0,0,1>, <0,0,0>, 1 open
  material {
    deepMblueMtex
  }
  hollow
  scale <1500.0, 180.0, 270.0>
  translate  <-2.902718, -9.963168, -150.0>
}


union { // plantgroup
  object { // kelpplantB03->kelpplantB00
    kelpplantB00
    rotate -8.083864*y
    translate  <39.842685, 77.201827, 8.110166>
  }
  object { // kelpplantB02->kelpplantB00
    kelpplantB00
    rotate <15.001253, -3.967453, -75.522575>
    translate  <-30.519254, 58.599887, -7.027824>
  }
  object { // kelpplantB01->kelpplantB00
    kelpplantB00
    rotate -13.640701*y
    translate  <31.813545, 27.907095, 2.298032>
  }
  object { // kelpplantA06->kelpplantA00
    kelpplantA00
    rotate <3.1574, -4.497691, -35.124023>
    translate  <-31.336129, 141.909612, -5.204794>
  }
  object { // kelpplantA05->kelpplantA00
    kelpplantA00
    rotate <0.0, -5.66866, -130.0>
    translate  <39.957483, 134.764475, 5.813367>
  }
  object { // kelpplantA04->kelpplantA00
    kelpplantA00
    rotate -35.0*z
    translate  <29.103353, 152.786806, -0.0>
  }
  object { // kelpplantA03->kelpplantA00
    kelpplantA00
    rotate <0.0, -15.669125, -0.0>
    translate  <-8.340771, 157.971565, -8.236442>
  }
  object { // kelpplantA02->kelpplantA00
    kelpplantA00
    rotate <-10.372744, 5.426719, -44.824696>
    translate  <4.418644, 147.673661, -2.703826>
  }
  object { // kelpplantA01->kelpplantA00
    kelpplantA00
    rotate <2.918841, 3.162333, 19.956284>
    translate  <-37.672036, 80.210778, -0.811862>
  }
  object { // kelpplantB04->kelpplantB00
    kelpplantB00
    scale <1.0, 1.0, 2.0>
    rotate -0.0*y
    translate  <-7.625222, 159.452182, -6.949012>
  }
  translate  <-3.235528, 0.0, -68.738867>
}




#declare stoneMA20 = union {
  superellipsoid { // SuperQ041
    <0.1, 0.5>
    material {
      algaeMskinMbig
    }
    scale <7.356646, 5.5, 5.5>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  superellipsoid { // SuperQ042
    <0.1, 0.5>
    material {
      algaeMskinMgreen
    }
    scale <6.68786, 5.0, 5.0>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.304664, -12.685903, 46.736843>
  scale 0.8
  rotate <-0.0, 35.503326, -49.134827>
  translate  <-14.530891, 2.933853, -64.877586>
}
#declare stoneMA19 = union {
  superellipsoid { // SuperQ039
    <0.1, 0.5>
    material {
      algaeMskinMbig
    }
    scale <7.356646, 5.5, 5.5>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  superellipsoid { // SuperQ040
    <0.1, 0.5>
    material {
      algaeMskinMgreen
    }
    scale <6.68786, 5.0, 5.0>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.304664, -12.685903, 46.736843>
  scale 1.2
  rotate <47.135773, 31.190821, 45.731483>
  translate  <-1.62772, 16.26867, -64.551439>
}
#declare stoneMA07 = union {
  superellipsoid { // SuperQ037
    <0.1, 0.5>
    material {
      algaeMskinMbig
    }
    scale <7.356646, 5.5, 5.5>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  superellipsoid { // SuperQ038
    <0.1, 0.5>
    material {
      algaeMskinMgreen
    }
    scale <6.68786, 5.0, 5.0>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.304664, -12.685903, 46.736843>
  rotate <17.564505, 19.768734, -40.859455>
  translate  <14.483299, 17.367743, -61.332517>
}
#declare seaMbottom = union {
  plane { // seaMBottomM2
    z,0
    material {
      algaeMskinMgreen
    }
    hollow
    translate  -62.0*z
  }
  plane { // seaMbottomM1
    z,0
    material {
      algaeMskinMbig
    }
    hollow
    scale <0.5, 0.5, 1.0>
    translate  -60.106238*z
  }
  rotate <8.569123, -0.0, -0.0>
  translate  <-0.0, 0.220461, -11.885849>
}
#declare stoneMA18 = union {
  superellipsoid { // SuperQ035
    <0.1, 0.5>
    material {
      algaeMskinMbig
    }
    scale <7.356646, 5.5, 5.5>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  superellipsoid { // SuperQ036
    <0.1, 0.5>
    material {
      algaeMskinMgreen
    }
    scale <6.68786, 5.0, 5.0>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.304664, -12.685903, 46.736843>
  scale 2.5
  rotate <-14.636575, -26.31764, -88.593422>
  translate  <-62.898288, 124.696694, -39.630633>
}
#declare stoneMA16 = union {
  superellipsoid { // SuperQ031
    <0.1, 0.5>
    material {
      algaeMskinMbig
    }
    scale <7.356646, 5.5, 5.5>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  superellipsoid { // SuperQ032
    <0.1, 0.5>
    material {
      algaeMskinMgreen
    }
    scale <6.68786, 5.0, 5.0>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.304664, -12.685903, 46.736843>
  scale 2.0
  rotate <48.15567, -4.721283, 23.744934>
  translate  <-36.038877, 99.707182, -47.034927>
}
#declare stoneMA15 = union {
  superellipsoid { // SuperQ029
    <0.1, 0.5>
    material {
      algaeMskinMbig
    }
    scale <7.356646, 5.5, 5.5>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  superellipsoid { // SuperQ030
    <0.1, 0.5>
    material {
      algaeMskinMgreen
    }
    scale <6.68786, 5.0, 5.0>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.304664, -12.685903, 46.736843>
  scale 1.5
  rotate <57.030552, -36.717381, 48.45961>
  translate  <19.28903, 78.387105, -48.901339>
}
#declare stoneMA14 = union {
  superellipsoid { // SuperQ027
    <0.1, 0.5>
    material {
      algaeMskinMbig
    }
    scale <7.356646, 5.5, 5.5>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  superellipsoid { // SuperQ028
    <0.1, 0.5>
    material {
      algaeMskinMgreen
    }
    scale <6.68786, 5.0, 5.0>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.304664, -12.685903, 46.736843>
  scale 2.0
  rotate <24.113506, -26.862795, -44.729214>
  translate  <39.760653, 71.363642, -54.077257>
}
#declare stoneMA13 = union {
  superellipsoid { // SuperQ025
    <0.1, 0.5>
    material {
      algaeMskinMbig
    }
    scale <7.356646, 5.5, 5.5>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  superellipsoid { // SuperQ026
    <0.1, 0.5>
    material {
      algaeMskinMgreen
    }
    scale <6.68786, 5.0, 5.0>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.304664, -12.685903, 46.736843>
  scale 2.0
  rotate <7.667385, 30.834723, 14.716444>
  translate  <-32.193985, 25.207081, -67.74121>
}
#declare stoneMA12 = union {
  superellipsoid { // SuperQ023
    <0.1, 0.5>
    material {
      algaeMskinMbig
    }
    scale <7.356646, 5.5, 5.5>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  superellipsoid { // SuperQ024
    <0.1, 0.5>
    material {
      algaeMskinMgreen
    }
    scale <6.68786, 5.0, 5.0>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.304664, -12.685903, 46.736843>
  scale 2.0
  rotate <-45.504868, -19.214157, 18.518326>
  translate  <-5.908483, 129.618912, -46.763944>
}
#declare stoneMA11 = union {
  superellipsoid { // SuperQ021
    <0.1, 0.5>
    material {
      algaeMskinMbig
    }
    scale <7.356646, 5.5, 5.5>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  superellipsoid { // SuperQ022
    <0.1, 0.5>
    material {
      algaeMskinMgreen
    }
    scale <6.68786, 5.0, 5.0>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.304664, -12.685903, 46.736843>
  scale 2.0
  rotate <-8.950954, -29.589893, 0.0>
  translate  <33.262324, 44.628005, -63.618765>
}
#declare stoneMA10 = union {
  superellipsoid { // SuperQ017
    <0.1, 0.5>
    material {
      algaeMskinMbig
    }
    scale <7.356646, 5.5, 5.5>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  superellipsoid { // SuperQ018
    <0.1, 0.5>
    material {
      algaeMskinMgreen
    }
    scale <6.68786, 5.0, 5.0>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.304664, -12.685903, 46.736843>
  scale <2.0, 2.0, 4.0>
  rotate <-23.105556, -8.423579, -18.949858>
  translate  <53.375151, 125.290655, -48.265307>
}
#declare stoneMA08 = union {
  superellipsoid { // SuperQ015
    <0.1, 0.5>
    material {
      algaeMskinMbig
    }
    scale <7.356646, 5.5, 5.5>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  superellipsoid { // SuperQ016
    <0.1, 0.5>
    material {
      algaeMskinMgreen
    }
    scale <6.68786, 5.0, 5.0>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.304664, -12.685903, 46.736843>
  scale 2.0
  rotate <-22.443653, -0.0, 0.0>
  translate  <56.704511, 83.043234, -49.367059>
}
#declare stoneMA09 = union {
  superellipsoid { // SuperQ019
    <0.1, 0.5>
    material {
      algaeMskinMbig
    }
    scale <7.356646, 5.5, 5.5>
    rotate <-0.202722, -0.37508, -1.947566>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  superellipsoid { // SuperQ020
    <0.1, 0.5>
    material {
      algaeMskinMgreen
    }
    scale <6.68786, 5.0, 5.0>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.304664, -12.685903, 46.736843>
  scale <1.902882, 2.272425, 1.0>
  rotate <23.43364, -14.06955, 7.429184>
  translate  <-9.392363, 56.793922, -58.142488>
}
#declare stoneMA05 = union {
  superellipsoid { // SuperQ011
    <0.1, 0.5>
    material {
      algaeMskinMbig
    }
    scale <7.356646, 5.5, 5.5>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  superellipsoid { // SuperQ012
    <0.1, 0.5>
    material {
      algaeMskinMgreen
    }
    scale <6.68786, 5.0, 5.0>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.304664, -12.685903, 46.736843>
  scale 2.0
  rotate <-0.0, 35.503326, -49.134827>
  translate  <24.790082, 27.225835, -70.174367>
}
#declare stoneMA00 = union {
  superellipsoid { // SuperQ002
    <0.1, 0.5>
    material {
      algaeMskinMbig
    }
    scale <7.356646, 5.5, 5.5>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  superellipsoid { // SuperQ001
    <0.1, 0.5>
    material {
      algaeMskinMgreen
    }
    scale <6.68786, 5.0, 5.0>
    translate  <-1.265895, 12.704045, -46.416149>
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.304664, -12.685903, 46.736843>
  scale <2.0, 1.0, 1.0>
  rotate <18.411179, -19.499313, -13.948883>
  translate  <-2.799457, 33.655936, -62.888603>
}
union { // seaMbottomMgroup
  object { stoneMA20 }
  object { stoneMA19 }
  object { stoneMA07 }
  object { seaMbottom }
  object { stoneMA18 }
  object { stoneMA16 }
  object { stoneMA15 }
  object { stoneMA14 }
  object { stoneMA13 }
  object { stoneMA12 }
  object { stoneMA11 }
  object { stoneMA10 }
  object { stoneMA08 }
  object { stoneMA09 }
  object { stoneMA05 }
  object { stoneMA00 }
  scale <0.8, 0.8, 0.666667>
  rotate <-12.90903, -0.0, -0.0>
  translate  <-5.677721, 28.580076, -17.021775>
}


#declare wingMleftMtop = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.000536, -4.441828, 0.000000>, <-0.766239, -3.955211, 0.000000>, <-2.990828, -3.036046, -0.438185>, <-3.541221, -2.657566, 0.000000>, 
      <0.028131, -1.909886, 0.350170>, <-0.948525, -1.909886, 0.116723>, <-3.964062, -1.927909, -0.250391>, <-4.836123, -1.621520, 1.502347>, 
      <0.028131, -0.909886, 0.350170>, <-0.948525, -0.909886, 0.116723>, <-4.000107, -1.018023, -0.250391>, <-4.854145, -1.216274, 1.502347>, 
      <0.019119, -0.063080, 0.350170>, <-0.948525, 0.009011, 0.116723>, <-3.477927, -0.018023, -0.125196>, <-4.468508, -0.108137, 0.907668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.019119, -0.063080, 0.350170>, <-0.948525, 0.009011, 0.116723>, <-3.477927, -0.018023, -0.125196>, <-4.468508, -0.108137, 0.907668>, 
      <0.010108, 0.783726, 0.350170>, <-0.948525, 0.927909, 0.116723>, <-2.955747, 0.981977, 0.000000>, <-4.082871, 1.000000, 0.312989>, 
      <0.010108, 1.891863, 0.350170>, <-0.856353, 1.927909, 0.000000>, <-2.252856, 2.036046, 0.000000>, <-3.306924, 2.018023, -0.187793>, 
      <-0.018559, 2.711634, 0.000000>, <0.008744, 3.648822, 0.000000>, <-0.378480, 4.045325, 0.000000>, <-2.153462, 2.945931, 0.000000>
    }
  }
  material {
    mantaMtopMskin
  }
}
#declare wingMleftMbottom = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.000536, -4.441828, 0.000000>, <-0.766239, -3.955211, 0.000000>, <-2.990828, -3.036046, -0.438185>, <-3.541221, -2.657566, 0.000000>, 
      <0.004786, -1.909886, -0.303481>, <-1.018559, -1.909886, -0.233447>, <-3.987406, -1.927909, -0.390459>, <-4.836123, -1.621520, 1.502347>, 
      <0.004786, -0.909886, -0.303481>, <-1.018559, -0.909886, -0.233447>, <-4.023452, -1.018023, -0.390459>, <-4.854145, -1.216274, 1.502347>, 
      <-0.004225, -0.063080, -0.303481>, <-1.018559, 0.009011, -0.233447>, <-3.501272, -0.018023, -0.265264>, <-4.468508, -0.108137, 0.907668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.004225, -0.063080, -0.303481>, <-1.018559, 0.009011, -0.233447>, <-3.501272, -0.018023, -0.265264>, <-4.468508, -0.108137, 0.907668>, 
      <-0.013237, 0.783726, -0.303481>, <-1.018559, 0.927909, -0.233447>, <-2.979091, 0.981977, -0.140068>, <-4.082871, 1.000000, 0.312989>, 
      <-0.013237, 1.891863, -0.303481>, <-0.856353, 1.927909, 0.000000>, <-2.252856, 2.036046, 0.000000>, <-3.306924, 2.018023, -0.187793>, 
      <-0.018559, 2.711634, 0.000000>, <0.008744, 3.648822, 0.000000>, <-0.378480, 4.045325, 0.000000>, <-2.153462, 2.945931, 0.000000>
    }
  }
  material {
    mantaMbottomMskin
  }
}
#declare wingMrightMbottom = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000536, -4.441828, 0.000000>, <0.766239, -3.955211, 0.000000>, <2.990828, -3.036046, -0.438185>, <3.541221, -2.657566, 0.000000>, 
      <-0.004786, -1.909886, -0.303481>, <1.018559, -1.909886, -0.233447>, <3.987406, -1.927909, -0.390459>, <4.836123, -1.621520, 1.502347>, 
      <-0.004786, -0.909886, -0.303481>, <1.018559, -0.909886, -0.233447>, <4.023452, -1.018023, -0.390459>, <4.854145, -1.216274, 1.502347>, 
      <0.004225, -0.063080, -0.303481>, <1.018559, 0.009011, -0.233447>, <3.501272, -0.018023, -0.265264>, <4.468508, -0.108137, 0.907668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.004225, -0.063080, -0.303481>, <1.018559, 0.009011, -0.233447>, <3.501272, -0.018023, -0.265264>, <4.468508, -0.108137, 0.907668>, 
      <0.013237, 0.783726, -0.303481>, <1.018559, 0.927909, -0.233447>, <2.979091, 0.981977, -0.140068>, <4.082871, 1.000000, 0.312989>, 
      <0.013237, 1.891863, -0.303481>, <0.856353, 1.927909, 0.000000>, <2.252856, 2.036046, 0.000000>, <3.306924, 2.018023, -0.187793>, 
      <0.018559, 2.711634, 0.000000>, <-0.008744, 3.648822, 0.000000>, <0.378480, 4.045325, 0.000000>, <2.153462, 2.945931, 0.000000>
    }
  }
  material {
    mantaMbottomMskin
  }
}
#declare wingMrightMtop = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000536, -4.441828, 0.000000>, <0.766239, -3.955211, 0.000000>, <2.990828, -3.036046, -0.438185>, <3.541221, -2.657566, 0.000000>, 
      <-0.028131, -1.909886, 0.350170>, <0.948525, -1.909886, 0.116723>, <3.964062, -1.927909, -0.250391>, <4.836123, -1.621520, 1.502347>, 
      <-0.028131, -0.909886, 0.350170>, <0.948525, -0.909886, 0.116723>, <4.000107, -1.018023, -0.250391>, <4.854145, -1.216274, 1.502347>, 
      <-0.019119, -0.063080, 0.350170>, <0.948525, 0.009011, 0.116723>, <3.477927, -0.018023, -0.125196>, <4.468508, -0.108137, 0.907668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.019119, -0.063080, 0.350170>, <0.948525, 0.009011, 0.116723>, <3.477927, -0.018023, -0.125196>, <4.468508, -0.108137, 0.907668>, 
      <-0.010108, 0.783726, 0.350170>, <0.948525, 0.927909, 0.116723>, <2.955747, 0.981977, 0.000000>, <4.082871, 1.000000, 0.312989>, 
      <-0.010108, 1.891863, 0.350170>, <0.856353, 1.927909, 0.000000>, <2.252856, 2.036046, 0.000000>, <3.306924, 2.018023, -0.187793>, 
      <0.018559, 2.711634, 0.000000>, <-0.008744, 3.648822, 0.000000>, <0.378480, 4.045325, 0.000000>, <2.153462, 2.945931, 0.000000>
    }
  }
  material {
    mantaMtopMskin
  }
}
#declare bodyMright = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.000173, -3.515722, 0.000000>, <0.512857, -3.264631, 0.000000>, <0.768474, -2.975876, 0.000000>, <1.925036, -2.373256, 0.000000>, 
      <-0.023574, -1.709791, 0.980700>, <0.559659, -1.719432, 0.299758>, <0.803576, -1.797673, 0.000000>, <2.229251, -1.772564, 0.000000>, 
      <-0.023574, -1.209535, 0.980700>, <0.544027, -1.259753, 2.808185>, <0.117892, -1.209535, 0.010985>, <2.428161, -1.284862, 0.000000>, 
      <-0.023574, -0.872488, 0.980700>, <0.558789, -0.918048, 1.592522>, <0.489985, -0.910152, 0.005493>, <2.428161, -0.947815, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.023574, -0.872488, 0.980700>, <0.558789, -0.918048, 1.592522>, <0.489985, -0.910152, 0.005493>, <2.428161, -0.947815, 0.000000>, 
      <-0.023574, -0.535441, 0.980700>, <0.573551, -0.576343, 0.376860>, <0.862079, -0.610769, 0.000000>, <2.428161, -0.610769, 0.000000>, 
      <0.020665, 0.843635, 0.910696>, <0.559659, 0.768307, 0.547494>, <0.873779, 0.818525, 0.000000>, <2.229251, 0.655316, 0.000000>, 
      <-0.011874, 3.478168, 0.000000>, <0.618162, 3.490722, 0.000000>, <0.920582, 2.938321, 0.000000>, <2.053742, 1.143018, 0.000000>
    }
  }
  material {
    mantaMtopMskin
  }
  translate  <0.0, -0.213489, -0.046217>
}
#declare eyeMgroupMright = union {
  sphere { // Sphere002
    <0,0,0>,1
    material {
      eyeMskin
    }
    scale <1.349977, 1.383294, 0.585911>
  }
  torus { // Torus001
    2.5, 1.5  rotate -x*90
    sturm
    material {
      mantaMtopMskin
    }
    scale <1.0, 1.0, 0.5>
  }
  scale 0.06
  rotate <2.366691, 49.930527, -11.269181>
  translate  <0.648579, -1.781849, 0.625053>
}
#declare tail = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.704756, 0.066144, 0.000000>, <-1.176152, -1.769149, 0.000000>, <1.176152, -1.769149, 0.000000>, <0.704756, 0.066147, 0.000000>, 
      <-0.704756, 0.066144, 8.953636>, <-1.176152, -1.769149, 8.953636>, <1.176152, -1.769149, 8.953636>, <0.704756, 0.066147, 8.953636>, 
      <0.377236, -0.215883, 21.231885>, <-0.094159, -1.769149, 21.513913>, <2.258144, -1.769149, 21.513913>, <1.786749, 0.066147, 21.513913>, 
      <-0.143834, 0.862354, 28.488482>, <-0.635155, -0.490114, 28.664227>, <1.717148, -0.490114, 28.664227>, <1.265678, 1.003376, 28.669320>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.704756, 0.066147, 0.000000>, <0.233361, 1.901442, 0.000000>, <-0.233361, 1.901438, 0.000000>, <-0.704756, 0.066144, 0.000000>, 
      <0.704756, 0.066147, 8.953636>, <0.233361, 1.901442, 8.953636>, <-0.233361, 1.901438, 8.953636>, <-0.704756, 0.066144, 8.953636>, 
      <1.786749, 0.066147, 21.513913>, <1.315354, 1.901442, 21.513913>, <0.848631, 1.337382, 20.949857>, <0.377236, -0.215883, 21.231885>, 
      <1.265678, 1.003376, 28.669320>, <0.814208, 2.496866, 28.674413>, <0.347487, 2.214822, 28.312737>, <-0.143834, 0.862354, 28.488482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.143834, 0.862354, 28.488482>, <-0.635155, -0.490114, 28.664227>, <1.717148, -0.490114, 28.664227>, <1.265678, 1.003376, 28.669320>, 
      <-0.664905, 1.940592, 35.745079>, <-1.176152, 0.788922, 35.814542>, <1.176152, 0.788922, 35.814542>, <0.744607, 1.940606, 35.824728>, 
      <-1.714789, 3.295671, 42.620353>, <-1.905326, 2.432375, 42.617250>, <-0.623686, 2.432375, 42.612151>, <-1.045326, 3.483704, 42.617837>, 
      <-4.693928, 4.789870, 49.588617>, <-4.828305, 3.932919, 49.586096>, <-3.760760, 3.932919, 49.581849>, <-4.172429, 4.883893, 49.586479>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.265678, 1.003376, 28.669320>, <0.814208, 2.496866, 28.674413>, <0.347487, 2.214822, 28.312737>, <-0.143834, 0.862354, 28.488482>, 
      <0.744607, 1.940606, 35.824728>, <0.313063, 3.092290, 35.834914>, <-0.153658, 3.092263, 35.675616>, <-0.664905, 1.940592, 35.745079>, 
      <-1.045326, 3.483704, 42.617837>, <-1.466967, 4.535032, 42.623524>, <-1.524252, 4.158968, 42.623456>, <-1.714789, 3.295671, 42.620353>, 
      <-4.172429, 4.883893, 49.586479>, <-4.584098, 5.834866, 49.591109>, <-4.559552, 5.646820, 49.591138>, <-4.693928, 4.789870, 49.588617>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.693928, 4.789870, 49.588617>, <-4.828305, 3.932919, 49.586096>, <-3.760760, 3.932919, 49.581849>, <-4.172429, 4.883893, 49.586479>, 
      <-7.673068, 6.284068, 56.556880>, <-7.751284, 5.433464, 56.554942>, <-6.897834, 5.433464, 56.551546>, <-7.299531, 6.284082, 56.555120>, 
      <-12.996524, 8.384766, 66.590789>, <-13.018580, 7.634517, 66.589433>, <-12.379225, 7.634517, 66.586889>, <-12.770951, 8.384779, 66.589406>, 
      <-4.614742, 17.717495, 78.122743>, <-4.580638, 17.067602, 78.121969>, <-4.155378, 17.067602, 78.120277>, <-4.537132, 17.717509, 78.121737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.172429, 4.883893, 49.586479>, <-4.584098, 5.834866, 49.591109>, <-4.559552, 5.646820, 49.591138>, <-4.693928, 4.789870, 49.588617>, 
      <-7.299531, 6.284082, 56.555120>, <-7.701229, 7.134700, 56.558693>, <-7.594851, 7.134672, 56.558819>, <-7.673068, 6.284068, 56.556880>, 
      <-12.770951, 8.384779, 66.589406>, <-13.162676, 9.135042, 66.591923>, <-12.974468, 9.135015, 66.592146>, <-12.996524, 8.384766, 66.590789>, 
      <-4.537132, 17.717509, 78.121737>, <-4.918887, 18.367416, 78.123198>, <-4.648846, 18.367389, 78.123517>, <-4.614742, 17.717495, 78.122743>
    }
  }
  material {
    mantaMtopMskin
  }
  scale 0.15
  rotate <91.862434, 0.0, 180.0>
  translate  <0.141049, 0.190397, 0.09567>
}
#declare bodyMleft = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000173, -3.515722, 0.000000>, <-0.512857, -3.264631, 0.000000>, <-0.768474, -2.975876, 0.000000>, <-1.925036, -2.373256, 0.000000>, 
      <0.023574, -1.709791, 0.980700>, <-0.559659, -1.719432, 0.299758>, <-0.803576, -1.797673, 0.000000>, <-2.229251, -1.772564, 0.000000>, 
      <0.023574, -1.209535, 0.980700>, <-0.544027, -1.259753, 2.808185>, <-0.117892, -1.209535, 0.010985>, <-2.428161, -1.284862, 0.000000>, 
      <0.023574, -0.872488, 0.980700>, <-0.558789, -0.918048, 1.592522>, <-0.489985, -0.910152, 0.005493>, <-2.428161, -0.947815, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.023574, -0.872488, 0.980700>, <-0.558789, -0.918048, 1.592522>, <-0.489985, -0.910152, 0.005493>, <-2.428161, -0.947815, 0.000000>, 
      <0.023574, -0.535441, 0.980700>, <-0.573551, -0.576343, 0.376860>, <-0.862079, -0.610769, 0.000000>, <-2.428161, -0.610769, 0.000000>, 
      <-0.020665, 0.843635, 0.910696>, <-0.559659, 0.768307, 0.547494>, <-0.873779, 0.818525, 0.000000>, <-2.229251, 0.655316, 0.000000>, 
      <0.011874, 3.478168, 0.000000>, <-0.618162, 3.490722, 0.000000>, <-0.920582, 2.938321, 0.000000>, <-2.053742, 1.143018, 0.000000>
    }
  }
  material {
    mantaMtopMskin
  }
  translate  <0.0, -0.2131, -0.04594>
}
#declare eyeMgroupMleft = union {
  sphere { // Sphere003
    <0,0,0>,1
    material {
      eyeMskin
    }
    scale <1.349977, 1.383294, 0.585911>
  }
  torus { // Torus002
    2.5, 1.5  rotate -x*90
    material {
      mantaMtopMskin
    }
    scale <1.0, 1.0, 0.5>
  }
  scale 0.06
  rotate <-2.36669, -49.930531, 11.26918>
  translate  <-0.596981, -1.758976, 0.588905>
}
union { // manta
  object { wingMleftMtop }
  object { wingMleftMbottom }
  object { wingMrightMbottom }
  object { wingMrightMtop }
  object { bodyMright }
  object { eyeMgroupMright }
  object { tail }
  object { bodyMleft }
  object { eyeMgroupMleft }
  scale 2.0
  rotate <10.425126, -0.0, -42.157402>
  translate  <-1.138683, 16.688909, -41.587518>
}


