// dmbeach.pov

#include "flyingbird.inc"

// development switches
#declare Water = 1;
#declare Clouds = 1;
#declare Figure = 1;
#declare Birds = 1;
#declare Fill = 0;

// Parameters
#declare SunLight = <1.5, 1.5, 1.0>;
#declare FillLight = <0.2, 0.2, 0.2>;
#declare FogColour = <1.4, 0.7, 0.4>;

global_settings {
	number_of_waves 40
}

camera {
	location <0, 4, -10>
	look_at <0,2,0>
}

#declare Sun = sphere { <0,0,0>, 300
	texture {
		pigment { rgb <1,0.8,0.4> }
		finish { ambient 1.5 }
	}
}

#declare Sun2Ambient = 1.1;
#declare Sun2 = blob { threshold 0.5
	sphere { <0,0,0>, 2, 1
		scale <50,10,50>
		rotate <0,0,2>
		translate <0,250,0>
		texture {
			pigment { rgb <1,0.5,0.2> }
			finish { ambient Sun2Ambient }
		}
	}
	sphere { <0,0,0>, 2, 1
		scale <140,30,50>
		rotate <0,0,4>
		translate <0,200,0>
		texture {
			pigment { rgb <1,0.4,0.15> }
			finish { ambient Sun2Ambient }
		}
	}
	sphere { <0,0,0>, 2, 1
		scale <220,30,50>
		rotate <0,0,3>
		translate <0,130,0>
		texture {
			pigment { rgb <1,0.3,0.1> }
			finish { ambient Sun2Ambient }
		}
	}
	sphere { <0,0,0>, 2, 1
		scale <300,100,50>
		translate <0,0,0>
		texture {
			pigment { rgb <1,0.2,0.05> }
			finish { ambient Sun2Ambient }
		}
	}
	sphere { <0,0,0>, 2, 1
		scale <220,50,50>
		translate <0,-130,0>
		texture {
			pigment { rgb <1,0.15,0.0> }
			finish { ambient Sun2Ambient }
		}
	}
	sphere { <0,0,0>, 2, 1
		scale <160,40,50>
		translate <0,-200,0>
		texture {
			pigment { rgb <1,0.1,0.0> }
			finish { ambient Sun2Ambient }
		}
	}
	sphere { <0,0,0>, 2, 1
		scale <80,30,50>
		translate <0,-250,0>
		texture {
			pigment { rgb <1,0.1,0.0> }
			finish { ambient Sun2Ambient }
		}
	}
	texture {
		pigment { rgb <1,1,1> }
	}
}

light_source { <-400, 300, 5000>, rgb SunLight
	looks_like { Sun2 }
}

#if (Fill)
light_source { <-10, 20, 0>, rgb FillLight
}
#end

sky_sphere {
	pigment { gradient y
		colour_map {
			[0.0 rgb <0.7,0.3,0.1>]
			[0.5 rgb <0.6,0.25,0.1>]
			//[1.0 rgb <0.5,0.8,1.0>]
			[1.0 rgb <0.3,0.2,0.5>]
		}
		scale 2
		translate <0,-1,0>
	}
}

#declare Sand = texture {
	pigment {
		rgb <0.8,0.6,0.5>
	}
	normal { granite 0.3
		turbulence 0.1
		scale 0.05
	}
}

// sand dunes
torus { 6, 2
	scale <2,0.5,1>
	rotate <0,0,5>
	rotate <0,-10,0>
	translate <-2,-0.9,1>
	texture { Sand }
}

height_field { gif "dune.gif"
	smooth
	translate <-0.5,0,-0.5>
	scale <17,20,5>
	translate <-7,-0.001,0>
	texture { Sand }
}

// silhouette
#if (Figure)
//box { <0,0,0>, <1,1,0.001>
height_field { gif "silhouette4.gif"
	water_level 0.001
	scale <1,0.001,1>
	rotate <-90,0,0>
	texture {
		pigment {
			image_map { gif "silhouette3.gif"
				filter all 1
			}
		}
	}
	scale <2,2,1>
	translate <-3,0.25,7>
}
#end

#if (Birds)
// birds
object { FlyingBird
	rotate <10,40,10>
	translate <20,7,30>
}
object { FlyingBird
	rotate <-10,-10,4>
	translate <-5,7,70>
}
object { FlyingBird
	rotate <-3,-15,4>
	translate <-15,7,80>
}
object { FlyingBird
	rotate <2,4,4>
	translate <-13,9,90>
}
#declare seed1 = seed(345);
#declare i = 0;
#while (i < 30)
	object { FlyingBird
		rotate <-10+rand(seed1)*20,rand(seed1)*20,-4+rand(seed1*10)>
		translate <-50+rand(seed1)*40,7+rand(seed1)*10,100+rand(seed1)*20>
	}
	#declare i = i + 1;
#end
#end // if (Birds)

// clouds
#if (Clouds)
// simple cloud plane
plane { y, 40
	hollow
	texture {
		pigment { bozo
			colour_map {
				[0.0 rgbt <1,1,1,1>]
				[0.7 rgbt <1,1,1,1>]
				[0.8 rgbf <1,0.9,0.8,0.9>]
				[1.0 rgbf <0.7,0.6,0.6,0.9>]
			}
			turbulence 0.3
			scale 50
		}
		finish {
			ambient 0.8
		}
	}
}
// media above clouds to provide scattering and edge brightening
box { <-1000,40.001,0>, <1000,41,30000>
	hollow
	texture {
		pigment { rgbt <1,1,1,1> }
	}
	interior {
		media {
			scattering {5, rgb <0.05,0.1,0.2>
				eccentricity -0.3
			}
			density { bozo
				turbulence 0.3
				lambda 2.5
				omega 0.7
				scale <50,1,50>
			}
		}
	}
}
#end

// fog layer
fog {
	fog_type 2
	rgb FogColour
	distance 3000
	fog_offset 30
	fog_alt 20
}

// the water
#if (Water)

#macro Wave(x0,z0)
	#local WaveLength = 10;
	#local WaveDepth = 0.4;
	#local WaveRadius = 0.5;
	#local WaveD = WaveRadius - WaveDepth;
	#local TorusRadius = (WaveLength*WaveLength + WaveD*WaveD) / 2 / WaveD;
	#local FoamRadius = (WaveRadius - WaveDepth) / 2;
	#local FoamZ = z0 - sqrt(WaveRadius*WaveRadius - WaveDepth*WaveDepth);
	//cylinder { <-WaveLength,-WaveDepth,z0>, <WaveLength,-WaveDepth,z0>, WaveRadius }
	torus { TorusRadius, WaveRadius
		rotate <90,0,0>
		translate <x0,-TorusRadius-WaveDepth,z0>
	}
	
	torus { TorusRadius, FoamRadius
		rotate <90,0,0>
		translate <x0,-TorusRadius,FoamZ>
		texture {
			pigment { bozo
				colour_map {
					[0.0 rgb <1,1,1>]
					[1.0 rgbt <1,1,1,1>]
				}
				turbulence 0.7
				scale 0.1
			}
			finish {
				ambient 0.5
				//reflection 0.4
			}
		}
	}
#end // macro Wave()

// ocean plane
union {
	plane { y, 0 }
	Wave(-2,10)
	Wave(4,14)
	union { Wave(-13,22)
		translate <0,0.1,0>
	}
	texture {
		pigment { rgb <0.3,0.6,0.4> }
		normal { ripples 0.7
			frequency 50
			scale <100,30,30>
			turbulence 0.3
		}
		finish {
			reflection 0.4
		}
	}
}
// water in channel
plane { y, 0
	rotate <0.1,0,0>
	translate <0,0,7>
	texture {
		pigment { rgb <0.3,0.6,0.4> }
		/*
		normal { ripples 0.7
			frequency 100
			scale 70
			turbulence 1
			omega 0.5
		}
		*/
		normal { granite 0.7
			scale 10
			turbulence 0.1
		}
		finish {
			reflection 0.4
		}
	}
}
#end
