// flyingbird.inc
// Defines a FlyingBird object.
//
// Transforming the FlyingBird object:
// rotate <45,0,0>  - bank to the left
// rotate <-45,0,0> - bank to the right
// rotate <0,0,45>  - climb
// rotate <0,0,-45> - dive

#declare RightWing =
bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
  <0.003130, 3.884194, 0.000000>, <0.001565, 2.694836, 0.000000>, <0.000000, 1.505477, 0.000000>, <-0.001565, 0.128326, 0.000000>, 
  <1.317684, 4.070423, -0.000923>, <2.192488, 3.381847, 0.000000>, <3.192488, 2.693271, 0.000000>, <4.380282, 1.816901, 0.000000>, 
  <2.444444, 4.194053, 0.000000>, <4.133020, 3.818466, 0.000000>, <5.258216, 3.255086, 0.000000>, <8.136150, 2.441315, -1.001565>, 
  <4.823161, 4.568075, 0.000000>, <6.198748, 4.317684, 0.000000>, <9.139280, 3.754304, -0.312989>, <15.397496, 1.500782, -3.067293>
}

#declare LeftWing =
bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
  <-0.003130, 3.884194, 0.000000>, <-0.001565, 2.694836, 0.000000>, <-0.000000, 1.505477, 0.000000>, <0.001565, 0.128326, 0.000000>, 
  <-1.317684, 4.070423, -0.000923>, <-2.192488, 3.381847, 0.000000>, <-3.192488, 2.693271, 0.000000>, <-4.380282, 1.816901, 0.000000>, 
  <-2.444444, 4.194053, 0.000000>, <-4.133020, 3.818466, 0.000000>, <-5.258216, 3.255086, 0.000000>, <-8.136150, 2.441315, -1.001565>, 
  <-4.823161, 4.568075, 0.000000>, <-6.198748, 4.317684, 0.000000>, <-9.139280, 3.754304, -0.312989>, <-15.397496, 1.500782, -3.067293>
}

#declare T_Wings =
texture {
	pigment { rgb <1,1,1> }
}

#declare Wings =
union {
	object { RightWing }
	object { LeftWing }
	scale <0.3,0.3,0.3>
	rotate <-90,0,0>
	rotate <0,-90,0>
	texture { T_Wings }
}

#declare T_Body =
texture {
	pigment { rgb <1,1,1> }
	finish { ambient 0.3 }
}

#declare T_Head =
texture {
	pigment { rgb <1,1,1> }
}

#declare Body =
blob { threshold 0.5
    // body
    sphere { <0,0,0> 1, 1
        scale <2,0.3,0.3>
        translate <1,0,0>
    }
    // head
    sphere { <0,0,0> 1, 1
        scale <0.5,0.15,0.15>
        texture { T_Head }
        rotate <0,0,-30>
        translate <2.2,0.0,0>
    }
    /*
    // right arm
    sphere { <0,0,0> 1, 1
        scale <1.4,0.1,0.1>
        rotate <0,82,0>
        translate <1.32,0,-0.8>
    }
    // left arm
    sphere { <0,0,0> 1, 1
        scale <1.4,0.1,0.1>
        rotate <0,-82,0>
        translate <1.32,0,0.8>
    }
    */
    // right leg
    sphere { <0,0,0> 1, 1
        scale <0.4,0.05,0.05>
        rotate <0,0,15>
        translate <-0.1,-0.1,-0.1>
    }
    // left leg
    sphere { <0,0,0> 1, 1
        scale <0.4,0.05,0.05>
        rotate <0,0,15>
        translate <-0.1,-0.1,0.1>
    }
    texture { T_Body }
}

#declare Eyes =
union {
    sphere { <0,0,0.075> 0.05 }
    sphere { <0,0,-0.075> 0.05 }
    texture {
        pigment { wood
            colour_map {
                [0.0 rgb <0,0,0>]
                [0.1 rgb <0,0,0>]
                [0.15 rgb <0.9,0.8,0.1>]
                [1.0 rgb <0.8,0.7,0.1>]
            }
            scale 0.3
        }
        finish {
            specular 1
            roughness 0.001
        }
    }
    translate <2.3,0,0>
}

#declare FlyingBird =
union {
    object { Wings }
    object { Body }
    object { Eyes }
}