///////////////////////////////////////////////////////////////////////////////////////
//
// EMAIL: douge@nls.net
// NAME: Douglas Eichenberg
// TOPIC: The Wilderness
// COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING
//            COMPETITION COPYRIGHT.
// TITLE: Gila
// COUNTRY: USA
// WEBPAGE: www.getinfo.net/douge
// RENDERER USED: POVRay v3.1, MegaPOV 0.5
// TOOLS USED: Moray v3.2, NuGraf/PolyTrans v2.2j, Paint Shop Pro v6.02,
//             MakeTree.pov by Gilles Tran, TrueSpace v4 
// RENDER TIME: 47m 6s 
// HARDWARE USED: 600 MHz PIII/Windows 2000/128Mb
// 
// IMAGE DESCRIPTION: The Sonoran Desert of Arizona, with native flora and fauna.
//                    The scene depicts a Gila monster hunting for eggs.
//
//                    GILA MONSTER:
//                    There are only two known venomous lizards: the Gila Monster
//                    (pictured here) and a close relative, the Mexican Beaded Lizard.
//                    Both live in the Sonoran Desert.  Both lizards are of the same
//                    genus, which dates back 30 million years to the Oligocene epoch
//                    (a period of time between the dinosaurs and man).  Over this
//                    30 million year span of time, the Gila Monster has not evolved
//                    in any way; a skeleton from 30 million years ago is identical
//                    to one from the present day.  Perhaps one of the most survivable
//                    creatures, the Gila Monster is able to live up to three years
//                    without food in one of the harshest environments on the planet.
//                    They live largely on the eggs of other desert animals, especially
//                    ground nesting birds (which are quite common in the desert).
//                    The Gila monster's sense of smell is so keen that it can smell
//                    a single egg buried six inches beneath the surface.
//
//                    OCOTILLO:
//                    In order for a tree or bush to survive in the desert, there
//                    have to be some ingenious survival techniques.  The ocotillo
//                    reduces it's exposure to harsh sunlight by shedding it's leaves
//                    when it gets to be too dry (as many as six or eight times per
//                    year).  In a place where not even weeds can grow, the ocotillo
//                    does pretty well. 
//
//                    THE SOTOL PLANT:
//                    I couldn't find anything interesting to say about this plant,
//                    except that the Pima Indians used it for weaving because it
//                    has such strong fibers.
//
//                    ROCKS:
//                    In scientific terminology these are called, um, rocks. 
//                  
//
// DESCRIPTION OF HOW THIS IMAGE WAS CREATED:
//                    
//                    The cracked desert floor is a height field created in POV with
//                    Moray and converted into a tileable bump map.  The beauty
//                    of it is that you can't tell it's tiled unless you're looking
//                    for it.  The bump map image is a gray scale TGA.  To get the color
//                    you see I applied a semi-transparent crackle-patterned colormap over
//                    top of the bump map.  
//
//                    The rocks came from a macro I wrote based on Jaime Vives Piqueres
//                    code for his image 'running' in the September/October '99 round
//                    of the IRTC (one of my all-time favorite POV images... I use it
//                    as my Windows backdrop).  The plants are also based on code from
//                    Jaime's image.  Each plant and rock was individually placed (ie.,
//                    the placement is not random). 
//
//                    The tree is a modified Gilles Tran tree, created with his 
//                    MakeTree.pov code.  By increasing the initial number of branch
//                    segments and creating a push vector in the +y direction, I was
//                    able to create something that looked reasonably like a desert 
//                    bush.  
//
//                    I came up with a neat trick for lighting the scene.  First I
//                    created a simple overhead area light parallel to the ground
//                    plane, making it shadowless.  I was then able to tweak this light
//                    to adjust the brightness. Then I added another area light, tilted at 
//                    an angle, to cast some nice soft shadows.  At that point I was
//                    unhappy with the overall effect; the dark areas were *too* dark,
//                    and a lot of the scene just wasn't getting enough light.  I've
//                    never liked to depend on ambience because I don't like the
//                    way it looks, so what I did instead was create a large hollow
//                    sphere and make a shadowless point light, attaching the 'looks_like'
//                    keyword to it.  That gave me a large spherical light all around
//                    the scene, casting light into all the little areas that were 
//                    otherwise missed.  It's basically a nicer version of ambient light.
//                    Moving the sphere around has some interesting and subtle effects.
//                    Also, on the area lights I turned adaptive up to 3 to smooth out
//                    the shadows.   
//
//                    Originally, the scene was coded and rendered with version 3.1.
//                    I decided at the last minute to add a motion blur effect to the
//                    tongue, so I ported the code to MegaPOV 0.5.  This had a strange
//                    effect on the bump maps and other bumps, so I added the '#version
//                    official 3.1;' line at the end of all the files.  I also had to
//                    tweak the following settings for the finish on the lizard: ambient,
//                    diffuse and specular.  The resulting leopard surface normal looks
//                    much nicer in MegaPOV than it did in version 3.1.  Technically, 
//                    this shouldn't happen: according to the MegaPOV docs, adding the
//                    '#version official 3.1;' line to the end of all the files will
//                    cause normals to be done by 3.1 methods.  Another weird MegaPOV
//                    thing: when the scene is rendered it generates a warning saying
//                    'Camera is inside a non-hollow object.' (which isn't true). 
//                                                                         
//                    The lizard was modelled in TrueSpace and converted to a mesh of
//                    smooth triangles with NuGraf/PolyTrans (12.6 meg file).  The orange 
//                    and black pattern on the lizards skin is an image map with a leopard 
//                    surface normal for scales.  I tried some other patterns for the
//                    normal, but none of them looked quite right. 
//
//                    The include files and image maps have been left out because they're
//                    just too big, but I'll be happy to give a complete copy to anybody
//                    who wants one.
//
///////////////////////////////////////////////////////////////////////////////////////
#version unofficial megapov 0.5;
default {                         // used for test rendering      
  texture {
    pigment { rgb <1,0,0> }
  }
}


global_settings {   
  motion_blur 5,0.06
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

#declare r_stone=seed(31);       // 3,4,6,7,8,9,10 (other good seed values)
#declare r_stone1=seed(4);
#declare r_stone2=seed(9); 
#declare r_stone3=seed(87);
#declare r_stone4=seed(375); 
#declare r_stone5=seed(467);
background { color <0.000,0.000,0.000> }

camera {  
//  location  <     -4.241,     -11.284,       7.422>  
location  <     -4.241,     -11.284,       7.422>
  direction <        0.0,         0.0,      2.4880> 
  sky       <    0.00000,     0.00000,     1.00000>  
  up        <        0.0,         0.0,         1.0> 
  right     <    1.33333,         0.0,         0.0> 
  look_at   <     -0.806,      -1.319,       0.431>
}

#declare skysphere = sphere { <0,0,0>,50 hollow }       // A hollow sphere to use as a light source
#declare egg = object { sphere {<0,0,0>,1} scale <1.25,1.25,1>}
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//                               LIGHTS                                    //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

///////////////////////////////////
//
//      This one casts the shadows
//
///////////////////////////////////
light_source { 
  <63.241, -0.354, 37.648>
  color rgb <1.000, 1.000, 1.000>*1.8   //0.15        
  area_light <40.692, 0.000, -74.100>, <0.000, 84.538, 0.000>, 5, 5
  adaptive 3
  jitter
  //shadowless
}
//light_source {                                adding this point light will give hard shadows,
//    <40.241, -10, 46.648>*1000                but increases rendering time to 15 hours!
//    color rgb <1,1,1>*1.1
//    }        
////////////////////////////////////////////
//
//      This one lights up the ground...    
//
////////////////////////////////////////////
light_source { 
  <0,0, 50>
  color rgb <1.000, 1.000, 1.000>*1       
  area_light <50, 50, 0>, <-50, -50, 0.000>, 5, 5
  adaptive 3
  jitter 
  shadowless 
}        
///////////////////////////////////////////////
//
//      This one adds light to vertical faces 
//      (much nicer than using ambient) 
//
///////////////////////////////////////////////
light_source {
  <-10,-10,0>
  color rgb <1,1,1>*1
  shadowless
  looks_like {skysphere}
}

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//                                INCLUDES                                 //
//                                                                         //
///////////////////////////////////////////////////////////////////////////// 
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "Stonemaker.inc" 
#include "i_textur.inc"  
#include "i_plants.inc"  
#include "desertree.pov"

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//                                MATERIALS                                //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

 #declare t_stone=
 texture{
  T_Grnt14
  normal{granite}
  scale .3
  scale 6
 }
 texture{
  pigment{
   gradient y
   color_map{
    [0.0 Clear]
    [0.9 Gold filter 0.5]
    [1.0 DarkTan filter 0.75]
   }
  }
  normal{granite scale .3*6/3.5}
  scale 3.5
 }

#declare sand = 
   material  
   {   
      texture
      {      
         pigment
         {
            granite
            color_map
            {
               [ 0.0     rgbft <0.86, 0.82, 0.67, 0.0, 0.0> ]
               [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            }
         }      
         normal
         {
            crackle , 0.5
            ramp_wave
         }      
         finish
         {
            ambient 0.1
         }
      }
   }


#declare _auto_name_no_1_ = 
   texture 
   {   
      pigment
      {
         granite
         color_map
         {
            [ 0.0     rgbft <0.86, 0.82, 0.67, 0.0, 0.0> ]
            [ 0.5     rgbft <0.91, 0.87, 0.71, 0.0, 0.0> ]
            [ 1.0     rgbft <0.86, 0.84, 0.59, 0.0, 0.0> ]
         }
         turbulence 0.7
         ramp_wave
      }   
      finish
      {
         ambient 0.5
         diffuse 1.0
         specular 0.5
         roughness 0.01
         crand 0.25
      }
   }
   texture  
   {   
      pigment
      {
         color rgbf <1.0, 1.0, 1.0, 1.0>
      }   
      finish
      {
         ambient 0.187033
         brilliance 0.977333
         phong 0.057533
         phong_size 40.396667
         specular 0.187033
      }
   }

#declare SandstP = 
   material  
   {   
      texture { _auto_name_no_1_ }
   }


#declare M1 = 
      texture
      {      
         pigment
         {
            image_map
            {
                sys   "C:\Documents and Settings\All Users\Desktop\Gila\drymud5.bmp" 
            } 
            scale 3
         }      
         normal
         {
            bump_map
            {
               tga   "C:\Documents and Settings\All Users\Desktop\GILA\MUD3R.tga"
            } 
            bump_size 1.5       
            scale  3.0  
          }      
         finish { ambient 0.05 specular 0.05 roughness 0.005} 
      }
      texture
      {
         pigment 
         {
            crackle
            color_map
            {
               [ 0.0     rgbt <0.815686, 0.745098, 0.458824, 0.7> ]
               [ 1.0     rgbt <0.996078, 0.843137, 0.478431, 0.7> ]
            }
            turbulence 0.3
            ramp_wave
        }
      }
#declare Material1 = 
  material { texture { M1 } }

//////////////////////////////////////////////
// 
//      Scene objects
//
//////////////////////////////////////////////

#include "C:\Documents and Settings\All Users\Desktop\GILA\gilamon.pov"
//#include "C:\Documents and Settings\All Users\Desktop\GILA\cactus.pov" 

plane { 
  z,0
  material {
    Material1 
  }                   
  rotate <0,180,0>
  translate <0,0,-.1> 
}

/////////////////////////////////////////////////////////////
//
//      Clump of rocks and plants (unioned for easy movement)
//
/////////////////////////////////////////////////////////////
union {  
        object{
                Stone(r_stone, 0.9)
                rotate <360*rand(r_stone),360*rand(r_stone),360*rand(r_stone)>
                 scale <.1+rand(r_stone)*.1,.1+rand(r_stone)*.1,.1+rand(r_stone)*.1>
                 translate <-5.5,6,.23> 
                 scale 0.6
                 texture{t_stone scale 1}
              }    
        object{
                Stone(r_stone1, 0.9)
                rotate <360*rand(r_stone),360*rand(r_stone),360*rand(r_stone)> 
                rotate <40,0,0>
                scale <.1+rand(r_stone)*.1,.1+rand(r_stone)*.1,.1+rand(r_stone)*.1>
                translate <-1.7,3.1,.23> 
                scale <.8,.8,.5>*2 //0.8
                texture{t_stone scale 1} //0.8
              }

        object{
                Stone(r_stone2, 0.9)
                rotate <360*rand(r_stone),360*rand(r_stone),360*rand(r_stone)>
                 scale <.1+rand(r_stone)*.1,.1+rand(r_stone)*.1,.1+rand(r_stone)*.1>
                 translate <-2,3.2,.23> 
                 scale <1.35,1.2,1.2>
                 texture{t_stone scale 1}
              }  
   
        object{ plant
                 scale .06
                 rotate 360*rand(r_plant)*y
                 rotate <90,0,0>
                 translate <-4,3.5,-.07>
             }

        object{ plant
                scale .09
                 rotate 360*rand(r_plant)*y
                 rotate <90,0,0>
                 translate <-1.8,-1.95,-.1> //translate <-1.75,-1.85,-.1>
              }   

       object{ plant
                scale .075
                 rotate 360*rand(r_plant)*y
                 rotate <90,0,0>
                 translate <0.45,-0.2,-.1>
              }   
                                                
        object{ plant
                scale .09
                 rotate 360*rand(r_plant)*y
                 rotate <90,0,0>
                 translate <-3.7,5.35,-.07>
              }    
                         
       object{ plant
                scale .11
                 rotate 360*rand(r_plant)*y
                 rotate <90,0,0>
                 translate <-1.8,6,-.07>
              }    
                                
       object{ plant
                scale .11
                 rotate 360*rand(r_plant)*y
                 rotate <90,0,0>
                 translate <0.3,6.6,-.07>
              }                       
        translate <1,-2.5,0>
        scale 1.2
}    

object{
        MakeTree()
        texture {txtTree} 
        scale .25
        rotate <90,0,0>
        translate <-2.4,4,-.1> 
}         
        object{
                Stone(r_stone3, 0.9)
                rotate <360*rand(r_stone),360*rand(r_stone),360*rand(r_stone)>
                 scale <.1+rand(r_stone)*.1,.1+rand(r_stone)*.1,.1+rand(r_stone)*.1>
                 translate <.35,.15,2.2> 
                 scale 2.2  
                 rotate <90,0,0>
                 texture{t_stone scale 1}
              } 
                
        object{
                Stone(r_stone4, 0.9)
                rotate <360*rand(r_stone),360*rand(r_stone),360*rand(r_stone)> 
                rotate <0,90,0>
                 scale <.1+rand(r_stone)*.1,.1+rand(r_stone)*.1,.1+rand(r_stone)*.1>
                 translate <0.48,3.9,.21> 
                 //scale 1 
                 texture{t_stone scale 1}
              }  
                   
        object{
                Stone(r_stone5, 0.9)
                rotate <360*rand(r_stone),360*rand(r_stone),360*rand(r_stone)> 
                rotate <0,90,0>
                 scale <.1+rand(r_stone)*.1,.1+rand(r_stone)*.1,.1+rand(r_stone)*.1>
                 translate <.2,8.7,.23> 
                 scale 0.55 
                 texture{t_stone scale 1}
              }  
        object{ egg
                pigment { rgb <.8,.8,.8>}
                scale .12
                translate <-3.05,2.5,.05>
              }             
        object{ egg
                pigment { rgb <.8,.8,.8>}
                scale .12 
                rotate <0,0,30>
                translate <-2.8,2.4,.05>
              }           
        object{ egg
                pigment { rgb <.8,.8,.8>}
                scale .12 
                rotate <0,0,-30>
                translate <-3.1,2.0,.05>
              }                          
#version official 3.1;                           